<?php
!defined('P_W') && exit('Forbidden');
class Array2Xml {
    var $xml;
	
    function Array2Xml($array, $encoding = 'utf-8') {
		$this->xml = '<?xml version="1.0" encoding="' . $encoding . '"?>';
        $this->xml .= $this->_array2xml($array);
    }
	
    function getXml() {
        return $this->xml;
    }
		
    function _array2xml($array){
        $xmlStr = '';
		foreach($array as $key => $val) {
			if (preg_match("/^\d.*/",$key)){
			    $key = 'item';
			}
			
            $xmlStr .= "<$key>";
            $xmlStr .= is_array($val) ? $this->_array2xml($val) : $this->_xmlEscape($val);
            $xmlStr.="</$key>";
        }
        return $xmlStr;
    }
	
	function _xmlEscape($str){
		$search = array('&', '<', '>', '"', '\'');
        $replace = array('&amp;', '&lt;', '&gt;', '&quot;', '&apos;');
        return str_replace($search, $replace, $str);
	}
}