<?php
!defined('P_W') && exit('Forbidden');

class Openim_WeiboApi extends BaseApi
{

	var $methodsType = array(
		'getlist' => 'POST',
	);

	/**
	 * ȡб
	 * @param string $userName û
	 * @param int $page ҳ
	 * @param int $pageNum ÿҳ
	 * @return array
	 */
	function getlist($userName, $page = 1, $pageNum = 20)
	{
		if (empty($userName)) return false;

		$userService = L::loadClass('UserService', 'user');
		$userInfo = $userService->getByUserName($userName, true, true);
		if (empty($userInfo)) return false;

		//@xxxӴ
		global $db_htmifopen, $db_userurlopen, $db_bbsurl;
		$userurl = ($db_htmifopen && $db_userurlopen) ? 'u/' : 'u.php?uid='; //url
		//TODO: ӦôService֡ʹþԵַ
		$siteBaseUrl = rtrim($db_bbsurl, '/') . '/';
		define('USER_URL', $siteBaseUrl . $userurl);
		
		$weibo = L::loadClass('weibo', 'sns');
		$weiboList = $weibo->getUserWeibos($userInfo['uid'], $page, $pageNum);
		if (empty($weiboList)) return array();
		
		$list = array();
		foreach ($weiboList as $item) {
			$newItem = $this->_parseWeiboData($item, $siteBaseUrl, true);
			$list[] = $newItem;
		}
		return $list;
	}
	
	/**
	 * 
	 * @param array $item 
	 * @param string $siteBaseUrl վַ
	 * @param bool $parseRepost Ƿת
	 * @return array array(
	 * 	'weiboId' => int id
	 * 	'userId' => int ûid
	 * 	'timestamp' => int ʱ
	 * 	'content' => string ģΪhtml
	 * 	'url' => string ݶӦַ
	 * 	'typeName' => string ƣܵΪ
	 * 		'weibo' => '',
	 * 		'transmit' => 'ת',
	 * 		'sendweibo' => '͵',
	 * 		'honor' => 'ǩ',
	 * 		'article' => '',
	 * 		'diary' => '־',
	 * 		'photos' => '',
	 * 		'group_article' => 'Ⱥ黰',
	 * 		'group_photos' => 'Ⱥ',
	 * 		'group_active' => 'Ⱥ',
	 * 		'group_write' => 'Ⱥ¼',
	 * 		'sinaweibo' => '΢',
	 * 		'cms' => ''
	 * 	'extra' => array ¶ӦݣܵΪ
	 * 		'title' => string HTMLӦݵı
	 * 		'photos' => array(array('url' => string ͼƬ1ԵַURL), array('url' => string ͼƬ2ԵַURL))
	 * 		'sinaPhotos' => array(array('thumb' => string ͼURL, 'middle' => string ͼURL, 'original' => string ԭʼͼURL));
	 * 	'repost' => array ת΢
	 * )
	 * 
	 */
	function _parseWeiboData($item, $siteBaseUrl, $parseRepost = false)
	{
		$siteBaseUrl = trim($siteBaseUrl, '/') . '/';
		
		//ƵƵ
		$item['content'] = preg_replace('/<span><img.*onclick=\"mediaPlayer\.showMusic\(.*\)\".*\/><\/span>/i', '[]', $item['content']);
		$item['content'] = preg_replace('/<img.*\/><a.*onclick=\"mediaPlayer\.showVideo\(.*\).*\">.*<\/a>/i', '[Ƶ]', $item['content']);
		//TODO: ӦôService֡ʹþԵַ
		$item['content'] = str_replace('<a href="apps.php?q=weibo&do=topics&topic=', '<a href="' . $siteBaseUrl . 'apps.php?q=weibo&do=topics&topic=', $item['content']);
		if ($item['type'] == '42') { //޸汾ȺXSS bug
			$item['extra']['title'] = htmlspecialchars($item['extra']['title'], ENT_QUOTES);
		}
		
		$userId = (int)$item['uid'];
		
		//΢Ӧ
		$url = '';
		if ($item['type'] == 10) {
			$url = $siteBaseUrl . "read.php?tid={$item['objectid']}";
		} elseif($item['type'] == 3) {
			$url = $siteBaseUrl . "mode.php?m=cms&q=view&id={$item['objectid']}";
		} elseif ($item['type'] == 20) {
			$url = $siteBaseUrl . "apps.php?q=diary&a=detail&did={$item['objectid']}&uid={$userId}";
		} elseif ($item['type'] == 40 && isset($item['extra']['cyid'])) {
			$url = $siteBaseUrl . "apps.php?q=group&a=read&cyid={$item['extra']['cyid']}&tid={$item['objectid']}";
		} elseif ($item['type'] == 42 && isset($item['extra']['cyid'])) {
			$url = $siteBaseUrl . "apps.php?q=group&a=active&job=view&cyid={$item['extra']['cyid']}&id={$item['objectid']}";
		} elseif ($item['contenttype'] == 1) {
			$url = $siteBaseUrl . "apps.php?q=weibo&uid={$userId}";
		}
		$weibo = L::loadClass('weibo', 'sns');
		$typeName = $weibo->getType($item['type']);
		
		$extra = array();
		if (isset($item['extra']) && isset($item['extra']['title'])) {
			$extra['title'] = $item['extra']['title'];
		}
		if (isset($item['extra']) && isset($item['extra']['photos']) && is_array($item['extra']['photos'])) {
			$newPhotos = array();
			foreach ($item['extra']['photos'] as $photo) {
				$newPhoto = array();
				$return = geturl($photo['path']);
				if ($return && $return[1] == 'Local') {
					$newPhoto['url'] = strpos($siteBaseUrl, $return[0]) === 0 ? $return[0] : $siteBaseUrl . $return[0];
					$newPhotos[] = $newPhoto;
				} elseif ($return && $return[1] == 'Ftp') {
					$newPhoto['url'] = $return[0];
					$newPhotos[] = $newPhoto;
				}
			}
			$extra['photos'] = $newPhotos;
		}
		if (isset($item['extra']) && isset($item['extra']['sinaPhotos']) && is_array($item['extra']['sinaPhotos'])) {
			$extra['sinaPhotos'] = $item['extra']['sinaPhotos'];
		}
		
		if (isset($item['transmits']) && $item['transmits'] && $parseRepost) {
			$repost = $this->_parseWeiboData($item['transmits'], $siteBaseUrl, false);
		} else {
			$repost = array();
		}
		
		$weiboId = (int)$item['mid'];
		$timestamp = (int)$item['postdate'];
		
		return array(
			'weiboId' => $weiboId,
			'userId' => $userId,
			'timestamp' => $timestamp,
			'content' => $item['content'],
			'url' => $url,
			'typeName' => $typeName,
			'extra' => $extra,
			'repost' => $repost
		);
	}
}