<?php
!defined('P_W') && exit('Forbidden');

define('OPENIM_USER_INVALID_PARAMS',201);
class Openim_UserApi extends BaseApi {
	/**
	 * סtokenҪֵ
	 * @var string
	 */
	var $_salt;
	var $methodsType = array(
			'checkpassword' => 'GET',
			'checktoken' => 'GET'
		);
		
	function init() {
		$this->_salt = $this->openApi->apikey;
	}
	
	/**
	 * û룬ڼסtoken
	 * @param string $userCode ûϢΪencryptStringܵjson飬Ϊarray('username' => 'foo', 'password' => 'bar')
	 * @return int|array ʧܷ-1array('errCode' => int, 'errMessage' => 'foo')ɹarray('token' => 'foo')
	 */
	function checkpassword($userCode){
      $userCode = $this->_stripSlashes($userCode);
      if (trim($userCode) == ''){
         return $this->errMessage(OPENIM_USER_INVALID_PARAMS, 'invalid params');
      }
      //
      $userCodeInfo = encryptString($userCode,false);
      
      $json = new Services_JSON(true);
      $userCodeInfo = (array)$json->decode($userCodeInfo, false);
      $userCodeInfo = pwConvert($userCodeInfo, $this->openApi->charset, 'UTF-8');

      $windid = $userCodeInfo['username'];
      $windpwd = $userCodeInfo['password'];

      //
      if (empty($windid) || empty($windpwd)){
         return $this->errMessage(OPENIM_USER_INVALID_PARAMS, 'invalid params');
      }
      
      $userService = $this->_getUserService();
      $userInfo = $userService->getByUserName($windid);

      //ûǷ 
      if (!$userInfo) {
          return -2;
      }
      
      //ûǷȷ 
      if ($userInfo['password'] && $this->_plaintextToDb($windpwd) == $userInfo['password']){
         $userId = $userInfo['uid'];
         //ǵһʹ÷񣬷
         $this->_postNewWeiboIfNeverUsedService($userId);
         //ǵһʹ÷񣬼¼ûѿͨ״̬ 
         $this->_setHasUsedOpenImService($userId);
         //ؼסõToken
         return array('token' => encryptString($this->_encodeToken($userInfo['password'])));
      }
      
      return -3;
   }

	function _stripSlashes($variable){
	    if (is_array($variable)) {
	        foreach ($variable as $key => $value) {
	        	$variable[$key] = $this->stripSlashes($value);
	        }
	        return $variable;
	    } else {
			return stripslashes($variable);
		}
	}
	/**
	 * ûסtokenڼסtoken
	 * @param string $userCode ûϢΪencryptStringܵjson飬Ϊarray('username' => 'foo', 'token' => 'bar')
	 * @return int|array ʧܷ-1array('errCode' => int, 'errMessage' => 'foo')ɹarray('token' => 'foo')
	 */
   function checktoken($userCode) {
      if (trim($userCode) == '') {
         return $this->errMessage(OPENIM_USER_INVALID_PARAMS, 'invalid params');
      }
      
      $userCodeInfo = encryptString($userCode,false);

      $json = new Services_JSON(true);
      $userCodeInfo = (array)$json->decode($userCodeInfo, false);
      $userCodeInfo = pwConvert($userCodeInfo, $this->openApi->charset, 'UTF-8');
      
      $windid = $userCodeInfo['username'];
      $token = $userCodeInfo['token'];
      if (empty($windid) || empty($token)){
         return $this->errMessage(OPENIM_USER_INVALID_PARAMS, 'invalid params');
      }
      
      $userService = $this->_getUserService();
      $userInfo = $userService->getByUserName($windid);

      if (!$userInfo) {
          return -1;
      }
      
      if ($userInfo['password'] && $this->_encodeToken($userInfo['password']) == $token) {
         $userId = $userInfo['uid'];
         $this->_postNewWeiboIfNeverUsedService($userId);
         $this->_setHasUsedOpenImService($userId);
         return array('token' => encryptString($token));
      }
      
      return -1;
   }
   
   function _setHasUsedOpenImService($userId) {
       $openImUserService = L::loadClass('OpenImUser', 'openim');
       $openImUserService->setHasUsedService($userId);
   }
   
   function _postNewWeiboIfNeverUsedService($userId) {
      $openImUserService = L::loadClass('OpenImUser', 'openim');
      if ($openImUserService->hasUsedService($userId)) {
         return -1;
      }
      $userService = $this->_getUserService();
      $userInfo = $userService->get($userId);
      if (!$userInfo) {
         return -2;
      }
      $groupId = $userInfo['groupid'];
      $groupId == '-1' && $groupId = $userInfo['memberid'];
	  global $db_bbsurl;
      $weiboContent = $userInfo['username'] . 'ص磺ҳɹ¼Ŀͻˣұ ' . rtrim($db_bbsurl, '/') . '/yunliao.php';

      $weiboService = L::loadClass('weibo','sns');
      if (($return = $weiboService->sendCheck($weiboContent, $groupId)) !== true) {
         return -3; //failure in posting new weibo
      }
      if ($weiboService->send($userId, $weiboContent)) {
         return true;
      }
      return -4;
   }
   
	/**
	 * @return PW_UserService
	 */
	function _getUserService(){
		return L::loadClass('UserService', 'user');
	}
	
	/**
	 * ûסtoken
	 * @param string $passwordInDb ݿм¼
	 * @return string
	 */
	function _encodeToken($passwordInDb) {
		return sha1($passwordInDb . $this->_salt);
	}
	
	/**
	 * ȡݿе
	 * @param string $password
	 * @return string
	 */
	function _plaintextToDb($password) {
		return md5($password);
	}
}