<?php
!defined('P_W') && exit('Forbidden');
define('MESSAGE_INVALID_PARAMS',601);
define('MESSAGE_SENDER_DOES_NOT_EXIST',-511);
define('MESSAGE_INVALID_RELATION_ID',-602);

class Openim_SendMessageApi extends BaseApi {
	var $methodsType = array(
		'sendbyusername' => 'POST',
		'replybyusername' => 'POST',
		'deletemessagebyuseridandmessageid' => 'GET'
	);
    
    /**
     * վ
     * @param string $senderUsername
     * @param string $receiverUsername
     * @param string $title
     * @param string $content
     * @return array
     */
    function sendbyusername($senderUsername, $receiverUsername, $title, $content) {
    	global $db_openim_notSyncNewPmToPlatform;
    	$db_openim_notSyncNewPmToPlatform = true;
    	
    	$senderUsername = (string)$senderUsername;
    	$receiverUsername = (string)$receiverUsername;
    	$title = (string)$title;
    	$content = (string)$content;

    	//
    	if (!$senderUsername || !$receiverUsername || !$content || !$title) {
    		return $this->errMessage(MESSAGE_INVALID_PARAMS, 'invalid params');
    	}
    	
    	//ûǷ
    	$userInfo = $this->_getUserInfoByUsername($senderUsername);
    	if (!$userInfo) {
    		return $this->errMessage(MESSAGE_SENDER_DOES_NOT_EXIST, 'sender not found');
    	}
		$openImMessageService = $this->_getOpenImMessageService();

		$result = $openImMessageService->getSendMessageResult(
			$userInfo['uid'],
			array($receiverUsername),
			array(
				'create_uid' => $userInfo['uid'], 
				'create_username' => $userInfo['username'], 
				'title' => $title ? Char_cv($title) : $title, 
				'content' => Char_cv($content)
			)
		);
		if (is_a($result, 'PW_Service_MessageException')) {
			return array('errCode' => $result->getCode(), 'errMessage' => $result->getMessage(), 'errdata' => $result->getData());
		} elseif (isException($result)) {
			return $this->errMessage($result->getCode(), $result->getMessage());
		}
		return array('messageId' => $result);
    }
    
    /**
     * ظվ
     * @param string $senderUsername
     * @param int $relationId
     * @param string $content
     * @return array
     */
    function replybyusername($senderUsername, $relationId, $content) {
    	global $db_openim_notSyncNewPmToPlatform;
    	$db_openim_notSyncNewPmToPlatform = true;
    	
    	$senderUsername = (string)$senderUsername;
    	$relationId = (int)$relationId;
    	$content = (string)$content;
    	
        //
    	if (!$senderUsername || $relationId < 1 || !$content) {
    		return $this->errMessage(MESSAGE_INVALID_PARAMS, 'invalid params');
    	}
    	
        //ûǷ
    	$userInfo = $this->_getUserInfoByUsername($senderUsername);
    	if (!$userInfo) {
    		return $this->errMessage(MESSAGE_SENDER_DOES_NOT_EXIST, 'sender not found');
    	}
    	
    	$openImMessageService = $this->_getOpenImMessageService();
    	$relation = $openImMessageService->getRelation($userInfo['uid'], $relationId);
    	if (!$relation) {
    		return $this->errMessage(MESSAGE_INVALID_RELATION_ID, 'invalid relation id');
    	}
    	
    	$result = $openImMessageService->getSendReplyResult(
    		$userInfo['uid'],
    		$relationId,
    		$relation['mid'], 
    		array(
				'create_uid' => $userInfo['uid'], 
				'create_username' => $userInfo['username'], 
				'title' => Char_cv($userInfo['username']), //Ϊ 
				'content' => Char_cv($content)
			)
		);
    	if (is_a($result, 'PW_Service_MessageException')) {
			return array('errCode' => $result->getCode(), 'errMessage' => $result->getMessage(), 'errdata' => $result->getData());
		} elseif (isException($result)) {
			return $this->errMessage($result->getCode(), $result->getMessage());
		}
		$openImMessageService->readMessages($userInfo['uid'], $relation['mid']);
		return array('messageId' => $result);
    }
    
    /**
     * ɾվ
     * @param int $uid ûID
     * @param int $mid ϢID
     * @return array
     */
    function deletemessagebyuseridandmessageid($uid, $mid) {
    	if (intval($uid) < 1 || intval($mid) < 1) {
    	    return $this->errMessage(MESSAGE_INVALID_PARAMS, 'invalid params');
    	}
    	
    	$openImMessageService = $this->_getOpenImMessageService();
    	$result = $openImMessageService->deleteMessageByUserIdAndMessageId($uid, $mid);

    	return array('success' => $result === true ? 1 : 0);
    }
    
    function _getUserInfoByUsername($username) {
		$userService = L::loadClass('UserService', 'user');
		return $userService->getByUserName($username);
    }
    
    function _getOpenImMessageService() {
		return L::loadClass('OpenImMessage', 'message');
    }
}