<?php

!defined('P_W') && exit('Forbidden');

define('MESSAGE_INVALID_PARAMS', 601);

class Openim_MessageApi extends BaseApi {

    var $methodsType = array(
    	'getlist' => 'GET',
    	'getone' => 'GET',
    	'ismessageboxfull' => 'GET'
    );

    /**
     * typeȡһб
     * @param int $userid
     * @param string $type
     * @param int $limit
     * @param null|int $beforeTimestamp Ϊnull½Ϊint޸ʱʱǰĽ
     * @return array
     */
    function getlist($userid, $type, $limit = 12, $beforeTimestamp = null) {
        $type = ucfirst(strtolower($type));
        //֧:,ռ,ϵͳ֪ͨ,ѷϢ
        $_type = array('All', 'Pm', 'Notice', 'Outbox');
        $userid = (int)$userid;
        $limit = (int)$limit;
        $beforeTimestamp = $beforeTimestamp ? (int)$beforeTimestamp : null;
        
        if ($userid < 1 || $limit < 1 || $limit > 10000 || (!is_null($beforeTimestamp) && $beforeTimestamp < 0) || !in_array($type, $_type)) {
            return $this->errMessage(MESSAGE_INVALID_PARAMS, 'invalid params');
        }
        $action = '_getList' . $type;
        $messages = $this->{$action}($userid, $limit, $beforeTimestamp);
        return array('messages' => $messages);
    }

    function _getListAll($userid, $limit = 12, $beforeTimestamp = null) {
    	return $this->_getListInbox($userid, 'all', $limit, $beforeTimestamp);
    }

    function _getListNotice($userid, $limit = 12, $beforeTimestamp = null) {
		return $this->_getListInbox($userid, 'notice', $limit, $beforeTimestamp);
    }
    
    function _getListPm($userid, $limit = 12, $beforeTimestamp = null) {
		return $this->_getListInbox($userid, 'pm', $limit, $beforeTimestamp);
    }

    /**
     * 
     * @param int $userid
     * @param int $limit
     * @param int $beforeTimestamp
     * @return array
     */
    function _getListOutbox($userid, $limit = 12, $beforeTimestamp = null, $offset = null) {
        $db = $this->db;
        $beforeTimestamp = is_null($beforeTimestamp) ? null : (int)$beforeTimestamp;
        $offset = is_null($offset) ? null : (int)$offset;
        $limit = (int)$limit;
        
        //get sender info
        $sender = $this->_getMessageRelatedUserInfoByUserId($userid);
        if ($sender === false) {
        	return array();
        }
        //msg info
        $messageDb = $db->query('SELECT mid, title, created_time, modified_time, extra FROM pw_ms_messages WHERE create_uid = ' . S::sqlEscape($userid) . ($beforeTimestamp > 0 ? ' AND modified_time < ' . S::sqlEscape($beforeTimestamp) : '') . ' ORDER BY modified_time DESC LIMIT ' . ($offset ? (int)$offset . ', ' : '') . (int)$limit);
        $messageContents = $receiverUsernames = $mids = array();
        while($rt = $db->fetch_array($messageDb)) {
        	$mids[] = $rt['mid'];
        	$messageContents[$rt['mid']] = 
        		array(
        			'mid' => (int)$rt['mid'],
        			'subject' => $this->_htmlEntityDecode($rt['title']),
        			'createdTimestamp' => (int)$rt['created_time'],
        			'lastModifiedTimestamp' => (int)$rt['modified_time'],
        		);
        	$msgInfo = $db->get_one('SELECT content FROM pw_ms_replies WHERE parentid = ' . S::sqlEscape($rt['mid']) . ' ORDER BY modified_time DESC');
        	if (!$msgInfo) {
        		unset($messageContents[$rt['mid']]);
        		continue;
        	}
        	$thisReceiverUsernames = unserialize($rt['extra']);
        	if (!$thisReceiverUsernames || !is_array($thisReceiverUsernames)) {
        		unset($messageContents[$rt['mid']]);
        		continue;
        	}
        	//1ûΪ
        	$receiverUsername = $thisReceiverUsernames[0];
        	if (!$receiverUsername) {
        		continue;
        	}
        	$senderInfo = $db->get_one('SELECT uid FROM pw_ms_relations WHERE uid = ' . S::sqlEscape($userid) . ' AND mid = ' . S::sqlEscape($rt['mid']) . ' AND categoryid=1');
        	if (!$senderInfo) {
        		unset($messageContents[$rt['mid']]);
        		continue;
        	}
        	$messageContents[$rt['mid']]['content'] = $this->_getHtmlFromWindCode($msgInfo['content']);
        	$receiverUsernames[$rt['mid']] = $receiverUsername;
        }
        if (empty($mids)) {
        	return array();
        }
        
        $messages = array();
        //return empty array if no messages found
        if (!empty($messageContents)) {
	        $newSiteUserInfos = array();
	        if (count($receiverUsernames)) {
	        	$userService = $this->_getUserService();
	        	$siteUserInfos = $userService->getByUserNames($receiverUsernames);
	
	        	if (is_array($siteUserInfos) && !empty($siteUserInfos)) {
	        		foreach($siteUserInfos as $siteUserInfo) {
	        			$newSiteUserInfos[$siteUserInfo['username']] = $siteUserInfo;
	        		}
	        	}
	        }
	        unset($siteUserInfos);
	
	        //շص
	        foreach($messageContents as $mid => $content) {
	        	$content['receiver'] = 
	        		isset($newSiteUserInfos[$receiverUsernames[$mid]]) ? 
	        		$this->_getMessageRelatedUserInfo($newSiteUserInfos[$receiverUsernames[$mid]]) : 
	        		array(
	        			'uid' => 0
	        		);
	        	$content['sender'] = $sender;
	        	$content['isRead'] = 1;
	        	$messages[] = $content;
	        }
        }
        if (empty($messages)) { //try to get messages until there is records left in relation table
        	return $this->_getListOutbox($userid, $limit, $beforeTimestamp, $limit);
        }
        return $messages;
    }
    
    function _htmlEntityDecode($string) {
    	//fix the &nbsp;&nbsp; problem
    	return str_replace(chr(0xA0), ' ', html_entity_decode($string, ENT_QUOTES));
    }
    
    function _getMessageRelatedUserInfoByUserId($userId) {
    	//get receiver info
        $userService = $this->_getUserService();
        $userInfo = $userService->get($userId);
        if (!$userInfo) {
        	return false;
        }
        return $this->_getMessageRelatedUserInfo($userInfo);
    }
    
    function _getMessageRelatedUserInfoByUsername($userName) {
    	//get receiver info
        $userService = $this->_getUserService();
        $userInfo = $userService->getByUserName($userName);
        if (!$userInfo) {
        	return false;
        }
        return $this->_getMessageRelatedUserInfo($userInfo);
    }
    /**
     * windCode﷨ַhtml
     * @global $db_windpost
     * @param string $string
     */
    function _getHtmlFromWindCode($string) {
    	global $db_windpost;
    	require_once(R_P.'require/bbscode.php');
    	return nl2br(convert($string, $db_windpost));
    }
    
    function _getMessageRelatedUserInfo($userInfo) {
        require_once R_P . '/require/showimg.php';
        return 
        	array(
        		'uid' => (int)$userInfo['uid'],
        		'username' => $userInfo['username'],
        		'avatarUrl' => $userInfo['uid'] == 0 ? '' : current(showfacedesign($userInfo['icon'], 1, 'm')),
        	);
    }
    /**
     * ûidȡϢ
     * @param int $userid
     * @param string $type 'all', 'pm''notice'
     * @param int $limit
     * @param null|int $beforeTimestamp Ϊnull½Ϊint޸ʱʱǰĽ
     * @return array
     */
    function _getListInbox($userid, $type, $limit = 12, $beforeTimestamp = null, $offset = null) {
    	$type = strtolower($type);
    	$offset = is_null($offset) ? null : (int)$offset;
    	$limit = (int)$limit;
    	
    	$allowedTypes = array('all', 'pm', 'notice');
    	if (!in_array($type, $allowedTypes)) {
    		return array();
    	}
    	switch ($type) {
    		case 'all':
    			$categoryIds = array(1, 2);
    			break;
    		case 'pm':
    			$categoryIds = array(1);
    			break;
    		case 'notice':
    			$categoryIds = array(2);
    			break;
    	}
    	
        $db = $this->db;
        $beforeTimestamp = is_null($beforeTimestamp) ? null : (int)$beforeTimestamp;
        
        //get receiver info
        $receiver = $this->_getMessageRelatedUserInfoByUserId($userid);
        if ($receiver === false) {
        	return array();
        }
        
        //info from relations
        $relationDb = $db->query('SELECT mid, status, created_time, modified_time, categoryid FROM pw_ms_relations WHERE uid = ' . S::sqlEscape($userid). ' AND categoryid '. ( count($categoryIds) > 1 ? 'IN (' .S::sqlImplode($categoryIds). ')' : '= ' .S::sqlEscape($categoryIds[0]) ) . ($beforeTimestamp > 0 ? ' AND modified_time < ' . S::sqlEscape($beforeTimestamp) : '') . ' ORDER BY modified_time DESC LIMIT ' . ($offset ? (int)$offset . ', ' : '') . (int)$limit);
        $relations = $mids = $pmMids = $noticeMids = array();
        while($rt = $db->fetch_array($relationDb)) {
        	$relations[$rt['mid']] = 
        		array(
        			'isRead' => ($rt['status'] == 0 ? true : false),
        			'createdTimestamp' => (int)$rt['created_time'],
        			'lastModifiedTimestamp' => (int)$rt['modified_time'],
        		);
        	$mids[] = $rt['mid'];
        	if ($rt['categoryid'] == 1) {
        		$pmMids[] = $rt['mid'];
        	} elseif ($rt['categoryid'] == 2) {
        		$noticeMids[] = $rt['mid'];
        	}
        }
        //return empty array if no messages found
        if (empty($mids)) {
        	return array();
        }

        $messageContents = $senderUserIds = $senders = $messages = array();
        if (count($pmMids)) {
	        $pmContentDb = $db->query('SELECT pw_ms_replies.content, pw_ms_replies.create_uid, pw_ms_messages.title, pw_ms_messages.mid FROM pw_ms_replies INNER JOIN pw_ms_messages ON pw_ms_replies.parentid = pw_ms_messages.mid WHERE pw_ms_messages.mid IN ('.S::sqlImplode($pmMids).') AND pw_ms_replies.create_uid != '. S::sqlEscape($userid));
	        while($rt = $db->fetch_array($pmContentDb)) {
	        	$messageContents[$rt['mid']] = 
	        		array(
	        			'subject' => $this->_htmlEntityDecode($rt['title']),
	        			'content' => $this->_getHtmlFromWindCode($rt['content']),
	        		);
	        	$senderUserIds[$rt['mid']] = $rt['create_uid'];
	        }
        }
        if (count($noticeMids)) {
        	$noticeContentDb = $db->query('SELECT pw_ms_messages.content, pw_ms_messages.create_uid, pw_ms_messages.title, pw_ms_messages.mid FROM pw_ms_messages WHERE pw_ms_messages.mid IN ('.S::sqlImplode($noticeMids).')');
	        while($rt = $db->fetch_array($noticeContentDb)) {
	        	$messageContents[$rt['mid']] = 
	        		array(
	        			'subject' => $this->_htmlEntityDecode($rt['title']),
	        			'content' => $this->_getHtmlFromWindCode($rt['content']),
	        		);
	        	$senderUserIds[$rt['mid']] = $rt['create_uid'];
	        }
        }
        if (!empty($senderUserIds)) {
	        //message sender info
	        $userService = $this->_getUserService();
	        $siteUserInfos = $userService->getByUserIds($senderUserIds);
	        $newSiteUserInfos = array();
	        if (is_array($siteUserInfos) && !empty($siteUserInfos)) {
	        	foreach($siteUserInfos as $siteUserInfo) {
	        		$newSiteUserInfos[$siteUserInfo['uid']] = $siteUserInfo;
	        	}
	        }
	        unset($siteUserInfos);
	        
	        foreach ($senderUserIds as $mid => $userId) {
	        	if (!isset($newSiteUserInfos[$userId])) {
	        		$senders[$mid] = array('uid' => 0);
	        		continue;
	        	}
	        	$senders[$mid] = $this->_getMessageRelatedUserInfo($newSiteUserInfos[$userId]);
	        }
	        
	        //շص
	        foreach($mids as $mid) {
	        	if (!isset($relations[$mid]) || !isset($messageContents[$mid]) || !isset($senders[$mid])) {
	        		continue;
	        	}
	        	$messages[] = 
	        		array(
	        			'mid' => (int)$mid,
	        			'createdTimestamp' => (int)$relations[$mid]['createdTimestamp'],
	        			'lastModifiedTimestamp' => (int)$relations[$mid]['lastModifiedTimestamp'],
	        			'subject' => (string)$messageContents[$mid]['subject'],
	        			'content' => (string)$messageContents[$mid]['content'],
	        			'isRead' => $relations[$mid]['isRead'] ? 1 : 0,
	        			'sender' => $senders[$mid],
	        			'receiver' => $receiver,
	        		);
	        }
        }
        if (empty($messages)) { //try to get messages until there is records left in relation table
        	return $this->_getListInbox($userid, $type, $limit, $beforeTimestamp, $limit);
        }
        return $messages;
    }
    /**
     * ûidmidȡһϢ
     * @param int $userId
     * @param int $mid
     * @return array
     */
    function getone($userId, $mid) {
        $userId = (int) $userId;
        $mid = (int) $mid;
        if ($userId < 1 || $mid < 1) {
            return $this->errMessage(MESSAGE_INVALID_PARAMS, 'invalid params');
        }
        $db = $this->db;
        
        $messageService = $this->_getMessageService();
        $relation = $db->get_one('SELECT rid, categoryid FROM pw_ms_relations WHERE uid = ' . S::sqlEscape($userId) . ' AND mid = ' . S::sqlEscape($mid));
        if (!$relation['rid']) {
            return $this->errMessage(-500, 'message not found');
        }
        $categoryId = (int)$relation['categoryid'];
        $rid = $relation['rid'];
        
        $currentUser = $this->_getMessageRelatedUserInfoByUserId($userId);
        if (!$currentUser) {
			return $this->errMessage(-501, 'user not found');
        }
        
        $msgInfo = $messageService->getMessage($mid);
        if (!$msgInfo) {
        	return $this->errMessage(-502, 'message not found');
        }
        $title = $this->_htmlEntityDecode($msgInfo['title']);
        //mark as read
        $messageService->readMessages($userId, $mid);
        $messageType = '';
        switch ($categoryId) {
        	case 1: //pm
        		$rawConversations = $messageService->getReplies($userId, $mid, $rid);
        		if (empty($rawConversations)) {
        			return $this->errMessage(-503, 'message not found');
        		}
        		$conversations = array();
        		foreach($rawConversations as $rawConversation) {
        			$conversations[] = 
        				array(
        					'replyid' => (int)$rawConversation['id'],
        					'sender' => $this->_getMessageRelatedUserInfo($rawConversation),
        					'content' => $rawConversation['content'],
        					'createdTimestamp' => (int)$rawConversation['created_time'],
        					'lastModifiedTimestamp' => (int)$rawConversation['modified_time'],
        				);
        		}
        		$messageService->resetStatistics(array($userId), 'sms_num');
        		$messageType = 'pm';
        		break;
        	case 2: //system notice
        		$conversations = array(
        			array(
        				'replyid' => 0,
        				'sender' => array(
        					'uid' => 0
        				),
        				'content' => $this->_getHtmlFromWindCode($msgInfo['content']),
        				'createdTimestamp' => $msgInfo['created_time'],
        				'lastModifiedTimestamp' => $msgInfo['modified_time'],
        			)
        		);
        		$messageService->resetStatistics(array($userId), 'notice_num');
        		$messageType = 'notice';
        		break;
        	default:
        		return $this->errMessage(-504, 'message not found');
        		break;
        }
        list($messageNumber,$noticeNumber,$requestNumber,$groupsmsNumber) = $messageService->getUserStatistics($userId);
        $totalMsgCount = $messageNumber+$noticeNumber+$requestNumber+$groupsmsNumber;
		$messageService->updateNewPm($userId, 'set', $totalMsgCount);
        $messages = array('title' => $title, 'mid' => $mid, 'rid' => $rid, 'currentUser' => $currentUser, 'conversation' => $conversations, 'type' => $messageType);
        
        return $messages;
    }
    
    /**
     * ûվǷ
     * @param string $username
     * @return int 1Ϊǣ0Ϊ
     */
    function ismessageboxfull($username) {
        $username = (string) $username;
        if (empty($username)) {
            return $this->errMessage(MESSAGE_INVALID_PARAMS, 'invalid params');
        }
        $userService = L::loadClass('UserService', 'user');
		$userInfo = $userService->getByUserName($username);
		if (!$userInfo) return $this->errMessage(-511, 'user not found');
		
		$userId = $userInfo['uid'];
    	$messageServer = $this->_getMessageService();
    	$usedNumbers = $messageServer->statisticUsersNumbers(array($userId));
		$usedNumber = isset($usedNumbers[$userId]) ? $usedNumbers[$userId] : 0;
		if ($usedNumber == 0) return 0;
		
		$groupId = $userInfo['groupid'] == -1 ? $userInfo['memberid'] : $userInfo['groupid'];
		if ($groupId == '') {
			return $this->errMessage(-511, 'invalid group id');
		}
		if (file_exists(D_P."data/groupdb/group_$groupId.php")) {
			require S::escapePath(D_P."data/groupdb/group_$groupId.php");
		} else {
			require(D_P.'data/groupdb/group_1.php');
		}
		if (isset($_G['maxmsg']) && $_G['maxmsg'] > 0 && $_G['maxmsg'] <= $usedNumber) {
			return 1;
		}
		return 0;
    }
    /**
     * @return PW_UserService
     */
    function _getUserService() {
        return L::loadClass('UserService', 'user');
    }
    /**
     * @return PW_MessageService
     */
    function _getMessageService() {
        return L::loadClass("message", 'message');
    }

}