<?php
!defined('P_W') && exit('Forbidden');

define('MESSAGE_INVALID_PARAMS',601);

class MessageApi extends BaseApi {
	var $methodsType = array(
            'get'            => 'GET',
			'getmessages'    => 'GET',
            'inbox'          => 'GET',
			'outbox'         => 'GET',
			'getunread'      => 'GET',
			'delete'         => 'POST',
			'send'           => 'POST',
			'reply'          => 'POST',
	        'getreply'       => 'GET',
    );
		 
	/**
	 * ȡȡϢ
	 * @param int $mid ϢID
	 * @param int $uid ûID ѡڸûϢעΪѶ
	 * @return array
	 */
	function get($mid,$uid = 0) {
		if (intval($mid) < 1) {
    	    return $this->errMessage(MESSAGE_INVALID_PARAMS,'invalid params');
    	}
    	
    	$messageService = $this->_getMessageService();
    	$result = $messageService->getMessage($mid);
    	if ($result && $uid) $messageService->readMessages($uid, $mid);
   	
    	$messageInfo = $this->_messageMapper($result);
    	return array('messageinfo' => $messageInfo);
	}
		
	/**
	 * ȡûվ
	 * @param int $uid ûID
	 * @param int $offset 
	 * @param int $limit 
	 * @return array
	 */
	function getmessages($uid, $offset = 1, $limit = 20) {
		if (intval($uid) < 1){
			return $this->errMessage(MESSAGE_INVALID_PARAMS, 'invalid params');
		}
		
		$messageService = $this->_getMessageService();
		$result = $messageService->getAllMessages($uid, $offset, $limit);
		$messages = array();
		foreach($result as $value){
			$messages[] = $this->_messageMapper($value);
		}
		$count = $messageService->countAllMessage($uid);
		return array('count' => $count,'messages' => $messages);
	}
	
	
	/**
	 * ȡûյĶϢ
	 * @param Integer $uid ûID
	 * @param Integer $offset
	 * @param Integer $limit 
	 * @return array
	 */
	function inbox($uid, $offset = 1, $limit = 20) {
		if (intval($uid) < 1){
			return $this->errMessage(MESSAGE_INVALID_PARAMS, 'invalid params');
		} 
		
		$messageService = $this->_getMessageService();
		$result = $messageService->getMessagesByOther($uid, 100, $offset, $limit);
		$messages = array();
		foreach($result as $value){
			$messages[] = $this->_messageMapper($value);
		}
		$count = $messageService->countMessagesByOther($uid,100);
		$unread = $messageService->countMessagesNotRead($uid);
		return array('count' => $count, 'unread'=>$unread, 'messages' => $messages);
	}
		
	/**
	 * ȡû͵ĶϢ
	 * @param int $uid
	 * @param int $offset
	 * @param int $limit
	 * @return array 
	 */
	function outbox($uid, $offset = 1, $limit = 20) {
		if (intval($uid) < 1) {
			return $this->errMessage(MESSAGE_INVALID_PARAMS, 'invalid params');
		}
		
		$messageService = $this->_getMessageService();
		$result = $messageService->getMessagesBySelf($uid, 100, $offset, $limit);
		$messages = array();
		foreach($result as $value){
			$messagesFilter = $this->_messageMapper($value);
			foreach ($value['extra'] as $v){
				$userService = $this->_getUserService();
				$uid = $userService->getUserIdByUserName($v);
				$messagesFilter['revicers'][] = array('uid' => $uid,'username' => $v);
			}
			$messages[] = $messagesFilter;
		}
		$count = $messageService->countMessagesBySelf($uid,100);
		return array('count' => $count,'messages' => $messages);
	}
	
	
	/**
	 * ȡĩϢб
	 * @param int $uid
	 * @param int $offset
	 * @param int $limit
	 * @return array
	 */
	function getunread($uid, $offset = 1, $limit = 20) {
		if (intval($uid) < 1){
			return $this->errMessage(MESSAGE_INVALID_PARAMS, 'invalid params');
		}
		
		$messageService = $this->_getMessageService();
		$result = $messageService->getAllNotRead($uid, $offset, $limit);
		$messages = array();
		foreach($result as $value){
			$messages[] = $this->_messageMapper($value);
		}
		$count = $messageService->countMessagesNotRead($uid);
		return array('count' => $count,'messages' => $messages);
	}
	
	/**
	 * ƳϢ
	 * @param int $uid ûID
	 * @param int $relationId ϢID
	 * @return int|array
	 */
	function delete($uid, $relationId) {
		if (intval($uid) < 1 || intval($relationId) < 1) {
    	    return $this->errMessage(MESSAGE_INVALID_PARAMS, 'invalid params');
    	}
    	
    	$messageService = $this->_getMessageService();
		return (bool)$messageService->deleteMessage($uid, $relationId) ? 0 : 1;
	}
	
	
	/**
	 * ֪ͨ
	 * @param int $uid ûID
	 * @param int|array $recevieName ûID
	 * @param string $type 'notice' | 'message'
	 * @param string $subject Ϣ
	 * @param string $content Ϣ
	 * @return int
	 */
	function send($uid, $recevieName, $type = 'message', $subject, $content) {
		if (intval($uid) < 1 || empty($recevieName) || empty($subject) || empty($content)){
			return $this->errMessage(MESSAGE_INVALID_PARAMS, 'invalid params');
		}
		
		$this->_initUserGroupInfo($uid);
		$GLOBLS['winduid'] = $uid;
		$recevieName = is_array($recevieName) ? $recevieName : array($recevieName);		
		$userService = $this->_getUserService();
		$userName = $userService->getUserNameByUserId($uid);
		$GLOBLS['windid'] = $userName;
				
		$messageInfo = array(
			'create_uid' => $uid,
			'create_username' => $userName,
			'title' => $subject,
			'content' => $content
		);
		$messageService = $this->_getMessageService();
		if ($type == 'notice'){
			return M::sendNotice($recevieName,$messageInfo);
		}elseif ($type == 'message'){
			return M::sendMessage($uid,$recevieName,$messageInfo);
		}
	}
	
	/**
	 * ظ
	 * @param int $uid ûID
	 * @param int $mid ϢID
	 * @param int $rid ϢϵID
	 * @param string $subject Ϣ
	 * @param string $content Ϣ
	 * @return int ͳɹĻظid
	 */
	function reply($uid,$mid,$rid,$subject,$content){
		if (intval($uid) < 1 || intval($mid) < 1 || empty($subject) || empty($content)){
			return $this->errMessage(MESSAGE_INVALID_PARAMS, 'invalid params');
		}		
		$userService = $this->_getUserService();
		$messageInfo = array(
			'create_uid' => $uid,
			'create_username' => $userService->getUserNameByUserId($uid),
			'title' => $subject,
			'content' => $content
		);
		$messageService = $this->_getMessageService();
		$replyId = $messageService->sendReply($uid,$rid,$mid,$messageInfo);
		return array('replyid' => $replyId);
	}
	
	/**
	 * ȡϢظ
	 * @param Integer $uid ûID
	 * @param Integer $mid ϢID
	 * @param Integer $rid ϢϵID
	 * @return Array
	 */
	function getreply($uid, $mid, $rid) {
		if (intval($uid) < 1 || intval($mid) < 1 || intval($rid) < 1){
			return $this->errMessage(MESSAGE_INVALID_PARAMS, 'invalid params');
		}
		
		$messageService = $this->_getMessageService();
		$replyInfo = $messageService->getReplies($uid, $mid, $rid);
		$messages = array();
		foreach($replyInfo as $value){
			$messages[] = $this->_messageMapper($value);
		}
		return array('messagereply' => $messages);
	}
	
	function _messageMapper($data){
		$return = array(
			'mid' => $data['mid'],
			'senderid' => $data['create_uid'],
			'sender'   => $data['create_username'],
			'title'    => $data['title'],
			'content'  => $data['content'],
			'createdtime' => $data['created_time']
		);
		isset($data['rid']) && $return['rid'] = $data['rid'];
		isset($data['status']) && $return['status'] = $data['status'];
		isset($data['icon']) && $return['icon'] = $data['icon'];
		return $return;
	}
	
	function _initUserGroupInfo($uid) {
    	global $groupid, $_G;
    	$userService = L::loadClass('UserService', 'user');
    	$userInfo = $userService->get($uid);
    	$groupid = $userInfo['groupid'];
    	$groupid == '-1' && $groupid = $userInfo['memberid'];
    	
		if ($groupid == 'guest') {
			require_once(D_P.'data/groupdb/group_2.php');
		} elseif (file_exists(D_P."data/groupdb/group_$groupid.php")) {
			require_once S::escapePath(D_P."data/groupdb/group_$groupid.php");
		} else {
			require_once(D_P.'data/groupdb/group_1.php');
		}
    }
    
	/**
	 * @return PW_UserService
	 */
	function _getUserService() {
		return L::loadClass('UserService', 'user');
	}
	
	/**
	 * @return PW_MessageService
	 */
	function _getMessageService() {
		return L::loadClass("message", 'message');
	}
}