<?php
!defined('P_W') && exit('Forbidden');

define('Friend_INVALID_PARAMS',101);
define('Friend_ALREADY_EXIST',102);

class FriendApi extends BaseApi{
	var $methodsType = array(
            'getfriends'   => 'GET',
            'addfriend'    => 'POST',
            'delfriend'    => 'POST'
        );

    /**
     * ȡûĺ
     * @param int $uid ûID
	 * @param $offset
	 * @param $limit
	 * @return Array
     */
    function getfriends($uid, $offset = 1, $limit = 20) {
    	if (intval($uid) <= 0){
    	    return $this->errMessage(Friend_INVALID_PARAMS,'invalid params');
    	}
    	
        $users = array();
		$offset = ($offset - 1) * $limit;
        $query = $this->db->query("SELECT friendid FROM pw_friends WHERE status='0' AND uid=" . S::sqlEscape($uid) . S::sqlLimit($offset,$limit));
        while ($rt = $this->db->fetch_array($query)) {
            $uid = $rt['friendid'];
            $userQuery = $this->db->get_one("SELECT * FROM pw_members WHERE uid=" . S::sqlEscape($uid));
            require_once(R_P . 'require/showimg.php');
			$iconInfo = showfacedesign($userQuery['icon'], 1, 'm');
			$userQuery['icon'] = $iconInfo[0];
            $userInfo = array(
            	'uid'         => $userQuery['uid'],
            	'username'    => $userQuery['username'],
            	'email'       => $userQuery['email'],
            	'gender'      => $userQuery['gender'],
            	'icon'        => $userQuery['icon'],
            	'groupid'     => $userQuery['groupid'],
            	'memberid'    => $userQuery['memberid'],
				'registertime'=> $userQuery['regdate'],
            	'signature'   => $userQuery['signature'],
            	'introduce'   => $userQuery['introduce'],
            	'oicq'        => $userQuery['oicq'],
            	'aliwangwang' => $userQuery['aliww'],
            	'icq'         => $userQuery['icq'],
            	'msn'         => $userQuery['msn'],
            	'yahoo'       => $userQuery['msn'],
            	'website'     => $userQuery['site'],
            	'location'    => $userQuery['location'],
            	'birthday'    => $userQuery['bday'],
            	'isverified'  => $userQuery['yz'],
            	'groups'      => $userQuery['groups']
            );
            $users[] = $userInfo;
        }
        $count = $this->db->get_value("SELECT count(*) FROM pw_friends WHERE status='0' AND uid=" . S::sqlEscape($uid));
        return array('count' => $count,'friends' => $users);
    }	
	
    /**
     * Ӻ
     * @param int $uid
     * @param int $friendId
     * @param string $desc
     * @param int $ftid
     * @param boolean $isUpdatemem
	 * @return array|int
     */
    function addfriend($uid, $friendId, $desc = '', $ftid = 0, $isUpdatemem = true){
        if (intval($uid) <= 0 || intval($friendId) <= 0){
            return $this->errMessage(Friend_INVALID_PARAMS,'invalid params');
        }
    	$friendService = $this->_getFriendService();
		if ($friendService->isFriend($uid, $friendId) === true) {
			return $this->errMessage(Friend_ALREADY_EXIST,'friend already exist');
		}
		
        $friendService->addFriend($uid,$friendId,$desc,$ftid,$isUpdatemem);
        return 1;
    }
    
    /**
     * ɾ
     * @param int $uid
     * @param int $friendId
	 * @return array|int
     */
    function delfriend($uid, $friendId){
        if (intval($uid) <= 0 || intval($friendId) <= 0){
            return $this->errMessage(Friend_INVALID_PARAMS,'Invalid params');
        }
        $friendService = $this->_getFriendService();
        $friendService->delFriend($uid,$friendId);
        return 1;
    }
    
    /**
     * @return PW_Friend
     */
    function _getFriendService(){
        return L::loadClass('friend', 'friend');
    }
}