<?php
!function_exists('readover') && exit('Forbidden');
require_once('exception.php');
require_once('message.class.php');
/**
 * @author zuojie
 *
 */
class PW_OpenImMessage extends PW_Message {
	function getSendMessageResult($userId,$usernames,$messageInfo,$typeId=null){
		return $this->_sendMessage($userId,$usernames,$messageInfo,$typeId);
	}
	/**
	 * վ
	 * 
	 * ܷصPW_Service_MessageExceptioncodeͶӦ
	 * 101 
	 * -102 Ч
	 * -103 ߲ڣܾܷ߻û鷢͵վţռ
	 * -104 վŸԼ
	 * -121 
	 * -122 Ĺ
	 * -501 ûûзվŵȨ
	 * -502 ûûվŵȨ
	 * -503 ûÿϢĿѵ
	 * -504 ûϢѵ
	 * -511 ߲
	 * -512 ûЧ
	 * 501 
	 * 
	 * @param int $userId
	 * @param array $usernames
	 * @param array $messageInfo
	 * @param unknown_type $typeId
	 * @access protected
	 * @return true|PW_Service_MessageException ɹtrue򷵻PW_Service_MessageException
	 */
	function _sendMessage($userId,$usernames,$messageInfo,$typeId=null) {
		$service = $this->_serviceFactory('openimmessage');
		return $service->_sendMessage($userId,$usernames,$messageInfo,$typeId);
	}
	
	function getSendReplyResult($userId,$relationId,$parentId,$messageInfo){
		return $this->_sendReply($userId,$relationId,$parentId,$messageInfo);
	}
	/**
	 * վ
	 * 
	 * ܷصPW_Service_MessageExceptioncodeͶӦ
	 * 101 
	 * -121 
	 * -122 Ĺ
	 * -501 ûûзվŵȨ
	 * -502 ûûվŵȨ
	 * -503 ûÿϢĿѵ
	 * -504 ûϢѵ
	 * -511 ߲
	 * -512 ûЧ
	 * -601 ظϢ
	 * -602 ϢϵЧ
	 * -603 ͻظʹ
	 * 501 
	 * 
	 * @param int $userId
	 * @param int $relationId
	 * @param int $parentId
	 * @param array $messageInfo
	 * @access protected
	 * @return true|PW_Service_MessageException ɹtrue򷵻PW_Service_MessageException
	 */
	function _sendReply($userId,$relationId,$parentId,$messageInfo) {
		$service = $this->_serviceFactory('openimmessage');
		return $service->_sendReply($userId,$relationId,$parentId,$messageInfo);
	}

	function syncNewPmToPlatform($userId) {
		/*global $db_openim_isopen;
		if (!$db_openim_isopen) return null;*/
		global $db_openim_notSyncNewPmToPlatform;
		$userId = (int)$userId;
		if ($userId < 1) return null;
		//TODO: do not use global variable
        if (isset($db_openim_notSyncNewPmToPlatform) && $db_openim_notSyncNewPmToPlatform) {
        	return false;
        }
        return $this->_syncNewPmToPlatform($userId);
	}
	
	function deleteMessageByUserIdAndMessageId($userId, $messageId) {
		$userId = (int)$userId;
		$messageId = (int)$messageId;
		
		if ($userId < 1 || $messageId < 1) return null;
		
		$service = $this->_serviceFactory('openimmessage');
		$relation = $service->getRelationByUserIdAndMessageId($userId, $messageId);

		if ($relation && isset($relation['rid']) && $relation['rid'] > 1) {
			$this->deleteMessage($userId, $relation['rid']);
			return true;
		}
		return null;
	}
	
	function _syncNewPmToPlatform($userId) {
		global $db_sitehash, $db_siteownerid, $charset;
		if (!$db_sitehash || !$db_siteownerid) return null;
		$service = $this->_serviceFactory('openimmessage');
		$timestamp = $service->getTimestampOfLatestUnreadMessageOrNotice($userId);
		if (!$timestamp) {
			$timestamp = 0;
		}
		$openImUserService = L::loadClass('OpenImUser', 'openim');
        if ($openImUserService->getPmNotifyTimestamp($userId) >= $timestamp) {
        	return true;
        }
        $openImUserService->setPmNotifyTimestamp($userId, $timestamp);
		L::loadClass('client', 'utility/platformapisdk', false);
		$client = new PlatformApiClient($db_sitehash, $db_siteownerid, $charset);

		$jsonResult = $client->get('openim.message.newpm', array('userid' => $userId, 'newpmtime' => $timestamp), true);
		//JSONתΪPHP
		if ($jsonResult) {
			require_once(R_P. 'lib/utility/json.class.php');
			$jsonService = new Services_JSON(true);
			$phpResult = $jsonService->decode($jsonResult);
			if ($phpResult['code'] == '0') { //ɹ
				return true;
			}
		}
		return false;
	}
}