/*==============================================================*/
/* DBMS name:      MySQL 5.0                                    */
/* Created on:     2011-1-28 16:50:28                           */
/*==============================================================*/


drop table if exists ut_ad;

drop table if exists ut_ad_position;

drop table if exists ut_ad_report;

drop table if exists ut_article;

drop table if exists ut_article_comment;

drop table if exists ut_article_content;

drop table if exists ut_channel;

drop table if exists ut_channel_ad_position;

drop table if exists ut_channel_article;

drop table if exists ut_channel_game;

drop table if exists ut_channel_module;

drop table if exists ut_channel_module_template;

drop table if exists ut_channel_music;

drop table if exists ut_channel_picture;

drop table if exists ut_channel_software;

drop table if exists ut_channel_theme;

drop table if exists ut_cron;

drop table if exists ut_error_report;

drop table if exists ut_farm_exprience_log;

drop table if exists ut_farm_invite;

drop table if exists ut_farm_plant;

drop table if exists ut_farm_plant_action;

drop table if exists ut_farm_report;

drop table if exists ut_farm_seed;

drop table if exists ut_farm_user;

drop table if exists ut_farm_user_fruit;

drop table if exists ut_farm_user_land;

drop table if exists ut_farm_user_level_rule;

drop table if exists ut_farm_user_seed;

drop table if exists ut_forbidden_keywords;

drop table if exists ut_forum_post;

drop table if exists ut_forum_post_accusation;

drop table if exists ut_forum_post_annex;

drop table if exists ut_forum_post_content;

drop table if exists ut_forum_post_operation_log;

drop table if exists ut_forum_post_reply;

drop table if exists ut_forum_role_honour_img;

drop table if exists ut_forum_shortcut_reply;

drop table if exists ut_forum_topic;

drop table if exists ut_friend_site;

drop table if exists ut_friend_site_in_log;

drop table if exists ut_friend_site_out_log;

drop table if exists ut_friend_site_report;

drop table if exists ut_game;

drop table if exists ut_game_comment;

drop table if exists ut_game_package;

drop table if exists ut_game_picture;

drop table if exists ut_illegal_mobile_ip;

drop table if exists ut_legal_mobile_ip;

drop table if exists ut_line;

drop table if exists ut_menu;

drop table if exists ut_message_board;

drop table if exists ut_mobile_brand;

drop table if exists ut_mobile_phone;

drop table if exists ut_mobile_platform;

drop table if exists ut_mobile_report;

drop table if exists ut_mobile_screen;

drop table if exists ut_mobile_serial;

drop table if exists ut_music;

drop table if exists ut_music_album;

drop table if exists ut_music_category;

drop table if exists ut_music_comment;

drop table if exists ut_music_file;

drop table if exists ut_music_language;

drop table if exists ut_music_singer;

drop table if exists ut_music_singer_area;

drop table if exists ut_photo_frame;

drop table if exists ut_picture;

drop table if exists ut_picture_comment;

drop table if exists ut_picture_detail;

drop table if exists ut_plugin;

drop table if exists ut_poll;

drop table if exists ut_poll_item;

drop table if exists ut_poll_user;

drop table if exists ut_report_basic;

drop table if exists ut_report_channel_module;

drop table if exists ut_report_game;

drop table if exists ut_report_software;

drop table if exists ut_report_theme;

drop table if exists ut_sessions;

drop table if exists ut_software;

drop table if exists ut_software_comment;

drop table if exists ut_software_package;

drop table if exists ut_system;

drop table if exists ut_theme;

drop table if exists ut_theme_comment;

drop table if exists ut_theme_package;

drop table if exists ut_ubb_tags;

drop table if exists ut_user;

drop table if exists ut_user_action_state;

drop table if exists ut_user_album_group;

drop table if exists ut_user_album_group_img;

drop table if exists ut_user_attention_friend;

drop table if exists ut_user_black_list;

drop table if exists ut_user_collection;

drop table if exists ut_user_forum_channel;

drop table if exists ut_user_friend;

drop table if exists ut_user_friend_group;

drop table if exists ut_user_honour;

drop table if exists ut_user_login_cms_log;

drop table if exists ut_user_menu;

drop table if exists ut_user_message_board;

drop table if exists ut_user_message_box;

drop table if exists ut_user_space;

drop table if exists ut_user_space_visit_log;

drop table if exists ut_user_template;

drop table if exists ut_visit_log;

drop table if exists ut_website_attribute;

/*==============================================================*/
/* Table: ut_ad                                                 */
/*==============================================================*/
create table ut_ad
(
   id                   int not null auto_increment,
   ad_name              varchar(128) not null,
   ad_language          varchar(512) not null,
   ad_url               varchar(512) not null,
   setup_flag           int(1) not null default 0,
   status               int(1) not null default 9,
   memo                 varchar(1000),
   create_date          datetime not null,
   ug_ad_id             int,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_ad_position                                        */
/*==============================================================*/
create table ut_ad_position
(
   id                   int not null auto_increment,
   channel_module_id    int not null,
   page_type            int(1) not null default 1,
   position             int(1) not null default 1,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_ad_report                                          */
/*==============================================================*/
create table ut_ad_report
(
   id                   int not null auto_increment,
   report_day           varchar(8) not null,
   ad_id                int not null,
   pv                   int default 0,
   primary key (id),
   UNIQUE KEY index_ad_day(ad_id, report_day)
)
type = myisam;

/*==============================================================*/
/* Table: ut_article                                            */
/*==============================================================*/
create table ut_article
(
   id                   int not null auto_increment,
   title                varchar(256) not null,
   source               varchar(256),
   click_count          int not null default 0,
   publish_status       int(1) not null default 2,
   comment_flag         int(1) not null default 1,
   creator_id           int not null,
   create_date          datetime not null,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_article_comment                                    */
/*==============================================================*/
create table ut_article_comment
(
   id                   int not null auto_increment,
   article_id           int not null,
   comment              varchar(2000) not null,
   status               int(1) not null default 2,
   create_user_id       int,
   create_user_pet_name varchar(32),
   create_date          datetime not null,
   primary key (id),
   KEY index_articleid(article_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_article_content                                    */
/*==============================================================*/
create table ut_article_content
(
   article_id           int not null,
   content              text not null,
   primary key (article_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_channel                                            */
/*==============================================================*/
create table ut_channel
(
   id                   int not null auto_increment,
   parent_id            int,
   line_id              int,
   channel_type         int(1) not null default 1,
   channel_module_id    int,
   channel_text         text not null,
   br_flag              int(1) not null default 0,
   show_flag            int(1) not null default 1,
   show_order           int not null default 1,
   creator_id           int not null,
   create_date          datetime not null,
   primary key (id),
   KEY index_parentid_lineid(parent_id, line_id),
   KEY index_line_id(line_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_channel_ad_position                                */
/*==============================================================*/
create table ut_channel_ad_position
(
   id                   int not null auto_increment,
   channel_id           int not null,
   ad_id                int not null,
   ad_position_id       int not null default 0,
   channel_module_id    int  default 0,
   page_type            int  default 0,
   position				int  default 0,
   create_date          datetime not null,
   primary key (id),
   KEY index_channel_position(channel_id, ad_position_id),
   KEY index_positionid(ad_position_id),
   KEY index_adid(ad_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_channel_article                                    */
/*==============================================================*/
create table ut_channel_article
(
   id                   int not null auto_increment,
   channel_id           int not null,
   article_id           int not null,
   top_flag             int not null default 0,
   create_date          datetime,
   primary key (id),
   KEY index_channel_top(channel_id, top_flag DESC)
)
type = myisam;

/*==============================================================*/
/* Table: ut_channel_game                                       */
/*==============================================================*/
create table ut_channel_game
(
   id                   int not null auto_increment,
   channel_id           int not null,
   game_id              int not null,
   top_flag             int not null default 0,
   create_date          datetime,
   primary key (id),
   KEY index_channel_top(channel_id, top_flag DESC)
)
type = myisam;

/*==============================================================*/
/* Table: ut_channel_module                                     */
/*==============================================================*/
create table ut_channel_module
(
   id                   int not null auto_increment,
   channel_module_name  varchar(256) not null,
   show_order           int not null default 0,
   primary key (id),
   KEY index_order(show_order)
)
type = myisam;

/*==============================================================*/
/* Table: ut_channel_module_template                            */
/*==============================================================*/
create table ut_channel_module_template
(
   id                   int not null auto_increment,
   title                varchar(20),
   channel_module_id    int not null,
   head_ubb_content     text,
   foot_ubb_content     text,
   page_type            int(1),
   primary key (id),
   KEY index_channel_module_id(channel_module_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_channel_music                                      */
/*==============================================================*/
create table ut_channel_music
(
   id                   int not null auto_increment,
   channel_id           int not null,
   music_id             int not null,
   top_flag             int not null default 0,
   create_date          datetime,
   primary key (id),
   KEY index_channel_top(channel_id, top_flag DESC)
)
type = myisam;

/*==============================================================*/
/* Table: ut_channel_picture                                    */
/*==============================================================*/
create table ut_channel_picture
(
   id                   int not null auto_increment,
   channel_id           int not null,
   picture_id           int not null,
   top_flag             int not null default 0,
   create_date          datetime,
   primary key (id),
   KEY index_channel_top(channel_id, top_flag DESC)
)
type = myisam;

/*==============================================================*/
/* Table: ut_channel_software                                   */
/*==============================================================*/
create table ut_channel_software
(
   id                   int not null auto_increment,
   channel_id           int not null,
   software_id          int not null,
   top_flag             int not null default 0,
   create_date          datetime,
   primary key (id),
   KEY index_channel_top(channel_id, top_flag DESC)
)
type = myisam;

/*==============================================================*/
/* Table: ut_channel_theme                                      */
/*==============================================================*/
create table ut_channel_theme
(
   id                   int not null auto_increment,
   channel_id           int not null,
   theme_id             int not null,
   top_flag             int not null default 0,
   create_date          datetime,
   primary key (id),
   KEY index_channel_top(channel_id, top_flag DESC)
)
type = myisam;

/*==============================================================*/
/* Table: ut_cron                                               */
/*==============================================================*/
create table ut_cron
(
   id                   int not null,
   cron_name            varchar(64) not null,
   last_run_date        int,
   next_run_date        int,
   command              varchar(256) not null,
   run_weekday          int(1) default 0,
   run_day              int(2) default 0,
   run_hour             int(2) default 0,
   run_minute           varchar(36) default '',
   plugin               varchar(50),
   status               int(1) not null default 1,
   primary key (id)
)
type = myisam
auto_increment = 101;

/*==============================================================*/
/* Table: ut_error_report                                       */
/*==============================================================*/
create table ut_error_report
(
   id                   int not null auto_increment,
   error_type           int(2) not null default 0,
   error_content        varchar(512) not null,
   data_id              int not null,
   create_date          datetime not null,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_farm_exprience_log                                 */
/*==============================================================*/
create table ut_farm_exprience_log
(
   id                   int not null auto_increment,
   farm_user_id         int not null,
   log_date             varchar(10) not null,
   log_type             int(1) not null,
   log_datetime         datetime not null,
   add_exprience        int not null,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_farm_invite                                        */
/*==============================================================*/
create table ut_farm_invite
(
   id                   int not null auto_increment,
   user_id              int not null,
   invitation_code      varchar(64) not null,
   from_user_id         int,
   create_date          datetime not null,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_farm_plant                                         */
/*==============================================================*/
create table ut_farm_plant
(
   id                   int not null auto_increment,
   farm_seed_id         int not null,
   farm_user_id         int not null,
   worm_count           int not null default 0,
   grass_count          int not null default 0,
   user_land_id         int not null,
   is_system_give       int(1) not null default 0,
   watering_time        int(1) not null default 0,
   start_time           int not null default 0,
   current_season       int(1) not null default 1,
   last_watering_status int(1) not null default 1,
   last_watering_time   int not null default 0,
   watering_flag        int(1) not null default 1,
   status               int(1) not null default 1,
   seed_name            varchar(20) not null,
   fruit_name           varchar(20) not null,
   create_date          datetime not null,
   fruit                int(4) not null default 0,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_farm_plant_action                                  */
/*==============================================================*/
create table ut_farm_plant_action
(
   id                   int not null auto_increment,
   farm_plant_id        int not null,
   farm_user_id         int not null,
   action               varchar(1000) not null,
   action_date          varchar(10) not null,
   action_datetime      datetime not null,
   action_type          int(1) not null,
   action_count         int(4) not null default 0,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_farm_report                                        */
/*==============================================================*/
create table ut_farm_report
(
   id                   int not null auto_increment,
   report_day           varchar(8) not null,
   pv                   int default 0,
   uv                   int default 0,
   add_user             int default 0,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_farm_seed                                          */
/*==============================================================*/
create table ut_farm_seed
(
   id                   int not null auto_increment,
   seed_name            varchar(20) not null,
   fruit_name           varchar(20) not null,
   season_type          int(1) not null default 1,
   price                double not null default 0,
   need_user_level      int(4) not null,
   bud_time             double not null default 0,
   small_leaves_time    double not null default 0,
   big_leaves_time      double not null default 0,
   flowering_time       double not null default 0,
   ripening_time        double not null default 0,
   again_ripening_time  double not null default 0,
   total_time           double not null default 0,
   yield                int not null default 0,
   sale                 double not null default 0,
   exprience            int not null default 0,
   icon                 varchar(256),
   icon_path            varchar(256),
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_farm_user                                          */
/*==============================================================*/
create table ut_farm_user
(
   id                   int not null auto_increment,
   user_id              int not null,
   level                int not null default 0,
   exprience            int not null default 0,
   gold                 double not null default 0,
   status               int(1) not null default 1,
   create_date          datetime not null,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_farm_user_fruit                                    */
/*==============================================================*/
create table ut_farm_user_fruit
(
   id                   int not null auto_increment,
   farm_user_id         int not null,
   farm_seed_id         int not null,
   total                int(8) not null default 0,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_farm_user_land                                     */
/*==============================================================*/
create table ut_farm_user_land
(
   id                   int not null auto_increment,
   farm_user_id         int not null,
   status               int(1) not null default 1,
   land_type            int not null default 1,
   show_order           int not null default 0,
   create_date          datetime not null,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_farm_user_level_rule                               */
/*==============================================================*/
create table ut_farm_user_level_rule
(
   id                   int not null auto_increment,
   need_exprience       int not null default 0,
   buy_land_no          int(2) not null default 0,
   buy_land_price       double not null default 0,
   give_seed_id         int,
   give_seed_count      int(4),
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_farm_user_seed                                     */
/*==============================================================*/
create table ut_farm_user_seed
(
   id                   int not null auto_increment,
   farm_user_id         int not null,
   farm_seed_id         int not null,
   total                int(8) not null default 0,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_forbidden_keywords                                 */
/*==============================================================*/
create table ut_forbidden_keywords
(
   id                   int not null auto_increment,
   source_keyword       varchar(50) not null,
   target_keyword       varchar(50) not null,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_forum_post                                         */
/*==============================================================*/
create table ut_forum_post
(
   id                   int not null auto_increment,
   channel_id           int,
   title                varchar(256) not null,
   click_count          int not null default 0,
   reply_count          int not null default 0,
   check_status         int(1) not null default 2,
   lock_status          int(1) not null default 1,
   forum_topic_id       int,
   bulletin_flag        int(1) not null default 0,
   extract_flag         int(1) not null default 0,
   position_flag        int(1) not null default 2,
   annex_flag           int(1) not null default 0,
   bad_evaluation_count int not null default 0,
   good_evaluation_count int not null default 0,
   last_reply_date      datetime not null,
   create_user_id       int not null,
   create_user_pet_name varchar(32) not null,
   create_date          datetime not null,
   post_type            int(1) not null default 0,
   primary key (id),
   KEY index_channelid(channel_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_forum_post_accusation                              */
/*==============================================================*/
create table ut_forum_post_accusation
(
   id                   int not null auto_increment,
   forum_post_id        int not null,
   accusation_content   varchar(256) not null,
   accusation_user_id   int,
   accusation_user_pet_name varchar(32),
   accusation_date      datetime not null,
   primary key (id),
   KEY index_postid(forum_post_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_forum_post_annex                                   */
/*==============================================================*/
create table ut_forum_post_annex
(
   id                   int not null auto_increment,
   forum_post_id        int not null,
   annex_url            varchar(512) not null,
   annex_type           int(1) not null,
   file_name            varchar(512) not null,
   file_type            varchar(8) not null,
   file_size            int not null,
   create_date          datetime not null,
   primary key (id),
   KEY index_postid(forum_post_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_forum_post_content                                 */
/*==============================================================*/
create table ut_forum_post_content
(
   post_id              int not null,
   content              text not null,
   primary key (post_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_forum_post_operation_log                           */
/*==============================================================*/
create table ut_forum_post_operation_log
(
   id                   int not null auto_increment,
   forum_post_id        int not null,
   operation_name       varchar(64) not null,
   operation_user_id    int not null,
   operation_user_pet_name varchar(64) not null,
   operation_date       datetime not null,
   post_user_id         int,
   post_pet_name        varchar(64),
   post_title           varchar(256),
   post_channel_id      int,
   primary key (id),
   KEY index_postid(forum_post_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_forum_post_reply                                   */
/*==============================================================*/
create table ut_forum_post_reply
(
   id                   int not null auto_increment,
   forum_post_id        int not null,
   reply_content        varchar(1000) not null,
   reply_face_file_name varchar(32),
   reply_user_id        int,
   reply_user_pet_name  varchar(32),
   reply_date           datetime not null,
   status               int(1) not null default 2,
   primary key (id),
   KEY index_postid(forum_post_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_forum_role_honour_img                              */
/*==============================================================*/
create table ut_forum_role_honour_img
(
   id                   int not null auto_increment,
   forum_role           int(1) not null,
   honour_img           varchar(256) not null,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_forum_shortcut_reply                               */
/*==============================================================*/
create table ut_forum_shortcut_reply
(
   id                   int not null auto_increment,
   reply_content        varchar(256) not null,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_forum_topic                                        */
/*==============================================================*/
create table ut_forum_topic
(
   id                   int not null auto_increment,
   topic_name           varchar(128) not null,
   channel_id           int not null,
   posts_count          int not null default 0,
   show_order           int(3) not null default 999,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_friend_site                                        */
/*==============================================================*/
create table ut_friend_site
(
   id                   int not null auto_increment,
   channel_id           int not null,
   friend_site_name     varchar(64) not null,
   out_url              varchar(512),
   intro                varchar(512),
   contact_info         varchar(512),
   in_pv_all            int default 0,
   out_pv_all           int default 0,
   status               int(1) default 2,
   top_flag				int(1) default 0,
   last_in_date         datetime,
   create_date          datetime,
   primary key (id),
   KEY index_channelid(channel_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_friend_site_in_log                                 */
/*==============================================================*/
create table ut_friend_site_in_log
(
   id                   int not null auto_increment,
   friend_site_id       int not null,
   ip                   varchar(32) not null,
   agent                varchar(256),
   referer              varchar(512),
   visit_date           datetime,
   primary key (id),
   KEY index_siteid(friend_site_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_friend_site_out_log                                */
/*==============================================================*/
create table ut_friend_site_out_log
(
   id                   int not null auto_increment,
   friend_site_id       int not null,
   ip                   varchar(32) not null,
   agent                varchar(256),
   visit_date           datetime not null,
   primary key (id),
   KEY index_siteid(friend_site_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_friend_site_report                                 */
/*==============================================================*/
create table ut_friend_site_report
(
   id                   int not null auto_increment,
   friend_site_id       int not null,
   report_day           varchar(8) not null,
   in_pv                int default 0,
   out_pv               int default 0,
   site_pv              int default 0,
   primary key (id),
   KEY index_siteid(friend_site_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_game                                               */
/*==============================================================*/
create table ut_game
(
   id                   int not null auto_increment,
   title                varchar(256) not null,
   image_url            varchar(512),
   thumb_image_url      varchar(512),
   recommend_level      int(1),
   good_count           int not null default 0,
   normal_count         int not null default 0,
   bad_count            int not null default 0,
   click_count          int not null default 0,
   down_count           int not null default 0,
   real_click_count     int not null default 0,
   real_down_count      int not null default 0,
   comment_flag         int(1) not null default 1,
   fee_type             int(1),
   fee_detail           varchar(64),
   manufacturer         varchar(32),
   introduction         text,
   install_tutorial     text,
   base_upload_path     varchar(128) not null,
   publish_status       int(1) not null default 2,
   creator_id           int not null,
   create_date          datetime not null,
   rename_flag          int(1) default 1,
   mobile_serial_ids    varchar(1024) default '',
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_game_comment                                       */
/*==============================================================*/
create table ut_game_comment
(
   id                   int not null auto_increment,
   game_id              int not null,
   comment              varchar(2000) not null,
   status               int(1) not null default 2,
   create_user_id       int,
   create_user_pet_name varchar(32),
   create_date          datetime not null,
   primary key (id),
   KEY index_gameid(game_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_game_package                                       */
/*==============================================================*/
create table ut_game_package
(
   id                   int not null auto_increment,
   game_id              int not null,
   mobile_serial_id     int,
   mobile_screen_id     int,
   agent_description    text,
   package_type         int(1) not null default 1,
   download_url         varchar(512) not null,
   download_additional_url varchar(512),
   download_type        int(1) not null default 1,
   file_type            varchar(32),
   file_size            int default 0,
   show_order           int not null default 1,
   primary key (id),
   KEY index_gameid(game_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_game_picture                                       */
/*==============================================================*/
create table ut_game_picture
(
   id                   int not null auto_increment,
   game_id              int not null,
   image_url            varchar(512) not null,
   show_order           int not null default 1,
   primary key (id),
   KEY index_gameid(game_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_illegal_mobile_ip                                  */
/*==============================================================*/
create table ut_illegal_mobile_ip
(
   id                   int not null auto_increment,
   ip                   varchar(64) not null,
   memo                 varchar(512),
   primary key (id),
   KEY index_ip(ip)
)
type = myisam;

/*==============================================================*/
/* Table: ut_legal_mobile_ip                                    */
/*==============================================================*/
create table ut_legal_mobile_ip
(
   id                   int not null auto_increment,
   ip                   varchar(64) not null,
   province             varchar(64),
   city                 varchar(64),
   operator_name        varchar(32),
   primary key (id),
   KEY index_ip(ip)
)
type = myisam;

/*==============================================================*/
/* Table: ut_line                                               */
/*==============================================================*/
create table ut_line
(
   id                   int not null auto_increment,
   line_order           int not null default 1,
   channel_id           int,
   show_flag            int(1) not null default 1,
   system_flag          int(1) not null default 0,
   primary key (id),
   KEY index_channelid(channel_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_menu                                               */
/*==============================================================*/
create table ut_menu
(
   id                   int not null auto_increment,
   menu_name            varchar(32) not null,
   menu_url             varchar(256),
   show_flag            int(1) not null default 0,
   forum_menu_flag      int(1) not null default 0,
   parent_id            int,
   primary key (id),
   KEY index_parentid(parent_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_message_board                                      */
/*==============================================================*/
create table ut_message_board
(
   id                   int not null auto_increment,
   channel_id           int not null,
   message_title        varchar(256) not null,
   message_text         varchar(512) not null,
   reply_message        varchar(512),
   reply_date           datetime,
   ip                   varchar(32) not null,
   private_flag         int(1) not null default 0,
   extract_flag         int(1) not null default 0,
   top_flag             int(1) not null default 0,
   status               int(1) not null default 2,
   create_user_id       int,
   create_user_pet_name varchar(32),
   create_date          datetime,
   primary key (id),
   KEY index_channelid(channel_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_mobile_brand                                       */
/*==============================================================*/
create table ut_mobile_brand
(
   id                   int not null auto_increment,
   brand_name           varchar(64) not null,
   hot_flag             int(1) not null,
   show_order           int(3) not null default 999,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_mobile_phone                                       */
/*==============================================================*/
create table ut_mobile_phone
(
   id                   int not null auto_increment,
   agent                varchar(256) not null,
   mobile_platform_id   int,
   mobile_screen_id     int,
   mobile_serial_id     int,
   mobile_brand_id      int not null,
   hot_flag             int(1) default 0,
   show_order           int(5) not null default 99999,
   primary key (id),
   KEY index_platformid(mobile_platform_id),
   KEY index_screenid(mobile_screen_id),
   KEY index_serialid(mobile_serial_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_mobile_platform                                    */
/*==============================================================*/
create table ut_mobile_platform
(
   id                   int not null auto_increment,
   platform_name        varchar(256) not null,
   universal_flag       int(1) default 0,
   show_order           int(2) not null default 99,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_mobile_report                                      */
/*==============================================================*/
create table ut_mobile_report
(
   id                   int not null auto_increment,
   content              varchar(200) not null,
   create_user_id       int,
   create_user_pet_name varchar(32),
   create_date          datetime,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_mobile_screen                                      */
/*==============================================================*/
create table ut_mobile_screen
(
   id                   int not null auto_increment,
   screen_size          varchar(64) not null,
   show_order           int(3) not null default 999,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_mobile_serial                                      */
/*==============================================================*/
create table ut_mobile_serial
(
   id                   int not null auto_increment,
   serial               varchar(256) not null,
   mobile_brand_id      int,
   show_order           int(3) not null default 999,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_music                                              */
/*==============================================================*/
create table ut_music
(
   id                   int not null auto_increment,
   title                varchar(128) not null,
   singer_id            int,
   singer_name          varchar(32),
   album_id             int,
   album_name           varchar(64),
   category_id          int,
   category_name        varchar(32),
   language_id          int,
   language             varchar(32),
   click_count          int not null default 0,
   down_count           int not null default 0,
   lyric                varchar(2000),
   publish_status       int(1) not null default 2,
   create_date          datetime not null,
   creator_id           int not null,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_music_album                                        */
/*==============================================================*/
create table ut_music_album
(
   id                   int not null auto_increment,
   album_name           varchar(64) not null,
   cover_img_url        varchar(256),
   singer_id            int,
   singer_name          varchar(32),
   click_count          int not null default 0,
   publish_date         varchar(32),
   introduction         varchar(512),
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_music_category                                     */
/*==============================================================*/
create table ut_music_category
(
   id                   int not null auto_increment,
   category_name        varchar(32) not null,
   show_order           int not null default 1,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_music_comment                                      */
/*==============================================================*/
create table ut_music_comment
(
   id                   int not null auto_increment,
   music_id             int not null,
   comment              varchar(2000) not null,
   status               int(1) not null default 2,
   create_user_id       int,
   create_user_pet_name varchar(32),
   create_date          datetime not null,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_music_file                                         */
/*==============================================================*/
create table ut_music_file
(
   id                   int not null auto_increment,
   music_id             int not null,
   introduction         varchar(128),
   lyric_down_url       varchar(256),
   download_url         varchar(256) not null,
   download_type        int(1) not null default 1,
   file_type            varchar(32),
   file_size            int default 0,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_music_language                                     */
/*==============================================================*/
create table ut_music_language
(
   id                   int not null auto_increment,
   language             varchar(32) not null,
   show_order           int not null default 1,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_music_singer                                       */
/*==============================================================*/
create table ut_music_singer
(
   id                   int not null auto_increment,
   singer_name          varchar(32) not null,
   first_character      varchar(1),
   singer_type          int(1) not null default 0,
   singer_area_id       int,
   singer_area          varchar(32),
   click_count          int not null default 0,
   down_count           int not null default 0,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_music_singer_area                                  */
/*==============================================================*/
create table ut_music_singer_area
(
   id                   int not null auto_increment,
   area                 varchar(32) not null,
   show_order           int not null default 1,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_photo_frame                                        */
/*==============================================================*/
create table ut_photo_frame
(
   id                   int not null auto_increment,
   photo_frame_url      varchar(256) not null,
   introduction         varchar(256),
   width                int not null default 0,
   height               int not null default 0,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_picture                                            */
/*==============================================================*/
create table ut_picture
(
   id                   int not null auto_increment,
   title                varchar(128) not null,
   thumbnail_img_url    varchar(256),
   picture_count        int not null default 0,
   click_count          int not null default 0,
   down_count           int not null default 0,
   publish_status       int(1) not null default 2,
   introduction         varchar(1000),
   creator_id           int not null,
   create_date          datetime not null,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_picture_comment                                    */
/*==============================================================*/
create table ut_picture_comment
(
   id                   int not null auto_increment,
   picture_id           int not null,
   comment              varchar(2000) not null,
   status               int(1) not null default 2,
   create_user_id       int,
   create_user_pet_name varchar(32),
   create_date          datetime not null,
   primary key (id),
   KEY index_pictureid(picture_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_picture_detail                                     */
/*==============================================================*/
create table ut_picture_detail
(
   id                   int not null auto_increment,
   picture_id           int not null,
   title                varchar(128) not null,
   big_thumbnail_img_url varchar(512) not null,
   middle_thumbnail_img_url varchar(512) not null,
   small_thumbnail_img_url varchar(512) not null,
   real_img_url         varchar(512) not null,
   file_size            int not null default 0,
   file_type            varchar(32) not null,
   img_width            int not null default 0,
   img_height           int not null default 0,
   primary key (id),
   KEY index_pictureid(picture_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_plugin                                             */
/*==============================================================*/
create table ut_plugin
(
   id                   int not null auto_increment,
   plugin_code          varchar(20) not null,
   plugin_name          varchar(20) not null,
   description          varchar(1000),
   status               int(1) not null default 9,
   publish_time         date,
   install_time         date,
   plugin_version       varchar(20),
   primary key (id),
   UNIQUE KEY `plugin_code` (`plugin_code`)
)
type = myisam;

/*==============================================================*/
/* Table: ut_poll                                               */
/*==============================================================*/
create table ut_poll
(
   id                   int not null auto_increment,
   title                varchar(100),
   check_out_flag       int(1) not null default 0,
   check_out_time       datetime,
   channel_module_id    int not null,
   object_id            int not null,
   voters               int not null default 0,
   status               int(1) not null default 1,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_poll_item                                          */
/*==============================================================*/
create table ut_poll_item
(
   id                   int not null auto_increment,
   poll_id              int not null,
   hits                 int not null default 0,
   text                 varchar(256) not null,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_poll_user                                          */
/*==============================================================*/
create table ut_poll_user
(
   id                   int not null auto_increment,
   user_id              int not null default 0,
   poll_id              int not null default 0,
   item_id              int default 0,
   ip                   varchar(256),
   create_date          datetime not null,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_report_basic                                       */
/*==============================================================*/
create table ut_report_basic
(
   id                   int not null auto_increment,
   report_day           varchar(8) not null,
   pv                   int default 0,
   uv                   int default 0,
   primary key (id),
   KEY index_day(report_day)
)
type = myisam;

/*==============================================================*/
/* Table: ut_report_channel_module                              */
/*==============================================================*/
create table ut_report_channel_module
(
   id                   int not null auto_increment,
   report_day           varchar(8) not null,
   channel_module_id    int not null,
   pv                   int default 0,
   uv                   int default 0,
   primary key (id),
   UNIQUE KEY index_moduleid_day(channel_module_id, report_day)
)
type = myisam;

/*==============================================================*/
/* Table: ut_report_game                                        */
/*==============================================================*/
create table ut_report_game
(
   id                   int not null auto_increment,
   report_day           varchar(8),
   game_id              int not null,
   click_count          int default 0,
   down_count           int default 0,
   primary key (id),
   UNIQUE KEY index_gameid_day(game_id, report_day) 
)
type = myisam;

/*==============================================================*/
/* Table: ut_report_software                                    */
/*==============================================================*/
create table ut_report_software
(
   id                   int not null auto_increment,
   report_day           varchar(8),
   software_id          int not null,
   click_count          int default 0,
   down_count           int default 0,
   primary key (id),
   UNIQUE KEY index_softwareid_day(software_id, report_day) 
)
type = myisam;

/*==============================================================*/
/* Table: ut_report_theme                                       */
/*==============================================================*/
create table ut_report_theme
(
   id                   int not null auto_increment,
   report_day           varchar(8),
   theme_id             int not null,
   click_count          int default 0,
   down_count           int default 0,
   primary key (id),
   UNIQUE KEY index_theme_day(theme_id, report_day)
)
type = myisam;

/*==============================================================*/
/* Table: ut_sessions                                           */
/*==============================================================*/
create table ut_sessions
(
   id                   CHAR(64) not null,
   data                 VARCHAR(10240) not null,
   timeout              int(12) not null,
   last_touch_date      datetime not null,
   user_id              int,
   channel_id           int,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_software                                           */
/*==============================================================*/
create table ut_software
(
   id                   int not null auto_increment,
   title                varchar(256) not null,
   image_url            varchar(512),
   thumb_image_url      varchar(512),
   recommend_level      int(1),
   good_count           int not null default 0,
   normal_count         int not null default 0,
   bad_count            int not null default 0,
   click_count          int not null default 0,
   down_count           int not null default 0,
   real_click_count     int not null default 0,
   real_down_count      int not null default 0,
   comment_flag         int(1) not null default 1,
   fee_type             int(1),
   fee_detail           varchar(64),
   manufacturer         varchar(64),
   introduction         text,
   install_tutorial     text,
   publish_status       int(1) not null default 2,
   base_upload_path     varchar(128) not null,
   creator_id           int not null,
   create_date          datetime not null,
   rename_flag          int(1) default 1,
   mobile_platform_ids  varchar(1024) default '',
   universal_flag_contain int(1) default 0,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_software_comment                                   */
/*==============================================================*/
create table ut_software_comment
(
   id                   int not null auto_increment,
   software_id          int not null,
   comment              varchar(2000) not null,
   status               int(1) not null default 2,
   create_user_id       int,
   create_user_pet_name varchar(32),
   create_date          datetime not null,
   primary key (id),
   KEY index_softwareid(software_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_software_package                                   */
/*==============================================================*/
create table ut_software_package
(
   id                   int not null auto_increment,
   software_id          int not null,
   mobile_platform_id   int not null,
   mobile_screen_id     int,
   universal_flag       int(1) default 0,
   agent_description    text,
   download_url         varchar(512) not null,
   download_additional_url varchar(512),
   download_type        int(1) not null default 1,
   file_type            varchar(32),
   file_size            int default 0,
   show_order           int not null default 1,
   primary key (id),
   KEY index_softwareid(software_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_system                                             */
/*==============================================================*/
create table ut_system
(
   id                   int not null auto_increment,
   content              varbinary(2000),
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_theme                                              */
/*==============================================================*/
create table ut_theme
(
   id                   int not null auto_increment,
   title                varchar(256) not null,
   image_url            varchar(512),
   thumb_image_url      varchar(512),
   recommend_level      int(1),
   good_count           int not null default 0,
   normal_count         int not null default 0,
   bad_count            int not null default 0,
   click_count          int not null default 0,
   down_count           int not null default 0,
   real_click_count     int not null default 0,
   real_down_count      int not null default 0,
   comment_flag         int(1) not null default 1,
   fee_type             int(1),
   fee_detail           varchar(64),
   manufacturer         varchar(64),
   introduction         text,
   install_tutorial     text,
   publish_status       int(1) not null default 2,
   base_upload_path     varchar(128) not null,
   creator_id           int not null,
   create_date          datetime not null,
   rename_flag          int(1) default 1,
   mobile_platform_ids  varchar(1024) default '',
   universal_flag_contain int(1) default 0,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_theme_comment                                      */
/*==============================================================*/
create table ut_theme_comment
(
   id                   int not null auto_increment,
   theme_id             int not null,
   comment              varchar(2000) not null,
   status               int(1) not null default 2,
   create_user_id       int,
   create_user_pet_name varchar(32),
   create_date          datetime not null,
   primary key (id),
   KEY index_themeid(theme_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_theme_package                                      */
/*==============================================================*/
create table ut_theme_package
(
   id                   int not null auto_increment,
   theme_id             int not null,
   mobile_platform_id   int not null,
   mobile_screen_id     int,
   universal_flag       int(1) default 0,
   agent_description    text,
   download_url         varchar(512) not null,
   download_additional_url varchar(512),
   download_type        int(1) not null default 1,
   file_type            varchar(32),
   file_size            int default 0,
   show_order           int not null default 1,
   primary key (id),
   KEY index_themeid(theme_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_ubb_tags                                           */
/*==============================================================*/
create table ut_ubb_tags
(
   id                   int not null auto_increment,
   title                varchar(128) not null,
   content              text not null,
   show_order           int(6) not null default 1,
   create_date          datetime not null,
   create_id            int default 0,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_user                                               */
/*==============================================================*/
create table ut_user
(
   id                   int not null auto_increment,
   login_name           varchar(64),
   password             varchar(64) not null,
   pet_name             varchar(64) not null,
   utid                 varchar(16) not null,
   experience           int default 0,
   head_image_url       varchar(256),
   gender               int(1),
   area_name            varchar(256),
   area_id              int,
   modile_phone_number  varchar(32),
   qq                   varchar(128),
   msn                  varchar(128),
   mail                 varchar(256),
   height               varchar(32),
   blood_type           varchar(4),
   birthday             varchar(32),
   hobby                varchar(256),
   education            varchar(32),
   profession           varchar(32),
   company              varchar(256),
   forum_sign           varchar(256),
   authentication_level int(1) not null default 1,
   mobile_phone_id      int,
   mobile_phone_agent   varchar(64),
   cms_role             int(1) not null default 9,
   forum_role           int(1) not null default 9,
   last_login_date      datetime,
   login_count          int not null default 0,
   post_count           int not null default 0,
   album_img_count      int default 0,
   status               int(1) not null default 1,
   create_date          datetime not null,
   primary key (id)
)
type = myisam
auto_increment = 1002;

/*==============================================================*/
/* Table: ut_user_action_state                                  */
/*==============================================================*/
create table ut_user_action_state
(
   id                   int not null auto_increment,
   user_id              int not null,
   action_type          int not null,
   action               varchar(1000),
   create_date          datetime not null,
   primary key (id),
   KEY index_userid(user_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_user_album_group                                   */
/*==============================================================*/
create table ut_user_album_group
(
   id                   int not null auto_increment,
   user_id              int not null,
   group_name           varchar(64) not null,
   visible_level        int(1) not null default 1,
   img_count            int not null default 0,
   create_date          datetime not null,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_user_album_group_img                               */
/*==============================================================*/
create table ut_user_album_group_img
(
   id                   int not null auto_increment,
   user_id              int not null,
   album_group_id       int,
   title                varchar(64),
   description          varchar(1024),
   preview_img_url      varchar(256),
   real_img_url         varchar(256) not null,
   img_height           int not null default 0,
   img_width            int not null default 0,
   file_size            int not null default 0,
   status               int(1) not null default 2,
   create_date          datetime,
   primary key (id),
   KEY index_userid(user_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_user_attention_friend                              */
/*==============================================================*/
create table ut_user_attention_friend
(
   id                   int not null auto_increment,
   user_id              int not null,
   attention_user_id    int not null,
   primary key (id),
   KEY index_attention_user_id(attention_user_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_user_black_list                                    */
/*==============================================================*/
create table ut_user_black_list
(
   id                   int not null auto_increment,
   user_id              int not null,
   black_user_id        int not null,
   primary key (id),
   KEY index_userid(user_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_user_collection                                    */
/*==============================================================*/
create table ut_user_collection
(
   id                   int not null auto_increment,
   user_id              int not null,
   collection_type      int(1) not null,
   data_id              int not null,
   data_title           varchar(128) not null,
   link                 varchar(256),
   create_date          datetime,
   primary key (id),
   KEY index_userid(user_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_user_forum_channel                                 */
/*==============================================================*/
create table ut_user_forum_channel
(
   id                   int not null auto_increment,
   user_id              int not null,
   channel_id           int not null,
   create_date          datetime not null,
   post_id              int,
   primary key (id),
   KEY index_channelid(channel_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_user_friend                                        */
/*==============================================================*/
create table ut_user_friend
(
   id                   int not null auto_increment,
   user_id              int not null,
   friend_user_id       int not null,
   friend_group_id      int,
   primary key (id),
   KEY index_userid(user_id),
   KEY index_groupid(friend_group_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_user_friend_group                                  */
/*==============================================================*/
create table ut_user_friend_group
(
   id                   int not null auto_increment,
   user_id              int not null,
   group_name           varchar(32) not null,
   friend_count         int not null default 0,
   create_date          datetime not null,
   primary key (id),
   KEY index_userid(user_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_user_honour                                        */
/*==============================================================*/
create table ut_user_honour
(
   id                   int not null auto_increment,
   honour_name          varchar(64) not null,
   level                varchar(64) not null,
   experience           int not null default 0,
   honour_img           varchar(256),
   primary key (id),
   KEY index_experience(experience)
)
type = myisam;

/*==============================================================*/
/* Table: ut_user_login_cms_log                                 */
/*==============================================================*/
create table ut_user_login_cms_log
(
   id                   int not null auto_increment,
   user_id              int not null,
   user_login_name      varchar(32) not null,
   login_ip             varchar(32) not null,
   login_date           datetime not null,
   primary key (id),
   KEY index_userid(user_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_user_menu                                          */
/*==============================================================*/
create table ut_user_menu
(
   id                   int not null auto_increment,
   menu_id              int not null,
   user_id              int not null,
   primary key (id),
   KEY index_userid(user_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_user_message_board                                 */
/*==============================================================*/
create table ut_user_message_board
(
   id                   int not null auto_increment,
   user_id              int not null,
   message_text         varchar(512) not null,
   create_user_id       int,
   create_user_pet_name varchar(32),
   create_date          datetime,
   primary key (id),
   KEY index_userid(user_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_user_message_box                                   */
/*==============================================================*/
create table ut_user_message_box
(
   id                   int not null auto_increment,
   user_id              int not null,
   message_content      varchar(1000) not null,
   from_user_id         int,
   from_user_pet_name   varchar(64),
   message_type         int(1) not null default 1,
   read_flag            int(1) not null default 2,
   create_date          datetime not null,
   primary key (id),
   KEY index_userid(user_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_user_space                                         */
/*==============================================================*/
create table ut_user_space
(
   id                   int not null auto_increment,
   user_id              int not null,
   visible_level        int(1) not null default 1,
   password             varchar(64),
   message_board_status int(1) not null default 1,
   message_count        int not null default 0,
   salutatory           varchar(512),
   click_count          int not null default 0,
   today_count          int not null default 0,
   last_visit_date      date,
   primary key (id),
   KEY index_userid(user_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_user_space_visit_log                               */
/*==============================================================*/
create table ut_user_space_visit_log
(
   id                   int not null auto_increment,
   user_id              int not null,
   visit_user_id        int not null,
   visit_user_pet_name  varchar(32),
   visit_date           datetime not null,
   primary key (id),
   KEY index_userid_visituserid(user_id, visit_user_id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_user_template                                      */
/*==============================================================*/
create table ut_user_template
(
   id                   int not null auto_increment,
   page_type            int(1) not null default 1,
   content              text,
   default_content      text,
   primary key (id)
)
type = myisam;

/*==============================================================*/
/* Table: ut_visit_log                                          */
/*==============================================================*/
create table ut_visit_log
(
   id                   int not null auto_increment,
   ip                   varchar(32) not null,
   channel_id           int,
   cookie_id            varchar(32),
   visit_uri            varchar(512),
   agent                varchar(256),
   referer              varchar(512),
   friend_site_id       int,
   visit_date           datetime not null,
   mobile_flag          int(1) not null default 1,
   primary key (id),
   KEY index_ip_cookieid(ip, cookie_id)
)
type = myisam;

/*==============================================================*/
/* Index: ut_idx_visit_log_visit_date                           */
/*==============================================================*/
create index ut_idx_visit_log_visit_date on ut_visit_log
(
   visit_date
);

/*==============================================================*/
/* Table: ut_website_attribute                                  */
/*==============================================================*/
create table ut_website_attribute
(
   id                   int not null auto_increment,
   channel_module_id    int,
   attribute_name       varchar(256) not null,
   attribute_value      varchar(2000) not null,
   memo                 varchar(1000),
   primary key (id),
   KEY index_attribute_name(attribute_name)
)
type = myisam;

drop table if exists ut_menu_acl;

CREATE TABLE ut_menu_acl (                            
    id int(11) NOT NULL AUTO_INCREMENT,                  
    controller char(100) NOT NULL,                       
    action char(100) NOT NULL,                           
    PRIMARY KEY (`id`)                                     
) ENGINE=MyISAM;

drop table if exists ut_menu_acl_map;

CREATE TABLE ut_menu_acl_map (                        
	id int(11) NOT NULL AUTO_INCREMENT,                  
	menu_id int(11) NOT NULL DEFAULT '0',                
	acl_id int(11) NOT NULL DEFAULT '0',                 
    PRIMARY KEY (`id`)                                     
 ) ENGINE=MyISAM;
