/**
 * @author jiangsj
 * @version 1.0
 */
(function($){
	window.LayoutAddUBB = function(){
		this.init();
	};
	window.LayoutAddUBB.prototype = {
		author:'jiangsj',
		url:{
			line:'./index.php?r=Layout.ajaxline',
			sort:'./index.php?r=Layout.ajaxsort',
			module:'./index.php?r=Layout.changemodule'
		},
		init:function(){
			var me = this;
			this.dom();
			me.getline(me.init_channel.val(),me.init_line.val());
			me.getsort(me.line_id.val(),me.init_order.val());
			
			me.parent_id.change(function(){
				var id = $(this).val();
				me.getline(id,null);
				me.getsort(me.line_id.val(),null);
			});
			
			me.line_id.change(function(){
				var id = $(this).val();
				me.getsort(id,null);
			});
		},
		dom:function(){
			this.init_channel = $("#init_channel");
			this.init_line = $("#init_line");
			this.init_order = $("#init_order");
			this.parent_id = $("#parent_id");
			this.line_id = $("#line_id");
			this.show_order = $("#show_order");
		},
		getline:function(channelid,set){
			var me = this;
			$.ajax({
				type:'get',
				async:false,
				url:me.url.line+"&rd="+Math.random(),
				data:{channel_id:channelid},
				dataType:'json',
				success:function(data){
					var html = '';
					var i = 1;
					$(data).each(function(k,v){
						if (v.system_flag != 1) {
							html += '<option value="' + v.id + '"';
							if (set == v.id) {
								html += ' selected';
							}
							html += '>' + i + '</option>';
						}
						 i++;
					});	
					me.line_id.empty().html(html);
				}
			});
		},
		getsort:function(lineid,set){
			var me = this;
			$.ajax({
				type:'get',
				async:false,
				url:me.url.sort+"&rd="+Math.random(),
				data:{line_id:lineid},
				dataType:'json',
				success:function(data){
					var html = '';
					$(data).each(function(k,v){
						
						html+= '<option value="'+v+'"';
						 if(set == v){
						 	html+= ' selected';
						 }
						 html+= '>'+v+'</option>';
					});	
					me.show_order.empty().html(html);
				}
			});
		}
	};
	
    $(document).ready(function(){
		new LayoutAddUBB();
        
        /*
         * jquery验证
         */
        var validate = $("#channelForm").validate({
            rules: {
                'data[Channel][channel_text]': {
					required:true
				},
				'data[Channel][parent_id]':{
					required:true,
					number:true
				},
				'data[Channel][line_id]':{
					required:true,
					number:true
				}
            },
            messages: {
                'data[Channel][channel_text]': '请输入UBB代码',
				'data[Channel][parent_id]': '请选择上级频道',
				'data[Channel][line_id]': '请选择行号'
            },
            errorPlacement: function(error, element){
                $("#span_" + element.attr("id")).html(error).attr("class", "error");
            },
            errorClass: "invalid",
            success: function(label){
                label.html("&nbsp;&nbsp;&nbsp;").attr("class", "valid");
            }
        });
        $("#channelForm").submit(function(){
            if (validate.numberOfInvalids() <= 0) {
                $(this).ajaxSubmit({
                    success: function(str){
                        var data = eval('(' + str + ')');
                        if (data.status == 1) {
                            window.frames['cpanelLayout'].location.reload();
							//window.frames['leftLayout'].location.reload();
                            $.successUI({
								message:"修改成功！",
								showOverlay:true,
								autoHide:true,
								confirm:function(){setTimeout($.unblockUI, 300);}
							});
							
                        }
                        else {
                           $.errorUI({
								message:"修改失败！",
								showOverlay:true
							});
                        }
                    }
                });
            }else{
				$.errorUI({
					message:"UBB内容不能为空！",
					showOverlay:true
				});
			}
            return false;
        });
    });
})(jQuery);
