/**
 * james
 * @param {Object} "#channel_text"
 */
	$(document).ready(function(){
		
		var $Editor = $("#channel_text").addClass("cleditorTextarea").cleditor({
		
          width:        "100%", // width not including margins, borders or padding
          height:       240, // height not including margins, borders or padding
          controls:     // controls to add to the toolbar
                        "bold italic underline break | " +
                        " undo redo | " +
                        " image link file |",
          
          useCSS:       false, // use CSS to style HTML when possible (not supported in ie)
          docType:      // Document type contained within the editor
                        '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">',
          docCSSFile:   // CSS file used to style the document contained within the editor
                        "", 
          bodyStyle:    // style to assign to document body contained within the editor
                        "margin:4px; font:10pt Arial,Verdana; cursor:text",
		  customBind:function(editor)
		  {
		  	$.ajax({
				url:"index.php?r=Layout.getUbbTemplate",
				type:"get",
				data:{template:'basic-function'},
				cache:false,
				success:function(html){
					$("#ubbArea").empty();
					$(html).appendTo("#ubbArea");
					$(".ubbcode").bind('click',function(){
						$.cleditor.cRange(editor);
						$.cleditor.exec(editor,$(this).text());
					});
				}
			});
			
			$(".ubbmenu").click(function(){
				var btn_name = $(this).text();
				if($(this).attr("value")!=''){
					$.ajax({
						url:"index.php?r=Layout.getUbbTemplate",
						type:"get",
						data:{template:$(this).attr("value")},
						cache:false,
						success:function(html){
							$(".ubbTool").slideUp(1000);
							$("#ubbArea").empty();
							$("#ubbmenu-status").html(btn_name);
							$(html).appendTo("#ubbArea");
							$(".ubbcode").bind('click',function(){
								$.cleditor.cRange(editor);
								$.cleditor.exec(editor,$(this).text());
							});
							
							//绑定资源调用向导
							$(".useubbwizard").bind('click',function(){
								var channel_id=0,channel_text=$(this).attr("value");
								if(channel_text == '' || channel_text== undefined) return false;
								var isAll = false;
								var channels = new Array();
								
								switch(channel_text)
								{
									case "article":
										channel_id = 1;
										break;
									case "software":
										channel_id = 2;
										break;
									case "theme":
										channel_id = 8;
										break;
									case "game":
										channel_id = 3;
										break;
									case "picture":
										channel_id = 9;
										break;
									case "forum":
										channel_id = 5;
										break;
									case "forum2":
										channel_id = 5;
										break;
									case "forum3":
										channel_id = 5;
										break;
									case "link":
										channel_id = 7;
										break;
									case "music":
										channel_id = 10;
										break;
								}
								$.ajax({
									url:"index.php?r=Layout.getChannelByModule",
									type:"get",
									data:{channel_module_id:channel_id},
									cache:false,
									success:function(ChannelResponseText){
										var fc = $.fn.firesbox.start(ChannelResponseText, {hideOnContentClick: false});
										//绑定checkall事件
										fc.find("#checkall").unbind("click").bind("click", function(){
											if($(this).attr("checked")){
												$(".channelbox").each(function(){
													$(this).attr("checked",true);
												});
												isAll = true;
											}else{
												$(".channelbox").each(function(){
													$(this).attr("checked",false);
												});
												isAll = false;
											}
										});
										//绑定单个选框事件
										fc.find(".channelbox").unbind("click").bind("click", function(){
											var channel_id = $(this).val();
											if($(this).attr("checked")){
												if($.inArray(channel_id,channels) == -1)
												{
													channels.push(channel_id);
												}
											}else{
												if($.inArray(channel_id,channels) != -1)
												{
													channels = $.grep(channels,function(n,i){return n!=channel_id;});
												}
												
												if(isAll){
													isAll = false;
													$("#checkall").attr("checked",false);
													$(".channelbox").each(function(){
														if($(this).attr("checked")){
															if($.inArray($(this).val(),channels) == -1)
															{
																channels.push($(this).val());
															}
														}
													});
												}
											}
										});
										
										fc.find(".nextBtn").unbind("click").bind("click", function(){
											if(!isAll && channels.length<1){
												alert("请选择频道！");
												return false;
											}
											
											var channel = "";
											if(isAll){
												channel = "0";
											}else{
												$(channels).each(function(k,v){
													if(channel == ""){
														channel = v;
													}else{
														channel+="|"+v;
													}
												});
											}
											switch(channel_text)
											{
												case "article":
													bindArticle(editor,channel);
													break;
												case "software":
													bindSoftware(editor,channel);
													break;
												case "theme":
													bindTheme(editor,channel);
													break;
												case "game":
													bindGame(editor,channel);
													break;
												case "picture":
													bindPicture(editor,channel);
													break;
												case "forum":
													bindForum(editor,channel);
													break;
												case "forum2":
													bindForum2(editor,channel);
													break;
												case "forum3":
													bindForum3(editor,channel);
													break;
												case "link":
													bindLink(editor,channel);
													break;
												case "music":
													bindMusic(editor,channel);
													break;
											}
											
										});
									}
								});
								
							});
							
							//绑定资源新增向导
							$(".useubbwizard-new").bind('click',function(){
								var channel_id=0,channel_text=$(this).attr("value");
								if(channel_text == '' || channel_text== undefined) return false;
								
								var isAll = false;
								var channels = new Array();
								
								switch(channel_text)
								{
									case "article":
										channel_id = 1;
										break;
									case "software":
										channel_id = 2;
										break;
									case "theme":
										channel_id = 8;
										break;
									case "game":
										channel_id = 3;
										break;
									case "picture":
										channel_id = 9;
										break;
									case "bbs":
										channel_id = 5;
										break;
									case "link":
										channel_id = 7;
										break;
								}
								
								$.ajax({
									url:"index.php?r=Layout.getChannelByModule",
									type:"get",
									data:{channel_module_id:channel_id},
									cache:false,
									success:function(ChannelResponseText){
										var fc = $.fn.firesbox.start(ChannelResponseText, {hideOnContentClick: false});
										//绑定checkall事件
										fc.find("#checkall").unbind("click").bind("click", function(){
											if($(this).attr("checked")){
												$(".channelbox").each(function(){
													$(this).attr("checked",true);
												});
												isAll = true;
											}else{
												$(".channelbox").each(function(){
													$(this).attr("checked",false);
												});
												isAll = false;
											}
										});
										//绑定单个选框事件
										fc.find(".channelbox").unbind("click").bind("click", function(){
											var channel_id = $(this).val();
											if($(this).attr("checked")){
												if($.inArray(channel_id,channels) == -1)
												{
													channels.push(channel_id);
												}
											}else{
												if($.inArray(channel_id,channels) != -1)
												{
													channels = $.grep(channels,function(n,i){return n!=channel_id;});
												}
												
												if(isAll){
													isAll = false;
													$("#checkall").attr("checked",false);
													$(".channelbox").each(function(){
														if($(this).attr("checked")){
															if($.inArray($(this).val(),channels) == -1)
															{
																channels.push($(this).val());
															}
														}
													});
												}
											}
										});
										
										fc.find(".nextBtn").unbind("click").bind("click", function(){
											if(!isAll && channels.length<1){
												alert("请选择频道！");
												return false;
											}
											
											var channel = "";
											if(isAll){
												channel = "0";
											}else{
												$(channels).each(function(k,v){
													if(channel == ""){
														channel = v;
													}else{
														channel+="|"+v;
													}
												});
											}
											
											bindResourcesNew(editor,channel,channel_text);
											
										});
									}
								});
								
							});
							
							//绑定广告
							$(".useubbADwizard").bind('click',function(){
								bindADWizard(editor);
							});
							
							$(".useubbsearchwizard").bind('click',function(){
								$.ajax({
									url:"index.php?r=Layout.getSearchInputWizard",
									type:"get",
									data:{},
									cache:false,
									success:function(HtmlResponseText){
										var fc = $.fn.firesbox.start(HtmlResponseText, {hideOnContentClick: false});
										
										 fc.find(".cancelBtn").unbind("click").bind('click',function(){
											$.fn.firesbox.close();
										});
										fc.find(".insertBtn").unbind("click").bind('click',function(){
											var input_name = $("#firesbox_content").find("#input-name").val();
											var input_size = $("#firesbox_content").find("#input-size").val();
											var input_value = $("#firesbox_content").find("#input-value").val();
											if(input_name == ""){
												alert("搜索框名不能为空！");
												return false;
											}
											$.cleditor.cRange(editor);
											$.cleditor.exec(editor,"[input name="+input_name+" size="+input_size+" value="+input_value+"]");
											
											$.fn.firesbox.close();
										});
									}
								});
							});
							
							$(".useubbsearchbuttonwizard").bind('click',function(){
								var channel_id=0,channel_text=$(this).attr("value");
								if(channel_text == '' || channel_text== undefined) return false;
								var $channel_id = 0;
								switch(channel_text)
								{
									case "article":
										channel_id = 1;
										break;
									case "software":
										channel_id = 2;
										break;
									case "theme":
										channel_id = 8;
										break;
									case "game":
										channel_id = 3;
										break;
									case "picture":
										channel_id = 9;
										break;
									case "forum":
										channel_id = 5;
										break;
								}
								$.ajax({
									url:"index.php?r=Layout.getSearchChannelByModule",
									type:"get",
									data:{channel_module_id:channel_id},
									cache:false,
									success:function(ChannelResponseText){
										var fc = $.fn.firesbox.start(ChannelResponseText, {hideOnContentClick: false});
										//绑定checkall事件
										fc.find(".channelbox").unbind("click").bind("click", function(){
											if ($(this).attr("checked")) {
												$channel_id = $(this).val();
											}
										});
										fc.find(".nextBtn").unbind("click").bind("click", function(){
											switch(channel_text)
											{
												case "article":
													bindSearchArticle(editor,$channel_id);
													break;
												case "software":
													bindSearchSoftware(editor,$channel_id);
													break;
												case "theme":
													bindSearchTheme(editor,$channel_id);
													break;
												case "game":
													bindSearchGame(editor,$channel_id);
													break;
												case "picture":
													bindSearchPicture(editor,$channel_id);
													break;
												case "forum":
													bindSearchForum(editor,$channel_id);
													break;
											}
										});
									}
								});
								
							});
							
						}
					});
				}
			});
		  }
        });
		
		$(".showtool").click(function(){
			if($(".ubbTool").is(":visible") !== false){
				$(".ubbTool").slideUp(300);
			}else{
				$(".ubbTool").slideDown(300);
			}
		});
		
		function bindArticle(editor,channel)
		{ 
			$.ajax({
				url:"index.php?r=Layout.getArticleWizard",
				type:"get",
				data:{},
				cache:false,
				success:function(HttpResponseText){
					$("#firesbox_content").empty();
					$(HttpResponseText).appendTo("#firesbox_content");
					$("#firesbox_content").find(".cancelBtn").unbind("click").bind('click',function(){
						$.fn.firesbox.close();
					});
					$("#firesbox_content").find(".insertBtn").unbind("click").bind('click',function(){
						var record_count = $("#firesbox_content").find("#record-count").val();
						var ordering = $("#firesbox_content").find("#ordering").val();
						var title_length = $("#firesbox_content").find("#title-length").val();
						var show_channel = $("#firesbox_content").find("#show-channel").val();
						if(record_count == "") record_count = 20;
						if(title_length == "") title_length = 0;
						$.cleditor.cRange(editor);
						$.cleditor.exec(editor,"[article="+channel+"_"+record_count+"_"+ordering+"_"+title_length+"_"+show_channel+"]");
						
						$.fn.firesbox.close();
					});
				}
			});
			
		}//end article
		
		function bindSoftware(editor,channel)
		{ 
			$.ajax({
				url:"index.php?r=Layout.getSoftwareWizard",
				type:"get",
				data:{},
				cache:false,
				success:function(HttpResponseText){
					$("#firesbox_content").empty();
					$(HttpResponseText).appendTo("#firesbox_content");
					$("#firesbox_content").find(".cancelBtn").unbind("click").bind('click',function(){
						$.fn.firesbox.close();
					});
					$("#firesbox_content").find("#ordering").unbind("change").bind('change',function(){
						if($(this).val() == 5){
							$("#firesbox_content").find("#show-ordering-day").fadeIn("slow");
						}else{
							$("#firesbox_content").find("#show-ordering-day").fadeOut("slow");
						}
					});
					
					$("#firesbox_content").find(".insertBtn").unbind("click").bind('click',function(){
						var record_count = $("#firesbox_content").find("#record-count").val();
						var ordering = $("#firesbox_content").find("#ordering").val();
						var title_length = $("#firesbox_content").find("#title-length").val();
						var show_channel = $("#firesbox_content").find("#show-channel").val();
						var ordering_day = $("#firesbox_content").find("#ordering-day").val();
						if(record_count == "") record_count = 20;
						if(title_length == "") title_length = 0;
						if(ordering == "5" && ordering_day==""){
							alert("请填写天数！");
							return false;
						}else if(ordering == "5" && ordering_day >0){
							ordering+= "|"+ordering_day;
						}
						$.cleditor.cRange(editor);
						$.cleditor.exec(editor,"[software="+channel+"_"+record_count+"_"+ordering+"_"+title_length+"_"+show_channel+"]");
						
						$.fn.firesbox.close();
					});
				}
			});
			
		}//end software
		
		function bindTheme(editor,channel)
		{ 
			$.ajax({
				url:"index.php?r=Layout.getThemeWizard",
				type:"get",
				data:{},
				cache:false,
				success:function(HttpResponseText){
					$("#firesbox_content").empty();
					$(HttpResponseText).appendTo("#firesbox_content");
					$("#firesbox_content").find(".cancelBtn").unbind("click").bind('click',function(){
						$.fn.firesbox.close();
					});
					$("#firesbox_content").find("#ordering").unbind("change").bind('change',function(){
						if($(this).val() == 5){
							$("#firesbox_content").find("#show-ordering-day").fadeIn("slow");
						}else{
							$("#firesbox_content").find("#show-ordering-day").fadeOut("slow");
						}
					});
					
					$("#firesbox_content").find(".insertBtn").unbind("click").bind('click',function(){
						var record_count = $("#firesbox_content").find("#record-count").val();
						var ordering = $("#firesbox_content").find("#ordering").val();
						var title_length = $("#firesbox_content").find("#title-length").val();
						var show_channel = $("#firesbox_content").find("#show-channel").val();
						var ordering_day = $("#firesbox_content").find("#ordering-day").val();
						if(record_count == "") record_count = 20;
						if(title_length == "") title_length = 0;
						if(ordering == "5" && ordering_day==""){
							alert("请填写天数！");
							return false;
						}else if(ordering == "5" && ordering_day >0){
							ordering+= "|"+ordering_day;
						}
						$.cleditor.cRange(editor);
						$.cleditor.exec(editor,"[theme="+channel+"_"+record_count+"_"+ordering+"_"+title_length+"_"+show_channel+"]");
						
						$.fn.firesbox.close();
					});
				}
			});
			
		}//end theme
		
		function bindGame(editor,channel)
		{ 
			$.ajax({
				url:"index.php?r=Layout.getGameWizard",
				type:"get",
				data:{},
				cache:false,
				success:function(HttpResponseText){
					$("#firesbox_content").empty();
					$(HttpResponseText).appendTo("#firesbox_content");
					$("#firesbox_content").find(".cancelBtn").unbind("click").bind('click',function(){
						$.fn.firesbox.close();
					});
					$("#firesbox_content").find("#ordering").unbind("change").bind('change',function(){
						if($(this).val() == 5){
							$("#firesbox_content").find("#show-ordering-day").fadeIn("slow");
						}else{
							$("#firesbox_content").find("#show-ordering-day").fadeOut("slow");
						}
					});
					
					$("#firesbox_content").find(".insertBtn").unbind("click").bind('click',function(){
						var record_count = $("#firesbox_content").find("#record-count").val();
						var ordering = $("#firesbox_content").find("#ordering").val();
						var title_length = $("#firesbox_content").find("#title-length").val();
						var show_channel = $("#firesbox_content").find("#show-channel").val();
						var ordering_day = $("#firesbox_content").find("#ordering-day").val();
						if(record_count == "") record_count = 20;
						if(title_length == "") title_length = 0;
						if(ordering == "5" && ordering_day==""){
							alert("请填写天数！");
							return false;
						}else if(ordering == "5" && ordering_day >0){
							ordering+= "|"+ordering_day;
						}
						$.cleditor.cRange(editor);
						$.cleditor.exec(editor,"[game="+channel+"_"+record_count+"_"+ordering+"_"+title_length+"_"+show_channel+"]");
						
						$.fn.firesbox.close();
					});
				}
			});
			
		}//end game
		
		function bindPicture(editor,channel)
		{ 
			$.ajax({
				url:"index.php?r=Layout.getPictureWizard",
				type:"get",
				data:{},
				cache:false,
				success:function(HttpResponseText){
					$("#firesbox_content").empty();
					$(HttpResponseText).appendTo("#firesbox_content");
					$("#firesbox_content").find(".cancelBtn").unbind("click").bind('click',function(){
						$.fn.firesbox.close();
					});
					$("#firesbox_content").find("#ordering").unbind("change").bind('change',function(){
						if($(this).val() == 5){
							$("#firesbox_content").find("#show-ordering-day").fadeIn("slow");
						}else{
							$("#firesbox_content").find("#show-ordering-day").fadeOut("slow");
						}
					});
					
					$("#firesbox_content").find(".insertBtn").unbind("click").bind('click',function(){
						var record_count = $("#firesbox_content").find("#record-count").val();
						var ordering = $("#firesbox_content").find("#ordering").val();
						var title_length = $("#firesbox_content").find("#title-length").val();
						var show_channel = $("#firesbox_content").find("#show-channel").val();
						var ordering_day = $("#firesbox_content").find("#ordering-day").val();
						if(record_count == "") record_count = 20;
						if(title_length == "") title_length = 0;
						if(ordering == "5" && ordering_day==""){
							alert("请填写天数！");
							return false;
						}else if(ordering == "5" && ordering_day >0){
							ordering+= "|"+ordering_day;
						}
						$.cleditor.cRange(editor);
						$.cleditor.exec(editor,"[picture="+channel+"_"+record_count+"_"+ordering+"_"+title_length+"_"+show_channel+"]");
						
						$.fn.firesbox.close();
					});
				}
			});
			
		}//end picture

		function bindForum(editor,channel)
		{ 
			$.ajax({
				url:"index.php?r=Layout.getForumWizard",
				type:"get",
				data:{},
				cache:false,
				success:function(HttpResponseText){
					$("#firesbox_content").empty();
					$(HttpResponseText).appendTo("#firesbox_content");
					$("#firesbox_content").find(".cancelBtn").unbind("click").bind('click',function(){
						$.fn.firesbox.close();
					});
					$("#firesbox_content").find(".insertBtn").unbind("click").bind('click',function(){
						var record_count = $("#firesbox_content").find("#record-count").val();
						var ordering = $("#firesbox_content").find("#ordering").val();
						var title_length = $("#firesbox_content").find("#title-length").val();
						var show_channel = $("#firesbox_content").find("#show-channel").val();
						if(record_count == "") record_count = 20;
						if(title_length == "") title_length = 0;
						$.cleditor.cRange(editor);
						$.cleditor.exec(editor,"[bbs="+channel+"_"+record_count+"_"+ordering+"_"+title_length+"_"+show_channel+"]");
						
						$.fn.firesbox.close();
					});
				}
			});
			
		}//end forum
		
		function bindForum2(editor,channel)
		{ 
			$.ajax({
				url:"index.php?r=Layout.getForumWizard&type=2",
				type:"get",
				data:{},
				cache:false,
				success:function(HttpResponseText){
					$("#firesbox_content").empty();
					$(HttpResponseText).appendTo("#firesbox_content");
					$("#firesbox_content").find(".cancelBtn").unbind("click").bind('click',function(){
						$.fn.firesbox.close();
					});
					$("#firesbox_content").find(".insertBtn").unbind("click").bind('click',function(){
						var record_count = $("#firesbox_content").find("#record-count").val();
						var ordering = $("#firesbox_content").find("#ordering").val();
						var title_length = $("#firesbox_content").find("#title-length").val();
						var show_channel = $("#firesbox_content").find("#show-channel").val();
						if(record_count == "") record_count = 20;
						if(title_length == "") title_length = 0;
						$.cleditor.cRange(editor);
						$.cleditor.exec(editor,"[bbsj="+channel+"_"+record_count+"_"+ordering+"_"+title_length+"_"+show_channel+"]");
						
						$.fn.firesbox.close();
					});
				}
			});
			
		}//end forum2
		
		
		function bindForum3(editor,channel)
		{ 
			$.ajax({
				url:"index.php?r=Layout.getForumWizard&type=3",
				type:"get",
				data:{},
				cache:false,
				success:function(HttpResponseText){
					$("#firesbox_content").empty();
					$(HttpResponseText).appendTo("#firesbox_content");
					$("#firesbox_content").find(".cancelBtn").unbind("click").bind('click',function(){
						$.fn.firesbox.close();
					});
					$("#firesbox_content").find(".insertBtn").unbind("click").bind('click',function(){
						var record_count = $("#firesbox_content").find("#record-count").val();
						var ordering = $("#firesbox_content").find("#ordering").val();
						var title_length = $("#firesbox_content").find("#title-length").val();
						var show_channel = $("#firesbox_content").find("#show-channel").val();
						if(record_count == "") record_count = 20;
						if(title_length == "") title_length = 0;
						$.cleditor.cRange(editor);
						$.cleditor.exec(editor,"[bbsd="+channel+"_"+record_count+"_"+ordering+"_"+title_length+"_"+show_channel+"]");
						
						$.fn.firesbox.close();
					});
				}
			});
			
		}//end forum3
		
		
		function bindLink(editor,channel)
		{ 
			$.ajax({
				url:"index.php?r=Layout.getLinkWizard",
				type:"get",
				data:{},
				cache:false,
				success:function(HttpResponseText){
					$("#firesbox_content").empty();
					$(HttpResponseText).appendTo("#firesbox_content");
					$("#firesbox_content").find(".cancelBtn").unbind("click").bind('click',function(){
						$.fn.firesbox.close();
					});
					$("#firesbox_content").find(".insertBtn").unbind("click").bind('click',function(){
						var record_count = $("#firesbox_content").find("#record-count").val();
						var ordering = $("#firesbox_content").find("#ordering").val();
						var title_length = $("#firesbox_content").find("#title-length").val();
						var show_br = $("#firesbox_content").find("#show-br").val();
						var br_count = $("#firesbox_content").find("#br-count").val();
						var spacer = $("#firesbox_content").find("#spacer").val();
						if(record_count == "") record_count = 20;
						if(title_length == "") title_length = 0;
						$.cleditor.cRange(editor);
						$.cleditor.exec(editor,"[link="+channel+"_"+record_count+"_"+ordering+"_"+title_length+"_"+show_br+"_"+br_count+"_"+spacer+"]");
						
						$.fn.firesbox.close();
					});
				}
			});
			
		}//end link
		
		function bindResourcesNew(editor,channel,module)
		{ 
			$.ajax({
				url:"index.php?r=Layout.getResourcesNewWizard",
				type:"get",
				data:{module:module},
				cache:false,
				success:function(HttpResponseText){
					$("#firesbox_content").empty();
					$(HttpResponseText).appendTo("#firesbox_content");
					$("#firesbox_content").find(".cancelBtn").unbind("click").bind('click',function(){
						$.fn.firesbox.close();
					});
					$("#firesbox_content").find(".insertBtn").unbind("click").bind('click',function(){
						var record_count = $("#firesbox_content").find("#record-count").val();
						var ordering = $("#firesbox_content").find("#ordering").val();
						var show_channel = $("#firesbox_content").find("#show-channel").val();
						if(record_count == "") record_count = 20;
						$.cleditor.cRange(editor);
						$.cleditor.exec(editor,"["+module+"="+channel+"_"+ordering+"_"+record_count+"_"+show_channel+"]");
						
						$.fn.firesbox.close();
					});
				}
			});
			
		}//end ResourcesNew
		
		function bindADWizard(editor)
		{
			$.ajax({
				url:"index.php?r=Layout.getADWizard",
				type:"get",
				data:{},
				cache:false,
				success:function(HttpResponseText){
					var fc = $.fn.firesbox.start(HttpResponseText, {hideOnContentClick: false});
					fc.find(".cancelBtn").unbind("click").bind('click',function(){
						//清空cookie
						$.cookie("ADCOOKIES",null);
						$.fn.firesbox.close();
					});
					fc.find(".insertBtn").unbind("click").bind('click',function(){
						var ad_cookies = $.cookie("ADCOOKIES");
						if(ad_cookies == "" ||　ad_cookies == undefined){
							alert("请先选择要投放的广告！");
							return false;
						}
						var record_count = $("#firesbox_content").find("#record-count").val();
						if(record_count == "") record_count = 20;
						$.cleditor.cRange(editor);
						$.cleditor.exec(editor,"[ad]"+ad_cookies+"_"+record_count+"[/ad]");
						//清空cookie
						$.cookie("ADCOOKIES",null);
						$.fn.firesbox.close();
					});
				}
			});
		}
		
		function bindMusic(editor,channel)
		{ 
			$.ajax({
				url:"index.php?r=Layout.getMusicWizard",
				type:"get",
				data:{},
				cache:false,
				success:function(HttpResponseText){
					$("#firesbox_content").empty();
					$(HttpResponseText).appendTo("#firesbox_content");
					$("#firesbox_content").find(".cancelBtn").unbind("click").bind('click',function(){
						$.fn.firesbox.close();
					});
					$("#firesbox_content").find(".insertBtn").unbind("click").bind('click',function(){
						var show_type = $("#firesbox_content").find("#show-type").val();
						var record_count = $("#firesbox_content").find("#record-count").val();
						var ordering = $("#firesbox_content").find("#ordering").val();
						var show_channel = $("#firesbox_content").find("#show-channel").val();
						if(record_count == "") record_count = 20;
						$.cleditor.cRange(editor);
						$.cleditor.exec(editor,"["+show_type+"="+channel+"_"+record_count+"_"+ordering+"_"+show_channel+"]");
						
						$.fn.firesbox.close();
					});
				}
			});
			
		}//end music
		
		function bindSearchArticle(editor,$channel_id)
		{
			$.ajax({
				url:"index.php?r=Layout.getSearchArticleWizard",
				type:"get",
				data:{channel_module_id:1},
				cache:false,
				success: function(HtmlResponseText){
					$("#firesbox_content").empty();
					$(HtmlResponseText).appendTo("#firesbox_content");
					$("#firesbox_content").find(".cancelBtn").unbind("click").bind('click',function(){
						$.fn.firesbox.close();
					});
					$("#firesbox_content").find(".insertBtn").unbind("click").bind('click',function(){
						var input_name = $("#firesbox_content").find("#input-name").val();
						var btn_name = $("#firesbox_content").find("#btn-name").val();
						$.cleditor.cRange(editor);
						$.cleditor.exec(editor,"[ancho=article_"+$channel_id+" name="+input_name+"]"+btn_name+"[/ancho]");
						
						$.fn.firesbox.close();
					});
				}
			});
		}
		
		function bindSearchSoftware(editor,$channel_id)
		{
			$.ajax({
				url:"index.php?r=Layout.getSearchSoftwareWizard",
				type:"get",
				data:{channel_module_id:1},
				cache:false,
				success: function(HtmlResponseText){
					$("#firesbox_content").empty();
					$(HtmlResponseText).appendTo("#firesbox_content");
					$("#firesbox_content").find(".cancelBtn").unbind("click").bind('click',function(){
						$.fn.firesbox.close();
					});
					$("#firesbox_content").find(".insertBtn").unbind("click").bind('click',function(){
						var input_name = $("#firesbox_content").find("#input-name").val();
						var btn_name = $("#firesbox_content").find("#btn-name").val();
						$.cleditor.cRange(editor);
						$.cleditor.exec(editor,"[ancho=software_"+$channel_id+" name="+input_name+"]"+btn_name+"[/ancho]");
						
						$.fn.firesbox.close();
					});
				}
			});
		}
		
		function bindSearchTheme(editor,$channel_id)
		{
			$.ajax({
				url:"index.php?r=Layout.getSearchThemeWizard",
				type:"get",
				data:{channel_module_id:1},
				cache:false,
				success: function(HtmlResponseText){
					$("#firesbox_content").empty();
					$(HtmlResponseText).appendTo("#firesbox_content");
					$("#firesbox_content").find(".cancelBtn").unbind("click").bind('click',function(){
						$.fn.firesbox.close();
					});
					$("#firesbox_content").find(".insertBtn").unbind("click").bind('click',function(){
						var input_name = $("#firesbox_content").find("#input-name").val();
						var btn_name = $("#firesbox_content").find("#btn-name").val();
						$.cleditor.cRange(editor);
						$.cleditor.exec(editor,"[ancho=theme_"+$channel_id+" name="+input_name+"]"+btn_name+"[/ancho]");
						
						$.fn.firesbox.close();
					});
				}
			});
		}
		
		function bindSearchGame(editor,$channel_id)
		{
			$.ajax({
				url:"index.php?r=Layout.getSearchGameWizard",
				type:"get",
				data:{channel_module_id:1},
				cache:false,
				success: function(HtmlResponseText){
					$("#firesbox_content").empty();
					$(HtmlResponseText).appendTo("#firesbox_content");
					$("#firesbox_content").find(".cancelBtn").unbind("click").bind('click',function(){
						$.fn.firesbox.close();
					});
					$("#firesbox_content").find(".insertBtn").unbind("click").bind('click',function(){
						var input_name = $("#firesbox_content").find("#input-name").val();
						var btn_name = $("#firesbox_content").find("#btn-name").val();
						$.cleditor.cRange(editor);
						$.cleditor.exec(editor,"[ancho=game_"+$channel_id+" name="+input_name+"]"+btn_name+"[/ancho]");
						
						$.fn.firesbox.close();
					});
				}
			});
		}
		
		function bindSearchPicture(editor,$channel_id)
		{
			$.ajax({
				url:"index.php?r=Layout.getSearchPictureWizard",
				type:"get",
				data:{channel_module_id:1},
				cache:false,
				success: function(HtmlResponseText){
					$("#firesbox_content").empty();
					$(HtmlResponseText).appendTo("#firesbox_content");
					$("#firesbox_content").find(".cancelBtn").unbind("click").bind('click',function(){
						$.fn.firesbox.close();
					});
					$("#firesbox_content").find(".insertBtn").unbind("click").bind('click',function(){
						var input_name = $("#firesbox_content").find("#input-name").val();
						var btn_name = $("#firesbox_content").find("#btn-name").val();
						$.cleditor.cRange(editor);
						$.cleditor.exec(editor,"[ancho=picture_"+$channel_id+" name="+input_name+"]"+btn_name+"[/ancho]");
						
						$.fn.firesbox.close();
					});
				}
			});
		}
		
		function bindSearchForum(editor,$channel_id)
		{
			$.ajax({
				url:"index.php?r=Layout.getSearchForumWizard",
				type:"get",
				data:{channel_module_id:1},
				cache:false,
				success: function(HtmlResponseText){
					$("#firesbox_content").empty();
					$(HtmlResponseText).appendTo("#firesbox_content");
					$("#firesbox_content").find(".cancelBtn").unbind("click").bind('click',function(){
						$.fn.firesbox.close();
					});
					$("#firesbox_content").find(".insertBtn").unbind("click").bind('click',function(){
						var input_name = $("#firesbox_content").find("#input-name").val();
						var btn_name = $("#firesbox_content").find("#btn-name").val();
						$.cleditor.cRange(editor);
						$.cleditor.exec(editor,"[ancho=bbs_"+$channel_id+" name="+input_name+"]"+btn_name+"[/ancho]");
						
						$.fn.firesbox.close();
					});
				}
			});
		}
		
		var editorBody = $(".editorBody").height();
		var sHeight = document.documentElement.clientHeight;
		var tcHeight = $("#topOutside").height();
		var toph = $(".sitmap").height();
		$("#UBB_edit_navBox").css({
			height: sHeight - editorBody -tcHeight -toph -59
		});
		
		$("#btn_save_to_ubbtags").click(function(){
			var top = $(this).offset().top;
			var ubbtags = $("#channel_text").val();
			if(ubbtags == ""){
				$.errorUI({
					message:"自定义标签不能为空！",
					showOverlay:true
				});
			}else{
				$.confirmUI({
					message:"标签说明：<input id='tags-title' maxlenght='20' type='text'>",
					confirm:function(){
						if($("#tags-title").val() == "")
						{
							alert("标签说明不能为空");
						}else{
							$.post('index.php?r=Layout.saveToUbbTags',{title:$("#tags-title").val(),ubbtags:ubbtags},function(JsonResponse){
								if(JsonResponse.status == 1){
									$.successUI({
										message:"标签保存成功！",
										showOverlay:true,
										autoHide:true,
										confirm:function(){setTimeout($.unblockUI, 300);}
									});
								}else{
									$.errorUI({
										message:"标签保存失败！",
										showOverlay:true
									});
								}
							},'json');
						}
						
					},
					showOverlay:true,
					cancel:function(){setTimeout($.unblockUI, 300);}
				});
			}
		});
		
	});