var lf = "<br />";

$(document).ready(function(){
	
	$("#js-db-name").blur(function(){
		checkDbLevel();
	});
	
	$("#js-admin-name").blur(function(){
		var p = /^[a-zA-Z]\w{3,15}$/;
		if(!p.test($(this).val())){
			$("#span-js-admin-name").html("<span class='comment'><img src='images\/no.gif'>4-15个字符，（只允许字母、数字、下划线）<\/span>");
		}else{
			$("#span-js-admin-name").html("<span class='comment'><img src='images\/yes.gif'><\/span>");
		}
	});
	
	$("#js-admin-password").blur(function(){
		var p = /^[A-Za-z0-9]{6,16}$/;
		if(!p.test($(this).val())){
			$("#span-js-admin-password").html("<span class='comment'><img src='images\/no.gif'>6-16个字符，建议使用英文字母数字组合以增强安全性<\/span>");
		}else{
			$("#span-js-admin-password").html("<span class='comment'><img src='images\/yes.gif'><\/span>");
		}
	});
	$("#js-admin-password2").blur(function(){
		var password = $("#js-admin-password").val();
		var password2 = $(this).val();
		if(password2 != password){
			$("#span-js-admin-password2").html("<span class='comment'><img src='images\/no.gif'>两次输入的密码不一样<\/span>");
		}else if(password2==''){
			$("#span-js-admin-password2").html("<span class='comment'><img src='images\/no.gif'>密码不能为空<\/span>");
		}else{
			$("#span-js-admin-password2").html("<span class='comment'><img src='images\/yes.gif'><\/span>");
		}
	});
	
	$("#js-go").click(function(){
		getDbList();
	});
	
	$("#js-monitor-close").click(function(){
		$("#js-monitor").hide();
	});
	
	$("#js-db-list").change(function(){
		$("#js-db-name").val($("#js-db-list").val());
	});
	
	var lab = [
		'js-license-key',
		'js-db-host',
		'js-db-port',
		'js-db-user',
		'js-db-pass',
		'js-db-prefix',
		'js-db-list',
		'js-db-name',
		'js-admin-name',
		'js-admin-password',
		'js-admin-password2'
	];
	
	$(lab).each(function(k,v){
		
		if (v == 'js-db-prefix') {
			$("#" + v).blur(function(){
				var _v = $(this).val();
				var p = /^[a-z\_]+$/;
				if(_v != "")
				{
					if(!p.test(_v))
					{
						alert("数据库表前缀必须是小写字母或小写字母和下划线组成");
						$('#js-submit').attr('disabled', 'true');
					}else{
						if (chkform()) {
							$('#js-submit').attr('disabled', '');
						}
						else {
							$('#js-submit').attr('disabled', 'true');
						}
					}
				}else{
					if (chkform()) {
						$('#js-submit').attr('disabled', '');
					}
					else {
						$('#js-submit').attr('disabled', 'true');
					}
				}
			});
		}
		else {
		
			$("#" + v).blur(function(){
				if (chkform()) {
					$('#js-submit').attr('disabled', '');
				}
				else {
					$('#js-submit').attr('disabled', 'true');
				}
			});
		}
	});
	
	$("#js-submit").click(function(){
		$("#js-monitor").show();
		
		install();
	});
	
	$("#js-monitor-view-detail").html('显示细节');
    $("#js-monitor-view-detail").click(function(){
		if($("#js-notice").is(":visible") !== false)
		{
			$("#js-view-detail").html('隐藏细节');
			$("#js-notice").hide();
			
		}else{
			$("#js-monitor-view-detail").html('显示细节');
			$("#js-notice").show();
		}
	});

    var d = new Draggable();
    d.bindDragNode("js-monitor", "js-monitor-title");

});	

function checkDbLevel()
{
	$.ajax({
  		type: "GET",
  		url: './index.php?act=get_db_level&rd='+Math.random(),
		dataType: "json",
		async: false,
  		data: {
			host:$("#js-db-host").val(),
			port:$("#js-db-port").val(),
			user:$("#js-db-user").val(),
			dbname:$("#js-db-name").val(),
			password:$("#js-db-pass").val()
		},
  		success: function(data){
     		if(data.status!=1){
				$("#span_js-db-name").html('<font style="color:red;">'+data.html+'</font>');
			}else{
				$("#span_js-db-name").html('');
			}
   		}
	}); 
}

function getDbList()
{
	$.ajax({
  		type: "GET",
  		url: './index.php?act=get_db_list&rd='+Math.random(),
		dataType: "json",
		async: false,
  		data: {
			host:$("#js-db-host").val(),
			port:$("#js-db-port").val(),
			user:$("#js-db-user").val(),
			password:$("#js-db-pass").val()
		},
  		success: function(data){
     		if(data.status==1){
				$('#js-db-list').html(data.html);
			}else{
				$('#js-db-list').html('<option value="">已有数据库</option>');
				alert(data.html);
			}
   		}
		}); 
}

function chkform()
{
	if($("#js-db-host").val()==''){
		return false;
	}
	if($("#js-db-port").val()==''){
		return false;
	}
	if($("#js-db-user").val()==''){
		return false;
	}
	if($("#js-db-pass").val()==''){
		return false;
	}
	
	if($("#js-db-name").val()==''){
		return false;
	}
	
	if($("#js-db-prefix").val()!='')
	{
		var p = /^[a-z\_]+$/;

		if(!p.test($("#js-db-prefix").val()))
		{
			return false;
		}
				
	}
	
	if($("#js-admin-name").val()==''){
		return false;
	}
	var password = $("#js-admin-password").val();
	var password2 = $("#js-admin-password2").val();
	if(password.length<6){
		//$("#span-js-admin-password").innerHTML="<span class='comment'><img src='images\/no.gif'>密码长度不能小于6<\/span>";
		return false;
	}
	if(password2 != password){
		return false;
		//$("#span-js-admin-password2").innerHTML="<span class='comment'><img src='images\/no.gif'>两次输入的密码不一样<\/span>";
	}
	if(password2.length<6){
		return false;
		//$("#span-js-admin-password2").innerHTML="<span class='comment'><img src='images\/no.gif'>密码长度不能小于6<\/span>";
	}
	return true;
}



function install()
{
	$("#js-notice").empty();
	
	startNotice();
	$('#js-submit').attr('disabled','true');
	$('#js-pre-step').attr('disabled','true');
	//notice.innerHTML = '验证注册码............';
	/*
	if(!serial()){
		displayErrorMsg("注册错误");
		return false;
	}else{
		displayOKMsg();
		
	}
	*/
	
	create_config_file();
}
function create_config_file()
{
	$("#js-notice").append('创建配置文件............');
	var params = {
		db_host: $("#js-db-host").val(),
		db_port: $("#js-db-port").val(),
		db_user: $("#js-db-user").val(),
		db_pass: $("#js-db-pass").val(),
		db_name: $("#js-db-name").val(),
		db_prefix: $("#js-db-prefix").val()
	}
	
	$.ajax({
  		type: "POST",
  		url: './index.php?act=create_config_file&rd='+Math.random(),
		dataType: "json",
		//async: false,
  		data: params,
  		success: function(data){
     		if(data.status==1){
				displayOKMsg();
				createDatabase();
			}else{
				displayErrorMsg(data.err);
				return false;
			}
   		}
	}); 
}
function createDatabase()
{
	$("#js-notice").append('创建数据库............');
	var params = {
		db_host: $("#js-db-host").val(),
		db_port: $("#js-db-port").val(),
		db_user: $("#js-db-user").val(),
		db_pass: $("#js-db-pass").val(),
		db_name: $("#js-db-name").val(),
		db_prefix: $("#js-db-prefix").val()
	}
	
	$.ajax({
  		type: "POST",
  		url: './index.php?act=create_database&rd='+Math.random(),
		dataType: "json",
		//async: false,
  		data: params,
  		success: function(data){
     		if(data.status==1){
				displayOKMsg();
				createTable();
			}else{
				displayErrorMsg(data.err);
				return false;
			}
   		}
	}); 
}
function createTable()
{
	$("#js-notice").append('安装表结构............');
	$.ajax({
  		type: "POST",
  		url: './index.php?act=create_tables&rd='+Math.random(),
		dataType: "json",
		//async: false,
		data:{setup:'yes'},
  		success: function(data){
     		if(data.status==1){
				displayOKMsg();
				initData();
			}else{
				displayErrorMsg(data.err);
				return false;
			}
   		}
	}); 
}
function initData()
{
	$("#js-notice").append('初始化数据............');
	$.ajax({
  		type: "POST",
  		url: './index.php?act=initData&rd='+Math.random(),
		dataType: "json",
		//async: false,
		data:{setup:'yes'},
  		success: function(data){
     		if(data.status==1){
				displayOKMsg();
				createAdmin();
			}else{
				displayErrorMsg(data.err);
				return false;
			}
   		}
	}); 
}
function createAdmin()
{
	$("#js-notice").append('创建管理员帐号............');
	var params = {
		admin_name: $("#js-admin-name").val(),
		admin_password: $("#js-admin-password").val(),
		admin_password2: $("#js-admin-password2").val(),
		setup:'yes'
	}
	$.ajax({
  		type: "POST",
  		url: './index.php?act=createAdmin&rd='+Math.random(),
		dataType: "json",
		//async: false,
		data:params,
  		success: function(data){
     		if(data.status==1){
				displayOKMsg();
				createOthers();
			}else{
				displayErrorMsg(data.err);
				return false;
			}
   		}
	});
}
function createOthers()
{
	$("#js-notice").append('处理其它............');
	var params = {
		setup:'yes'
	}
	$.ajax({
  		type: "POST",
  		url: './index.php?act=createothers&rd='+Math.random(),
		dataType: "json",
		//async: false,
		data:params,
  		success: function(data){
     		if(data.status==1){
				displayOKMsg();
				goToDone();
			}else{
				displayErrorMsg(data.err);
				return false;
			}
   		}
	});
	
}
function complete()
{
	$("#js-monitor-loading").attr("src", "images/loading2.gif");
    $("#js-monitor-wait-please").html( "安装完成,页面正在跳转中………");
    $("#js-monitor-view-detail"). html( "隐藏细节");
    $("#js-monitor-notice").css("display","block");
}
/**
 * 转到完成页
 */
function goToDone() {
    complete();
    window.setTimeout(function () {
        location.href = "../admin/";
    }, 1000);
}

/**
 * 显示完成信息
 */
function displayOKMsg() {
	
	$("#js-notice").append("<span style='color:green;'>成功</span>" + lf);
}

/**
 * 显示错误信息
 */
function displayErrorMsg(result) {
    stopNotice();
    $("#js-notice").append("<span style='color:red;'>失败</span>" + lf + lf);
    $("#js-monitor-view-detail"). html( "隐藏细节");
    $("#js-monitor-notice").css("display","block");
    $("#js-notice").append("<strong style='color:red'>" + result + "</strong>");
}

/* 在安装过程中调用该方法 */
function startNotice() {
    $("#js-monitor-loading").attr("src", "images/loading.gif");
    $("#js-monitor-wait-please").html( "正在安装中，请稍候…………");
}

/* 安装完毕调用该方法 */
function stopNotice() {
    $("#js-monitor-loading").attr("src","images/loading2.gif");
    $("#js-monitor-wait-please").html('安装进程已终止');
}