/*
 * Footsoft UBB Editor v1.0
 * Author:jiangsj
 * Date:2010-04-29 14:02:00
 * Website:www.footsoft.net
 */
/*类实例名称*/
var FT;
/*定义类*/
function Foot(){
    var name;
    
    var textareaid;
    var width = "98%";
    var height = "200";
    var TA = "posteditor_textarea";
    var BOX = "mainbox";
    var cursor = -1;
    var stack = new Array();
    var r = /^-?\d+$/;
    var iframeid = "Editor";
	var tools = "default";
    
    var start = 0;
    var end = 0;
    
    this.init = function(){
        init_params();
        if (r.test(width)) {
            document.getElementById(BOX).style.width = width + "px";
        }
        else {
            document.getElementById(BOX).style.width = width;
        }
        if (r.test(height)) {
            document.getElementById(BOX).style.height = height + "px";
            document.getElementById(TA).style.height = (parseInt(height) - 72) + "px";
            parent.document.getElementById(iframeid).style.height = (parseInt(height) + 10) + "px";
        }
        else {
            document.getElementById(BOX).style.height = height;
            document.getElementById(TA).style.height = height;
            parent.document.getElementById(iframeid).style.height = "200px";
        }
        _fromobj = parent.document.getElementById(textareaid);
        _iframe = parent.document.getElementById(iframeid);

		if (this.os() == "MSIE") {
			addEvent(_iframe, "blur", AttachBlur);
		}else {
			addEvent(_iframe.contentWindow, "blur", AttachBlur);
		}
		
        //addEvent(_fromobj.form, "submit", AttachSubmit);
        addEvent(_fromobj.form, "reset", AttachReset);
        AttachReset();
    }
    
    this.cmd_bold = function(){
        var txt = get_select_text();
        txt = "[b]" + txt + "[/b]";
        ubb(txt);
    }
	
	this.cmd_br = function()
	{
		var txt = get_select_text();
        txt = "[br]";
        ubb(txt);
	}
    
    this.cmd_italic = function(){
        var txt = get_select_text();
        txt = "[i]" + txt + "[/i]";
        ubb(txt);
    }
    
    this.cmd_underline = function(){
        var txt = get_select_text();
        txt = "[u]" + txt + "[/u]";
        ubb(txt);
    }
    
    this.txt = function(){
        return get_select_text();
    }
    this.settxt = function(txt){
        ubb(txt);
    }
	
	this.tools = function(){
		return tools;
	}
    
    this.undo = function(){
        addSnapshot(getcontents());
        moveCursor(-1);
        if ((str = getSnapshot()) !== false) {
            setcontents(str);
        }
    }
    
    this.redo = function(){
        moveCursor(1);
        if ((str = getSnapshot()) !== false) {
            setcontents(str);
        }
    }
    
    this.length = function(){
        return getcontents().length;
    }
    
    this.clear = function(){
        AttachReset();
    }
    
    this.height = function(h){
        h = parseInt(h);
        var oh1 = parseInt(document.getElementById(BOX).offsetHeight);
        var oh2 = parseInt(document.getElementById(TA).offsetHeight);
        if (oh2 + h >= 20 && parent.document.getElementById(iframeid)) {
            document.getElementById(BOX).style.height = (oh1 + h) + "px";
            document.getElementById(TA).style.height = (oh2 + h) + "px";
            parent.document.getElementById(iframeid).style.height = (oh1 + h + 10) + "px";
        }
    }
    
    this.range = function(){
        createRange();
    }
    
    function moveCursor(increment){
        var test = cursor + increment;
        if (test >= 0 && stack[test] != null && !isUndefined(stack[test])) {
            cursor += increment;
        }
    }
    
    function addSnapshot(str){
        if (stack[cursor] == str) {
            return;
        }
        else {
            cursor++;
            stack[cursor] = str;
            if (!isUndefined(stack[cursor + 1])) {
                stack[cursor + 1] = null;
            }
        }
    }
    
    function getSnapshot(){
        if (!isUndefined(stack[cursor]) && stack[cursor] != null) {
            return stack[cursor];
        }
        else {
            return false;
        }
    }
    
    function isUndefined(obj){
        if (obj === undefined) {
            return true;
        }
        else {
            return false;
        }
    }
    
    function getcontents(){
        return document.getElementById(TA).value;
    }
    
    function setcontents(str){
        document.getElementById(TA).value = str;
    }
    
    /*获得被选中的内容*/
    function get_select_text(){
        var word = "";
        var obj = document.getElementById(TA);
        if (start != end) {
            word = obj.value.substring(start, end);
        }
        return word;
    }
    
    function createRange(){
        var obj = document.getElementById(TA);
        obj.focus();
        //Firefox
        if (typeof(obj.selectionStart) != 'undefined') {
            start = obj.selectionStart;
            end = obj.selectionEnd;
        }
        //ie
        else 
            if (document.selection) {
                var range = document.selection.createRange();
                if (range.parentElement().id == obj.id) {
                    // create a selection of the whole textarea
                    var range_all = document.body.createTextRange();
                    range_all.moveToElementText(obj);
                    
                    for (start = 0; range_all.compareEndPoints("StartToStart", range) < 0; start++) 
                        range_all.moveStart('character', 1);
                    // get number of line breaks from textarea start to selection start and add them to start
                    // 计算一下\n
                    for (var i = 0; i <= start; i++) {
                        if (obj.value.charAt(i) == '\n') 
                            start++;
                    }
                    // create a selection of the whole textarea
                    var range_all = document.body.createTextRange();
                    range_all.moveToElementText(obj);
                    // calculate selection end point by moving beginning of range_all to end of range
                    for (end = 0; range_all.compareEndPoints('StartToEnd', range) < 0; end++) 
                        range_all.moveStart('character', 1);
                    // get number of line breaks from textarea start to selection end and add them to end
                    for (var i = 0; i <= end; i++) {
                        if (obj.value.charAt(i) == '\n') 
                            end++;
                    }
                }
                
            }
    }
    
    /*UBB替换字符串*/
    function ubb(txt){
        addSnapshot(getcontents());
        var obj = document.getElementById(TA);
		obj.focus();  //先聚集
		var s = obj.scrollTop;//获得滚动条的位置
		var pos = start+txt.length;
		obj.value = obj.value.substr(0, start) + txt + obj.value.substr(end);
        addSnapshot(getcontents());
		if( obj.createTextRange )  //ie
     	{  
	         var rng = obj.createTextRange(); //新建textRange对象  
	         rng.move( 'character', pos  ); //更改rng对象的开始位置  
	         rng.collapse( true ); //光标移动到范围结尾  
	         rng.select();//选中  
     	}else if( obj.setSelectionRange )  //ff
     	{
	        obj.setSelectionRange( pos ,  pos );  //设光标
     	}
		obj.scrollTop = s;//把滚动条恢复到以前的位置
        
    }
    
    function addEvent(obj, type, fn){
        //ie
        if (obj.attachEvent) {
            obj.attachEvent("on" + type, fn);
        }
        //firefox
        else 
            if (obj.addEventListener) {
                obj.addEventListener(type, fn, false);
            }
            //other
            else {
                obj["on" + type] = fn;
            }
    }
    function AttachBlur(){
        _fromobj = parent.document.getElementById(textareaid);
        _fromobj.value = document.getElementById(TA).value;
        //alert(_fromobj.value);
    }
    function AttachSubmit(){
        _fromobj = parent.document.getElementById(textareaid);
        _fromobj.value = document.getElementById(TA).value;
    }
    function AttachReset(){
        _fromobj = parent.document.getElementById(textareaid);
        document.getElementById(TA).value = "";
        if (_fromobj.value != "") {
            document.getElementById(TA).value = _fromobj.value;
        }
    }
    
    /*获得URL传值*/
    function init_params(){
        var hrefstr, pos, parastr, para, tempstr;
        hrefstr = window.location.href;
        pos = hrefstr.indexOf("?")
        if (pos > 0) {
            parastr = hrefstr.substring(pos + 1);
            para = parastr.split("&");
            tempstr = "";
            var isid = false;
            for (var i = 0; i < para.length; i++) {
                tempstr = para[i];
                pos = tempstr.indexOf("=");
                if (pos > 0) {
                    if (tempstr.substring(0, pos) == "id") {
                        textareaid = tempstr.substring(pos + 1);
                        isid = true;
                    }
                    else 
                        if (tempstr.substring(0, pos) == "width") {
                            width = tempstr.substring(pos + 1);
                        }
                        else 
                            if (tempstr.substring(0, pos) == "height") {
                                height = tempstr.substring(pos + 1);
                            }
                            else 
                                if (tempstr.substring(0, pos) == "iframe") {
                                    iframeid = tempstr.substring(pos + 1);
                                }
								else 
									if(tempstr.substring(0, pos) == "tools"){
										tools = tempstr.substring(pos + 1);
									}
                }
            }
            if (!isid) {
                alert("没有传id值");
            }
        }
    }
    this.os = function(){
        var OsObject = "";
        if (navigator.userAgent.indexOf("MSIE") > 0) {
            return "MSIE";
        }
        if (isFirefox = navigator.userAgent.indexOf("Firefox") > 0) {
            return "Firefox";
        }
        if (isSafari = navigator.userAgent.indexOf("Safari") > 0) {
            return "Safari";
        }
        if (isCamino = navigator.userAgent.indexOf("Camino") > 0) {
            return "Camino";
        }
        if (isMozilla = navigator.userAgent.indexOf("Gecko/") > 0) {
            return "Gecko";
        }
    }
    
}

FT = new Foot();
FT.init();
