/**
 * @author jiangsj
 * @version 1.0
 */
(function($){
	window.LayoutAddChannel = function(){
		this.init();
	};
	window.LayoutAddChannel.prototype = {
		author:'jiangsj',
		url:{
			line:'./index.php?r=Layout.ajaxline',
			sort:'./index.php?r=Layout.ajaxsort',
			module:'./index.php?r=Layout.changemodule'
		},
		init:function(){
			var me = this;
			this.dom();
			me.getline(me.init_channel.val(),me.init_line.val());
			me.getsort(me.line_id.val(),me.init_order.val());
			
			me.parent_id.change(function(){
				var id = $(this).val();
				me.getline(id,null);
				me.getsort(me.line_id.val(),null);
			});
			
			me.line_id.change(function(){
				var id = $(this).val();
				me.getsort(id,null);
			});
		},
		dom:function(){
			this.init_channel = $("#init_channel");
			this.init_line = $("#init_line");
			this.init_order = $("#init_order");
			this.parent_id = $("#parent_id");
			this.line_id = $("#line_id");
			this.show_order = $("#show_order");
		},
		getline:function(channelid,set){
			var me = this;
			$.ajax({
				type:'get',
				async:false,
				url:me.url.line+"&rd="+Math.random(),
				data:{channel_id:channelid},
				dataType:'json',
				success:function(data){
					var html = '';
					var i = 1;
					$(data).each(function(k,v){
						if (v.system_flag != 1) {
							html += '<option value="' + v.id + '"';
							if (set == v.id) {
								html += ' selected';
							}
							html += '>' + i + '</option>';
						}
						 i++;
					});	
					me.line_id.empty().html(html);
				}
			});
		},
		getsort:function(lineid,set){
			var me = this;
			$.ajax({
				type:'get',
				async:false,
				url:me.url.sort+"&rd="+Math.random(),
				data:{line_id:lineid},
				dataType:'json',
				success:function(data){
					var html = '';
					$(data).each(function(k,v){
						html+= '<option value="'+v+'"';
						 if(set == v){
						 	html+= ' selected';
						 }
						 html+= '>'+v+'</option>';
					});	
					me.show_order.empty().html(html);
				}
			});
		}
	};
	
    $(document).ready(function(){
		new LayoutAddChannel();
		var validate_parent_id = jQuery.validator.addMethod("parent_id", function(value, element) {
			   return this.optional(element) || checkParentId(value);   
			 }, "不能选择自身作为上级栏目");       
        /*
         * jquery验证
         */
        var validate = $("#channelForm").validate({
            rules: {
                'data[Channel][channel_text]': {
					required:true,
					maxlength:20
				},
				'data[Channel][parent_id]':{
					required:true,
					parent_id:true,
					number:true
				},
				'data[Channel][channel_module_id]':{
					required:true,
					number:true
				},
				'data[Channel][line_id]':{
					required:true,
					number:true
				}
            },
            messages: {
                'data[Channel][channel_text]': '请输入频道名称',
				'data[Channel][parent_id]': {required:'请选择上级栏目 ',parent_id:'不能选择自身作为上级栏目'},
				'data[Channel][channel_module_id]': '请选择功能属性',
				'data[Channel][line_id]': '请选择行号'
            },
            errorPlacement: function(error, element){
                $("#span_" + element.attr("id")).html(error).attr("class", "error");
            },
            errorClass: "invalid",
            success: function(label){
                label.html("&nbsp;&nbsp;&nbsp;").attr("class", "valid");
            }
        });
        $("#channelForm").submit(function(){
            if (validate.numberOfInvalids() <= 0) {
                $(this).ajaxSubmit({
                    success: function(str){
						var data = eval('(' + str + ')');
                        if (data.status == 1) {
                            window.frames['cpanelLayout'].location.reload();
							window.frames['leftLayout'].location.reload();
                            $.successUI({
								message:"修改成功！",
								showOverlay:true,
								autoHide:true,
								confirm:function(){setTimeout($.unblockUI, 300);}
							});
							
							
                        }
                        else {
                            $.errorUI({
								message:"修改失败！",
								showOverlay:true
							});
                        }
                    }
                });
            }else{
            	if(validate_parent_id){
					$.errorUI({
						message:"带*项没有填写全！",
						showOverlay:true
					});
            	}
			}
            return false;
        });
    });
})(jQuery);

function checkParentId(parent_id){
	if(parent_id == $('#id').val()){
		return false;
	}else{
		return true;
	}
}
