<?php
class tudou
{
	private $curl = null;
	private $mid = 0;
	private $url = '';
	private $html = '';
	private $total = 0;
	private $specialid = 0;

	function tudou($url, $mid = 0)
	{
		$this->curl = qbase::get_object('curl');
		$this->url = $url;
		$this->mid = $mid;
	}

	public function get()
	{
		if(strpos($this->url, '/programs/view/') !== false){
			$temp = $this->get_single_player($this->url);
			return empty($temp) ? array() : array($temp);
		}else if(strpos($this->url, '/playlist/id/') !== false){
			return $data = $this->get_player();
		}else if(strpos($this->url, '/hd.tudou.com/program/') !== false){
			$t = explode("/program/", $this->url);
			$id = intval($t[1]);
			$page = 1;
			$data = array();
			while(true){
				$url = "http://hd.tudou.com/ajax/albumVideos.html?videoId={$id}&pageNumer={$page}";
				$html = $this->curl->load($url);
				preg_match_all("/href=\"\/program\/([0-9]{1,9})\/\" title=\"(.*?)\" target=\"_self\"\>/", $html, $temp);
				foreach($temp[2] as $key=>$val){
					$u = "http://hd.tudou.com/program/{$temp[1][$key]}/";
					$t = $this->get_hd_single($u);
					if(empty($t)) continue;
					$data[] = $t;
				}
				if(empty($temp) || !is_array($temp) || count($temp[1]) < 10) break;
				$page++;
			}
			return $data;
		}else{
			$t = explode("playindex.do?lid=", $this->url);
			$pid = intval($t[1]);
			if($pid < 1) return array();
			$this->url = "http://www.tudou.com/playlist/id/{$pid}/";
			return $data = $this->get_player();
		}
	}

	private function get_hd_single($url)
	{
		$this->html = $this->curl->load($url);
		$player = intval($this->curl->cut($this->html, "code: \"", "\","));
		$name = $this->curl->cut($this->html, "title: \"", "\"");
		$name = str_replace("", "", $name);
		$name = str_replace("", "", $name);
		$name = $this->curl->relace_script($name);
		$data = array($this->charsetLocal($name), $this->linkToUrl($player));
		return $data;
	}

	public function get_single_player($url)
	{
		$this->html = $this->curl->load($url);
		$player = intval(trim($this->curl->cut($this->html, "var iid = ", ",iid_code")));
		$name = $this->curl->cut($this->html, ",kw = \"", "\"");
		if(!$player || !$name) return false;
		$name = str_replace("", "", $name);
		$name = str_replace("", "", $name);
		$name = $this->curl->relace_script($name);
		$data = array($this->charsetLocal($name), $this->linkToUrl($player));
		return $data;
	}

	public function get_player()
	{
		$this->html = $this->curl->load($this->url);
		return $this->get_play_ids();
	}

	private function get_special_id()
	{
		$t = explode("/playlist/id/", $this->url);
		return intval($t[1]);
	}

	private function get_play_ids()
	{
		$this->html = $this->curl->cut($this->html, "<div class=\"pl_panel\" id=\"playItems\">", "<div class=\"page_nav\" id=\"pageBar\"");
		preg_match_all("/\<a target=\"new\" title=\"(.*?)\" href=\"http:\/\/www\.tudou\.com\/playlist\/playindex\.do\?lid=([0-9]{1,12})&iid=([0-9]{1,12})&cid=([0-9]{1,12})\"\>(.*?)\<\/a\>\<\/h1\>/ies", $this->html, $temp);
		$data = array();
		foreach($temp[3] as $key=>$val){
			$data[] = array(
				$this->charsetLocal(addslashes($temp[1][$key])), $this->linkToUrl($val)
			);
		}

		$data = $this->order($data);
		return $data;
	}

	private function order($data)
	{
		if(count($data) < 3) return $data;
		$temp = $id = array();
		foreach($data as $key=>$val){
			$temp[$key] = $this->get_int($val[0]);
			$id[$key] = $key;
		}
		$n = count($temp);
		$m = count(array_unique($temp));
		array_multisort($temp, SORT_ASC, $id, SORT_ASC, $data);
		return $data;
	}

	public function get_int($str)
	{
		$arr = array('','','','','','','','','','');
		$to = array('0','1','2','3','4','5','6','7','8','9');
		$str = str_replace($arr, $to, $str);
		$str = preg_replace("/200[0-9]/", "", $str);
		$t = '';
		$status = 0;
		for ($i=0;$i<strlen($str);$i++){
			$s = substr($str,$i,1);
			if (is_numeric($s)) {
				if($status == 2) break;
				$status = 1;
				$t .= $s;
			}else{
				if($status == 1) $status = 2;
			}
		}
		while($t[0] === '0'){
			$t = substr($t, 1);	
		}
		return $t;
	}

	function charsetLocal($s){
		global $_SET;
		return qbase::iconvs($s, $_SET['def_charset'], 'gbk');
	}

	function linkToUrl($code){
		return $code;
	}
}
?>