<?php
function ubb($string)
{
	$searcharray['bbcode_regexp'] = array(
		"/\[url\]\s*(www.|https?:\/\/|ftp:\/\/|gopher:\/\/|news:\/\/|telnet:\/\/|rtsp:\/\/|mms:\/\/){1}([^\[\"']+?)\s*\[\/url\]/ie",
		"/\[url=www.([^\[\"']+?)\](.+?)\[\/url\]/is",
		"/\[url=(https?|ftp|gopher|news|telnet|rtsp|mms){1}:\/\/([^\[\"']+?)\](.+?)\[\/url\]/is",
		"/\[color=([^\[]+?)\]/i",
		"/\[em:([0-9]{1,5}):\]/i",
		"/\[size=([^\[]+?)\]/i",
		"/\[font=([^\[]+?)\]/i",
		"/\[align=([^\[]+?)\]/i",
		"/\[center\]/i",
		"/\[img\]\s*([^\[]+?)\s*\[\/img\]/ies",
		"/\[img=(\d{1,3})[x|\,](\d{1,3})\]\s*([^\[]+?)\s*\[\/img\]/ies",
		"/\[code\]\s*([^\[]+?)\s*\[\/code\]/ies"
		);
	$replacearray['bbcode_regexp'] = array(
		"cuturl('\\1\\2')",
		"<a href=\"http://www.\\1\" target=\"_blank\">\\2</a>",
		"<a href=\"\\1://\\2\" target=\"_blank\">\\3</a>",
		"<font color=\"\\1\">",
		"<img src=\"".W_P."images/face/\\1.gif\" />",
		"<font size=\"\\1\">",
		"<font face=\"\\1\">",
		"<p align=\"\\1\">",
		"<p align=\"center\">",
		"bbcodeurl('\\1', '<img src=\"%s\" border=\"0\" onload=\"if(this.width>screen.width*0.7) {this.resized=true; this.width=screen.width*0.7; this.alt=\'Click here to open new window\';}\" onmouseover=\"if(this.resized) this.style.cursor=\'pointer\';\" onclick=\"if(this.resized) {window.open(\'%s\');}\">')",
		"bbcodeurl('\\3', '<img width=\"\\1\" height=\"\\2\" src=\"%s\" border=\"0\">')"
		);

	$searcharray['bbcode_str'] = array(
		'[/color]', '[/size]', '[/font]', '[/align]', '[b]', '[/b]',
		'[i]', '[/i]', '[u]', '[/u]', '[list]', '[list=1]', '[list=a]',
		'[list=A]', '[*]','[/*]', '[/list]', '[/center]','[code]','[/code]'
		);

	$replacearray['bbcode_str'] = array(
		'</font>', '</font>', '</font>', '</p>', '<b>', '</b>', 
		'<i>','</i>', '<u>', '</u>', '<ol>', '<ol type=1>', '<ol type=a>',
		'<ol type=A>', '<li>', '</li>', '</ol>', '</p>','<pre>','</pre>'
		);

	$string = preg_replace("/\[([a-zA-Z\*\=]{1,9})\](.*)\[\//ies", "replacebr('\\1','\\2')", $string);
	$string = str_replace($searcharray['bbcode_str'], $replacearray['bbcode_str'], preg_replace($searcharray['bbcode_regexp'], $replacearray['bbcode_regexp'], $string));
	return $string;
}

function replacebr($type, $string){
	if($type == 'code'){
		return "[code]" . preg_replace("/[\t]/", "  ", $string) . "[/";
	}else{
		return "[{$type}]" . preg_replace("/[\r\n]/", "",$string) . "[/";
	}
}

function bbcodeurl($url, $tags)
{
	if (!preg_match("/<.+?>/s", $url))
	{
		if (!in_array(strtolower(substr($url, 0, 6)), array('http:/', 'ftp://', 'rtsp:/', 'mms://')))
		{
			$url = 'http://' . $url;
		}
		return str_replace('submit', '', sprintf($tags, $url, $url));
	}
	else
	{
		return '&nbsp;' . $url;
	}
}

function cuturl($url)
{
	$length = 65;
	$urllink = "<a href=\"" . (substr(strtolower($url), 0, 4) == 'www.' ? "http://$url" : $url) . '" target="_blank">';
	if (strlen($url) > $length)
	{
		$url = substr($url, 0, intval($length * 0.5)) . ' ... ' . substr($url, - intval($length * 0.3));
	}
	$urllink .= $url . '</a>';
	return $urllink;
}
?>