<?php
if(!defined('R_P'))  die("access die");
function menuList()
{
	$key = "menu_list";
	if (false === ($data = cache::get($key))){
		$data = qdb::fetchAll("select channelid, channelname, channeldir, link, url, target, domain, is_html, close_index from ".TABLEPRE."channel where `show`=1 and close_index = 0 order by displayorder asc");
		foreach($data as &$menu){
			if(!$menu['link']) $menu['url'] = toPath($menu['channelid']);
		}
		cache::set($key, $data);
	}
	return $data;
}

function getTag($channelid, $id)
{
	global $_SET;
	static $tag = array();
	$key = 'tag_' . $channelid .'_'. $id;
	if(!isset($tag[$key])){
		$cache_content = (intval($_SET['cache_content']) && defined('A_P') === false) ? true : false;
		if($cache_content == false || false === ($tag[$key] = cache::get($key))){
			$tag[$key] = qdb::fetchAll("select t.kid, d.tid, t.name, t.detail from ".TABLEPRE."tag_mapping as d left join ".TABLEPRE."tag as t on d.kid = t.kid where d.channelid = '{$channelid}' and d.id = '{$id}'"); 
			if($cache_content == true) cache::set($key, $tag[$key], 3600 * 24 * 30);
		}
	}
	return $tag[$key];
}

function getDigg($channelid, $limit = 10, $cacheTime = 3600)
{
	if($channelid < 1) return array();
	global $channel, $_MODULE;
	$table = $_MODULE[$channel[$channelid]['channelselect']]['table_name'];
	if(empty($table)) return array();
	$cacheFile = "digg_{$channelid}_{$limit}";
	if(false === ($data = cache::get($cacheFile))){
		$data = qdb::fetchAll("seelct s.*, d.good, d.bad from ".TABLEPRE."digg as d left join ".TABLEPRE."{$table} as s on d.id = s.id where d.channelid = '{$channelid}' order by good desc limit {$limit}");
		foreach($data as &$val){
			if(false === ($temp = getCidInfo($val['channelid'], $val['cid']))) continue;
			unset($temp['description']);
			$val = array_merge($val, $temp);		
			$iif = !( $val['pur_browse'] || $val['html'] || $val['pay']);
			$val['parent_url'] = qbase::GetCidHtmlDirType($val['channelid'], $val['cid'], $val['ciddir'], $val['cfilename'],!($val['pur_browse'] || $val['category_html']));
			$val['url']  = qbase::GetHtmlDirType($val['channelid'], $val['id'], $val['ciddir'], $val['dateline'],$val['filename'],$val['ver'],$iif);
		}
		cache::set($cacheFile, $data, $cacheTime);
	}
	return $data;
}

function getRelatedBySubject($subject, $cid = 0, $limit = 10, $cacheTime = 3600){
	$keyword = qbase::wordSegment($subject);
	return getRelatedByKeyword($keyword, $cid, $limit, $cacheTime);
}

function getRelatedByKeyword($keyword, $cid = 0, $limit = 10, $cacheTime = 3600){
	if(empty($keyword)) return array();
	global $channel, $_MODULE, $id, $channelid;
	$table = $_MODULE[$channel[$channelid]['channelselect']]['table_name'];
	$like = array();
	$temp = explode(" ", trim($keyword));
	foreach($temp as $key=>$val){
		$val = addslashes($val);
		$like[] = " subject like '%{$val}%' ";
		if($key >= 5) break;
	}
	$like = count($like) ? " and (" . implode(' or ', $like) . ") " : '';
	$where = $cid > 0 ? " where cid = '{$cid}' " : " where 1=1 ";
	$temp = qdb::fetchAll("select * FROM ".TABLEPRE."{$table}_{$channelid} use index(cid) {$where} {$like} limit {$limit}", $cacheTime);
	$ids = array();
	$data = array();
	foreach($temp as $val){
		if(in_array($val['id'], $ids) || $val['id'] == $id) continue;
		$ids[] = $val['id'];
		if(false === ($temp = getCidInfo($val['channelid'], $val['cid']))) continue;
		unset($temp['description']);
		$val = array_merge($val, $temp);
		$iif = !( $val['pur_browse'] || $val['html'] || $val['pay']);
		$val['parent_url'] = qbase::GetCidHtmlDirType($val['channelid'], $val['cid'], $val['ciddir'], $val['cfilename'], !($val['pur_browse'] || $val['category_html']));
		$val['url']  = qbase::GetHtmlDirType($val['channelid'], $val['id'], $val['ciddir'], $val['dateline'],$val['filename'],$val['ver'],$iif);
		$data[] = $val;
	}
	return $data;
}

function getChannelRelatedByMap($channelid, $id){
	return getRelatedByMap($channelid .'-'. $id);
}
function getRelatedByMap($key){
	global $channel, $_MODULE;
	$temp = qdb::fetchAll("select * from ".TABLEPRE."related where cid = '{$key}' order by ordering asc");
	$data = array();
	$ids = array();
	foreach($temp as $val){
		$val['data'] = $val['ids_arr'] = array();
		$tp = explode(",", $val['ids']);
		foreach($tp as $s){
			$tt = explode("-", $s);
			if(!isset($channel[$tt[0]]) || intval($tt[1]) < 1) continue;
			$val['ids_arr'][] = $s;
			$val['ids_int'][] = intval($tt[1]);
			$ids[$tt[0]][] = intval($tt[1]);
		}
		$data[] = $val;
	}
	$channel_data = array();
	foreach($ids as $channelid=>$ids_array){
		if(empty($ids_array)) continue;
		$ids_string = implode(",", $ids_array);

		$channelselect = $channel[$channelid]['channelselect'];
		$table = isset($_MODULE[$channelselect]) ? "".TABLEPRE."" . $_MODULE[$channelselect]['table_name'] . "_" . $channelid : false;
		if(!$table) continue;
		
		$channel_data_temp = qdb::fetchAll("select m.channelid, m.subject , m.id, m.dateline, m.pay, m.filename, m.ver, m.thumb, c.cid, c.category_html, c.html, c.pur_browse, c.ciddir, c.title from {$table} as m left join ".TABLEPRE."acategory as c on m.cid = c.cid where m.id in ({$ids_string}) order by m.id desc");
		foreach($channel_data_temp as $k=>&$v){
			$iif = !($v['html'] || $v['pur_browse'] || $v['pay']);
			$v['url'] = qbase::GetHtmlDirType($v['channelid'], $v['id'], $v['ciddir'], $v['dateline'], $v['filename'], $v['ver'], $iif);
			$v['parent_url'] = qbase::GetCidHtmlDirType($v['channelid'], $v['cid'], $v['ciddir'],!($v['category_html'] || $v['pur_browse']));
			$channel_data["{$v['channelid']}-{$v['id']}"] = $v;
		}
		unset($v);
	}
	foreach($data as &$val){
		foreach($val['ids_arr'] as $sign){
			if(empty($channel_data[$sign])) continue;
			$val['data'][] = $channel_data[$sign];
		}
	}
	return $data;
}

function menus($channelid, $pid = 0, $num = 0)
{
	$menus = qdb::fetchAll("select channelid, cid, title, description, keyword, ciddir, html, category_html, pur_browse, cfilename from ".TABLEPRE."acategory where cupid='{$pid}' and channelid = '{$channelid}' order by displayorder asc");
	foreach($menus as &$menu){	
		$menu['url'] = qbase::GetCidHtmlDirType($menu['channelid'], $menu['cid'], $menu['ciddir'], $menu['cfilename'], !($menu['pur_browse'] || $menu['category_html']));
	}
	return $num < 1 ? $menus : array_slice($menus, 0, $num);
} 

function menusTree($channelid){
	$temp = qbase::get_object('category', $channelid)->get();
	$data = array();
	$index = 1;
	foreach($temp as $key=>&$val){
		$val['url'] = qbase::GetCidHtmlDirType($channelid, $val['cid'], $val['ciddir'], $val['cfilename'], !($val['pur_browse'] || $val['category_html']));
		if($val['cupid'] == 0){
			$index++;
			$data[$index] = $val;
		}else{
			$data[$index]['data'][] = $val;
		}
	}
	return $data;
}

/*ȡǰҳ·бҳҳ*/

function menuPath()
{
	global $channelid, $cid;
	$data = array();
	if(false === ($info = getCidInfo($channelid, $cid))) return $data;
	$data[] = array(
		'name'=>$info['title'],
		'description'=>$info['description'],
		'url'=>qbase::GetCidHtmlDirType($info['channelid'], $info['cid'], $info['ciddir'], $info['cfilename'],  !($info['pur_browse'] || $info['category_html']))
	);
	$pid = $info['cupid'];
	$index = 0;
	while($pid > 0 && $index < 20){
		$category = getCidInfo($channelid, $pid);
		$pid = $category['cupid'];
		$index++;
		$data[] = array(
			'name'=>$category['title'],
			'description'=>$category['description'],
			'keyword'=>$category['keyword'],
			'url'=>qbase::GetCidHtmlDirType($category['channelid'], $category['cid'], $category['ciddir'], $category['cfilename'], !($category['pur_browse'] || $category['category_html']))
		);
	}
	krsort($data);
	return $data;
} 

function getCidInfo($channelid, $cid)
{
	static $database = array();
	$cid = intval($cid);
	$key = 'cid_' . $cid;
	if(isset($database[$key])) return $database[$key];
	if (false === ($info = cache::get($key))){
		$info = qdb::QueryFirst("select * from ".TABLEPRE."acategory where cid='{$cid}' limit 1");
		if(!empty($info)){
			$info['parent_title'] = $info['title'];
			if($info['extdata']){
				$temp = @unserialize($info['extdata']);
				if(is_array($temp)){
					$info = array_merge($info, $temp);
				}
			}
			unset($info['extdata']);
			cache::set($key, $info, 3600);
		}else{
			return false;
		}
	}
	$database[$key] = $info;
	return $info;
}

function toPath($channelid, $cid = 0)
{
	if($cid == 0){
		global $channel;
		if (!isset($channel[$channelid])) return '';
		if (!$channel[$channelid]['is_html']){
			return REWRITE ? W_P . "index-mod-" . $channelid . '.html' :W_P . "index.php?mod=" . $channelid;
		}else{
			if ($channel[$channelid]['domain']){
				return $channel[$channelid]['domain'];
			}else{
				return  W_P .  $channel[$channelid]['channeldir'] . '/';
			}
		}
	}
	$info = getCidInfo( $channelid, $cid);
	if( !empty( $info)){
		return qbase::GetCidHtmlDirType($info['channelid'], $info['cid'], $info['ciddir'], $info['cfilename'], !($info['pur_browse'] || $info['category_html']));
	}else{
		return '';
	}
}

function cmsExtend(&$default, &$object){
	foreach($default as $key=>$val){
		if(!isset($object[$key])) $object[$key] = $val;
		else if(is_numeric($val)) $object[$key] = intval($object[$key]);
	}
	return $object;
}

function cmsFormatIds($query){
	$ids = $temp = array();
	if(!is_array($query)) $temp = explode(",", $query);
	else $temp = $query;
	foreach($temp as $val){
		if(intval($val) < 1) continue;
		$ids[] = intval($val);
	}
	return array_unique($ids);
}

function cmsAnnouncement($query){
	$param = array();
	$param_default = array(
		'channelid'=>0,
		'num'=>5,
		'ids'=>'',
		'cacheTime'=>0,
	);
	parse_str($query, $param);
	$param = cmsExtend($param_default, $param);	
	$cacheKey = "CA_" . sprintf("%u",crc32($query));
	if($param['cacheTime'] == 0 || false === ($data = cache::get($cacheKey))){
		$where = ' where 1=1 ';
		if ($param['ids']){
			$ids = cmsFormatIds($param['ids']);
			if(!empty($ids)) $where .= " and id in (". implode(',', $ids) .") ";
		}
		if($param['channelid'] > 0) $where .= " and channelid = '{$param['channelid']}' ";
		$data = qdb::fetchAll("select * from ".TABLEPRE."announcement {$where} order by id desc limit {$param['num']}");
		if($param['cacheTime']) cache::set($cacheKey, $data, $param['cacheTime']);
	}
	return $data;
}

function cmsSql($sql, $type = 0 ,$cacheTime = 0){
	$cacheKey = "CS_" . sprintf("%u", crc32($sql . '_' . $type));
	if(strtolower(substr(trim($sql), 0, 6)) != 'select') qbase::showmsg("cmsSql ֻܲѯsql");
	if($cacheTime == 0 || false === ($data = cache::get($cacheKey))){
		switch($type){
			case 0:
				$data = qdb::fetchAll($sql);
			break;

			case 1:
				$data = qdb::queryFirst($sql);
			break;

			case 2:
			default:
				$data = qdb::queryAlone($sql);
			break;
		}
		if($cacheTime) cache::set($cacheKey, $data, $cacheTime);
	}
	return $data;
}

function cmsComment($query)
{
	global $channel, $_MODULE;
	$param = array();
	$param_default = array(
		'channelid'=>0,
		'order'=>'good',
		'desc'=>'desc',
		'num'=>10,
		'cacheTime'=>0,
	);	
	parse_str($query, $param);
	$param = cmsExtend($param_default, $param);
	$mod = $_MODULE[$channel[$param['channelid']]['channelselect']]['table_name'];
	if(empty($mod)) die('module system not found');
	$cacheKey = "CC_" . sprintf("%u",crc32($query));
	if($param['cacheTime'] == 0 || false === ($data = cache::get($cacheKey))){
		if(!in_array($param['order'], array('good','bad','total', 'absolute'))) die('param order not found');
		if(!in_array($param['desc'], array('desc','asc'))) die('param desc not found');	
		$sql = "select v.good, v.total, v.bad, v.normal, v.absolute, s.channelid, s.id, s.cid, s.subject, s.dateline, s.pay, s.filename, s.ver, c.ciddir, c.title, c.html, c.pur_browse from ".TABLEPRE."comment_view as v left join ".TABLEPRE."{$mod}_{$param['channelid']} as s on v.id = s.id left join ".TABLEPRE."acategory as c on s.cid = c.cid where v.channelid = '{$param['channelid']}' order by {$param['order']} {$param['desc']} limit {$param['num']}";
		$data = qdb::fetchAll($sql);
		foreach($data as $key=>&$val){
			if(empty($val['id'])){
				unset($data[$key]);
				continue;
			}
			$iif = !($val['html'] || $val['pur_browse'] || $val['pay']);
			$val['url'] = qbase::GetHtmlDirType($val['channelid'], $val['id'], $val['ciddir'], $val['dateline'], $val['filename'], $val['ver'],$iif);
		}
		if($param['cacheTime']) cache::set($cacheKey, $data, $param['cacheTime']);
	}
	return $data;
}

function cmsQuery($query)
{
	global $channel, $_MODULE;
	$param = array();
	$param_default = array(
		'channelid'=>0,
		'cid'=>0,
		'comend'=>0,
		'thumb'=>0,
		'subject_pre'=>'',
		'filter'=>'',
		'ids'=>'',
		'order'=>'id desc',
		'pageno'=>1,
		'pagesize'=>20,
		'cacheTime'=>0,
		'extend'=>0,
		'detail'=>0,
		'other'=>'',
		'showpage'=>0,
		'hash'=>'',
		'first'=>1,
		'last'=>1,
		'pre'=>0,
		'next'=>1,
		'half'=>4,
		'pinfo'=>1
	);
	parse_str($query, $param);
	$param = cmsExtend($param_default, $param);
	if($param['channelid'] < 1 || empty($channel[$param['channelid']])) die('channelid not found');
	$modid = $channel[$param['channelid']]['channelselect'];
	$mod = $_MODULE[$modid]['table_name'];
	if(empty($mod)) die('module system not found');
	if(!is_array($fields[$modid])) $fields[$modid] = array();
	$cacheKey = "CQ_" . sprintf("%u",crc32($query));
	if($param['cacheTime'] == 0 || (AJAX && $param['showpage'] && $param['cid']) || false === ($data = cache::get($cacheKey))){
		$data = array('data'=>array(), 'total'=>0, 'pager'=>'');
		$where = ' where 1=1';
		if ($param['ids']){
			$ids = cmsFormatIds($param['ids']);
			if(!empty($ids)) $where .= " and a.id in (". implode(',', $ids) .") ";
 		}
		if ($param['cid'] >0){
			$info = getCidInfo($param['channelid'], $param['cid']);
			if(empty($info)) die('cid not found in channel ' . $param['channelid']);
			if($info['arrchildid']) $where .= $info['child'] ? " and a.cid IN (" . $info['arrchildids'] . ") " : " and a.cid = '{$param['cid']}' ";
		}
		if (!empty($param['other']) && is_array($param['other'])){
			foreach($param['other'] as $key=>$val){
				if(!is_numeric($key)) $where .= " and a.{$key} = '" .addslashes($val). "' ";
			}
		}
		if ($param['comend'] >0) $where .= " and a.is_comend > 0";
		if ($param['thumb'] >0) $where .= " and a.thumb != '' ";
		if ($param['subject_pre']) $where .= " and a.subject_pre = '{$param['subject_pre']}' ";
		if (!is_numeric($param['filter'])){
			$param['filter'] = array_unique( is_array($param['filter']) ? $param['filter'] : explode(',', $param['filter']));
			foreach($param['filter'] as $val){
				$val = intval($val);
				if($val > 0) $where .= " and a.filter like '%{$val}%' ";
			}
		}else{
			$param['filter'] = intval($param['filter']);
			if($param['filter']) $where .= " and a.filter like '%{$param['filter']}%' ";
		}
		if ($param['showpage'] && $param['cid'] > 0){
			$countSql = "select count(*) from ".TABLEPRE."{$mod}_{$param['channelid']} as a " . $where;
			$data['total']  = qdb::QueryAlone( $countSql);
			$startid = ($param['pageno'] - 1) * $param['pagesize'];
		}else{
			$startid = 0;
		}
		$orderbysql = is_array($param['order']) ? qbase::orderbyToString($param['order'], 'a') : " order by a.{$param['order']} ";
		$join = '';
		$field_join = '';
		if($param['extend'] && !empty($_MODULE[$modid]['extend'])){
			$join = " left join ".TABLEPRE."extend_data_{$modid} as e on a.channelid = e.channelid and a.id = e.id ";
			$field_join = " ,e.* ";
		}
		$sql = "SELECT a.* {$field_join} FROM ".TABLEPRE."{$mod}_{$param['channelid']} as a {$join} " . $where . $orderbysql . " LIMIT  " . $startid . " ," . $param['pagesize'];
		$data['data'] = qdb::fetchAll($sql);
		$detail_ids = array();
		foreach($data['data'] as $key=>&$val){
			if(false === ($val = cmsFormatItem($val))){
				unset($data['data'][$key]);
				continue;
			}
			if($mod == 'article' && $val['is_link'] == 0 ){
				$detail_ids[intval($val['message'])] = $key;
			}
		}
		if($param['detail'] && $mod == 'article' && !empty($detail_ids)){
			$detail_ids_str = implode(',', array_unique(array_keys($detail_ids)));
			$detail = qdb::fetchAll("select * from ".TABLEPRE."text where text_id IN ({$detail_ids_str}) ");
			foreach($detail as $v){
				$data['data'][$detail_ids[$v['text_id']]]['detail'] = $v['message'];
			}
		}
		if($param['cacheTime']) cache::set($cacheKey, $data, $param['cacheTime']);
	}
	$data['pager'] = '';
	if($data['total'] > 0 && $param['cid'] > 0){
		$info = getCidInfo($param['channelid'], $param['cid']);
		if(!empty($info))	$data['pager'] = qbase::page($data['total'], $param['pageno'], $param['pagesize'], $info['category_html'] || $info['pur_browse'], $info['ciddir'], $info['cfilename'], $param['first'], $param['last'], $param['pre'], $param['next'], $param['pinfo'], $param['half'], $param['hash']);
	}
	return $data;
}

function cmsFormatItem(&$val){
	global $channel;
	static $fields = array(
		1 => array('subject_pre'),
		2 => array('softtype', 'use_type', 'language', 'plugin', 'systems'),
		4 => array('subject_pre', 'play_area'),
	);
	if(false === ($temp = getCidInfo($val['channelid'], $val['cid']))) return false;
	unset($temp['description']);
	$modid = $channel[$val['channelid']]['channelselect'];
	$val = array_merge($val, $temp);
	$iif = !($val['html'] || $val['pur_browse'] || $val['pay']);
	$val['url'] = qbase::GetHtmlDirType($val['channelid'], $val['id'], $val['ciddir'], $val['dateline'], $val['filename'], $val['ver'], $iif);
	$val['parent_url'] = qbase::GetCidHtmlDirType($val['channelid'], $val['cid'], $val['ciddir'], $val['cfilename'], !($val['category_html'] || $val['pur_browse']));
	$val['description'] = str_replace(array("&nbsp;"," "), "", strip_tags($val['description']));
	foreach($fields[$modid] as $v){
		$val['op_' . $v] = isset($val[$v]) ? qbase::formatSet($v, $val[$v]) : '';
	}
	if($val['extdata']){
		$temp = @unserialize($val['extdata']);
		if(is_array($temp)){
			$val = array_merge($val, $temp);
		}
	}
	unset($val['extdata']);
	return $val;
}

function cmsPortal($pid, $ordering = 'asc', $limit = 10){
	if($ordering != 'desc') $ordering = 'asc';
	$item = qdb::queryFirst("select * from ".TABLEPRE."portal where pid = '{$pid}' ");
	if(empty($item)) return array('status'=>404, 'data'=>array(), 'html'=>'bad param pid');
	if($item['p_type']) return array('status'=>200, 'item'=>$item, 'data'=>array(), 'html'=>$item['p_html']);
	$key = "pm_" . $pid;
	if(false === ($data = cache::get($key))){
		$data = qdb::fetchAll("select * from ".TABLEPRE."portal_mapping where pid = '{$pid}' order by id asc");
		cache::set($key, $data, 86400);
	}
	if($ordering != 'asc'){
		$ids = array();
		foreach($data as $val){
			$ids[] = $val['id'];
		}
		array_multisort($data, SORT_DESC, $ids);
	}
	$data = array_slice($data, 0, $limit);
	return array('status'=>200, 'item'=>$item, 'data'=>$data, 'html'=>'');
}

/*ûҳҳ*/
function cmsContentPage($query){
	global $id, $_output, $page, $iif, $page_total;
	$param = array();
	$param_default = array(
		'hash'=>'',
		'first'=>1,
		'last'=>1,
		'pre'=>0,
		'next'=>0,
		'half'=>4,
		'pinfo'=>1
	);
	parse_str($query, $param);
	$param = cmsExtend($param_default, $param);
	return qbase::privatePage($id, $_output['filename'], $_output['ver'], $page, $page_total, !$iif, $param['first'], $param['last'], $param['pre'], $param['next'], $param['pinfo'], $param['half'], $param['hash']);
}

/*ֻʹҳ*/
function nextSubject($id, $cid)
{
	global $channelid, $_category_info, $channeltitle, $mod;
	$query = "select subject,id,dateline, pay, filename, ver from ".TABLEPRE."{$mod}_{$channelid} use index(cid) where cid='$cid' and id>'$id' order by id ASC limit 1";
	$data = qdb::QueryFirst($query);
	if (!empty($data)){
		$iif = !( $_category_info['pur_browse'] || $_category_info['html'] || $data['pay']);
		$url = qbase::GetHtmlDirType($channelid, $data['id'], $_category_info['ciddir'], $data['dateline'],$data['filename'], $data['ver'], $iif);
		return '<a href=' . $url . ' class="link-next">' . $data['subject'] . '</a>';
	}else{
		return 'û';
	}
}
/*ֻʹҳ*/
function preSubject($id, $cid)
{
	global $channelid, $_category_info, $channeltitle, $mod;
	$query = "select subject,id,dateline, pay, filename, ver from ".TABLEPRE."{$mod}_{$channelid}  use index(cid)  where cid='$cid' and id<'$id' order by id DESC limit 1";
	$data = qdb::QueryFirst($query);
	if (!empty($data)){
		$iif = !( $_category_info['html'] || $_category_info['pur_browse'] || $data['pay']);
		$url = qbase::GetHtmlDirType($channelid, $data['id'], $_category_info['ciddir'], $data['dateline'],$data['filename'],$data['ver'],$iif) ;
		return '<a href=' . $url . ' class="link-pre">' . $data['subject'] . '</a>';
	}else{
		return 'û';
	}
}
/*صĵĵַ*/
function getDocLink($channelid, $id)
{
	global $channel, $_MODULE;
	$mod = qbase::getMod($channelid);
	if(empty($mod)) die("bad param channelid");
	$data = qbase::get_object('content', $channelid, $id)->get();
	if (!empty($data)){
		$_category_info = getCidInfo($channelid, $data['cid']);
		$iif = !( $_category_info['html'] || $_category_info['pur_browse'] || $data['pay']);
		return qbase::GetHtmlDirType($channelid, $data['id'], $_category_info['ciddir'], $data['dateline'],$data['filename'],$data['ver'],$iif) ;
	}else{
		die("bad param id");
	}
}

function getFriendLink($limit, $logo = true){
	$key = "friendlink";
	if(false === ($data = cache::get($key))){
		$temp = qdb::fetchAll("select id, name, url, description, logo, views from ".TABLEPRE."site where status > 0 order by ordering desc");
		$data = array(array(), array());
		foreach($temp as &$val){
			if($val['logo']){
				$data[1][] = $val;
			}else{
				$data[0][] = $val;
			}
		}
		cache::set($key, $data, 86400 * 30);
	}
	return array_slice($data[$logo ? 1 : 0], 0, $limit);
}
?>