<?php
class youku
{
	private $curl = null;
	private $mid = 0;
	private $url = '';
	private $html = '';
	private $total = 0;
	private $specialid = 0;

	function youku($url, $mid)
	{
		$this->curl = qbase::get_object('curl');
		$this->url = $url;
		$this->mid = $mid;
	}

	function get(){
		if(strpos($this->url, '/v_show/') !== false){
			$this->html = $this->curl->load($this->url);
			$player = trim($this->curl->cut($this->html, "var videoId2= '", "';"));
			$name = trim($this->curl->cut($this->html, "<meta name=\"title\" content=\"", "\">"));
			if(empty($name)){
				$temp = explode("-", $this->curl->cut($this->html, "<title>", "</title>"));
				$name = trim($temp[0]);
			}
			if(!$player || !$name) return array();
			$name = str_replace("", "", $name);
			$name = str_replace("", "", $name);

			$name = $this->curl->relace_script($name);
			$data[] = array($this->charsetLocal($name), $this->linkToUrl($player));
		}else if(strpos($this->url, '/show_page/id_') !== false){
			$temp = explode("/show_page/id_", $this->url);
			$pid = substr($temp[1], 0, -5);
			$page = 1;
			$data = array();
			while(true){
				$url = "http://www.youku.com/show_eplist/showid_{$pid}_type_pic_from_ajax_page_{$page}.html";
				$html = $this->curl->load($url);
				preg_match_all("/href=\"http:\/\/v\.youku\.com\/v_show\/id_([a-zA-Z0-9]{1,32})\.html\" target=\"video\"\>(.*?)\<\/a\>/", $html, $temp);
				if(empty($temp[0])) break;
				foreach($temp[2] as $key=>$val){
					$data[] = array(
						addslashes($this->charsetLocal($val)), $this->linkToUrl(addslashes($temp[1][$key]))
					);
				}
				$page++;
			}
		}else{
			$data = $this->get_player();
		}
		return $data;
	}

	public function get_player()
	{
		$this->html = $this->curl->load($this->url);
		$this->total = $this->get_total();
		$this->specialid = $this->get_special_id();
		return $this->get_play_ids($this->specialid);
	}

	private function get_total()
	{
		return 100;
	}

	private function get_special_id()
	{
		$t = explode("id_", $this->url);
		return intval($t[1]);
	}

	private function get_play_ids($specialid)
	{
		$data = array();
		$p = 10;
		$pages = ceil($this->total/$p);
		for($i=0; $i<$pages;$i++){
			$s = $i * $p;
			$t = $this->curl->load("http://v.youku.com/player/getPlayList/Type/Folder/Fid/{$specialid}/Pt/{$s}");
			$d = qbase::jsondecode($t, true);
			if(!is_array($d) || !is_array($d['folder']['list'])) continue;
			$this->total = intval($d['folder']['total']);
			$pages = ceil($this->total/$p);
			foreach($d['folder']['list'] as $val){
				if(!$val['videoId']) continue;
				$data[] = array(
					addslashes($this->charsetLocal($val['title'])), $this->linkToUrl($val['videoId'])
				);
			}
		}
		$data = $this->order($data);
		return $data;
	}

	private function order($data)
	{
		if(count($data) < 3) return $data;
		$temp = $id = array();
		foreach($data as $key=>$val){
			$temp[$key] = $this->get_int($val[0]);
			$id[$key] = $key;
		}
		$n = count($temp);
		$m = count(array_unique($temp));
		array_multisort($temp, SORT_ASC, $id, SORT_ASC, $data);
		return $data;
	}

	public function get_int($str)
	{
		$arr = array('','','','','','','','','','');
		$to = array('0','1','2','3','4','5','6','7','8','9');
		$str = str_replace($arr, $to, $str);
		$str = preg_replace("/200[0-9]/", "", $str);
		$t = '';
		$status = 0;
		for ($i=0;$i<strlen($str);$i++){
			$s = substr($str,$i,1);
			if (is_numeric($s)) {
				if($status == 2) break;
				$status = 1;
				$t .= $s;
			}else{
				if($status == 1) $status = 2;
			}
		}
		while($t[0] === '0'){
			$t = substr($t, 1);	
		}
		return $t;
	}

	function charsetLocal($s){
		global $_SET;
		return qbase::iconvs($s, $_SET['def_charset'], 'utf-8');
	}

	function linkToUrl($code){
		return $code;
	}
}
?>