<?php
if (!defined('R_P')) exit('Access Denied');
require_once(R_P . "/include/class.userpay_parent.php");
class userpay extends userpay_parent {
	var $channelid = 1;
	var $pay_purview = array();
	var $pay_usergroup = array();
	var $hash_string = '';
	var $timeout = 600;
	function userpay($channelid, $pay_purview, $hash = '') {
		$this -> userpay_parent();
		$this -> hash_string = $hash;
		$this -> pay_purview = $pay_purview;
		$this -> channelid = $channelid;
		if ($hash) {
			$this -> view = $this -> checkSureLink('pay');
		} else {
			$this -> view = 0;
		} 
		$info = getCidInfo($this -> channelid, $this -> pay_purview['cid']);
		$this -> pay_usergroup = empty($info) ? array() : explode(',', $info['pur_usergroup']);
	} 

	function purviewContent() { // ҳշ
		$if_login = $this -> hasLogin();
		if (!$if_login || !$this -> checkPurview()) { // Աȼ
			if (!$if_login) {
				return array('status' => 403, 'code'=> 1, 'message' => "Ҫ¼ܽв<a href='###' onclick=\"this.href=config.url + 'user.php?ac=login&forward='+encodeURIComponent(window.location.href);\">¼</a>");
			} else {
				return array('status' => 403, 'code'=> 2, 'message' => "ûûȨ޲鿴");
			} 
		} 
		if($this -> pay_purview['point'] < 1){
			return array('status' => 200, 'pay_log'=> 1, 'paytype'=>0);
		}
		$pay_log = 0;
		$last_pay = $this -> getLastPay();
		switch ($this -> pay_purview['pay_type']) {
			case 0: 
				// ظշ
				if ($last_pay == 0) { // ûڴĿչ,շ
					if ($this -> checkPoint()) {
						$this -> updateUserPay($this -> pay_purview['point']);
					} else {
						return array('status' => 403, 'code'=> 3, 'message' => 'ӵеĵ');
					} 
				}else{
					$pay_log = 1;
				}
				break;

			case 1: 
				// ϴշʱ $this->pay_purview['read_last'] Сʱշ
				if ($_SERVER['REQUEST_TIME'] - $last_pay >= 3600 * $this -> pay_purview['read_last']) {
					if ($this -> checkPoint()) {
						$this -> updateUserPay($this -> pay_purview['point']);
					} else {
						return array('status' => 403, 'code'=> 4, 'message' => 'ӵеĵ');
					} 
				} else if( $last_pay > 0){
					$pay_log = 1;
				}
				break;

			case 2: 
				// ÿһξظշһ
				if ($this -> checkPoint()) {
					$this -> updateUserPay($this -> pay_purview['point']);
				} else {
					return array('status' => 403, 'code'=> 8, 'message' => 'ӵеĵ');
				} 
				break;
		} 
		return array('status' => 200, 'pay_log'=> $pay_log, 'paytype'=>$this->checkValidity());
	} 

	function checkPurview() { // Ա
		switch ($this -> pay_purview['read_purview']) {
			case 0: 
				// ոĿȨ
				return $this -> checkPurviewAcategory($this -> pay_purview['cid']);
				break;

			case 1:
				return $this -> hasLogin();
				break;

			case 2: 
				// Ҫһû
				if ($this -> hasLogin() == false) return false;
				return in_array($this -> user['gid'], $this -> pay_usergroup);
				break;
		} 
	} 

	function checkPoint() {
		return $this -> user['point'] < $this -> pay_purview['point'] ? false : true ;
	} 

	function getLastPay() {
		$dateline = qdb :: queryAlone("select pay_dateline from " . TABLEPRE . "pay where id='" . $this -> pay_purview['id'] . "' and channelid='{$this->channelid}' and uid='" . $this -> user['uid'] . "' and pay_point > 0 order by pid desc limit 1");
		return $dateline ? $dateline : 0 ;
	} 

	function getPayTimes() {
		return qdb :: queryAlone("select count(*) from " . TABLEPRE . "pay where  id='" . $this -> pay_purview['id'] . "' and channelid='{$this->channelid}' and uid='" . $this -> user['uid'] . "'");
	} 

	function updateUserPay($pay_point = 0) {
		if ($pay_point > 0) { // 鿴Ƿ
			if ($this -> user['point'] < $pay_point) { // 
				return false;
			} else {
				$this -> updateUserPayPoint($pay_point);
				return true;
			} 
		} else {
			$this -> updateUserPayPoint();
			return true;
		} 
	} 

	function updateUserPayPoint($pay_point = 0) {
		if ($this -> view == 0) return ;
		$hash = md5($this->hash_string);
		$check = qdb::queryAlone("select count(*) as num from " . TABLEPRE . "pay  where hash = '{$hash}' ");
		if($check > 0) return;
		qdb :: query("insert into " . TABLEPRE . "pay (id,channelid,uid,pay_point,pay_dateline, hash) values ('{$this -> pay_purview['id']}','{$this->channelid}','{$this -> user['uid']}','{$pay_point}','{$_SERVER['REQUEST_TIME']}', '{$hash}')");
		if ($pay_point > 0) {
			$this -> changePoint($pay_point);
		} 
	} 

	function checkPurviewAcategory($cid) {
		$info = getCidInfo($this -> channelid, $cid);
		switch ($info['pur_browse']) {
			case 0: 
				// Ŀ,Ȩ޲
				return true;
				break;

			case 1: 
				// ֤Ŀ,Ҫ¼
				return $this -> hasLogin();
				break;

			case 2: 
				// Ҫһû
				if ($this -> hasLogin() == false) return false;
				$group = empty($info['pur_usergroup']) ? array() : explode(',', $info['pur_usergroup']);
				return in_array($this -> user['gid'], $group);
				break;

			default:
				return false;
				break;
		} 
	} 

	function createSureLink($action = 'check') {
		$param = array(
			'id' => $this -> pay_purview['id'],
			'channelid' => $this -> channelid,
			'u' => $this -> user['uid'],
			'd' => $_SERVER['REQUEST_TIME'],
			'action'=>$action,
			'r'=>qbase::random(6)
		);
		return urlencode(qbase :: authcode(qbase :: array2string($param), "ENCODE"));
	} 

	function checkSureLink($action = 'check') {
		if($action == 'view' && $this -> hasLogin() && $this -> checkPurview() && $this -> pay_purview['point'] < 1) return 1;
		parse_str(qbase :: authcode($this->hash_string, "DECODE"), $param);
		if (!isset($param['id']) || !isset($param['channelid']) || !isset($param['d']) || !isset($param['u'])) return 0;
		if ($param['id'] != $this -> pay_purview['id'] || $param['channelid'] != $this -> channelid || $param['u'] != $this -> user['uid'] || $_SERVER['REQUEST_TIME'] - $param['d'] > $this->timeout) return 0;
		return $param['action'] == $action ? 1 : 0;
	} 
} 

?>