<?php
class qsqlite
{
	var $mLinkId = 0;
	var $mQueryId = 0;
	var $mQueryString = '';
	var $mRecord = array();

	var $mError = '';
	var $mErrNo = 0;
	var $mReportError = 1;
	
	var $mSqlCache = 10800 ;
	var $buffer    = 'sqlite_unbuffered_query' ;

	var $mAppName = '';
	var $mTechNicalEmail = '';

	var $startTime = 0;

	function sqlite($mServerName, $mDbUserName, $mDbPassWord, $mDbName)
	{
		if ($this->mLinkId == 0){
			$this->mLinkId = @sqlite_open($mDbName);
			if (!$this->mLinkId) $this->GetErr('sqlite_connect error');
			return $this->mLinkId;
		}
	}

	function queryAlone($QueryString)
	{
		$this->mQueryId = $this->Query($QueryString);
		$rows = @sqlite_array_query($this->mQueryId, SQLITE_NUM);
		return $rows[0];
	}

	function queryFirst($QueryString, $type = SQLITE_ASSOC)
	{
		$this->mQueryId = $this->Query($QueryString);
		$rows = $this->fetchArray($this->mQueryId, $type);
		return $rows;
	}

	function Query($QueryString, $is_buffer = 0)
	{
		$buffer = $is_buffer == 0 ? 'sqlite_unbuffered_query' : 'sqlite_query';
		if (!$this->mQueryId = $buffer($QueryString, $this->mLinkId)) $this->GetErr('query error : '. $QueryString);
		return $this->mQueryId;
	}

	function fetchArray($QueryId = -1, $type = SQLITE_ASSOC)
	{
		if ($QueryId != -1) $this->mQueryId = $QueryId;
		if (isset($this->mQueryId)) return @sqlite_array_query($this->mQueryId, $type);
	}

	function fetchAll($QueryString, $type = SQLITE_ASSOC)
	{
		if(!$result = @sqlite_unbuffered_query( $QueryString)) $this->GetErr('query error : ' . $QueryString);
		return sqlite_fetch_all($result, SQLITE_ASSOC);
	}


	function NumRows($QueryId = -1)
	{
		if ($QueryId != -1) $this->mQueryId = $QueryId;
		return sqlite_num_rows($this->mQueryId);
	}

	function InsertId()
	{
		return sqlite_last_insert_rowid($this->mLinkId);
	}

	function AffectedRows()
	{
		return @sqlite_num_rows($this->mLinkId);
	}

	function version()
	{
		return sqlite_libversion();
	}

	function close($LinkId = -1)
	{
		if ($LinkId != -1) $this->mLinkId = $LinkId;
		return sqlite_close($this->mLinkId);
	}

	function setCache( $v)
	{
		$this->mSqlCache = $v;
	}

	function setBuffer( $v)
	{
		$this->buffer = $v ? 'sqlite_query' : 'sqlite_unbuffered_query';
	}

	function GetErr($msg)
	{
		global $_SERVER,$SET;
		$this->mErrNo = sqlite_last_error();
		$this->mError = sqlite_error_string($this->mErrNo);
		header("content-Type: text/html; charset=".$SET['def_charset']);
		if ($this->mReportError == 1){
			require 'class.mysql.error.php';
		}else{
			die("mysql error");
		}
	}

	function log($data)
	{
		base::writetofile(C_P . "/log/" . base::formatTime('Y-n-d') . ".txt", base::formatTime('Y-n-d H:i:s') ."\t". $data, 'a+');
	}
}

class used_time
{
	var $_before = 0;
	function __construct(){ $this->_before = $this->_get_microtime();}
	function get_usedtime(){ return $this->_get_microtime() - $this->_before;}
	function _get_microtime()
	{
		list($usec, $sec) = explode(' ', microtime());
		return ((float)$usec + (float)$sec);
	}	
}
?>