<?php
class mysql
{
	var $mLinkId = 0;
	var $mQueryId = 0;
	var $mQueryString = '';
	var $mRecord = array();

	var $mError = '';
	var $mErrNo = 0;
	var $mReportError = 1;
	
	var $mSqlCache = 10800 ;
	var $buffer    = 'mysql_unbuffered_query' ;

	var $mAppName = '';
	var $mTechNicalEmail = '';

	var $startTime = 0;

	function mysql($mServerName, $mDbUserName, $mDbPassWord, $mDbName, $charset)
	{
		if ($this->mLinkId == 0){
			if ($mDbPassWord == '') $this->mLinkId = @mysql_connect($mServerName , $mDbUserName );
			else $this->mLinkId = @mysql_connect($mServerName , $mDbUserName , $mDbPassWord);
			if (!$this->mLinkId) $this->GetErr('mysql_connect error');
			if ($this->version() > '4.1'){
				$charset = str_replace('-', '', $charset);
				$this->query("SET character_set_connection={$charset}, character_set_results={$charset}, character_set_client=binary");
				if ( $this->version() > '5.0.1') $this->query("SET sql_mode=''");
			}
			if ($mDbName  != '') $this->SelectDb($mDbName );
			return $this->mLinkId;
		}
	}

	function SelectDb($mDbName)
	{
		if (!@mysql_select_db($mDbName, $this->mLinkId)) $this->GetErr('can not use database ' . $mDbName );
	}

	function queryAlone($QueryString)
	{
		$this->mQueryId = $this->Query($QueryString);
		$rows = @mysql_fetch_array($this->mQueryId);
		$this->FreeResult($this->mQueryId);
		return $rows[0];
	}

	function queryFirst($QueryString, $type = MYSQL_ASSOC)
	{
		$this->mQueryId = $this->Query($QueryString);
		$rows = $this->fetchArray($this->mQueryId, $type);
		return $rows ? $rows : array();
	}

	function Query($QueryString, $is_buffer = 0)
	{
		if(DEBUG) $this->log($QueryString . "\n");
		$buffer = $is_buffer == 0 ? 'mysql_unbuffered_query' : 'mysql_query';
		if (!$this->mQueryId = $buffer($QueryString, $this->mLinkId)) $this->GetErr('query error : '. $QueryString);
		return $this->mQueryId;
	}

	function fetchArray($QueryId = -1, $type = MYSQL_ASSOC)
	{
		if ($QueryId != -1) $this->mQueryId = $QueryId;
		if (isset($this->mQueryId)) $this->mRecord = @mysql_fetch_array($this->mQueryId, $type);
		return $this->mRecord;
	}

	function fetchAll($QueryString, $type = MYSQL_ASSOC)
	{
		if(DEBUG) $this->_time = new used_time();
		$returnArray = array();
		if(!$result = @mysql_unbuffered_query( $QueryString)) $this->GetErr('query error : ' . $QueryString);
		while( $list = mysql_fetch_array($result , $type)){
			$returnArray[] = $list; 
		}
		$this->FreeResult($result);
		if(DEBUG) $this->log($this->_time->get_usedtime() . "\t" . $QueryString . "\n");
		return $returnArray;
	}

	function FreeResult($QueryId = -1)
	{
		if ($QueryId != -1) $this->mQueryId = $QueryId;
		return @mysql_free_result($this->mQueryId);
	}

	function NumRows($QueryId = -1)
	{
		if ($QueryId != -1) $this->mQueryId = $QueryId;
		return mysql_num_rows($this->mQueryId);
	}

	function InsertId()
	{
		return mysql_insert_id($this->mLinkId);
	}

	function AffectedRows()
	{
		return mysql_affected_rows($this->mLinkId);
	}

	function version()
	{
		return mysql_get_server_info();
	}

	function close($LinkId = -1)
	{
		if ($LinkId != -1) $this->mLinkId = $LinkId;
		return mysql_close($this->mLinkId);
	}

	function GetErr($msg)
	{
		global $_SERVER,$_SET;
		$this->mError = mysql_error();
		$this->mErrNo = mysql_errno();
		header("content-Type: text/html; charset=".$_SET['def_charset']);
		if ($this->mReportError == 1){
			require 'class.mysql.error.php';
		}else{
			die("mysql error");
		}
	}

	function log($data)
	{
		qbase::writetofile(C_P . "/log/" . qbase::formatTime('Y-n-d') . ".txt", qbase::formatTime('Y-n-d H:i:s') ."\t". $data, 'a+');
	}
}

class used_time
{
	var $_before = 0;
	function __construct(){ $this->_before = $this->_get_microtime();}
	function get_usedtime(){ return $this->_get_microtime() - $this->_before;}
	function _get_microtime()
	{
		list($usec, $sec) = explode(' ', microtime());
		return ((float)$usec + (float)$sec);
	}	
}
?>