<?php
define ('OS_WINDOWS', 32);
define ('OS_UNIX', 64);
// Check os
if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN')
	define('SYSTME_OS', OS_WINDOWS);
else
	define('SYSTME_OS', OS_UNIX);

if (!is_dir($rootdir))
{
	@mkdir($rootdir); 
	// die('<B>A Wrong in config.php:</B> <i>error '.$rootdir.' </i><p><span style="color:#CCCCCC">file name:<br></span><p>To config agian!');
}

$thepath = (empty($_GET[path]) || strstr($_GET[path], '..')) ? '.': urldecode($_GET[path]);

$currdir = getAbsolutePath($thepath) ;

if (!is_dir($currdir))
{
	$currdir = $rootdir;
}

$urlpath = getRelativePath($currdir) ;

$parentpath = getPath(dirname($urlpath));

$action = ($_GET[action]) ? $_GET[action] : $_POST[action];

$encode_path = urlencode($_GET[path]);
// debug info
$debug = <<< DEBUG
<pre>
------------- Debug info ------------
rootdir    : $rootdir
_GET[path] : $_GET[path]   $encode_path
currdir    : $currdir
urlpath    : $urlpath
parentpath : $parentpath
-------------------------------------
</pre>
DEBUG;
// -------------------------------------------
// used functions
// -------------------------------------------
function getAvailFilename($filename)
{
	global $filename_pattern;
	$filename = trim($filename);
	return (!preg_match($filename_pattern, $filename)) ? $filename : false;
}

function getPath($path)
{
	if (SYSTME_OS == OS_WINDOWS)
		$path = str_replace("\\", "/", $path);
	return $path;
}

function getAbsolutePath($path) // $path  rootdir
{
	global $rootdir;
	$s = getPath(realpath($rootdir . '/' . $path));
	return getPath($s);
}

function getRelativePath($path)
{
	global $rootdir;
	$root = getPath($rootdir);
	$pattern = "/" . preg_quote($root, "/") . "/i" ;
	$replace = "."; // "" or "."
	$s = preg_replace($pattern, $replace, getPath(realpath($path)), 1);
	// return substr($s, 0);
	return getPath($s);
}

define ('DATE_FORMAT', 'Y-m-d H:i:s');

CLASS Document
{
	// Private
	var $file; // full path
	
	// Public
	var $name; // file name
	var $type; // file type
	var $size; // file size
	var $date; // last update time
	var $mode; // file attrib
	
	function Document($path, $name)
	{
		$this->file = $path . '/' . $name;
		$this->name = $name;
		$this->getDocumentInfo();
	}
	// Public
	function getDocumentInfo()
	{
		$this->getType();
		$this->getSize();
		$this->getDate();
		$this->getMode();
	}
	// Private
	function getSize()
	{
		$this->size = ($this->type == 'DIR') ? 0 : filesize($this->file);
	}

	function getDate()
	{
		// $this->date = qbase::formatTime( DATE_FORMAT, filemtime($this->file) );
		$this->date = filemtime($this->file);
	}

	function getType()
	{
		if (is_dir($this->file))
		{
			$type = 'DIR';
		}
		else
		{
			preg_match ("/^.+\.([a-z0-9]{0,})$/i", $this->file, $ext);

			switch (strtolower($ext[1]))
			{
				case 'pcd' : case 'pcx' :
				case 'jpge' : case 'jpg' : case 'jpe' :
				case 'gif' :
				case 'png' :
				case 'dib' : case 'rle' : case 'bmp' :
				case 'tiff' : case 'tif' :
					$type = 'IMG';
					break;

				case 'vbs' : case 'vbse' :
				case 'js' : case 'jse' :
					$type = 'SCRIPT';
					break;

				case 'exe' : case 'com' :
					$type = 'BINARY';
					break;

				case 'ra' : case 'rm' : case 'rmj' : case 'rms' : case 'rmi' :
				case 'ram' : case 'rmm' : case 'mnd' : case 'rp' : case 'rt' :
				case 'mp4' : case 'rmvb' :
					$type = 'REALMEDIA';
					break;

				case 'mid' : case 'midi' : case 'wav' : case 'wave' :
				case 'avi' : case 'aiff' : case 'asf' : case 'au' : case 'wma' :
				case 'mpeg' : case 'mpg' : case 'm3u' : case 'mov' :
					$type = 'MSMEDIA';
					break;

				case 'mp3' : case 'mp2' : case 'mpv' : case 'mx3' :
					$type = 'MP3';
					break;

				case 'pdf' :
					$type = 'PDF';
					break;

				case 'rar' : case 'arj' : case 'tar' : case 'ace' :
				case 'lzh' : case 'uue' : case 'bz2' :
					$type = 'RAR';
					break;

				case 'zip' : case 'gzip' : case 'cab' :
				case 'tbz' : case 'tbz2' :
					$type = 'ZIP';
					break;

				case 'css' : case 'sql' : case 'txt' :
				case 'ini' : case 'inf' : case 'conf' :
				case 'cgi' : case 'inc' : case 'csv' :
				case 'c' : case 'cpp' :
					$type = 'TEXT';
					break;

				case 'rtf' : case 'doc' :
					$type = 'WORD';
					break;

				case 'swf' :
					$type = 'FLASH';
					break;

				case 'php' : case 'php3' : case 'phtml' :
					$type = 'PHP';
					break;

				case 'html' : case 'htm' : case 'shtml' :
					$type = 'HTML';
					break;

				case 'xml' :
					$type = 'XML';
					break;

				default :
					$type = 'OTHER';
					break;
			}
		}
		$this->type = $type;
		return $type;
	}

	function getMode()
	{
		$mode = fileperms($this->file);

		if ($mode &0x1000) $type = 'p'; // FIFO pipe
		elseif ($mode &0x2000) $type = 'c'; // Character special
		elseif ($mode &0x4000) $type = 'd'; // Directory
		elseif ($mode &0x6000) $type = 'b'; // Block special
		elseif ($mode &0x8000) $type = '-'; // Regular
		elseif ($mode &0xA000) $type = 'l'; // Symbolic Link
		elseif ($mode &0xC000) $type = 's'; // Socket
		else $type = 'u'; // UNKNOWN
		
		// Determine les permissions par groupe
		$owner['r'] = ($mode &00400) ? 'r' : '-';
		$owner['w'] = ($mode &00200) ? 'w' : '-';
		$owner['x'] = ($mode &00100) ? 'x' : '-';
		$group['r'] = ($mode &00040) ? 'r' : '-';
		$group['w'] = ($mode &00020) ? 'w' : '-';
		$group['e'] = ($mode &00010) ? 'x' : '-';
		$world['r'] = ($mode &00004) ? 'r' : '-';
		$world['w'] = ($mode &00002) ? 'w' : '-';
		$world['e'] = ($mode &00001) ? 'x' : '-';
		// Adjuste pour SUID, SGID et sticky bit
		if ($mode &0x800) $owner['e'] = ($owner['e'] == 'x') ? 's' : 'S';
		if ($mode &0x400) $group['e'] = ($group['e'] == 'x') ? 's' : 'S';
		if ($mode &0x200) $world['e'] = ($world['e'] == 'x') ? 't' : 'T';

		$mode = "$type$owner[r]$owner[w]$owner[e]$group[r]$group[w]$group[e]$world[r]$world[w]$world[e]";
		$this->mode = $mode;
	}
} //end class
CLASS Folder
{
	var $currdir;
	var $stype;
	var $dirs = array();
	var $files = array();

	function Folder($name, $stype)
	{
		$this->currdir = $name;
		$this->stype = $stype;
	}

	function getFolderInfo()
	{
		$handle = @opendir($this->currdir);
		$i = 0;
		$fi = 0;
		$di = 0;
		while (false !== ($file = @readdir($handle)))
		{
			if (($file != '.') && ($file != '..'))
			{
				if (is_dir($this->currdir . '/' . $file))
				{
					$this->dirs[] = new Document($this->currdir, $file);
				}
				else
				{
					$this->files[] = new Document($this->currdir, $file);
				}
			}
		}
		// usort($files,OrdDir);
		$i = 0;
		foreach($this->dirs as $dirs)
		{
			print "d.add('{$dirs->name}', '{$dirs->type}', '{$dirs->mode}', '{$dirs->size}', '{$dirs->date}','{$this->stype}', '". urlencode($dirs->name) ."');\n";
			$i++;
		}
		foreach($this->files as $files)
		{
			print "d.add('{$files->name}', '{$files->type}', '{$files->mode}', '{$files->size}', '{$files->date}','{$this->stype}', '". urlencode($files->name) ."');\n";
			$i++;
		}

		@closedir($handle);
	}
}

?>
