<?php
 class qdb
 {
	static $_db_manager = NULL;
	static function get_db()
	 {
		if(self::$_db_manager == NULL){
			global $_SET;
			switch(strtolower(QMECMS_CONNECT)){
				case 'mysql':
					self::$_db_manager = qbase::get_object('mysql', $_SET['servername'], $_SET['dbusername'], $_SET['dbpassword'], $_SET['dbname'], $_SET['def_charset']);
				break;

				case 'rpc':
					$_SET['servername'] = 'www.qmecms.com';
					self::$_db_manager = qbase::get_object('qrpc', $_SET['servername'], $_SET['passport_key']);
				break;

				default:
					die('The param QMECMS_CONNECT is not allowed');
				break;
			}
		}
		return self::$_db_manager;
	 }
	 static function close()
	 {
		if(self::$_db_manager) self::get_db()->close();
	 }
	static function query($sql, $type = false)
	{
		$r = self::get_db()->query($sql, $type);
		if($type == false) return $r;
		switch(strtolower(trim(substr(trim($sql), 0, 6)))){
			case 'update':
			case 'delete':
				return self::get_db()->AffectedRows();
			case 'replac':
			case 'insert':
				return self::get_db()->InsertId();
			default:
				return $r;
			break;
		}
	}
	static function fetchArray($linkid, $type = MYSQL_ASSOC)
	 {
		return self::get_db()->fetchArray($linkid, $type);
	 }
	static function queryFirst($sql, $type = MYSQL_ASSOC)
	{
		return self::get_db()->queryFirst($sql, $type);
	}
	static function queryAlone($sql)
	{
		return self::get_db()->queryAlone($sql);
	}
	static function fetchAll($sql, $cacheTime = 0, $type = MYSQL_ASSOC)
	{
		if($cacheTime <= 0 || false === ($data = cache::get($sql))){
			$data = self::get_db()->fetchAll($sql, $type);
			if($cacheTime > 0) cache::set($sql, $data, $cacheTime);
		}
		return $data;
	}
	static function NumRows($linkid = -1)
	{
		return self::get_db()->NumRows($linkid);
	}
	static function version(){
		return self::get_db()->version();
	}
 }
?>