<?php
class comment_verify{
	var $key = "comment_verify";
	var $passport = '';
	var $exptime = 0;
	var $act = array();
	var $random_verify = false;

	function comment_verify(){
		global $_SET;
		$this->passport = $_SET['passport_key'];
		$this->exptime = 3600 * 3;
		$this->random_verify = intval($_SET['comment_random_verify']) > 0 ? true : false;
	}

	function create($channelid, $id){
		$data = array(
			'c'=>$channelid,
			'i'=>$id,
			't'=>$_SERVER['REQUEST_TIME']
		);
		$data['hash'] = substr(md5(qbase::array2string($data) . $this->passport), 0, 12);
		return qbase::authcode(qbase::array2string($data), "ENCODE");
	}

	function check_verify($channelid, $id){
		if($random_verify == false) return 0;
		$verify = trim($_POST['verify']);
		if(empty($verify)) return 1;
		parse_str(qbase::authcode($verify, "DECODE"), $data);
		if(empty($data['c']) || empty($data['i']) || empty($data['t']) || empty($data['hash'])) return 2;
		if($channelid != $data['c'] && $id != $data['i']) return 3;
		$verify_hash = $data['hash'];
		unset($data['hash']);
		if($verify_hash != substr(md5(qbase::array2string($data) . $this->passport), 0, 12)) return 4;
		if($_SERVER['REQUEST_TIME'] - $data['t'] > $this->exptime) return 5;
		return 0;
	}

	function check_referer(){
		$r = $_SERVER['HTTP_REFERER'];
		$h = $_SERVER['HTTP_HOST'];
		if(empty($r) || empty($h)) return false;
		return true;
	}

	function check_word($msg){
		$data = $this->_get_cache();
		$msg = $this->_format_word($msg);
		if(!empty($data['delete'])) foreach($data['delete'][1] as $val){
			if(preg_match("/" . $val . "/ies", $msg)) return 2;
		}
		if(!empty($data['delete'][0]) && preg_match("/" . $data['delete'][0] . "/ies", $msg)) return 2;

		if(!empty($data['check'])) foreach($data['check'][1] as $val){
			if(preg_match("/" . $val . "/ies", $msg)) return 1;
		}
		if(!empty($data['check'][0]) && preg_match("/" . $data['check'][0] . "/ies", $msg)) return 1;

		return 0;
	}

	function update_sp($type){
		$dateline = qbase::formatTime("Y-n-d", time());
		if($type == 'del'){
			$del = 1;
			$forbidden = 0;
		}else{
			$del = 0;
			$forbidden = 1;
		}
		$num = qdb::query("update ".TABLEPRE."comment_spam set  del = del + {$del},  forbidden = forbidden + '{$forbidden}' where dateline = '{$dateline}' ", true);
		if($num == 0){
			qdb::query("replace into ".TABLEPRE."comment_spam (dateline, forbidden, del) values ('{$dateline}', {$forbidden}, {$del}) ");
		}
	}

	function _format_word(&$msg){
		$from = array("\r\n", "\r","\n","\t"," ", "",);
		$to = array("","","","","","");
		$msg = str_replace($from, $to, $msg);
		$nums = array("", "", "", "", "", "", "",
			"", "", "", "", "", "", "",
			"", "", "", "", "", "", "", "", "", "", "", "", "",
			"", "", "", "", "", " ", "", "", "", "", "", "", "",
			"", "", "", "", "", "", "", "", "", "", "", "", "",
			"", "", "", "", "", "", "", "", "", "", "", "", "");
		$fnums = explode(",", "0,1,2,3,4,5,6,7,8,9,+,-,%,.,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z,A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z");
		return str_replace($nums, $fnums, $msg);
	}
	function _get_cache(){
		if(false === ($data= cache::get($this->key))){
			$temp = qdb::fetchAll("select * from ".TABLEPRE."comment_filter order by fid asc");
			$data = array('delete'=>array(array(),array()), 'check'=>array(array(),array()));
			$tp = array(array(),array());
			foreach($temp as $val){
				if($val['act']){
					if($val['type'] > 0){
						$data['delete'][1][] = $val['keyword'];
					}else{
						$tp[1][] = preg_quote($val['keyword']);
					}
				}else{
					if($val['type'] > 0){
						$data['check'][1][] = $val['keyword'];
					}else{
						$tp[0][] = preg_quote($val['keyword']);
					}
				}
				$data['delete'][0] = implode("|", $tp[1]);
				$data['check'][0] = implode("|", $tp[0]);
			}
			cache::set($this->key, $data, 3600 * 24 * 30);
		}
		return $data;
	}
	function delete_cache(){
		cache::delete($this->key);
	}
}
?>