<?php
class charset
{
	function utf82gb($utfstr)
	{
		if ( function_exists(iconv))
		{
			return iconv("UTF-8//IGNORE","GB2312//IGNORE", $utfstr);
		}
		else
		{
			global $UC2GBTABLE;
			$okstr = "";
			if (trim($utfstr) == "") return $utfstr;
			if (empty($UC2GBTABLE))
			{
				$filename = dirname(__FILE__) . "/table/gb2312-utf8.table";
				$fp = fopen($filename, "r");
				while ($l = fgets($fp, 15))
				{
					$UC2GBTABLE[hexdec(substr($l, 7, 6))] = hexdec(substr($l, 0, 6));
				}
				fclose($fp);
			}
			$okstr = "";
			$ulen = strlen($utfstr);
			for($i = 0;$i < $ulen;$i++)
			{
				$c = $utfstr[$i];
				$cb = decbin(ord($utfstr[$i]));
				if (strlen($cb) == 8)
				{
					$csize = strpos(decbin(ord($cb)), "0");
					for($j = 0;$j < $csize;$j++)
					{
						$i++;
						$c .= $utfstr[$i];
					}
					$c = charset::utf82u($c);
					if (isset($UC2GBTABLE[$c]))
					{
						$c = dechex($UC2GBTABLE[$c] + 0x8080);
						$okstr .= chr(hexdec($c[0] . $c[1])) . chr(hexdec($c[2] . $c[3]));
					}
					else
					{
						$okstr .= "&#" . $c . ";";
					}
				}
				else $okstr .= $c;
			}
			$okstr = trim($okstr);
			return $okstr;
		}
	}

	// utf8תUnicode
	function utf82u($c)
	{
		switch (strlen($c))
		{
			case 1:
				return ord($c);
			case 2:
				$n = (ord($c[0]) &0x3f) << 6;
				$n += ord($c[1]) &0x3f;
				return $n;
			case 3:
				$n = (ord($c[0]) &0x1f) << 12;
				$n += (ord($c[1]) &0x3f) << 6;
				$n += ord($c[2]) &0x3f;
				return $n;
			case 4:
				$n = (ord($c[0]) &0x0f) << 18;
				$n += (ord($c[1]) &0x3f) << 12;
				$n += (ord($c[2]) &0x3f) << 6;
				$n += ord($c[3]) &0x3f;
				return $n;
		}
	}

	/**
 	* GBתUTF-8
 	*/
	function gb2utf8($gbstr)
	{
		if ( function_exists(iconv))
		{
			return iconv("GB2312//IGNORE","UTF-8//IGNORE", $gbstr);
		}
		else
		{
			global $CODETABLE;
			if (trim($gbstr) == "") return $gbstr;
			if (empty($CODETABLE))
			{
				$filename = dirname(__FILE__) . "/table/gb2312-utf8.table";
				$fp = fopen($filename, "r");
				while ($l = fgets($fp, 15))
				{
					$CODETABLE[hexdec(substr($l, 0, 6))] = substr($l, 7, 6);
				}
				fclose($fp);
			}
			$ret = "";
			$utf8 = "";
			while ($gbstr)
			{
				if (ord(substr($gbstr, 0, 1)) > 0x80)
				{
					$thisW = substr($gbstr, 0, 2);
					$gbstr = substr($gbstr, 2, strlen($gbstr));
					$utf8 = "";
					@$utf8 = charset::u2utf8(hexdec($CODETABLE[hexdec(bin2hex($thisW)) - 0x8080]));
					if ($utf8 != "")
					{
						for ($i = 0;$i < strlen($utf8);$i += 3)
						$ret .= chr(substr($utf8, $i, 3));
					}
				}
				else
				{
					$ret .= substr($gbstr, 0, 1);
					$gbstr = substr($gbstr, 1, strlen($gbstr));
				}
			}
			return $ret;
		}
	}

	// Unicodeתutf8
	function u2utf8($c)
	{
		for ($i = 0;$i < count($c);$i++)
		$str = "";
		if ($c < 0x80)
		{
			$str .= $c;
		}
		else if ($c < 0x800)
		{
			$str .= (0xC0 | $c >> 6);
			$str .= (0x80 | $c &0x3F);
		}
		else if ($c < 0x10000)
		{
			$str .= (0xE0 | $c >> 12);
			$str .= (0x80 | $c >> 6 &0x3F);
			$str .= (0x80 | $c &0x3F);
		}
		else if ($c < 0x200000)
		{
			$str .= (0xF0 | $c >> 18);
			$str .= (0x80 | $c >> 12 &0x3F);
			$str .= (0x80 | $c >> 6 &0x3F);
			$str .= (0x80 | $c &0x3F);
		}
		return $str;
	}

	function ascillDecode($str) 
	{ 
		preg_match_all("/(\d{2,5})/", $str,$a);
		$a = $a[0];
		foreach ($a as $dec){
			if ($dec < 128) { 
				$utf .= chr($dec); 
			} else if ($dec < 2048) { 
				$utf .= chr(192 + (($dec - ($dec % 64)) / 64)); 
				$utf .= chr(128 + ($dec % 64)); 
			} else { 
				$utf .= chr(224 + (($dec - ($dec % 4096)) / 4096)); 
				$utf .= chr(128 + ((($dec % 4096) - ($dec % 64)) / 64)); 
				$utf .= chr(128 + ($dec % 64)); 
			} 
		}
		return $utf;
	} 
	
	function ascillEncode($c)
	{
		$len = strlen($c);
		$a = 0;
		while ($a < $len){
			$ud = 0;
			if (ord($c{$a})>=0 && ord($c{$a})<=127){
				$ud = ord($c{$a});
				$a += 1;
			}else if (ord($c{$a})>=192 && ord($c{$a})<=223){
				$ud = (ord($c{$a})-192)*64 + (ord($c{$a+1})-128);
				$a += 2;
			}else if (ord($c{$a})>=224 && ord($c{$a})<=239){
				$ud = (ord($c{$a})-224)*4096 + (ord($c{$a+1})-128)*64 + (ord($c{$a+2})-128);
				$a += 3;
			}else if (ord($c{$a})>=240 && ord($c{$a})<=247){
				$ud = (ord($c{$a})-240)*262144 + (ord($c{$a+1})-128)*4096 + (ord($c{$a+2})-128)*64 + (ord($c{$a+3})-128);
				$a += 4;
			}else if (ord($c{$a})>=248 && ord($c{$a})<=251){
				$ud = (ord($c{$a})-248)*16777216 + (ord($c{$a+1})-128)*262144 + (ord($c{$a+2})-128)*4096 + (ord($c{$a+3})-128)*64 + (ord($c{$a+4})-128);
				$a += 5;
			}else if (ord($c{$a})>=252 && ord($c{$a})<=253){
				$ud = (ord($c{$a})-252)*1073741824 + (ord($c{$a+1})-128)*16777216 + (ord($c{$a+2})-128)*262144 + (ord($c{$a+3})-128)*4096 + (ord($c{$a+4})-128)*64 + (ord($c{$a+5})-128);
				$a += 6;
			}else if (ord($c{$a})>=254 && ord($c{$a})<=255){ //error
				$ud = false;
			}
			$scill .= "&#$ud;";
		}
		return $scill;
	}

}
?>
