<?php
if(!defined('R_P'))  die("access die");
class cache
{
	function get($k){
		$file = self::_hash($k);
		if(is_file($file)){
			$v = qbase::readfromfile($file);
			if($v === false) return false;
			$temp = @unserialize($v);
			return ($temp[0] + filemtime($file)) > $_SERVER['REQUEST_TIME'] ? $temp[1] : false;
		}
		return false;
	}

	function set($k, $v, $time = 86400){
		return qbase::writetofile(self::_hash($k), serialize(array($time , $v)));
	}

	function delete($k){
		$file = self::_hash($k);
		$status = is_file($file) ? @unlink($file) : false;
		clearstatcache();
		return $status;
	}
	
	function flush(){
		qbase::get_object('html')->deletedir(C_P."/cache/");
		return clearstatcache();
	}	
	
	function _hash($k){
		if(strpos($k, '/') !== false) return $k;
		$id = (string)sprintf("%u", crc32($k));
		return C_P. '/cache/'. substr($id, 0, 2) . '/' . $id . '.html';
	}
}
?>