<?php
class access
{
	var $querynum = 0;
	var $conn;
	var $insertid = 0;
	var $cursor = 0;

	function access($dbhost, $dbuser = '', $dbpw = '', $dbname = '')
	{
		$this->conn = new com('adodb.connection') or exit('Cannot start ADO');
		$this->conn->open("DRIVER={Microsoft Access Driver (*.mdb)};dbq=$dbhost;uid=$dbuser;pwd=$dbpw");
		if($this->conn->state == 0)
		{
			$this->conn->open("Provider=Microsoft.Jet.OLEDB.4.0; Data Source=$dbhost");
			if($this->conn->state == 0)	exit('Can not connect to Access Database !');
		}
		return $this->conn;
	}

	function query($sql)
	{
		$sql = trim(str_replace("`","",$sql));
		$sql = str_replace('1=1  and',"",$sql);
		echo $sql;
		if(preg_match("/^(select.*)limit ([0-9]+)(,([0-9]+))?$/i", $sql, $matchs)){
			$sql = $matchs[1];
			$offset = $matchs[2];
			$pagesize = $matchs[4];
			$query = $this->conn->Execute($sql);
			return $this->limit($query, $offset, $pagesize);
		}else{
			return $this->conn->Execute($sql);
		}
	}

	function queryAlone($sql)
	{
		$query = $this->query($sql);
	    $rs = $this->conn->Execute($query);
		$r = $this->fetchArray($rs, $type);
		$this->FreeResult($rs);
		return array_shift($r);
	}

	function queryFirst($sql, $type = MYSQL_ASSOC)
	{
		$query = $this->query($sql);
	    $rs = $this->conn->Execute($query);
		$r = $this->fetchArray($rs, $type);
		$this->FreeResult($rs);
		return $r;
	}

	function fetchArray($rs, $type = MYSQL_ASSOC)
	{
		if(is_array($rs)){
			return $this->cursor < count($rs) ? $rs[$this->cursor++] : FALSE;
		}else{
			if($rs->EOF) return FALSE;
			$array = array();
			for($i = 0; $i < $this->num_fields($rs); $i++){
				$fielddata = $rs->Fields[$i]->Value;
			    if($type == MYSQL_ASSOC) $array[$rs->Fields[$i]->Name] = $fielddata;
			    else $array[$i] = $fielddata;
			}
			$rs->MoveNext();
			return $array;
		}
	}

	function fetchAll($sql, $type = MYSQL_ASSOC)
	{
		$returnArray = array();
		$result = $this->query($sql);
		while( $list = $this->fetchArray($result , $type)){
			$returnArray[] = $list; 
		}
		$this->FreeResult($result);
		return $returnArray;
	}

	function num_rows($rs)
	{
	    return is_array($rs) ? count($rs) : $rs->recordcount;
	}

	function num_fields($rs)
	{
	    return $rs->Fields->Count;
	}

	function fetch_assoc($rs)
	{
	    return $this->fetch_array($rs, ASSOC);
	}

	function fetch_row($rs)
	{
	    return $this->fetch_array($rs, NUM);
	}

	function FreeResult($rs)
	{
	    if(is_resource($rs)) $rs->close();
	}

	function error()
	{
	    return $this->conn->Errors[$this->conn->Errors->Count-1]->Number;
	}

	function errormsg()
	{
	    return $this->conn->Errors[$this->conn->Errors->Count-1]->Description;
	}

	function close()
	{
	    $this->conn->close();
	}

	function limit($rs, $offset, $pagesize = 0)
	{
		if($pagesize > 0)
		{
			$rs->Move($offset);
		}
		else
		{
			$pagesize = $offset;
		}
		$info = array();
		for($i = 0; $i < $pagesize; $i++)
		{
			$r = $this->fetch_array($rs);
			if(!$r) break;
			$info[] = $r;
		}
		$this->free_result($rs);
		$this->cursor = 0;
		return $info;
	}
}
?>