--
-- Ľṹ `qmecms_acategory`
--

CREATE TABLE `qmecms_acategory` (
  `cid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cupid` int(10) unsigned NOT NULL DEFAULT '0',
  `channelid` int(10) NOT NULL DEFAULT '0',
  `child` tinyint(1) NOT NULL DEFAULT '0',
  `arrchildid` mediumtext NOT NULL,
  `arrchildids` mediumtext NOT NULL,
  `displayorder` int(10) unsigned NOT NULL DEFAULT '255',
  `title` varchar(30) NOT NULL,
  `cfilename` varchar(64) NOT NULL,
  `description` varchar(128) NOT NULL DEFAULT '',
  `keyword` varchar(128) NOT NULL DEFAULT '',
  `showphp` varchar(64) DEFAULT NULL,
  `showmessage` varchar(64) NOT NULL,
  `dir` varchar(128) NOT NULL DEFAULT '',
  `pic` varchar(120) NOT NULL,
  `pur_browse` tinyint(1) NOT NULL DEFAULT '0',
  `pur_usergroup` varchar(200) NOT NULL,
  `c_allow` tinyint(1) NOT NULL DEFAULT '0',
  `c_check` tinyint(1) NOT NULL DEFAULT '0',
  `c_post` tinyint(1) NOT NULL,
  `ciddir` varchar(128) NOT NULL DEFAULT '',
  `num` int(10) unsigned NOT NULL DEFAULT '0',
  `cnum` int(10) unsigned NOT NULL,
  `html` tinyint(1) NOT NULL DEFAULT '0',
  `category_html` tinyint(1) unsigned NOT NULL,
  `extdata` text NOT NULL,
  PRIMARY KEY (`cid`),
  KEY `channelid` (`channelid`),
  KEY `title` (`title`),
  KEY `cupid` (`cupid`)
) ENGINE=MyISAM   ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_ad`
--

CREATE TABLE `qmecms_ad` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  `description` varchar(125) NOT NULL,
  `width` smallint(4) unsigned NOT NULL,
  `num` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_admin`
--

CREATE TABLE `qmecms_admin` (
  `uid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(30) NOT NULL DEFAULT '',
  `password` varchar(32) NOT NULL DEFAULT '',
  `groupid` smallint(3) unsigned NOT NULL DEFAULT '0',
  `manage_channel` varchar(255) DEFAULT NULL,
  `manage_acc_channel` varchar(255) NOT NULL DEFAULT '',
  `manage_category` text,
  `manage_other` text,
  `lastlogintime` int(10) unsigned NOT NULL DEFAULT '0',
  `active_time` int(10) unsigned NOT NULL,
  `lastloginip` bigint(11) unsigned NOT NULL DEFAULT '0',
  `checkstring` varchar(6) NOT NULL DEFAULT '',
  `session` varchar(32) NOT NULL DEFAULT '',
  PRIMARY KEY (`uid`),
  UNIQUE KEY `username` (`username`),
  KEY `session` (`session`)
) ENGINE=MyISAM   ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_admin_count`
--

CREATE TABLE `qmecms_admin_count` (
  `aid` int(10) NOT NULL AUTO_INCREMENT,
  `y` smallint(4) NOT NULL,
  `m` char(6) NOT NULL,
  `d` char(10) NOT NULL,
  `uid` varchar(30) NOT NULL,
  `channelid` int(10) NOT NULL,
  `id` int(10) NOT NULL,
  PRIMARY KEY (`aid`),
  UNIQUE KEY `uid` (`uid`,`channelid`,`id`)
) ENGINE=MyISAM  ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_admin_log`
--

CREATE TABLE `qmecms_admin_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `php` varchar(255) NOT NULL,
  `message` varchar(250) NOT NULL,
  `username` varchar(30) NOT NULL DEFAULT '',
  `dateline` int(11) unsigned NOT NULL DEFAULT '0',
  `ip` bigint(11) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_ad_mapping`
--

CREATE TABLE `qmecms_ad_mapping` (
  `pid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned NOT NULL,
  `subject` varchar(64) NOT NULL,
  `type` varchar(20) NOT NULL,
  `dateline` int(10) unsigned NOT NULL,
  `closetime` int(10) unsigned NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  `word` varchar(250) NOT NULL,
  `src` varchar(255) NOT NULL,
  `link` varchar(255) NOT NULL,
  `width` smallint(4) unsigned NOT NULL,
  `height` smallint(4) unsigned NOT NULL,
  `code` text NOT NULL,
  `filter_val` varchar(250) NOT NULL,
  `filter_type` tinyint(1) unsigned NOT NULL,
  `channelid` int(10) unsigned NOT NULL,
  `ordering` int(10) unsigned NOT NULL,
  `modifytime` int(11) unsigned NOT NULL,
  PRIMARY KEY (`pid`)
) ENGINE=MyISAM  ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_announcement`
--

CREATE TABLE `qmecms_announcement` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `channelid` int(10) NOT NULL DEFAULT '0',
  `title` varchar(250) NOT NULL DEFAULT '',
  `content` text NOT NULL,
  `addtime` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `channelid` (`channelid`)
) ENGINE=MyISAM  ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_article_1`
--

CREATE TABLE `qmecms_article_1` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cid` int(10) unsigned NOT NULL DEFAULT '0',
  `channelid` int(10) unsigned NOT NULL DEFAULT '0',
  `author` varchar(30) NOT NULL DEFAULT '',
  `source` varchar(100) NOT NULL DEFAULT '',
  `subject_pre` varchar(6) NOT NULL DEFAULT '',
  `subject` varchar(100) NOT NULL DEFAULT '',
  `keyword` varchar(64) NOT NULL,
  `description` varchar(255) NOT NULL,
  `message` int(10) unsigned NOT NULL DEFAULT '0',
  `is_link` tinyint(1) NOT NULL DEFAULT '0',
  `linkurl` varchar(255) DEFAULT NULL,
  `subject_color` char(7) NOT NULL DEFAULT '0',
  `page` smallint(3) unsigned NOT NULL DEFAULT '1',
  `dateline` int(10) unsigned NOT NULL DEFAULT '0',
  `dview` mediumint(6) unsigned NOT NULL DEFAULT '0',
  `wview` mediumint(6) unsigned NOT NULL DEFAULT '0',
  `mview` mediumint(6) unsigned NOT NULL DEFAULT '0',
  `views` mediumint(6) unsigned NOT NULL DEFAULT '0',
  `viewtime` int(10) unsigned NOT NULL DEFAULT '0',
  `filter` set('0','1','2','3','4','5','6','7','8','9','10','11','12','13','14','15','16','17','18','19','20','21','22','23','24','25','26','27','28','29','30','31','32') NOT NULL,
  `stars` tinyint(1) NOT NULL DEFAULT '0',
  `postip` bigint(11) unsigned NOT NULL DEFAULT '0',
  `is_comend` tinyint(1) NOT NULL DEFAULT '0',
  `thumb` varchar(255) DEFAULT NULL,
  `editor` varchar(30) NOT NULL DEFAULT '0',
  `edit_time` int(10) NOT NULL DEFAULT '0',
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `nocoment` tinyint(1) NOT NULL DEFAULT '0',
  `pay` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `filename` varchar(64) NOT NULL,
  `showphp` varchar(30) DEFAULT NULL,
  `ver` mediumint(8) unsigned NOT NULL,
  `ordering` int(10) unsigned NOT NULL,
  `tag_status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `extdata` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `views` (`views`),
  KEY `cid` (`cid`)
) ENGINE=MyISAM ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_banned`
--

CREATE TABLE `qmecms_banned` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `start` bigint(11) unsigned NOT NULL,
  `end` bigint(11) unsigned NOT NULL,
  `lasttime` int(10) unsigned NOT NULL,
  `dateline` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_cache`
--

CREATE TABLE `qmecms_cache` (
  `k` bigint(16) NOT NULL,
  `v` text NOT NULL,
  `d` int(10) NOT NULL,
  UNIQUE KEY `key` (`k`)
) ENGINE=MyISAM ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_channel`
--

CREATE TABLE `qmecms_channel` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `channelid` int(10) NOT NULL DEFAULT '0',
  `channelname` varchar(30) NOT NULL DEFAULT '',
  `channeltitle` varchar(30) NOT NULL DEFAULT '',
  `channelitem` varchar(10) NOT NULL DEFAULT '',
  `channeldir` varchar(30) NOT NULL DEFAULT '',
  `channelselect` tinyint(1) NOT NULL DEFAULT '0',
  `system` tinyint(1) NOT NULL DEFAULT '0',
  `show` tinyint(1) NOT NULL DEFAULT '1',
  `link` tinyint(1) NOT NULL DEFAULT '0',
  `url` varchar(255) DEFAULT NULL,
  `is_html` tinyint(1) NOT NULL DEFAULT '0',
  `is_html_content` tinyint(1) NOT NULL DEFAULT '0',
  `is_auto` tinyint(1) DEFAULT '0',
  `close_index` tinyint(1) unsigned NOT NULL,
  `istext` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `html_type` varchar(10) NOT NULL DEFAULT '.html',
  `html_pre` varchar(20) NOT NULL DEFAULT '',
  `html_size` int(10) NOT NULL DEFAULT '0',
  `CidCacheTime` int(10) NOT NULL DEFAULT '0',
  `ShowCacheTime` int(10) NOT NULL DEFAULT '0',
  `allow_upload` tinyint(1) NOT NULL DEFAULT '1',
  `upload_size` int(6) NOT NULL DEFAULT '0',
  `upload_type` varchar(255) NOT NULL DEFAULT '',
  `coment_pass` smallint(1) NOT NULL DEFAULT '1',
  `pic_width` int(10) unsigned NOT NULL DEFAULT '0',
  `pic_height` int(10) unsigned NOT NULL DEFAULT '0',
  `pic_cut` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `water` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `water_position` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `water_word` varchar(64) NOT NULL,
  `water_size` tinyint(2) unsigned NOT NULL DEFAULT '12',
  `water_color` char(7) NOT NULL,
  `target` varchar(10) NOT NULL DEFAULT '',
  `skin` varchar(30) NOT NULL DEFAULT 'default',
  `index_template` varchar(64) NOT NULL DEFAULT '',
  `description` varchar(255) NOT NULL DEFAULT '',
  `displayorder` int(10) NOT NULL DEFAULT '1000',
  `html_date_path` tinyint(1) NOT NULL DEFAULT '1',
  `show_related` tinyint(1) NOT NULL DEFAULT '0',
  `show_special` tinyint(1) NOT NULL DEFAULT '0',
  `show_money` tinyint(1) NOT NULL DEFAULT '0',
  `show_vote` tinyint(1) NOT NULL DEFAULT '0',
  `upload_date_path` tinyint(1) NOT NULL DEFAULT '1',
  `domain` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `channelid` (`channelid`)
) ENGINE=MyISAM   ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_collect_links`
--

CREATE TABLE `qmecms_collect_links` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(150) NOT NULL DEFAULT '',
  `url` varchar(150) NOT NULL DEFAULT '',
  `rules` int(8) unsigned NOT NULL DEFAULT '0',
  `date` int(10) unsigned NOT NULL DEFAULT '0',
  `adopt` int(1) unsigned NOT NULL DEFAULT '1',
  `import` int(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `adopt` (`adopt`),
  KEY `url` (`url`),
  KEY `rules` (`rules`,`id`),
  KEY `import` (`import`,`id`)
) ENGINE=MyISAM  ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_collect_rule`
--

CREATE TABLE `qmecms_collect_rule` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cid` int(10) NOT NULL DEFAULT '0',
  `channelid` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(75) NOT NULL DEFAULT '',
  `charset` varchar(10) NOT NULL DEFAULT 'gbk',
  `auto_filename` tinyint(1) NOT NULL,
  `len` int(10) NOT NULL DEFAULT '0',
  `filter` varchar(255) NOT NULL DEFAULT '',
  `filter_text` text NOT NULL,
  `pic` tinyint(1) NOT NULL DEFAULT '0',
  `index_type` int(10) NOT NULL DEFAULT '1',
  `onepage` varchar(150) NOT NULL DEFAULT '',
  `manypage` text NOT NULL,
  `oneurl` text NOT NULL,
  `url_start` varchar(10) NOT NULL DEFAULT '0',
  `url_end` varchar(10) NOT NULL DEFAULT '0',
  `link_rule` text NOT NULL,
  `link_start` tinyint(1) NOT NULL,
  `link_with` varchar(250) NOT NULL,
  `jclinks` varchar(200) NOT NULL DEFAULT '',
  `body_rule` text NOT NULL,
  `author` text NOT NULL,
  `source` text NOT NULL,
  `pubtime` text NOT NULL,
  `formss` int(1) NOT NULL DEFAULT '1',
  `form_code` text NOT NULL,
  `form_next` text NOT NULL,
  `radio_cookie` tinyint(1) NOT NULL DEFAULT '0',
  `cookie` text NOT NULL,
  `dateline` int(10) NOT NULL DEFAULT '0',
  `last_update` int(10) NOT NULL DEFAULT '0',
  `auto_update` varchar(20) NOT NULL,
  `last_autodate` int(10) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `cid` (`cid`,`name`,`id`),
  KEY `channelid` (`channelid`)
) ENGINE=MyISAM   ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_comment`
--

CREATE TABLE `qmecms_comment` (
  `commentid` int(11) NOT NULL AUTO_INCREMENT,
  `channelid` int(10) unsigned NOT NULL DEFAULT '0',
  `id` int(10) NOT NULL DEFAULT '0',
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `username` varchar(30) NOT NULL,
  `url` varchar(128) NOT NULL,
  `content` mediumtext NOT NULL,
  `type` enum('comment','trackback') NOT NULL,
  `vote` tinyint(1) unsigned NOT NULL,
  `ip` bigint(11) unsigned NOT NULL DEFAULT '0',
  `addtime` int(11) NOT NULL DEFAULT '0',
  `is_pass` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`commentid`),
  KEY `channelid` (`channelid`,`id`)
) ENGINE=MyISAM  ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_comment_filter`
--

CREATE TABLE `qmecms_comment_filter` (
  `fid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `keyword` varchar(128) NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `act` tinyint(1) NOT NULL,
  PRIMARY KEY (`fid`),
  UNIQUE KEY `keyword` (`keyword`),
  KEY `type` (`type`)
) ENGINE=MyISAM ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_comment_spam`
--

CREATE TABLE `qmecms_comment_spam` (
  `dateline` varchar(10) NOT NULL,
  `forbidden` int(10) unsigned NOT NULL,
  `del` int(10) unsigned NOT NULL,
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  UNIQUE KEY `dateline` (`dateline`)
) ENGINE=MyISAM  ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_comment_view`
--

CREATE TABLE `qmecms_comment_view` (
  `channelid` int(10) unsigned NOT NULL,
  `id` int(10) unsigned NOT NULL,
  `total` int(10) unsigned NOT NULL,
  `good` int(10) unsigned NOT NULL,
  `bad` int(10) unsigned NOT NULL,
  `normal` int(10) unsigned NOT NULL,
  `absolute` int(10) unsigned NOT NULL,
  UNIQUE KEY `channlid` (`channelid`,`id`),
  KEY `total` (`total`),
  KEY `absolute` (`absolute`)
) ENGINE=MyISAM ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_config`
--

CREATE TABLE `qmecms_config` (
  `g` varchar(20) NOT NULL,
  `k` varchar(30) CHARACTER SET utf8 NOT NULL,
  `v` text CHARACTER SET utf8 NOT NULL,
  UNIQUE KEY `g` (`g`,`k`)
) ENGINE=MyISAM ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_cron`
--

CREATE TABLE `qmecms_cron` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `status` tinyint(1) unsigned NOT NULL,
  `filter` text NOT NULL,
  `exptime` int(10) NOT NULL,
  `createdate` int(10) NOT NULL,
  `lasttime` int(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=MyISAM   ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_digg`
--

CREATE TABLE `qmecms_digg` (
  `channelid` int(10) unsigned NOT NULL,
  `id` int(10) unsigned NOT NULL,
  `good` int(10) unsigned NOT NULL,
  `bad` int(10) unsigned NOT NULL,
  `diff` int(10) unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY `channelid` (`channelid`,`id`),
  KEY `good` (`good`)
) ENGINE=MyISAM ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_downloads_2`
--

CREATE TABLE `qmecms_downloads_2` (
  `pid` int(10) NOT NULL AUTO_INCREMENT,
  `id` int(10) NOT NULL DEFAULT '0',
  `serverid` text NOT NULL,
  `url_name` varchar(50) DEFAULT NULL,
  `urls` varchar(255) NOT NULL DEFAULT '',
  `ordering` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`pid`),
  KEY `id` (`id`)
) ENGINE=MyISAM   ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_download_2`
--

CREATE TABLE `qmecms_download_2` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cid` int(10) unsigned NOT NULL DEFAULT '0',
  `channelid` int(10) NOT NULL DEFAULT '0',
  `subject_pre` varchar(6) NOT NULL,
  `subject_color` varchar(7) NOT NULL,
  `subject` varchar(100) NOT NULL DEFAULT '0',
  `size` int(10) NOT NULL DEFAULT '0',
  `stars` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `systems` varchar(200) NOT NULL,
  `language` varchar(20) NOT NULL DEFAULT '',
  `use_type` varchar(20) NOT NULL DEFAULT '',
  `plugin` varchar(20) NOT NULL DEFAULT '',
  `thumb` varchar(255) NOT NULL,
  `author` varchar(30) NOT NULL DEFAULT '',
  `source` varchar(120) NOT NULL,
  `softtype` varchar(30) DEFAULT NULL,
  `editor` varchar(30) NOT NULL DEFAULT '',
  `edit_time` int(10) unsigned NOT NULL DEFAULT '0',
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `description` mediumtext NOT NULL,
  `is_comend` tinyint(1) NOT NULL DEFAULT '0',
  `nocoment` tinyint(1) NOT NULL DEFAULT '0',
  `dateline` int(10) unsigned NOT NULL DEFAULT '0',
  `dview` mediumint(6) unsigned NOT NULL DEFAULT '0',
  `wview` mediumint(6) unsigned NOT NULL DEFAULT '0',
  `mview` mediumint(6) unsigned NOT NULL DEFAULT '0',
  `views` mediumint(6) unsigned NOT NULL DEFAULT '0',
  `viewtime` int(10) unsigned NOT NULL DEFAULT '0',
  `filter` set('0','1','2','3','4','5','6','7','8','9','10','11','12','13','14','15','16','17','18','19','20','21','22','23','24','25','26','27','28','29','30','31','32') NOT NULL DEFAULT '0',
  `a-z` char(3) NOT NULL DEFAULT '',
  `keyword` varchar(64) NOT NULL,
  `postip` bigint(11) unsigned NOT NULL DEFAULT '0',
  `filename` varchar(64) NOT NULL,
  `showphp` varchar(30) NOT NULL DEFAULT '',
  `ver` mediumint(8) unsigned NOT NULL,
  `ordering` int(10) unsigned NOT NULL,
  `pay` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `error` tinyint(1) NOT NULL DEFAULT '0',
  `type` enum('0','1') DEFAULT '0',
  `tag_status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `extdata` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `views` (`views`),
  KEY `cid` (`cid`)
) ENGINE=MyISAM   ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_downserver`
--

CREATE TABLE `qmecms_downserver` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `channelid` int(10) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL DEFAULT '',
  `serverpath` varchar(255) NOT NULL DEFAULT '',
  `displayorder` int(10) NOT NULL DEFAULT '0',
  `is_lock` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM   ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_extend`
--

CREATE TABLE `qmecms_extend` (
  `eid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned NOT NULL DEFAULT '0',
  `name` varchar(64) CHARACTER SET utf8 NOT NULL,
  `ext` varchar(64) CHARACTER SET utf8 NOT NULL,
  `description` varchar(250) CHARACTER SET utf8 NOT NULL,
  `type` varchar(10) CHARACTER SET utf8 NOT NULL,
  `need` tinyint(1) NOT NULL DEFAULT '0',
  `filter_error` varchar(250) NOT NULL,
  `filter` varchar(250) NOT NULL,
  `upload` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `word_num` int(10) unsigned NOT NULL DEFAULT '0',
  `word` varchar(250) CHARACTER SET utf8 NOT NULL,
  `data` text CHARACTER SET utf8 NOT NULL,
  `ordering` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`eid`),
  UNIQUE KEY `id` (`id`,`ext`)
) ENGINE=MyISAM   ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_guestbook`
--

CREATE TABLE `qmecms_guestbook` (
  `gid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pic` int(10) NOT NULL,
  `qq` varchar(15) NOT NULL,
  `email` varchar(64) NOT NULL,
  `ip` bigint(11) unsigned NOT NULL,
  `dateline` int(11) NOT NULL,
  `message` text NOT NULL,
  `has_reply` tinyint(1) unsigned NOT NULL,
  `reply` text NOT NULL,
  `reply_time` int(11) unsigned NOT NULL,
  PRIMARY KEY (`gid`),
  KEY `ip` (`ip`)
) ENGINE=MyISAM  ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_js`
--

CREATE TABLE `qmecms_js` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `channelid` int(10) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `code_name` varchar(50) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `file_name` varchar(50) NOT NULL DEFAULT '',
  `args` text NOT NULL,
  `tpl` text NOT NULL,
  `dateline` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `file_name` (`file_name`)
) ENGINE=MyISAM  ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_mail_queue`
--

CREATE TABLE `qmecms_mail_queue` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(64) NOT NULL,
  `mailto` varchar(64) NOT NULL,
  `subject` varchar(120) NOT NULL,
  `body` text NOT NULL,
  `status` tinyint(4) NOT NULL,
  `dateline` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_module`
--

CREATE TABLE `qmecms_module` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(10) NOT NULL DEFAULT '0',
  `name` varchar(100) NOT NULL DEFAULT '',
  `table_name` varchar(100) NOT NULL DEFAULT '',
  `appname`  varchar(30) NOT NULL DEFAULT '',
  `admin_php` varchar(50) NOT NULL DEFAULT '',
  `user_list_php` varchar(50) NOT NULL DEFAULT '',
  `user_list_last_php` varchar(50) NOT NULL,
  `user_content_php` varchar(50) NOT NULL DEFAULT '',
  `is_showpage` tinyint(1) NOT NULL DEFAULT '0',
  `is_lock` tinyint(1) NOT NULL DEFAULT '0',
  `is_morechannel` tinyint(1) NOT NULL DEFAULT '0',
  `is_hidden` tinyint(1) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM   ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_movies_4`
--

CREATE TABLE `qmecms_movies_4` (
  `pid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned NOT NULL DEFAULT '0',
  `pname` varchar(64) NOT NULL,
  `url` varchar(250) NOT NULL,
  `type` varchar(20) DEFAULT NULL,
  `ordering` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`pid`),
  UNIQUE KEY `id` (`id`,`url`,`type`)
) ENGINE=MyISAM   ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_movie_4`
--

CREATE TABLE `qmecms_movie_4` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cid` int(10) unsigned NOT NULL DEFAULT '0',
  `channelid` int(10) unsigned NOT NULL DEFAULT '0',
  `subject_pre` varchar(6) NOT NULL DEFAULT '',
  `subject` varchar(100) NOT NULL DEFAULT '',
  `subject_ot` varchar(128) NOT NULL,
  `play_year` char(10) NOT NULL,
  `play_area` varchar(20) NOT NULL,
  `description` text NOT NULL,
  `play_word` varchar(64) NOT NULL,
  `play_leader` varchar(128) NOT NULL,
  `play_actor` varchar(128) NOT NULL,
  `play_status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '????-????',
  `keyword` varchar(64) NOT NULL,
  `subject_color` char(7) NOT NULL DEFAULT '''''',
  `dateline` int(10) unsigned NOT NULL DEFAULT '0',
  `dview` mediumint(6) unsigned NOT NULL DEFAULT '0',
  `wview` mediumint(6) unsigned NOT NULL DEFAULT '0',
  `mview` mediumint(6) unsigned NOT NULL DEFAULT '0',
  `views` mediumint(6) unsigned NOT NULL DEFAULT '0',
  `viewtime` int(10) unsigned NOT NULL DEFAULT '0',
  `filter` set('0','1','2','3','4','5','6','7','8','9','10','11','12','13','14','15','16','17','18','19','20','21','22','23','24','25','26','27','28','29','30','31','32') NOT NULL DEFAULT '0',
  `is_comend` tinyint(1) NOT NULL DEFAULT '0',
  `stars` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `thumb` varchar(255) DEFAULT NULL,
  `editor` varchar(30) NOT NULL DEFAULT '''''',
  `edit_time` int(10) NOT NULL DEFAULT '0',
  `uid` int(10) NOT NULL,
  `postip` bigint(11) unsigned NOT NULL DEFAULT '0',
  `nocoment` tinyint(1) NOT NULL DEFAULT '0',
  `pay` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `showphp` varchar(30) DEFAULT NULL,
  `ver` mediumint(8) unsigned NOT NULL,
  `ordering` int(10) unsigned NOT NULL,
  `filename` varchar(64) NOT NULL,
  `extdata` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `views` (`views`),
  KEY `cid` (`cid`),
  KEY `is_comend` (`is_comend`)
) ENGINE=MyISAM   ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_movie_actor_mapping`
--

CREATE TABLE `qmecms_movie_actor_mapping` (
  `name` varchar(64) NOT NULL,
  `channelid` int(10) unsigned NOT NULL,
  `id` int(10) unsigned NOT NULL,
  UNIQUE KEY `name` (`name`,`channelid`,`id`),
  KEY `channelid` (`channelid`,`id`)
) ENGINE=MyISAM ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_page`
--

CREATE TABLE `qmecms_page` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL DEFAULT '',
  `meta_title` varchar(255) NOT NULL DEFAULT '',
  `meta_keywords` varchar(255) NOT NULL DEFAULT '',
  `meta_description` varchar(255) NOT NULL DEFAULT '',
  `content` text NOT NULL,
  `tpl` varchar(32) NOT NULL DEFAULT '',
  `updatetime` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `title` (`title`)
) ENGINE=MyISAM  ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_pay`
--

CREATE TABLE `qmecms_pay` (
  `pid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned NOT NULL DEFAULT '0',
  `channelid` int(10) unsigned NOT NULL DEFAULT '0',
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `pay_point` int(10) unsigned NOT NULL DEFAULT '0',
  `pay_dateline` int(10) unsigned NOT NULL DEFAULT '0',
  `hash` varchar(32) NOT NULL,
  PRIMARY KEY (`pid`),
  KEY `id` (`id`,`channelid`,`uid`)
) ENGINE=MyISAM  ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_pay_mapping`
--

CREATE TABLE `qmecms_pay_mapping` (
  `channelid` int(10) unsigned NOT NULL DEFAULT '0',
  `id` int(10) unsigned NOT NULL DEFAULT '0',
  `requirepoint` mediumint(6) unsigned NOT NULL DEFAULT '0',
  `read_purview` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `pay_type` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `read_last` mediumint(6) unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY `channelid` (`channelid`,`id`)
) ENGINE=MyISAM ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_pics_3`
--

CREATE TABLE `qmecms_pics_3` (
  `pid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned NOT NULL,
  `ordering` int(10) unsigned NOT NULL,
  `url` varchar(120) NOT NULL,
  `ext` varchar(5) NOT NULL,
  `pic_name` varchar(250) NOT NULL,
  `is_thumb` tinyint(1) NOT NULL,
  PRIMARY KEY (`pid`),
  KEY `id` (`id`)
) ENGINE=MyISAM  ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_pic_3`
--

CREATE TABLE `qmecms_pic_3` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL DEFAULT '0',
  `channelid` int(11) NOT NULL DEFAULT '0',
  `subject_pre` varchar(6) NOT NULL,
  `subject` varchar(100) NOT NULL DEFAULT '',
  `thumb` varchar(255) NOT NULL DEFAULT '',
  `subject_color` varchar(7) NOT NULL DEFAULT '',
  `author` varchar(30) NOT NULL DEFAULT '',
  `source` varchar(100) NOT NULL DEFAULT '',
  `description` mediumtext NOT NULL,
  `is_comend` tinyint(1) NOT NULL DEFAULT '0',
  `nocoment` tinyint(1) NOT NULL DEFAULT '0',
  `editor` varchar(30) NOT NULL DEFAULT '',
  `edit_time` int(10) unsigned NOT NULL DEFAULT '0',
  `keyword` varchar(64) NOT NULL,
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `dateline` int(10) NOT NULL DEFAULT '0',
  `dview` mediumint(6) unsigned NOT NULL DEFAULT '0',
  `mview` mediumint(6) unsigned NOT NULL DEFAULT '0',
  `wview` mediumint(6) unsigned NOT NULL DEFAULT '0',
  `views` mediumint(6) unsigned NOT NULL DEFAULT '0',
  `viewtime` int(10) unsigned NOT NULL DEFAULT '0',
  `filter` set('0','1','2','3','4','5','6','7','8','9','10','11','12','13','14','15','16','17','18','19','20','21','22','23','24','25','26','27','28','29','30','31','32') NOT NULL DEFAULT '0',
  `filename` varchar(64) NOT NULL,
  `showphp` varchar(30) NOT NULL DEFAULT '',
  `showtype` tinyint(1) unsigned NOT NULL,
  `ver` mediumint(8) unsigned NOT NULL,
  `ordering` int(10) unsigned NOT NULL,
  `pay` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `stars` tinyint(1) NOT NULL DEFAULT '3',
  `postip` bigint(11) unsigned NOT NULL DEFAULT '0',
  `page` smallint(3) unsigned NOT NULL DEFAULT '1',
  `extdata` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `views` (`views`),
  KEY `cid` (`cid`)
) ENGINE=MyISAM  ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_pic_setting`
--

CREATE TABLE `qmecms_pic_setting` (
  `id` int(10) unsigned NOT NULL,
  `channelid` int(10) unsigned NOT NULL,
  `w` int(10) unsigned NOT NULL,
  `h` int(10) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL,
  `name` varchar(20) NOT NULL,
  UNIQUE KEY `channelid` (`channelid`,`name`)
) ENGINE=MyISAM ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_portal`
--

CREATE TABLE `qmecms_portal` (
  `pid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `p_title` varchar(64) CHARACTER SET gb2312 NOT NULL,
  `p_type` tinyint(1) NOT NULL,
  `p_html` text CHARACTER SET gb2312 NOT NULL,
  `p_dateline` int(10) NOT NULL,
  `p_uid` int(10) NOT NULL,
  `p_status` tinyint(1) unsigned NOT NULL,
  PRIMARY KEY (`pid`)
) ENGINE=MyISAM   ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_portal_mapping`
--

CREATE TABLE `qmecms_portal_mapping` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(10) unsigned NOT NULL,
  `uid` int(10) unsigned NOT NULL,
  `subject` varchar(64) NOT NULL,
  `url` varchar(250) NOT NULL,
  `thumb` varchar(250) NOT NULL,
  `ordering` int(10) unsigned NOT NULL,
  `description` text NOT NULL,
  `subject_color` char(7) NOT NULL,
  `target` enum('_blank','_self','_top') NOT NULL,
  `extdata` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`)
) ENGINE=MyISAM   ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_portal_purview`
--

CREATE TABLE `qmecms_portal_purview` (
  `uid` int(10) unsigned NOT NULL,
  `pid` int(10) unsigned NOT NULL,
  UNIQUE KEY `uid` (`uid`,`pid`)
) ENGINE=MyISAM ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_recycle`
--

CREATE TABLE `qmecms_recycle` (
  `rid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id` int(10) unsigned NOT NULL,
  `channelid` int(10) unsigned NOT NULL,
  `cid` int(10) NOT NULL,
  `is_comend` tinyint(1) unsigned NOT NULL,
  `status` enum('0','1','2','3','4') NOT NULL,
  `uid` int(11) NOT NULL,
  `filter` set('0','1','2','3','4','5','6','7','8','9','10','11','12','13','14','15','16','17','18','19','20','21','22','23','24','25','26','27','28','29','30','31','32') NOT NULL,
  `data` text NOT NULL,
  PRIMARY KEY (`rid`),
  UNIQUE KEY `id` (`id`,`channelid`),
  KEY `channelid` (`channelid`,`status`,`uid`)
) ENGINE=MyISAM   ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_related`
--

CREATE TABLE `qmecms_related` (
  `aid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cid` varchar(20) CHARACTER SET utf8 NOT NULL,
  `title` varchar(64) CHARACTER SET utf8 NOT NULL,
  `ids` text CHARACTER SET utf8 NOT NULL,
  `ordering` int(10) unsigned NOT NULL,
  PRIMARY KEY (`aid`),
  KEY `cid` (`cid`)
) ENGINE=MyISAM  ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_search_log`
--

CREATE TABLE `qmecms_search_log` (
  `dateline` char(10) CHARACTER SET utf8 NOT NULL,
  `word` varchar(20) CHARACTER SET utf8 NOT NULL,
  `num` int(10) unsigned NOT NULL DEFAULT '0',
  UNIQUE KEY `dateline` (`dateline`,`word`)
) ENGINE=MyISAM ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_setting`
--

CREATE TABLE `qmecms_setting` (
  `channelid` int(10) NOT NULL,
  `type` varchar(20) CHARACTER SET utf8 NOT NULL,
  `val` text CHARACTER SET utf8 NOT NULL,
  UNIQUE KEY `channelid` (`channelid`,`type`)
) ENGINE=MyISAM ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_site`
--

CREATE TABLE `qmecms_site` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  `url` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `logo` varchar(255) NOT NULL,
  `pwd` varchar(32) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `views` int(10) NOT NULL,
  `dateline` int(11) NOT NULL,
  `ordering` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_special`
--

CREATE TABLE `qmecms_special` (
  `sid` int(11) NOT NULL AUTO_INCREMENT,
  `mid` int(10) unsigned NOT NULL,
  `channelid` int(10) NOT NULL,
  `subject` varchar(100) NOT NULL DEFAULT '',
  `thumb` varchar(120) NOT NULL DEFAULT '',
  `filename` varchar(64) NOT NULL,
  `showphp` varchar(30) NOT NULL DEFAULT 'special',
  `description` text NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `dateline` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`sid`)
) ENGINE=MyISAM  ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_tag`
--

CREATE TABLE `qmecms_tag` (
  `kid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `rank` mediumint(6) unsigned NOT NULL DEFAULT '0',
  `num` int(10) unsigned NOT NULL,
  `detail` varchar(255) NOT NULL,
  PRIMARY KEY (`kid`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM   ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_tag_mapping`
--

CREATE TABLE `qmecms_tag_mapping` (
  `tid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `channelid` int(10) unsigned NOT NULL,
  `id` int(10) unsigned NOT NULL DEFAULT '0',
  `kid` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`tid`),
  UNIQUE KEY `kid` (`kid`,`id`,`channelid`)
) ENGINE=MyISAM   ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_text`
--

CREATE TABLE `qmecms_text` (
  `text_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `message` text NOT NULL,
  PRIMARY KEY (`text_id`)
) ENGINE=MyISAM  ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_url`
--

CREATE TABLE `qmecms_url` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(10) NOT NULL,
  `host` varchar(128) NOT NULL,
  `url` varchar(256) NOT NULL,
  `dview` int(10) unsigned NOT NULL,
  `views` int(10) NOT NULL,
  `viewtime` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  UNIQUE KEY `url` (`url`)
) ENGINE=MyISAM   ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_user`
--

CREATE TABLE `qmecms_user` (
  `uid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(20) CHARACTER SET utf8 NOT NULL,
  `email` varchar(64) CHARACTER SET utf8 NOT NULL,
  `email_verify` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `password` varchar(32) CHARACTER SET utf8 NOT NULL,
  `regtime` int(10) unsigned NOT NULL DEFAULT '0',
  `regip` bigint(11) unsigned NOT NULL DEFAULT '0',
  `logintime` int(10) unsigned NOT NULL DEFAULT '0',
  `logintimes` int(10) unsigned NOT NULL DEFAULT '0',
  `loginip` bigint(11) unsigned NOT NULL DEFAULT '0',
  `session` varchar(12) CHARACTER SET utf8 NOT NULL,
  `unallowed` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`uid`),
  UNIQUE KEY `username` (`username`),
  KEY `email` (`email`),
  KEY `regip` (`regip`)
) ENGINE=MyISAM  ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_user_extend`
--

CREATE TABLE `qmecms_user_extend` (
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `username` varchar(20) CHARACTER SET utf8 NOT NULL,
  `name` varchar(20) NOT NULL,
  `name_purview` tinyint(1) NOT NULL,
  `gid` int(10) unsigned NOT NULL DEFAULT '0',
  `point` int(10) unsigned NOT NULL DEFAULT '0',
  `pic` varchar(120) CHARACTER SET utf8 NOT NULL,
  `pic_modify` int(10) NOT NULL,
  `sex` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `birth_year` mediumint(4) unsigned NOT NULL DEFAULT '0',
  `birth_month` tinyint(2) unsigned NOT NULL DEFAULT '0',
  `birth_day` tinyint(2) unsigned NOT NULL,
  `qq` varchar(15) NOT NULL,
  UNIQUE KEY `uid` (`uid`),
  KEY `gid` (`gid`)
) ENGINE=MyISAM ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_user_group`
--

CREATE TABLE `qmecms_user_group` (
  `gid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gname` varchar(30) CHARACTER SET utf8 NOT NULL,
  `point` int(10) unsigned NOT NULL DEFAULT '0',
  `validity` int(10) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `purview` text CHARACTER SET utf8 NOT NULL,
  PRIMARY KEY (`gid`),
  UNIQUE KEY `gname` (`gname`)
) ENGINE=MyISAM  ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_voteip`
--

CREATE TABLE `qmecms_voteip` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `voteid` int(10) NOT NULL DEFAULT '0',
  `ip` bigint(11) unsigned NOT NULL DEFAULT '0',
  `dateline` varchar(10) NOT NULL DEFAULT '',
  `ie` varchar(100) NOT NULL DEFAULT '',
  `os` varchar(100) NOT NULL DEFAULT '',
  KEY `myid` (`id`)
) ENGINE=MyISAM  ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_voteoption`
--

CREATE TABLE `qmecms_voteoption` (
  `optionid` int(11) NOT NULL AUTO_INCREMENT,
  `voteid` int(11) NOT NULL DEFAULT '0',
  `voteoption` varchar(255) NOT NULL DEFAULT '',
  `number` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`optionid`),
  KEY `voteid` (`voteid`)
) ENGINE=MyISAM  ;

-- --------------------------------------------------------

--
-- Ľṹ `qmecms_votesubject`
--

CREATE TABLE `qmecms_votesubject` (
  `voteid` int(11) NOT NULL AUTO_INCREMENT,
  `subject` varchar(255) NOT NULL DEFAULT '',
  `type` tinyint(1) NOT NULL DEFAULT '0',
  `inputer` varchar(30) NOT NULL DEFAULT '',
  `addtime` int(11) NOT NULL DEFAULT '0',
  `totime` int(11) NOT NULL DEFAULT '0',
  `passed` tinyint(1) NOT NULL DEFAULT '0',
  `checkip` tinyint(1) unsigned NOT NULL,
  PRIMARY KEY (`voteid`),
  KEY `subject` (`subject`,`inputer`)
) ENGINE=MyISAM ;
