<?php
if(!defined('MOD'))  die("access die");
$channelid = intval($_GET['channelid']);
InitParam();
GetList();

function GetList(){
	$jsonArray = array();
	if ($GLOBALS["sDir"] != ""){
		if (strrpos($GLOBALS["sDir"], "/") !== false){
			$s_Url = substr($GLOBALS["sDir"], 0, strrpos($GLOBALS["sDir"], "/"));
		}else{
			$s_Url = "";
		}
		$jsonArray[] = array(1,"..","{$s_Url}","parentfolder");
	}
	if ($handle = @opendir($GLOBALS["sCurrDir"])){
		while (false !== ($file = readdir($handle))){
			$sFileType = filetype($GLOBALS["sCurrDir"] . "/" . $file);
			switch ($sFileType){
				case "dir":
					if (($file != ".") && ($file != "..")){
						$oDirs[] = $file;
					}
					break;
				case "file":
					$oFiles[] = $file;
					break;
				default:
			}
		}
	}

	if (isset($oDirs)){
		foreach($oDirs as $key => $oDir){
			if ($GLOBALS["sDir"] == ""){
				$s_Url = $oDir;
			}else{
				$s_Url = $GLOBALS["sDir"] . "/" . $oDir;
			}
			$jsonArray[] = array(1,"{$oDir}","{$s_Url}","closedfolder");
		}
	}

	if (isset($oFiles)){
		$nFileNum = count($oFiles);
	}else{
		$nFileNum = 0;
	}

	if ($nFileNum > 0){
		foreach($oFiles as $key => $oFile){
			$sFileName = $GLOBALS["sCurrDir"] . $oFile;
			if (CheckValidExt($oFile)){
				if ($GLOBALS["sDir"] == ""){
					$s_Url = $GLOBALS["sContentPath"] . $oFile;
				}else{
					$s_Url = $GLOBALS["sContentPath"] . $GLOBALS["sDir"] . "/" . $oFile;
				}
				$pic =  FileName2Pic($oFile);
				$size = GetSizeUnit(filesize($sFileName));
				$jsonArray[] = array(0,"{$oFile}","{$s_Url}","{$pic}","{$size}");
			}
		}
	}

	if ($GLOBALS["sDir"] == ""){
		$s_Url = "/";
	}else{
		$s_Url = "/" . $GLOBALS["sDir"] . "/";
	}
	$data = array('status'=>200, 'message'=>$jsonArray);
	echo qbase::xmlPrint(qbase::jsonencode( $data));
}

function CheckValidExt($s_FileName){
	if ($GLOBALS["sAllowExt"] == ""){
		return true;
	}
	preg_match("/\.([a-zA-Z0-9]{2,4})$/", $s_FileName, $exts);
	$sExt = $exts[1];
	$aExt = explode('|', $GLOBALS["sAllowExt"]);
	if (!in_array(strtoupper($sExt), $aExt)){
		return false;
	}
	return true;
}

function InitParam(){
	global $_SET, $channelid, $channel, $ext;
	global $sCurrDir, $sDir;
	global $sAllowExt, $sUploadDir, $sBaseUrl, $sContentPath, $sAllowBrowse;
	$sType = toTrim("type");
	if ($channelid >= 0){
		$sUploadDir = $_SET[abspath] . "/attachment/";
		$sSaveDir = $_SET[weburl].$_SET[webpath] . 'attachment/';
	}else{
		$sUploadDir = $_SET[abspath] . "/templates/";
		$sSaveDir = $_SET[weburl].$_SET[webpath] . "templates/";
	}
	$sContentPath = $sSaveDir;
	switch (strtoupper($sType)){
		case "FILE":
			$sAllowExt = $ext['FILE'];
			break;
		case "MEDIA":
			$sAllowExt = $ext['MEDIA'];
			break;
		case "FLASH":
			$sAllowExt = $ext['FLASH'];
			break;
		case "READ":
			$sAllowExt = $ext['READ'];
			break;
		case "ALL":
			$sAllowExt = "";
			break;
		default:
			$sAllowExt = $ext['IMAGE'];
			break;
	}
	$sAllowExt = strtoupper($sAllowExt);
	$sCurrDir = $sUploadDir;
	$sDir = toTrim("dir");
	if ($sDir != ""){
		if (is_dir($sUploadDir . $sDir)){
			$sCurrDir = $sUploadDir . $sDir . "/";
		}else{
			$sDir = "";
		}
	}
}

function toTrim($p){
	if (isset($_GET[$p])){
		return trim($_GET[$p]);
	}else{
		return "";
	}
}

function FileName2Pic($sFileName){
	global $_SET;
	$sExt = strtoupper(substr($sFileName, strrpos($sFileName, ".") + 1));
	switch ($sExt){
		case "TXT":
			$sPicName = "txt";
			break;
		case "CHM":
		case "HLP":
			$sPicName = "hlp";
			break;
		case "DOC":
			$sPicName = "doc";
			break;
		case "PDF":
			$sPicName = "pdf";
			break;
		case "MDB":
			$sPicName = "mdb";
			break;
		case "GIF":
			$sPicName = "gif";
			break;
		case "JPG":
			$sPicName = "jpg";
			break;
		case "BMP":
			$sPicName = "bmp";
			break;
		case "PNG":
			$sPicName = "pic";
			break;
		case "ASP":
		case "JSP":
		case "JS":
		case "PHP":
		case "PHP3":
		case "ASPX":
			$sPicName = "code";
			break;
		case "HTM":
		case "HTML":
		case "SHTML":
			$sPicName = "htm";
			break;
		case "ZIP":
		case "RAR":
			$sPicName = "rar";
			break;
		case "EXE":
			$sPicName = "exe";
			break;
		case "AVI":
			$sPicName = "avi";
			break;
		case "MPG":
		case "MPEG":
		case "ASF":
			$sPicName = "mp";
			break;
		case "RA":
		case "RM":
			$sPicName = "rm";
			break;
		case "MP3":
			$sPicName = "mp3";
			break;
		case "MID":
		case "MIDI":
			$sPicName = "mid";
			break;
		case "WAV":
			$sPicName = "audio";
			break;
		case "XLS":
			$sPicName = "xls";
			break;
		case "PPT":
		case "PPS":
			$sPicName = "ppt";
			break;
		case "SWF":
			$sPicName = "swf";
			break;
		default:
			$sPicName = "unknow";
			break;
	}
	return $sPicName;
}

function GetSizeUnit($n_Size){
	if ($n_Size >= 1024 * 1024){
		return number_format(($n_Size / 1024 / 1024), 1) . "M";
	}elseif($n_Size >= 1024){
		return number_format(($n_Size / 1024), 0) . "K";
	}else{
		return '1K';
	}
}
?>