<?php
require_once('sitemap.php');
class google_xml extends sitemap
{
	var $max = 1024000;
	var $flush_num = 20;
	var $xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><urlset xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n";
	var $write_index = 0;
	var $fp;
	var $file;
	var $file_index = 1;
	var $write_data = array();
	var $file_count_num = 0;
	var $file_count_change = false;
	var $set_map;
	function google_xml() {
		parent::sitemap();
	}

	function build(){
		clearstatcache();
		$this->set_map =  $this->set_dir . "google-open.xml";
		if(!is_file($this->set_map)) $this->init(1);

		$file_inex_count = array(0);
		$dir = glob($this->set_dir . "google-open-*.xml");
		if(is_array($dir)){
			foreach($dir as $name){
				$file_inex_count[] = intval(substr($name, 23, -4));
			}
		}
		$this->file_index = $this->file_count_num = max(1, max($file_inex_count));
		$this->file = $this->set_dir . "google-open-{$this->file_index}.xml";
		if(!is_file($this->file)) $this->create_map($this->file_index);
		$this->fp = fopen($this->file, 'r+');
	}

	function clear(){
		parent::clear('google');
	}

	function add($ids, $channelid) 
	{
		foreach($ids as $val){
			$this->write($this->item($val, $channelid));
		}
		$this->flush();
		if($this->file_count_change) $this->init($this->file_count_num);
	}

	function init($num) 
	{
		clearstatcache();
		$data = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><sitemapindex xmlns=\"http://www.sitemaps.org/schemas/sitemap/0.9\">\n";
		for($i=1; $i<=$num;$i++){
			$localfile = $this->set_dir . "google-open-{$i}.xml";
			$lastmod = date("Y-m-d", is_file($localfile) ? filemtime($localfile) : $_SERVER['REQUEST_TIME']);
			$data .= "<sitemap><loc>" .W_P. "attachment/sitemap/google-open-{$i}.xml</loc><lastmod>{$lastmod}</lastmod></sitemap>\n";
		}
		$data .= '</sitemapindex>';
		qbase::writetofile($this->set_map, $data);
	}

	function next() 
	{
		fclose($this->fp);
		$this->file_index++;
		$this->file = $this->set_dir . "google-open-{$this->file_index}.xml";
		if(!is_file($this->file)) $this->create_map($this->file_index);
		$this->fp = fopen($this->file, 'r+');
		$this->file_count_num++;
		$this->file_count_change = true;
	}

	function create_map($index) 
	{
		$data = '<?xml version="1.0" encoding="UTF-8"?><urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"> </urlset>';
		$file = $this->set_dir . "google-open-{$index}.xml";
		qbase::writetofile($file, $data);
	}

	function write($s, $type = false) 
	{
		$this->write_data[] = $s;
		$this->write_index++;
		if($this->write_index % $this->flush_num == 0){
			$this->flush();
		}
		return true;
	}

	function flush()
	{
		clearstatcache();
		$data = implode("", $this->write_data) . " </urlset>";
		$this->write_data = array();
		$size = filesize($this->file);
		if($size + strlen($data) > $this->max){
			$this->next();
			$size = filesize($this->file);
		}
		fseek($this->fp, $size - 10);
		fwrite($this->fp, $data);
		return true;
	}

	function item($id, $channelid) 
	{
		$table= $this->get_table($channelid);
		if($table === false) return;
		$query = "select id,dateline, channelid, cid, pay, filename, dateline, ver from {$table} where  id= '{$id}' ";
		$data = qdb::QueryFirst($query);

		if(false === ($temp = getCidInfo($data['channelid'], $data['cid']))) return;
		$iif = !($temp['html'] || $temp['pur_browse'] || $data['pay']);
		$url = qbase::GetHtmlDirType($data['channelid'], $data['id'], $temp['ciddir'], $data['dateline'], $data['filename'], $data['ver'], $iif);
		$date = qbase::formatTime('Y-m-d', $data['dateline']);
		$url = $this->specialchars($url);
		return " <url><loc>{$url}</loc><lastmod>{$date}</lastmod><changefreq>daily</changefreq></url> \n";
	}
}
?>