<?php
if(!defined('MOD'))  die("access die");
purviewCheck('database', 'plugin');
@set_time_limit(300);
$action = $_GET['action'] ? $_GET['action'] : 'manage';
$curdir = A_P . '/plugin/database/';
require_once($curdir . 'class.db_back.php');
$back = new db_back($curdir . 'backup/');
switch($action){
	case 'manage':
		$data = readDirFiles($curdir . 'backup/');
		$tables = $back->get_status();
	break;

	case 'dump':
		checkAdminReferer();
		$table = trim($_GET['table']);
		$page = intval($_GET['page']) > 0 ?  intval($_GET['page']) : 1;
		$limit = intval($_GET['limit']);
		$start = intval($_GET['start']);
		if($table == TABLEPRE . "admin"){
			$data = array("status"=>404, "message"=>"ϵͳֹԹԱݱ");
		}else{
			if($start > 0) $back->clear();
			$data = $back->dump($table, $page, $limit);
		}
		die(qbase::xmlPrint(qbase::jsonencode($data)));
	break;

	case 'optimize':
		checkAdminReferer();
		$table = trim($_GET['table']);
		$back->optimize($table);
		$data = array('status'=>200);
		die(qbase::xmlPrint(qbase::jsonencode($data)));
	break;

	case 'repair':
		checkAdminReferer();
		@set_time_limit(300);
		$table = trim($_GET['table']);
		$back->repair($table);
		$data = array('status'=>200);
		die(qbase::xmlPrint(qbase::jsonencode($data)));
	break;

	case 'clear':
		checkAdminReferer();
		$back->clear();
		$data = array('status'=>200);
		die(qbase::xmlPrint(qbase::jsonencode($data)));
	break;

	case 'remove':
		checkAdminReferer();
		$name = trim($_GET['name']);
		if($dir = checkDir($name)){
			qbase::deleteDir($curdir . 'backup/' . $dir . '/');
			qbase::showmsg("ɹ", "default", $_SERVER['HTTP_REFEFER']);
		}else{
			qbase::showmsg("error request");
		}
	break;

	case 'load':
		checkAdminReferer();
		$table = trim($_GET['table']);
		$index = intval($_GET['index']) ? intval($_GET['index']) : 1;
		$name = trim($_GET['name']);
		if($dir = checkDir($name)){
			$file = $curdir . 'backup/' . $dir . '/' . $index . "_" . $table . ".php";
			if(is_file($file)){
				include($file);
				$data = array('status'=>200);
				die(qbase::xmlPrint(qbase::jsonencode($data)));
				exit();
			}else qbase::showmsg("error request");
		}else{
			qbase::showmsg("error request");
		}
	break;

	case 'load_init':
		checkAdminReferer();
		$name = trim($_GET['name']);
		if($dir = checkDir($name)){
			$temp = getDirFiles($dir);
			$data = array();
			$sort =  array('status'=>200, 'data'=>array());
			foreach($temp as $val){
				if(preg_match("/([0-9]{1,9})_([a-z0-9_]{1,64})\.php/i", $val['name'], $load)){
					$data[$load['2']][] = $load[1];
				}
			}
			foreach($data as $table=>$pre){
				$sort['data'][] = array(
					'table'=>$table,
					'max'=>max($pre)
				);
			}
			die(qbase::xmlPrint(qbase::jsonencode($sort)));
		}else{
			qbase::showmsg("error request");
		}
	break;

	case 'info':
		checkAdminReferer();
		$name = trim($_GET['name']);
		if($dir = checkDir($name)){
			$data = array('status'=>200, 'data'=>array());
			if(is_dir($curdir . 'backup/' . $dir . '/')){
				$data['data'] = getDirFiles($dir);
			}
			die(qbase::xmlPrint(qbase::jsonencode($data)));
		}else{
			qbase::showmsg("error request");
		}
	break;
}
include qbase::template($path . 'plugin/database');

function checkDir($name){
	if(preg_match("/([0-9]{4})\-([0-9]{1,2})\-([0-9]{1,2})/", $name, $dir)){
		return $dir[0];
	}
	return false;
}

function getDirFiles($dir){
	global $curdir;
	$name = $curdir . 'backup/' . $dir . '/';
	$data = array();
	$temp = glob($name . '*.php');
	if(is_array($temp)){
		foreach($temp as $val){
			$data[] = array(
				'name'=>basename($val),
				'file'=>$val,
				'size'=>GetSizeUnit(@filesize($val))
			);
		}
	}
	return $data;
}

function readDirFiles($dir){
	if(!is_dir($dir)) return array();
	$handle = @opendir($dir);
	$temp = array();
	while (false !== ($filename = @readdir($handle)))
	{
		if($filename == '.' || $filename == '..') continue;
		if (is_dir($dir . $filename)){
			if(!preg_match("/[^0-9\-]/i", $filename)){
				$temp[] = $filename;
			}
		}
	}
	@closedir($handle);
	return $temp;
}

function GetSizeUnit($n_Size)
{
	if ($n_Size >= 1024 * 1024){
		return number_format(($n_Size / 1024 / 1024), 2) . "M";
	}elseif($n_Size >= 1024){
		return number_format(($n_Size / 1024), 2) . "K";
	}else{
		return $n_Size . 'B';
	}
}

function QE($sql){
	qdb::query($sql);
}
function QC($sql){
	global $_SET;
	$charset = str_replace('-', '', $_SET['def_charset']);
	$sql = preg_replace("/AUTO_INCREMENT=([0-9]{1,11})/", "", $sql);
	$sql = preg_replace("/DEFAULT CHARSET={$charset} COMMENT=(.+?)$/ies", "", $sql);
	qdb::query($sql);
}
?>