var createUpload = function(file){
	var tables = $('upload').getElementsByTagName('table');
	var table = null;
	if(tables.length == 0){
		table = document.createElement("table");
		table.className = 'upload';
		table.setAttribute('border', '0');
		table.setAttribute('width', '100%');
		$('upload').appendChild(table);
	}else{
		table = tables[0];
	}
	var obj = table.insertRow(table.rows.length);
	obj.id = file.id;
	var td = obj.insertCell(0);
	td.innerHTML = "<div id='"+file.id+"_preview' class='preview'></div>";
	td.className = 'icon';
	var td = obj.insertCell(1);
	td.className = 'loading';
	td.innerHTML = '<div class="name-box"><div class="box"><div class="loading" id="'+file.id+'_loading"></div></div><div class="name"><span>'+file.name+'</span></div></div>';
	var td = obj.insertCell(2);
	td.className = 'loading-num';
	var td = obj.insertCell(3);
	td.className = 'status';
	td.innerHTML = 'ϴ';
	parent.qmeCms.dialogView.reHeight();
	return obj;
}
function fileQueued(file) {


}

function fileDialogComplete(numFilesSelected, numFilesQueued) {
	try {
		this.startUpload();
	} catch (ex)  {
        this.debug(ex);
	}
}

function uploadStart(file) {
	
}
function uploadSuccess(file, serverData) {

}

function fileQueueError(file, errorCode, message) {
	try {
		if (errorCode === SWFUpload.QUEUE_ERROR.QUEUE_LIMIT_EXCEEDED) {
			alert("You have attempted to queue too many files.\n" + (message === 0 ? "You have reached the upload limit." : "You may select " + (message > 1 ? "up to " + message + " files." : "one file.")));
			return;
		}
		var obj = $(file.id);
		if(obj == null) obj = createUpload(file);
		switch (errorCode) {
		case SWFUpload.QUEUE_ERROR.FILE_EXCEEDS_SIZE_LIMIT:
			var msg = 'ϴļƵƴС';
			this.debug("Error Code: File too big, File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
			break;
		case SWFUpload.QUEUE_ERROR.ZERO_BYTE_FILE:
			var msg = 'ϴļСô0';
			this.debug("Error Code: Zero byte file, File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
			break;
		case SWFUpload.QUEUE_ERROR.INVALID_FILETYPE:
			var msg = 'ϴļͲƵ';
			this.debug("Error Code: Invalid File Type, File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
			break;
		case SWFUpload.QUEUE_ERROR.QUEUE_LIMIT_EXCEEDED:
			var msg = 'ѡļ̫';
			break;
		default:
			if (file !== null) {
				var msg = 'Unhandled Error';
			}
			this.debug("Error Code: " + errorCode + ", File name: " + file.name + ", File size: " + file.size + ", Message: " + message);
			break;
		}

		obj.cells[1].innerHTML = msg;
		obj.cells[2].innerHTML = '<span class="error"></span>';
		obj.cells[3].innerHTML = '';

	} catch (ex) {
        this.debug(ex);
    }

}

function uploadComplete(file) {
	if (this.getStats().files_queued === 0) {
		return true;
	}else{
		this.startUpload();
	}
}

function queueComplete(numFilesUploaded) {

}
