DROP TABLE IF EXISTS qb_members;
CREATE TABLE `qb_members` (
  `uid` mediumint(7) unsigned NOT NULL auto_increment,
  `username` varchar(30) NOT NULL default '',
  `password` varchar(32) NOT NULL default '',
  PRIMARY KEY  (`uid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_memberdata;
CREATE TABLE `qb_memberdata` (
  `uid` mediumint(7) unsigned NOT NULL default '0',
  `username` varchar(50) NOT NULL default '',
  `question` varchar(32) NOT NULL default '',
  `groupid` smallint(4) NOT NULL default '0',
  `grouptype` tinyint(1) NOT NULL default '0',
  `groups` varchar(255) NOT NULL default '',
  `yz` tinyint(1) NOT NULL default '0',
  `newpm` tinyint(1) NOT NULL default '0',
  `medals` varchar(255) NOT NULL default '',
  `money` mediumint(7) unsigned NOT NULL default '0',
  `totalspace` bigint(13) NOT NULL default '0',
  `usespace` bigint(13) NOT NULL default '0',
  `oltime` int(10) NOT NULL default '0',
  `lastvist` int(10) NOT NULL default '0',
  `lastip` varchar(15) NOT NULL default '',
  `regdate` int(10) NOT NULL default '0',
  `regip` varchar(15) NOT NULL default '',
  `sex` tinyint(1) NOT NULL default '0',
  `bday` date NOT NULL default '0000-00-00',
  `icon` varchar(150) NOT NULL default '',
  `introduce` text NOT NULL,
  `hits` int(7) NOT NULL default '0',
  `lastview` int(10) NOT NULL default '0',
  `oicq` varchar(11) NOT NULL default '',
  `msn` varchar(50) NOT NULL default '',
  `homepage` varchar(150) NOT NULL default '',
  `email` varchar(50) NOT NULL default '',
  `provinceid` mediumint(6) NOT NULL default '0',
  `cityid` mediumint(7) NOT NULL default '0',
  `address` varchar(255) NOT NULL default '',
  `postalcode` varchar(6) NOT NULL default '',
  `mobphone` varchar(12) NOT NULL default '',
  `telephone` varchar(25) NOT NULL default '',
  `idcard` varchar(20) NOT NULL default '',
  `truename` varchar(20) NOT NULL default '',
  `config` text NOT NULL,
  `moneycard` mediumint(7) unsigned NOT NULL default '0',
  `email_yz` tinyint(1) NOT NULL default '0',
  `mob_yz` tinyint(1) NOT NULL default '0',
  `idcard_yz` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`uid`),
  KEY `groups` (`groups`),
  KEY `sex` (`sex`,`bday`,`cityid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_group;
CREATE TABLE `qb_group` (
  `gid` smallint(4) NOT NULL auto_increment,
  `gptype` tinyint(1) NOT NULL default '0',
  `grouptitle` varchar(50) NOT NULL default '',
  `levelnum` mediumint(7) NOT NULL default '0',
  `totalspace` int(10) NOT NULL default '0',
  `allowsearch` tinyint(1) NOT NULL default '0',
  `powerdb` text NOT NULL,
  `allowadmin` tinyint(1) NOT NULL default '0',
  `allowadmindb` text,
  PRIMARY KEY  (`gid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_menu;
CREATE TABLE `qb_menu` (
  `id` mediumint(5) NOT NULL auto_increment,
  `fid` mediumint(5) NOT NULL default '0',
  `name` varchar(80) NOT NULL default '',
  `linkurl` varchar(150) NOT NULL default '',
  `color` varchar(15) NOT NULL default '',
  `target` tinyint(1) NOT NULL default '0',
  `moduleid` tinyint(2) NOT NULL default '0',
  `type` tinyint(2) NOT NULL default '0',
  `hide` tinyint(1) NOT NULL default '0',
  `list` smallint(4) NOT NULL default '0',
  `extend` varchar(30) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_admin_menu;
CREATE TABLE `qb_admin_menu` (
  `id` mediumint(5) NOT NULL auto_increment,
  `fid` mediumint(5) NOT NULL default '0',
  `name` text NOT NULL,
  `linkurl` varchar(150) NOT NULL default '',
  `color` varchar(15) NOT NULL default '',
  `target` tinyint(1) NOT NULL default '0',
  `list` smallint(4) NOT NULL default '0',
  `groupid` mediumint(5) NOT NULL default '0',
  `iftier` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_module;
CREATE TABLE `qb_module` (
  `id` mediumint(5) NOT NULL auto_increment,
  `type` tinyint(1) NOT NULL default '0',
  `name` varchar(30) NOT NULL default '',
  `pre` varchar(20) NOT NULL default '',
  `dirname` varchar(30) NOT NULL default '',
  `domain` varchar(100) NOT NULL default '',
  `admindir` varchar(20) NOT NULL default '',
  `config` text NOT NULL,
  `list` mediumint(5) NOT NULL default '0',
  `admingroup` varchar(150) NOT NULL default '',
  `adminmember` text NOT NULL,
  `ifclose` tinyint(1) NOT NULL default '0',
  `ifsys` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_alonepage;
CREATE TABLE `qb_alonepage` (
  `id` mediumint(5) NOT NULL auto_increment,
  `fid` mediumint(5) NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `title` varchar(100) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `style` varchar(15) NOT NULL default '',
  `tpl_head` varchar(50) NOT NULL default '',
  `tpl_main` varchar(50) NOT NULL default '',
  `tpl_foot` varchar(50) NOT NULL default '',
  `filename` varchar(100) default NULL,
  `filepath` varchar(30) NOT NULL default '',
  `descrip` text NOT NULL,
  `keywords` varchar(255) NOT NULL default '',
  `content` text NOT NULL,
  `hits` int(7) NOT NULL default '0',
  `ishtml` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_config;
CREATE TABLE `qb_config` (
  `c_key` varchar(50) NOT NULL default '',
  `c_value` text NOT NULL,
  `c_descrip` text NOT NULL,
  PRIMARY KEY  (`c_key`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_copyfrom;
CREATE TABLE `qb_copyfrom` (
  `id` mediumint(5) NOT NULL auto_increment,
  `name` varchar(40) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `keywords` (`name`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_hack;
CREATE TABLE `qb_hack` (
  `keywords` varchar(30) NOT NULL default '',
  `name` varchar(30) NOT NULL default '',
  `isclose` tinyint(1) NOT NULL default '0',
  `author` varchar(30) NOT NULL default '',
  `config` text NOT NULL,
  `htmlcode` text NOT NULL,
  `hackfile` text NOT NULL,
  `hacksqltable` text NOT NULL,
  `adminurl` varchar(150) NOT NULL default '',
  `about` text NOT NULL,
  `class1` varchar(30) NOT NULL default '',
  `class2` varchar(30) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `linkname` text NOT NULL,
  `isbiz` tinyint(1) NOT NULL default '0',
  UNIQUE KEY `keywords` (`keywords`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_label;
CREATE TABLE `qb_label` (
  `lid` int(10) NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  `ch` smallint(4) NOT NULL default '0',
  `chtype` tinyint(2) NOT NULL default '0',
  `tag` varchar(50) NOT NULL default '',
  `type` varchar(30) NOT NULL default '',
  `typesystem` tinyint(1) NOT NULL default '0',
  `code` text NOT NULL,
  `divcode` text,
  `hide` tinyint(1) NOT NULL default '0',
  `js_time` int(10) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  `pagetype` tinyint(3) NOT NULL default '0',
  `module` mediumint(6) NOT NULL default '0',
  `fid` mediumint(7) NOT NULL default '0',
  `if_js` tinyint(1) NOT NULL default '0',
  `style` varchar(40) NOT NULL default '',
  PRIMARY KEY  (`lid`),
  KEY `ch` (`ch`,`pagetype`,`module`,`fid`,`chtype`),
  KEY `tag` (`tag`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_form_config;
CREATE TABLE `qb_form_config` (
  `c_key` varchar(50) NOT NULL default '',
  `c_value` text NOT NULL,
  `c_descrip` text NOT NULL,
  PRIMARY KEY  (`c_key`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_form_content;
CREATE TABLE `qb_form_content` (
  `id` mediumint(7) NOT NULL auto_increment,
  `title` varchar(100) NOT NULL default '',
  `mid` smallint(4) NOT NULL default '0',
  `hits` mediumint(7) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  `list` varchar(10) NOT NULL default '',
  `uid` mediumint(7) NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `titlecolor` varchar(15) NOT NULL default '',
  `yz` tinyint(1) NOT NULL default '0',
  `ip` varchar(15) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `hits` (`hits`,`yz`),
  KEY `list` (`list`,`yz`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_form_content_1;
CREATE TABLE `qb_form_content_1` (
  `id` mediumint(7) unsigned NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `truename` varchar(20) NOT NULL default '',
  `sex` int(1) NOT NULL default '0',
  `oicq` varchar(10) NOT NULL default '',
  `mobphone` varchar(11) NOT NULL default '',
  `interest` mediumtext NOT NULL,
  `introduce` mediumtext NOT NULL,
  `sortname` varchar(40) NOT NULL default '',
  `webtime` int(10) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `uid` (`uid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_form_content_2;
CREATE TABLE `qb_form_content_2` (
  `id` mediumint(7) NOT NULL auto_increment,
  `uid` mediumint(7) NOT NULL default '0',
  `workplace` varchar(100) NOT NULL default '',
  `nums` varchar(10) NOT NULL default '',
  `jobrequire` mediumtext NOT NULL,
  `workwhere` varchar(50) NOT NULL default '',
  `wage` varchar(30) NOT NULL default '',
  `asksex` int(1) NOT NULL default '0',
  `schoo_age` varchar(20) NOT NULL default '',
  `wageyear` varchar(12) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `uid` (`uid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_form_content_3;
CREATE TABLE `qb_form_content_3` (
  `id` mediumint(7) NOT NULL auto_increment,
  `uid` mediumint(7) NOT NULL default '0',
  `advicetype` varchar(30) NOT NULL default '',
  `content` mediumtext NOT NULL,
  `truename` varchar(15) NOT NULL default '',
  `email` varchar(50) NOT NULL default '',
  `mobphone` varchar(25) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `uid` (`uid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_form_content_4;
CREATE TABLE `qb_form_content_4` (
  `id` mediumint(7) NOT NULL auto_increment,
  `uid` mediumint(7) NOT NULL default '0',
  `truename` varchar(15) NOT NULL default '',
  `sex` int(1) NOT NULL default '0',
  `age` int(2) NOT NULL default '0',
  `mobphone` varchar(25) NOT NULL default '',
  `metier` varchar(30) NOT NULL default '',
  `my_song` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `uid` (`uid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_form_content_6;
CREATE TABLE `qb_form_content_6` (
  `id` mediumint(7) NOT NULL auto_increment,
  `uid` mediumint(7) NOT NULL default '0',
  `workposition` varchar(50) NOT NULL default '',
  `experience` mediumtext NOT NULL,
  `workyear` int(2) NOT NULL default '0',
  `truename` varchar(15) NOT NULL default '',
  `schoo_age` varchar(15) NOT NULL default '',
  `myage` int(2) NOT NULL default '0',
  `graduateschool` varchar(40) NOT NULL default '',
  `specialty` varchar(50) NOT NULL default '',
  `skill` varchar(50) NOT NULL default '',
  `sex` int(1) NOT NULL default '0',
  `telephone` varchar(25) NOT NULL default '',
  `wage` varchar(20) NOT NULL default '',
  `address` varchar(255) NOT NULL default '',
  `email` varchar(50) NOT NULL default '',
  `oicq` varchar(11) NOT NULL default '',
  `worktime` varchar(15) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `uid` (`uid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_form_module;
CREATE TABLE `qb_form_module` (
  `id` smallint(4) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL default '',
  `list` smallint(4) NOT NULL default '0',
  `style` varchar(50) NOT NULL default '',
  `config` mediumtext NOT NULL,
  `allowpost` varchar(255) NOT NULL default '',
  `endtime` int(10) NOT NULL default '0',
  `about` text NOT NULL,
  `usetitle` tinyint(1) NOT NULL default '0',
  `repeatpost` tinyint(1) NOT NULL default '0',
  `statename` varchar(30) NOT NULL default '',
  `allowview` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_form_reply;
CREATE TABLE `qb_form_reply` (
  `rid` mediumint(7) NOT NULL auto_increment,
  `id` mediumint(7) NOT NULL default '0',
  `mid` mediumint(7) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `content` text NOT NULL,
  `ip` varchar(15) NOT NULL default '',
  PRIMARY KEY  (`rid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_friendlink;
CREATE TABLE `qb_friendlink` (
  `id` mediumint(5) NOT NULL auto_increment,
  `fid` int(7) NOT NULL default '0',
  `name` varchar(30) NOT NULL default '',
  `url` varchar(150) NOT NULL default '',
  `logo` varchar(150) NOT NULL default '',
  `descrip` varchar(255) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `ifhide` tinyint(1) NOT NULL default '0',
  `iswordlink` tinyint(1) default NULL,
  `hits` tinyint(7) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  `uid` int(7) NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `yz` tinyint(1) NOT NULL default '1',
  `endtime` int(10) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `yz` (`yz`,`endtime`,`ifhide`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_friendlink_sort;
CREATE TABLE `qb_friendlink_sort` (
  `fid` mediumint(7) NOT NULL auto_increment,
  `name` varchar(30) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  PRIMARY KEY  (`fid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_pm;
CREATE TABLE `qb_pm` (
  `mid` int(10) unsigned NOT NULL auto_increment,
  `touid` mediumint(8) unsigned NOT NULL default '0',
  `togroups` varchar(80) NOT NULL default '',
  `fromuid` mediumint(8) unsigned NOT NULL default '0',
  `username` varchar(15) NOT NULL default '',
  `type` enum('rebox','sebox','public') NOT NULL default 'rebox',
  `ifnew` tinyint(1) NOT NULL default '0',
  `title` varchar(130) NOT NULL default '',
  `mdate` int(10) unsigned NOT NULL default '0',
  `content` text NOT NULL,
  PRIMARY KEY  (`mid`),
  KEY `touid` (`touid`),
  KEY `fromuid` (`fromuid`),
  KEY `type` (`type`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_guestbook_content;
CREATE TABLE `qb_guestbook_content` (
  `id` int(7) NOT NULL auto_increment,
  `fid` mediumint(7) NOT NULL default '0',
  `ico` tinyint(2) NOT NULL default '0',
  `email` varchar(50) NOT NULL default '',
  `oicq` varchar(11) default NULL,
  `weburl` varchar(150) NOT NULL default '',
  `blogurl` varchar(150) NOT NULL default '',
  `uid` int(7) NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `ip` varchar(15) NOT NULL default '',
  `content` text NOT NULL,
  `yz` tinyint(1) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  `list` int(10) NOT NULL default '0',
  `reply` text NOT NULL,
  `mobphone` varchar(12) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_guestbook_sort;
CREATE TABLE `qb_guestbook_sort` (
  `fid` mediumint(7) unsigned NOT NULL auto_increment,
  `fup` mediumint(7) unsigned NOT NULL default '0',
  `name` varchar(50) NOT NULL default '',
  `mid` smallint(4) NOT NULL default '0',
  `class` smallint(4) NOT NULL default '0',
  `sons` smallint(4) NOT NULL default '0',
  `type` tinyint(1) NOT NULL default '0',
  `admin` varchar(100) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `listorder` tinyint(2) NOT NULL default '0',
  `passwd` varchar(32) NOT NULL default '',
  `logo` varchar(150) NOT NULL default '',
  `descrip` text NOT NULL,
  `style` varchar(50) NOT NULL default '',
  `template` text NOT NULL,
  `jumpurl` varchar(150) NOT NULL default '',
  `maxperpage` tinyint(3) NOT NULL default '0',
  `metatitle` varchar(250) NOT NULL default '',
  `metakeywords` varchar(255) NOT NULL default '',
  `metadescription` varchar(255) NOT NULL default '',
  `allowcomment` tinyint(1) NOT NULL default '0',
  `allowpost` varchar(150) NOT NULL default '',
  `allowviewtitle` varchar(150) NOT NULL default '',
  `allowviewcontent` varchar(150) NOT NULL default '',
  `allowdownload` varchar(150) NOT NULL default '',
  `forbidshow` tinyint(1) NOT NULL default '0',
  `config` mediumtext NOT NULL,
  `index_show` tinyint(1) NOT NULL default '0',
  `contents` mediumint(4) NOT NULL default '0',
  `tableid` varchar(30) NOT NULL default '',
  `dir_name` varchar(50) NOT NULL default '',
  `ifcolor` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`fid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_guestbook_config;
CREATE TABLE `qb_guestbook_config` (
  `c_key` varchar(50) NOT NULL default '',
  `c_value` text NOT NULL,
  `c_descrip` text NOT NULL,
  PRIMARY KEY  (`c_key`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_limitword;
CREATE TABLE `qb_limitword` (
  `id` int(5) NOT NULL auto_increment,
  `oldword` varchar(50) NOT NULL default '',
  `newword` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_ad_norm_place;
CREATE TABLE `qb_ad_norm_place` (
  `id` mediumint(7) NOT NULL auto_increment,
  `keywords` varchar(50) NOT NULL default '',
  `name` varchar(100) NOT NULL default '',
  `type` varchar(30) NOT NULL default '0',
  `isclose` tinyint(1) NOT NULL default '0',
  `begintime` int(10) NOT NULL default '0',
  `endtime` int(10) NOT NULL default '0',
  `adcode` text NOT NULL,
  `posttime` int(10) NOT NULL default '0',
  `list` int(10) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `hits` mediumint(7) NOT NULL default '0',
  `money` mediumint(6) NOT NULL default '0',
  `moneycard` mediumint(6) NOT NULL default '0',
  `ifsale` tinyint(1) NOT NULL default '0',
  `autoyz` tinyint(1) NOT NULL default '0',
  `demourl` varchar(150) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_ad_norm_user;
CREATE TABLE `qb_ad_norm_user` (
  `u_id` mediumint(7) NOT NULL auto_increment,
  `id` mediumint(7) NOT NULL default '0',
  `u_uid` mediumint(7) NOT NULL default '0',
  `u_username` varchar(30) NOT NULL default '',
  `u_day` smallint(4) NOT NULL default '0',
  `u_begintime` int(10) NOT NULL default '0',
  `u_endtime` int(10) NOT NULL default '0',
  `u_hits` mediumint(7) NOT NULL default '0',
  `u_yz` tinyint(1) NOT NULL default '0',
  `u_code` text NOT NULL,
  `u_money` mediumint(7) NOT NULL default '0',
  `u_moneycard` mediumint(7) NOT NULL default '0',
  `u_posttime` int(10) NOT NULL default '0',
  PRIMARY KEY  (`u_id`),
  KEY `u_endtime` (`u_endtime`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_ad_config;
CREATE TABLE `qb_ad_config` (
  `c_key` varchar(50) NOT NULL default '',
  `c_value` text NOT NULL,
  `c_descrip` text NOT NULL,
  PRIMARY KEY  (`c_key`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_ad_compete_place;
CREATE TABLE `qb_ad_compete_place` (
  `id` mediumint(7) NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  `isclose` tinyint(1) NOT NULL default '0',
  `list` int(10) NOT NULL default '0',
  `price` mediumint(5) NOT NULL default '0',
  `day` mediumint(4) NOT NULL default '0',
  `adnum` smallint(3) NOT NULL default '0',
  `wordnum` smallint(3) NOT NULL default '0',
  `autoyz` tinyint(1) NOT NULL default '1',
  `demourl` varchar(150) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_ad_compete_user;
CREATE TABLE `qb_ad_compete_user` (
  `ad_id` mediumint(7) NOT NULL auto_increment,
  `uid` mediumint(7) NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `begintime` int(10) NOT NULL default '0',
  `endtime` int(10) NOT NULL default '0',
  `money` mediumint(6) NOT NULL default '0',
  `id` mediumint(7) NOT NULL default '0',
  `yz` tinyint(1) NOT NULL default '1',
  `adlink` varchar(200) NOT NULL default '',
  `adword` varchar(255) NOT NULL default '',
  `hits` mediumint(7) NOT NULL default '0',
  `color` varchar(20) NOT NULL default '',
  `fonttype` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`ad_id`),
  KEY `id` (`id`,`endtime`,`money`,`yz`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_upfile;
CREATE TABLE `qb_upfile` (
  `up_id` mediumint(7) NOT NULL auto_increment,
  `module_id` smallint(4) NOT NULL default '0',
  `ids` varchar(255) NOT NULL default '0',
  `fid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  `url` varchar(150) NOT NULL default '',
  `filename` varchar(100) NOT NULL default '',
  `num` smallint(5) NOT NULL default '0',
  `if_tmp` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`up_id`),
  KEY `filename` (`filename`),
  KEY `if_tmp` (`if_tmp`),
  KEY `posttime` (`posttime`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_vote_element;
CREATE TABLE `qb_vote_element` (
  `id` int(7) NOT NULL auto_increment,
  `cid` int(7) NOT NULL default '0',
  `title` varchar(50) NOT NULL default '',
  `votenum` int(7) NOT NULL default '0',
  `list` int(10) NOT NULL default '0',
  `img` varchar(100) NOT NULL default '',
  `describes` varchar(255) NOT NULL default '',
  `url` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_vote_comment;
CREATE TABLE `qb_vote_comment` (
  `id` mediumint(7) unsigned NOT NULL auto_increment,
  `cid` mediumint(7) unsigned NOT NULL default '0',
  `vid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) unsigned NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  `content` text NOT NULL,
  `ip` varchar(15) NOT NULL default '',
  `icon` tinyint(3) NOT NULL default '0',
  `yz` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `aid` (`cid`),
  KEY `uid` (`uid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_vote_topic;
CREATE TABLE `qb_vote_topic` (
  `cid` int(7) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL default '',
  `about` text NOT NULL,
  `type` tinyint(4) NOT NULL default '0',
  `limittime` int(10) NOT NULL default '0',
  `limitip` tinyint(1) NOT NULL default '0',
  `ip` text NOT NULL,
  `posttime` int(10) NOT NULL default '0',
  `user` text NOT NULL,
  `begintime` int(10) NOT NULL default '0',
  `endtime` int(10) NOT NULL default '0',
  `forbidguestvote` tinyint(1) NOT NULL default '0',
  `ifcomment` tinyint(1) NOT NULL default '0',
  `tplcode` text NOT NULL,
  `votetype` tinyint(2) NOT NULL default '0',
  `aid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (`cid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_vote_config;
CREATE TABLE `qb_vote_config` (
  `c_key` varchar(50) NOT NULL default '',
  `c_value` text NOT NULL,
  `c_descrip` text NOT NULL,
  PRIMARY KEY  (`c_key`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_area;
CREATE TABLE `qb_area` (
  `fid` mediumint(7) unsigned NOT NULL auto_increment,
  `fup` mediumint(7) unsigned NOT NULL default '0',
  `name` varchar(200) NOT NULL default '',
  `class` smallint(4) NOT NULL default '0',
  `sons` smallint(4) NOT NULL default '0',
  `type` tinyint(1) NOT NULL default '0',
  `admin` varchar(100) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `listorder` tinyint(2) NOT NULL default '0',
  `passwd` varchar(32) NOT NULL default '',
  `logo` varchar(150) NOT NULL default '',
  `descrip` text NOT NULL,
  `style` varchar(50) NOT NULL default '',
  `template` text NOT NULL,
  `jumpurl` varchar(150) NOT NULL default '',
  `maxperpage` tinyint(3) NOT NULL default '0',
  `metakeywords` varchar(255) NOT NULL default '',
  `metadescription` varchar(255) NOT NULL default '',
  `allowcomment` tinyint(1) NOT NULL default '0',
  `allowpost` varchar(150) NOT NULL default '',
  `allowviewtitle` varchar(150) NOT NULL default '',
  `allowviewcontent` varchar(150) NOT NULL default '',
  `allowdownload` varchar(150) NOT NULL default '',
  `forbidshow` tinyint(1) NOT NULL default '0',
  `config` text NOT NULL,
  PRIMARY KEY  (`fid`),
  KEY `fup` (`fup`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_jfabout;
CREATE TABLE `qb_jfabout` (
  `id` mediumint(7) NOT NULL auto_increment,
  `fid` mediumint(5) NOT NULL default '0',
  `title` varchar(150) NOT NULL default '',
  `content` text NOT NULL,
  `list` int(10) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_jfsort;
CREATE TABLE `qb_jfsort` (
  `fid` mediumint(5) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  PRIMARY KEY  (`fid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_moneycard;
CREATE TABLE `qb_moneycard` (
  `id` mediumint(7) NOT NULL auto_increment,
  `passwd` varchar(32) NOT NULL default '',
  `moneyrmb` int(7) NOT NULL default '0',
  `moneycard` int(7) NOT NULL default '0',
  `ifsell` tinyint(1) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `username` varchar(32) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_olpay;
CREATE TABLE `qb_olpay` (
  `id` mediumint(7) NOT NULL auto_increment,
  `orderid` int(10) NOT NULL default '0',
  `numcode` varchar(32) NOT NULL default '',
  `money` varchar(15) NOT NULL default '0',
  `ifpay` tinyint(1) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `username` varchar(32) NOT NULL default '',
  `paytype` tinyint(3) NOT NULL default '0',
  `moduleid` mediumint(5) NOT NULL default '0',
  `formid` mediumint(5) NOT NULL default '0',
  `banktype` varchar(15) NOT NULL default '',
  `articleid` int(10) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `numcode` (`numcode`),
  KEY `paytype` (`paytype`),
  KEY `formid` (`formid`),
  KEY `articleid` (`articleid`),
  KEY `moduleid` (`moduleid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_propagandize;
CREATE TABLE `qb_propagandize` (
  `id` int(10) NOT NULL auto_increment,
  `uid` mediumint(7) NOT NULL default '0',
  `ip` bigint(11) NOT NULL default '0',
  `day` smallint(3) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  `fromurl` varchar(150) NOT NULL default '',
  PRIMARY KEY  (`id`),
  KEY `day` (`day`,`uid`,`ip`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_template;
CREATE TABLE `qb_template` (
  `id` mediumint(5) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL default '',
  `type` smallint(4) NOT NULL default '0',
  `filepath` varchar(100) NOT NULL default '',
  `descrip` text NOT NULL,
  `list` int(10) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_template_bak;
CREATE TABLE `qb_template_bak` (
  `bid` int(7) NOT NULL auto_increment,
  `id` int(7) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  `code` text NOT NULL,
  PRIMARY KEY  (`bid`),
  KEY `id` (`id`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_crontab;
CREATE TABLE `qb_crontab` (
  `id` mediumint(7) NOT NULL auto_increment,
  `title` varchar(100) NOT NULL default '',
  `minutetime` mediumint(4) NOT NULL default '0',
  `daytime` varchar(4) NOT NULL default '0',
  `whiletime` int(10) NOT NULL default '0',
  `lasttime` int(10) NOT NULL default '0',
  `filepath` varchar(50) NOT NULL default '',
  `about` text NOT NULL,
  `ifstop` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `ifstop` (`ifstop`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_moneylog;
CREATE TABLE `qb_moneylog` (
  `id` mediumint(7) NOT NULL auto_increment,
  `uid` mediumint(7) NOT NULL default '0',
  `money` mediumint(7) NOT NULL default '0',
  `about` varchar(255) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `uid` (`uid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_yzimg;
CREATE TABLE `qb_yzimg` (
  `sid` varchar(8) NOT NULL default '',
  `imgnum` varchar(6) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  UNIQUE KEY `sid` (`sid`),
  KEY `posttime` (`imgnum`,`posttime`)
) TYPE=HEAP;


DROP TABLE IF EXISTS qb_news_article;
CREATE TABLE `qb_news_article` (
  `aid` mediumint(7) unsigned NOT NULL auto_increment,
  `title` varchar(150) NOT NULL default '',
  `smalltitle` varchar(100) NOT NULL default '',
  `fid` mediumint(7) unsigned NOT NULL default '0',
  `mid` mediumint(5) NOT NULL default '0',
  `fname` varchar(50) NOT NULL default '',
  `hits` mediumint(7) NOT NULL default '0',
  `pages` smallint(4) NOT NULL default '0',
  `comments` mediumint(7) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  `list` int(10) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `author` varchar(30) NOT NULL default '',
  `copyfrom` varchar(100) NOT NULL default '',
  `copyfromurl` varchar(150) NOT NULL default '',
  `titlecolor` varchar(15) NOT NULL default '',
  `fonttype` tinyint(1) NOT NULL default '0',
  `picurl` varchar(150) NOT NULL default '0',
  `ispic` tinyint(1) NOT NULL default '0',
  `yz` tinyint(1) NOT NULL default '0',
  `yzer` varchar(30) NOT NULL default '',
  `yztime` int(10) NOT NULL default '0',
  `levels` tinyint(2) NOT NULL default '0',
  `levelstime` int(10) NOT NULL default '0',
  `keywords` varchar(100) NOT NULL default '',
  `jumpurl` varchar(150) NOT NULL default '',
  `iframeurl` varchar(150) NOT NULL default '',
  `style` varchar(15) NOT NULL default '',
  `template` varchar(255) NOT NULL default '',
  `target` tinyint(1) NOT NULL default '0',
  `ip` varchar(15) NOT NULL default '',
  `lastfid` mediumint(7) NOT NULL default '0',
  `money` mediumint(7) NOT NULL default '0',
  `buyuser` text NOT NULL,
  `passwd` varchar(32) NOT NULL default '',
  `allowdown` varchar(150) NOT NULL default '',
  `allowview` varchar(150) NOT NULL default '',
  `editer` varchar(30) NOT NULL default '',
  `edittime` int(10) NOT NULL default '0',
  `begintime` int(10) NOT NULL default '0',
  `endtime` int(10) NOT NULL default '0',
  `description` text NOT NULL,
  `lastview` int(10) NOT NULL default '0',
  `digg_num` mediumint(7) NOT NULL default '0',
  `digg_time` int(10) NOT NULL default '0',
  `forbidcomment` tinyint(1) NOT NULL default '0',
  `ifvote` tinyint(1) NOT NULL default '0',
  `heart` varchar(255) NOT NULL default '',
  `htmlname` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`aid`),
  KEY `fid` (`fid`),
  KEY `hits` (`hits`,`yz`,`fid`,`ispic`),
  KEY `lastview` (`yz`,`lastview`,`fid`,`ispic`),
  KEY `list` (`list`,`yz`,`fid`,`ispic`),
  KEY `ispic` (`ispic`),
  KEY `uid` (`uid`),
  KEY `levels` (`levels`),
  KEY `digg_num` (`digg_num`),
  KEY `digg_time` (`digg_time`),
  KEY `mid` (`mid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_news_collection;
CREATE TABLE `qb_news_collection` (
  `id` mediumint(7) NOT NULL auto_increment,
  `aid` int(10) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_news_comment;
CREATE TABLE `qb_news_comment` (
  `cid` mediumint(7) unsigned NOT NULL auto_increment,
  `aid` int(10) unsigned NOT NULL default '0',
  `fid` mediumint(7) unsigned NOT NULL default '0',
  `authorid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) unsigned NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  `content` text NOT NULL,
  `ip` varchar(15) NOT NULL default '',
  `icon` tinyint(3) NOT NULL default '0',
  `yz` tinyint(1) NOT NULL default '0',
  `ifcom` tinyint(1) NOT NULL default '0',
  `agree` mediumint(5) NOT NULL default '0',
  `disagree` mediumint(5) NOT NULL default '0',
  PRIMARY KEY  (`cid`),
  KEY `aid` (`aid`),
  KEY `fid` (`fid`),
  KEY `uid` (`uid`),
  KEY `ifcom` (`ifcom`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_news_config;
CREATE TABLE `qb_news_config` (
  `c_key` varchar(50) NOT NULL default '',
  `c_value` text NOT NULL,
  `c_descrip` text NOT NULL,
  PRIMARY KEY  (`c_key`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_news_fu_article;
CREATE TABLE `qb_news_fu_article` (
  `fid` int(7) NOT NULL default '0',
  `aid` int(10) NOT NULL default '0',
  KEY `fid` (`fid`),
  KEY `aid` (`aid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_news_fu_sort;
CREATE TABLE `qb_news_fu_sort` (
  `fid` mediumint(7) unsigned NOT NULL auto_increment,
  `fup` mediumint(7) unsigned NOT NULL default '0',
  `fmid` mediumint(5) NOT NULL default '0',
  `name` varchar(50) NOT NULL default '',
  `class` smallint(4) NOT NULL default '0',
  `sons` smallint(4) NOT NULL default '0',
  `type` tinyint(1) NOT NULL default '0',
  `admin` varchar(100) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `listorder` tinyint(2) NOT NULL default '0',
  `passwd` varchar(32) NOT NULL default '',
  `logo` varchar(150) NOT NULL default '',
  `descrip` text NOT NULL,
  `style` varchar(50) NOT NULL default '',
  `template` text NOT NULL,
  `jumpurl` varchar(150) NOT NULL default '',
  `maxperpage` tinyint(3) NOT NULL default '0',
  `metakeywords` varchar(255) NOT NULL default '',
  `metadescription` varchar(255) NOT NULL default '',
  `allowcomment` tinyint(1) NOT NULL default '0',
  `allowpost` varchar(150) NOT NULL default '',
  `allowviewtitle` varchar(150) NOT NULL default '',
  `allowviewcontent` varchar(150) NOT NULL default '',
  `allowdownload` varchar(150) NOT NULL default '',
  `forbidshow` tinyint(1) NOT NULL default '0',
  `config` text NOT NULL,
  `list_html` varchar(255) NOT NULL default '',
  `bencandy_html` varchar(255) NOT NULL default '',
  `domain` varchar(150) NOT NULL default '',
  `domain_dir` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`fid`),
  KEY `fup` (`fup`),
  KEY `fmid` (`fmid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_news_gather_rule;
CREATE TABLE `qb_news_gather_rule` (
  `id` mediumint(7) NOT NULL auto_increment,
  `fid` mediumint(7) NOT NULL default '0',
  `type` varchar(15) NOT NULL default '0',
  `fixsystem` varchar(30) NOT NULL default '',
  `filetype` varchar(50) NOT NULL default '',
  `webname` varchar(150) NOT NULL default '',
  `listurl` varchar(150) NOT NULL default '',
  `firstpage` varchar(150) NOT NULL default '',
  `page_begin` int(10) NOT NULL default '0',
  `page_end` int(10) NOT NULL default '0',
  `page_step` int(10) NOT NULL default '0',
  `title_minleng` smallint(5) NOT NULL default '0',
  `listmoreurl` text NOT NULL,
  `link_include_word` text NOT NULL,
  `link_noinclude_word` text NOT NULL,
  `link_replace_word` text NOT NULL,
  `title_replace_word` text NOT NULL,
  `list_begin_code` text NOT NULL,
  `list_end_code` text NOT NULL,
  `list_begin_preg` text NOT NULL,
  `list_end_preg` text NOT NULL,
  `gatherthesame` tinyint(1) NOT NULL default '0',
  `show_begin_preg` text NOT NULL,
  `show_end_preg` text NOT NULL,
  `show_endfile_preg` text NOT NULL,
  `show_begin_code` text NOT NULL,
  `show_end_code` text NOT NULL,
  `show_replace_word` text NOT NULL,
  `show_morepage` varchar(100) NOT NULL default '',
  `show_firstpage` varchar(100) NOT NULL default '',
  `show_spe2page` tinyint(1) NOT NULL default '0',
  `posttime` int(10) NOT NULL default '0',
  `list` int(10) NOT NULL default '0',
  `copypic` tinyint(1) NOT NULL default '0',
  `sort` smallint(4) NOT NULL default '0',
  `file_type` varchar(50) NOT NULL default '',
  `file_minleng` mediumint(6) NOT NULL default '0',
  `file_minsize` int(9) NOT NULL default '0',
  `file_includeword` text NOT NULL,
  `file_noincludeword` text NOT NULL,
  `file_explode` text NOT NULL,
  `file_picwidth` int(8) NOT NULL default '0',
  `file_star_string` varchar(150) NOT NULL default '',
  `title_rule` text NOT NULL,
  `content_rule` text NOT NULL,
  `title_morepage_rull` text NOT NULL,
  `content_morepage_rull` text NOT NULL,
  `charset_type` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_news_keyword;
CREATE TABLE `qb_news_keyword` (
  `id` mediumint(5) NOT NULL auto_increment,
  `keywords` varchar(30) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `ifhide` tinyint(1) NOT NULL default '0',
  `url` varchar(150) NOT NULL default '',
  `num` smallint(4) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `keywords` (`keywords`),
  KEY `num` (`num`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_news_keywordid;
CREATE TABLE `qb_news_keywordid` (
  `id` mediumint(7) NOT NULL default '0',
  `aid` mediumint(7) NOT NULL default '0',
  KEY `id` (`id`),
  KEY `aid` (`aid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_news_reply;
CREATE TABLE `qb_news_reply` (
  `rid` mediumint(7) NOT NULL auto_increment,
  `subhead` varchar(150) NOT NULL default '',
  `postdate` int(10) NOT NULL default '0',
  `aid` mediumint(7) NOT NULL default '0',
  `fid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `topic` tinyint(1) NOT NULL default '0',
  `content` mediumtext NOT NULL,
  `orderid` mediumint(7) NOT NULL default '0',
  PRIMARY KEY  (`rid`),
  KEY `aid` (`aid`,`topic`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_news_report;
CREATE TABLE `qb_news_report` (
  `id` mediumint(7) NOT NULL auto_increment,
  `aid` int(10) NOT NULL default '0',
  `type` varchar(50) NOT NULL default '',
  `uid` mediumint(7) NOT NULL default '0',
  `name` varchar(30) NOT NULL default '',
  `content` text NOT NULL,
  `posttime` int(10) NOT NULL default '0',
  `ip` varchar(15) NOT NULL default '',
  `yz` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_news_sort;
CREATE TABLE `qb_news_sort` (
  `fid` mediumint(7) unsigned NOT NULL auto_increment,
  `fup` mediumint(7) unsigned NOT NULL default '0',
  `fmid` mediumint(5) NOT NULL default '0',
  `name` varchar(50) NOT NULL default '',
  `class` smallint(4) NOT NULL default '0',
  `sons` smallint(4) NOT NULL default '0',
  `type` tinyint(1) NOT NULL default '0',
  `admin` varchar(100) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `listorder` tinyint(2) NOT NULL default '0',
  `passwd` varchar(32) NOT NULL default '',
  `logo` varchar(150) NOT NULL default '',
  `descrip` text NOT NULL,
  `style` varchar(50) NOT NULL default '',
  `template` text NOT NULL,
  `jumpurl` varchar(150) NOT NULL default '',
  `maxperpage` tinyint(3) NOT NULL default '0',
  `metakeywords` varchar(255) NOT NULL default '',
  `metadescription` varchar(255) NOT NULL default '',
  `allowcomment` tinyint(1) NOT NULL default '0',
  `allowpost` varchar(150) NOT NULL default '',
  `allowviewtitle` varchar(150) NOT NULL default '',
  `allowviewcontent` varchar(150) NOT NULL default '',
  `allowdownload` varchar(150) NOT NULL default '',
  `forbidshow` tinyint(1) NOT NULL default '0',
  `config` text NOT NULL,
  `list_html` varchar(255) NOT NULL default '',
  `bencandy_html` varchar(255) NOT NULL default '',
  `domain` varchar(150) NOT NULL default '',
  `domain_dir` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`fid`),
  KEY `fup` (`fup`),
  KEY `fmid` (`fmid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_news_special;
CREATE TABLE `qb_news_special` (
  `id` mediumint(7) NOT NULL auto_increment,
  `fid` mediumint(7) NOT NULL default '0',
  `title` varchar(150) NOT NULL default '',
  `titlecolor` varchar(15) NOT NULL default '',
  `keywords` varchar(100) NOT NULL default '',
  `style` varchar(25) NOT NULL default '',
  `template` varchar(255) NOT NULL default '',
  `picurl` varchar(150) NOT NULL default '',
  `content` mediumtext NOT NULL,
  `aids` text NOT NULL,
  `tids` text NOT NULL,
  `jumpurl` varchar(150) NOT NULL default '',
  `target` tinyint(1) NOT NULL default '0',
  `uid` mediumint(7) NOT NULL default '0',
  `username` varchar(50) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  `list` int(10) NOT NULL default '0',
  `hits` mediumint(7) NOT NULL default '0',
  `lastview` int(10) NOT NULL default '0',
  `levels` tinyint(1) NOT NULL default '0',
  `levelstime` int(10) NOT NULL default '0',
  `htmlfile` varchar(50) NOT NULL default '',
  `banner` varchar(150) NOT NULL default '',
  `allowpost` varchar(255) NOT NULL default '',
  `ifbase` tinyint(1) NOT NULL default '0',
  `htmlname` varchar(80) NOT NULL default '',
  `yz` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `fid` (`fid`),
  KEY `ifbase` (`ifbase`),
  KEY `yz` (`yz`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_news_special_comment;
CREATE TABLE `qb_news_special_comment` (
  `id` mediumint(7) unsigned NOT NULL auto_increment,
  `cid` mediumint(7) unsigned NOT NULL default '0',
  `vid` mediumint(7) NOT NULL default '0',
  `uid` mediumint(7) unsigned NOT NULL default '0',
  `username` varchar(30) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  `content` text NOT NULL,
  `ip` varchar(15) NOT NULL default '',
  `icon` tinyint(3) NOT NULL default '0',
  `yz` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `aid` (`cid`),
  KEY `uid` (`uid`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_news_spsort;
CREATE TABLE `qb_news_spsort` (
  `fid` mediumint(7) unsigned NOT NULL auto_increment,
  `fup` mediumint(7) unsigned NOT NULL default '0',
  `name` varchar(200) NOT NULL default '',
  `class` smallint(4) NOT NULL default '0',
  `sons` smallint(4) NOT NULL default '0',
  `type` tinyint(1) NOT NULL default '0',
  `admin` varchar(100) NOT NULL default '',
  `list` int(10) NOT NULL default '0',
  `listorder` tinyint(2) NOT NULL default '0',
  `passwd` varchar(32) NOT NULL default '',
  `logo` varchar(150) NOT NULL default '',
  `descrip` text NOT NULL,
  `style` varchar(50) NOT NULL default '',
  `template` text NOT NULL,
  `jumpurl` varchar(150) NOT NULL default '',
  `maxperpage` tinyint(3) NOT NULL default '0',
  `metakeywords` varchar(255) NOT NULL default '',
  `metadescription` varchar(255) NOT NULL default '',
  `allowcomment` tinyint(1) NOT NULL default '0',
  `allowpost` varchar(150) NOT NULL default '',
  `allowviewtitle` varchar(150) NOT NULL default '',
  `allowviewcontent` varchar(150) NOT NULL default '',
  `allowdownload` varchar(150) NOT NULL default '',
  `forbidshow` tinyint(1) NOT NULL default '0',
  `config` text NOT NULL,
  `list_html` varchar(255) NOT NULL default '',
  `bencandy_html` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`fid`),
  KEY `fup` (`fup`)
) TYPE=MyISAM;


DROP TABLE IF EXISTS qb_regnum;
CREATE TABLE `qb_regnum` (
  `sid` varchar(8) NOT NULL default '',
  `num` varchar(6) NOT NULL default '',
  `posttime` int(10) NOT NULL default '0',
  UNIQUE KEY `sid` (`sid`),
  KEY `posttime` (`num`,`posttime`)
) TYPE=HEAP;


INSERT INTO `qb_members` VALUES ('1','admin','21232f297a57a5a743894a0e4a801fc3');
INSERT INTO `qb_memberdata` VALUES ('1','admin','','3','1','','1','0','','1259','0','74759118','4303034','1306912698','127.0.0.1','1253678332','127.0.0.1','1','1890-00-00','http://news.net/upload_files/icon/1.jpg','','115','1300686405','888888','','','222@qq.com','20','345','cvbnmmm','','13399999999','','','ѧ','a:1:{s:7:\"endtime\";s:0:\"\";}','5','0','0','0');
INSERT INTO `qb_group` VALUES ('2','1','ο','0','0','0','a:56:{s:10:\"upfileType\";s:0:\"\";s:13:\"upfileMaxSize\";s:0:\"\";s:14:\"PassContribute\";s:1:\"1\";s:17:\"SearchArticleType\";s:1:\"1\";s:16:\"PostArticleYzImg\";s:1:\"1\";s:13:\"EditPassPower\";s:1:\"0\";s:12:\"SetTileColor\";s:1:\"0\";s:14:\"SetSellArticle\";s:1:\"0\";s:17:\"SetSpecialArticle\";s:1:\"0\";s:17:\"SetArticleKeyword\";s:1:\"0\";s:20:\"AddArticleKeywordNum\";s:0:\"\";s:21:\"AddArticleCopyfromNum\";s:0:\"\";s:18:\"SelectArticleStyle\";s:1:\"0\";s:16:\"SelectArticleTpl\";s:1:\"0\";s:13:\"SetArticleTpl\";s:1:\"0\";s:18:\"SetArticlePosttime\";s:1:\"0\";s:18:\"SetArticleViewtime\";s:1:\"0\";s:16:\"SetArticleHitNum\";s:1:\"0\";s:18:\"SetArticlePassword\";s:1:\"0\";s:19:\"SetArticleDownGroup\";s:1:\"0\";s:19:\"SetArticleViewGroup\";s:1:\"0\";s:17:\"SetArticleJumpurl\";s:1:\"0\";s:19:\"SetArticleIframeurl\";s:1:\"0\";s:21:\"SetArticleDescription\";s:1:\"0\";s:16:\"SetArticleTopCom\";s:1:\"0\";s:13:\"SetSmallTitle\";s:1:\"0\";s:19:\"CommentArticleYzImg\";s:1:\"1\";s:17:\"CollectArticleNum\";s:0:\"\";s:15:\"CreatSpecialNum\";s:0:\"\";s:13:\"PostNoDelCode\";s:1:\"0\";s:7:\"SetVote\";s:1:\"0\";s:11:\"SetHtmlName\";s:1:\"0\";s:16:\"PassContributeSP\";s:1:\"0\";s:14:\"AllowUploadMax\";s:1:\"0\";s:11:\"comment_num\";s:2:\"10\";s:10:\"comment_yz\";s:1:\"1\";s:11:\"comment_img\";s:1:\"0\";s:16:\"sell_postauto_yz\";s:1:\"0\";s:15:\"buy_postauto_yz\";s:1:\"0\";s:15:\"post_pingpai_yz\";s:1:\"0\";s:10:\"use2domain\";s:1:\"0\";s:16:\"useHomepageStyle\";s:1:\"0\";s:21:\"view_buy_view_contact\";s:1:\"0\";s:13:\"post_sell_num\";s:0:\"\";s:12:\"post_buy_num\";s:0:\"\";s:13:\"post_news_num\";s:0:\"\";s:14:\"post_photo_num\";s:0:\"\";s:11:\"post_hr_num\";s:0:\"\";s:17:\"post_zhanghui_num\";s:0:\"\";s:12:\"post_ZLG_num\";s:0:\"\";s:16:\"post_pingpai_num\";s:0:\"\";s:19:\"post_baojiadian_num\";s:0:\"\";s:19:\"post_xunjiadian_num\";s:0:\"\";s:24:\"post_info_collection_num\";s:0:\"\";s:18:\"allow_get_homepage\";s:1:\"0\";s:15:\"power_qb_video_\";a:27:{s:17:\"SearchArticleType\";s:1:\"1\";s:19:\"CommentArticleYzImg\";s:1:\"1\";s:11:\"comment_num\";s:2:\"10\";s:17:\"CollectArticleNum\";s:0:\"\";s:15:\"CreatSpecialNum\";s:0:\"\";s:16:\"PassContributeSP\";s:1:\"0\";s:16:\"PostArticleYzImg\";s:1:\"1\";s:14:\"PassContribute\";s:1:\"1\";s:13:\"EditPassPower\";s:1:\"0\";s:13:\"PostNoDelCode\";s:1:\"0\";s:7:\"SetVote\";s:1:\"0\";s:12:\"SetTileColor\";s:1:\"0\";s:14:\"SetSellArticle\";s:1:\"0\";s:18:\"SelectArticleStyle\";s:1:\"0\";s:16:\"SelectArticleTpl\";s:1:\"0\";s:13:\"SetArticleTpl\";s:1:\"0\";s:18:\"SetArticlePosttime\";s:1:\"0\";s:18:\"SetArticleViewtime\";s:1:\"0\";s:16:\"SetArticleHitNum\";s:1:\"0\";s:18:\"SetArticlePassword\";s:1:\"0\";s:19:\"SetArticleDownGroup\";s:1:\"0\";s:19:\"SetArticleViewGroup\";s:1:\"0\";s:17:\"SetArticleJumpurl\";s:1:\"0\";s:19:\"SetArticleIframeurl\";s:1:\"0\";s:21:\"SetArticleDescription\";s:1:\"0\";s:16:\"SetArticleTopCom\";s:1:\"0\";s:11:\"SetHtmlName\";s:1:\"0\";}}','0','');
INSERT INTO `qb_group` VALUES ('3','1','Ա','0','0','0','a:26:{s:10:\"upfileType\";s:0:\"\";s:13:\"upfileMaxSize\";s:0:\"\";s:14:\"PassContribute\";s:1:\"1\";s:13:\"EditPassPower\";s:1:\"0\";s:14:\"AllowUploadMax\";s:1:\"1\";s:11:\"comment_num\";s:0:\"\";s:10:\"comment_yz\";s:1:\"1\";s:11:\"comment_img\";s:1:\"0\";s:16:\"sell_postauto_yz\";s:1:\"0\";s:15:\"buy_postauto_yz\";s:1:\"0\";s:15:\"post_pingpai_yz\";s:1:\"0\";s:10:\"use2domain\";s:1:\"0\";s:16:\"useHomepageStyle\";s:1:\"0\";s:21:\"view_buy_view_contact\";s:1:\"0\";s:13:\"post_sell_num\";s:0:\"\";s:12:\"post_buy_num\";s:0:\"\";s:13:\"post_news_num\";s:0:\"\";s:14:\"post_photo_num\";s:0:\"\";s:11:\"post_hr_num\";s:0:\"\";s:17:\"post_zhanghui_num\";s:0:\"\";s:12:\"post_ZLG_num\";s:0:\"\";s:16:\"post_pingpai_num\";s:0:\"\";s:19:\"post_baojiadian_num\";s:0:\"\";s:19:\"post_xunjiadian_num\";s:0:\"\";s:24:\"post_info_collection_num\";s:0:\"\";s:18:\"allow_get_homepage\";s:1:\"1\";}','1','a:104:{s:13:\"center_config\";s:1:\"1\";s:8:\"user_reg\";s:1:\"1\";s:12:\"center_cache\";s:1:\"1\";s:11:\"module_list\";s:1:\"1\";s:9:\"hack_list\";s:1:\"1\";s:9:\"blend_set\";s:1:\"1\";s:14:\"friendlink_mod\";s:1:\"1\";s:14:\"alonepage_list\";s:1:\"1\";s:9:\"mysql_out\";s:1:\"1\";s:10:\"mysql_into\";s:1:\"1\";s:9:\"mysql_del\";s:1:\"1\";s:9:\"mysql_sql\";s:1:\"1\";s:9:\"menu_list\";s:1:\"1\";s:14:\"adminmenu_list\";s:1:\"1\";s:15:\"membermenu_list\";s:1:\"1\";s:11:\"member_list\";s:1:\"1\";s:8:\"regfield\";s:1:\"1\";s:16:\"member_addmember\";s:1:\"1\";s:10:\"group_list\";s:1:\"1\";s:16:\"group_list_admin\";s:1:\"1\";s:9:\"group_add\";s:1:\"1\";s:10:\"alipay_set\";s:1:\"1\";s:7:\"js_list\";s:1:\"1\";s:12:\"propagandize\";s:1:\"1\";s:11:\"jfadmin_mod\";s:1:\"1\";s:15:\"attachment_list\";s:1:\"1\";s:9:\"area_list\";s:1:\"1\";s:10:\"upgrade_ol\";s:1:\"1\";s:14:\"limitword_list\";s:1:\"1\";s:13:\"copyfrom_list\";s:1:\"1\";s:17:\"limitword_replace\";s:1:\"1\";s:8:\"cnzz_set\";s:1:\"1\";s:12:\"message_send\";s:1:\"1\";s:9:\"mail_send\";s:1:\"1\";s:8:\"sms_send\";s:1:\"1\";s:15:\"logs_login_logs\";s:1:\"1\";s:18:\"logs_admin_do_logs\";s:1:\"1\";s:15:\"style_editstyle\";s:1:\"1\";s:13:\"template_list\";s:1:\"1\";s:8:\"adminmap\";s:1:\"1\";s:7:\"crontab\";s:1:\"1\";s:5:\"login\";s:1:\"1\";s:8:\"moneylog\";s:1:\"1\";s:24:\"Module_news_center_label\";s:1:\"1\";s:25:\"Module_news_center_config\";s:1:\"1\";s:21:\"Module_news_listartic\";s:1:\"1\";s:25:\"Module_news_sort_listsort\";s:1:\"1\";s:23:\"Module_news_postArticle\";s:1:\"1\";s:19:\"Module_news_comment\";s:1:\"1\";s:21:\"Module_news_sort_html\";s:1:\"1\";s:23:\"Module_news_listsp_html\";s:1:\"1\";s:19:\"Module_news_special\";s:1:\"1\";s:18:\"Module_news_spsort\";s:1:\"1\";s:20:\"Module_news_fu_artic\";s:1:\"1\";s:19:\"Module_news_fu_sort\";s:1:\"1\";s:23:\"Module_news_group_power\";s:1:\"1\";s:18:\"Module_news_gather\";s:1:\"1\";s:22:\"Module_news_getkeyword\";s:1:\"1\";s:25:\"Module_photo_center_label\";s:1:\"1\";s:26:\"Module_photo_center_config\";s:1:\"1\";s:22:\"Module_photo_listartic\";s:1:\"1\";s:26:\"Module_photo_sort_listsort\";s:1:\"1\";s:24:\"Module_photo_postArticle\";s:1:\"1\";s:20:\"Module_photo_comment\";s:1:\"1\";s:22:\"Module_photo_sort_html\";s:1:\"1\";s:24:\"Module_photo_listsp_html\";s:1:\"1\";s:20:\"Module_photo_special\";s:1:\"1\";s:19:\"Module_photo_spsort\";s:1:\"1\";s:21:\"Module_photo_fu_artic\";s:1:\"1\";s:20:\"Module_photo_fu_sort\";s:1:\"1\";s:24:\"Module_photo_group_power\";s:1:\"1\";s:22:\"Module_photo_batch_cut\";s:1:\"1\";s:19:\"Module_photo_gather\";s:1:\"1\";s:23:\"Module_photo_getkeyword\";s:1:\"1\";s:25:\"Module_video_center_label\";s:1:\"1\";s:26:\"Module_video_center_config\";s:1:\"1\";s:22:\"Module_video_listartic\";s:1:\"1\";s:26:\"Module_video_sort_listsort\";s:1:\"1\";s:24:\"Module_video_postArticle\";s:1:\"1\";s:20:\"Module_video_comment\";s:1:\"1\";s:22:\"Module_video_sort_html\";s:1:\"1\";s:24:\"Module_video_listsp_html\";s:1:\"1\";s:20:\"Module_video_special\";s:1:\"1\";s:19:\"Module_video_spsort\";s:1:\"1\";s:21:\"Module_video_fu_artic\";s:1:\"1\";s:20:\"Module_video_fu_sort\";s:1:\"1\";s:24:\"Module_video_group_power\";s:1:\"1\";s:23:\"Module_video_getkeyword\";s:1:\"1\";s:16:\"Module_ad_center\";s:1:\"1\";s:21:\"Module_ad_norm_listad\";s:1:\"1\";s:25:\"Module_ad_norm_listuserad\";s:1:\"1\";s:24:\"Module_ad_compete_listad\";s:1:\"1\";s:26:\"Module_ad_compete_listuser\";s:1:\"1\";s:18:\"Module_form_center\";s:1:\"1\";s:23:\"Module_form_form_module\";s:1:\"1\";s:24:\"Module_form_form_content\";s:1:\"1\";s:23:\"Module_guestbook_center\";s:1:\"1\";s:21:\"Module_guestbook_sort\";s:1:\"1\";s:24:\"Module_guestbook_content\";s:1:\"1\";s:18:\"Module_vote_center\";s:1:\"1\";s:20:\"Module_vote_vote_add\";s:1:\"1\";s:21:\"Module_vote_vote_list\";s:1:\"1\";s:24:\"Module_vote_comment_list\";s:1:\"1\";s:6:\"mymenu\";N;}');
INSERT INTO `qb_group` VALUES ('4','1','ǰ̨Ա','0','0','0','a:6:{s:14:\"AllowUploadMax\";s:1:\"0\";s:10:\"upfileType\";s:0:\"\";s:13:\"upfileMaxSize\";s:0:\"\";s:11:\"comment_num\";s:0:\"\";s:10:\"comment_yz\";s:1:\"1\";s:11:\"comment_img\";s:1:\"1\";}','0','a:1:{s:6:\"mymenu\";N;}');
INSERT INTO `qb_group` VALUES ('8','0','ͨԱ','0','50','0','a:55:{s:10:\"upfileType\";s:0:\"\";s:13:\"upfileMaxSize\";s:0:\"\";s:14:\"PassContribute\";s:1:\"1\";s:13:\"EditPassPower\";s:1:\"0\";s:17:\"SearchArticleType\";s:1:\"1\";s:12:\"SetTileColor\";s:1:\"0\";s:14:\"SetSellArticle\";s:1:\"0\";s:13:\"SetSmallTitle\";s:1:\"0\";s:17:\"SetSpecialArticle\";s:1:\"1\";s:17:\"SetArticleKeyword\";s:1:\"1\";s:20:\"AddArticleKeywordNum\";s:1:\"0\";s:16:\"PostArticleYzImg\";s:1:\"0\";s:21:\"AddArticleCopyfromNum\";s:1:\"0\";s:16:\"SelectArticleTpl\";s:1:\"0\";s:13:\"SetArticleTpl\";s:1:\"0\";s:18:\"SelectArticleStyle\";s:1:\"0\";s:18:\"SetArticlePosttime\";s:1:\"0\";s:18:\"SetArticleViewtime\";s:1:\"0\";s:16:\"SetArticleHitNum\";s:1:\"0\";s:18:\"SetArticlePassword\";s:1:\"0\";s:19:\"SetArticleDownGroup\";s:1:\"0\";s:19:\"SetArticleViewGroup\";s:1:\"0\";s:17:\"SetArticleJumpurl\";s:1:\"0\";s:19:\"SetArticleIframeurl\";s:1:\"0\";s:21:\"SetArticleDescription\";s:1:\"0\";s:16:\"SetArticleTopCom\";s:1:\"0\";s:17:\"CollectArticleNum\";s:2:\"30\";s:15:\"CreatSpecialNum\";s:1:\"7\";s:19:\"CommentArticleYzImg\";s:1:\"1\";s:11:\"SetHtmlName\";s:1:\"0\";s:7:\"SetVote\";s:1:\"1\";s:16:\"PassContributeSP\";s:1:\"0\";s:13:\"PostNoDelCode\";s:1:\"0\";s:14:\"AllowUploadMax\";s:1:\"0\";s:11:\"comment_num\";s:0:\"\";s:10:\"comment_yz\";s:1:\"0\";s:11:\"comment_img\";s:1:\"0\";s:16:\"sell_postauto_yz\";s:1:\"1\";s:15:\"buy_postauto_yz\";s:1:\"1\";s:15:\"post_pingpai_yz\";s:1:\"1\";s:10:\"use2domain\";s:1:\"0\";s:16:\"useHomepageStyle\";s:1:\"0\";s:21:\"view_buy_view_contact\";s:1:\"0\";s:13:\"post_sell_num\";s:1:\"5\";s:12:\"post_buy_num\";s:1:\"5\";s:13:\"post_news_num\";s:1:\"5\";s:14:\"post_photo_num\";s:2:\"10\";s:11:\"post_hr_num\";s:1:\"5\";s:17:\"post_zhanghui_num\";s:1:\"5\";s:12:\"post_ZLG_num\";s:1:\"0\";s:16:\"post_pingpai_num\";s:1:\"5\";s:19:\"post_baojiadian_num\";s:1:\"5\";s:19:\"post_xunjiadian_num\";s:1:\"5\";s:24:\"post_info_collection_num\";s:2:\"30\";s:18:\"allow_get_homepage\";s:1:\"1\";}','0','');
INSERT INTO `qb_group` VALUES ('9','0','VIPԱ','10000','0','0','a:54:{s:17:\"SearchArticleType\";s:1:\"0\";s:16:\"PostArticleYzImg\";s:1:\"0\";s:14:\"PassContribute\";s:1:\"1\";s:13:\"EditPassPower\";s:1:\"0\";s:12:\"SetTileColor\";s:1:\"0\";s:14:\"SetSellArticle\";s:1:\"0\";s:17:\"SetSpecialArticle\";s:1:\"0\";s:17:\"SetArticleKeyword\";s:1:\"0\";s:20:\"AddArticleKeywordNum\";s:0:\"\";s:21:\"AddArticleCopyfromNum\";s:0:\"\";s:18:\"SelectArticleStyle\";s:1:\"0\";s:16:\"SelectArticleTpl\";s:1:\"0\";s:13:\"SetArticleTpl\";s:1:\"0\";s:18:\"SetArticlePosttime\";s:1:\"0\";s:18:\"SetArticleViewtime\";s:1:\"0\";s:16:\"SetArticleHitNum\";s:1:\"0\";s:18:\"SetArticlePassword\";s:1:\"0\";s:19:\"SetArticleDownGroup\";s:1:\"0\";s:19:\"SetArticleViewGroup\";s:1:\"0\";s:17:\"SetArticleJumpurl\";s:1:\"0\";s:19:\"SetArticleIframeurl\";s:1:\"0\";s:21:\"SetArticleDescription\";s:1:\"0\";s:16:\"SetArticleTopCom\";s:1:\"0\";s:13:\"SetSmallTitle\";s:1:\"0\";s:19:\"CommentArticleYzImg\";s:1:\"0\";s:17:\"CollectArticleNum\";s:0:\"\";s:15:\"CreatSpecialNum\";s:0:\"\";s:14:\"AllowUploadMax\";s:1:\"0\";s:10:\"upfileType\";s:0:\"\";s:13:\"upfileMaxSize\";s:0:\"\";s:11:\"comment_num\";s:2:\"30\";s:10:\"comment_yz\";s:1:\"0\";s:11:\"comment_img\";s:1:\"0\";s:16:\"sell_postauto_yz\";s:1:\"1\";s:15:\"buy_postauto_yz\";s:1:\"1\";s:15:\"post_pingpai_yz\";s:1:\"1\";s:10:\"use2domain\";s:1:\"1\";s:16:\"useHomepageStyle\";s:1:\"1\";s:21:\"view_buy_view_contact\";s:1:\"1\";s:9:\"topmyinfo\";s:0:\"\";s:12:\"topmyinfoday\";s:0:\"\";s:13:\"topcompanyday\";s:0:\"\";s:13:\"post_sell_num\";s:2:\"50\";s:12:\"post_buy_num\";s:2:\"50\";s:13:\"post_news_num\";s:2:\"50\";s:14:\"post_photo_num\";s:3:\"100\";s:11:\"post_hr_num\";s:2:\"20\";s:17:\"post_zhanghui_num\";s:2:\"20\";s:12:\"post_ZLG_num\";s:1:\"5\";s:19:\"post_baojiadian_num\";s:2:\"50\";s:19:\"post_xunjiadian_num\";s:2:\"50\";s:16:\"post_pingpai_num\";s:2:\"10\";s:24:\"post_info_collection_num\";s:3:\"100\";s:18:\"allow_get_homepage\";s:1:\"1\";}','0','');
INSERT INTO `qb_group` VALUES ('10','0','ʯԱ','30000','0','0','a:50:{s:17:\"SearchArticleType\";s:1:\"0\";s:19:\"CommentArticleYzImg\";s:1:\"0\";s:17:\"CollectArticleNum\";s:0:\"\";s:15:\"CreatSpecialNum\";s:0:\"\";s:16:\"PassContributeSP\";s:1:\"0\";s:16:\"PostArticleYzImg\";s:1:\"0\";s:14:\"PassContribute\";s:1:\"1\";s:13:\"EditPassPower\";s:1:\"0\";s:13:\"PostNoDelCode\";s:1:\"0\";s:7:\"SetVote\";s:1:\"0\";s:12:\"SetTileColor\";s:1:\"0\";s:14:\"SetSellArticle\";s:1:\"0\";s:18:\"SelectArticleStyle\";s:1:\"0\";s:16:\"SelectArticleTpl\";s:1:\"0\";s:13:\"SetArticleTpl\";s:1:\"0\";s:18:\"SetArticlePosttime\";s:1:\"0\";s:18:\"SetArticleViewtime\";s:1:\"0\";s:16:\"SetArticleHitNum\";s:1:\"0\";s:18:\"SetArticlePassword\";s:1:\"0\";s:19:\"SetArticleDownGroup\";s:1:\"0\";s:19:\"SetArticleViewGroup\";s:1:\"0\";s:17:\"SetArticleJumpurl\";s:1:\"0\";s:19:\"SetArticleIframeurl\";s:1:\"0\";s:21:\"SetArticleDescription\";s:1:\"0\";s:16:\"SetArticleTopCom\";s:1:\"0\";s:11:\"SetHtmlName\";s:1:\"0\";s:14:\"AllowUploadMax\";s:1:\"0\";s:10:\"upfileType\";s:0:\"\";s:13:\"upfileMaxSize\";s:0:\"\";s:11:\"comment_num\";s:0:\"\";s:10:\"comment_yz\";s:1:\"1\";s:11:\"comment_img\";s:1:\"1\";s:16:\"sell_postauto_yz\";s:1:\"1\";s:15:\"buy_postauto_yz\";s:1:\"1\";s:15:\"post_pingpai_yz\";s:1:\"1\";s:10:\"use2domain\";s:1:\"1\";s:16:\"useHomepageStyle\";s:1:\"1\";s:21:\"view_buy_view_contact\";s:1:\"1\";s:13:\"post_sell_num\";s:3:\"100\";s:12:\"post_buy_num\";s:3:\"100\";s:13:\"post_news_num\";s:3:\"100\";s:14:\"post_photo_num\";s:3:\"100\";s:11:\"post_hr_num\";s:3:\"100\";s:17:\"post_zhanghui_num\";s:3:\"100\";s:12:\"post_ZLG_num\";s:2:\"10\";s:16:\"post_pingpai_num\";s:2:\"10\";s:19:\"post_baojiadian_num\";s:3:\"100\";s:19:\"post_xunjiadian_num\";s:3:\"100\";s:24:\"post_info_collection_num\";s:3:\"300\";s:18:\"allow_get_homepage\";s:1:\"1\";}','0','');
INSERT INTO `qb_menu` VALUES ('9','0','ѶƵ','/news/','','0','0','0','0','18','30');
INSERT INTO `qb_menu` VALUES ('52','0','Ƽר','/news/listsp.php?fid=1','','0','0','0','0','0','');
INSERT INTO `qb_menu` VALUES ('51','0','վҳ','/','','0','0','0','0','20','0');
INSERT INTO `qb_menu` VALUES ('54','0','Ŷ','/news/digg.php','','0','0','0','0','0','');
INSERT INTO `qb_menu` VALUES ('55','9','','/news/list.php?fid=3','','0','0','0','0','0','');
INSERT INTO `qb_menu` VALUES ('56','9','ITҵ','/news/list.php?fid=4','','0','0','0','0','0','');
INSERT INTO `qb_menu` VALUES ('62','9','ͼƬ','/news/list.php?fid=33','','0','0','0','0','0','');
INSERT INTO `qb_menu` VALUES ('63','9','ȵ¼','/news/list.php?fid=34','','0','0','0','0','0','');
INSERT INTO `qb_menu` VALUES ('64','9','web','/news/list.php?fid=39','','0','0','0','0','0','');
INSERT INTO `qb_admin_menu` VALUES ('12','0','ݹ','','','0','8','3','0');
INSERT INTO `qb_admin_menu` VALUES ('81','12','','index.php?lfj=module_admin&dirname=form&file=form_content&job=list','','0','11','3','0');
INSERT INTO `qb_admin_menu` VALUES ('82','12','Ա','index.php?lfj=module_admin&dirname=guestbook&file=content&job=list','','0','10','3','1');
INSERT INTO `qb_admin_menu` VALUES ('83','0','ǩ/ģ/̬ҳ','','','0','9','3','0');
INSERT INTO `qb_admin_menu` VALUES ('84','83','</a>\r\n<font color=\"#FF0000\">ҳ</font><img src=../images/default/article_elite.gif> <a href=\"../index.php?&ch=1&chtype=0&jobs=show\" target=\"main\">ǩ</a> <A HREF=\'../index.php?&ch=1&MakeIndex=1\' target=\'_blank\' onclick=\"return confirm(\'ȷʵҪҳɾ̬?ɾ̬,и,Ҫµһξ̬.ſԿЧ.\');\">̬</a> <a> ','#','','0','4','3','0');
INSERT INTO `qb_admin_menu` VALUES ('87','0','Աع','','','0','7','3','0');
INSERT INTO `qb_admin_menu` VALUES ('88','87','ԱϹ','index.php?lfj=member&job=list','','0','0','3','0');
INSERT INTO `qb_admin_menu` VALUES ('90','87','Ȩ','index.php?lfj=group&job=list','','0','0','3','1');
INSERT INTO `qb_admin_menu` VALUES ('91','87','Ա̨Ȩ','index.php?lfj=group&job=list_admin','','0','0','3','0');
INSERT INTO `qb_admin_menu` VALUES ('92','0','ϵͳ','','','0','6','3','0');
INSERT INTO `qb_admin_menu` VALUES ('93','92','ȫֲ','index.php?lfj=center&job=config','','0','0','3','0');
INSERT INTO `qb_admin_menu` VALUES ('94','92','վ˵','index.php?lfj=guidemenu&job=list','','0','0','3','0');
INSERT INTO `qb_admin_menu` VALUES ('96','92','ӹ','index.php?lfj=friendlink&job=list','','0','0','3','0');
INSERT INTO `qb_admin_menu` VALUES ('97','92','ҳ','index.php?lfj=alonepage&job=list','','0','0','3','0');
INSERT INTO `qb_admin_menu` VALUES ('98','92','վݿ','index.php?lfj=mysql&job=out','','0','0','3','0');
INSERT INTO `qb_admin_menu` VALUES ('99','92','ܱģ͹','index.php?lfj=module_admin&dirname=form&file=form_module&job=list','','0','0','3','0');
INSERT INTO `qb_admin_menu` VALUES ('102','0','˵','','','0','0','-3','0');
INSERT INTO `qb_module` VALUES ('24','2','ϵͳ','ad_','a_d','','','','0','','','0','0');
INSERT INTO `qb_module` VALUES ('21','2','ܱ','form_','form','','','','0','','','0','0');
INSERT INTO `qb_module` VALUES ('18','2','Ա','guestbook_','guestbook','','','','0','','','0','0');
INSERT INTO `qb_module` VALUES ('30','2','ϵͳ','news_','news','','','a:9:{s:12:\"list_PhpName\";s:18:\"list.php?&fid=$fid\";s:12:\"show_PhpName\";s:29:\"bencandy.php?&fid=$fid&id=$id\";s:8:\"MakeHtml\";N;s:14:\"list_HtmlName1\";N;s:14:\"show_HtmlName1\";N;s:14:\"list_HtmlName2\";N;s:14:\"show_HtmlName2\";N;s:13:\"list_HtmlName\";a:9:{i:1;s:27:\"XinWenZhongXin/{$page}.html\";i:3;s:25:\"SheHuiXinWen/{$page}.html\";i:4;s:20:\"ITYeJie/{$page}.html\";i:31;s:26:\"XinWenTouTiao/{$page}.html\";i:32;s:26:\"TuiJianXinWen/{$page}.html\";i:33;s:25:\"TuPianXinWen/{$page}.html\";i:34;s:26:\"ReDianShiJian/{$page}.html\";i:38;s:24:\"YiYuJingRen/{$page}.html\";i:39;s:22:\"webXinWen/{$page}.html\";}s:13:\"show_HtmlName\";a:8:{i:3;s:59:\"SheHuiXinWen/{$time_Y}{$time_m}{$time_d}/{$id}-{$page}.html\";i:4;s:54:\"ITYeJie/{$time_Y}{$time_m}{$time_d}/{$id}-{$page}.html\";i:31;s:60:\"XinWenTouTiao/{$time_Y}{$time_m}{$time_d}/{$id}-{$page}.html\";i:32;s:60:\"TuiJianXinWen/{$time_Y}{$time_m}{$time_d}/{$id}-{$page}.html\";i:33;s:59:\"TuPianXinWen/{$time_Y}{$time_m}{$time_d}/{$id}-{$page}.html\";i:34;s:60:\"ReDianShiJian/{$time_Y}{$time_m}{$time_d}/{$id}-{$page}.html\";i:38;s:58:\"YiYuJingRen/{$time_Y}{$time_m}{$time_d}/{$id}-{$page}.html\";i:39;s:56:\"webXinWen/{$time_Y}{$time_m}{$time_d}/{$id}-{$page}.html\";}}','10','','','0','1');
INSERT INTO `qb_module` VALUES ('23','2','ͶƱϵͳ','vote_','vote','','','','0','','','0','0');
INSERT INTO `qb_alonepage` VALUES ('1','0','','','1229507597','0','','','','','','friendlink.htm','','','','<table cellSpacing=4 cellPadding=4 width=\"100%\" border=0>\r\n<tbody>\r\n<tr>\r\n<td width=\"20%\"><a href=\"http://www.mmcbbs.com/\" target=_blank>ݼݼ̳</a></td>\r\n<td width=\"20%\"><a href=\"http://www.liuv.net/\" target=_blank>ˮ</a></td>\r\n<td width=\"20%\"><a href=\"http://pic.goodod.com/\" target=_blank>ŷֻͼƬ</a></td>\r\n<td width=\"20%\"><a href=\"http://www.tianyakezhan.com/\" target=_blank>Ŀջ</a></td>\r\n<td width=\"20%\"><a href=\"http://www.czin.cn/\" target=_blank></a></td></tr>\r\n<tr>\r\n<td width=\"20%\"><a href=\"http://www.jneg.com.cn/\" target=_blank>ܼ԰</a></td>\r\n<td width=\"20%\"><a href=\"http://www.wyrj.com/\" target=_blank>˼</a></td>\r\n<td width=\"20%\"><a href=\"http://www.nenbei.com/\" target=_blank>۱</a></td>\r\n<td width=\"20%\"><a href=\"http://www.photosbar.com/\" target=_blank>ͼ</a></td>\r\n<td width=\"20%\"><a href=\"http://www.ok586.cn/\" target=_blank></a></td></tr>\r\n<tr>\r\n<td width=\"20%\"><a href=\"http://www.51solo.net/\" target=_blank>Ұ</a></td>\r\n<td width=\"20%\"><a href=\"http://www.toopd.com/\" target=_blank></a></td>\r\n<td width=\"20%\"><a href=\"http://www.qiqig.com/\" target=_blank></a></td>\r\n<td width=\"20%\"><a href=\"http://www.jxsrjys.com.cn/\" target=_blank>Ľ</a></td>\r\n<td width=\"20%\"><a href=\"http://www.unok.net/\" target=_blank></a></td></tr>\r\n<tr>\r\n<td width=\"20%\"><a href=\"http://mmm.pudou.com/\" target=_blank>˶й</a></td>\r\n<td width=\"20%\"><a href=\"http://www.itzhan.com/\" target=_blank>IT</a></td>\r\n<td width=\"20%\"><a href=\"http://www.hkwtv.com/\" target=_blank></a></td>\r\n<td width=\"20%\">&nbsp;</td>\r\n<td width=\"20%\">&nbsp;</td></tr></tbody></table>','54','0');
INSERT INTO `qb_config` VALUES ('yzImgComment','0','');
INSERT INTO `qb_config` VALUES ('flashtime','0','');
INSERT INTO `qb_config` VALUES ('showComment','1','');
INSERT INTO `qb_config` VALUES ('forbidComment','0','');
INSERT INTO `qb_config` VALUES ('showCommentRows','8','');
INSERT INTO `qb_config` VALUES ('viewNoPassGuestBook','1','');
INSERT INTO `qb_config` VALUES ('yzImgContribute','0','');
INSERT INTO `qb_config` VALUES ('groupPassContribute','3','');
INSERT INTO `qb_config` VALUES ('RegCompany','0','');
INSERT INTO `qb_config` VALUES ('MaxOnlineUser','1000','');
INSERT INTO `qb_config` VALUES ('groupPassShopYz','3,4','');
INSERT INTO `qb_config` VALUES ('groupPassPassGuestBook','3','');
INSERT INTO `qb_config` VALUES ('ifOpenGuestBook','1','');
INSERT INTO `qb_config` VALUES ('yzImgGuestBook','1','');
INSERT INTO `qb_config` VALUES ('ContributeFid','2','');
INSERT INTO `qb_config` VALUES ('groupPassLogYz','3,4','');
INSERT INTO `qb_config` VALUES ('regmoney','5','');
INSERT INTO `qb_config` VALUES ('FtpPwd','admin','');
INSERT INTO `qb_config` VALUES ('PostSortStep','2','');
INSERT INTO `qb_config` VALUES ('ListSonline','2','');
INSERT INTO `qb_config` VALUES ('_Notice','29weSgiaHR0cDovL3d3dy5waHAxNjguY29tL05vdGljZS8/dXJsPSR3ZWJkYlt3d3dfdXJsXSIsUEhQMTY4X1BBVEguImNhY2hlL05vdGljZS5waHAiKTs=','');
INSERT INTO `qb_config` VALUES ('CommentTime','5','');
INSERT INTO `qb_config` VALUES ('weburl','/','');
INSERT INTO `qb_config` VALUES ('MailType','smtp','');
INSERT INTO `qb_config` VALUES ('tenpay_id','1900000109','');
INSERT INTO `qb_config` VALUES ('allowMemberCommentPass','1','');
INSERT INTO `qb_config` VALUES ('AvoidGatherPre','','');
INSERT INTO `qb_config` VALUES ('AvoidCopy','0','');
INSERT INTO `qb_config` VALUES ('AvoidGather','0','');
INSERT INTO `qb_config` VALUES ('AvoidSave','0','');
INSERT INTO `qb_config` VALUES ('adminPostEditType','html','');
INSERT INTO `qb_config` VALUES ('article_show_step','0','');
INSERT INTO `qb_config` VALUES ('ifContribute','1','');
INSERT INTO `qb_config` VALUES ('allowGuestSearch','0','');
INSERT INTO `qb_config` VALUES ('kill_badword','0','');
INSERT INTO `qb_config` VALUES ('ShowKeywordColor','#F70968','');
INSERT INTO `qb_config` VALUES ('ifShowKeyword','1','');
INSERT INTO `qb_config` VALUES ('UseFtp','0','');
INSERT INTO `qb_config` VALUES ('FtpDir','111','');
INSERT INTO `qb_config` VALUES ('FtpWeb','','');
INSERT INTO `qb_config` VALUES ('FtpName','admin','');
INSERT INTO `qb_config` VALUES ('photoShowType','0','');
INSERT INTO `qb_config` VALUES ('groupTime','180','');
INSERT INTO `qb_config` VALUES ('allowGuestCommentPass','1','');
INSERT INTO `qb_config` VALUES ('ShowMenu','0','');
INSERT INTO `qb_config` VALUES ('GuestBookNum','8','');
INSERT INTO `qb_config` VALUES ('ShopNormalSend','8','');
INSERT INTO `qb_config` VALUES ('ShopEmsSend','25','');
INSERT INTO `qb_config` VALUES ('groupUpType','1','');
INSERT INTO `qb_config` VALUES ('allowDownMv','0','');
INSERT INTO `qb_config` VALUES ('QQ_QBappid','40632','');
INSERT INTO `qb_config` VALUES ('is_waterimg','1','');
INSERT INTO `qb_config` VALUES ('alipay_service','create_direct_pay_by_user','');
INSERT INTO `qb_config` VALUES ('HideNopowerPost','1','');
INSERT INTO `qb_config` VALUES ('autoPlayFirstMv','1','');
INSERT INTO `qb_config` VALUES ('allowGuestComment','1','');
INSERT INTO `qb_config` VALUES ('PostNotice','<font face=SimSun>\r\n<p><font face=SimSun>1תݣдԴַ<br />2İȨ뷨ɷ߳е</font></p></font>','');
INSERT INTO `qb_config` VALUES ('ListLeng','70','');
INSERT INTO `qb_config` VALUES ('propagandize_jumpto','/','');
INSERT INTO `qb_config` VALUES ('propagandize_LogDay','5','');
INSERT INTO `qb_config` VALUES ('propagandize_close','0','');
INSERT INTO `qb_config` VALUES ('propagandize_Money','2','');
INSERT INTO `qb_config` VALUES ('YZ_IdcardMoney','20','');
INSERT INTO `qb_config` VALUES ('EditYzEmail','0','');
INSERT INTO `qb_config` VALUES ('EditYzMob','0','');
INSERT INTO `qb_config` VALUES ('EditYzIdcard','0','');
INSERT INTO `qb_config` VALUES ('YZ_EmailMoney','10','');
INSERT INTO `qb_config` VALUES ('YZ_MobMoney','15','');
INSERT INTO `qb_config` VALUES ('MailServer','smtp.163.com','');
INSERT INTO `qb_config` VALUES ('SPlist_filename','html/4special{$fid}/list{$page}.htm','');
INSERT INTO `qb_config` VALUES ('SPbencandy_filename','html/5special{$fid}/show{$id}.htm','');
INSERT INTO `qb_config` VALUES ('YzImg_voice','0','');
INSERT INTO `qb_config` VALUES ('close_count','0','');
INSERT INTO `qb_config` VALUES ('Reg_Field','a:1:{s:8:\\\\\"field_db\\\\\";a:0:{}}','');
INSERT INTO `qb_config` VALUES ('passport_TogetherLogin','1','');
INSERT INTO `qb_config` VALUES ('Listsortnameline','2','');
INSERT INTO `qb_config` VALUES ('ListSonLeng','34','');
INSERT INTO `qb_config` VALUES ('ListSonRows','9','');
INSERT INTO `qb_config` VALUES ('JsListLeng','36','');
INSERT INTO `qb_config` VALUES ('forbidReg','0','');
INSERT INTO `qb_config` VALUES ('cache_time_js','-1','');
INSERT INTO `qb_config` VALUES ('SideSortStyle','side_sort/2','');
INSERT INTO `qb_config` VALUES ('SideTitleStyle','side_tpl/2','');
INSERT INTO `qb_config` VALUES ('JsListRows','5','');
INSERT INTO `qb_config` VALUES ('list_filename','html/{$fid}/{$page}.htm','');
INSERT INTO `qb_config` VALUES ('bencandy_filename','html/{$fid}-{$dirid}/{$id}-{$page}.htm','');
INSERT INTO `qb_config` VALUES ('cache_time_com','-1','');
INSERT INTO `qb_config` VALUES ('ArticleHeart','Ƿ|1.gif\r\n֧|2.gif\r\nܰ|3.gif\r\n|4.gif\r\nЦ|5.gif\r\n|6.gif\r\n|7.gif\r\nԾ|8.gif','');
INSERT INTO `qb_config` VALUES ('heart_time','30','');
INSERT INTO `qb_config` VALUES ('heart_noRecord','1','');
INSERT INTO `qb_config` VALUES ('ForceDel','0','');
INSERT INTO `qb_config` VALUES ('UseArticleDigg','0','');
INSERT INTO `qb_config` VALUES ('forbidRegIp','','');
INSERT INTO `qb_config` VALUES ('sortNUM','24','');
INSERT INTO `qb_config` VALUES ('FtpPort','21','');
INSERT INTO `qb_config` VALUES ('articleNUM','78','');
INSERT INTO `qb_config` VALUES ('cache_time_like','-1','');
INSERT INTO `qb_config` VALUES ('cache_time_new','-1','');
INSERT INTO `qb_config` VALUES ('waterimg','images/default/water.gif','');
INSERT INTO `qb_config` VALUES ('passport_path','../pw7','');
INSERT INTO `qb_config` VALUES ('QQ_appkey','','');
INSERT INTO `qb_config` VALUES ('Del_MoreUpfile','1','');
INSERT INTO `qb_config` VALUES ('passport_type','','');
INSERT INTO `qb_config` VALUES ('QQ_appid','','');
INSERT INTO `qb_config` VALUES ('QQ_login','2','');
INSERT INTO `qb_config` VALUES ('emailOnly','1','');
INSERT INTO `qb_config` VALUES ('reg_group','8','');
INSERT INTO `qb_config` VALUES ('RegYz','1','');
INSERT INTO `qb_config` VALUES ('RewriteUrl','0','');
INSERT INTO `qb_config` VALUES ('index_cache_time','0','');
INSERT INTO `qb_config` VALUES ('label_cache_time','-1','');
INSERT INTO `qb_config` VALUES ('DownLoad_readfile','1','');
INSERT INTO `qb_config` VALUES ('forbid_show_bug','1','');
INSERT INTO `qb_config` VALUES ('passport_url','http://localhost/u/bbs','');
INSERT INTO `qb_config` VALUES ('passport_pre','`dz7`.cdb_','');
INSERT INTO `qb_config` VALUES ('cache_time_pic','-1','');
INSERT INTO `qb_config` VALUES ('list_cache_time','0','');
INSERT INTO `qb_config` VALUES ('bencandy_cache_time','0','');
INSERT INTO `qb_config` VALUES ('showsp_cache_time','0','');
INSERT INTO `qb_config` VALUES ('cache_time_hot','-1','');
INSERT INTO `qb_config` VALUES ('yzImgReg','1','');
INSERT INTO `qb_config` VALUES ('alipay_partner','20883328846','');
INSERT INTO `qb_config` VALUES ('MoneyRatio','100','');
INSERT INTO `qb_config` VALUES ('Money2card','0','');
INSERT INTO `qb_config` VALUES ('cookieDomain','','');
INSERT INTO `qb_config` VALUES ('limitRegTime','','');
INSERT INTO `qb_config` VALUES ('DefaultIndexHtml','0','');
INSERT INTO `qb_config` VALUES ('AutoPassCompany','1','');
INSERT INTO `qb_config` VALUES ('forbidRegName','','');
INSERT INTO `qb_config` VALUES ('UseArticleHeart','1','');
INSERT INTO `qb_config` VALUES ('AutoTitleNum','1','');
INSERT INTO `qb_config` VALUES ('deleteArticleMoney','-1','');
INSERT INTO `qb_config` VALUES ('postArticleMoney','1','');
INSERT INTO `qb_config` VALUES ('comArticleMoney','3','');
INSERT INTO `qb_config` VALUES ('hotArticleNum','100','');
INSERT INTO `qb_config` VALUES ('newArticleTime','24','');
INSERT INTO `qb_config` VALUES ('ListShowIcon','0','');
INSERT INTO `qb_config` VALUES ('autoGetKeyword','0','');
INSERT INTO `qb_config` VALUES ('autoGetSmallPic','1','');
INSERT INTO `qb_config` VALUES ('autoCutSmallPic','1','');
INSERT INTO `qb_config` VALUES ('ForbidRepeatTitle','1','');
INSERT INTO `qb_config` VALUES ('viewNoPassArticle','0','');
INSERT INTO `qb_config` VALUES ('ArticlePicWidth','800','');
INSERT INTO `qb_config` VALUES ('ArticlePicHeight','600','');
INSERT INTO `qb_config` VALUES ('ArticleDownloadDirTime','0','');
INSERT INTO `qb_config` VALUES ('ArticleDownloadUseFtp','0','');
INSERT INTO `qb_config` VALUES ('XunLei_ID','08311','');
INSERT INTO `qb_config` VALUES ('FlashGet_ID','6370','');
INSERT INTO `qb_config` VALUES ('KeepTodayCount','1','');
INSERT INTO `qb_config` VALUES ('ShopOtherSend','18','');
INSERT INTO `qb_config` VALUES ('ForbidShowPhpPage','0','');
INSERT INTO `qb_config` VALUES ('bencandy_filename2','bencandy.php?fid-{$fid}-id-{$id}-page-{$page}.htm','');
INSERT INTO `qb_config` VALUES ('MailPw','8gz','');
INSERT INTO `qb_config` VALUES ('MailId','lfj846@163.com','');
INSERT INTO `qb_config` VALUES ('yeepay_id','10011159269','');
INSERT INTO `qb_config` VALUES ('yeepay_key','jY9VL251GM0ZiX48583Dx520T623054s86587s0kyy39m6x43SqSya689p1L','');
INSERT INTO `qb_config` VALUES ('QQ_QBappkey','befedd71ba4690dc1426','');
INSERT INTO `qb_config` VALUES ('list_filename2','list.php?fid-{$fid}-page-{$page}.htm','');
INSERT INTO `qb_config` VALUES ('FtpHost','127.0.0.1','');
INSERT INTO `qb_config` VALUES ('cookiePre','','');
INSERT INTO `qb_config` VALUES ('bokecc_id','','');
INSERT INTO `qb_config` VALUES ('miibeian_gov_cn','ICP050453','');
INSERT INTO `qb_config` VALUES ('copyright','','');
INSERT INTO `qb_config` VALUES ('mymd5','94305017','');
INSERT INTO `qb_config` VALUES ('companyTrade','еҵ豸\r\nͨе\r\nͨ㲿\r\n\r\n\r\n綯\r\nԪ\r\n\r\n\r\nȫ豸\r\nװ\r\nֽֽƷ\r\n繤\r\n繤\r\nͨǱ\r\nרǱ\r\nͨ豸㲿\r\n칫ĽƷ\r\n롢Լ\r\nճҾƷ\r\nľġľƷ\r\nҾ\r\nõ\r\nƷƷ\r\nʳƷ\r\nͨŲƷ\r\n\r\nӡˢ豸\r\n˶СƷ\r\nЬñ\r\nװ\r\nûѧƷ\r\nũûѧƷ\r\nճ\r\nȾϡϡͿϺī\r\n߻\r\n澫ϸѧƷ\r\nʳƷӼ\r\n\r\nƷ\r\n豸\r\n\r\nԴ\r\n͡ũƷ\r\n\r\nҽҩҽ豸\r\n֯\r\nƤ\r\núƷ\r\nճ\r\n\r\nѵ\r\n֤\r\n\r\n\r\nڴ\r\nά޼װ\r\n桢չ\r\nרҵ¼豸\r\nѧӰ\r\n༭豸\r\nǰ豸\r\nװҵ\r\nز\r\nװ\r\nʵͨ\r\n֤\r\nᡢ\r\nҵ\r\nڡ\r\nʵҵ˾ҵó\r\n¼\r\nг','');
INSERT INTO `qb_config` VALUES ('yzNumReg','0','');
INSERT INTO `qb_config` VALUES ('YzImg_difficult','0','');
INSERT INTO `qb_config` VALUES ('YzImg_string','','');
INSERT INTO `qb_config` VALUES ('YzImg_letter_differ','0','');
INSERT INTO `qb_config` VALUES ('AutoCutFace','0','');
INSERT INTO `qb_config` VALUES ('yzImgAdminLogin','0','');
INSERT INTO `qb_config` VALUES ('upgrade_Record','v7','');
INSERT INTO `qb_config` VALUES ('NewsMakeHtml','0','');
INSERT INTO `qb_config` VALUES ('member_contact','','');
INSERT INTO `qb_config` VALUES ('alipay_transport','https','');
INSERT INTO `qb_config` VALUES ('tenpay_key','8934e7d15453e97507ef794cf7b0519d','');
INSERT INTO `qb_config` VALUES ('memberNotice','ӭӻԾͶ,Ͷɵûֽ!!','');
INSERT INTO `qb_config` VALUES ('SPlist_filename2','listsp.php?fid-{$fid}-page-{$page}.htm','');
INSERT INTO `qb_config` VALUES ('SPbencandy_filename2','showsp.php?fid-{$fid}-id-{$id}-page-{$page}.htm','');
INSERT INTO `qb_config` VALUES ('alipay_key','4hqoy6bl87phm','');
INSERT INTO `qb_config` VALUES ('alipay_id','ay@qibosoft.com','');
INSERT INTO `qb_config` VALUES ('pay99_id','','');
INSERT INTO `qb_config` VALUES ('pay99_key','','');
INSERT INTO `qb_config` VALUES ('sms_es_name','wcb800322','');
INSERT INTO `qb_config` VALUES ('sms_es_key','wcb800321','');
INSERT INTO `qb_config` VALUES ('sms_type','ccell','');
INSERT INTO `qb_config` VALUES ('MailPort','25','');
INSERT INTO `qb_config` VALUES ('alipay_scale','100','');
INSERT INTO `qb_config` VALUES ('updir','upload_files','');
INSERT INTO `qb_config` VALUES ('mirror','http://down.qibosoft.com/other/testv6/upload_files/','');
INSERT INTO `qb_config` VALUES ('path','','');
INSERT INTO `qb_config` VALUES ('sms_wi_id','wcb800322','');
INSERT INTO `qb_config` VALUES ('sms_wi_pwd','wcb800321','');
INSERT INTO `qb_config` VALUES ('sms_ccell_id','82008','');
INSERT INTO `qb_config` VALUES ('sms_ccell_pwd','celllxl','');
INSERT INTO `qb_config` VALUES ('upfileType','.rar .txt .jpg .gif .bmp .png .zip .mp3 .wma .wmv .mpeg .mpg .rm .ram .htm .doc .swf .avi .flv .sql .doc .ppt .xls .chm .pdf','');
INSERT INTO `qb_config` VALUES ('upfileMaxSize','','');
INSERT INTO `qb_config` VALUES ('totalSpace','100','');
INSERT INTO `qb_config` VALUES ('MakeIndexHtmlTime','0','');
INSERT INTO `qb_config` VALUES ('guide_word','վҳ|/|0||51|0\r\nѶƵ|/news/|0||9|30\r\nƼר|/news/listsp.php?fid=1|0||52|\r\nŶ|/news/digg.php|0||54|','');
INSERT INTO `qb_config` VALUES ('QQ_logintime','24','');
INSERT INTO `qb_config` VALUES ('waterAlpha','80','');
INSERT INTO `qb_config` VALUES ('if_gdimg','1','');
INSERT INTO `qb_config` VALUES ('waterpos','7','');
INSERT INTO `qb_config` VALUES ('time','0','');
INSERT INTO `qb_config` VALUES ('admin_url','admin','');
INSERT INTO `qb_config` VALUES ('www_url','http://localhost/u','');
INSERT INTO `qb_config` VALUES ('style_member','blue','');
INSERT INTO `qb_config` VALUES ('style','blue','');
INSERT INTO `qb_config` VALUES ('web_open','1','');
INSERT INTO `qb_config` VALUES ('close_why','վά,\r\nͣ.','');
INSERT INTO `qb_config` VALUES ('MoneyDW','','');
INSERT INTO `qb_config` VALUES ('MoneyName','','');
INSERT INTO `qb_config` VALUES ('UserEmailAutoPass','1','');
INSERT INTO `qb_config` VALUES ('BuySpacesizeMoney','50','');
INSERT INTO `qb_config` VALUES ('UseMoneyType','cms','');
INSERT INTO `qb_config` VALUES ('webmail','admin@admin.com','');
INSERT INTO `qb_config` VALUES ('description','ṩ𱬵Ѷ','');
INSERT INTO `qb_config` VALUES ('metakeywords',' ʱ ','');
INSERT INTO `qb_config` VALUES ('webname','벩ýϵͳ','');
INSERT INTO `qb_config` VALUES ('hideFid','','');
INSERT INTO `qb_hack` VALUES ('alipay_set','ֵ֧߳','0','','','','','','index.php?lfj=alipay&job=list','','other','','9','','0');
INSERT INTO `qb_hack` VALUES ('area_list','','0','','','','','','index.php?lfj=area&job=list','','other','','5','','0');
INSERT INTO `qb_hack` VALUES ('attachment_list','','0','','','','','','index.php?lfj=attachment&job=list','','other','','6','','0');
INSERT INTO `qb_hack` VALUES ('cnzz_set','CNZZͳ','0','','','','','','index.php?lfj=cnzz&job=ask','','other','վ⹦','3','','0');
INSERT INTO `qb_hack` VALUES ('crontab','ʱ','0','','','','','','index.php?lfj=crontab&job=list','','other','ȫ','0','','0');
INSERT INTO `qb_hack` VALUES ('jfadmin_mod','ֽܹ','0','','','','','','index.php?lfj=jfadmin&job=listjf','','other','','7','','0');
INSERT INTO `qb_hack` VALUES ('login','û¼','0','','a:3:{s:10:\"systemType\";s:6:\"php168\";s:9:\"guestcode\";s:0:\"\";}','','','','index.php?lfj=hack&hack=login&job=list','','','','0','','0');
INSERT INTO `qb_hack` VALUES ('logs_login_logs','̨¼־','0','','','','','','index.php?lfj=logs&job=login_logs','','other','־','2','','0');
INSERT INTO `qb_hack` VALUES ('logs_admin_do_logs','̨־','0','','','','','','index.php?lfj=logs&job=admin_logs','','other','־','1','','0');
INSERT INTO `qb_hack` VALUES ('mail_send','ʼȺ','0','','','','','','index.php?lfj=mail&job=send','','other','Ϣ/ʼȺ','2','','0');
INSERT INTO `qb_hack` VALUES ('message_send','վϢȺ','0','','','','','','index.php?lfj=message&job=send','','other','Ϣ/ʼȺ','3','','0');
INSERT INTO `qb_hack` VALUES ('moneycard_make','㿨ֵ','0','','','','','','index.php?lfj=moneycard&job=make','','other','','7','','1');
INSERT INTO `qb_hack` VALUES ('moneylog','ûѻּ¼','0','','','','','','index.php?lfj=moneylog&job=list','','other','ȫ','0','','0');
INSERT INTO `qb_hack` VALUES ('propagandize','ƹ׬ȡֹ','0','','','','','','index.php?lfj=propagandize&job=list','','other','','8','','0');
INSERT INTO `qb_hack` VALUES ('sms_send','ֻȺ','0','','','','','','index.php?lfj=sms&job=send','','other','Ϣ/ʼȺ','1','','0');
INSERT INTO `qb_hack` VALUES ('style_editstyle','','0','','','','','','index.php?lfj=style&job=edittpl','','other','/ģ','2','','0');
INSERT INTO `qb_hack` VALUES ('template_list','ģ','0','','','','','','index.php?lfj=template&job=list','','other','/ģ','1','','0');
INSERT INTO `qb_hack` VALUES ('upgrade_ol','ϵͳ','0','','','','','','index.php?lfj=upgrade&job=get','','other','','4','','0');
INSERT INTO `qb_label` VALUES ('298','','0','0','bodyad','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20090420140457_NOGYw.jpg\";s:7:\"imglink\";s:47:\"http://www.phpwind.net/read-htm-tid-761520.html\";s:5:\"width\";s:3:\"990\";s:6:\"height\";s:2:\"80\";}','a:3:{s:5:\"div_w\";s:3:\"990\";s:5:\"div_h\";s:2:\"80\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1240210319','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('299','','0','0','b2','comment','1','a:25:{s:9:\"tplpart_1\";s:579:\"<div>\r\n  <div style=\"float:left;\"><b><font color=\"#990000\">{$username}</font></b>  <font color=\"#990000\">{$time_m}-{$time_d} \r\n    {$time_H}:{$time_i}</font>  </div>\r\n  <a target=\'_blank\' href=\"$webdb[www_url]/do/comment.php?fid=$fid&id=$aid\" style=\"overflow:hidden;\r\n	text-overflow:ellipsis;\r\n	white-space:nowrap;width:230px;float:left;display:black;\"><font color=\"#0000FF\">{$article}</font></a><div style=\"float:left;\"></div></div>\r\n<div style=\"clear:both;border-bottom:1px dotted #ccc;margin-bottom:5px;width:99%;\"><font color=\"#666666\">{$title}</font></div>\";s:13:\"tplpart_1code\";s:579:\"<div>\r\n  <div style=\"float:left;\"><b><font color=\"#990000\">{$username}</font></b>  <font color=\"#990000\">{$time_m}-{$time_d} \r\n    {$time_H}:{$time_i}</font>  </div>\r\n  <a target=\'_blank\' href=\"$webdb[www_url]/do/comment.php?fid=$fid&id=$aid\" style=\"overflow:hidden;\r\n	text-overflow:ellipsis;\r\n	white-space:nowrap;width:230px;float:left;display:black;\"><font color=\"#0000FF\">{$article}</font></a><div style=\"float:left;\"></div></div>\r\n<div style=\"clear:both;border-bottom:1px dotted #ccc;margin-bottom:5px;width:99%;\"><font color=\"#666666\">{$title}</font></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"comment\";s:11:\"roll_height\";s:2:\"50\";s:3:\"url\";N;s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"200\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";N;s:3:\"asc\";N;s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:149:\" SELECT A.*,A.content AS title,B.title AS article FROM qb_comment A LEFT JOIN qb_article B ON A.aid=B.aid  WHERE A.yz=1  ORDER BY A.cid DESC LIMIT 4 \";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:8:\"titlenum\";s:2:\"80\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"468\";s:5:\"div_h\";s:3:\"190\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1240996241','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('923','','0','0','special_finance_7','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:67:\" <div class=\"al1\"><a href=\"$url\" target=\"_blank\">$title</a></div>\";s:13:\"tplpart_2code\";s:421:\"<div style=\"width:100%;margin:7px\"> \r\n              <div class=\"al\"><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" width=\"90\" height=\"65\" border=\"0\" /></a></div>\r\n              <div  class=\"sm\"> \r\n                <p><span style=\"font-weight:bold;\">$title</span></p>\r\n                <p>$content</p>\r\n              </div>\r\n            </div> \r\n           \";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:24:\"/common_zh_pic/zh_pc.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"7\";s:3:\"sql\";s:158:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid   WHERE A.yz=1   AND R.topic=1 ORDER BY A.list DESC LIMIT 8 \";s:4:\"sql2\";s:170:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid  WHERE A.yz=1  AND A.ispic=1 AND R.topic=1 ORDER BY A.list DESC LIMIT 1 \";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:2:\"60\";s:8:\"titlenum\";s:2:\"38\";s:9:\"titlenum2\";s:2:\"30\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"304\";s:5:\"div_h\";s:3:\"303\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300428550','11','30','21','0','default');
INSERT INTO `qb_label` VALUES ('922','','0','0','special_finance_6','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:75:\"<div><b><a href=\"$url\" target=\"_blank\">$title</a></b><br>\r\n$content</div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:29:\"/common_content/content_1.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"c\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:158:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid   WHERE A.yz=1   AND R.topic=1 ORDER BY A.list DESC LIMIT 5 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"60\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"28\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"205\";s:5:\"div_h\";s:3:\"405\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300428563','11','30','21','0','default');
INSERT INTO `qb_label` VALUES ('921','','0','0','special_finance_5','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:129:\"<p><a href=\"$url\" target=\"_blank\">{$title}</a> <span style=\"color:#727171;padding-left:10px;\">({$time_m}-{$time_d})</span> </p>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"9\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 9 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"385\";s:5:\"div_h\";s:3:\"234\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300428556','11','30','21','0','default');
INSERT INTO `qb_label` VALUES ('920','','0','0','special_finance_4','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:129:\"<p><a href=\"$url\" target=\"_blank\">{$title}</a> <span style=\"color:#727171;padding-left:10px;\">({$time_m}-{$time_d})</span> </p>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"8\";s:3:\"sql\";s:91:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list ASC LIMIT 8 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"380\";s:5:\"div_h\";s:3:\"218\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300428541','11','30','21','0','default');
INSERT INTO `qb_label` VALUES ('472','','0','0','index_ad8','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101109141128_eq3o1.jpg\";s:7:\"imglink\";s:26:\"http://www.chinaccnet.com/\";s:5:\"width\";s:3:\"270\";s:6:\"height\";s:2:\"60\";}','a:3:{s:5:\"div_w\";s:3:\"269\";s:5:\"div_h\";s:2:\"57\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1292642659','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('182','','0','0','Title1','code','0','web','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:3:\"220\";s:5:\"div_h\";s:2:\"23\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1240127514','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('183','','0','0','Title2','code','0','ְƸ','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:3:\"255\";s:5:\"div_h\";s:2:\"26\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1239767486','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('184','','0','0','Title3','code','0','','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:3:\"210\";s:5:\"div_h\";s:2:\"23\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1239022710','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('185','','0','0','Title4','code','0','','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:3:\"210\";s:5:\"div_h\";s:2:\"23\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1239022689','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('186','','0','0','Title5','code','0','','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:3:\"455\";s:5:\"div_h\";s:2:\"24\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1239022487','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('187','','0','0','Title6','code','0','Ա','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1240899624','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('188','','0','0','Title01','code','0','','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:3:\"210\";s:5:\"div_h\";s:2:\"24\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1239022429','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('189','','0','0','Title02','code','0','ܹע','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:3:\"234\";s:5:\"div_h\";s:2:\"23\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1239022631','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('630','','0','0','special_sport_2','code','0','<a href=\"#\"></a> | <a href=\"#\"></a> | <a href=\"#\"></a> ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','22','0','default');
INSERT INTO `qb_label` VALUES ('284','','0','0','Title_jinjaad','code','0','ͶƱ','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:3:\"215\";s:5:\"div_h\";s:2:\"26\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1239022512','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('285','','0','0','jinjaad','hack_vote','0','<SCRIPT src=\'http://www_qibosoft_com/do/vote.php?job=js&cid=6\'></SCRIPT>','a:4:{s:6:\"voteid\";s:1:\"6\";s:5:\"div_w\";s:3:\"229\";s:5:\"div_h\";s:3:\"138\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1239010747','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('919','','0','0','special_finance_3','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:153:\"<div class=\"diao_bt\"><a href=\"$url\" target=\"_blank\">$title</a></div>\r\n            <div class=\"yy\">$content<a href=\"$url\" target=\"_blank\">[ϸ]</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:29:\"/common_content/content_1.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"c\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"1\";s:3:\"sql\";s:158:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid   WHERE A.yz=1   AND R.topic=1 ORDER BY A.list DESC LIMIT 1 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:3:\"120\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"358\";s:5:\"div_h\";s:2:\"85\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300428532','11','30','21','0','default');
INSERT INTO `qb_label` VALUES ('918','','0','0','special_car_32','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:48:\" <a href=\"$url\" target=\"_blank\">$title</a><br>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"7\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 7 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"36\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"243\";s:5:\"div_h\";s:3:\"175\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300428338','11','30','22','0','default');
INSERT INTO `qb_label` VALUES ('916','','0','0','special_car_25','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:298:\"<div class=\"spic\">\r\n        <div class=\"auto_08\"><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" width=\'150\' height=\'99\' onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" border=\"0\" /></a></div>\r\n        <div class=\"SHIPAI\"><a href=\"$ur\" target=\"_blank\">$title</a></div>\r\n      </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:122:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1  AND A.ispic=1   AND A.ispic=1  ORDER BY A.list DESC LIMIT 4 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"26\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"350\";s:5:\"div_h\";s:3:\"320\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300428354','11','30','22','0','default');
INSERT INTO `qb_label` VALUES ('917','','0','0','special_car_29','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:53:\"<div><a href=\"$url\" target=\"_blank\">$title</a></div> \";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"13\";s:3:\"sql\";s:93:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 13 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"46\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"326\";s:5:\"div_h\";s:3:\"312\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300428346','11','30','22','0','default');
INSERT INTO `qb_label` VALUES ('915','','0','0','special_car_24','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:304:\"<div class=\"hpic\">\r\n          <div class=\"auto_08\"><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" width=\'150\' height=\'99\' onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" border=\"0\" /></a></div>\r\n          <div class=\"SHIPAI\"><a href=\"$ur\" target=\"_blank\">$title</a></div>\r\n        </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:123:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1  AND A.ispic=1   AND A.ispic=1  ORDER BY A.list DESC LIMIT 10 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"26\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"988\";s:5:\"div_h\";s:3:\"325\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300428325','11','30','22','0','default');
INSERT INTO `qb_label` VALUES ('338','','0','0','bjsptitle','code','0','Ƽר','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('339','','0','0','bjspecial','specialsort','1','a:34:{s:9:\"tplpart_1\";s:442:\"<div style=\"float:left;margin:5px 0px 0px 5px;width:155px;text-align:center;\"> \r\n             <a href=\"$webdb[www_url]/do/showsp.php?fid=$fid&id=$id\" target=\"_blank\" style=\"display:block;width:120px;height:160px;border:1px #333 solid;margin-bottom:5px;\"><img width=\"120\" height=\"160\" src=\"$picurl\" border=\"0\"></a> \r\n               <A HREF=\"$webdb[www_url]/do/showsp.php?fid=$fid&id=$id\" title=\'$full_title\' target=\"_blank\">$title</A> \r\n</div>\";s:13:\"tplpart_1code\";s:442:\"<div style=\"float:left;margin:5px 0px 0px 5px;width:155px;text-align:center;\"> \r\n             <a href=\"$webdb[www_url]/do/showsp.php?fid=$fid&id=$id\" target=\"_blank\" style=\"display:block;width:120px;height:160px;border:1px #333 solid;margin-bottom:5px;\"><img width=\"120\" height=\"160\" src=\"$picurl\" border=\"0\"></a> \r\n               <A HREF=\"$webdb[www_url]/do/showsp.php?fid=$fid&id=$id\" title=\'$full_title\' target=\"_blank\">$title</A> \r\n</div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:11:\"specialsort\";s:11:\"roll_height\";s:2:\"50\";s:3:\"url\";s:45:\"$webdb[www_url]/do/showsp.php?fid=$fid&id=$id\";s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"200\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:3:\"fid\";s:0:\"\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"amodule\";N;s:7:\"tplpath\";s:24:\"/common_pic/img_div1.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";N;s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:4:\"list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:1:\"1\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:113:\" SELECT A.* FROM qb_special A  WHERE `ifbase`=0  AND A.levels=1  AND A.picurl!=\'\'   ORDER BY A.list DESC LIMIT 6 \";s:4:\"sql2\";s:0:\"\";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:0:\"\";s:8:\"titlenum\";s:2:\"26\";s:9:\"titlenum2\";s:0:\"\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"953\";s:5:\"div_h\";s:3:\"177\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1240899961','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('913','','0','0','special_car_13','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:595:\"<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n                  <tr> \r\n                    <td class=\"Czhouju\"> \r\n                      <div class=\"L left_tu\"><img src=\"$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" width=\"80\" height=\"60\" /></div>\r\n                      <div class=\"L right_zi\"> <a href=\"$url\" target=\"_blank\" style=\"color:#004276;\">$title</a><br>$content<a href=\"$url\" target=\"_blank\" style=\"color:#98122A;\">[ȫ]</a><br>\r\n                      </div>\r\n                    </td>\r\n                  </tr>\r\n                </table>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:33:\"/common_pic/title_pic_content.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:2:\"cp\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"2\";s:3:\"sql\";s:187:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid   WHERE A.yz=1  AND A.ispic=1   AND A.ispic=1  AND R.topic=1 ORDER BY A.list ASC LIMIT 2 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"70\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"36\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"355\";s:5:\"div_h\";s:3:\"174\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300428302','11','30','22','0','default');
INSERT INTO `qb_label` VALUES ('914','','0','0','special_car_23','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:49:\"<A HREF=\"$url\" target=\'_blank\'  >$title</a><br>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:24:\"/common_title/0title.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 4 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"223\";s:5:\"div_h\";s:2:\"90\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300428312','11','30','22','0','default');
INSERT INTO `qb_label` VALUES ('912','','0','0','special_car_12','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:56:\"<div><a href=\"$url\" target=\"_blank\">$title</a> </div>   \";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 5 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"46\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"352\";s:5:\"div_h\";s:3:\"137\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300428291','11','30','22','0','default');
INSERT INTO `qb_label` VALUES ('911','','0','0','special_car_10','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:653:\"<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n                  <tr> \r\n                    <td class=\"Czhouju\"> \r\n                      <div class=\"L left_tu\"><a href=\"$url\" target=\"_blank\"><img width=\'95\' height=\'64\' src=\"$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" border=\"0\" /></a></div>\r\n                      <div class=\"L right_zi\"> <a href=\"$url\" style=\"color:#004276;\" target=\"_blank\">$title</a><br>\r\n                        $content<span href=\"$url\" style=\"color:#98122A;\">[ϸ]</span><br>\r\n                      </div>\r\n                    </td>\r\n                  </tr>\r\n                </table>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:33:\"/common_pic/title_pic_content.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:2:\"cp\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"3\";s:3:\"sql\";s:188:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid   WHERE A.yz=1  AND A.ispic=1   AND A.ispic=1  AND R.topic=1 ORDER BY A.list DESC LIMIT 3 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"60\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"363\";s:5:\"div_h\";s:3:\"248\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300428279','11','30','22','0','default');
INSERT INTO `qb_label` VALUES ('304','','0','0','a2','member','1','a:19:{s:9:\"tplpart_1\";s:504:\"<div style=\"float:left;margin-right:5px;margin-top:7px;margin-bottom:3px;\"> <CENTER><a style=\"display:block;width:65px;height:65px;border:1px solid #ccc;\" href=\"$webdb[www_url]/member/homepage.php?uid=$uid\" target=\"_blank\"><img style=\"border:2px solid #fff;\" onerror=\"this.src=\'$webdb[www_url]/images/default/noface.gif\'\" width=\"65\" height=\"65\" src=\"$picurl\" border=\"0\"></a><A HREF=\"$webdb[www_url]/member/homepage.php?uid=$uid\" title=\'$full_title\' target=\"_blank\">$title</A></CENTER>\r\n            </div>\";s:13:\"tplpart_1code\";s:504:\"<div style=\"float:left;margin-right:5px;margin-top:7px;margin-bottom:3px;\"> <CENTER><a style=\"display:block;width:65px;height:65px;border:1px solid #ccc;\" href=\"$webdb[www_url]/member/homepage.php?uid=$uid\" target=\"_blank\"><img style=\"border:2px solid #fff;\" onerror=\"this.src=\'$webdb[www_url]/images/default/noface.gif\'\" width=\"65\" height=\"65\" src=\"$picurl\" border=\"0\"></a><A HREF=\"$webdb[www_url]/member/homepage.php?uid=$uid\" title=\'$full_title\' target=\"_blank\">$title</A></CENTER>\r\n            </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:7:\"group_1\";s:0:\"\";s:7:\"group_2\";s:0:\"\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"6\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:7:\"regdate\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";N;s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:173:\" SELECT M.username AS title,D.*,D.icon AS picurl,D.introduce AS content FROM qb_members M LEFT JOIN qb_memberdata D ON M.uid=D.uid  WHERE 1  ORDER BY D.regdate DESC LIMIT 6 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"20\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"235\";s:5:\"div_h\";s:3:\"190\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1240994881','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('305','','0','0','Title04','code','0','ÿ','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('306','','0','0','c02','guestbook','1','a:25:{s:9:\"tplpart_1\";s:384:\"<div> <b><font color=\"#990000\">{$username}</font></b> <font color=\"#990000\"> {$time_m}-{$time_d} \r\n    {$time_H}:{$time_i} </font>:</div> \r\n<div style=\"clear:both;border-bottom:1px dotted #ccc;margin-bottom:5px;width:98%;padding-bottom:6px;\"><a href=\"$webdb[www_url]/do/guestbook.php?fid=$fid&id=$id#$id\" target=\"_blank\"><font color=\"#666666\">{$title}</font></a></div>\r\n\";s:13:\"tplpart_1code\";s:384:\"<div> <b><font color=\"#990000\">{$username}</font></b> <font color=\"#990000\"> {$time_m}-{$time_d} \r\n    {$time_H}:{$time_i} </font>:</div> \r\n<div style=\"clear:both;border-bottom:1px dotted #ccc;margin-bottom:5px;width:98%;padding-bottom:6px;\"><a href=\"$webdb[www_url]/do/guestbook.php?fid=$fid&id=$id#$id\" target=\"_blank\"><font color=\"#666666\">{$title}</font></a></div>\r\n\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:9:\"guestbook\";s:11:\"roll_height\";s:2:\"50\";s:3:\"url\";N;s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"200\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";N;s:3:\"asc\";N;s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:86:\" SELECT A.*,content AS title FROM qb_guestbook A  WHERE 1  ORDER BY A.id DESC LIMIT 4 \";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:8:\"titlenum\";s:2:\"70\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"231\";s:5:\"div_h\";s:3:\"260\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1240898314','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('470','','0','0','index_ad5','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101027171021_fndoi.gif\";s:7:\"imglink\";s:26:\"http://www.chinaccnet.com/\";s:5:\"width\";s:3:\"220\";s:6:\"height\";s:2:\"50\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1292642651','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('471','','0','0','index_ad7','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101109141121_uu6ot.gif\";s:7:\"imglink\";s:19:\"http://u.admin5.com\";s:5:\"width\";s:3:\"990\";s:6:\"height\";s:2:\"70\";}','a:3:{s:5:\"div_w\";s:3:\"991\";s:5:\"div_h\";s:2:\"68\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1291791530','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('910','','0','0','special_car_8','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:55:\" <div><a href=\"$url\" target=\"_blank\">$title</a> </div> \";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:91:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list ASC LIMIT 6 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"44\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"347\";s:5:\"div_h\";s:3:\"139\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300428270','11','30','22','0','default');
INSERT INTO `qb_label` VALUES ('364','','0','0','bb1','code','0','<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"3\" bgcolor=\"#ffffff\">\r\n        <tr align=\"center\" bgcolor=\"#EBEBEB\"> \r\n          <td width=\"36%\">ְλ</td>\r\n          <td width=\"13%\">ѧ</td>\r\n          <td width=\"14%\">Ա</td>\r\n          <td width=\"13%\"></td>\r\n          <td width=\"13%\"></td>\r\n          <td width=\"11%\"></td>\r\n        </tr> \r\n</table>','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:3:\"475\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1239768502','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('365','','0','0','bb2','form','1','a:31:{s:9:\"tplpart_1\";s:527:\"<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"3\" style=\"border-bottom:1px dotted #eee;\">\r\n        <tr align=\"center\"> \r\n          \r\n    <td width=\"36%\" align=\"left\"> $workposition</td>\r\n          <td width=\"13%\">$schoo_age</td>\r\n          <td width=\"14%\">$sex</td>\r\n          <td width=\"13%\">{$workyear} </td>\r\n          <td width=\"13%\">{$myage} </td>\r\n          \r\n    <td width=\"11%\"><a href=\"$webdb[www_url]/do/bencandy_form.php?mid=$mid&id=$id\" target=\"_blank\"></a></td>\r\n        </tr> \r\n      </table>\";s:13:\"tplpart_1code\";s:527:\"<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"3\" style=\"border-bottom:1px dotted #eee;\">\r\n        <tr align=\"center\"> \r\n          \r\n    <td width=\"36%\" align=\"left\"> $workposition</td>\r\n          <td width=\"13%\">$schoo_age</td>\r\n          <td width=\"14%\">$sex</td>\r\n          <td width=\"13%\">{$workyear} </td>\r\n          <td width=\"13%\">{$myage} </td>\r\n          \r\n    <td width=\"11%\"><a href=\"$webdb[www_url]/do/bencandy_form.php?mid=$mid&id=$id\" target=\"_blank\"></a></td>\r\n        </tr> \r\n      </table>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:4:\"form\";s:11:\"roll_height\";s:2:\"50\";s:3:\"url\";N;s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"200\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"amodule\";s:1:\"6\";s:7:\"tplpath\";s:16:\"/form/askjob.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:3:\"all\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";N;s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";N;s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:195:\" SELECT A.*,R.*,config AS M_config FROM qb_form_content A LEFT JOIN qb_form_content_6 R ON A.id=R.id LEFT JOIN qb_form_module F ON A.mid=F.id  WHERE 1  AND A.mid=\'6\'  ORDER BY A.id DESC  LIMIT 5 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:0:\"\";s:8:\"titlenum\";s:2:\"20\";s:9:\"titlenum2\";s:0:\"\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1240899424','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('318','','0','0','b02','code','0','<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"3\" bgcolor=\"#ffffff\">\r\n        <tr align=\"center\" bgcolor=\"#EBEBEB\"> \r\n          <td width=\"36%\">Ƹְλ</td>\r\n          <td width=\"13%\">ѧҪ</td>\r\n          <td width=\"14%\">ԱҪ</td>\r\n          <td width=\"13%\">Ҫ</td>\r\n          <td width=\"13%\">н</td>\r\n          <td width=\"11%\"></td>\r\n        </tr> \r\n      </table>','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:3:\"490\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1239022772','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('909','','0','0','special_car_7','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:300:\"<div class=\"Calign\"> \r\n                <div class=\"Text\"> <span><a href=\"$url\" target=\"_blank\">$title</a></span></div>\r\n                <div class=\"line_ys\"> <span style=\"text-indent:20px;\">$content<a href=\"$url\" style=\"color:#98122A;\">[ȫ]</a></span></div>\r\n                 \r\n              </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:29:\"/common_content/content_1.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"c\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"2\";s:3:\"sql\";s:158:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid   WHERE A.yz=1   AND R.topic=1 ORDER BY A.list DESC LIMIT 2 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:3:\"160\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"370\";s:5:\"div_h\";s:3:\"207\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300428262','11','30','22','0','default');
INSERT INTO `qb_label` VALUES ('908','','0','0','special_sport_23','article','1','a:32:{s:13:\"tplpart_1code\";s:194:\"<div class=\"content_list\"><span>[<a href=\"$list_url\" target=\"_blank\">$fname</a>]<a href=\"$url\" target=\"_blank\">$title</a></span> \r\n                    <font>{$time_m}{$time_d}</font></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"15\";s:3:\"sql\";s:102:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'0\'   ORDER BY A.list ASC LIMIT 15 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"468\";s:5:\"div_h\";s:3:\"450\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290134248','11','30','19','0','default');
INSERT INTO `qb_label` VALUES ('907','','0','0','special_sport_22','article','1','a:32:{s:13:\"tplpart_1code\";s:194:\"<div class=\"content_list\"><span>[<a href=\"$list_url\" target=\"_blank\">$fname</a>]<a href=\"$url\" target=\"_blank\">$title</a></span> \r\n                    <font>{$time_m}{$time_d}</font></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"15\";s:3:\"sql\";s:103:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'0\'   ORDER BY A.list DESC LIMIT 15 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"468\";s:5:\"div_h\";s:3:\"466\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290134230','11','30','19','0','default');
INSERT INTO `qb_label` VALUES ('317','','0','0','Title05','code','0','̳ǹ','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1239778992','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('319','','0','0','b022','form','1','a:31:{s:9:\"tplpart_1\";s:521:\"<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"3\" style=\"border-bottom:1px dotted #eee;\">\r\n        <tr align=\"center\"> \r\n          \r\n    <td width=\"36%\" align=\"left\">&nbsp;$workplace</td>\r\n          <td width=\"13%\">$schoo_age</td>\r\n          <td width=\"14%\">$asksex</td>\r\n          <td width=\"13%\">$wageyear</td>\r\n          <td width=\"13%\">$wage</td>\r\n          \r\n    <td width=\"11%\"><a href=\"$webdb[www_url]/do/bencandy_form.php?mid=$mid&id=$id\" target=\"_blank\"></a></td>\r\n        </tr> \r\n      </table>\";s:13:\"tplpart_1code\";s:521:\"<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"3\" style=\"border-bottom:1px dotted #eee;\">\r\n        <tr align=\"center\"> \r\n          \r\n    <td width=\"36%\" align=\"left\">&nbsp;$workplace</td>\r\n          <td width=\"13%\">$schoo_age</td>\r\n          <td width=\"14%\">$asksex</td>\r\n          <td width=\"13%\">$wageyear</td>\r\n          <td width=\"13%\">$wage</td>\r\n          \r\n    <td width=\"11%\"><a href=\"$webdb[www_url]/do/bencandy_form.php?mid=$mid&id=$id\" target=\"_blank\"></a></td>\r\n        </tr> \r\n      </table>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:4:\"form\";s:11:\"roll_height\";s:2:\"50\";s:3:\"url\";N;s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"200\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"amodule\";s:1:\"2\";s:7:\"tplpath\";s:17:\"/form/givejob.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:3:\"all\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";N;s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";N;s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:195:\" SELECT A.*,R.*,config AS M_config FROM qb_form_content A LEFT JOIN qb_form_content_2 R ON A.id=R.id LEFT JOIN qb_form_module F ON A.mid=F.id  WHERE 1  AND A.mid=\'2\'  ORDER BY A.id DESC  LIMIT 4 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:0:\"\";s:8:\"titlenum\";s:2:\"20\";s:9:\"titlenum2\";s:0:\"\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"485\";s:5:\"div_h\";s:2:\"70\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1240899392','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('322','','0','0','bodyad2','pic','0','a:4:{s:6:\"imgurl\";s:11:\"ad/cnad.jpg\";s:7:\"imglink\";s:22:\"http://www.qibosoft.com/\";s:5:\"width\";s:3:\"742\";s:6:\"height\";s:2:\"90\";}','a:3:{s:5:\"div_w\";s:3:\"742\";s:5:\"div_h\";s:2:\"90\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1239759405','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('323','','0','0','Title4d','code','0','֮PKս','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1237278157','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('324','','0','0','c2d','hack_vote','0','<SCRIPT src=\'http://www_qibosoft_com/do/vote.php?job=js&cid=10\'></SCRIPT>','a:4:{s:6:\"voteid\";s:2:\"10\";s:5:\"div_w\";s:3:\"237\";s:5:\"div_h\";s:3:\"145\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1239011013','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('325','','0','0','Title5d','code','0','2008йվ˴','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1240113989','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('326','','0','0','b2d','hack_vote','0','<SCRIPT src=\'http://www_qibosoft_com/do/vote.php?job=js&cid=11\'></SCRIPT>','a:4:{s:6:\"voteid\";s:2:\"11\";s:5:\"div_w\";s:3:\"480\";s:5:\"div_h\";s:3:\"238\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1239011483','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('906','','0','0','special_sport_18','article','1','a:32:{s:13:\"tplpart_1code\";s:235:\"<div class=\"photo_list\"><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" width=\"160\" height=\"110\" border=\"0\" /></a><br />\r\n  <a href=\"$url\" target=\"_blank\">$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:132:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'0\'  AND A.ispic=1   AND A.ispic=1  ORDER BY A.list DESC LIMIT 5 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"20\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"925\";s:5:\"div_h\";s:3:\"134\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290133716','11','30','19','0','default');
INSERT INTO `qb_label` VALUES ('328','','0','0','Title04d','code','0','Ƽͼ','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:3:\"215\";s:5:\"div_h\";s:2:\"26\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1239345594','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('329','','0','0','c2de','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20090420130440_bWzOZ.jpg\";s:7:\"imglink\";s:19:\"http://www.371.com/\";s:5:\"width\";s:3:\"242\";s:6:\"height\";s:2:\"98\";}','a:3:{s:5:\"div_w\";s:3:\"233\";s:5:\"div_h\";s:2:\"87\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1240205249','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('347','','0','0','show_right_top_picad','code','0','<SCRIPT LANGUAGE=\'JavaScript\' src=\'http://www_qibosoft_com/do/a_d_s.php?job=js&ad_id=show_right_top_picad\'></SCRIPT>','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:3:\"290\";s:5:\"div_h\";s:3:\"110\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1240893892','3','0','0','0','default');
INSERT INTO `qb_label` VALUES ('469','','0','0','index_ad4','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101027171018_bzfar.gif\";s:7:\"imglink\";s:21:\"http://www.eydns.com/\";s:5:\"width\";s:3:\"220\";s:6:\"height\";s:2:\"50\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1292642613','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('348','','0','0','show_topad','code','0','<SCRIPT LANGUAGE=\'JavaScript\' src=\'http://www_qibosoft_com/do/a_d_s.php?job=js&ad_id=show_topad\'></SCRIPT>','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:3:\"990\";s:5:\"div_h\";s:2:\"60\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1240893880','3','0','0','0','default');
INSERT INTO `qb_label` VALUES ('349','','0','0','list_page_topad','code','0','<SCRIPT LANGUAGE=\'JavaScript\' src=\'http://www_qibosoft_com/do/a_d_s.php?job=js&ad_id=list_page_topad\'></SCRIPT>','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:3:\"290\";s:5:\"div_h\";s:3:\"130\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1240893815','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('350','','0','0','article_list','code','0','<SCRIPT LANGUAGE=\'JavaScript\' src=\'http://www_qibosoft_com/do/a_d_s.php?job=js&ad_id=article_list\'> </SCRIPT>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:3:\"273\";s:5:\"div_h\";s:2:\"56\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1292548963','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('351','','0','0','article_list_tag','code','0','λ','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1239279418','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('356','','0','0','bbsifmark_tag','code','0','̳','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('354','','0','0','article_show','code','0','<SCRIPT LANGUAGE=\'JavaScript\' src=\'http://www_qibosoft_com/do/a_d_s.php?job=js&ad_id=article_show\'></SCRIPT>','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1240893904','3','0','0','0','default');
INSERT INTO `qb_label` VALUES ('355','','0','0','article_show_tag','code','0','λ','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1239279430','3','0','0','0','default');
INSERT INTO `qb_label` VALUES ('358','','0','0','view_article_bbs_tag','code','0','̳Ƽͼ','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','3','0','0','0','default');
INSERT INTO `qb_label` VALUES ('360','','0','0','bodyad33','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20090418150428_gPa47.jpg\";s:7:\"imglink\";s:22:\"http://www.yeepay.com/\";s:5:\"width\";s:3:\"243\";s:6:\"height\";s:2:\"90\";}','a:3:{s:5:\"div_w\";s:3:\"243\";s:5:\"div_h\";s:2:\"90\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1240041136','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('468','','0','0','index_ad3','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101027171006_q2b2q.gif\";s:7:\"imglink\";s:18:\"http://www.sudu.cn\";s:5:\"width\";s:3:\"220\";s:6:\"height\";s:2:\"50\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1292642635','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('465','','0','0','index_ad1','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101109141123_k355a.jpg\";s:7:\"imglink\";s:36:\"http://www.chinaccnet.com/hyperv.php\";s:5:\"width\";s:3:\"740\";s:6:\"height\";s:2:\"70\";}','a:3:{s:5:\"div_w\";s:3:\"737\";s:5:\"div_h\";s:2:\"67\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1291714552','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('466','','0','0','index_ad2','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101109141150_bnrt2.jpg\";s:7:\"imglink\";s:22:\"http://www.yeepay.com/\";s:5:\"width\";s:3:\"240\";s:6:\"height\";s:2:\"70\";}','a:3:{s:5:\"div_w\";s:3:\"240\";s:5:\"div_h\";s:2:\"68\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289462758','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('467','','0','0','index_rollpic','rollpic','0','a:6:{s:8:\"rolltype\";s:1:\"0\";s:5:\"width\";s:3:\"266\";s:6:\"height\";s:3:\"236\";s:6:\"picurl\";a:2:{i:1;s:32:\"label/1_20101109141150_sfgyo.jpg\";i:2;s:32:\"label/1_20101109141154_f28xx.jpg\";}s:7:\"piclink\";a:2:{i:1;s:19:\"http://www.sudu.cn/\";i:2;s:26:\"http://www.chinaccnet.com/\";}s:6:\"picalt\";a:2:{i:1;s:0:\"\";i:2;s:0:\"\";}}','a:3:{s:5:\"div_w\";s:3:\"265\";s:5:\"div_h\";s:3:\"232\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1292642100','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('373','','0','99','head_guides','code','0','      <div class=\"ico_guide bbs\"><a href=\"http://www_qibosoft_com/bbs/\" target=\'_blank\'></a></div>\r\n	  <div class=\"ico_guide post\"><a href=\"http://www_qibosoft_com/do/post.php\">Ͷ</a></div>\r\n	  <div class=\"ico_guide sell\"><a href=\"http://www_qibosoft_com/do/buymoneycard.php?paytype=yeepay\">ֵ</a></div>\r\n	  <div class=\"ico_guide jf\"><a href=\"http://www_qibosoft_com/do/jf.php\"></a></div>\r\n	  <div class=\"ico_guide user\"><a href=\"http://www_qibosoft_com/do/list_form.php?mid=2\">Ƹ</a></div>\r\n	  <div class=\"ico_guide search\"><a href=\"http://www_qibosoft_com/do/search.php\"></a></div>\r\n	  <div class=\"ico_guide book\"><a href=\"http://www_qibosoft_com/do/guestbook.php\"></a></div>\r\n	  <div class=\"ico_guide digg\"><a href=\"http://www_qibosoft_com/do/listsp.php?fid=1\">ר</a></div>','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:3:\"700\";s:5:\"div_h\";s:2:\"50\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1240898798','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('905','','0','0','special_sport_17','article','1','a:32:{s:13:\"tplpart_1code\";s:75:\"<div class=\"content_list\"><a href=\"$url\" target=\"_blank\">$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:102:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'0\'   ORDER BY A.list DESC LIMIT 4 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"50\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"375\";s:5:\"div_h\";s:3:\"108\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290133507','11','30','19','0','default');
INSERT INTO `qb_label` VALUES ('375','','0','0','list_top_ad','code','0','<SCRIPT LANGUAGE=\'JavaScript\' src=\'http://www_qibosoft_com/do/a_d_s.php?job=js&ad_id=AD_list_topad\'></SCRIPT>','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:3:\"900\";s:5:\"div_h\";s:2:\"51\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1240893857','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('904','','0','0','special_sport_16','article','1','a:32:{s:13:\"tplpart_1code\";s:75:\"<div class=\"content_list\"><a href=\"$url\" target=\"_blank\">$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:101:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'0\'   ORDER BY A.list ASC LIMIT 6 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"50\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"373\";s:5:\"div_h\";s:3:\"163\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290133420','11','30','19','0','default');
INSERT INTO `qb_label` VALUES ('903','','0','0','special_sport_15','article','1','a:32:{s:13:\"tplpart_1code\";s:75:\"<div class=\"content_list\"><a href=\"$url\" target=\"_blank\">$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:102:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'0\'   ORDER BY A.list DESC LIMIT 6 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"50\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"375\";s:5:\"div_h\";s:3:\"160\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290133428','11','30','19','0','default');
INSERT INTO `qb_label` VALUES ('902','','0','0','down_b4','article','1','a:32:{s:13:\"tplpart_1code\";s:87:\"<div class=\"list\"><a href=\"$url\" target=\"_blank\">$title</a><span>{$hits}</span></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";s:2:\"40\";s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"8\";s:3:\"sql\";s:106:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.fid IN (40)   ORDER BY A.list DESC LIMIT 8 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"44\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('901','','0','0','down_b3','article','1','a:32:{s:13:\"tplpart_1code\";s:87:\"<div class=\"list\"><a href=\"$url\" target=\"_blank\">$title</a><span>{$hits}</span></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";s:2:\"27\";s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"8\";s:3:\"sql\";s:106:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.fid IN (27)   ORDER BY A.list DESC LIMIT 8 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"42\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289481159','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('900','','0','0','down_b2','article','1','a:32:{s:13:\"tplpart_1code\";s:87:\"<div class=\"list\"><a href=\"$url\" target=\"_blank\">$title</a><span>{$hits}</span></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:3:\"101\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";s:2:\"26\";s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"8\";s:3:\"sql\";s:106:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.fid IN (26)   ORDER BY A.list DESC LIMIT 8 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"42\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289481175','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('899','','0','0','down_b1','article','1','a:32:{s:13:\"tplpart_1code\";s:87:\"<div class=\"list\"><a href=\"$url\" target=\"_blank\">$title</a><span>{$hits}</span></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:3:\"101\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";s:2:\"12\";s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"8\";s:3:\"sql\";s:106:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.fid IN (12)   ORDER BY A.list DESC LIMIT 8 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"42\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289481170','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('898','','0','0','down_t5','article','1','a:32:{s:13:\"tplpart_1code\";s:87:\"<div class=\"list\"><a href=\"$url\" target=\"_blank\">$title</a><span>{$hits}</span></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:3:\"101\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:104:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'101\'   ORDER BY A.list DESC LIMIT 6 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"34\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('385','','0','0','showinfo','code','0','<SCRIPT LANGUAGE=\"JavaScript\">\r\n<!--\r\ndocument.write(\'<span id=\"num_info\"><img alt=\"ݼ,Ժ...\" src=\"http://www_qibosoft_com/images/default/ico_loading3.gif\"></span>\');\r\ndocument.write(\'<div style=\"display:none;\"><iframe src=\"http://www_qibosoft_com/do/job.php?job=getinfo&iframeID=num_info\" width=0 height=0></iframe></div>\');\r\n//-->\r\n</SCRIPT>','a:4:{s:9:\"html_edit\";s:0:\"\";s:5:\"div_w\";s:3:\"235\";s:5:\"div_h\";s:2:\"55\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1241074422','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('387','','0','0','blog_rollpic','rollpic','0','a:6:{s:8:\"rolltype\";s:1:\"0\";s:5:\"width\";s:3:\"310\";s:6:\"height\";s:3:\"200\";s:6:\"picurl\";a:2:{i:1;s:32:\"label/1_20101108091153_pfput.jpg\";i:2;s:32:\"label/1_20101108091131_uive7.jpg\";}s:7:\"piclink\";a:2:{i:1;s:1:\"#\";i:2;s:1:\"#\";}s:6:\"picalt\";a:2:{i:1;s:0:\"\";i:2;s:0:\"\";}}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289180839','0','25','0','0','default');
INSERT INTO `qb_label` VALUES ('388','','0','0','blog_hot','blog_log','1','a:24:{s:9:\"tplpart_1\";s:234:\" <div class=\"list\"><a href=\"$webdb[www_url]/blog/index.php?file=viewlog&uid=$uid&id=$id\" class=\"t$i\" target=\"_blank\">$title</a><a href=\"$webdb[www_url]/blog/?uid=$uid\" class=\"user\" target=\"_blank\">$username</a></div>\r\n                \";s:13:\"tplpart_1code\";s:234:\" <div class=\"list\"><a href=\"$webdb[www_url]/blog/index.php?file=viewlog&uid=$uid&id=$id\" class=\"t$i\" target=\"_blank\">$title</a><a href=\"$webdb[www_url]/blog/?uid=$uid\" class=\"user\" target=\"_blank\">$username</a></div>\r\n                \";s:13:\"tplpart_2code\";s:0:\"\";s:13:\"RollStyleType\";s:0:\"\";s:3:\"url\";s:59:\"$webdb[www_url]/blog/index.php?file=viewlog&uid=$uid&id=$id\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:11:\"content_num\";s:2:\"80\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:8:\"posttime\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:76:\" SELECT * FROM qb_blog_log_article  WHERE 1  ORDER BY posttime DESC LIMIT 6 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"30\";s:10:\"titleflood\";s:1:\"0\";s:9:\"titlenum2\";s:0:\"\";s:12:\"content_num2\";s:0:\"\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289182107','0','25','0','0','default');
INSERT INTO `qb_label` VALUES ('389','','0','0','blog_topic','blog_log','1','a:24:{s:9:\"tplpart_1\";s:446:\"<div class=\"list$i\">\r\n            	<div class=\"title\"><a href=\"$webdb[www_url]/blog/index.php?file=viewlog&uid=$uid&id=$id\" target=\'_blank\'>$title</a></div>\r\n                <div class=\"user\"><a href=\"$webdb[www_url]/blog/?uid=$uid\">$username</a></div>\r\n                <div class=\"content\">{$content}...<a href=\"$webdb[www_url]/blog/index.php?file=viewlog&uid=$uid&id=$id\" target=\'_blank\'>[ϸ]</a>\r\n                </div>\r\n            </div>\";s:13:\"tplpart_1code\";s:446:\"<div class=\"list$i\">\r\n            	<div class=\"title\"><a href=\"$webdb[www_url]/blog/index.php?file=viewlog&uid=$uid&id=$id\" target=\'_blank\'>$title</a></div>\r\n                <div class=\"user\"><a href=\"$webdb[www_url]/blog/?uid=$uid\">$username</a></div>\r\n                <div class=\"content\">{$content}...<a href=\"$webdb[www_url]/blog/index.php?file=viewlog&uid=$uid&id=$id\" target=\'_blank\'>[ϸ]</a>\r\n                </div>\r\n            </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:13:\"RollStyleType\";s:0:\"\";s:3:\"url\";s:59:\"$webdb[www_url]/blog/index.php?file=viewlog&uid=$uid&id=$id\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:11:\"content_num\";s:3:\"110\";s:7:\"tplpath\";s:29:\"/common_content/content_1.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"c\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:8:\"posttime\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:76:\" SELECT * FROM qb_blog_log_article  WHERE 1  ORDER BY posttime DESC LIMIT 5 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"30\";s:10:\"titleflood\";s:1:\"0\";s:9:\"titlenum2\";s:0:\"\";s:12:\"content_num2\";s:0:\"\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289186800','0','25','0','0','default');
INSERT INTO `qb_label` VALUES ('390','','0','0','blog_member1','Info_blog_','1','a:28:{s:13:\"tplpart_1code\";s:406:\"<div class=\"listblog\">\r\n                	<a href=\"$webdb[www_url]/blog/?uid=$uid\" target=\"_blank\" class=\"pic\"><img src=\"$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/noface.gif\'\" width=\"45\" height=\"45\" /></a>\r\n                    <a href=\"$webdb[www_url]/blog/?uid=$uid\" target=\"_blank\" class=\"name\">$title</a>\r\n                    <span>:<em>$hits</em></span>\r\n                </div> \";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:4:\"blog\";s:6:\"wninfo\";s:5:\"blog_\";s:6:\"cityId\";N;s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:11:\"content_num\";s:2:\"80\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:8:\"moduleid\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:1:\"1\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"8\";s:3:\"sql\";s:158:\"SELECT M.*,B.*,B.webname AS title,M.uid AS id,M.icon AS picurl FROM qb_blog_home B LEFT JOIN qb_memberdata M ON B.uid=M.uid  WHERE 1  ORDER BY 1 DESC LIMIT 8 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"20\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289186011','0','25','0','0','default');
INSERT INTO `qb_label` VALUES ('392','','0','0','blog_member2','Info_blog_','1','a:28:{s:13:\"tplpart_1code\";s:554:\"<div class=\"listReporter\">\r\n                	<a href=\"$webdb[www_url]/blog/?uid=$uid\" target=\"_blank\" class=\"pic\"><img src=\"$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/noface.gif\'\" width=\"70\" height=\"70\" /></a>\r\n                	<a href=\"$webdb[www_url]/blog/?uid=$uid\" target=\"_blank\" class=\"name\">$title</a>\r\n                    <span>:<em>$hits</em></span>\r\n                    <span><a href=\"$webdb[www_url]/blog/?uid=$uid\" target=\"_blank\"><img src=\"$webdb[www_url]/images/v7/blog/view.gif\"/></a></span>\r\n                </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:4:\"blog\";s:6:\"wninfo\";s:5:\"blog_\";s:6:\"cityId\";N;s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:11:\"content_num\";s:2:\"80\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:8:\"moduleid\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:5:\"B.uid\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"3\";s:3:\"sql\";s:161:\"SELECT M.*,B.*,B.webname AS title,M.uid AS id,M.icon AS picurl FROM qb_blog_home B LEFT JOIN qb_memberdata M ON B.uid=M.uid  WHERE 1  ORDER BY B.uid ASC LIMIT 3 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"20\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289186087','0','25','0','0','default');
INSERT INTO `qb_label` VALUES ('393','','0','0','blog_title1','blog_log','1','a:24:{s:9:\"tplpart_1\";s:152:\"<div class=\"list l$i\"><a href=\"$url\" target=\"_blank\">$title</a><span><a href=\"$webdb[www_url]/blog/?uid=$uid\" target=\"_blank\">$username</a></span></div>\";s:13:\"tplpart_1code\";s:207:\"<div class=\"list l$i\"><a href=\"$webdb[www_url]/blog/index.php?file=viewlog&uid=$uid&id=$id\" target=\"_blank\">$title</a><span><a href=\"$webdb[www_url]/blog/?uid=$uid\" target=\"_blank\">$username</a></span></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:13:\"RollStyleType\";s:0:\"\";s:3:\"url\";s:59:\"$webdb[www_url]/blog/index.php?file=viewlog&uid=$uid&id=$id\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:11:\"content_num\";s:2:\"80\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:8:\"posttime\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"8\";s:3:\"sql\";s:76:\" SELECT * FROM qb_blog_log_article  WHERE 1  ORDER BY posttime DESC LIMIT 8 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"30\";s:10:\"titleflood\";s:1:\"0\";s:9:\"titlenum2\";s:0:\"\";s:12:\"content_num2\";s:0:\"\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','25','0','0','default');
INSERT INTO `qb_label` VALUES ('394','','0','0','blog_title2','blog_log','1','a:24:{s:9:\"tplpart_1\";s:146:\" <div class=\"list\"><a href=\"$url\" target=\"_blank\">$title</a><a href=\"$webdb[www_url]/blog/?uid=$uid\" class=\"u\" target=\"_blank\">$username</a></div>\";s:13:\"tplpart_1code\";s:201:\" <div class=\"list\"><a href=\"$webdb[www_url]/blog/index.php?file=viewlog&uid=$uid&id=$id\" target=\"_blank\">$title</a><a href=\"$webdb[www_url]/blog/?uid=$uid\" class=\"u\" target=\"_blank\">$username</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:13:\"RollStyleType\";s:0:\"\";s:3:\"url\";s:59:\"$webdb[www_url]/blog/index.php?file=viewlog&uid=$uid&id=$id\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:11:\"content_num\";s:2:\"80\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:8:\"posttime\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"7\";s:3:\"sql\";s:75:\" SELECT * FROM qb_blog_log_article  WHERE 1  ORDER BY posttime ASC LIMIT 7 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"30\";s:10:\"titleflood\";s:1:\"0\";s:9:\"titlenum2\";s:0:\"\";s:12:\"content_num2\";s:0:\"\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','25','0','0','default');
INSERT INTO `qb_label` VALUES ('395','','0','0','blog_title3','blog_log','1','a:24:{s:9:\"tplpart_1\";s:146:\" <div class=\"list\"><a href=\"$url\" target=\"_blank\">$title</a><a href=\"$webdb[www_url]/blog/?uid=$uid\" class=\"u\" target=\"_blank\">$username</a></div>\";s:13:\"tplpart_1code\";s:201:\" <div class=\"list\"><a href=\"$webdb[www_url]/blog/index.php?file=viewlog&uid=$uid&id=$id\" target=\"_blank\">$title</a><a href=\"$webdb[www_url]/blog/?uid=$uid\" class=\"u\" target=\"_blank\">$username</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:13:\"RollStyleType\";s:0:\"\";s:3:\"url\";s:59:\"$webdb[www_url]/blog/index.php?file=viewlog&uid=$uid&id=$id\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:11:\"content_num\";s:2:\"80\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:8:\"posttime\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"7\";s:3:\"sql\";s:76:\" SELECT * FROM qb_blog_log_article  WHERE 1  ORDER BY posttime DESC LIMIT 7 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"30\";s:10:\"titleflood\";s:1:\"0\";s:9:\"titlenum2\";s:0:\"\";s:12:\"content_num2\";s:0:\"\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','25','0','0','default');
INSERT INTO `qb_label` VALUES ('396','','0','0','blog_photo1','blog_photo','1','a:24:{s:9:\"tplpart_1\";s:255:\"<div class=\"listpic\"> <a href=\"$url\" class=\"pic\" target=\"_blank\"><img src=\"$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" width=\"120\" height=\"90\" /></a> \r\n              <a href=\"$url\" class=\"title\" target=\"_blank\">$title</a> </div>\";s:13:\"tplpart_1code\";s:369:\"<div class=\"listpic\"> <a href=\"$webdb[www_url]/blog/index.php?file=viewphoto&uid=$uid&id=$id\" class=\"pic\" target=\"_blank\"><img src=\"$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" width=\"120\" height=\"90\" /></a> \r\n              <a href=\"$webdb[www_url]/blog/index.php?file=viewphoto&uid=$uid&id=$id\" class=\"title\" target=\"_blank\">$title</a> </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:13:\"RollStyleType\";s:0:\"\";s:3:\"url\";s:61:\"$webdb[www_url]/blog/index.php?file=viewphoto&uid=$uid&id=$id\";s:5:\"width\";s:0:\"\";s:6:\"height\";s:0:\"\";s:11:\"content_num\";s:2:\"80\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:8:\"posttime\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:74:\" SELECT * FROM qb_blog_photo_pic  WHERE 1  ORDER BY posttime DESC LIMIT 4 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"20\";s:10:\"titleflood\";s:1:\"0\";s:9:\"titlenum2\";s:0:\"\";s:12:\"content_num2\";s:0:\"\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','25','0','0','default');
INSERT INTO `qb_label` VALUES ('397','','0','0','blog_t1','code','0','־','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','25','0','0','default');
INSERT INTO `qb_label` VALUES ('398','','0','0','blog_t2','code','0','ƼͼƬ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','25','0','0','default');
INSERT INTO `qb_label` VALUES ('399','','0','0','blog_t3','code','0','Ƽ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','25','0','0','default');
INSERT INTO `qb_label` VALUES ('400','','0','0','blog_t4','code','0','Ĺ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','25','0','0','default');
INSERT INTO `qb_label` VALUES ('401','','0','0','blog_t5','code','0','<a href=\"log.php?fid=1\" class=\"F14\"></a> | <a href=\"log.php?fid=2\" class=\"F14\">ʳ</a> | <a href=\"log.php?fid=3\" class=\"F14\"></a> <a href=\"log.php\" class=\"more\">..</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:3:\"200\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289190367','0','25','0','0','default');
INSERT INTO `qb_label` VALUES ('402','','0','0','blog_t6','code','0','־','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','25','0','0','default');
INSERT INTO `qb_label` VALUES ('403','','0','0','blog_t7','code','0','<a  href=\"log.php?fid=1\"></a> | <a href=\"log.php?fid=2\"></a> <a href=\"log.php\" class=\"more\" target=\"_blank\">...</a>\r\n\r\n','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:3:\"150\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289190226','0','25','0','0','default');
INSERT INTO `qb_label` VALUES ('404','','0','0','blog_t8','code','0','²','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','25','0','0','default');
INSERT INTO `qb_label` VALUES ('405','','0','0','blog_t9','code','0','<a href=\"photo.php\" target=\"_blank\">...</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289190131','0','25','0','0','default');
INSERT INTO `qb_label` VALUES ('406','','0','0','blog_t10','code','0','<a href=\"member.php\" target=\"_blank\">...</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289190119','0','25','0','0','default');
INSERT INTO `qb_label` VALUES ('407','','0','0','blog_t11','code','0','<a href=\"member.php\" target=\"_blank\">...</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289190100','0','25','0','0','default');
INSERT INTO `qb_label` VALUES ('408','','0','0','blog_b1','code','0','<span class=\"l FB\"></span><span class=\"r\"><a href=\"log.php?fid=1\">...</a></span>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289190307','0','25','0','0','default');
INSERT INTO `qb_label` VALUES ('409','','0','0','blog_b2','code','0','<span class=\"l FB\">ʳ</span><span class=\"r\"><a href=\"log.php?fid=2\">...</a></span>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289190336','0','25','0','0','default');
INSERT INTO `qb_label` VALUES ('410','','0','0','exam_rollpic','rollpic','0','a:6:{s:8:\"rolltype\";s:1:\"0\";s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"160\";s:6:\"picurl\";a:2:{i:1;s:32:\"label/1_20101108131113_7mfrt.jpg\";i:2;s:32:\"label/1_20101108131123_dyfe2.jpg\";}s:7:\"piclink\";a:2:{i:1;s:1:\"#\";i:2;s:1:\"#\";}s:6:\"picalt\";a:2:{i:1;s:0:\"\";i:2;s:0:\"\";}}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','17','0','0','default');
INSERT INTO `qb_label` VALUES ('411','','0','0','exam_top1','Info_exam_','1','a:27:{s:13:\"tplpart_1code\";s:185:\"<div class=\"uu$i\"><span class=\"L\"><a href=\"$webdb[www_url]/exam/bencandy.php?fid=$fid&id=$id\" target=\"_blank\">$title</a></span><span class=\"R\">{$time_Y}-{$time_m}-{$time_d}</span></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:4:\"exam\";s:6:\"wninfo\";s:5:\"exam_\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:11:\"content_num\";s:2:\"80\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:8:\"moduleid\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:1:\"1\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:162:\"SELECT A.*,A.name AS title,A.creattime AS posttime,B.name AS fname FROM qb_exam_form A LEFT JOIN qb_exam_sort B ON A.fid=B.fid  WHERE 1  ORDER BY 1 DESC LIMIT 10 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"50\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"400\";s:5:\"div_h\";s:3:\"250\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289366253','0','17','0','0','default');
INSERT INTO `qb_label` VALUES ('412','','0','0','exam_top2','Info_exam_','1','a:27:{s:13:\"tplpart_1code\";s:113:\"<div class=\"lista$i\"><a href=\"$webdb[www_url]/exam/bencandy.php?fid=$fid&id=$id\" target=\"_blank\">$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:4:\"exam\";s:6:\"wninfo\";s:5:\"exam_\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:11:\"content_num\";s:2:\"80\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:8:\"moduleid\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:1:\"1\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"11\";s:3:\"sql\";s:162:\"SELECT A.*,A.name AS title,A.creattime AS posttime,B.name AS fname FROM qb_exam_form A LEFT JOIN qb_exam_sort B ON A.fid=B.fid  WHERE 1  ORDER BY 1 DESC LIMIT 11 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"400\";s:5:\"div_h\";s:3:\"150\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289366296','0','17','0','0','default');
INSERT INTO `qb_label` VALUES ('413','','0','0','exam_top3','Info_exam_','1','a:27:{s:13:\"tplpart_1code\";s:134:\"<div class=\"list$i\"><a href=\"$webdb[www_url]/exam/bencandy.php?fid=$fid&id=$id\" target=\"_blank\">$title</a><span>{$hits}</span></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:4:\"exam\";s:6:\"wninfo\";s:5:\"exam_\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:11:\"content_num\";s:2:\"80\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:8:\"moduleid\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:1:\"1\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:162:\"SELECT A.*,A.name AS title,A.creattime AS posttime,B.name AS fname FROM qb_exam_form A LEFT JOIN qb_exam_sort B ON A.fid=B.fid  WHERE 1  ORDER BY 1 DESC LIMIT 10 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"28\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289366305','0','17','0','0','default');
INSERT INTO `qb_label` VALUES ('414','','0','0','exam_a1','Info_exam_','1','a:27:{s:13:\"tplpart_1code\";s:112:\"<div class=\"list$i\"><a href=\"$webdb[www_url]/exam/bencandy.php?fid=$fid&id=$id\" target=\"_blank\">$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:4:\"exam\";s:6:\"wninfo\";s:5:\"exam_\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:11:\"content_num\";s:2:\"80\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:8:\"moduleid\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:1:\"1\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:161:\"SELECT A.*,A.name AS title,A.creattime AS posttime,B.name AS fname FROM qb_exam_form A LEFT JOIN qb_exam_sort B ON A.fid=B.fid  WHERE 1  ORDER BY 1 DESC LIMIT 6 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"30\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289366363','0','17','0','0','default');
INSERT INTO `qb_label` VALUES ('415','','0','0','exam_a2','Info_exam_','1','a:27:{s:13:\"tplpart_1code\";s:112:\"<div class=\"list$i\"><a href=\"$webdb[www_url]/exam/bencandy.php?fid=$fid&id=$id\" target=\"_blank\">$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:4:\"exam\";s:6:\"wninfo\";s:5:\"exam_\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:11:\"content_num\";s:2:\"80\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:8:\"moduleid\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:1:\"1\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:161:\"SELECT A.*,A.name AS title,A.creattime AS posttime,B.name AS fname FROM qb_exam_form A LEFT JOIN qb_exam_sort B ON A.fid=B.fid  WHERE 1  ORDER BY 1 DESC LIMIT 6 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"30\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"230\";s:5:\"div_h\";s:3:\"112\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289366375','0','17','0','0','default');
INSERT INTO `qb_label` VALUES ('416','','0','0','exam_a3','Info_exam_','1','a:27:{s:13:\"tplpart_1code\";s:231:\"<div class=\"list\"><a href=\"$webdb[www_url]/exam/list.php?fid=$fid\" class=\"s\" target=\"_blank\">[{$fname}]</a><a href=\"$webdb[www_url]/exam/bencandy.php?fid=$fid&id=$id\" target=\"_blank\">$title</a><span>{$time_m}-{$time_d}</span></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:4:\"exam\";s:6:\"wninfo\";s:5:\"exam_\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:11:\"content_num\";s:2:\"80\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:8:\"moduleid\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:1:\"1\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:161:\"SELECT A.*,A.name AS title,A.creattime AS posttime,B.name AS fname FROM qb_exam_form A LEFT JOIN qb_exam_sort B ON A.fid=B.fid  WHERE 1  ORDER BY 1 DESC LIMIT 6 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"30\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289366339','0','17','0','0','default');
INSERT INTO `qb_label` VALUES ('417','','0','0','exam_a4','Info_exam_','1','a:27:{s:13:\"tplpart_1code\";s:231:\"<div class=\"list\"><a href=\"$webdb[www_url]/exam/list.php?fid=$fid\" class=\"s\" target=\"_blank\">[{$fname}]</a><a href=\"$webdb[www_url]/exam/bencandy.php?fid=$fid&id=$id\" target=\"_blank\">$title</a><span>{$time_m}-{$time_d}</span></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:4:\"exam\";s:6:\"wninfo\";s:5:\"exam_\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:11:\"content_num\";s:2:\"80\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:8:\"moduleid\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:1:\"1\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:161:\"SELECT A.*,A.name AS title,A.creattime AS posttime,B.name AS fname FROM qb_exam_form A LEFT JOIN qb_exam_sort B ON A.fid=B.fid  WHERE 1  ORDER BY 1 DESC LIMIT 6 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"30\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289366351','0','17','0','0','default');
INSERT INTO `qb_label` VALUES ('418','','0','0','exam_a5','Info_exam_','1','a:27:{s:13:\"tplpart_1code\";s:231:\"<div class=\"list\"><a href=\"$webdb[www_url]/exam/list.php?fid=$fid\" class=\"s\" target=\"_blank\">[{$fname}]</a><a href=\"$webdb[www_url]/exam/bencandy.php?fid=$fid&id=$id\" target=\"_blank\">$title</a><span>{$time_m}-{$time_d}</span></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:4:\"exam\";s:6:\"wninfo\";s:5:\"exam_\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:11:\"content_num\";s:2:\"80\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:8:\"moduleid\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:1:\"1\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:161:\"SELECT A.*,A.name AS title,A.creattime AS posttime,B.name AS fname FROM qb_exam_form A LEFT JOIN qb_exam_sort B ON A.fid=B.fid  WHERE 1  ORDER BY 1 DESC LIMIT 6 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"30\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289366399','0','17','0','0','default');
INSERT INTO `qb_label` VALUES ('419','','0','0','exam_a6','Info_exam_','1','a:27:{s:13:\"tplpart_1code\";s:231:\"<div class=\"list\"><a href=\"$webdb[www_url]/exam/list.php?fid=$fid\" class=\"s\" target=\"_blank\">[{$fname}]</a><a href=\"$webdb[www_url]/exam/bencandy.php?fid=$fid&id=$id\" target=\"_blank\">$title</a><span>{$time_m}-{$time_d}</span></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:4:\"exam\";s:6:\"wninfo\";s:5:\"exam_\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:11:\"content_num\";s:2:\"80\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:8:\"moduleid\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:1:\"1\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:161:\"SELECT A.*,A.name AS title,A.creattime AS posttime,B.name AS fname FROM qb_exam_form A LEFT JOIN qb_exam_sort B ON A.fid=B.fid  WHERE 1  ORDER BY 1 DESC LIMIT 6 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"30\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289366390','0','17','0','0','default');
INSERT INTO `qb_label` VALUES ('420','','0','0','exam_q1','code','0','	<a href=\"#\"></a> | <a href=\"#\">ģ⿼</a> | <a href=\"#\">У</a> | <a href=\"#\"></a> | <a href=\"#\">ٿ</a> | <a href=\"#\">Ƹ</a> | <a href=\"#\">&gt;&gt;</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','17','0','0','default');
INSERT INTO `qb_label` VALUES ('421','','0','0','exam_q2','code','0','	<a href=\"#\"></a> | <a href=\"#\">ģ⿼</a> | <a href=\"#\">У</a> | <a href=\"#\"></a> | <a href=\"#\">ٿ</a> | <a href=\"#\">Ƹ</a> | <a href=\"#\">&gt;&gt;</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','17','0','0','default');
INSERT INTO `qb_label` VALUES ('422','','0','0','exam_q3','code','0','	<a href=\"#\"></a> | <a href=\"#\">ģ⿼</a> | <a href=\"#\">У</a> | <a href=\"#\"></a> | <a href=\"#\">ٿ</a> | <a href=\"#\">Ƹ</a> | <a href=\"#\">&gt;&gt;</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','17','0','0','default');
INSERT INTO `qb_label` VALUES ('423','','0','0','exam_q4','code','0','<a href=\"#\"></a> | <a href=\"#\">ģ⿼</a> | <a href=\"#\">У</a> | <a href=\"#\"></a> | <a href=\"#\">ٿ</a> | <a href=\"#\">Ƹ</a> | <a href=\"#\">&gt;&gt;</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','17','0','0','default');
INSERT INTO `qb_label` VALUES ('424','','0','0','exam_tt1','code','0','1','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','17','0','0','default');
INSERT INTO `qb_label` VALUES ('425','','0','0','exam_tt2','code','0','2','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','17','0','0','default');
INSERT INTO `qb_label` VALUES ('426','','0','0','exam_tt3','code','0','3','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','17','0','0','default');
INSERT INTO `qb_label` VALUES ('427','','0','0','exam_tt4','code','0','4','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','17','0','0','default');
INSERT INTO `qb_label` VALUES ('428','','0','0','exam_tt5','code','0','ȼ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','17','0','0','default');
INSERT INTO `qb_label` VALUES ('429','','0','0','exam_tt6','code','0','	<a href=\"#\">һ</a> | <a href=\"#\"></a> | <a href=\"#\"></a> | <a href=\"#\">ļ</a> | <a href=\"#\">Ƶ̳</a> | <a href=\"#\">⸨</a> | <a href=\"#\">ϰ</a> | <a href=\"#\"></a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','17','0','0','default');
INSERT INTO `qb_label` VALUES ('430','','0','0','exam_tt7','code','0','Ƽ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','17','0','0','default');
INSERT INTO `qb_label` VALUES ('431','','0','0','exam_tt8','code','0','','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','17','0','0','default');
INSERT INTO `qb_label` VALUES ('432','','0','0','exam_tt9','code','0','<a href=\"#\"></a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','17','0','0','default');
INSERT INTO `qb_label` VALUES ('433','','0','0','exam_tt10','code','0','Ծע','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289280336','0','17','0','0','default');
INSERT INTO `qb_label` VALUES ('434','','0','0','exam_tt11','code','0','<a href=\"#\"></a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','17','0','0','default');
INSERT INTO `qb_label` VALUES ('435','','0','0','exam_tt12','code','0','ģһ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','17','0','0','default');
INSERT INTO `qb_label` VALUES ('436','','0','0','exam_tt13','code','0','<a href=\"#\"></a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','17','0','0','default');
INSERT INTO `qb_label` VALUES ('437','','0','0','exam_tt14','code','0','ģ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','17','0','0','default');
INSERT INTO `qb_label` VALUES ('438','','0','0','exam_tt15','code','0','<a href=\"#\"></a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','17','0','0','default');
INSERT INTO `qb_label` VALUES ('439','','0','0','exam_ad1','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101108161146_axggb.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"990\";s:6:\"height\";s:2:\"60\";}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','17','0','0','default');
INSERT INTO `qb_label` VALUES ('440','','0','0','exam_ad2','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101108161103_n32j4.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"490\";s:6:\"height\";s:2:\"80\";}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','17','0','0','default');
INSERT INTO `qb_label` VALUES ('441','','0','0','exam_ad3','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101108161125_s7nrb.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"490\";s:6:\"height\";s:2:\"80\";}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','17','0','0','default');
INSERT INTO `qb_label` VALUES ('442','','0','0','exam_top03','code','0','	<div class=\"list\"><a href=\"#\">2010֤ǩԼ</a></div>\r\n                        <div class=\"list\"><a href=\"#\">2010֤ǩԼ</a></div>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','17','0','0','default');
INSERT INTO `qb_label` VALUES ('897','','0','0','down_t4','article','1','a:32:{s:13:\"tplpart_1code\";s:87:\"<div class=\"list\"><a href=\"$url\" target=\"_blank\">$title</a><span>{$hits}</span></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:3:\"101\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:104:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'101\'   ORDER BY A.list DESC LIMIT 6 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"34\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289480863','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('444','','0','0','new_rollpic','rollpic','0','a:6:{s:8:\"rolltype\";s:1:\"0\";s:5:\"width\";s:3:\"310\";s:6:\"height\";s:3:\"260\";s:6:\"picurl\";a:2:{i:1;s:32:\"label/1_20101108161159_zs6we.jpg\";i:2;s:32:\"label/1_20101108171103_f9fvv.jpg\";}s:7:\"piclink\";a:2:{i:1;s:1:\"#\";i:2;s:1:\"#\";}s:6:\"picalt\";a:2:{i:1;s:0:\"\";i:2;s:0:\"\";}}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('896','','0','0','down_t3','article','1','a:32:{s:13:\"tplpart_1code\";s:91:\"<div class=\"list l$i\"><a href=\"$url\" target=\"_blank\">$title</a><span>{$hits}</span></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:3:\"101\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:104:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'101\'   ORDER BY A.list DESC LIMIT 6 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"26\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289480275','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('894','','0','0','down_t1','article','1','a:32:{s:13:\"tplpart_1code\";s:91:\"<div class=\"list l$i\"><a href=\"$url\" target=\"_blank\">$title</a><span>{$hits}</span></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:3:\"101\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:105:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'101\'   ORDER BY A.list DESC LIMIT 10 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"28\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289479954','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('895','','0','0','down_t2','article','1','a:32:{s:13:\"tplpart_1code\";s:181:\"<div class=\"list l$i\"><a href=\"$list_url\" class=\"sort\" target=\"_blank\" >[{$fname}]</a><a href=\"$url\" class=\"title\" target=\"_blank\" >$title</a><span>{$time_m}-{$time_d} </span></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:3:\"101\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"11\";s:3:\"sql\";s:105:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'101\'   ORDER BY A.list DESC LIMIT 11 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"36\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289480150','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('893','','0','0','shops_v1','article','1','a:32:{s:13:\"tplpart_1code\";s:65:\"<div class=\"list\"><a href=\"$url\" target=\"_blank\">$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"7\";s:3:\"sql\";s:102:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'0\'   ORDER BY A.list DESC LIMIT 7 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"36\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289457356','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('892','','0','0','shops_p4','article','1','a:32:{s:13:\"tplpart_1code\";s:94:\"<div class=\"list l1\"><a href=\"$url\" target=\"_blank\">$title</a><span>{$hits}˹ע</span></div>\";s:13:\"tplpart_2code\";s:688:\"<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"listt\">\r\n                  <tr>\r\n                    \r\n                <td class=\"img\"><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" width=\"80\" height=\"60\"/></a></td>\r\n                    <td class=\"word\">\r\n                    	\r\n                  <div class=\"t\"><a href=\"$url\" target=\"_blank\">$title</a></div>\r\n                        <div class=\"p\">г<strike>{$martprice}</strike></div>\r\n                        <div class=\"p\">ۼ<span> {$nowprice}</span></div>\r\n                    </td>\r\n                  </tr>\r\n                </table>\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:3:\"103\";s:7:\"tplpath\";s:25:\"/common_zh_pic/zh_pic.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"9\";s:3:\"sql\";s:105:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'103\'   ORDER BY A.list DESC LIMIT 10 \";s:4:\"sql2\";s:117:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'103\'  AND A.ispic=1 ORDER BY A.list DESC LIMIT 1 \";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"20\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289457230','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('891','','0','0','shops_p3','article','1','a:32:{s:13:\"tplpart_1code\";s:70:\"<div class=\"list l$i\"><a href=\"$url\" target=\"_blank\">$title</a></div> \";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:102:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'0\'   ORDER BY A.list DESC LIMIT 6 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"36\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('890','','0','0','shops_p2','article','1','a:32:{s:13:\"tplpart_1code\";s:386:\"<div class=\"listshop\">\r\n                	<div class=\"img\"><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" width=\"120\" height=\"90\"/></a></div>\r\n                    <div class=\"t\"><a href=\"$url\" target=\"_blank\">$title</a></div>\r\n                    <div class=\"p\">ۼ<span>{$nowprice}</span></div>\r\n                </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:3:\"103\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:134:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'103\'  AND A.ispic=1   AND A.ispic=1  ORDER BY A.list ASC LIMIT 10 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('452','','0','0','new_tt2','code','0','<a href=\"#\">...</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('453','','0','0','new_tt1','code','0','ƼĶ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('454','','0','0','new_tt3','code','0','<a href=\"#\">...</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('455','','0','0','new_tt4','code','0','Ƽ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('456','','0','0','new_tt6','code','0','<a href=\"#\">...</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('457','','0','0','new_tt5','code','0','Ƽ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('458','','0','0','new_tt8','code','0','<a href=\"#\">...</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('459','','0','0','new_tt7','code','0','','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('460','','0','0','new_tt9','code','0','<a href=\"#\">...</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('461','','0','0','new_tt10','code','0','ͼƬ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('462','','0','0','new_tt11','code','0','<a href=\"#\">...</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('463','','0','0','new_tt12','code','0','۽','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('464','','0','0','new_tt13','code','0','','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('473','','0','0','index_hot1','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:68:\"<div class=\"listb$i\"><a href=\"$url\" target=\"_blank\">$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"8\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 8 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"34\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"206\";s:5:\"div_h\";s:3:\"204\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300416138','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('474','','0','0','index_t1','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:249:\"<div class=\"lista$i\"> <span class=\"t\"><a href=\"$url\" target=\"_blank\">$title</a></span> \r\n                <span class=\"d\">[{$time_m}-{$time_d}]</span> <span class=\"c\">{$content}<a href=\"$url\" target=\"_blank\">[]</a></span> \r\n              </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"c\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:158:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid   WHERE A.yz=1   AND R.topic=1 ORDER BY A.list DESC LIMIT 6 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:3:\"130\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"54\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"446\";s:5:\"div_h\";s:3:\"209\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300416125','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('475','','0','0','index_t2','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:308:\"<div class=\"listpic\">\r\n        	\r\n        <div class=\"img\"><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" width=\"120\" height=\"90\"/></a></div>\r\n            \r\n        <div class=\"t\"><a href=\"$url\" target=\"_blank\">$title</a></div>\r\n        </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:122:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1  AND A.ispic=1   AND A.ispic=1  ORDER BY A.list DESC LIMIT 6 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"991\";s:5:\"div_h\";s:3:\"142\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300416150','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('476','','0','0','index_down','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:90:\"<div class=\"listc$i\"><a href=\"$url\" target=\"_blank\">$title</a><span>{$hits}</span></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:93:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 10 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"26\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"206\";s:5:\"div_h\";s:3:\"254\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300416169','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('477','','0','0','index_j1','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:219:\"<div class=\"list$i\">\r\n                    	<span class=\"t\"><a href=\"$url\" target=\"_blank\">$title</a></span>\r\n                        <span class=\"c\">&nbsp;&nbsp;&nbsp;&nbsp;{$content}.</span>\r\n                    </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"c\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"7\";s:3:\"sql\";s:158:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid   WHERE A.yz=1   AND R.topic=1 ORDER BY A.list DESC LIMIT 7 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"94\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"271\";s:5:\"div_h\";s:3:\"237\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300416160','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('478','','0','0','index_j2','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:283:\"<div class=\"list\"> <span class=\"t\"><em>{$username}</em>  {$time_m}-{$time_d} \r\n                      00:54  <a href=\"#\" target=\"_blank\">$article</a></span> \r\n                      <span class=\"a\"></span> <span class=\"c\">{$title}...</span> \r\n                    </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"200\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"3\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 3 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"50\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"407\";s:5:\"div_h\";s:3:\"194\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300416203','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('479','','0','0','index_j3','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:501:\"	<div class=\"listpic\">\r\n                    \r\n              <div class=\"img\"><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" width=\"120\" height=\"90\"/></a></div>\r\n                    \r\n              <div class=\"t\"><a href=\"$url\" target=\"_blank\">$title</a></div>\r\n                    <div class=\"p\"><strike>г:{$martprice}</strike></div>\r\n                    <div class=\"p\"><em>ۼ:{$nowprice}</em></div>\r\n                </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:122:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1  AND A.ispic=1   AND A.ispic=1  ORDER BY A.list DESC LIMIT 5 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"26\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"739\";s:5:\"div_h\";s:3:\"180\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300416217','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('480','','0','0','index_member','member','1','a:20:{s:9:\"tplpart_1\";s:429:\"<div class=\"listuser\">\r\n                	\r\n                <div class=\"img\"><a href=\"$webdb[www_url]/member/homepage.php?uid=$uid\" target=\"_blank\"><img src=\"$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/nobody.gif\'\" width=\"50\" height=\"50\"/></a></div>\r\n                	\r\n                <div class=\"name\"><a href=\"$webdb[www_url]/member/homepage.php?uid=$uid\" target=\"_blank\">$title</a></div>\r\n                </div>\";s:13:\"tplpart_1code\";s:429:\"<div class=\"listuser\">\r\n                	\r\n                <div class=\"img\"><a href=\"$webdb[www_url]/member/homepage.php?uid=$uid\" target=\"_blank\"><img src=\"$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/nobody.gif\'\" width=\"50\" height=\"50\"/></a></div>\r\n                	\r\n                <div class=\"name\"><a href=\"$webdb[www_url]/member/homepage.php?uid=$uid\" target=\"_blank\">$title</a></div>\r\n                </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:7:\"group_1\";s:0:\"\";s:7:\"group_2\";s:0:\"\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:7:\"regdate\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";N;s:7:\"rowspan\";s:1:\"9\";s:3:\"sql\";s:134:\" SELECT D.*,D.username AS title,D.icon AS picurl,D.introduce AS content FROM qb_memberdata D  WHERE 1  ORDER BY D.regdate ASC LIMIT 9 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"20\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"223\";s:5:\"div_h\";s:3:\"252\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289463337','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('481','','0','0','index_c1','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:101:\"  <div class=\"list\"><a href=\"$url\" target=\"_blank\">$title</a><span>[{$time_m}/{$time_d}]</span></div>\";s:13:\"tplpart_2code\";s:741:\"<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n                          <tr>\r\n                            \r\n                    <td class=\"img\"><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" width=\"80\" height=\"60\"/></a></td>\r\n                            <td>\r\n                                \r\n                      <div class=\"t\"><a href=\"$url\" target=\"_blank\">$title</a></div>\r\n                                \r\n                      <div class=\"m\">{$content}<a href=\"$url\" target=\"_blank\">[ϸ]</a></div>\r\n                            </td>\r\n                          </tr>\r\n                        </table>\r\n                        \r\n               \";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:33:\"/common_zh_content/zh_content.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:158:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid   WHERE A.yz=1   AND R.topic=1 ORDER BY A.list DESC LIMIT 6 \";s:4:\"sql2\";s:170:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid  WHERE A.yz=1  AND A.ispic=1 AND R.topic=1 ORDER BY A.list DESC LIMIT 1 \";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:2:\"70\";s:8:\"titlenum\";s:2:\"36\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"341\";s:5:\"div_h\";s:3:\"220\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300416231','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('482','','0','0','index_c2','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:101:\"  <div class=\"list\"><a href=\"$url\" target=\"_blank\">$title</a><span>[{$time_m}/{$time_d}]</span></div>\";s:13:\"tplpart_2code\";s:738:\"<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n                          <tr>                            \r\n                    <td class=\"img\"><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" width=\"80\" height=\"60\"/></a></td>\r\n                            <td>\r\n                                \r\n                      <div class=\"t\"><a href=\"$url\" target=\"_blank\">$title</a></div>\r\n                                \r\n                      <div class=\"m\">{$content}<a href=\"$url\" target=\"_blank\">[ϸ]</a></div>\r\n                            </td>\r\n                          </tr>\r\n                        </table>\r\n                        \r\n              \";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:33:\"/common_zh_content/zh_content.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:157:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid   WHERE A.yz=1   AND R.topic=1 ORDER BY A.list ASC LIMIT 6 \";s:4:\"sql2\";s:169:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid  WHERE A.yz=1  AND A.ispic=1 AND R.topic=1 ORDER BY A.list ASC LIMIT 1 \";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:2:\"70\";s:8:\"titlenum\";s:2:\"36\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"346\";s:5:\"div_h\";s:3:\"229\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300416241','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('483','','0','0','index_cc1','code','0','<span>ITҵ</span><a href=\"#\">&gt;&gt;</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('484','','0','0','index_cc2','code','0','<span></span><a href=\"#\">&gt;&gt;</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('485','','0','0','index_digg','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:589:\"<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"listConcern\">\r\n                  <tr>\r\n                    <td class=\"L\"><div class=\"n\" id=\"DiggNum_$id\">$digg_num</div><div class=\"d\"><a href=\"$webdb[www_url]/news/job.php?job=digg&type=vote&id=$id\" target=\"DiggIframe_$id\">һ</a></div></td>\r\n                    <td class=\"R\"><a href=\"$url\" class=\"a$i\" target=\"_blank\">$title</a></td>\r\n                  </tr>\r\n                </table>\r\n<div style=\"display:none;\"><iframe src=\"about:blank\" width=0 height=0 name=\"DiggIframe_$id\" id=\"DiggIframe_$id\"></iframe></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:22:\"/article/title_dig.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 4 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"50\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"223\";s:5:\"div_h\";s:3:\"232\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300425211','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('487','','0','0','index_pk','hack_vote','0','<SCRIPT src=\'http://www_qibosoft_com/vote/vote.php?job=js&cid=10\'></SCRIPT>','a:4:{s:6:\"voteid\";s:2:\"10\";s:5:\"div_w\";s:3:\"253\";s:5:\"div_h\";s:3:\"163\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289463349','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('486','','0','0','index_tr1','Info_news_','1','a:37:{s:9:\"tplpart_1\";s:288:\"<div class=\"listzt\">\r\n        	<div class=\"img\"><a target=\"_blank\" href=\"$url\"><img src=\"$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" width=\"120\" height=\"160\"/></a></div>\r\n            <div class=\"t\"><a target=\"_blank\" href=\"$url\">$title</a></div>\r\n        </div>\";s:13:\"tplpart_1code\";s:288:\"<div class=\"listzt\">\r\n        	<div class=\"img\"><a target=\"_blank\" href=\"$url\"><img src=\"$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" width=\"120\" height=\"160\"/></a></div>\r\n            <div class=\"t\"><a target=\"_blank\" href=\"$url\">$title</a></div>\r\n        </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:11:\"specialsort\";s:13:\"RollStyleType\";s:0:\"\";s:11:\"roll_height\";s:2:\"50\";s:3:\"url\";N;s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:3:\"fid\";s:0:\"\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";N;s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:4:\"list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:111:\" SELECT A.* FROM qb_news_special A  WHERE `ifbase`=0 AND yz=1  AND A.picurl!=\'\'   ORDER BY A.list DESC LIMIT 6 \";s:4:\"sql2\";s:0:\"\";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:0:\"\";s:8:\"titlenum\";s:2:\"28\";s:9:\"titlenum2\";s:0:\"\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"985\";s:5:\"div_h\";s:3:\"208\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300424270','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('839','','0','0','listpic2','article','1','a:29:{s:13:\"tplpart_1code\";s:322:\"<div  class=\"listpic\" style=\"padding:5px 9px 3px 17px;\"> \r\n              <p class=img><a href=\"$url\" target=\"_blank\"><img width=\"120\" height=\"90\" src=\"$picurl\" border=\"0\"></a></p>\r\n              <p class=title style=\'text-align:center;\'><A HREF=\"$url\" title=\'$full_title\' target=\"_blank\">$title</A></p>\r\n            </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"200\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:3:\"100\";s:7:\"tplpath\";s:24:\"/common_pic/img_div1.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";s:2:\"10\";s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:5:\"A.aid\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:152:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.fid IN (10)  AND A.mid=\'100\'  AND A.ispic=1   AND A.ispic=1  ORDER BY A.aid DESC LIMIT 6 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"20\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1239006574','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('488','','0','0','index_tr01','code','0','<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n          <tr>\r\n            <td class=\"choose\"><a href=\"#\" class=\"nbor\"></a></td>\r\n            <td><a href=\"#\" class=\"nbor\">ͼƬ</a></td>\r\n            <td><a href=\"#\">Ӱ</a></td>\r\n            <td><a href=\"#\">̳</a></td>\r\n            <td><a href=\"#\">flash</a></td>\r\n          </tr>\r\n        </table> ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:3:\"670\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289292242','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('489','','0','0','index_vote2','hack_vote','0','<SCRIPT src=\'http://www_qibosoft_com/vote/vote.php?job=js&cid=12\'></SCRIPT>','a:4:{s:6:\"voteid\";s:2:\"12\";s:5:\"div_w\";s:3:\"444\";s:5:\"div_h\";s:3:\"227\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289463384','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('490','','0','0','wn_rollpic','rollpic','0','a:6:{s:8:\"rolltype\";s:1:\"0\";s:5:\"width\";s:3:\"280\";s:6:\"height\";s:3:\"190\";s:6:\"picurl\";a:2:{i:1;s:32:\"label/1_20101109181105_gzaok.jpg\";i:2;s:32:\"label/1_20101109181113_fwdej.jpg\";}s:7:\"piclink\";a:2:{i:1;s:1:\"#\";i:2;s:1:\"#\";}s:6:\"picalt\";a:2:{i:1;s:0:\"\";i:2;s:0:\"\";}}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','26','0','0','default');
INSERT INTO `qb_label` VALUES ('491','','0','0','wn_topic1','Info_wn_','1','a:29:{s:13:\"tplpart_1code\";s:128:\"<div class=\"list\"><a href=\"$list_url\" class=\"sort\" target=\"_blank\">[{$fname}]</a><a href=\"$url\" target=\"_blank\">$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:2:\"wn\";s:13:\"RollStyleType\";s:0:\"\";s:6:\"wninfo\";s:3:\"wn_\";s:7:\"typefid\";s:3:\"fid\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:11:\"content_num\";s:2:\"80\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:8:\"moduleid\";s:0:\"\";s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"8\";s:3:\"sql\";s:73:\" SELECT A.* FROM qb_wn_content A   WHERE 1  ORDER BY A.list DESC LIMIT 8 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"30\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289303057','0','26','0','0','default');
INSERT INTO `qb_label` VALUES ('492','','0','0','wn_tg1','Info_wn_','1','a:30:{s:13:\"tplpart_1code\";s:262:\"<div class=\"list$i\"> <span class=\"d\">{$time_y}/{$time_m}/{$time_d}</span> <span class=\"t\"><a href=\"$url\" target=\"_blank\">$title</a></span> \r\n                <span class=\"c\">{$content}<a href=\"$url\" target=\"_blank\">[鿴ȫ]</a></span> \r\n              </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:2:\"wn\";s:13:\"RollStyleType\";s:0:\"\";s:6:\"wninfo\";s:3:\"wn_\";s:7:\"typefid\";s:3:\"fid\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:11:\"content_num\";s:3:\"190\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:8:\"moduleid\";s:1:\"1\";s:5:\"stype\";s:1:\"c\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:133:\"SELECT B.*,A.* FROM qb_wn_content A  LEFT JOIN qb_wn_content_1 B ON A.id=B.id   WHERE 1  AND A.mid=\'1\'  ORDER BY A.list DESC LIMIT 5 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289305481','0','26','0','0','default');
INSERT INTO `qb_label` VALUES ('493','','0','0','wn_tg2','Info_wn_','1','a:30:{s:13:\"tplpart_1code\";s:83:\"<div class=\"list\"><a href=\"$url\" target=\"_blank\">$title</a><span>09-14</span></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:2:\"wn\";s:13:\"RollStyleType\";s:0:\"\";s:6:\"wninfo\";s:3:\"wn_\";s:7:\"typefid\";s:3:\"fid\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:11:\"content_num\";s:2:\"80\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:8:\"moduleid\";s:1:\"1\";s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:133:\"SELECT B.*,A.* FROM qb_wn_content A  LEFT JOIN qb_wn_content_1 B ON A.id=B.id   WHERE 1  AND A.mid=\'1\'  ORDER BY A.list DESC LIMIT 6 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"36\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','26','0','0','default');
INSERT INTO `qb_label` VALUES ('494','','0','0','wn_tg3','Info_wn_','1','a:30:{s:13:\"tplpart_1code\";s:65:\"<div class=\"list\"><a href=\"$url\" target=\"_blank\">$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:2:\"wn\";s:13:\"RollStyleType\";s:0:\"\";s:6:\"wninfo\";s:3:\"wn_\";s:7:\"typefid\";s:3:\"fid\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:11:\"content_num\";s:2:\"80\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:8:\"moduleid\";s:1:\"1\";s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"12\";s:3:\"sql\";s:133:\"SELECT B.*,A.* FROM qb_wn_content A  LEFT JOIN qb_wn_content_1 B ON A.id=B.id   WHERE 1  AND A.mid=\'1\'  ORDER BY A.list ASC LIMIT 12 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"30\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289305655','0','26','0','0','default');
INSERT INTO `qb_label` VALUES ('495','','0','0','wn_tg4','Info_wn_','1','a:30:{s:13:\"tplpart_1code\";s:328:\"<div class=\"listpic\">\r\n                	\r\n              <div class=\"img\"><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" width=\"120\" height=\"90\"/></a></div>\r\n                    <div class=\"t\"><a href=\"$url\" target=\"_blank\">$title</a></div>\r\n                </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:2:\"wn\";s:13:\"RollStyleType\";s:0:\"\";s:6:\"wninfo\";s:3:\"wn_\";s:7:\"typefid\";s:3:\"fid\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:11:\"content_num\";s:2:\"80\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:8:\"moduleid\";s:1:\"1\";s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:141:\"SELECT B.*,A.* FROM qb_wn_content A  LEFT JOIN qb_wn_content_1 B ON A.id=B.id   WHERE A.ispic=1  AND A.mid=\'1\'  ORDER BY A.list DESC LIMIT 5 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"30\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','26','0','0','default');
INSERT INTO `qb_label` VALUES ('496','','0','0','wn_tg01','Info_wn_','1','a:30:{s:13:\"tplpart_1code\";s:235:\"<div class=\"list$i\">\r\n                	\r\n              <div class=\"t\"><a href=\"$url\" target=\"_blank\">$title</a></div>\r\n                    <div class=\"m\">:<span>$hits</span> :<span>$comments</span></div>\r\n                </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:2:\"wn\";s:13:\"RollStyleType\";s:0:\"\";s:6:\"wninfo\";s:3:\"wn_\";s:7:\"typefid\";s:3:\"fid\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:11:\"content_num\";s:2:\"80\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:8:\"moduleid\";s:1:\"1\";s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"8\";s:3:\"sql\";s:133:\"SELECT B.*,A.* FROM qb_wn_content A  LEFT JOIN qb_wn_content_1 B ON A.id=B.id   WHERE 1  AND A.mid=\'1\'  ORDER BY A.list DESC LIMIT 8 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"30\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','26','0','0','default');
INSERT INTO `qb_label` VALUES ('497','','0','0','wn_tgh1','Info_wn_','1','a:30:{s:13:\"tplpart_1code\";s:196:\"<div class=\"listtc\">\r\n                	\r\n              <div class=\"t\"><a href=\"$url\" target=\"_blank\">$title</a></div>\r\n                    <div class=\"c\">$content</div>\r\n                </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:2:\"wn\";s:13:\"RollStyleType\";s:0:\"\";s:6:\"wninfo\";s:3:\"wn_\";s:7:\"typefid\";s:3:\"fid\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:11:\"content_num\";s:2:\"66\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:8:\"moduleid\";s:1:\"1\";s:5:\"stype\";s:1:\"c\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:133:\"SELECT B.*,A.* FROM qb_wn_content A  LEFT JOIN qb_wn_content_1 B ON A.id=B.id   WHERE 1  AND A.mid=\'1\'  ORDER BY A.list DESC LIMIT 6 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"30\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289306541','0','26','0','0','default');
INSERT INTO `qb_label` VALUES ('498','','0','0','wn_tgh2','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101109201135_eoslv.jpg\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"240\";s:6:\"height\";s:2:\"50\";}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','26','0','0','default');
INSERT INTO `qb_label` VALUES ('499','','0','0','wn_ptg4','Info_wn_','1','a:32:{s:13:\"tplpart_1code\";s:156:\" <div class=\"list\"><a href=\"$url\" class=\"sort\" target=\"_blank\">[{$fname}]</a><a href=\"$url\" target=\"_blank\">$title</a><span>{$time_m}-{$time_d}</span></div>\";s:13:\"tplpart_2code\";s:682:\"	<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"pic_word\">\r\n                      <tr>\r\n                        \r\n                  <td class=\"pic\"><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" width=\"80\" height=\"60\"/></a></td>\r\n                        <td class=\"word\">\r\n                        	\r\n                    <div class=\"t\"><a href=\"$url\" target=\"_blank\">$title</a></div>\r\n                    		\r\n                    <div class=\"c\">$content<a href=\"$url\" target=\"_blank\">[鿴ȫ]</a></div>\r\n                        </td>\r\n                      </tr>\r\n                    </table>\";s:3:\"SYS\";s:2:\"wn\";s:13:\"RollStyleType\";s:0:\"\";s:6:\"wninfo\";s:3:\"wn_\";s:7:\"typefid\";s:3:\"fid\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:2:\"70\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"tplpath\";s:25:\"/common_zh_pic/zh_pic.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:8:\"moduleid\";s:1:\"1\";s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"7\";s:3:\"sql\";s:133:\"SELECT B.*,A.* FROM qb_wn_content A  LEFT JOIN qb_wn_content_1 B ON A.id=B.id   WHERE 1  AND A.mid=\'1\'  ORDER BY A.list DESC LIMIT 7 \";s:4:\"sql2\";s:147:\"SELECT B.*,A.* FROM qb_wn_content A  LEFT JOIN qb_wn_content_1 B ON A.id=B.id   WHERE 1  AND A.mid=\'1\'  AND A.ispic=1 ORDER BY A.list DESC LIMIT 1 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"36\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289308003','0','26','0','0','default');
INSERT INTO `qb_label` VALUES ('500','','0','0','wn_ptg5','Info_wn_','1','a:32:{s:13:\"tplpart_1code\";s:156:\" <div class=\"list\"><a href=\"$url\" class=\"sort\" target=\"_blank\">[{$fname}]</a><a href=\"$url\" target=\"_blank\">$title</a><span>{$time_m}-{$time_d}</span></div>\";s:13:\"tplpart_2code\";s:682:\"	<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"pic_word\">\r\n                      <tr>\r\n                        \r\n                  <td class=\"pic\"><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" width=\"80\" height=\"60\"/></a></td>\r\n                        <td class=\"word\">\r\n                        	\r\n                    <div class=\"t\"><a href=\"$url\" target=\"_blank\">$title</a></div>\r\n                    		\r\n                    <div class=\"c\">$content<a href=\"$url\" target=\"_blank\">[鿴ȫ]</a></div>\r\n                        </td>\r\n                      </tr>\r\n                    </table>\";s:3:\"SYS\";s:2:\"wn\";s:13:\"RollStyleType\";s:0:\"\";s:6:\"wninfo\";s:3:\"wn_\";s:7:\"typefid\";s:3:\"fid\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:2:\"70\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"tplpath\";s:25:\"/common_zh_pic/zh_pic.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:8:\"moduleid\";s:1:\"1\";s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"7\";s:3:\"sql\";s:132:\"SELECT B.*,A.* FROM qb_wn_content A  LEFT JOIN qb_wn_content_1 B ON A.id=B.id   WHERE 1  AND A.mid=\'1\'  ORDER BY A.list ASC LIMIT 7 \";s:4:\"sql2\";s:146:\"SELECT B.*,A.* FROM qb_wn_content A  LEFT JOIN qb_wn_content_1 B ON A.id=B.id   WHERE 1  AND A.mid=\'1\'  AND A.ispic=1 ORDER BY A.list ASC LIMIT 1 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"36\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','26','0','0','default');
INSERT INTO `qb_label` VALUES ('501','','0','0','wn_tsf','code','0','<a href=\"#\"></a> | <a href=\"#\">˸</a> | <a href=\"#\"></a> &nbsp;&nbsp; <a href=\"#\">>></a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:3:\"250\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289308157','0','26','0','0','default');
INSERT INTO `qb_label` VALUES ('502','','0','0','wn_tp5','code','0','<a href=\"#\">...</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','26','0','0','default');
INSERT INTO `qb_label` VALUES ('503','','0','0','wn_tp3','code','0','<a href=\"#\">...</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','26','0','0','default');
INSERT INTO `qb_label` VALUES ('504','','0','0','wn_tp4','code','0','<a href=\"#\">...</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','26','0','0','default');
INSERT INTO `qb_label` VALUES ('505','','0','0','wn_tp2','code','0','<a href=\"#\">...</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','26','0','0','default');
INSERT INTO `qb_label` VALUES ('506','','0','0','wn_tp1','code','0','<a href=\"#\">...</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','26','0','0','default');
INSERT INTO `qb_label` VALUES ('507','','0','0','wn_g1','code','0','Ż','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','26','0','0','default');
INSERT INTO `qb_label` VALUES ('508','','0','0','wn_g3','code','0','','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','26','0','0','default');
INSERT INTO `qb_label` VALUES ('509','','0','0','wn_g2','code','0','ό','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','26','0','0','default');
INSERT INTO `qb_label` VALUES ('510','','0','0','wn_g4','code','0','չע','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','26','0','0','default');
INSERT INTO `qb_label` VALUES ('511','','0','0','wn_g6','code','0','','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','26','0','0','default');
INSERT INTO `qb_label` VALUES ('512','','0','0','wn_g5','code','0','ͼƬ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','26','0','0','default');
INSERT INTO `qb_label` VALUES ('513','','0','0','photo_rollpic','rollpic','0','a:6:{s:8:\"rolltype\";s:1:\"0\";s:5:\"width\";s:3:\"298\";s:6:\"height\";s:3:\"238\";s:6:\"picurl\";a:2:{i:1;s:32:\"label/1_20101110141134_yuvgy.jpg\";i:2;s:32:\"label/1_20101110141112_eb6bm.jpg\";}s:7:\"piclink\";a:2:{i:1;s:1:\"#\";i:2;s:1:\"#\";}s:6:\"picalt\";a:2:{i:1;s:0:\"\";i:2;s:0:\"\";}}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('889','','0','0','shops_p1','article','1','a:32:{s:13:\"tplpart_1code\";s:504:\"<div class=\"listshop\">\r\n                	\r\n              		<div class=\"img\"><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" width=\"120\" height=\"90\"/></a></div>\r\n                    \r\n             		 <div class=\"t\"><a href=\"$url\" target=\"_blank\">$title</a></div>\r\n                    <div class=\"p\">г<strike>{$martprice}</strike></div>\r\n                    <div class=\"p\">ۼ<span>{$nowprice}</span></div>\r\n                </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:3:\"103\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"8\";s:3:\"sql\";s:134:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'103\'  AND A.ispic=1   AND A.ispic=1  ORDER BY A.list DESC LIMIT 8 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('888','','0','0','video_h2','article','1','a:32:{s:13:\"tplpart_1code\";s:415:\"	<div class=\"listvideo\">\r\n                	\r\n              <div class=\"img\"><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" width=\"120\" height=\"90\"/></a></div>\r\n                    \r\n              <div class=\"t\"><a href=\"$url\" target=\"_blank\">$title</a></div>\r\n                    <div class=\"m\">:<span>$hits</span></div>\r\n                </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:3:\"102\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"15\";s:3:\"sql\";s:135:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'102\'  AND A.ispic=1   AND A.ispic=1  ORDER BY A.list DESC LIMIT 15 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289449096','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('887','','0','0','video_h1','article','1','a:32:{s:13:\"tplpart_1code\";s:673:\"<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"listtable\">\r\n                  <tr>\r\n                    \r\n                <td class=\"img\"><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" width=\"100\" height=\"75\"/></a></td>\r\n                    <td class=\"word\">\r\n                       \r\n                  <div class=\"t\"><a href=\"$url\" target=\"_blank\">$title</a></div>\r\n                       <div class=\"m\">:<span>$hits</span></div>\r\n                       <div class=\"m\">:<span>$comments</span></div>\r\n                    </td>\r\n                  </tr>\r\n                </table>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:3:\"102\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:134:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'102\'  AND A.ispic=1   AND A.ispic=1  ORDER BY A.list DESC LIMIT 5 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('518','','0','0','photo_t6','code','0','<a href=\"#\">...</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('519','','0','0','photo_t5','code','0','<a href=\"#\">...</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('520','','0','0','photo_t7','code','0','ͼƬ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('521','','0','0','photo_t9','code','0','ƼͼƬ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('522','','0','0','photo_t8','code','0','','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('523','','0','0','photo_t10','code','0','<a href=\"#\">...</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('524','','0','0','photo_t11','code','0','<a href=\"#\" class=\"sort choose\"><span></span></a>\r\n                <a href=\"#\" class=\"sort\"><span></span></a>\r\n                <a href=\"#\" class=\"sort\"><span>Ů</span></a>\r\n                <a href=\"#\" class=\"sort\"><span>ʱ</span></a>\r\n                <a href=\"#\" class=\"sort\"><span></span></a>\r\n                <a href=\"#\" class=\"sort\"><span></span></a>\r\n                <a href=\"#\" class=\"sort\"><span>Ļ</span></a>\r\n                <a href=\"#\" class=\"sort\"><span>Ȥ</span></a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('525','','0','0','video_rollpic','rollpic','0','a:6:{s:8:\"rolltype\";s:1:\"0\";s:5:\"width\";s:3:\"318\";s:6:\"height\";s:3:\"248\";s:6:\"picurl\";a:2:{i:1;s:32:\"label/1_20101111111131_dupyp.jpg\";i:2;s:32:\"label/1_20101111111135_0n6tg.jpg\";}s:7:\"piclink\";a:2:{i:1;s:1:\"#\";i:2;s:1:\"#\";}s:6:\"picalt\";a:2:{i:1;s:0:\"\";i:2;s:0:\"\";}}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('886','','0','0','video_t3','article','1','a:32:{s:13:\"tplpart_1code\";s:94:\"<div class=\"lista$i\"><a href=\"$url\" target=\"_blank\">$title</a>\r\n\r\n<span>{$hits}</span></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:3:\"102\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:105:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'102\'   ORDER BY A.list DESC LIMIT 10 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"36\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289448993','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('885','','0','0','video_t2','article','1','a:32:{s:13:\"tplpart_1code\";s:148:\"<div class=\"list\"><a href=\"$list_url\" class=\"sort\">[{$fname}]</a><a href=\"$url\" class=\"title\" target=\"_blank\">$title</a><span>{$hits}</span></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:3:\"102\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"8\";s:3:\"sql\";s:104:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'102\'   ORDER BY A.list DESC LIMIT 8 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"36\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289449013','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('884','','0','0','video_t1','article','1','a:32:{s:13:\"tplpart_1code\";s:443:\"<div class=\"listvideo\">\r\n                	\r\n              <div class=\"img\"><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" width=\"150\" height=\"100\"/></a></div>\r\n                    \r\n              <div class=\"t\"><a href=\"$url\" target=\"_blank\">$title</a></div>\r\n                    <div class=\"m\">:<span>$comments</span> :<span>$hits</span></div>\r\n                </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:3:\"102\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:134:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'102\'  AND A.ispic=1   AND A.ispic=1  ORDER BY A.list DESC LIMIT 6 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289446391','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('882','','0','0','photo_t3','article','1','a:32:{s:13:\"tplpart_1code\";s:68:\"<div class=\"lista$i\"><a href=\"$url\" target=\"_blank\">$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:3:\"100\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:105:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'100\'   ORDER BY A.list DESC LIMIT 10 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289374054','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('883','','0','0','photo_t4','article','1','a:32:{s:13:\"tplpart_1code\";s:68:\"<div class=\"listb$i\"><a href=\"$url\" target=\"_blank\">$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:3:\"100\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"11\";s:3:\"sql\";s:104:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'100\'   ORDER BY A.list ASC LIMIT 11 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('881','','0','0','photo_t2','article','1','a:32:{s:13:\"tplpart_1code\";s:312:\"<div class=\"listpic\">\r\n                	<div class=\"img\"><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" width=\"120\" height=\"90\"/></a></div>\r\n                    <div class=\"t\"><a href=\"$url\" target=\"_blank\">$title</a></div>\r\n                </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:3:\"100\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"15\";s:3:\"sql\";s:135:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'100\'  AND A.ispic=1   AND A.ispic=1  ORDER BY A.list DESC LIMIT 15 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('531','','0','0','video_c1','code','0','<a href=\"#\">...</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('532','','0','0','video_c2','code','0','<a href=\"#\">...</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('533','','0','0','video_c3','code','0','<a href=\"#\">...</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('534','','0','0','video_c5','code','0','ӰȲ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('535','','0','0','video_c7','code','0','ѡƵ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('536','','0','0','video_c9','code','0',' <a href=\"#\" class=\"sort choose\"><span></span></a>\r\n                <a href=\"#\" class=\"sort\"><span></span></a>\r\n                <a href=\"#\" class=\"sort\"><span>Ů</span></a>\r\n                <a href=\"#\" class=\"sort\"><span>ʱ</span></a>\r\n                <a href=\"#\" class=\"sort\"><span></span></a>\r\n                <a href=\"#\" class=\"sort\"><span></span></a>\r\n                <a href=\"#\" class=\"sort\"><span>Ļ</span></a>\r\n                <a href=\"#\" class=\"sort\"><span>Ȥ</span></a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('537','','0','0','video_c10','code','0','Ƶ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('538','','0','0','video_ad1','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101111121107_nd3ch.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"720\";s:6:\"height\";s:2:\"90\";}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('539','','0','0','video_ad2','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101111121116_80r2g.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"260\";s:6:\"height\";s:2:\"90\";}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('540','','0','0','shops_rollpic','rollpic','0','a:6:{s:8:\"rolltype\";s:1:\"0\";s:5:\"width\";s:3:\"530\";s:6:\"height\";s:3:\"210\";s:6:\"picurl\";a:2:{i:1;s:32:\"label/1_20101111141159_txw13.jpg\";i:2;s:32:\"label/1_20101111141105_k2yzk.jpg\";}s:7:\"piclink\";a:2:{i:1;s:1:\"#\";i:2;s:1:\"#\";}s:6:\"picalt\";a:2:{i:1;s:0:\"\";i:2;s:0:\"\";}}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('541','','0','0','shops_sort','code','0','	<dl>\r\n                	<dt><a href=\"list.php?fid=16\" target=\"_blank\">Ʒ</a></dt>\r\n                    <dd>\r\n                    	<div><a href=\"list.php?fid=16\" target=\"_blank\">ʾ</a></div>\r\n                        <div><a href=\"list.php?fid=16\" target=\"_blank\">ʾ</a></div>\r\n                        <div><a href=\"list.php?fid=16\" target=\"_blank\">ʾ</a></div>\r\n                        <div><a href=\"list.php?fid=16\" target=\"_blank\">ʾ</a></div>\r\n                        <div><a href=\"list.php?fid=16\" target=\"_blank\">ʾ</a></div>\r\n                        <div><a href=\"list.php?fid=16\" target=\"_blank\">ʾ</a></div>\r\n                    </dd>\r\n                </dl>\r\n                <dl>\r\n                	<dt><a href=\"list.php?fid=16\" target=\"_blank\">Ʒ</a></dt>\r\n                    <dd>\r\n                    	<div><a href=\"list.php?fid=16\" target=\"_blank\">ʾ</a></div>\r\n                        <div><a href=\"list.php?fid=16\" target=\"_blank\">ʾ</a></div>\r\n                        <div><a href=\"list.php?fid=16\" target=\"_blank\">ʾ</a></div>\r\n                        <div><a href=\"list.php?fid=16\" target=\"_blank\">ʾ</a></div>\r\n                        <div><a href=\"list.php?fid=16\" target=\"_blank\">ʾ</a></div>\r\n                        <div><a href=\"list.php?fid=16\" target=\"_blank\">ʾ</a></div>\r\n                    </dd>\r\n                </dl>\r\n                <dl>\r\n                	<dt><a href=\"list.php?fid=16\" target=\"_blank\">Ʒ</a></dt>\r\n                    <dd>\r\n                    	<div><a href=\"list.php?fid=16\" target=\"_blank\">ʾ</a></div>\r\n                        <div><a href=\"list.php?fid=16\" target=\"_blank\">ʾ</a></div>\r\n                        <div><a href=\"list.php?fid=16\" target=\"_blank\">ʾ</a></div>\r\n                        <div><a href=\"list.php?fid=16\" target=\"_blank\">ʾ</a></div>\r\n						\r\n                    </dd>\r\n                </dl>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('880','','0','0','photo_t1','article','1','a:32:{s:13:\"tplpart_1code\";s:313:\"	<div class=\"listpic\">\r\n                	<div class=\"img\"><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" width=\"125\" height=\"90\"/></a></div>\r\n                    <div class=\"t\"><a href=\"$url\" target=\"_blank\">$title</a></div>\r\n                </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:3:\"100\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:134:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'100\'  AND A.ispic=1   AND A.ispic=1  ORDER BY A.list DESC LIMIT 6 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('955','','0','0','blue_newsstc6','Info_video_','1','a:35:{s:13:\"tplpart_1code\";s:65:\"<div class=\"list\"><A HREF=\"$url\" target=\'_blank\'>$title</a></div>\";s:13:\"tplpart_2code\";s:410:\"<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n  <tr>\r\n    <td class=\"img\"><div><a href=\"$url\" target=\"_blank\" title=\"$full_title\"><img src=\"$picurl\" width=\"100\" /></a></div></td>\r\n    <td class=\"word\">\r\n    	<h3><a href=\"$url\" target=\"_blank\" title=\"$full_title\">$title</a></h3>\r\n    	<p>$content<a href=\"$url\" target=\"_blank\" title=\"$full_title\">[ϸ]</a></p>\r\n    </td>\r\n  </tr>\r\n</table>\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:6:\"video_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:33:\"/common_zh_content/zh_content.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"2\";s:3:\"sql\";s:160:\" SELECT A.*,A.aid AS id,R.content FROM qb_video_article A LEFT JOIN qb_video_reply R ON A.aid=R.aid   WHERE A.yz=1   AND R.topic=1 ORDER BY A.list DESC LIMIT 3 \";s:4:\"sql2\";s:172:\" SELECT A.*,A.aid AS id,R.content FROM qb_video_article A LEFT JOIN qb_video_reply R ON A.aid=R.aid  WHERE A.yz=1  AND A.ispic=1 AND R.topic=1 ORDER BY A.list DESC LIMIT 1 \";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:2:\"60\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('948','','0','0','blue_newst12','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:67:\"<div class=\"list\"><a href=\"$url\" target=\'_blank\'>$title</a></div>\r\n\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:91:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list ASC LIMIT 5 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"50\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1301448977','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('949','','0','0','blue_newsh10','code','0','Ѷ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('950','','0','0','blue_newsm10','code','0','<a href=\"#\">ýۼ</a> | <a href=\"#\"≯Ƶ</a> | <a href=\"#\">&gt;&gt;</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('951','','0','0','blue_newsh12','code','0','߲','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('952','','0','0','blue_newsh11','code','0','ط','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('953','','0','0','blue_newsh9','code','0','󻰺','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('954','','0','0','blue_newst9','Info_news_','1','a:36:{s:13:\"tplpart_1code\";s:231:\"<div class=\"listpic\">\r\n	<div class=\"img\"><a href=\"$url\" target=\"_blank\" title=\"$full_title\"><img src=\"$picurl\" width=\"120\" /></a></div>\r\n    <div class=\"t\"><a href=\"$url\" target=\"_blank\" title=\"$full_title\">$title</a></div>\r\n</div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"2\";s:3:\"sql\";s:124:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1  AND A.ispic=1   AND A.ispic=1  ORDER BY A.list DESC LIMIT 0,2 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"20\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1306912142','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('547','','0','0','shops_f1','code','0','<dl>\r\n                <dt><a href=\"#\">Ա</a></dt>\r\n                <dd>\r\n                    <div><a href=\"#\"></a></div>\r\n                    <div><a href=\"#\">Ҫ</a></div>\r\n                    <div><a href=\"#\">鿴ѹƷ</a></div>\r\n                    <div><a href=\"#\"></a></div>\r\n                    <div><a href=\"#\">עΪ...</a></div>\r\n                </dd>\r\n            </dl>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('548','','0','0','shops_f2','code','0','<dl>\r\n                <dt><a href=\"#\">֮</a></dt>\r\n                <dd>\r\n                    <div><a href=\"#\">뿪</a></div>\r\n                    <div><a href=\"#\">ι</a></div>\r\n                    <div><a href=\"#\">鿴۳Ʒ</a></div>\r\n                    <div><a href=\"#\">η</a></div>\r\n                    <div><a href=\"#\">̳ƷƼ</a></div>\r\n                </dd>\r\n            </dl>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('549','','0','0','shops_f3','code','0','<dl>\r\n                <dt><a href=\"#\">֧ʽ</a></dt>\r\n                <dd>\r\n                    <div><a href=\"#\">֧</a></div>\r\n                    <div><a href=\"#\">עƸͨ</a></div>\r\n                    <div><a href=\"#\">עᱴ</a></div>\r\n                    <div><a href=\"#\">ʹԤ</a></div>\r\n                    <div><a href=\"#\">ע֧</a></div>\r\n                </dd>\r\n            </dl>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('550','','0','0','shops_f4','code','0','<dl>\r\n                <dt><a href=\"#\"></a></dt>\r\n                <dd>\r\n                    <div><a href=\"#\">ι</a></div>\r\n                    <div><a href=\"#\">ٱ̼</a></div>\r\n                    <div><a href=\"#\">Ͷߵ</a></div>\r\n                    <div><a href=\"#\">ϵ</a></div>\r\n                    <div><a href=\"#\">ٱ</a></div>\r\n                </dd>\r\n            </dl>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('551','','0','0','shops_f5','code','0','<dl>\r\n                <dt><a href=\"#\">ͷ</a></dt>\r\n                <dd>\r\n                    <div><a href=\"#\">Ա޸</a></div>\r\n                    <div><a href=\"#\">޸ջַ</a></div>\r\n                    <div><a href=\"#\">Ʒ</a></div>\r\n                    <div><a href=\"#\">Ա޸ĸϢ</a></div>\r\n                </dd>\r\n            </dl>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('552','','0','0','shops_f6','code','0','<dl>\r\n                <dt><a href=\"#\"></a></dt>\r\n                <dd>\r\n                    <div><a href=\"#\"></a></div>\r\n                    <div><a href=\"#\">ͬͬͬ</a></div>\r\n                </dd>\r\n            </dl>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('553','','0','0','shops_ad1','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101111141108_fefgd.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"230\";s:6:\"height\";s:2:\"80\";}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('554','','0','0','shops_ad2','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101111141125_iaj1l.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"230\";s:6:\"height\";s:2:\"80\";}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('555','','0','0','shops_ad3','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101111141143_r4drz.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"230\";s:6:\"height\";s:2:\"80\";}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('556','','0','0','shops_ad4','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101111141103_rpuaq.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"230\";s:6:\"height\";s:2:\"80\";}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('557','','0','0','shops_ad5','code','0','	<div class=\"list\"><a href=\"#\">ñ׶԰ʼ</a><span>Ż</span></div>\r\n                <div class=\"list\"><a href=\"#\">Ҹüҽ:</a><em>010:88888888</em></div>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('558','','0','0','shops_ad6','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101111141126_b9tqw.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"200\";s:6:\"height\";s:2:\"55\";}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('559','','0','0','shops_a_d1','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101111141115_ci14j.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:2:\"90\";s:6:\"height\";s:2:\"35\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289458738','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('560','','0','0','shops_a_d2','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101111141129_5prhy.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:2:\"90\";s:6:\"height\";s:2:\"35\";}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('561','','0','0','shops_a_d3','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101111141110_oqdpu.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:2:\"90\";s:6:\"height\";s:2:\"35\";}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('562','','0','0','shops_a_d4','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101111141131_k3xih.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:2:\"90\";s:6:\"height\";s:2:\"35\";}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('563','','0','0','shops_a_d5','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101111141151_9lauy.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:2:\"90\";s:6:\"height\";s:2:\"35\";}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('564','','0','0','shops_a_d6','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101111151112_vin0e.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:2:\"90\";s:6:\"height\";s:2:\"35\";}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('565','','0','0','shops_a_d7','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101111151133_53hvd.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:2:\"90\";s:6:\"height\";s:2:\"35\";}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('566','','0','0','shops_a_d8','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101111151150_avkih.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:2:\"90\";s:6:\"height\";s:2:\"35\";}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('567','','0','0','shops_a_d9','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101111151107_s9khw.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:2:\"90\";s:6:\"height\";s:2:\"35\";}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('568','','0','0','shops_a_d10','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101111151123_lxocu.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:2:\"90\";s:6:\"height\";s:2:\"35\";}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('569','','0','0','shops_pp2','code','0','<a href=\"#\">...</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('570','','0','0','shops_pp1','code','0','<a href=\"#\" class=\"sort choose\"><span>Ҿ</span></a>\r\n                <a href=\"#\" class=\"sort\"><span>Ʒ</span></a>\r\n                <a href=\"#\" class=\"sort\"><span>װЬñ</span></a>\r\n                <a href=\"#\" class=\"sort\"><span></span></a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('571','','0','0','shops_pp0','code','0','̳ǲƷ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('572','','0','0','shops_pv3','code','0','̳ǹ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('573','','0','0','shops_pv4','code','0','Ʒ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('574','','0','0','shops_pcv2','code','0','֮','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('575','','0','0','shops_pcv3','code','0','ƼƷ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('576','','0','0','down_ad1','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101111191127_zgile.jpg\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"710\";s:6:\"height\";s:2:\"70\";}','a:3:{s:5:\"div_w\";s:3:\"707\";s:5:\"div_h\";s:2:\"69\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289475404','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('577','','0','0','down_ad2','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101111191154_ykdyp.jpg\";s:7:\"imglink\";s:21:\"http://www.1gftp.com/\";s:5:\"width\";s:3:\"270\";s:6:\"height\";s:2:\"70\";}','a:3:{s:5:\"div_w\";s:3:\"267\";s:5:\"div_h\";s:2:\"68\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1292643191','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('578','','0','0','down_ad3','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101111191142_bnynf.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"710\";s:6:\"height\";s:2:\"90\";}','a:3:{s:5:\"div_w\";s:3:\"708\";s:5:\"div_h\";s:2:\"88\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289475569','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('579','','0','0','down_ad4','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101111191109_shrig.gif\";s:7:\"imglink\";s:21:\"http://www.zwidc.com/\";s:5:\"width\";s:3:\"270\";s:6:\"height\";s:2:\"90\";}','a:3:{s:5:\"div_w\";s:3:\"268\";s:5:\"div_h\";s:2:\"89\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1292643722','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('580','','0','0','down_ad5','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101111191153_sdera.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"270\";s:6:\"height\";s:2:\"85\";}','a:3:{s:5:\"div_w\";s:3:\"270\";s:5:\"div_h\";s:2:\"84\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289475675','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('947','','0','0','blue_newst11','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:67:\"<div class=\"list\"><a href=\"$url\" target=\'_blank\'>$title</a></div>\r\n\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:24:\"/common_title/0title.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"2\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 2 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"50\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1301448965','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('946','','0','0','blue_newst13','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:65:\"<div class=\"list\"><a href=\"$url\" target=\'_blank\'>$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.hits\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.hits DESC LIMIT 5 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"50\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1301448988','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('945','','0','0','blue_newst14','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:65:\"<div class=\"list\"><a href=\"$url\" target=\'_blank\'>$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:10:\"A.digg_num\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"2\";s:3:\"sql\";s:96:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.digg_num DESC LIMIT 2 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"50\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1301449008','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('942','','0','0','blue_newsh15','code','0','<div class=\"tag\"></div><div class=\"more\"><a href=\"#\"></a></div>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('943','','0','0','blue_newst15','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:65:\"<div class=\"list\"><a href=\"$url\" target=\'_blank\'>$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 4 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('944','','0','0','blue_newst16','Info_news_','1','a:36:{s:13:\"tplpart_1code\";s:231:\"<div class=\"listpic\">\r\n	<div class=\"img\"><a href=\"$url\" target=\"_blank\" title=\"$full_title\"><img src=\"$picurl\" width=\"100\" /></a></div>\r\n    <div class=\"t\"><a href=\"$url\" target=\"_blank\" title=\"$full_title\">$title</a></div>\r\n</div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:124:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1  AND A.ispic=1   AND A.ispic=1  ORDER BY A.list DESC LIMIT 0,4 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"20\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1306912150','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('940','','0','0','blue_newsh13','code','0','','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('941','','0','0','blue_newsh14','code','0','̨','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('936','','0','0','blue_newsh16','code','0','<div class=\"tag\">Ƶ</div><div class=\"more\"><a href=\"#\"></a></div>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('937','','0','0','blue_newsad3','pic','0','a:4:{s:6:\"imgurl\";s:28:\"../news/images/blue/nad3.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"990\";s:6:\"height\";s:3:\"100\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1301451372','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('938','','0','0','blue_newsh17','code','0','<div class=\"tag\">ǿͼ</div><div class=\"more\"><a href=\"#\"></a></div>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1301452497','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('939','','0','0','blue_newst17a','Info_news_','1','a:36:{s:13:\"tplpart_1code\";s:231:\"<div class=\"listpic\">\r\n	<div class=\"img\"><a href=\"$url\" target=\"_blank\" title=\"$full_title\"><img src=\"$picurl\" width=\"260\" /></a></div>\r\n    <div class=\"t\"><a href=\"$url\" target=\"_blank\" title=\"$full_title\">$title</a></div>\r\n</div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.hits\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"1\";s:3:\"sql\";s:124:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1  AND A.ispic=1   AND A.ispic=1  ORDER BY A.hits DESC LIMIT 0,1 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1306912160','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('870','','0','0','new_p3','article','1','a:32:{s:13:\"tplpart_1code\";s:108:\"<div class=\"list l$i\"><a href=\"$url\" target=\"_blank\">$title</a><span><a>{$time_m}-{$time_d}</a></span></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:102:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'0\'   ORDER BY A.list DESC LIMIT 6 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"42\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('590','','0','0','down_c4','code','0','<a href=\"list.php?fid=40\" target=\"_blank\">..</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('591','','0','0','down_c3','code','0','<a href=\"list.php?fid=27\" target=\"_blank\">..</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('592','','0','0','down_c2','code','0','<a href=\"list.php?fid=26\" target=\"_blank\">..</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('593','','0','0','down_c1','code','0','<a href=\"list.php?fid=12\" target=\"_blank\">..</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('594','','0','0','down_bv1','code','0','վ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('595','','0','0','down_bv2','code','0','װ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('596','','0','0','down_bv3','code','0','칫','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('597','','0','0','down_bv4','code','0','ɱ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('598','','0','0','down_a4','code','0','¸','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('599','','0','0','down_a3','code','0','հ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289481643','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('600','','0','0','down_a2','code','0','Ƽ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('601','','0','0','down_a1','code','0','װƼ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('602','','0','0','down_d2','code','0','Ƽ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('603','','0','0','down_dp2','code','0','<a href=\"#\">Դ</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('604','','0','0','down_t3v','code','0','<div>ո:<span>5</span> :<span>1</span></div>\r\n                <div>:<em>651</em> :<em>103</em></div>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289481879','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('605','','0','0','w8_ad','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101111211144_j117r.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"990\";s:6:\"height\";s:2:\"70\";}','a:3:{s:5:\"div_w\";s:3:\"987\";s:5:\"div_h\";s:2:\"67\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289482282','0','27','0','0','default');
INSERT INTO `qb_label` VALUES ('606','','0','99','head_search','code','0','<a href=\"http://www_qibosoft_com/news/search.php?keyword=벩CMS\" class=\"b\">벩CMS</a> \r\n        <a href=\"http://www_qibosoft_com/news/search.php?keyword=ע\" target=\"_blank\">ע</a> \r\n        <a href=\"http://www_qibosoft_com/news/search.php?keyword=CEO\" target=\"_blank\">CEO</a> \r\n        <a href=\"http://www_qibosoft_com/news/search.php?keyword=Դ\" target=\"_blank\">Դ</a> \r\n        <a href=\"http://www_qibosoft_com/news/search.php?keyword=ITѶ\" target=\"_blank\">ITѶ</a> \r\n        <a href=\"http://www_qibosoft_com/news/search.php?keyword=ռ\" target=\"_blank\">ռ</a> \r\n        <a href=\"http://www_qibosoft_com/news/search.php?keyword=վֲ\" class=\"b\" target=\"_blank\">վֲ</a> \r\n        <a href=\"http://www_qibosoft_com/news/search.php?keyword=̳\" target=\"_blank\">̳</a> \r\n        <a href=\"http://www_qibosoft_com/news/search.php?keyword=ѯ\" class=\"b\" target=\"_blank\">ѯ</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:3:\"617\";s:5:\"div_h\";s:2:\"32\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300431312','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('607','','0','0','special_sport_1','code','0','<a href=\"#\">ղ</a> | <a href=\"#\">Ϊҳ</a> ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:3:\"113\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290131646','11','30','19','0','default');
INSERT INTO `qb_label` VALUES ('608','','0','0','special_sport_2','code','0','<a href=\"#\"></a> | <a href=\"#\"></a> | <a href=\"#\"></a> ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:3:\"191\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290131639','11','30','19','0','default');
INSERT INTO `qb_label` VALUES ('609','','0','0','special_sport_3','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101119091126_q0kjm.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"960\";s:6:\"height\";s:3:\"160\";}','a:3:{s:5:\"div_w\";s:3:\"961\";s:5:\"div_h\";s:3:\"159\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290137907','11','30','19','0','default');
INSERT INTO `qb_label` VALUES ('610','','0','0','special_sport_4','rollpic','0','a:6:{s:8:\"rolltype\";s:1:\"0\";s:5:\"width\";s:3:\"306\";s:6:\"height\";s:3:\"262\";s:6:\"picurl\";a:2:{i:1;s:32:\"label/1_20101119101151_gvdry.jpg\";i:2;s:32:\"label/1_20101119101155_mqgga.jpg\";}s:7:\"piclink\";a:2:{i:1;s:1:\"#\";i:2;s:1:\"#\";}s:6:\"picalt\";a:2:{i:1;s:0:\"\";i:2;s:0:\"\";}}','a:3:{s:5:\"div_w\";s:3:\"310\";s:5:\"div_h\";s:3:\"262\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290132179','11','30','19','0','default');
INSERT INTO `qb_label` VALUES ('611','','0','0','special_sport_5','swf','0','a:3:{s:8:\"flashurl\";s:58:\"http://player.youku.com/player.php/sid/XOTk1OTE2NjQ=/v.swf\";s:5:\"width\";s:3:\"305\";s:6:\"height\";s:3:\"275\";}','a:3:{s:5:\"div_w\";s:3:\"302\";s:5:\"div_h\";s:3:\"271\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290132344','11','30','19','0','default');
INSERT INTO `qb_label` VALUES ('612','','0','0','special_sport_6','code','0','ϣ˹','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','19','0','default');
INSERT INTO `qb_label` VALUES ('613','','0','0','special_sport_7','code','0','<table width=\"96%\" border=\"0\" align=\"center\" cellpadding=\"0\" cellspacing=\"0\" class=\"right_content1\">\r\n					  <tr>\r\n						<td width=\"45%\"><img src=\"http://www_qibosoft_com/images/special/sports/tiyu_photo3.gif\" width=\"100\" height=\"80\" /></td>\r\n					    <td width=\"55%\">ϣ˹Ϊɫıѡ֣ļʹõ20ھ...[<a href=\"#\">ϸ</a>]</td>\r\n					  </tr>\r\n					 </table>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:3:\"243\";s:5:\"div_h\";s:2:\"90\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290132645','11','30','19','0','default');
INSERT INTO `qb_label` VALUES ('614','','0','0','special_sport_8','code','0','ý','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','19','0','default');
INSERT INTO `qb_label` VALUES ('615','','0','0','special_sport_9','code','0','<img src=\"http://www_qibosoft_com/images/special/sports/tiyu_photo4.gif\" width=\"166\" height=\"78\" /><br />Ϻ¥̶','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:3:\"187\";s:5:\"div_h\";s:3:\"104\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290132805','11','30','19','0','default');
INSERT INTO `qb_label` VALUES ('616','','0','0','special_sport_10','code','0','ѵ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','19','0','default');
INSERT INTO `qb_label` VALUES ('617','','0','0','special_sport_11','code','0','<table width=\"96%\" border=\"0\" align=\"center\" cellpadding=\"0\" cellspacing=\"0\" class=\"right_content1 tiyu_top\">\r\n					  <tr>\r\n						<td id=\"vote_title\">ϣ˹ô?</td>\r\n				      </tr>\r\n					  <tr>\r\n						<td class=\"vote_cont\">\r\n							<span><input type=\"radio\" name=\"radiobutton\" value=\"radiobutton\" /> ,ϣ˹˵°ܻ</span>\r\n							<span><input type=\"radio\" name=\"radiobutton\" value=\"radiobutton\" /> ,˹ŵҲǸɾ</span>\r\n							<span><input type=\"radio\" name=\"radiobutton\" value=\"radiobutton\" /> ,ϣ˹ô</span>\r\n							<span><input type=\"radio\" name=\"radiobutton\" value=\"radiobutton\" /> ,Աȷʵ⿿Լ</span>\r\n							<span><input type=\"radio\" name=\"radiobutton\" value=\"radiobutton\" /> ˵壬̬չ</span>\r\n						</td>\r\n				      </tr>\r\n				  </table>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:3:\"245\";s:5:\"div_h\";s:3:\"210\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290132887','11','30','19','0','default');
INSERT INTO `qb_label` VALUES ('618','','0','0','special_sport_12','code','0','<font face=\"\"><a href=\"#\" >ϣ˹ϴѶ</a> <a href=\"#\">6·75000Ӣ</a></font>\r\n\r\n\r\n ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:3:\"367\";s:5:\"div_h\";s:2:\"20\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290133123','11','30','19','0','default');
INSERT INTO `qb_label` VALUES ('619','','0','0','special_sport_13','code','0','<font face=\"\"><a href=\"#\" >ϣ˹ź¶</a> <a href=\"#\">佱񵱾ȳα</a></font>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:3:\"366\";s:5:\"div_h\";s:2:\"20\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290133184','11','30','19','0','default');
INSERT INTO `qb_label` VALUES ('620','','0','0','special_sport_14','code','0','<font face=\"\"><a href=\"#\" >Ӣýϣ˹ջ¸</a> <a href=\"#\">̨</a></font> ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:3:\"370\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290133258','11','30','19','0','default');
INSERT INTO `qb_label` VALUES ('869','','0','0','new_p2','article','1','a:32:{s:13:\"tplpart_1code\";s:108:\"<div class=\"list l$i\"><a href=\"$url\" target=\"_blank\">$title</a><span><a>{$time_m}-{$time_d}</a></span></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:101:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'0\'   ORDER BY A.list ASC LIMIT 6 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"42\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289207948','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('868','','0','0','new_u1','article','1','a:32:{s:13:\"tplpart_1code\";s:108:\"<div class=\"list l$i\"><a href=\"$url\" target=\"_blank\">$title</a><span><a>{$time_m}-{$time_d}</a></span></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:102:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'0\'   ORDER BY A.list DESC LIMIT 5 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"42\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289207819','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('867','','0','0','new_p1','article','1','a:32:{s:13:\"tplpart_1code\";s:110:\"<div class=\"list_t_c\"> <a href=\"$url\" class=\"title\" target=\"_blank\">$title</a> \r\n              $content </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:29:\"/common_content/content_1.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"c\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:163:\" SELECT A.*,A.aid AS id,R.content FROM qb_article A LEFT JOIN qb_reply R ON A.aid=R.aid   WHERE A.yz=1  AND A.mid=\'0\'   AND R.topic=1 ORDER BY A.list DESC LIMIT 4 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:3:\"120\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289207618','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('866','','0','0','new_ps','article','1','a:32:{s:13:\"tplpart_1code\";s:536:\"	<table width=\"100%\" border=\"0\" cellspacing=\"0\" align=\"center\" cellpadding=\"0\" class=\"listtable\">\r\n                  <tr>\r\n                    \r\n                <td class=\"pic\"><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" width=\"70\" height=\"70\" /></a></td>\r\n                    <td class=\"word\">\r\n                    	<a href=\"$url\" class=\"title\">$title</a>\r\n                        $content\r\n                    </td>\r\n                  </tr>\r\n                </table>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:33:\"/common_pic/title_pic_content.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:2:\"cp\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:192:\" SELECT A.*,A.aid AS id,R.content FROM qb_article A LEFT JOIN qb_reply R ON A.aid=R.aid   WHERE A.yz=1  AND A.mid=\'0\'  AND A.ispic=1   AND A.ispic=1  AND R.topic=1 ORDER BY A.list ASC LIMIT 4 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"56\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"20\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289207490','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('625','','0','0','special_sport_19','code','0','ϣ˹ݶ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:3:\"127\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290133781','11','30','19','0','default');
INSERT INTO `qb_label` VALUES ('626','','0','0','special_sport_20','code','0','½չ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','19','0','default');
INSERT INTO `qb_label` VALUES ('627','','0','0','special_sport_21','code','0','','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','19','0','default');
INSERT INTO `qb_label` VALUES ('865','','0','0','new_photo','article','1','a:32:{s:13:\"tplpart_1code\";s:274:\"<div class=\"listpic\">\r\n			 <a href=\"$url\" class=\"pic\" target=\"_blank\"><img src=\"$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" width=\"120\" height=\"90\" /></a> \r\n              <a href=\"$url\" class=\"title\" target=\"_blank\">$title</a> \r\n            </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:132:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'0\'  AND A.ispic=1   AND A.ispic=1  ORDER BY A.list DESC LIMIT 4 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"20\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('864','','0','0','new_2','article','1','a:32:{s:13:\"tplpart_1code\";s:105:\"<div class=\"list\"><em>$i</em><a href=\"$url\" target=\"_blank\">$title</a><span><a>{$hits}</a></span></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"8\";s:3:\"sql\";s:102:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'0\'   ORDER BY A.list DESC LIMIT 8 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"32\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289206999','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('631','','0','0','special_car_1','code','0','ղ | Ϊҳ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:3:\"147\";s:5:\"div_h\";s:2:\"20\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290150121','11','30','22','0','default');
INSERT INTO `qb_label` VALUES ('632','','0','0','special_car_2','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101119151121_pnoj5.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:4:\"1014\";s:6:\"height\";s:3:\"166\";}','a:3:{s:5:\"div_w\";s:4:\"1008\";s:5:\"div_h\";s:3:\"153\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290150338','11','30','22','0','default');
INSERT INTO `qb_label` VALUES ('633','','0','0','special_car_3','rollpic','0','a:6:{s:8:\"rolltype\";s:1:\"0\";s:5:\"width\";s:3:\"346\";s:6:\"height\";s:3:\"250\";s:6:\"picurl\";a:2:{i:1;s:32:\"label/1_20101119151138_usu7n.jpg\";i:2;s:32:\"label/1_20101119151145_ysl0g.jpg\";}s:7:\"piclink\";a:2:{i:1;s:1:\"#\";i:2;s:1:\"#\";}s:6:\"picalt\";a:2:{i:1;s:0:\"\";i:2;s:0:\"\";}}','a:3:{s:5:\"div_w\";s:3:\"180\";s:5:\"div_h\";s:3:\"253\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290150658','11','30','22','0','default');
INSERT INTO `qb_label` VALUES ('634','','0','0','special_car_4','swf','0','a:3:{s:8:\"flashurl\";s:58:\"http://player.youku.com/player.php/sid/XMjE3NjczMDQ0/v.swf\";s:5:\"width\";s:3:\"344\";s:6:\"height\";s:3:\"256\";}','a:3:{s:5:\"div_w\";s:3:\"172\";s:5:\"div_h\";s:3:\"257\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290150893','11','30','22','0','default');
INSERT INTO `qb_label` VALUES ('635','','0','0','special_car_5','code','0','µA3౱չ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:3:\"154\";s:5:\"div_h\";s:2:\"17\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290150943','11','30','22','0','default');
INSERT INTO `qb_label` VALUES ('636','','0','0','special_car_6','code','0','<a href=\"#\"><span class=\"STYLE1\">[µA3Ƶ]</span></a> <a href=\"#\"><span class=\"STYLE1\">[ʵʳչ]</span></a> \r\n                  <a href=\"#\"><span class=\"STYLE1\">[µϳѻ]</span></a> <a href=\"#\"><span class=\"STYLE1\">[΢۰µA3]</span></a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:3:\"339\";s:5:\"div_h\";s:2:\"16\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290152789','11','30','22','0','default');
INSERT INTO `qb_label` VALUES ('863','','0','0','new_1','article','1','a:32:{s:13:\"tplpart_1code\";s:257:\"<div class=\"list$i\">\r\n            	\r\n          <div class=\"title\"><a href=\"$url\" target=\"_blank\">$title</a></div>\r\n                \r\n          <div class=\"content\">{$content}...<a href=\"$url\" target=\"_blank\">[ϸ]</a> \r\n          </div>\r\n            </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:29:\"/common_content/content_1.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"c\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"3\";s:3:\"sql\";s:163:\" SELECT A.*,A.aid AS id,R.content FROM qb_article A LEFT JOIN qb_reply R ON A.aid=R.aid   WHERE A.yz=1  AND A.mid=\'0\'   AND R.topic=1 ORDER BY A.list DESC LIMIT 3 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:3:\"110\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"36\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"390\";s:5:\"div_h\";s:3:\"250\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289208353','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('862','','0','0','list_page_mv','article','1','a:31:{s:13:\"tplpart_1code\";s:195:\"(mv,290,210,false)$mvurl(/mv)\r\n<div style=\"line-height:170%;text-align:center;padding-top:8px;\"><A HREF=\"$url\" target=\'_blank\'  style=\"$fontcolor;$fontweight\" title=\'$full_title\'>$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:3:\"102\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:5:\"A.aid\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"1\";s:3:\"sql\";s:103:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'102\'   ORDER BY A.aid DESC LIMIT 1 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1240292096','2','0','0','0','default');
INSERT INTO `qb_label` VALUES ('639','','0','0','special_car_9','code','0','ԼݰµA3','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','22','0','default');
INSERT INTO `qb_label` VALUES ('861','','0','0','mvshow','article','1','a:31:{s:13:\"tplpart_1code\";s:144:\"(mv,400,300,false)$mvurl(/mv)<div style=\"padding:8px 0 10px 0;\"> <A HREF=\"$url\" target=\'_blank\'  style=\"font-size:14px;\"><b>$title</b></a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:3:\"102\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:5:\"A.aid\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"1\";s:3:\"sql\";s:103:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'102\'   ORDER BY A.aid DESC LIMIT 1 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"50\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','19','0','default');
INSERT INTO `qb_label` VALUES ('641','','0','0','special_car_11','code','0','µA3','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','22','0','default');
INSERT INTO `qb_label` VALUES ('860','','0','0','mvshow','article','1','a:31:{s:13:\"tplpart_1code\";s:144:\"(mv,400,300,false)$mvurl(/mv)<div style=\"padding:8px 0 10px 0;\"> <A HREF=\"$url\" target=\'_blank\'  style=\"font-size:14px;\"><b>$title</b></a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:3:\"102\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:5:\"A.aid\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"1\";s:3:\"sql\";s:103:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'102\'   ORDER BY A.aid DESC LIMIT 1 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"50\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','20','0','default');
INSERT INTO `qb_label` VALUES ('858','','0','0','mvshow','article','1','a:31:{s:13:\"tplpart_1code\";s:144:\"(mv,400,300,false)$mvurl(/mv)<div style=\"padding:8px 0 10px 0;\"> <A HREF=\"$url\" target=\'_blank\'  style=\"font-size:14px;\"><b>$title</b></a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:3:\"102\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:5:\"A.aid\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"1\";s:3:\"sql\";s:103:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'102\'   ORDER BY A.aid DESC LIMIT 1 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"50\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','22','0','default');
INSERT INTO `qb_label` VALUES ('859','','0','0','mvshow','article','1','a:31:{s:13:\"tplpart_1code\";s:144:\"(mv,400,300,false)$mvurl(/mv)<div style=\"padding:8px 0 10px 0;\"> <A HREF=\"$url\" target=\'_blank\'  style=\"font-size:14px;\"><b>$title</b></a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:3:\"102\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:5:\"A.aid\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"1\";s:3:\"sql\";s:103:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'102\'   ORDER BY A.aid DESC LIMIT 1 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"50\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','21','0','default');
INSERT INTO `qb_label` VALUES ('644','','0','0','special_car_14','code','0','µA3ָ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','22','0','default');
INSERT INTO `qb_label` VALUES ('645','','0','0','special_car_15','code','0','<li>\r\n                            <div class=\"PA10\">1.4Tʰ<span>26.8</span></div>\r\n                          </li>\r\n                          <li>\r\n                            <div class=\"CALIGN_C2\">1.4Tʰ<span>26.8</span></div>\r\n                          </li>\r\n                          <li>\r\n                            <div class=\"PA10\">1.4Tʰ<span>26.8</span></div>\r\n                          </li>\r\n                          <li>\r\n                            <div class=\"CALIGN_C2\">1.4Tʰ<span>26.8</span></div>\r\n                          </li>\r\n                          <li class=\"CANSHU\">೵Ͳ>></li>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:3:\"207\";s:5:\"div_h\";s:3:\"140\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290153727','11','30','22','0','default');
INSERT INTO `qb_label` VALUES ('646','','0','0','special_car_16','code','0','Ƽָ<span>4</span>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:3:\"118\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290153782','11','30','22','0','default');
INSERT INTO `qb_label` VALUES ('647','','0','0','special_car_17','code','0','<img src=\"http://www_qibosoft_com/news/images/special/car/c5.gif\" /> <img src=\"http://www_qibosoft_com/news/images/special/car/c5.gif\" /> \r\n                        <img src=\"http://www_qibosoft_com/news/images/special/car/c5.gif\" /> <img src=\"http://www_qibosoft_com/news/images/special/car/c5.gif\" /> \r\n                        <img src=\"http://www_qibosoft_com/news/images/special/car/c6.gif\" />','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:3:\"212\";s:5:\"div_h\";s:2:\"34\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300427512','11','30','22','0','default');
INSERT INTO `qb_label` VALUES ('648','','0','0','special_car_18','code','0','΢','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','22','0','default');
INSERT INTO `qb_label` VALUES ('649','','0','0','special_car_19','code','0','ߵеľƷСµA3<br>\r\n                        ܷӮйгߵϿɣ<br>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:3:\"178\";s:5:\"div_h\";s:2:\"48\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290153966','11','30','22','0','default');
INSERT INTO `qb_label` VALUES ('650','','0','0','special_car_20','code','0','','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','22','0','default');
INSERT INTO `qb_label` VALUES ('651','','0','0','special_car_21','code','0','1.οµA3<br>\r\n                        <label>\r\n                        <input type=\"radio\" name=\"RadioGroup1\" value=\"ѡ\" />\r\n                        Ʒʱ³</label><br>\r\n                        <label>\r\n                        <input type=\"radio\" name=\"RadioGroup1\" value=\"ѡ\" />\r\n                        һһڳϮ</label><br>\r\n                        <label>\r\n                        <input type=\"radio\" name=\"RadioGroup1\" value=\"ѡ\" />\r\n                        ߶ͬƽ̨ۼ۽ϸ</label><br>\r\n                        <div style=\"margin-top:5px;\">2.Ϊµϵǣ</div>\r\n                        <label>\r\n                        <input type=\"radio\" name=\"RadioGroup1\" value=\"ѡ\" />\r\n                        MINI Cper</label> <label>\r\n                        <input type=\"radio\" name=\"RadioGroup1\" value=\"ѡ\" />\r\n                        ֶC30</label><br>\r\n                        <label>\r\n                        <input type=\"radio\" name=\"RadioGroup1\" value=\"ѡ\" />\r\n                        ߶ GTI</label> <label>\r\n                        <input type=\"radio\" name=\"RadioGroup1\" value=\"ѡ\" />\r\n                        1ϵ</label><br>\r\n                        <label>\r\n                        <input type=\"radio\" name=\"RadioGroup1\" value=\"ѡ\" />\r\n                        B</label><br />\r\n                        <div style=\"margin:7px;\"> \r\n                          <input type=\"button\" value=\"ύ\" />\r\n                          <input type=\"button\" value=\"鿴\" />\r\n                        </div>\r\n                      ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:3:\"210\";s:5:\"div_h\";s:3:\"197\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290154073','11','30','22','0','default');
INSERT INTO `qb_label` VALUES ('652','','0','0','special_car_22','code','0','ѻ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','22','0','default');
INSERT INTO `qb_label` VALUES ('856','','0','0','mvshow','article','1','a:31:{s:13:\"tplpart_1code\";s:149:\"(mv,400,300,false)$mvurl(/mv)<div style=\"padding:8px 0 10px 0;\">&nbsp;<A HREF=\"$url\" target=\'_blank\'  style=\"font-size:14px;\"><b>$title</b></a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:3:\"102\";s:7:\"tplpath\";s:30:\"/common_title/1title_noico.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:5:\"A.aid\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"1\";s:3:\"sql\";s:103:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'102\'   ORDER BY A.aid DESC LIMIT 1 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"46\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1240201322','11','30','24','0','default');
INSERT INTO `qb_label` VALUES ('857','','0','0','mvshow','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:144:\"(mv,400,300,false)$mvurl(/mv)<div style=\"padding:8px 0 10px 0;\"> <A HREF=\"$url\" target=\'_blank\'  style=\"font-size:14px;\"><b>$title</b></a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:24:\"/common_title/0title.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"1\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 1 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"50\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300428507','11','30','23','0','default');
INSERT INTO `qb_label` VALUES ('855','','0','0','list_page_mv','article','1','a:31:{s:13:\"tplpart_1code\";s:195:\"(mv,290,210,false)$mvurl(/mv)\r\n<div style=\"line-height:170%;text-align:center;padding-top:8px;\"><A HREF=\"$url\" target=\'_blank\'  style=\"$fontcolor;$fontweight\" title=\'$full_title\'>$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:3:\"102\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:5:\"A.aid\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:103:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'102\'   ORDER BY A.aid DESC LIMIT 5 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','1','0','default');
INSERT INTO `qb_label` VALUES ('656','','0','0','special_car_26','code','0','µA3ʵͼ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','22','0','default');
INSERT INTO `qb_label` VALUES ('657','','0','0','special_car_27','code','0','µ۳͵ģ֣','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','22','0','default');
INSERT INTO `qb_label` VALUES ('658','','0','0','special_car_28','code','0','','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','22','0','default');
INSERT INTO `qb_label` VALUES ('660','','0','0','special_car_30','code','0','г','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','22','0','default');
INSERT INTO `qb_label` VALUES ('661','','0','0','special_car_31','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101119161159_20k4y.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"240\";s:6:\"height\";s:3:\"130\";}','a:3:{s:5:\"div_w\";s:3:\"240\";s:5:\"div_h\";s:3:\"127\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290154756','11','30','22','0','default');
INSERT INTO `qb_label` VALUES ('854','','0','0','c02d','article','1','a:31:{s:13:\"tplpart_1code\";s:476:\"<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"margin:3px 0px 12px 0px;\">\r\n  <tr> \r\n    <td rowspan=\"2\" width=\"4%\" style=\"padding-right:3px;\"><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" width=\"100\" height=\"75\" border=\"0\"></a></td>\r\n    <td width=\"96%\"> <a href=\"$url\" target=\"_blank\" style=\"color:#666;font-weight:bold;\">$title</a></td>\r\n  </tr>\r\n  <tr> \r\n    <td width=\"96%\" style=\"color:#929292;text-indent:1em;\">$content</td>\r\n  </tr>\r\n</table>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"200\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:33:\"/common_pic/title_pic_content.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";s:2:\"34\";s:5:\"stype\";s:2:\"cp\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:5:\"A.aid\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:211:\" SELECT A.*,A.aid AS id,R.content FROM qb_article A LEFT JOIN qb_reply R ON A.aid=R.aid   WHERE A.yz=1  AND A.fid IN (34)  AND A.mid=\'0\'  AND A.ispic=1   AND A.ispic=1  AND R.topic=1 ORDER BY A.aid DESC LIMIT 4 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"58\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"18\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"230\";s:5:\"div_h\";s:3:\"238\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1240060985','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('663','','0','0','special_finance_1','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101122151143_g4zey.jpg\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"960\";s:6:\"height\";s:3:\"150\";}','a:3:{s:5:\"div_w\";s:3:\"958\";s:5:\"div_h\";s:3:\"149\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290409679','11','30','21','0','default');
INSERT INTO `qb_label` VALUES ('664','','0','0','special_finance_2','rollpic','0','a:6:{s:8:\"rolltype\";s:1:\"0\";s:5:\"width\";s:3:\"298\";s:6:\"height\";s:3:\"261\";s:6:\"picurl\";a:2:{i:1;s:32:\"label/1_20101122151110_kzqtx.jpg\";i:2;s:32:\"label/1_20101122151126_jorrb.jpg\";}s:7:\"piclink\";a:2:{i:1;s:1:\"#\";i:2;s:1:\"#\";}s:6:\"picalt\";a:2:{i:1;s:0:\"\";i:2;s:0:\"\";}}','a:3:{s:5:\"div_w\";s:3:\"294\";s:5:\"div_h\";s:3:\"257\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290411221','11','30','21','0','default');
INSERT INTO `qb_label` VALUES ('852','','0','0','1236087504','article','1','a:28:{s:3:\"SYS\";s:7:\"artcile\";s:11:\"roll_height\";s:2:\"50\";s:3:\"url\";N;s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"200\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"amodule\";s:2:\"-1\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";s:1:\"0\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:7:\"default\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:54:\" SELECT A.* FROM qb_article A  WHERE A.yz=1   LIMIT 5 \";s:4:\"sql2\";s:0:\"\";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:0:\"\";s:8:\"titlenum\";s:2:\"20\";s:9:\"titlenum2\";s:0:\"\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','1','');
INSERT INTO `qb_label` VALUES ('853','tretre','0','0','1236087539','article','1','a:28:{s:3:\"SYS\";s:7:\"artcile\";s:11:\"roll_height\";s:2:\"50\";s:3:\"url\";N;s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"200\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"amodule\";s:2:\"-1\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";s:1:\"0\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:7:\"default\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:54:\" SELECT A.* FROM qb_article A  WHERE A.yz=1   LIMIT 5 \";s:4:\"sql2\";s:0:\"\";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:0:\"\";s:8:\"titlenum\";s:2:\"20\";s:9:\"titlenum2\";s:0:\"\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','1','');
INSERT INTO `qb_label` VALUES ('851','','0','0','mainnews2','article','1','a:31:{s:13:\"tplpart_1code\";s:397:\"<div style=\"clear:both;padding-top:2px;margin-bottom:4px;\"><span style=\"float:left;font-size:13px;color:#ccc;\"><A HREF=\"$list_url\" style=\"font-size:13px;\">{$fname}</A>| <A HREF=\"$url\" target=\'_blank\' style=\"$fontcolor;font-size:13px;\">$title</a>$new$hot</span>                     \r\n    <span style=\"float:right;color:#993300;padding-right:3px;font-size:13px;\">[{$time_m}-{$time_d}]</span></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"200\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:28:\"/common_fname/time_fname.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";s:2:\"32\";s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:10:\"A.posttime\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:1:\"1\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:141:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.levels=1  AND A.fid IN (32)  AND A.mid=\'0\'   ORDER BY A.posttime DESC LIMIT 5 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"48\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"467\";s:5:\"div_h\";s:3:\"126\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1240280500','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('850','','0','0','mainnews','article','1','a:31:{s:13:\"tplpart_1code\";s:630:\"<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"margin-bottom:8px;\">\r\n  <tr>\r\n    <td align=\"center\" style=\"padding-bottom:5px;\"><a href=\"$url\" target=\"_blank\"><b><font color=\"#D50000\" style=\"font-size:16px;\">$title</font></b></a></td>\r\n  </tr>\r\n  <tr>\r\n    <td align=\"left\" height=\"18\" valign=\"middle\" style=\"border-bottom:1px dotted #ccc;line-height:150%;text-indent:2em;color:#929292;padding-bottom:3px;\">{$content} <font color=\"#D50000\">{$hits}</font>˹ע  <font color=\"#D50000\">{$comments}</font> \r\n      [<a href=\"$url\" style=\"color:#D50000;\" target=\"_blank\"></a>]</td>\r\n  </tr>\r\n</table>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"200\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"amodule\";s:2:\"-1\";s:7:\"tplpath\";s:24:\"/common_title/0title.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";s:2:\"31\";s:5:\"stype\";s:1:\"c\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:5:\"A.aid\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"1\";s:3:\"sql\";s:166:\" SELECT A.*,A.aid AS id,R.content FROM qb_article A LEFT JOIN qb_reply R ON A.aid=R.aid   WHERE A.yz=1  AND A.fid IN (31)   AND R.topic=1 ORDER BY A.aid DESC LIMIT 1 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:3:\"120\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"60\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"461\";s:5:\"div_h\";s:2:\"71\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1240195933','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('849','','0','0','c1','article','1','a:31:{s:13:\"tplpart_1code\";s:254:\"<div style=\"line-height:130%;font-size:13px;color:#ccc;clear:both;\"><span style=\"float:left;\"><A HREF=\"$url\" target=\'_blank\' style=\"$fontcolor;$fontweight\">$title </a></span><span style=\"float:right;padding-right:3px;color:#666;\">({$hits})</span></div>\";s:13:\"tplpart_2code\";s:302:\"<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"margin-bottom:4px;\">\r\n  <tr>\r\n    <td style=\"font-size:13px;font-weight:bold;\">[Ƽ]<A HREF=\"$url\" target=\"_blank\" style=\"font-size:15px;font-weight:bold;color:#990000;text-decoration: underline;\">$title</A></td>\r\n  </tr>\r\n</table>\";s:3:\"SYS\";s:7:\"artcile\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"200\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"amodule\";s:3:\"101\";s:7:\"tplpath\";s:32:\"/common_zh_title/zh_bigtitle.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";s:8:\"12,26,27\";s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:10:\"A.posttime\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"7\";s:3:\"sql\";s:133:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.fid IN (12,26,27)  AND A.mid=\'101\'   ORDER BY A.posttime DESC LIMIT 8 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"30\";s:10:\"titleflood\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"226\";s:5:\"div_h\";s:3:\"140\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1240192810','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('670','','0','0','special_finance_8','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101122161156_ehzhv.jpg\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"354\";s:6:\"height\";s:3:\"120\";}','a:3:{s:5:\"div_w\";s:3:\"354\";s:5:\"div_h\";s:3:\"119\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290414265','11','30','21','0','default');
INSERT INTO `qb_label` VALUES ('848','','0','0','show_34','article','1','a:31:{s:13:\"tplpart_1code\";s:809:\"<table  border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"float:left;width:160px;margin-top:15px;\">\r\n  <tr>\r\n    <td align=\"center\"><a href=\"$url\" target=\"_blank\" style=\"border:1px solid #ccc;display:block;width:120px;height:90px;\"><img style=\"border:1px solid #fff;\" src=\'$picurl\' border=0 width=\"120\" height=\"90\"></a></td>\r\n  </tr>\r\n  <tr>\r\n    <td align=\"center\" style=\"padding-top:5px;\"><a href=\"$url\" target=\"_blank\">$title</a></td>\r\n  </tr>\r\n  <tr>\r\n    <td align=\"center\" style=\"padding-top:3px;\"><strike><b>$martprice</b></strike> <b><font color=\"#FF0000\">$nowprice</font></b></td>\r\n  </tr>\r\n  <tr>\r\n    <td align=\"center\" style=\"padding-bottom:18px;padding-top:3px;\"><a href=\"$url\" target=\"_blank\"><img src=\"$webdb[www_url]/images/default/order_button.gif\" border=\"0\"></a></td>\r\n  </tr>\r\n</table>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"180\";s:7:\"amodule\";s:3:\"103\";s:7:\"tplpath\";s:17:\"/article/shop.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:5:\"A.aid\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"3\";s:3:\"sql\";s:132:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'103\'  AND A.ispic=1   AND A.ispic=1  ORDER BY A.aid ASC LIMIT 3 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"20\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"450\";s:5:\"div_h\";s:3:\"200\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1241074246','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('847','','0','0','a1','article','1','a:31:{s:13:\"tplpart_1code\";s:147:\"<div style=\"padding-top:6px;color:#ccc;\"><A HREF=\"$url\" target=\'_blank\' style=\"$fontcolor;$fontweight;font-size:13px;\">$title</a> $new $hot</div>\";s:13:\"tplpart_2code\";s:558:\"<table width=\"98%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"margin:3px 0px 5px 0px;\">\r\n  <tr> \r\n    <td rowspan=\"2\" width=\"4%\" style=\"padding-right:3px;padding-bottom:7px;border-bottom:1px dotted #ccc;\"><a href=\"$url\"><img src=\"$picurl\" width=\"100\" height=\"70\" border=\"0\"></a></td>\r\n    <td width=\"96%\"> <a href=\"$url\" target=\"_blank\" style=\"color:#666;font-weight:bold;\">$title</a></td>\r\n  </tr>\r\n  <tr> \r\n    <td width=\"96%\" style=\"padding-bottom:7px;text-indent:1em;border-bottom:1px dotted #ccc;color:#929292;\">$content</td>\r\n  </tr>\r\n</table>\r\n\";s:3:\"SYS\";s:7:\"artcile\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"200\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"amodule\";s:2:\"-1\";s:7:\"tplpath\";s:24:\"/common_zh_pic/zh_pc.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";s:2:\"39\";s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:10:\"A.posttime\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:171:\" SELECT A.*,A.aid AS id,R.content FROM qb_article A LEFT JOIN qb_reply R ON A.aid=R.aid   WHERE A.yz=1  AND A.fid IN (39)   AND R.topic=1 ORDER BY A.posttime DESC LIMIT 6 \";s:4:\"sql2\";s:183:\" SELECT A.*,A.aid AS id,R.content FROM qb_article A LEFT JOIN qb_reply R ON A.aid=R.aid  WHERE A.yz=1  AND A.fid IN (39)  AND A.ispic=1 AND R.topic=1 ORDER BY A.posttime DESC LIMIT 1 \";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:2:\"60\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"20\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"221\";s:5:\"div_h\";s:3:\"186\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1240192058','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('674','','0','0','special_finance_12','code','0','','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','21','0','default');
INSERT INTO `qb_label` VALUES ('675','','0','0','special_finance_19','code','0','Ҫ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','21','0','default');
INSERT INTO `qb_label` VALUES ('676','','0','0','special_finance_20','code','0','ر','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','21','0','default');
INSERT INTO `qb_label` VALUES ('677','','0','0','special_finance_21','code','0','±','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','21','0','default');
INSERT INTO `qb_label` VALUES ('678','','0','0','special_finance_22','code','0','׷ٱ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','21','0','default');
INSERT INTO `qb_label` VALUES ('679','','0','0','special_finance_23','code','0','Ĵ¼','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','21','0','default');
INSERT INTO `qb_label` VALUES ('680','','0','0','special_finance_24','code','0','Ԫ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','21','0','default');
INSERT INTO `qb_label` VALUES ('681','','0','0','special_finance_25','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101122161134_anvod.jpg\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"211\";s:6:\"height\";s:3:\"133\";}','a:3:{s:5:\"div_w\";s:3:\"213\";s:5:\"div_h\";s:3:\"129\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290414346','11','30','21','0','default');
INSERT INTO `qb_label` VALUES ('682','','0','0','special_finance_28','code','0','admin@qibosoft.com','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','21','0','default');
INSERT INTO `qb_label` VALUES ('683','','0','0','special_sp1_1','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101122161145_th99u.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"950\";s:6:\"height\";s:3:\"150\";}','a:3:{s:5:\"div_w\";s:3:\"948\";s:5:\"div_h\";s:3:\"149\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290416100','11','30','20','0','default');
INSERT INTO `qb_label` VALUES ('684','','0','0','special_sp1_2','rollpic','0','a:6:{s:8:\"rolltype\";s:1:\"0\";s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"220\";s:6:\"picurl\";a:2:{i:1;s:32:\"label/1_20101122161104_gaaxz.jpg\";i:2;s:32:\"label/1_20101122161110_yoshc.jpg\";}s:7:\"piclink\";a:2:{i:1;s:1:\"#\";i:2;s:1:\"#\";}s:6:\"picalt\";a:2:{i:1;s:0:\"\";i:2;s:0:\"\";}}','a:3:{s:5:\"div_w\";s:3:\"147\";s:5:\"div_h\";s:3:\"219\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290416339','11','30','20','0','default');
INSERT INTO `qb_label` VALUES ('685','','0','0','special_sp1_3','swf','0','a:3:{s:8:\"flashurl\";s:58:\"http://player.youku.com/player.php/sid/XMjIxMTM5MTMy/v.swf\";s:5:\"width\";s:3:\"301\";s:6:\"height\";s:3:\"261\";}','a:3:{s:5:\"div_w\";s:3:\"164\";s:5:\"div_h\";s:3:\"268\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290416435','11','30','20','0','default');
INSERT INTO `qb_label` VALUES ('686','','0','0','special_sp1_4','code','0','<table width=\"95%\" border=\"0\" align=\"center\" cellpadding=\"0\" cellspacing=\"0\" style=\"line-height:23px;\">\r\n					  <tr>\r\n						\r\n                      <td width=\"39%\"><img src=\"http://i1.sinaimg.cn/dy/2010/0512/S11612T1273624471182.jpg\" width=82 height=98/></td>\r\n					    <td width=\"61%\">\r\n							<div class=\"Cor3\"><a href=\"#\">Ӳ</a></div>\r\n							<div class=\"TEXT\">᣺ΪῨ÷ѭ켣˽Сѧٹѧţѧ\r\n</div>\r\n						</td>\r\n					  </tr>\r\n				  </table>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:3:\"237\";s:5:\"div_h\";s:3:\"106\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290416780','11','30','20','0','default');
INSERT INTO `qb_label` VALUES ('687','','0','0','special_sp1_5','code','0','<div class=\"TANGBIAOT\">\r\n					   <a href=\"#\" style=\"font-weight:bold;\">̳ǣ</a>\r\n					 <a href=\"#\">2005꿨÷ڼ˿õ£ԳɫĿ£ԳɫĿ£Գɫĳɹѡ£Գɫ£Գɫĵصס</a></div>\r\n					<div class=\"TANGBIAOT\">\r\n					  <a href=\"#\" style=\"font-weight:bold;\"></a>\r\n				  <a href=\"#\">÷ԡĿںŴѡڹ쵼⻼֮£뿴ɾǡ</a> </div>\r\n					<div class=\"TANGBIAOT\">\r\n					  <a href=\"#\" style=\"font-weight:bold;\">⣺</a>\r\n				  <a href=\"#\">÷׳ƽؽڶεΣʵĿؽڶεΣʵȻд۲졣</a></div>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:3:\"248\";s:5:\"div_h\";s:3:\"232\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290416775','11','30','20','0','default');
INSERT INTO `qb_label` VALUES ('846','','0','0','comarticle','article','1','a:31:{s:13:\"tplpart_1code\";s:1110:\"<table width=\"98%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"margin-bottom:6px;\">\r\n  <tr> \r\n    <td align=\"left\" style=\"border-bottom:1px dotted #eee;padding-bottom:5px;\"> \r\n      <div style=\"background:url($webdb[www_url]/images/default/sdigg.gif) no-repeat;width:44px;height:36px;float:left;\">\r\n        <div style=\"font-size:13px;text-align:center;padding:0px;font-weight:bold;background:#eee;\" id=\"DiggNum_$id\">$digg_num</div>\r\n        <div style=\"text-align:center;font-size:12px;color:#FFF;width:44px;height:20px;overflow:hidden;background:#ccc;\" id=\"DiggDo_$id\"><a href=\"$webdb[www_url]/do/job.php?job=digg&type=vote&id=$id\" target=\"DiggIframe_$id\" style=\"font-size:12px;color:#FFF;\">һ</a></div>\r\n      </div>\r\n      <div style=\"margin-left:4px;float:left;width:195px;\"> \r\n        <a href=\"$url\" target=\"_blank\" style=\"$fontcolor;$fontweight;font-size:13px;\">$title</a>\r\n      </div>\r\n      <div style=\"display:none;\"><iframe src=\"$webdb[www_url]/do/job.php?job=digg&type=getnum&id=$id\" width=0 height=0 name=\"DiggIframe_$id\" id=\"DiggIframe_$id\"></iframe></div>\r\n    </td>\r\n  </tr>\r\n</table>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"200\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:22:\"/article/title_dig.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:10:\"A.digg_num\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:106:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'0\'   ORDER BY A.digg_num DESC LIMIT 5 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"60\";s:12:\"content_num2\";s:2:\"55\";s:8:\"titlenum\";s:2:\"60\";s:9:\"titlenum2\";s:2:\"26\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"246\";s:5:\"div_h\";s:3:\"243\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1239193510','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('845','','0','0','c2','article','1','a:31:{s:13:\"tplpart_1code\";s:147:\"<div style=\"padding-top:5px;color:#ccc;\"><A HREF=\"$url\" target=\'_blank\' style=\"$fontcolor;$fontweight;font-size:13px;\">$title</a> $new $hot</div>\";s:13:\"tplpart_2code\";s:411:\"<table width=\"98%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"margin-bottom:5px;\">\r\n  <tr>\r\n    <td align=\"left\"><a href=\"$url\" target=\"_blank\" style=\"font-weight:bold;color:#666;\" title=\"$full_title\">$title</a></td>\r\n  </tr>\r\n  <tr>\r\n    <td align=\"left\" height=\"18\" valign=\"middle\" style=\"border-bottom:1px dotted #ccc;text-indent:2em;padding-bottom:5px;color:#929292;\">$content</td>\r\n  </tr>\r\n</table>\";s:3:\"SYS\";s:7:\"artcile\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"200\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:33:\"/common_zh_content/zh_content.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";s:5:\"35,38\";s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:10:\"A.posttime\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:189:\" SELECT A.*,A.aid AS id,R.content FROM qb_article A LEFT JOIN qb_reply R ON A.aid=R.aid   WHERE A.yz=1  AND A.fid IN (35,38)  AND A.mid=\'0\'   AND R.topic=1 ORDER BY A.posttime DESC LIMIT 6 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:2:\"68\";s:8:\"titlenum\";s:2:\"28\";s:9:\"titlenum2\";s:2:\"34\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"222\";s:5:\"div_h\";s:3:\"159\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1240192238','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('844','','0','0','listpic5','article','1','a:29:{s:13:\"tplpart_1code\";s:322:\"<div  class=\"listpic\" style=\"padding:5px 9px 3px 17px;\"> \r\n              <p class=img><a href=\"$url\" target=\"_blank\"><img width=\"120\" height=\"90\" src=\"$picurl\" border=\"0\"></a></p>\r\n              <p class=title style=\'text-align:center;\'><A HREF=\"$url\" title=\'$full_title\' target=\"_blank\">$title</A></p>\r\n            </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"200\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:3:\"104\";s:7:\"tplpath\";s:24:\"/common_pic/img_div1.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:5:\"A.aid\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:133:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'104\'  AND A.ispic=1   AND A.ispic=1  ORDER BY A.aid DESC LIMIT 6 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"20\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1239006692','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('843','','0','0','listpic4','article','1','a:29:{s:13:\"tplpart_1code\";s:322:\"<div  class=\"listpic\" style=\"padding:5px 9px 3px 17px;\"> \r\n              <p class=img><a href=\"$url\" target=\"_blank\"><img width=\"120\" height=\"90\" src=\"$picurl\" border=\"0\"></a></p>\r\n              <p class=title style=\'text-align:center;\'><A HREF=\"$url\" title=\'$full_title\' target=\"_blank\">$title</A></p>\r\n            </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"200\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:3:\"103\";s:7:\"tplpath\";s:24:\"/common_pic/img_div1.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:5:\"A.aid\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:133:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'103\'  AND A.ispic=1   AND A.ispic=1  ORDER BY A.aid DESC LIMIT 6 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"20\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1239006655','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('842','','0','0','listpic','article','1','a:31:{s:13:\"tplpart_1code\";s:322:\"<div  class=\"listpic\" style=\"padding:7px 9px 3px 17px;\"> \r\n              <p class=img><a href=\"$url\" target=\"_blank\"><img width=\"120\" height=\"90\" src=\"$picurl\" border=\"0\"></a></p>\r\n              <p class=title style=\'text-align:center;\'><A HREF=\"$url\" title=\'$full_title\' target=\"_blank\">$title</A></p>\r\n            </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"200\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:24:\"/common_pic/img_div1.jpg\";s:6:\"DivTpl\";i:0;s:5:\"fiddb\";s:2:\"33\";s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:1:\"1\";s:7:\"rowspan\";s:1:\"2\";s:3:\"sql\";s:167:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.levels=1  AND A.fid IN (33)  AND A.mid=\'0\'  AND A.ispic=1   AND A.ispic=1  ORDER BY A.list DESC LIMIT 6 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"3\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"20\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"459\";s:5:\"div_h\";s:3:\"254\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1241074794','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('841','','0','0','hotarticle','article','1','a:31:{s:13:\"tplpart_1code\";s:212:\"<div style=\"background:url($webdb[www_url]/images/default/i/$i.gif) no-repeat 0px 2px;height:23px;text-indent:1.3em;\"><A HREF=\"$url\" target=\'_blank\' style=\"$fontcolor;$fontweight;font-size:13px;\">$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"200\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"amodule\";s:1:\"0\";s:7:\"tplpath\";s:27:\"/common_title/2title_i2.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:3:\"all\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.hits\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"9\";s:3:\"sql\";s:97:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE 1  AND A.mid=\'0\'   ORDER BY A.hits DESC LIMIT 9 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"228\";s:5:\"div_h\";s:3:\"204\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1239609179','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('695','','0','0','special_sp1_16','code','0',' ӦԺ¼ұ룬е߼ά÷׽11910նйʽʡ ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:3:\"330\";s:5:\"div_h\";s:2:\"43\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1290476395','11','30','20','0','default');
INSERT INTO `qb_label` VALUES ('840','','0','0','listpic3','article','1','a:29:{s:13:\"tplpart_1code\";s:322:\"<div  class=\"listpic\" style=\"padding:5px 9px 3px 17px;\"> \r\n              <p class=img><a href=\"$url\" target=\"_blank\"><img width=\"120\" height=\"90\" src=\"$picurl\" border=\"0\"></a></p>\r\n              <p class=title style=\'text-align:center;\'><A HREF=\"$url\" title=\'$full_title\' target=\"_blank\">$title</A></p>\r\n            </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"artcile\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"200\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";s:3:\"102\";s:7:\"tplpath\";s:24:\"/common_pic/img_div1.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:5:\"A.aid\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:133:\" SELECT A.*,A.aid AS id FROM qb_article A  WHERE A.yz=1  AND A.mid=\'102\'  AND A.ispic=1   AND A.ispic=1  ORDER BY A.aid DESC LIMIT 6 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"20\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1239006730','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('698','','0','0','special_sp1_19','code','0','ûг','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','20','0','default');
INSERT INTO `qb_label` VALUES ('699','','0','0','special_sp1_20','code','0','۽Ӣ࿨÷','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','20','0','default');
INSERT INTO `qb_label` VALUES ('700','','0','0','special_sp1_21','code','0','ͼƬ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','20','0','default');
INSERT INTO `qb_label` VALUES ('701','','0','0','special_sp1_22','code','0','ͼı','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','20','0','default');
INSERT INTO `qb_label` VALUES ('702','','0','0','special_sp1_23','code','0','ʱ׷','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','20','0','default');
INSERT INTO `qb_label` VALUES ('703','','0','0','special_sp1_24','code','0','','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','20','0','default');
INSERT INTO `qb_label` VALUES ('704','','0','0','special_sp1_25','code','0','Ϣ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','20','0','default');
INSERT INTO `qb_label` VALUES ('705','','0','0','special_sp1_26','code','0','༭Ƽ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','11','30','20','0','default');
INSERT INTO `qb_label` VALUES ('706','','0','0','hy_1','rollpic','0','a:6:{s:8:\"rolltype\";s:1:\"0\";s:5:\"width\";s:3:\"470\";s:6:\"height\";s:3:\"185\";s:6:\"picurl\";a:2:{i:1;s:32:\"label/1_20101205111206_kttht.jpg\";i:2;s:32:\"label/1_20101205111212_fjnu8.jpg\";}s:7:\"piclink\";a:2:{i:1;s:1:\"#\";i:2;s:1:\"#\";}s:6:\"picalt\";a:2:{i:1;s:0:\"\";i:2;s:0:\"\";}}','a:3:{s:5:\"div_w\";s:3:\"467\";s:5:\"div_h\";s:3:\"185\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1291518928','0','16','0','0','default');
INSERT INTO `qb_label` VALUES ('707','','0','0','hy_2','Info_hy_','1','a:28:{s:13:\"tplpart_1code\";s:91:\"<div class=\"list\"><a href=\"$webdb[www_url]/home/?uid=$uid\" target=\"_blank\">$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"company\";s:7:\"typefid\";N;s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:11:\"content_num\";s:2:\"80\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:8:\"moduleid\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:8:\"renzheng\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:3:\"rid\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:64:\"SELECT * FROM qb_hy_company  WHERE 1  ORDER BY rid DESC LIMIT 6 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"30\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"240\";s:5:\"div_h\";s:3:\"139\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1291709105','0','16','0','0','default');
INSERT INTO `qb_label` VALUES ('708','','0','0','hy_3','Info_hy_','1','a:28:{s:13:\"tplpart_1code\";s:93:\"<div class=\"list\"><a href=\"$webdb[www_url]/home/?uid=$uid\" target=\"_blank\">$title</a>\r\n</div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"company\";s:7:\"typefid\";N;s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:11:\"content_num\";s:2:\"80\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:8:\"moduleid\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:8:\"renzheng\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:3:\"rid\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"18\";s:3:\"sql\";s:65:\"SELECT * FROM qb_hy_company  WHERE 1  ORDER BY rid DESC LIMIT 18 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"30\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"720\";s:5:\"div_h\";s:3:\"141\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1291709113','0','16','0','0','default');
INSERT INTO `qb_label` VALUES ('709','','0','0','hy_4','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101205111241_4shk3.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"730\";s:6:\"height\";s:2:\"70\";}','a:3:{s:5:\"div_w\";s:3:\"732\";s:5:\"div_h\";s:2:\"70\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1291519747','0','16','0','0','default');
INSERT INTO `qb_label` VALUES ('710','','0','0','hy_5','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101205111239_s46xf.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:2:\"70\";}','a:3:{s:5:\"div_w\";s:3:\"249\";s:5:\"div_h\";s:2:\"69\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1291519795','0','16','0','0','default');
INSERT INTO `qb_label` VALUES ('711','','0','0','hy_6','Info_hy_','1','a:28:{s:13:\"tplpart_1code\";s:99:\"	<div class=\"listmun$i\"><a href=\"$webdb[www_url]/home/?uid=$uid\" target=\"_blank\">$title</a>\r\n</div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"company\";s:7:\"typefid\";N;s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:11:\"content_num\";s:2:\"80\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:8:\"moduleid\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:8:\"renzheng\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:3:\"rid\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:65:\"SELECT * FROM qb_hy_company  WHERE 1  ORDER BY rid DESC LIMIT 10 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"30\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"236\";s:5:\"div_h\";s:3:\"250\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1291709135','0','16','0','0','default');
INSERT INTO `qb_label` VALUES ('712','','0','0','hy_7','Info_hy_','1','a:28:{s:13:\"tplpart_1code\";s:99:\"	<div class=\"listmun$i\"><a href=\"$webdb[www_url]/home/?uid=$uid\" target=\"_blank\">$title</a>\r\n</div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"company\";s:7:\"typefid\";N;s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:11:\"content_num\";s:2:\"80\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:8:\"moduleid\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:8:\"renzheng\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:3:\"rid\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:65:\"SELECT * FROM qb_hy_company  WHERE 1  ORDER BY rid DESC LIMIT 10 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"30\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"241\";s:5:\"div_h\";s:3:\"249\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1291709124','0','16','0','0','default');
INSERT INTO `qb_label` VALUES ('713','','0','0','hy_10','Info_hy_','1','a:28:{s:13:\"tplpart_1code\";s:330:\"<div class=\"list$i\">\r\n                	<a href=\"$webdb[www_url]/home/?uid=$uid\" target=\"_blank\" class=\"img\"><img src=\"$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" width=\"100\" height=\"35\" /></a>\r\n                <a href=\"$webdb[www_url]/home/?uid=$uid\" target=\"_blank\">$title</a>\r\n\r\n                </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:7:\"company\";s:7:\"typefid\";N;s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:11:\"content_num\";s:2:\"80\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:8:\"moduleid\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:3:\"all\";s:8:\"renzheng\";s:3:\"all\";s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:3:\"rid\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:64:\"SELECT * FROM qb_hy_company  WHERE 1  ORDER BY rid DESC LIMIT 4 \";s:7:\"colspan\";s:1:\"1\";s:8:\"titlenum\";s:2:\"18\";s:10:\"titleflood\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"244\";s:5:\"div_h\";s:3:\"141\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1291709129','0','16','0','0','default');
INSERT INTO `qb_label` VALUES ('714','','0','0','hy_a5','code','0','<a href=\"#\" target=\"_blank\">...</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','16','0','0','default');
INSERT INTO `qb_label` VALUES ('715','','0','0','hy_a3','code','0','<a href=\"#\" target=\"_blank\">...</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','16','0','0','default');
INSERT INTO `qb_label` VALUES ('716','','0','0','hy_a2','code','0','<a href=\"#\" target=\"_blank\">...</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','16','0','0','default');
INSERT INTO `qb_label` VALUES ('717','','0','0','hy_a1','code','0','<a href=\"#\" target=\"_blank\">...</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','16','0','0','default');
INSERT INTO `qb_label` VALUES ('718','','0','0','hy_a4','code','0','<a href=\"#\" target=\"_blank\">...</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','16','0','0','default');
INSERT INTO `qb_label` VALUES ('719','','0','0','hy_b4','code','0','¼','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','16','0','0','default');
INSERT INTO `qb_label` VALUES ('720','','0','0','hy_b3','code','0','½ҵ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','16','0','0','default');
INSERT INTO `qb_label` VALUES ('721','','0','0','hy_b1','code','0','Ƽҵ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:2:\"78\";s:5:\"div_h\";s:2:\"32\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1291520936','0','16','0','0','default');
INSERT INTO `qb_label` VALUES ('722','','0','0','hy_b7','code','0','Ź˾','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','16','0','0','default');
INSERT INTO `qb_label` VALUES ('723','','0','0','hy_c1','code','0','	<div class=\"h\"><a href=\"#\" target=\"_blank\">ΪʲôҪƻԱ?</a></div>\r\n                    <div class=\"l\">| <a href=\"#\" target=\"_blank\">ƻԱͨ</a></div>\r\n                    <div class=\"l\">| <a href=\"#\" target=\"_blank\">뿪ͨƻԱ</a></div>\r\n                    <div class=\"l\">| <a href=\"#\" target=\"_blank\">ƻԱ</a></div>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:3:\"239\";s:5:\"div_h\";s:2:\"97\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1291520874','0','16','0','0','default');
INSERT INTO `qb_label` VALUES ('724','','0','0','hy_c2','code','0','<a href=\"#\" target=\"_blank\">ôΪ?</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:2:\"81\";s:5:\"div_h\";s:2:\"34\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1291520901','0','16','0','0','default');
INSERT INTO `qb_label` VALUES ('725','','0','0','hy_c3','code','0','˾','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:2:\"82\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1291520931','0','16','0','0','default');
INSERT INTO `qb_label` VALUES ('726','','0','0','index_t22','code','0','<br><br>ʾ,<br><br><br><br>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('727','','0','0','index_t23','code','0','<br><br>2 ʾ,<br><br><br><br>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('728','','0','0','index_t24','code','0','<br><br>33ʾ,<br><br><br><br>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('729','','0','0','index_t25','code','0','<br><br>44ʾ,<br><br><br><br>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('730','','0','0','index_j32','code','0','dd<br><br>ʾ,<br><br><br><br>dd','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1293084023','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('731','','0','0','index_j33','code','0','<br><br>ʾ,<br><br><br><br>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('732','','0','0','index_j34','code','0','d<br><br>ʾ,<br><br><br><br>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('733','','0','0','index_tr12','code','0','1<br><br>ʾ,<br><br><br><br>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('734','','0','0','index_tr13','code','0','2<br><br>ʾ,<br><br><br><br>2','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('735','','0','0','index_tr14','code','0','3<br><br>ʾ,<br><br><br><br>3','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('736','','0','0','index_tr15','code','0','4<br><br>ʾ,<br><br><br><br>6','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('737','','0','0','index_trrr1','code','0','<span id=\"Span6\" onmouseover=\"ShowTab(6,6,11)\"></span>\r\n            <span id=\"Span7\" onmouseover=\"ShowTab(7,6,11)\">ͼƬ</span>\r\n            <span id=\"Span8\" onmouseover=\"ShowTab(8,6,11)\">Ӱ</span>\r\n            <span id=\"Span9\" onmouseover=\"ShowTab(9,6,11)\">̳</span>\r\n            <span id=\"Span10\" onmouseover=\"ShowTab(10,6,11)\">flash</span>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('738','','0','0','index_bfj3','code','0','<span id=\"Span11\" onmouseover=\"ShowTab(11,11,15)\">װ</span>\r\n                    <span id=\"Span12\" onmouseover=\"ShowTab(12,11,15)\"></span>\r\n                    <span id=\"Span13\" onmouseover=\"ShowTab(13,11,15)\">ʳƷ</span>\r\n                    <span id=\"Span14\" onmouseover=\"ShowTab(14,11,15)\"></span>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('739','','0','0','index_5t2','code','0','	<span id=\"Span1\" onmouseover=\"ShowTab(1,1,6)\"></span>\r\n            <span id=\"Span2\" onmouseover=\"ShowTab(2,1,6)\">ͼƬ</span>\r\n            <span id=\"Span3\" onmouseover=\"ShowTab(3,1,6)\">Ӱ</span>\r\n            <span id=\"Span4\" onmouseover=\"ShowTab(4,1,6)\">̳</span>\r\n            <span id=\"Span5\" onmouseover=\"ShowTab(5,1,6)\">flash</span>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','default');
INSERT INTO `qb_label` VALUES ('740','','0','0','wn_tp5','code','0','<a href=\"#\">...</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','default');
INSERT INTO `qb_label` VALUES ('741','','0','0','wn_tsf','code','0','<a href=\"#\"></a> | <a href=\"#\">˸</a> | <a href=\"#\"></a> &nbsp;&nbsp; <a href=\"#\">>></a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:3:\"250\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1289308157','0','30','0','0','default');
INSERT INTO `qb_label` VALUES ('742','','0','0','wn_ptg5','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:156:\" <div class=\"list\"><a href=\"$url\" class=\"sort\" target=\"_blank\">[{$fname}]</a><a href=\"$url\" target=\"_blank\">$title</a><span>{$time_m}-{$time_d}</span></div>\";s:13:\"tplpart_2code\";s:682:\"	<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"pic_word\">\r\n                      <tr>\r\n                        \r\n                  <td class=\"pic\"><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" width=\"80\" height=\"60\"/></a></td>\r\n                        <td class=\"word\">\r\n                        	\r\n                    <div class=\"t\"><a href=\"$url\" target=\"_blank\">$title</a></div>\r\n                    		\r\n                    <div class=\"c\">$content<a href=\"$url\" target=\"_blank\">[鿴ȫ]</a></div>\r\n                        </td>\r\n                      </tr>\r\n                    </table>\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"amodule\";N;s:7:\"tplpath\";s:25:\"/common_zh_pic/zh_pic.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:3:\"all\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"7\";s:3:\"sql\";s:152:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid   WHERE 1   AND R.topic=1 ORDER BY A.list ASC LIMIT 8 \";s:4:\"sql2\";s:164:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid  WHERE 1  AND A.ispic=1 AND R.topic=1 ORDER BY A.list ASC LIMIT 1 \";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:2:\"70\";s:8:\"titlenum\";s:2:\"36\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1299723717','0','30','0','0','default');
INSERT INTO `qb_label` VALUES ('743','','0','0','wn_ptg4','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:156:\" <div class=\"list\"><a href=\"$url\" class=\"sort\" target=\"_blank\">[{$fname}]</a><a href=\"$url\" target=\"_blank\">$title</a><span>{$time_m}-{$time_d}</span></div>\";s:13:\"tplpart_2code\";s:682:\"	<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"pic_word\">\r\n                      <tr>\r\n                        \r\n                  <td class=\"pic\"><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" width=\"80\" height=\"60\"/></a></td>\r\n                        <td class=\"word\">\r\n                        	\r\n                    <div class=\"t\"><a href=\"$url\" target=\"_blank\">$title</a></div>\r\n                    		\r\n                    <div class=\"c\">$content<a href=\"$url\" target=\"_blank\">[鿴ȫ]</a></div>\r\n                        </td>\r\n                      </tr>\r\n                    </table>\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"amodule\";N;s:7:\"tplpath\";s:25:\"/common_zh_pic/zh_pic.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:3:\"all\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"7\";s:3:\"sql\";s:153:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid   WHERE 1   AND R.topic=1 ORDER BY A.list DESC LIMIT 8 \";s:4:\"sql2\";s:165:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid  WHERE 1  AND A.ispic=1 AND R.topic=1 ORDER BY A.list DESC LIMIT 1 \";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:2:\"70\";s:8:\"titlenum\";s:2:\"36\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1299723704','0','30','0','0','default');
INSERT INTO `qb_label` VALUES ('744','','0','0','wn_tgh1','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:196:\"<div class=\"listtc\">\r\n                	\r\n              <div class=\"t\"><a href=\"$url\" target=\"_blank\">$title</a></div>\r\n                    <div class=\"c\">$content</div>\r\n                </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"c\";s:2:\"yz\";s:3:\"all\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:153:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid   WHERE 1   AND R.topic=1 ORDER BY A.list DESC LIMIT 6 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"66\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1299723697','0','30','0','0','default');
INSERT INTO `qb_label` VALUES ('745','','0','0','wn_tgh2','pic','0','a:4:{s:6:\"imgurl\";s:32:\"label/1_20101109201135_eoslv.jpg\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"240\";s:6:\"height\";s:2:\"50\";}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','default');
INSERT INTO `qb_label` VALUES ('746','','0','0','wn_tg01','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:235:\"<div class=\"list$i\">\r\n                	\r\n              <div class=\"t\"><a href=\"$url\" target=\"_blank\">$title</a></div>\r\n                    <div class=\"m\">:<span>$hits</span> :<span>$comments</span></div>\r\n                </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"8\";s:3:\"sql\";s:87:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE 1   ORDER BY A.list DESC LIMIT 8 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1299723691','0','30','0','0','default');
INSERT INTO `qb_label` VALUES ('747','','0','0','wn_tg4','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:328:\"<div class=\"listpic\">\r\n                	\r\n              <div class=\"img\"><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" width=\"120\" height=\"90\"/></a></div>\r\n                    <div class=\"t\"><a href=\"$url\" target=\"_blank\">$title</a></div>\r\n                </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:3:\"all\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:117:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE 1  AND A.ispic=1   AND A.ispic=1  ORDER BY A.list DESC LIMIT 5 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1299723709','0','30','0','0','default');
INSERT INTO `qb_label` VALUES ('748','','0','0','wn_tg2','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:83:\"<div class=\"list\"><a href=\"$url\" target=\"_blank\">$title</a><span>09-14</span></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:87:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE 1   ORDER BY A.list DESC LIMIT 6 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"36\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1299723671','0','30','0','0','default');
INSERT INTO `qb_label` VALUES ('749','','0','0','wn_tg3','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:65:\"<div class=\"list\"><a href=\"$url\" target=\"_blank\">$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"12\";s:3:\"sql\";s:87:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE 1   ORDER BY A.list ASC LIMIT 12 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1299723677','0','30','0','0','default');
INSERT INTO `qb_label` VALUES ('750','','0','0','wn_rollpic33','Info_news_','1','a:34:{s:13:\"tplpart_1code\";s:112:\"<div style=\"line-height:180%;\"><A HREF=\"$url\" target=\'_blank\'  style=\"$fontcolor;$fontweight\">$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:10:\"fu_article\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:24:\"/common_title/0title.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";s:1:\"3\";s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:174:\" SELECT A.*,A.aid AS id FROM qb_news_fu_article FA LEFT JOIN qb_news_article A ON FA.aid=A.aid   WHERE A.yz=1  AND FA.fid IN (3)  AND A.mid=\'\'   ORDER BY A.list DESC LIMIT 5 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"20\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','');
INSERT INTO `qb_label` VALUES ('751','','0','0','wn_rollpic','rollpic','0','a:6:{s:8:\"rolltype\";s:1:\"0\";s:5:\"width\";s:3:\"280\";s:6:\"height\";s:3:\"190\";s:6:\"picurl\";a:2:{i:1;s:32:\"label/1_20101109181105_gzaok.jpg\";i:2;s:32:\"label/1_20101109181113_fwdej.jpg\";}s:7:\"piclink\";a:2:{i:1;s:1:\"#\";i:2;s:1:\"#\";}s:6:\"picalt\";a:2:{i:1;s:0:\"\";i:2;s:0:\"\";}}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','default');
INSERT INTO `qb_label` VALUES ('752','','0','0','wn_topic1','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:128:\"<div class=\"list\"><a href=\"$list_url\" class=\"sort\" target=\"_blank\">[{$fname}]</a><a href=\"$url\" target=\"_blank\">$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:3:\"all\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"8\";s:3:\"sql\";s:87:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE 1   ORDER BY A.list DESC LIMIT 8 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1299723684','0','30','0','0','default');
INSERT INTO `qb_label` VALUES ('753','','0','0','wn_tg1','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:262:\"<div class=\"list$i\"> <span class=\"d\">{$time_y}/{$time_m}/{$time_d}</span> <span class=\"t\"><a href=\"$url\" target=\"_blank\">$title</a></span> \r\n                <span class=\"c\">{$content}<a href=\"$url\" target=\"_blank\">[鿴ȫ]</a></span> \r\n              </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:2:\"30\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"c\";s:2:\"yz\";s:3:\"all\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:153:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid   WHERE 1   AND R.topic=1 ORDER BY A.list DESC LIMIT 5 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:3:\"190\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1299723611','0','30','0','0','default');
INSERT INTO `qb_label` VALUES ('754','','0','0','wn_tp3','code','0','<a href=\"#\">...</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','default');
INSERT INTO `qb_label` VALUES ('755','','0','0','wn_tp4','code','0','<a href=\"#\">...</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','default');
INSERT INTO `qb_label` VALUES ('756','','0','0','wn_tp2','code','0','<a href=\"#\">...</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','default');
INSERT INTO `qb_label` VALUES ('757','','0','0','wn_tp1','code','0','<a href=\"#\">...</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','default');
INSERT INTO `qb_label` VALUES ('758','','0','0','wn_g1','code','0','Ż','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','default');
INSERT INTO `qb_label` VALUES ('759','','0','0','wn_g3','code','0','','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','default');
INSERT INTO `qb_label` VALUES ('760','','0','0','wn_g2','code','0','ό','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','default');
INSERT INTO `qb_label` VALUES ('761','','0','0','wn_g4','code','0','չע','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','default');
INSERT INTO `qb_label` VALUES ('762','','0','0','wn_g6','code','0','','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','default');
INSERT INTO `qb_label` VALUES ('763','','0','0','wn_g5','code','0','ͼƬ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','default');
INSERT INTO `qb_label` VALUES ('924','','0','0','special_finance_9','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:429:\"<div class=\"ren_h\">\r\n                <div class=\"at\"><img src=\"$webdb[www_url]/news/images/special/finance/finace_3.jpg\" width=\"15\" height=\"16\" /></div>\r\n                <div class=\"ab\"><a href=\"$url\" target=\"_blank\">$title</a></div>\r\n              </div>\r\n              <div class=\"ren_by\"> \r\n                \r\n  <p>{$content} <a href=\"$url\" target=\"_blank\"><font color=\"#990000\">[]</font></a> \r\n  </p>\r\n              </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:29:\"/common_content/content_1.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"c\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"1\";s:3:\"sql\";s:158:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid   WHERE A.yz=1   AND R.topic=1 ORDER BY A.list DESC LIMIT 1 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:3:\"270\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"553\";s:5:\"div_h\";s:3:\"144\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1301728252','11','30','21','0','blue');
INSERT INTO `qb_label` VALUES ('925','','0','0','special_finance_10','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:165:\"  <div><span style=\"float:left;\"><a href=\"$url\" target=\"_blank\">$title</a></span><span style=\"float:right;\">({$time_m} -{$time_d})</span><br />\r\n            </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"7\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 7 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"44\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"459\";s:5:\"div_h\";s:3:\"320\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300428578','11','30','21','0','default');
INSERT INTO `qb_label` VALUES ('926','','0','0','special_finance_11','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:165:\"  <div><span style=\"float:left;\"><a href=\"$url\" target=\"_blank\">$title</a></span><span style=\"float:right;\">({$time_m} -{$time_d})</span><br />\r\n            </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"7\";s:3:\"sql\";s:91:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list ASC LIMIT 7 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"44\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"371\";s:5:\"div_h\";s:3:\"306\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300428584','11','30','21','0','default');
INSERT INTO `qb_label` VALUES ('927','','0','0','special_sp1_9','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:237:\"<div class=\"photo_list\">    \r\n<a href=\"$url\" target=\"_blank\">\r\n<img width=\"164\" height=\"123\" src=\"$picurl\" border=0 onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" /></a>\r\n\r\n<a href=\"$url\" target=\"_blank\">$title</a>\r\n</div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:122:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1  AND A.ispic=1   AND A.ispic=1  ORDER BY A.list DESC LIMIT 5 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"20\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"904\";s:5:\"div_h\";s:3:\"153\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300428659','11','30','20','0','default');
INSERT INTO `qb_label` VALUES ('928','','0','0','special_sp1_10','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:571:\"<table width=\"96%\" border=\"0\" align=\"center\" cellpadding=\"0\" cellspacing=\"0\" class=\"right_content1\">\r\n					  <tr>\r\n						\r\n                <td width=\"37%\"><a href=\"$url\" target=\"_blank\">\r\n				<img src=\"$picurl\" onerror=\"this.src=\'$webdb[www_url]/images/default/nopic.jpg\'\" border=\"0\" width=\"100\" height=\"68\" /></a></td>\r\n					    \r\n                <td width=\"63%\"><a href=\"$url\" style=\"color:#1F4363;\" target=\"_blank\">$title</a> \r\n                  <div style=\"color:#6A6A6A;\">$content  [<a href=\"$url\" target=\"_blank\">ϸ</a>]</div></td>\r\n					  </tr>\r\n					 </table>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:33:\"/common_pic/title_pic_content.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:2:\"cp\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"3\";s:3:\"sql\";s:188:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid   WHERE A.yz=1  AND A.ispic=1   AND A.ispic=1  AND R.topic=1 ORDER BY A.list DESC LIMIT 3 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"50\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"310\";s:5:\"div_h\";s:3:\"229\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300428672','11','30','20','0','default');
INSERT INTO `qb_label` VALUES ('929','','0','0','special_sp1_11','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:71:\"<div class=\"Lianjie\"> <a href=\"$url\" target=\"_blank\">$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:93:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 10 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"44\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"351\";s:5:\"div_h\";s:3:\"326\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300428665','11','30','20','0','default');
INSERT INTO `qb_label` VALUES ('930','','0','0','special_sp1_12','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:176:\"<div class=\"Tbiaoti\"><a href=\"$url\" target=\"_blank\">$title</a></div>\r\n		\r\n<div class=\"xwzi\">{$content} <a href=\"$url\" target=\"_blank\" style=\"color:#990000;\">  [] </a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:29:\"/common_content/content_1.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"c\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"3\";s:3:\"sql\";s:157:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid   WHERE A.yz=1   AND R.topic=1 ORDER BY A.list ASC LIMIT 3 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:3:\"100\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"236\";s:5:\"div_h\";s:3:\"232\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300428651','11','30','20','0','default');
INSERT INTO `qb_label` VALUES ('931','','0','0','special_sp1_13','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:72:\" <div class=\"Lianjie\"> <a href=\"$url\" target=\"_blank\">$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"7\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 7 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"46\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"360\";s:5:\"div_h\";s:3:\"190\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300428644','11','30','20','0','default');
INSERT INTO `qb_label` VALUES ('932','','0','0','special_sp1_14','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:72:\" <div class=\"Lianjie\"> <a href=\"$url\" target=\"_blank\">$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:91:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list ASC LIMIT 6 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"44\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"359\";s:5:\"div_h\";s:3:\"162\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300428629','11','30','20','0','default');
INSERT INTO `qb_label` VALUES ('933','','0','0','special_sp1_15','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:72:\"<div class=\"BJ_ljie\"> <a href=\"$url\" target=\"_blank\">$title</a></div> \";s:13:\"tplpart_2code\";s:73:\"<div class=\"BIAOTI\"><a href=\"$url\" target=\"_blank\">$title</a></div>\r\n				\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:32:\"/common_zh_title/zh_bigtitle.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 5 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"44\";s:9:\"titlenum2\";s:2:\"32\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"354\";s:5:\"div_h\";s:3:\"196\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300428623','11','30','20','0','default');
INSERT INTO `qb_label` VALUES ('934','','0','0','special_sp1_17','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:102:\"<a href=\"$url\" target=\"blank\" class=\"t\" style=\"color:#013979;\">$title</a> \r\n						<div>$content </div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:29:\"/common_content/content_1.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"c\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"3\";s:3:\"sql\";s:158:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid   WHERE A.yz=1   AND R.topic=1 ORDER BY A.list DESC LIMIT 3 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"60\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"235\";s:5:\"div_h\";s:3:\"186\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300428615','11','30','20','0','default');
INSERT INTO `qb_label` VALUES ('935','','0','0','special_sp1_18','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:72:\"<div class=\"BJ_ljie\"> <a href=\"$url\" target=\"_blank\">$title</a></div> \";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"3\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 3 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:3:\"310\";s:5:\"div_h\";s:3:\"108\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300428637','11','30','20','0','default');
INSERT INTO `qb_label` VALUES ('956','','0','0','blue_newsstc5','Info_photo_','1','a:35:{s:13:\"tplpart_1code\";s:65:\"<div class=\"list\"><A HREF=\"$url\" target=\'_blank\'>$title</a></div>\";s:13:\"tplpart_2code\";s:410:\"<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n  <tr>\r\n    <td class=\"img\"><div><a href=\"$url\" target=\"_blank\" title=\"$full_title\"><img src=\"$picurl\" width=\"100\" /></a></div></td>\r\n    <td class=\"word\">\r\n    	<h3><a href=\"$url\" target=\"_blank\" title=\"$full_title\">$title</a></h3>\r\n    	<p>$content<a href=\"$url\" target=\"_blank\" title=\"$full_title\">[ϸ]</a></p>\r\n    </td>\r\n  </tr>\r\n</table>\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:6:\"photo_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:33:\"/common_zh_content/zh_content.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"2\";s:3:\"sql\";s:160:\" SELECT A.*,A.aid AS id,R.content FROM qb_photo_article A LEFT JOIN qb_photo_reply R ON A.aid=R.aid   WHERE A.yz=1   AND R.topic=1 ORDER BY A.list DESC LIMIT 3 \";s:4:\"sql2\";s:172:\" SELECT A.*,A.aid AS id,R.content FROM qb_photo_article A LEFT JOIN qb_photo_reply R ON A.aid=R.aid  WHERE A.yz=1  AND A.ispic=1 AND R.topic=1 ORDER BY A.list DESC LIMIT 1 \";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:2:\"60\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('957','','0','0','blue_newsstc4','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:65:\"<div class=\"list\"><A HREF=\"$url\" target=\'_blank\'>$title</a></div>\";s:13:\"tplpart_2code\";s:410:\"<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n  <tr>\r\n    <td class=\"img\"><div><a href=\"$url\" target=\"_blank\" title=\"$full_title\"><img src=\"$picurl\" width=\"100\" /></a></div></td>\r\n    <td class=\"word\">\r\n    	<h3><a href=\"$url\" target=\"_blank\" title=\"$full_title\">$title</a></h3>\r\n    	<p>$content<a href=\"$url\" target=\"_blank\" title=\"$full_title\">[ϸ]</a></p>\r\n    </td>\r\n  </tr>\r\n</table>\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:33:\"/common_zh_content/zh_content.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.hits\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"2\";s:3:\"sql\";s:158:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid   WHERE A.yz=1   AND R.topic=1 ORDER BY A.hits DESC LIMIT 3 \";s:4:\"sql2\";s:170:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid  WHERE A.yz=1  AND A.ispic=1 AND R.topic=1 ORDER BY A.hits DESC LIMIT 1 \";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:2:\"60\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1301391941','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('958','','0','0','blue_newssth2','code','0','<div id=\"Span4\" onmouseover=\"ShowTab(4,4,7)\"><span></span></div>\r\n<div id=\"Span5\" onmouseover=\"ShowTab(5,4,7)\"><span>ͼƬ</span></div>\r\n<div id=\"Span6\" onmouseover=\"ShowTab(6,4,7)\"><span>Ƶ</span></div>\r\n','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('959','','0','0','blue_newsh8','code','0','Ѷ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('960','','0','0','blue_newst7','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:65:\"<div class=\"list\"><A HREF=\"$url\" target=\'_blank\'>$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 5 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('961','','0','0','blue_newsh6','code','0','<div class=\"tag\">Ļݺ</div><div class=\"more\"><a href=\"#\"></a></div>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('962','','0','0','blue_newsh7','code','0','<div class=\"tag\"≯۽</div><div class=\"more\"><a href=\"#\"></a></div>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1301386682','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('963','','0','0','blue_newsad2','pic','0','a:4:{s:6:\"imgurl\";s:28:\"../news/images/blue/nad2.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"990\";s:6:\"height\";s:3:\"100\";}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('964','','0','0','blue_newst6','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:231:\"<div class=\"listpic\">\r\n	<div class=\"img\"><a href=\"$url\" target=\"_blank\" title=\"$full_title\"><img src=\"$picurl\" width=\"100\" /></a></div>\r\n    <div class=\"t\"><a href=\"$url\" target=\"_blank\" title=\"$full_title\">$title</a></div>\r\n</div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.hits\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"2\";s:3:\"sql\";s:121:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1  AND A.ispic=1   AND A.ispic=1  ORDER BY A.hits ASC LIMIT 2 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1301385690','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('965','','0','0','blue_newsh5','code','0','<div class=\"tag\">ע</div><div class=\"more\"><a href=\"#\"></a></div>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('966','','0','0','blue_newst5','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:65:\"<div class=\"list\"><A HREF=\"$url\" target=\'_blank\'>$title</a></div>\";s:13:\"tplpart_2code\";s:409:\"<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n  <tr>\r\n    <td class=\"img\"><div><a href=\"$url\" target=\"_blank\" title=\"$full_title\"><img src=\"$picurl\" width=\"80\" /></a></div></td>\r\n    <td class=\"word\">\r\n    	<h3><a href=\"$url\" target=\"_blank\" title=\"$full_title\">$title</a></h3>\r\n    	<p>$content<a href=\"$url\" target=\"_blank\" title=\"$full_title\">[ϸ]</a></p>\r\n    </td>\r\n  </tr>\r\n</table>\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:33:\"/common_zh_content/zh_content.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:10:\"A.digg_num\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:161:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid   WHERE A.yz=1   AND R.topic=1 ORDER BY A.digg_num ASC LIMIT 6 \";s:4:\"sql2\";s:173:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid  WHERE A.yz=1  AND A.ispic=1 AND R.topic=1 ORDER BY A.digg_num ASC LIMIT 1 \";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:2:\"50\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1301385512','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('967','','0','0','blue_newsad1','pic','0','a:4:{s:6:\"imgurl\";s:28:\"../news/images/blue/nad1.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"420\";s:6:\"height\";s:2:\"30\";}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('968','','0','0','blue_newst4','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:65:\"<div class=\"list\"><A HREF=\"$url\" target=\'_blank\'>$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"9\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 9 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('969','','0','0','blue_newst3','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:65:\"<div class=\"list\"><A HREF=\"$url\" target=\'_blank\'>$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"8\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 8 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('970','','0','0','blue_newst2','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:67:\"<div class=\"list$i\"><A HREF=\"$url\" target=\'_blank\'>$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"14\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list ASC LIMIT 14 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1301371936','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('971','','0','0','blue_newst1','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:67:\"<div class=\"list$i\"><A HREF=\"$url\" target=\'_blank\'>$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"3\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 3 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"50\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('972','','0','0','blue_newsstc2','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:65:\"<div class=\"list\"><A HREF=\"$url\" target=\'_blank\'>$title</a></div>\";s:13:\"tplpart_2code\";s:410:\"<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n  <tr>\r\n    <td class=\"img\"><div><a href=\"$url\" target=\"_blank\" title=\"$full_title\"><img src=\"$picurl\" width=\"120\" /></a></div></td>\r\n    <td class=\"word\">\r\n    	<h3><a href=\"$url\" target=\"_blank\" title=\"$full_title\">$title</a></h3>\r\n    	<p>$content<a href=\"$url\" target=\"_blank\" title=\"$full_title\">[ϸ]</a></p>\r\n    </td>\r\n  </tr>\r\n</table>\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:33:\"/common_zh_content/zh_content.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.hits\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:159:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid   WHERE A.yz=1   AND R.topic=1 ORDER BY A.hits DESC LIMIT 11 \";s:4:\"sql2\";s:170:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid  WHERE A.yz=1  AND A.ispic=1 AND R.topic=1 ORDER BY A.hits DESC LIMIT 1 \";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:2:\"60\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1301368638','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('973','','0','0','blue_newsstc1','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:65:\"<div class=\"list\"><A HREF=\"$url\" target=\'_blank\'>$title</a></div>\";s:13:\"tplpart_2code\";s:410:\"<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n  <tr>\r\n    <td class=\"img\"><div><a href=\"$url\" target=\"_blank\" title=\"$full_title\"><img src=\"$picurl\" width=\"120\" /></a></div></td>\r\n    <td class=\"word\">\r\n    	<h3><a href=\"$url\" target=\"_blank\" title=\"$full_title\">$title</a></h3>\r\n    	<p>$content<a href=\"$url\" target=\"_blank\" title=\"$full_title\">[ϸ]</a></p>\r\n    </td>\r\n  </tr>\r\n</table>\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:33:\"/common_zh_content/zh_content.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:158:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid   WHERE A.yz=1   AND R.topic=1 ORDER BY A.list ASC LIMIT 11 \";s:4:\"sql2\";s:169:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid  WHERE A.yz=1  AND A.ispic=1 AND R.topic=1 ORDER BY A.list ASC LIMIT 1 \";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:2:\"60\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1301368599','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('974','','0','0','blue_newsstc3','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:65:\"<div class=\"list\"><A HREF=\"$url\" target=\'_blank\'>$title</a></div>\";s:13:\"tplpart_2code\";s:410:\"<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n  <tr>\r\n    <td class=\"img\"><div><a href=\"$url\" target=\"_blank\" title=\"$full_title\"><img src=\"$picurl\" width=\"120\" /></a></div></td>\r\n    <td class=\"word\">\r\n    	<h3><a href=\"$url\" target=\"_blank\" title=\"$full_title\">$title</a></h3>\r\n    	<p>$content<a href=\"$url\" target=\"_blank\" title=\"$full_title\">[ϸ]</a></p>\r\n    </td>\r\n  </tr>\r\n</table>\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:33:\"/common_zh_content/zh_content.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:159:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid   WHERE A.yz=1   AND R.topic=1 ORDER BY A.list DESC LIMIT 11 \";s:4:\"sql2\";s:170:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid  WHERE A.yz=1  AND A.ispic=1 AND R.topic=1 ORDER BY A.list DESC LIMIT 1 \";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:2:\"60\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1301368651','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('975','','0','0','blue_newssth1','code','0','<div id=\"Span1\" onmouseover=\"ShowTab(1,1,4)\"><span>ר</span></div>\r\n<div id=\"Span2\" onmouseover=\"ShowTab(2,1,4)\"><span>ԭ</span></div>\r\n<div id=\"Span3\" onmouseover=\"ShowTab(3,1,4)\"><span>ر߻</span></div>\r\n','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('976','','0','0','blue_newsslide','rollpic','0','a:6:{s:8:\"rolltype\";s:1:\"0\";s:5:\"width\";s:3:\"300\";s:6:\"height\";s:3:\"220\";s:6:\"picurl\";a:2:{i:1;s:32:\"label/1_20101109181105_gzaok.jpg\";i:2;s:32:\"label/1_20101109181113_fwdej.jpg\";}s:7:\"piclink\";a:2:{i:1;s:1:\"#\";i:2;s:1:\"#\";}s:6:\"picalt\";a:2:{i:1;s:0:\"\";i:2;s:0:\"\";}}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('977','','0','99','blue_headad1','pic','0','a:4:{s:6:\"imgurl\";s:35:\"http://news.net/images/blue/ad1.gif\";s:7:\"imglink\";s:25:\"http://www.sudu.cn/agent/\";s:5:\"width\";s:3:\"470\";s:6:\"height\";s:2:\"60\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1306467247','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('978','','0','99','blue_headtext1','code','0','<a href=\"#\">uggs outlet</a>\r\n<a href=\"#\">˼С</a>\r\n<a href=\"#\">ٱӪ</a>\r\n<a href=\"#\">ԭ</a>\r\n<a href=\"#\">߲Ʒ</a>\r\n<a href=\"#\">Ա</a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1306467251','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('979','','0','0','blue_indexhottitle','Info_news_','1','a:36:{s:13:\"tplpart_1code\";s:69:\"<div class=\"list$i\"><A HREF=\"$url\" target=\'_blank\'>$title</a></div>\r\n\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:24:\"/common_title/0title.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"16\";s:3:\"sql\";s:95:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 0,16 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1306833734','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('980','','0','0','blue_indexslide','rollpic','0','a:6:{s:8:\"rolltype\";s:1:\"0\";s:5:\"width\";s:3:\"330\";s:6:\"height\";s:3:\"230\";s:6:\"picurl\";a:2:{i:1;s:32:\"label/1_20101109141150_sfgyo.jpg\";i:2;s:32:\"label/1_20101109141154_f28xx.jpg\";}s:7:\"piclink\";a:2:{i:1;s:19:\"http://www.sudu.cn/\";i:2;s:26:\"http://www.chinaccnet.com/\";}s:6:\"picalt\";a:2:{i:1;s:0:\"\";i:2;s:0:\"\";}}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('981','','0','0','blue_indexlistmv','Info_news_','1','a:36:{s:13:\"tplpart_1code\";s:186:\"<div class=\"listmv\"> \r\n<a class=\"img\" href=\"$url\" target=\"_blank\"><img  src=\"$picurl\" width=\"85\" height=\"60\" /></a>\r\n<A HREF=\"$url\" title=\'$full_title\' target=\"_blank\">$title</A>\r\n</div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:24:\"/common_pic/img_div1.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.hits\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"3\";s:3:\"sql\";s:124:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1  AND A.ispic=1   AND A.ispic=1  ORDER BY A.hits DESC LIMIT 0,3 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1306912067','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('982','','0','0','blue_indexhotzt','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:377:\"<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"listzt\">\r\n  <tr>\r\n    <td class=\"img\"><div><a href=\"$url\" target=\"_blank\"><img  src=\"$picurl\" width=\"60\" height=\"54\"/></a></div></td>\r\n    <td class=\"word\">\r\n    <div><a href=\"$url\" target=\"_blank\">$title</a></div>\r\n    <p>$content [<a href=\"$url\" target=\"_blank\">ϸ</a>]</p>\r\n    </td>\r\n  </tr>\r\n</table>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:29:\"/common_content/content_1.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:2:\"cp\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:188:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid   WHERE A.yz=1  AND A.ispic=1   AND A.ispic=1  AND R.topic=1 ORDER BY A.list DESC LIMIT 5 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"40\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"20\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300784192','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('983','','0','0','blue_indexh1','code','0','ƼƵ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('984','','0','0','blue_indexm1','code','0','<a href=\"./video/\"></a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('985','','0','0','blue_indexh2','code','0','ţ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('986','','0','0','blue_indexc2','code','0','<a href=\"#\">ֵ</a>\r\n<a href=\"#\">ƽ</a>\r\n<a href=\"#\">LED</a>\r\n<a href=\"#\">Ϣ</a>\r\n<a href=\"#\">RFID</a>\r\n<a href=\"#\"></a>\r\n<a href=\"#\">̫</a>\r\n<a href=\"#\"></a>\r\n<a href=\"#\">TFT</a>\r\n<a href=\"#\"></a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('987','','0','0','blue_indexh3','code','0','ȵר','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('988','','0','0','blue_indexm3','code','0','<a href=\"./news/listsp.php?fid=1\"></a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('989','','0','0','blue_indexlistblog1','Info_news_','1','a:36:{s:13:\"tplpart_1code\";s:292:\"<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"listpic\">\r\n  <tr>\r\n    <td class=\"img\"><div><a href=\"$url\" target=\"_blank\"><img  src=\"$picurl\" width=\"60\" height=\"60\"/></a></div></td>\r\n    <td class=\"word\"><a href=\"$url\" target=\"_blank\">$title</a></td>\r\n  </tr>\r\n</table>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:24:\"/common_pic/img_div1.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:124:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1  AND A.ispic=1   AND A.ispic=1  ORDER BY A.list DESC LIMIT 0,4 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"50\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1306912053','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('990','','0','0','blue_indexlisttz','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:93:\"<div class=\"list\"><span>{$username}</span> | <A HREF=\"$url\" target=\'_blank\' >$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:24:\"/common_title/0title.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"8\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 8 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300787011','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('991','','0','0','blue_indexlistblog2','Info_photo_','1','a:35:{s:13:\"tplpart_1code\";s:67:\"<div class=\"lista\"><A HREF=\"$url\" target=\'_blank\' >$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:6:\"photo_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:24:\"/common_title/0title.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"2\";s:3:\"sql\";s:93:\" SELECT A.*,A.aid AS id FROM qb_photo_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 2 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('992','','0','0','blue_indext1','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:101:\"<div class=\"list$i\"><A HREF=\"$url\" target=\'_blank\'>$title</a><span>{$time_H}:{$time_i}</span></div>\r\n\";s:13:\"tplpart_2code\";s:108:\"<dl>\r\n<dt><a href=\"$url\" target=\"_blank\" title=\"$full_title\">$title</a></dt>\r\n<dd>$content</dd>\r\n</dl>  \r\n\r\n\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:33:\"/common_zh_content/zh_content.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"12\";s:3:\"sql\";s:159:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid   WHERE A.yz=1   AND R.topic=1 ORDER BY A.list DESC LIMIT 13 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:2:\"60\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"50\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300850305','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('993','','0','0','blue_indext2','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:73:\"<div class=\"list$i\"><A HREF=\"$url\" target=\'_blank\' >$title</a></div>     \";s:13:\"tplpart_2code\";s:317:\"<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"listm\">\r\n  <tr>\r\n    <td class=\"img\"><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" width=\"100\" height=\"75\"/></a></td>\r\n    <td class=\"word\">\r\n    <div><A HREF=\"$url\" target=\'_blank\' >$title</a></div>\r\n    $content\r\n    </td>\r\n  </tr>\r\n</table>\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:33:\"/common_zh_content/zh_content.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:159:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid   WHERE A.yz=1   AND R.topic=1 ORDER BY A.list DESC LIMIT 11 \";s:4:\"sql2\";s:170:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid  WHERE A.yz=1  AND A.ispic=1 AND R.topic=1 ORDER BY A.list DESC LIMIT 1 \";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"100\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300851734','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('994','','0','0','blue_indexst1','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:68:\"<div class=\"list$i\"><A HREF=\"$url\" target=\'_blank\' >$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:24:\"/common_title/0title.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"8\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 8 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('995','','0','0','blue_indexst2','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:68:\"<div class=\"list$i\"><A HREF=\"$url\" target=\'_blank\' >$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"8\";s:3:\"sql\";s:91:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list ASC LIMIT 8 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('996','','0','0','blue_indexst3','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:68:\"<div class=\"list$i\"><A HREF=\"$url\" target=\'_blank\' >$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.hits\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"8\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.hits DESC LIMIT 8 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('997','','0','0','blue_indexst4','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:68:\"<div class=\"list$i\"><A HREF=\"$url\" target=\'_blank\' >$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:10:\"A.digg_num\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"8\";s:3:\"sql\";s:96:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.digg_num DESC LIMIT 8 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('998','','0','0','blue_indexst5','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:71:\"<div class=\"lista l1\"><A HREF=\"$url\" target=\'_blank\'>$title</a></div>\r\n\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:24:\"/common_title/0title.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 6 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('999','','0','0','blue_indexad2','pic','0','a:4:{s:6:\"imgurl\";s:27:\"../images/blue/indexad2.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:2:\"90\";}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1000','','0','0','blue_indexad1','pic','0','a:4:{s:6:\"imgurl\";s:27:\"../images/blue/indexad1.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"730\";s:6:\"height\";s:2:\"90\";}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1001','','0','0','blue_indextab5','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:99:\"<div class=\"list$i\"><A HREF=\"$url\" target=\'_blank\'>$title</a><span>{$time_H}:{$time_i}</span></div>\";s:13:\"tplpart_2code\";s:104:\"<dl>\r\n<dt><a href=\"$url\" target=\"_blank\" title=\"$full_title\">$title</a></dt>\r\n<dd>$content</dd>\r\n</dl>  \";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:33:\"/common_zh_content/zh_content.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.hits\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"12\";s:3:\"sql\";s:159:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid   WHERE A.yz=1   AND R.topic=1 ORDER BY A.hits DESC LIMIT 13 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:2:\"60\";s:8:\"titlenum\";s:2:\"36\";s:9:\"titlenum2\";s:2:\"60\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300861006','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1002','','0','0','blue_indextab6','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:99:\"<div class=\"list$i\"><A HREF=\"$url\" target=\'_blank\'>$title</a><span>{$time_H}:{$time_i}</span></div>\";s:13:\"tplpart_2code\";s:104:\"<dl>\r\n<dt><a href=\"$url\" target=\"_blank\" title=\"$full_title\">$title</a></dt>\r\n<dd>$content</dd>\r\n</dl>  \";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:32:\"/common_zh_title/zh_bigtitle.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:10:\"A.digg_num\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"12\";s:3:\"sql\";s:162:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid   WHERE A.yz=1   AND R.topic=1 ORDER BY A.digg_num ASC LIMIT 13 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:2:\"60\";s:8:\"titlenum\";s:2:\"36\";s:9:\"titlenum2\";s:2:\"60\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300860981','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1003','','0','0','blue_indext3','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:70:\"<div class=\"list$i\"><A HREF=\"$url\" target=\'_blank\' >$title</a></div>  \";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 4 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1004','','0','0','blue_indext4','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:175:\"<div class=\"listpic\">\r\n<a href=\"$url\" target=\"_blank\" class=\"img\"><img src=\"$picurl\" width=\"125\" height=\"90\"/></a>\r\n<a href=\"$url\" target=\"_blank\" class=\"t\">$title</a>\r\n</div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:122:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1  AND A.ispic=1   AND A.ispic=1  ORDER BY A.list DESC LIMIT 4 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300863819','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1005','','0','0','blue_indext5','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:65:\"<div class=\"list\"><A HREF=\"$url\" target=\'_blank\'>$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";s:1:\"3\";s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:110:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1  AND A.fid IN (3)   ORDER BY A.list DESC LIMIT 4 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300864834','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1006','','0','0','blue_indext6','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:65:\"<div class=\"list\"><A HREF=\"$url\" target=\'_blank\'>$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";s:1:\"4\";s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"3\";s:3:\"sql\";s:110:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1  AND A.fid IN (4)   ORDER BY A.list DESC LIMIT 3 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1007','','0','0','blue_indext7','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:65:\"<div class=\"list\"><A HREF=\"$url\" target=\'_blank\'>$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";s:2:\"34\";s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"3\";s:3:\"sql\";s:111:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1  AND A.fid IN (34)   ORDER BY A.list DESC LIMIT 3 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1008','','0','0','blue_indexad3','pic','0','a:4:{s:6:\"imgurl\";s:27:\"../images/blue/indexad3.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"110\";}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1009','','0','0','blue_indexst7','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:321:\"<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"listpic\">\r\n  <tr>\r\n    <td class=\"img\"><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" width=\"125\" height=\"90\"/></a></td>\r\n    <td class=\"word\">\r\n    <div><A HREF=\"$url\" target=\'_blank\' >$title</a></div>\r\n    $content\r\n    </td>\r\n  </tr>\r\n</table>\r\n\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:29:\"/common_content/content_1.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:2:\"cp\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"2\";s:3:\"sql\";s:188:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid   WHERE A.yz=1  AND A.ispic=1   AND A.ispic=1  AND R.topic=1 ORDER BY A.list DESC LIMIT 2 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1010','','0','0','blue_indexst8','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:321:\"<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"listpic\">\r\n  <tr>\r\n    <td class=\"img\"><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" width=\"125\" height=\"90\"/></a></td>\r\n    <td class=\"word\">\r\n    <div><A HREF=\"$url\" target=\'_blank\' >$title</a></div>\r\n    $content\r\n    </td>\r\n  </tr>\r\n</table>\r\n\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:29:\"/common_content/content_1.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:2:\"cp\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"2\";s:3:\"sql\";s:187:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid   WHERE A.yz=1  AND A.ispic=1   AND A.ispic=1  AND R.topic=1 ORDER BY A.list ASC LIMIT 2 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1011','','0','0','blue_indexst9','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:319:\"<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"listpic\">\r\n  <tr>\r\n    <td class=\"img\"><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" width=\"125\" height=\"90\"/></a></td>\r\n    <td class=\"word\">\r\n    <div><A HREF=\"$url\" target=\'_blank\' >$title</a></div>\r\n    $content\r\n    </td>\r\n  </tr>\r\n</table>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:29:\"/common_content/content_1.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:2:\"cp\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.hits\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"2\";s:3:\"sql\";s:188:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid   WHERE A.yz=1  AND A.ispic=1   AND A.ispic=1  AND R.topic=1 ORDER BY A.hits DESC LIMIT 2 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1012','','0','0','blue_indexst10','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:125:\"<div class=\"list\"><a href=\"$list_url\" target=\'_blank\' class=\"f\">[{$fname}]</a><a href=\"$url\" target=\'_blank\'>$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:24:\"/common_title/0title.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"8\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 8 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300867588','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1013','','0','0','blue_indexst11','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:125:\"<div class=\"list\"><a href=\"$list_url\" target=\'_blank\' class=\"f\">[{$fname}]</a><a href=\"$url\" target=\'_blank\'>$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"8\";s:3:\"sql\";s:91:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list ASC LIMIT 8 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300867610','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1014','','0','0','blue_indexst12','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:125:\"<div class=\"list\"><a href=\"$list_url\" target=\'_blank\' class=\"f\">[{$fname}]</a><a href=\"$url\" target=\'_blank\'>$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.hits\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"8\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.hits DESC LIMIT 8 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1300867575','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1015','','0','0','blue_indext8','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:65:\"<div class=\"list\"><a href=\"$url\" target=\'_blank\'>$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"9\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 9 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1016','','0','0','blue_indexh4','code','0','ITרҲ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1017','','0','0','blue_indexm4','code','0','<a href=\"#\"></a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1018','','0','0','blue_indexh5','code','0','Ƽ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1019','','0','0','blue_indexm5','code','0','<a href=\"#\"></a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1020','','0','0','blue_indexh6','code','0','ͶƱ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1021','','0','0','blue_indexm6','code','0','<a href=\"#\"></a>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1022','','0','0','blue_indexh7','code','0','','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1023','','0','0','blue_indexh8','code','0','<div class=\"tg\">ǰ</div><div class=\"m\"><a href=\"#\"></a></div>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1024','','0','0','blue_indexh9','code','0','а','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1025','','0','0','blue_indexh10','code','0','<div id=\"Span1\" onmouseover=\"ShowTab(1,1,5)\"><span></span></div>\r\n                    <div id=\"Span2\" onmouseover=\"ShowTab(2,1,5)\"><span>IT</span></div>\r\n                    <div id=\"Span3\" onmouseover=\"ShowTab(3,1,5)\"><span>ͨ</span></div>\r\n                    <div id=\"Span4\" onmouseover=\"ShowTab(4,1,5)\"><span>ҵ</span></div>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1026','','0','0','blue_indexh11','code','0','顤','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1027','','0','0','blue_indexh12','code','0','IT','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1028','','0','0','blue_indexh13','code','0','<span id=\"Span5\" onmouseover=\"ShowTab(5,5,7)\">ҵ綯̬</span>\r\n                        <span id=\"Span6\" onmouseover=\"ShowTab(6,5,7)\">鵼</span>\r\n                        <span class=\"m\"><a href=\"#\"></a></span>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1029','','0','0','blue_indexh14','code','0','<div class=\"tg\">Ʒ</div><div class=\"m\"><a href=\"#\"></a></div>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1030','','0','0','blue_indexh15','code','0','ۺ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1031','','0','0','blue_indexh16','code','0','','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1032','','0','0','blue_indexh17','code','0','ITҵ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1033','','0','0','blue_indexh18','code','0','ȵ¼','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1034','','0','0','blue_indexh19','code','0','<div class=\"tag\">ҵϢ</div><div class=\"more\"><a href=\"#\"></a></div>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1035','','0','0','blue_indexh20','code','0','<div id=\"Span7\" onmouseover=\"ShowTab(7,7,10)\"><span></span></div>\r\n                <div id=\"Span8\" onmouseover=\"ShowTab(8,7,10)\"><span>ҵ</span></div>\r\n                <div id=\"Span9\" onmouseover=\"ShowTab(9,7,10)\"><span>Ϣ</span></div>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1036','','0','0','blue_indexh21','code','0','<div class=\"tag\">Ʒͼ</div><div class=\"more\"><a href=\"#\"></a></div>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1037','','0','0','blue_indexh22','code','0','<div id=\"Span10\" onmouseover=\"ShowTab(10,10,13)\"><span>Ʒ</span></div>\r\n                <div id=\"Span11\" onmouseover=\"ShowTab(11,10,13)\"><span></span></div>\r\n                <div id=\"Span12\" onmouseover=\"ShowTab(12,10,13)\"><span></span></div>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1038','','0','0','blue_indexh23','code','0','<div class=\"tag\">ͶƱ</div><div class=\"more\"><a href=\"#\"></a></div>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1070','','0','0','blue_nbencandyh1','code','0','48Сʱ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','3','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1071','','0','0','blue_nbencandyt1','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:98:\"<div class=\"list\"><A HREF=\"$url\" target=\'_blank\'>$i.$title</a><span>{$comments}</span></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:24:\"/common_title/0title.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.hits\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.hits DESC LIMIT 5 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"50\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','3','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1072','','0','0','blue_nbencandyh2','code','0','ͼƬƼ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','3','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1073','','0','0','blue_nbencandyt2','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:215:\"<div class=\"listpic pic$i\">\r\n	<div class=\"img\"><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" width=\"120\"></a></div>\r\n    <div class=\"t\"><a href=\"$url\" title=\'$full_title\' target=\"_blank\">$title</a></div>\r\n</div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:24:\"/common_pic/img_div1.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:122:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1  AND A.ispic=1   AND A.ispic=1  ORDER BY A.list DESC LIMIT 4 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"20\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1301036384','3','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1074','','0','0','blue_nbencandyh3','code','0','ȵ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','3','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1075','','0','0','blue_nbencandyt3','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:67:\"<div class=\"list\"><A HREF=\"$url\" target=\'_blank\'>$title</a></div>\";s:13:\"tplpart_2code\";s:337:\"<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"list0\">\r\n  <tr>\r\n    <td class=\"img\"><div><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" width=\"125\"></a></div></td>\r\n    <td class=\"word\"><div><a href=\"$url\" target=\"_blank\">$title</a></div>$content<a href=\"$url\" target=\"_blank\">[ȫ]</a></td>\r\n  </tr>\r\n</table>\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:33:\"/common_zh_content/zh_content.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:158:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid   WHERE A.yz=1   AND R.topic=1 ORDER BY A.list DESC LIMIT 6 \";s:4:\"sql2\";s:170:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid  WHERE A.yz=1  AND A.ispic=1 AND R.topic=1 ORDER BY A.list DESC LIMIT 1 \";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:2:\"80\";s:8:\"titlenum\";s:2:\"60\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1301042718','3','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1076','','0','0','blue_nbencandyad1','pic','0','a:4:{s:6:\"imgurl\";s:28:\"../news/images/blue/bad1.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"290\";s:6:\"height\";s:3:\"150\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1301046740','3','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1077','','0','0','blue_nbencandysth1','code','0','<div id=\"Span1\" onmouseover=\"ShowTab(1,1,5)\"><span>Ƽ</span></div>\r\n<div id=\"Span2\" onmouseover=\"ShowTab(2,1,5)\"><span></span></div>\r\n<div id=\"Span3\" onmouseover=\"ShowTab(3,1,5)\"><span></span></div>\r\n<div id=\"Span4\" onmouseover=\"ShowTab(4,1,5)\"><span>ƾ</span></div>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1301046050','3','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1078','','0','0','blue_nbencandyh4','code','0','ѹע','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','3','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1079','','0','0','blue_nbencandyst1','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:87:\"<div class=\"list$i\"><a href=\"$url\" title=\'$full_title\' target=\"_blank\">$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list ASC LIMIT 10 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','3','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1080','','0','0','blue_nbencandyst2','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:87:\"<div class=\"list$i\"><a href=\"$url\" title=\'$full_title\' target=\"_blank\">$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:10:\"A.posttime\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:97:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.posttime DESC LIMIT 10 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','3','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1081','','0','0','blue_nbencandyst3','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:87:\"<div class=\"list$i\"><a href=\"$url\" title=\'$full_title\' target=\"_blank\">$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.hits\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:93:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.hits DESC LIMIT 10 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1301044006','3','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1082','','0','0','blue_nbencandyst4','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:87:\"<div class=\"list$i\"><a href=\"$url\" title=\'$full_title\' target=\"_blank\">$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:10:\"A.digg_num\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:97:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.digg_num DESC LIMIT 10 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','3','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1083','','0','0','blue_nbencandyh5','code','0','Ƶ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','3','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1084','','0','0','blue_nbencandyt51','Info_video_','1','a:35:{s:13:\"tplpart_1code\";s:191:\"<div class=\"listpic\">\r\n	<div class=\"img\"><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" width=\"125\" /></a></div>\r\n    <div class=\"t\"><a href=\"$url\" target=\"_blank\">$title</a></div>\r\n</div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:6:\"video_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:24:\"/common_pic/img_div1.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"2\";s:3:\"sql\";s:123:\" SELECT A.*,A.aid AS id FROM qb_video_article A  WHERE A.yz=1  AND A.ispic=1   AND A.ispic=1  ORDER BY A.list DESC LIMIT 2 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1301277363','3','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1085','','0','0','blue_nbencandyt52','Info_video_','1','a:35:{s:13:\"tplpart_1code\";s:65:\"<div class=\"list\"><a href=\"$url\" target=\"_blank\">$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:6:\"video_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"8\";s:3:\"sql\";s:93:\" SELECT A.*,A.aid AS id FROM qb_video_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 8 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1301277346','3','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1086','','0','0','blue_nbencandyh6','code','0','صע','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','3','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1087','','0','0','blue_nbencandyt6','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:67:\"<div class=\"list\"><a href=\"$url\" target=\"_blank\">$title</a></div>\r\n\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:93:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 10 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"50\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','3','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1088','','0','0','blue_nbencandyad2','pic','0','a:4:{s:6:\"imgurl\";s:28:\"../news/images/blue/bad2.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"290\";s:6:\"height\";s:3:\"120\";}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','3','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1089','','0','0','blue_nlisth1','code','0','ȵ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1090','','0','0','blue_nlistt1','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:67:\"<div class=\"list\"><A HREF=\"$url\" target=\'_blank\'>$title</a></div>\";s:13:\"tplpart_2code\";s:337:\"<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"list0\">\r\n  <tr>\r\n    <td class=\"img\"><div><a href=\"$url\" target=\"_blank\"><img src=\"$picurl\" width=\"125\"></a></div></td>\r\n    <td class=\"word\"><div><a href=\"$url\" target=\"_blank\">$title</a></div>$content<a href=\"$url\" target=\"_blank\">[ȫ]</a></td>\r\n  </tr>\r\n</table>\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:33:\"/common_zh_content/zh_content.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:158:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid   WHERE A.yz=1   AND R.topic=1 ORDER BY A.list DESC LIMIT 6 \";s:4:\"sql2\";s:170:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid  WHERE A.yz=1  AND A.ispic=1 AND R.topic=1 ORDER BY A.list DESC LIMIT 1 \";s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:2:\"80\";s:8:\"titlenum\";s:2:\"60\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1091','','0','0','blue_nlistad1','pic','0','a:4:{s:6:\"imgurl\";s:28:\"../news/images/blue/bad1.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"290\";s:6:\"height\";s:3:\"150\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1301290435','2','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1092','','0','0','blue_nlisth2','code','0','ѹע','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1093','','0','0','blue_nliststh1','code','0','<div id=\"Span1\" onmouseover=\"ShowTab(1,1,5)\"><span>Ƽ</span></div>\r\n<div id=\"Span2\" onmouseover=\"ShowTab(2,1,5)\"><span></span></div>\r\n<div id=\"Span3\" onmouseover=\"ShowTab(3,1,5)\"><span></span></div>\r\n<div id=\"Span4\" onmouseover=\"ShowTab(4,1,5)\"><span>ƾ</span></div>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1094','','0','0','blue_nlistst4','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:87:\"<div class=\"list$i\"><a href=\"$url\" title=\'$full_title\' target=\"_blank\">$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:93:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 10 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1095','','0','0','blue_nlistst1','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:87:\"<div class=\"list$i\"><a href=\"$url\" title=\'$full_title\' target=\"_blank\">$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list ASC LIMIT 10 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1096','','0','0','blue_nlistst2','Info_video_','1','a:35:{s:13:\"tplpart_1code\";s:87:\"<div class=\"list$i\"><a href=\"$url\" title=\'$full_title\' target=\"_blank\">$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:6:\"video_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:94:\" SELECT A.*,A.aid AS id FROM qb_video_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 10 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1097','','0','0','blue_nlistst3','Info_photo_','1','a:35:{s:13:\"tplpart_1code\";s:87:\"<div class=\"list$i\"><a href=\"$url\" title=\'$full_title\' target=\"_blank\">$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:6:\"photo_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:94:\" SELECT A.*,A.aid AS id FROM qb_photo_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 10 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1098','','0','0','blue_nlistad2','pic','0','a:4:{s:6:\"imgurl\";s:28:\"../news/images/blue/bad2.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"290\";s:6:\"height\";s:3:\"120\";}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1099','','0','0','blue_listspad','pic','0','a:4:{s:6:\"imgurl\";s:28:\"../news/images/blue/spad.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"990\";s:6:\"height\";s:2:\"90\";}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','10','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1100','','0','0','blue_sph1','code','0','<div class=\"tag\"><span></span>ר</div><div class=\"more\"><a href=\"#\">&gt;&gt;</a></div>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1301296642','10','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1101','','0','0','blue_spt1','Info_news_','1','a:33:{s:13:\"tplpart_1code\";s:111:\"<div class=\"list\"><a href=\"$url\" target=\"_blank\">$title</a><span>{$time_Y}{$time_m}{$time_d}</span></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"special\";s:13:\"RollStyleType\";s:0:\"\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:4:\"spid\";s:2:\"24\";s:3:\"url\";N;s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"tplpath\";s:24:\"/common_title/0title.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:4:\"list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";N;s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','10','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1102','','0','0','blue_sph2','code','0','<div class=\"tag\"><span></span>ר</div><div class=\"more\"><a href=\"#\">&gt;&gt;</a></div>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','10','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1103','','0','0','blue_spt2','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:111:\"<div class=\"list\"><a href=\"$url\" target=\"_blank\">$title</a><span>{$time_Y}{$time_m}{$time_d}</span></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:93:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 10 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','10','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1104','','0','0','blue_newst17b','Info_news_','1','a:36:{s:13:\"tplpart_1code\";s:231:\"<div class=\"listpic\">\r\n	<div class=\"img\"><a href=\"$url\" target=\"_blank\" title=\"$full_title\"><img src=\"$picurl\" width=\"110\" /></a></div>\r\n    <div class=\"t\"><a href=\"$url\" target=\"_blank\" title=\"$full_title\">$title</a></div>\r\n</div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:123:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1  AND A.ispic=1   AND A.ispic=1  ORDER BY A.list ASC LIMIT 0,4 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"36\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1306912200','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1105','','0','0','blue_newst17c','Info_news_','1','a:36:{s:13:\"tplpart_1code\";s:65:\"<div class=\"list\"><a href=\"$url\" target=\'_blank\'>$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"4\";s:3:\"sql\";s:94:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 0,4 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"50\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:9:\"start_num\";s:1:\"1\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1306912180','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1106','','0','0','blue_newsh18','code','0','<div class=\"tag\">ʷ</div><div class=\"more\"><a href=\"#\"></a></div>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1107','','0','0','blue_newsh19','code','0','<div class=\"tag\"></div><div class=\"more\"><a href=\"#\"></a></div>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1108','','0','0','blue_newsh20','code','0','<div class=\"tag\">̽</div><div class=\"more\"><a href=\"#\"></a></div>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1109','','0','0','blue_newst18','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:131:\"<div class=\"list\"><a href=\"$url\" target=\'_blank\' class=\"t\">$title</a><a href=\"$list_url\" target=\'_blank\' class=\"f\">$fname</a></div>\";s:13:\"tplpart_2code\";s:66:\"<div class=\"list0\"><a href=\"$url\" target=\'_blank\'>$title</a></div>\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:33:\"/common_zh_content/zh_content.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 6 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"50\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1301455701','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1110','','0','0','blue_newst19','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:131:\"<div class=\"list\"><a href=\"$url\" target=\'_blank\' class=\"t\">$title</a><a href=\"$list_url\" target=\'_blank\' class=\"f\">$fname</a></div>\";s:13:\"tplpart_2code\";s:66:\"<div class=\"list0\"><a href=\"$url\" target=\'_blank\'>$title</a></div>\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:33:\"/common_zh_content/zh_content.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:91:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list ASC LIMIT 6 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"50\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1301455687','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1111','','0','0','blue_newst20','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:131:\"<div class=\"list\"><a href=\"$url\" target=\'_blank\' class=\"t\">$title</a><a href=\"$list_url\" target=\'_blank\' class=\"f\">$fname</a></div>\";s:13:\"tplpart_2code\";s:66:\"<div class=\"list0\"><a href=\"$url\" target=\'_blank\'>$title</a></div>\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:33:\"/common_zh_content/zh_content.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 6 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"50\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1112','','0','0','blue_newsh21','code','0','<div class=\"tag\">λ</div><div class=\"more\"><a href=\"#\"></a></div>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1113','','0','0','blue_newst21','pic','0','a:4:{s:6:\"imgurl\";s:28:\"../news/images/blue/nad4.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"200\";s:6:\"height\";s:3:\"200\";}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1114','','0','0','blue_newsh22','code','0','<div class=\"tag\">48Сʱ</div><div class=\"more\"><a href=\"#\"></a></div>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1115','','0','0','blue_newst22','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:67:\"<div class=\"list$i\"><a href=\"$url\" target=\'_blank\'>$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"8\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 8 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1116','','0','0','blue_newst23','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:369:\"<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">\r\n  <tr>\r\n    <td class=\"img\"><div><a href=\"$url\" target=\"_blank\" title=\"$full_title\"><img src=\"$picurl\" width=\"100\" /></a></div></td>\r\n    <td class=\"word\">\r\n    <h3><a href=\"$url\" target=\'_blank\'>$title</a></h3>\r\n    <p>$content<a href=\"$url\" target=\'_blank\'>[ϸ]</a></p>	\r\n    </td>\r\n  </tr>\r\n</table>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:29:\"/common_content/content_1.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:2:\"cp\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.hits\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"1\";s:3:\"sql\";s:187:\" SELECT A.*,A.aid AS id,R.content FROM qb_news_article A LEFT JOIN qb_news_reply R ON A.aid=R.aid   WHERE A.yz=1  AND A.ispic=1   AND A.ispic=1  AND R.topic=1 ORDER BY A.hits ASC LIMIT 1 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"40\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1301462148','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1117','','0','0','blue_newsh23','code','0','<div class=\"tag\">б</div>\r\n<div class=\"more\"><a href=\"#\"></a> | <a href=\"#\"></a> | <a href=\"#\"></a>  | <a href=\"#\"></a> | <a href=\"#\">ƾ</a> | <a href=\"#\"></a> | <a href=\"#\"></a></div>','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1118','','0','0','blue_newsh24','code','0','ע','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1119','','0','0','blue_newsh25','code','0','ÿ','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1120','','0','0','blue_newsh26','code','0','¶̬','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1121','','0','0','blue_newst24','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:65:\"<div class=\"list\"><a href=\"$url\" target=\'_blank\'>$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 6 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"50\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1122','','0','0','blue_newst25','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:65:\"<div class=\"list\"><a href=\"$url\" target=\'_blank\'>$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:91:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list ASC LIMIT 6 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"50\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1123','','0','0','blue_newst26','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:65:\"<div class=\"list\"><a href=\"$url\" target=\'_blank\'>$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.hits\";s:3:\"asc\";s:3:\"ASC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:91:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.hits ASC LIMIT 6 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"50\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1301479287','0','30','0','0','blue');
INSERT INTO `qb_label` VALUES ('1124','','0','0','blue_diggst1','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:231:\"<div class=\"listpic\">\r\n	<div class=\"img\"><a href=\"$url\" target=\"_blank\" title=\"$full_title\"><img src=\"$picurl\" width=\"120\" /></a></div>\r\n    <div class=\"t\"><a href=\"$url\" target=\"_blank\" title=\"$full_title\">$title</a></div>\r\n</div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"2\";s:3:\"sql\";s:122:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1  AND A.ispic=1   AND A.ispic=1  ORDER BY A.list DESC LIMIT 2 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"20\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','7','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1125','','0','0','blue_diggst2','Info_photo_','1','a:35:{s:13:\"tplpart_1code\";s:231:\"<div class=\"listpic\">\r\n	<div class=\"img\"><a href=\"$url\" target=\"_blank\" title=\"$full_title\"><img src=\"$picurl\" width=\"120\" /></a></div>\r\n    <div class=\"t\"><a href=\"$url\" target=\"_blank\" title=\"$full_title\">$title</a></div>\r\n</div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:6:\"photo_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"2\";s:3:\"sql\";s:123:\" SELECT A.*,A.aid AS id FROM qb_photo_article A  WHERE A.yz=1  AND A.ispic=1   AND A.ispic=1  ORDER BY A.list DESC LIMIT 2 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"20\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','7','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1126','','0','0','blue_diggst3','Info_video_','1','a:35:{s:13:\"tplpart_1code\";s:231:\"<div class=\"listpic\">\r\n	<div class=\"img\"><a href=\"$url\" target=\"_blank\" title=\"$full_title\"><img src=\"$picurl\" width=\"120\" /></a></div>\r\n    <div class=\"t\"><a href=\"$url\" target=\"_blank\" title=\"$full_title\">$title</a></div>\r\n</div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:6:\"video_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"p\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"2\";s:3:\"sql\";s:123:\" SELECT A.*,A.aid AS id FROM qb_video_article A  WHERE A.yz=1  AND A.ispic=1   AND A.ispic=1  ORDER BY A.list DESC LIMIT 2 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"20\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','7','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1127','','0','0','blue_diggt2','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:65:\"<div class=\"list\"><A HREF=\"$url\" target=\'_blank\'>$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:24:\"/common_title/0title.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"6\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 6 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"30\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','7','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1128','','0','0','blue_diggt3','Info_news_','1','a:35:{s:13:\"tplpart_1code\";s:65:\"<div class=\"list\"><A HREF=\"$url\" target=\'_blank\'>$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:5:\"news_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:24:\"/common_title/0title.jpg\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"t\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:1:\"5\";s:3:\"sql\";s:92:\" SELECT A.*,A.aid AS id FROM qb_news_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 5 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"50\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','7','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1129','','0','0','blue_diggadr','pic','0','a:4:{s:6:\"imgurl\";s:30:\"../news/images/blue/diggad.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"290\";s:6:\"height\";s:3:\"100\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"21\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','1301549117','7','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1139','','0','0','blue_vbencandyst1','Info_video_','1','a:35:{s:13:\"tplpart_1code\";s:87:\"<div class=\"list$i\"><a href=\"$url\" title=\'$full_title\' target=\"_blank\">$title</a></div>\";s:13:\"tplpart_2code\";s:0:\"\";s:3:\"SYS\";s:3:\"CMS\";s:3:\"PRE\";s:6:\"video_\";s:5:\"ctype\";s:7:\"article\";s:13:\"RollStyleType\";s:0:\"\";s:7:\"fidtype\";s:1:\"0\";s:8:\"rolltype\";s:10:\"scrollLeft\";s:8:\"rolltime\";s:1:\"3\";s:11:\"roll_height\";s:2:\"50\";s:5:\"width\";s:3:\"250\";s:6:\"height\";s:3:\"187\";s:7:\"newhour\";s:2:\"24\";s:7:\"hothits\";s:3:\"100\";s:7:\"amodule\";N;s:7:\"tplpath\";s:0:\"\";s:6:\"DivTpl\";i:1;s:5:\"fiddb\";N;s:5:\"stype\";s:1:\"4\";s:2:\"yz\";s:1:\"1\";s:7:\"hidefid\";N;s:10:\"timeformat\";s:11:\"Y-m-d H:i:s\";s:5:\"order\";s:6:\"A.list\";s:3:\"asc\";s:4:\"DESC\";s:6:\"levels\";s:3:\"all\";s:7:\"rowspan\";s:2:\"10\";s:3:\"sql\";s:94:\" SELECT A.*,A.aid AS id FROM qb_video_article A  WHERE A.yz=1   ORDER BY A.list DESC LIMIT 10 \";s:4:\"sql2\";N;s:7:\"colspan\";s:1:\"1\";s:11:\"content_num\";s:2:\"80\";s:12:\"content_num2\";s:3:\"120\";s:8:\"titlenum\";s:2:\"40\";s:9:\"titlenum2\";s:2:\"40\";s:10:\"titleflood\";s:1:\"0\";s:10:\"c_rolltype\";s:1:\"0\";}','a:3:{s:5:\"div_w\";s:2:\"50\";s:5:\"div_h\";s:2:\"30\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','3','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1158','','0','0','blue_vlistad2','pic','0','a:4:{s:6:\"imgurl\";s:28:\"../news/images/blue/bad2.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"290\";s:6:\"height\";s:3:\"120\";}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','2','0','0','0','blue');
INSERT INTO `qb_label` VALUES ('1168','','0','99','coffee_headad1','pic','0','a:4:{s:6:\"imgurl\";s:24:\"../images/coffee/ad1.gif\";s:7:\"imglink\";s:1:\"#\";s:5:\"width\";s:3:\"470\";s:6:\"height\";s:2:\"60\";}','a:3:{s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','coffee');
INSERT INTO `qb_label` VALUES ('1169','','0','99','coffee_headtext1','code','0','<div><a href=\"#\">uggs outlet</a></div>\r\n<div><a href=\"#\">˼С</a></div>\r\n<div><a href=\"#\">ٱӪ</a></div>\r\n<div><a href=\"#\">ԭ</a></div>\r\n<div><a href=\"#\">߲Ʒ</a></div>\r\n<div><a href=\"#\">Ա</a></div>\r\n','a:4:{s:9:\"html_edit\";N;s:5:\"div_w\";s:0:\"\";s:5:\"div_h\";s:0:\"\";s:11:\"div_bgcolor\";s:0:\"\";}','0','0','1','admin','0','0','0','0','0','coffee');
INSERT INTO `qb_form_config` VALUES ('module_id','21','');
INSERT INTO `qb_form_config` VALUES ('module_pre','form_','');
INSERT INTO `qb_form_config` VALUES ('Info_webOpen','1','');
INSERT INTO `qb_form_config` VALUES ('Info_webname','ܱ','');
INSERT INTO `qb_form_content` VALUES ('26','','6','7','1237250809','1237250809','1','admin','','0','192.168.0.99');
INSERT INTO `qb_form_content` VALUES ('27','','3','1','1237260673','1237260673','1','admin','','1','192.168.0.99');
INSERT INTO `qb_form_content` VALUES ('30','','2','7','1237269830','1237269830','1','admin','','0','192.168.0.99');
INSERT INTO `qb_form_content` VALUES ('29','','2','2','1237268864','1237268864','1','admin','','0','192.168.0.99');
INSERT INTO `qb_form_content` VALUES ('25','','3','2','1237214289','1237214289','1','admin','','1','192.168.0.99');
INSERT INTO `qb_form_content` VALUES ('24','','6','3','1237213169','1237213169','1','admin','','0','192.168.0.99');
INSERT INTO `qb_form_content` VALUES ('31','','2','6','1239780761','1239780761','1','admin','','0','192.168.0.99');
INSERT INTO `qb_form_content` VALUES ('18','','3','0','1236936110','1236936110','1','admin','','0','192.168.0.99');
INSERT INTO `qb_form_content` VALUES ('20','','6','0','1237174883','1237174883','1','admin','','0','192.168.0.99');
INSERT INTO `qb_form_content_2` VALUES ('29','1','JAVAԱ','5','','','800Ԫ/','2','','');
INSERT INTO `qb_form_content_2` VALUES ('30','1','гܼ','2','Ʒ.','','8000Ԫ/','0','','');
INSERT INTO `qb_form_content_2` VALUES ('31','1','۾','8','ҹ˾ĲƷ.','','3000','0','ר','һ');
INSERT INTO `qb_form_content_3` VALUES ('18','1','ۺͷ','','222223','65223@qq.com','133444444443');
INSERT INTO `qb_form_content_3` VALUES ('25','1','ۺͷ','hhhhhhhhhhhhhhhhhh','222223','65223@qq.com','13377777777');
INSERT INTO `qb_form_content_3` VALUES ('27','1','ۺͷ','192.168.0.99/55 all righ\nts reserved \nICP05047353 \nPowered by PHP168','222223','65223@qq.com','13377777777');
INSERT INTO `qb_form_content_6` VALUES ('20','1','Ա','55555555555\nkkkkkkkkkkkkkkkkkkkkkk','5','222223','','56','','','','2','6767','','3','65223@qq.com','444444','');
INSERT INTO `qb_form_content_6` VALUES ('24','1','CԹʦ','4444444444444','4','222223','ר','4','','','','2','090-89766543','','3','65223@qq.com','444444','1');
INSERT INTO `qb_form_content_6` VALUES ('26','1','CԹʦ','rrrrrrrrrrrrrrrrrrrrrrrrrrr','4','222223','ר','4','','','','1','090-89766543','1000Ԫ-2000Ԫ','3','65223@qq.com','444444','1');
INSERT INTO `qb_form_module` VALUES ('1','','0','','a:3:{s:8:\"field_db\";a:8:{s:8:\"sortname\";a:14:{s:5:\"title\";s:18:\"ĸĿİ\";s:10:\"field_name\";s:8:\"sortname\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:40;s:9:\"form_type\";s:8:\"checkbox\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:38:\"Ƶ\r\nƵ\r\nͼƬƵ\r\nƵƵ\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"0\";s:9:\"orderlist\";s:2:\"11\";s:9:\"allowview\";N;}s:7:\"webtime\";a:15:{s:5:\"title\";s:16:\"ÿСʱ\";s:10:\"field_name\";s:7:\"webtime\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:10;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:1:\"4\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:4:\"Сʱ\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:2:\"10\";s:9:\"allowview\";N;}s:8:\"truename\";a:15:{s:5:\"title\";s:8:\"ʵ\";s:10:\"field_name\";s:8:\"truename\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:1:\"7\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:1:\"9\";s:9:\"allowview\";N;}s:3:\"sex\";a:15:{s:5:\"title\";s:4:\"Ա\";s:10:\"field_name\";s:3:\"sex\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:1;s:9:\"form_type\";s:5:\"radio\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:18:\"1|\r\n2|Ů\r\n0|\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:1:\"8\";s:9:\"allowview\";N;}s:4:\"oicq\";a:15:{s:5:\"title\";s:6:\"ϵQQ\";s:10:\"field_name\";s:4:\"oicq\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:10;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"10\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:7;s:9:\"allowview\";N;}s:8:\"mobphone\";a:14:{s:5:\"title\";s:8:\"ֻ\";s:10:\"field_name\";s:8:\"mobphone\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:11;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"11\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:6;s:9:\"allowview\";N;}s:8:\"interest\";a:14:{s:5:\"title\";s:8:\"Ȥ\";s:10:\"field_name\";s:8:\"interest\";s:10:\"field_type\";s:10:\"mediumtext\";s:10:\"field_leng\";i:0;s:9:\"form_type\";s:8:\"textarea\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:5;s:9:\"allowview\";N;}s:9:\"introduce\";a:14:{s:5:\"title\";s:8:\"ҽ\";s:10:\"field_name\";s:9:\"introduce\";s:10:\"field_type\";s:10:\"mediumtext\";s:10:\"field_leng\";i:0;s:9:\"form_type\";s:8:\"textarea\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:4;s:9:\"allowview\";N;}}s:7:\"is_html\";a:1:{s:7:\"content\";s:4:\"\";}s:11:\"listshow_db\";a:2:{s:8:\"truename\";s:8:\"ʵ\";s:3:\"sex\";s:4:\"Ա\";}}','3,4,8,9','0','<p><strong>м,,ǵİ!</strong></p>','0','0','','');
INSERT INTO `qb_form_module` VALUES ('2','Ƹ','0','','a:3:{s:8:\"field_db\";a:8:{s:9:\"workplace\";a:15:{s:5:\"title\";s:8:\"ְλ\";s:10:\"field_name\";s:9:\"workplace\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:100;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"30\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:2:\"10\";s:9:\"allowview\";N;}s:4:\"nums\";a:15:{s:5:\"title\";s:8:\"Ƹ\";s:10:\"field_name\";s:4:\"nums\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:10;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:1:\"4\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:2:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:1:\"9\";s:9:\"allowview\";N;}s:10:\"jobrequire\";a:15:{s:5:\"title\";s:14:\"ְλҪ\";s:10:\"field_name\";s:10:\"jobrequire\";s:10:\"field_type\";s:10:\"mediumtext\";s:10:\"field_leng\";i:0;s:9:\"form_type\";s:8:\"textarea\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:8;s:9:\"allowview\";N;}s:8:\"wageyear\";a:15:{s:5:\"title\";s:12:\"Ҫ\";s:10:\"field_name\";s:8:\"wageyear\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:12;s:9:\"form_type\";s:5:\"radio\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:40:\"Ӧҵ\r\nһ\r\n\r\n\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:7;s:9:\"allowview\";N;}s:9:\"workwhere\";a:15:{s:5:\"title\";s:8:\"ص\";s:10:\"field_name\";s:9:\"workwhere\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:6;s:9:\"allowview\";N;}s:4:\"wage\";a:15:{s:5:\"title\";s:8:\"нˮ\";s:10:\"field_name\";s:4:\"wage\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:30;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:5;s:9:\"allowview\";N;}s:6:\"asksex\";a:15:{s:5:\"title\";s:8:\"ԱҪ\";s:10:\"field_name\";s:6:\"asksex\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:1;s:9:\"form_type\";s:5:\"radio\";s:15:\"field_inputleng\";s:1:\"1\";s:8:\"form_set\";s:18:\"1|\r\n2|Ů\r\n0|\";s:10:\"form_value\";s:1:\"0\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:1:\"4\";s:9:\"allowview\";N;}s:9:\"schoo_age\";a:15:{s:5:\"title\";s:8:\"ѧҪ\";s:10:\"field_name\";s:9:\"schoo_age\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:6:\"select\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:46:\"Сѧ\r\nѧ\r\nר\r\n\r\nר\r\n\r\n˶ʿ\r\nʿ\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:4:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:1:\"3\";s:9:\"allowview\";N;}}s:7:\"is_html\";a:1:{s:7:\"content\";s:4:\"\";}s:11:\"listshow_db\";a:5:{s:8:\"wageyear\";s:12:\"Ҫ\";s:9:\"workplace\";s:8:\"ְλ\";s:4:\"nums\";s:8:\"Ƹ\";s:6:\"asksex\";s:8:\"ԱҪ\";s:9:\"schoo_age\";s:8:\"ѧҪ\";}}','','0','','0','1','','');
INSERT INTO `qb_form_module` VALUES ('3','Ͷ߽','0','','a:3:{s:8:\"field_db\";a:5:{s:10:\"advicetype\";a:15:{s:5:\"title\";s:8:\"Ͷ\";s:10:\"field_name\";s:10:\"advicetype\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:30;s:9:\"form_type\";s:5:\"radio\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:34:\"ǰͷ\r\nۺͷ\r\nƷ\r\n\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:2:\"10\";s:9:\"allowview\";N;}s:8:\"mobphone\";a:15:{s:5:\"title\";s:8:\"ĵ绰\";s:10:\"field_name\";s:8:\"mobphone\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:25;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"15\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:1:\"8\";s:9:\"allowview\";N;}s:5:\"email\";a:14:{s:5:\"title\";s:8:\"\";s:10:\"field_name\";s:5:\"email\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"15\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:7;s:9:\"allowview\";N;}s:7:\"content\";a:15:{s:5:\"title\";s:8:\"Ͷ\";s:10:\"field_name\";s:7:\"content\";s:10:\"field_type\";s:10:\"mediumtext\";s:10:\"field_leng\";i:0;s:9:\"form_type\";s:8:\"textarea\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:1:\"6\";s:9:\"allowview\";N;}s:8:\"truename\";a:15:{s:5:\"title\";s:8:\"ĳƺ\";s:10:\"field_name\";s:8:\"truename\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:15;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"10\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:1:\"8\";s:9:\"allowview\";N;}}s:7:\"is_html\";a:0:{}s:11:\"listshow_db\";a:2:{s:10:\"advicetype\";s:8:\"Ͷ\";s:8:\"truename\";s:8:\"ĳƺ\";}}','','0','','0','1','','3,4');
INSERT INTO `qb_form_module` VALUES ('4','','0','','a:3:{s:8:\"field_db\";a:6:{s:8:\"truename\";a:15:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:8:\"truename\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:15;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"10\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:10;s:9:\"allowview\";N;}s:3:\"sex\";a:14:{s:5:\"title\";s:4:\"Ա\";s:10:\"field_name\";s:3:\"sex\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:1;s:9:\"form_type\";s:5:\"radio\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:18:\"1|\r\n2|Ů\r\n0|\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:9;s:9:\"allowview\";N;}s:3:\"age\";a:15:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:3:\"age\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:2;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:1:\"2\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:2:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:8;s:9:\"allowview\";N;}s:8:\"mobphone\";a:14:{s:5:\"title\";s:8:\"ϵ绰\";s:10:\"field_name\";s:8:\"mobphone\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:25;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"12\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:7;s:9:\"allowview\";N;}s:7:\"my_song\";a:15:{s:5:\"title\";s:8:\"\";s:10:\"field_name\";s:7:\"my_song\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"30\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:6;s:9:\"allowview\";N;}s:6:\"metier\";a:15:{s:5:\"title\";s:4:\"ְҵ\";s:10:\"field_name\";s:6:\"metier\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:30;s:9:\"form_type\";s:6:\"select\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:32:\"Ա\r\n\r\nԱ\r\nʦ\r\n\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:5;s:9:\"allowview\";N;}}s:7:\"is_html\";a:2:{s:7:\"content\";s:4:\"\";s:5:\"my_88\";s:13:\"ҵֶmy_88\";}s:11:\"listshow_db\";a:4:{s:8:\"truename\";s:4:\"\";s:3:\"age\";s:4:\"\";s:6:\"metier\";s:4:\"ְҵ\";s:7:\"my_song\";s:8:\"\";}}','','0','<p>&nbsp;&nbsp; ΪлԱԱվ֧֣صؾеһ質ӭӻԾμӡ£</p>\r\n<p><strong>ʱ䣺</strong>Ӽ𡪡94800ֹ</p>\r\n<p><strong>Ŀʱ䣺</strong>95ţһ8301100</p>\r\n<p><strong>Ҫ</strong>עԱ豸˵ڱ̳עֵ½.</p>\r\n<p><strong>Ŀ</strong>ѡ峪 ɴݳ</p>\r\n<p><strong>ί</strong>˳Ƽ˳ټίе    ߻ϼԱ</p>\r\n<p><strong>ѡʽ</strong>ڱлԱڴͶƱÿͶ2ƱͶƱʱ6죬ȴ951101911800ֹίͳƱѡƱǰ</p>\r\n<p><strong></strong>ڻǰĸ֣費̶ͬȵͻֽ</p>\r\n<p>ڱʱҪ󣬽ݴұ˳򣬺ʱ䣬Ϊݳ˳򣬽941000ǰڸͷ֪ͨʽμӴ˴αѡݳ˳</p>\r\n<p><strong>֣</strong> α</p>','0','1','','');
INSERT INTO `qb_form_module` VALUES ('6','ְ','0','','a:3:{s:8:\"field_db\";a:16:{s:12:\"workposition\";a:15:{s:5:\"title\";s:8:\"ְλ\";s:10:\"field_name\";s:12:\"workposition\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"30\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";s:2:\"21\";s:9:\"allowview\";N;}s:8:\"truename\";a:15:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:8:\"truename\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:15;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"10\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:20;s:9:\"allowview\";N;}s:3:\"sex\";a:15:{s:5:\"title\";s:4:\"Ա\";s:10:\"field_name\";s:3:\"sex\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:1;s:9:\"form_type\";s:5:\"radio\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:18:\"1|\r\n2|Ů\r\n0|\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:19;s:9:\"allowview\";N;}s:5:\"myage\";a:15:{s:5:\"title\";s:4:\"\";s:10:\"field_name\";s:5:\"myage\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:2;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:1:\"2\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:2:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:18;s:9:\"allowview\";N;}s:9:\"schoo_age\";a:15:{s:5:\"title\";s:4:\"ѧ\";s:10:\"field_name\";s:9:\"schoo_age\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:15;s:9:\"form_type\";s:6:\"select\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:45:\"\r\nר\r\n\r\nר\r\n\r\n˶ʿ\r\nʿ\r\nMBA\";s:10:\"form_value\";s:4:\"ר\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:17;s:9:\"allowview\";N;}s:14:\"graduateschool\";a:15:{s:5:\"title\";s:8:\"ҵѧУ\";s:10:\"field_name\";s:14:\"graduateschool\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:40;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"15\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:16;s:9:\"allowview\";N;}s:9:\"specialty\";a:15:{s:5:\"title\";s:4:\"רҵ\";s:10:\"field_name\";s:9:\"specialty\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"20\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:15;s:9:\"allowview\";N;}s:5:\"skill\";a:15:{s:5:\"title\";s:4:\"س\";s:10:\"field_name\";s:5:\"skill\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"20\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:14;s:9:\"allowview\";N;}s:8:\"workyear\";a:15:{s:5:\"title\";s:8:\"\";s:10:\"field_name\";s:8:\"workyear\";s:10:\"field_type\";s:3:\"int\";s:10:\"field_leng\";i:2;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:1:\"2\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:2:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"1\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:13;s:9:\"allowview\";N;}s:10:\"experience\";a:15:{s:5:\"title\";s:8:\"\";s:10:\"field_name\";s:10:\"experience\";s:10:\"field_type\";s:10:\"mediumtext\";s:10:\"field_leng\";i:2;s:9:\"form_type\";s:8:\"textarea\";s:15:\"field_inputleng\";s:1:\"2\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:12;s:9:\"allowview\";N;}s:4:\"wage\";a:15:{s:5:\"title\";s:8:\"н\";s:10:\"field_name\";s:4:\"wage\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:20;s:9:\"form_type\";s:6:\"select\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:73:\"\r\n1000Ԫ\r\n1000Ԫ-2000Ԫ\r\n2000Ԫ-3000Ԫ\r\n3000Ԫ-4000Ԫ\r\n4000Ԫ\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:11;s:9:\"allowview\";N;}s:7:\"address\";a:15:{s:5:\"title\";s:10:\"ǰס\";s:10:\"field_name\";s:7:\"address\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:255;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"70\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:10;s:9:\"allowview\";N;}s:9:\"telephone\";a:15:{s:5:\"title\";s:8:\"ϵ绰\";s:10:\"field_name\";s:9:\"telephone\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:25;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:9;s:9:\"allowview\";N;}s:5:\"email\";a:15:{s:5:\"title\";s:8:\"ϵ\";s:10:\"field_name\";s:5:\"email\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:50;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:2:\"20\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:8;s:9:\"allowview\";N;}s:4:\"oicq\";a:15:{s:5:\"title\";s:6:\"QQ\";s:10:\"field_name\";s:4:\"oicq\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:11;s:9:\"form_type\";s:4:\"text\";s:15:\"field_inputleng\";s:1:\"9\";s:8:\"form_set\";s:0:\"\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"0\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:7;s:9:\"allowview\";N;}s:8:\"worktime\";a:15:{s:5:\"title\";s:8:\"\";s:10:\"field_name\";s:8:\"worktime\";s:10:\"field_type\";s:7:\"varchar\";s:10:\"field_leng\";i:15;s:9:\"form_type\";s:5:\"radio\";s:15:\"field_inputleng\";s:0:\"\";s:8:\"form_set\";s:34:\"ʱ\r\n1\r\n2\r\n3\r\n1\";s:10:\"form_value\";s:0:\"\";s:10:\"form_units\";s:0:\"\";s:10:\"form_title\";s:0:\"\";s:8:\"mustfill\";s:1:\"1\";s:8:\"listshow\";s:1:\"0\";s:6:\"search\";s:1:\"0\";s:9:\"orderlist\";i:6;s:9:\"allowview\";N;}}s:7:\"is_html\";a:1:{s:7:\"content\";s:4:\"\";}s:11:\"listshow_db\";a:7:{s:6:\"my_537\";s:8:\"\";s:6:\"my_425\";s:8:\"\";s:8:\"truename\";s:4:\"\";s:5:\"myage\";s:4:\"\";s:8:\"workyear\";s:8:\"\";s:3:\"sex\";s:4:\"Ա\";s:12:\"workposition\";s:8:\"ְλ\";}}','','0','','0','1','¼','');
INSERT INTO `qb_form_reply` VALUES ('6','25','3','1237255555','1','admin','<p><u>yyyyyy</u></p>\r\n<p><u>yyyyyyyy</u></p><strong>\r\n<hr width=\"100%\" color=#98fb98 SIZE=1 />\r\n</strong>','192.168.0.99');
INSERT INTO `qb_form_reply` VALUES ('10','27','3','1239591974','1','admin','ffffffffffff ','192.168.0.99');
INSERT INTO `qb_friendlink` VALUES ('12','0','PHPWINDٷ̳','http://www.phpwind.net/','http://www.phpwind.net/logo.gif','PHPWINDٷ̳','32','0','0','0','0','0','','1','0');
INSERT INTO `qb_friendlink` VALUES ('5','0','벩CMS','http://www.qibosoft.com','../images/default/friendlink.gif','CMSվϵͳṩ','40','0','0','0','0','0','','1','0');
INSERT INTO `qb_friendlink` VALUES ('18','3','','http://www.sudu.cn/','','','25','0','0','0','0','0','','1','0');
INSERT INTO `qb_friendlink` VALUES ('25','2','վ','http://admin5.com/','friendlink/1_20090418160400_wqpAk.gif','վ','37','0','0','0','0','0','','1','0');
INSERT INTO `qb_friendlink` VALUES ('26','2','йվվ','http://www.chinaz.com/','friendlink/1_20090418160432_JNCry.gif','йվվ','38','0','0','0','0','0','','1','0');
INSERT INTO `qb_friendlink` VALUES ('27','2','WEB','http://www.cncms.com.cn/','friendlink/1_20090418160451_64IKO.gif','WEB','34','0','0','0','0','0','','1','0');
INSERT INTO `qb_friendlink` VALUES ('29','2','е绪ͨ','http://www.chinaccnet.com/','','е绪ͨ','0','0','0','0','0','0','','1','0');
INSERT INTO `qb_friendlink` VALUES ('34','3','CNZZ','http://www.cnzz.cn/','','CNZZ','26','0','0','0','0','0','','1','0');
INSERT INTO `qb_friendlink_sort` VALUES ('2','','0');
INSERT INTO `qb_friendlink_sort` VALUES ('3','','0');
INSERT INTO `qb_guestbook_content` VALUES ('12','0','1','','','','','1','admin','192.168.0.99','ǿƽվ̨ķ:޸/data/global.phpļ,$ForceEnter=0;0ĳ1,ǿƽվĺ̨.','1','1240206881','1240206881','','');
INSERT INTO `qb_guestbook_content` VALUES ('13','0','1','','','','','1','admin','192.168.0.99','ͨԱΪԱķ,޸ļ/data/admin.php,ߵʺŸһ¼','1','1240206958','1240206958','','');
INSERT INTO `qb_guestbook_content` VALUES ('14','0','1','','','','','1','admin','192.168.0.99','վϵͳݿļ/data/mysql_config.php','1','1240207079','1240207079','','');
INSERT INTO `qb_guestbook_content` VALUES ('15','0','1','','','','','1','admin','192.168.0.99','ĬϴļСΪ2M,޸ķ.վϵͳϴ2Mļ.ǲԵ.޸ķ.һ˵PHPļc:\\windows\\php.ini.','1','1240207216','1240207216','','');
INSERT INTO `qb_guestbook_content` VALUES ('16','0','1','','','','','1','admin','192.168.0.99','.޷ʹòɼ.','1','1240207330','1240207330','','');
INSERT INTO `qb_guestbook_sort` VALUES ('1','0','չ','0','1','0','0','','0','0','','','','','','','0','','','','0','','','','','0','b:0;','0','0','','','0');
INSERT INTO `qb_guestbook_sort` VALUES ('2','0','Ͷ','0','1','0','0','','0','0','','','','','','','0','','','','1','','','','','0','','0','0','','','0');
INSERT INTO `qb_guestbook_config` VALUES ('module_id','18','');
INSERT INTO `qb_guestbook_config` VALUES ('GuestBookNum','20','');
INSERT INTO `qb_guestbook_config` VALUES ('groupPassPassGuestBook','3,4','');
INSERT INTO `qb_guestbook_config` VALUES ('viewNoPassGuestBook','0','');
INSERT INTO `qb_guestbook_config` VALUES ('yzImgGuestBook','1','');
INSERT INTO `qb_guestbook_config` VALUES ('module_pre','guestbook_','');
INSERT INTO `qb_guestbook_config` VALUES ('ifOpenGuestBook','1','');
INSERT INTO `qb_guestbook_config` VALUES ('Info_webname','Ա','');
INSERT INTO `qb_guestbook_config` VALUES ('Info_webOpen','1','');
INSERT INTO `qb_limitword` VALUES ('1','췴','**');
INSERT INTO `qb_limitword` VALUES ('2','ֹ','**');
INSERT INTO `qb_ad_norm_place` VALUES ('1','article_list','бҳ','code','0','0','0','a:5:{s:4:\"word\";s:0:\"\";s:6:\"picurl\";s:0:\"\";s:7:\"linkurl\";s:0:\"\";s:8:\"flashurl\";s:0:\"\";s:4:\"code\";s:0:\"\";}','0','0','0','0','0','5','0','1','/do/job.php?job=jump&pagetype=list');
INSERT INTO `qb_ad_norm_place` VALUES ('10','article_content','ߵĹ','pic','1','0','0','a:8:{s:4:\"word\";s:0:\"\";s:6:\"picurl\";s:32:\"other/1_20090326120324_mnfIi.jpg\";s:7:\"linkurl\";s:22:\"http://www.qibosoft.com/\";s:8:\"flashurl\";s:0:\"\";s:4:\"code\";s:0:\"\";s:5:\"width\";s:3:\"400\";s:6:\"height\";s:3:\"400\";s:9:\"pictarget\";s:5:\"blank\";}','0','0','0','0','0','5','1','1','/do/job.php?job=jump&pagetype=bencandy');
INSERT INTO `qb_ad_norm_place` VALUES ('2','article_show','ҳ·','code','0','0','0','a:5:{s:4:\"word\";s:0:\"\";s:6:\"picurl\";s:0:\"\";s:7:\"linkurl\";s:0:\"\";s:8:\"flashurl\";s:0:\"\";s:4:\"code\";s:1782:\"<div style=\"LINE-HEIGHT: 150%\"><a href=\"http://www.zxx6.com/\" target=_blank><font color=#ff0000><strong>վѧϰ</strong></font></a> <a href=\"http://www.angelyyl.cn/\" target=_blank></a><a href=\"http://www.czin.cn/\" target=_blank><br />ߡ˵ϼ԰</a> <br /><a href=\"http://www.sy50.com/\" target=_blank> ˽ </a> <br /><a href=\"http://www.771881.cn/\" target=_blank>㱧-Ůͬ-ܼŮվ </a><br /><a href=\"http://www.aihut.com/\" target=_blank>Сԭ </a><br /><a href=\"http://www.popyule.com/\" target=_blank>--ۺվqibosoft</a> <br /><a href=\"http://www.china551.cn/\" target=_blank><font color=#ff0000></font></a> <a href=\"http://www.ym988.com/\" target=_blank>Բģ幤 </a><br /><a href=\"http://www.welights.com/\" target=_blank>ʵƾ</a> <a href=\"http://www.hnmssy.cn/\" target=_blank>Ӱ</a> <br /><a href=\"http://www.nuoyue.net/\" target=_blank><font color=#ff0000>ŵԾվ - վѧϰĺõط</font></a> <br /><a href=\"http://www.qzfl.com/\" target=_blank>Ȫݷ ȪϢ</a> <br /><a href=\"http://www.stmsn.com/\" target=_blank>й</a> <a href=\"http://www.downcc.cn/\" target=_blank>󵱼վ </a><br /><a href=\"http://www.yt12333.cn/\" target=_blank>Ͷ籣֮-ͤͶ</a> <br /><a href=\"http://www.gooyi.cn/\" target=_blank> - Ż </a><br /><a href=\"http://www.idercn.com/\" target=_blank>I.D.</a> <a href=\"http://www.tz0632.com/\" target=_blank>ݳ</a> <a href=\"http://www.doubar.com/\" target=_blank> </a></div>\r\n<div style=\"LINE-HEIGHT: 150%\"><a href=\"http://www.wfseo.org/\" target=_blank><font color=#d2691e>վŻ</font><br /></a><br /></div>\";}','0','0','0','0','0','5','0','1','/do/job.php?job=jump&pagetype=bencandy');
INSERT INTO `qb_ad_norm_place` VALUES ('11','digg_list','а߹','code','0','0','0','a:5:{s:4:\"word\";s:0:\"\";s:6:\"picurl\";s:0:\"\";s:7:\"linkurl\";s:0:\"\";s:8:\"flashurl\";s:0:\"\";s:4:\"code\";s:813:\"<div style=\"LINE-HEIGHT: 200%\"><a href=\"http://www.ibioo.com/\" target=_blank><font color=#ff0000>̹--߻վ!</font> </a><br /><a href=\"http://www.51solo.net/\" target=_blank>Żҿʼ </a><br /><a href=\"http://1.com/45/admin/www.china-highway.com\" target=_blank>·߾йٹ· </a><br /><a href=\"http://www.nenbei.com/\" target=_blank><font color=#ff0000>۱ۺӭĵ </font></a><br /><a href=\"http://www.liuv.net/\" target=_blank><font color=#ff0000>ˮ</font></a> <br /><a href=\"http://www.fming.net/\" target=_blank>ԭ ѧӰĴƽ̨ </a><br /><a href=\"http://www.netchinatown.com/\" target=_blank>ʱƳ-⻪˾Ӣ԰ </a><br /><a href=\"http://frp.ok586.cn/\" target=_blank>Ϻȴרҵ. </a></div>\";}','0','0','0','0','0','5','0','1','/do/digg.php');
INSERT INTO `qb_ad_norm_place` VALUES ('19','list_page_topad','бҳ߶λ','pic','0','0','0','a:8:{s:4:\"word\";s:0:\"\";s:6:\"picurl\";s:13:\"ad/listad.jpg\";s:7:\"linkurl\";s:22:\"http://www.yeepay.com/\";s:8:\"flashurl\";s:0:\"\";s:4:\"code\";s:0:\"\";s:5:\"width\";s:3:\"290\";s:6:\"height\";s:3:\"130\";s:9:\"pictarget\";s:5:\"blank\";}','0','0','0','4','0','10','1','1','/do/job.php?job=jump&pagetype=list');
INSERT INTO `qb_ad_norm_place` VALUES ('18','show_topad','ҳ','pic','0','0','0','a:8:{s:4:\"word\";s:0:\"\";s:6:\"picurl\";s:18:\"ad/ad_show_top.jpg\";s:7:\"linkurl\";s:22:\"http://www.yeepay.com/\";s:8:\"flashurl\";s:0:\"\";s:4:\"code\";s:0:\"\";s:5:\"width\";s:3:\"980\";s:6:\"height\";s:2:\"60\";s:9:\"pictarget\";s:5:\"blank\";}','0','0','0','0','0','10','1','1','../do/job.php?job=jump&pagetype=bencandy');
INSERT INTO `qb_ad_norm_place` VALUES ('17','show_right_top_picad','ҳ߶ͼƬλ','pic','0','0','0','a:8:{s:4:\"word\";s:0:\"\";s:6:\"picurl\";s:15:\"ad/qyshowad.jpg\";s:7:\"linkurl\";s:43:\"http://www.qy.com.cn/idc/product_double.asp\";s:8:\"flashurl\";s:0:\"\";s:4:\"code\";s:0:\"\";s:5:\"width\";s:3:\"290\";s:6:\"height\";s:3:\"110\";s:9:\"pictarget\";s:5:\"blank\";}','0','0','0','29','0','10','1','1','/do/job.php?job=jump&pagetype=bencandy');
INSERT INTO `qb_ad_norm_place` VALUES ('20','AD_list_topad','бҳ','pic','0','0','0','a:8:{s:4:\"word\";s:0:\"\";s:6:\"picurl\";s:14:\"ad/cnidca1.gif\";s:7:\"linkurl\";s:21:\"http://www.cnidc.com/\";s:8:\"flashurl\";s:0:\"\";s:4:\"code\";s:0:\"\";s:5:\"width\";s:3:\"980\";s:6:\"height\";s:2:\"60\";s:9:\"pictarget\";s:5:\"blank\";}','0','0','0','4','0','10','1','1','/do/list.php?fid=1');
INSERT INTO `qb_ad_norm_place` VALUES ('21','sp_show_ad','רҳλ','code','0','0','0','a:5:{s:4:\"word\";s:0:\"\";s:6:\"picurl\";s:0:\"\";s:7:\"linkurl\";s:0:\"\";s:8:\"flashurl\";s:0:\"\";s:4:\"code\";s:943:\"<div style=\"LINE-HEIGHT: 150%\"><a href=\"http://3cq.org/\" target=_blank>׶ һΪǵĺ</a> <br /><a href=\"http://www.liuv.net/\" target=_blank>ˮ</a> <br /><a href=\"http://www.21yao.com/\" target=_blank>ҽҩ</a><br /><a href=\"http://www.fming.net/\" target=_blank>ԭ</a> <br /><a href=\"http://www.jnrx.net/\" target=_blank></a> <br /><a href=\"http://www.7mt.cn/\" target=_blank>Ħ-йһĦгý </a><br /><a href=\"http://www.hnpolice.net/\" target=_blank>ϹߵרѧУУѻ </a><br /><a href=\"http://www.seo178.com/\" target=_blank>SEOѵѡ--SEOѵ</a> <br /><a href=\"http://www.51solo.net/\" target=_blank>Ʒƹ,SEOվŻ </a><br /><a href=\"http://www.kljy.cn/\" target=_blank>ڶͯ </a><br /><a href=\"http://www.eia8.com/job/\" target=_blank>йƸְ</a> <br /><a href=\"http://www.wenzhang8.com/\" target=_blank>° þ </a> </div>\";}','0','0','0','0','0','0','0','1','/do/showsp.php?fid=1&id=23');
INSERT INTO `qb_ad_config` VALUES ('module_pre','ad_','');
INSERT INTO `qb_ad_config` VALUES ('Info_webname','ϵͳ','');
INSERT INTO `qb_ad_config` VALUES ('Info_webOpen','1','');
INSERT INTO `qb_ad_config` VALUES ('module_close','0','');
INSERT INTO `qb_ad_config` VALUES ('module_id','24','');
INSERT INTO `qb_ad_compete_place` VALUES ('3','ҳ۹','0','0','50','5','8','36','1','/do/digg.php');
INSERT INTO `qb_ad_compete_user` VALUES ('11','1','admin','1239277578','1239709578','50','3','1','http://www.qibosoft.com/','벩ٷվ','0','','0');
INSERT INTO `qb_ad_compete_user` VALUES ('12','1','admin','1239279810','1239711810','50','3','1','http://www.qibosoft.com/bbs','벩ٷ̳','0','','0');
INSERT INTO `qb_upfile` VALUES ('1','0','0','0','1','1305779339','article/9','tmp-1_20110519120559_MTMzMzEwNFoyLTA=.jpg','1','1');
INSERT INTO `qb_upfile` VALUES ('2','31','1323','9','1','1305779408','qb_photo_/9/1_20110519120559_MTMzMzEwNFoyLTA=.jpg','1_20110519120559_MTMzMzEwNFoyLTA=.jpg','1','0');
INSERT INTO `qb_upfile` VALUES ('3','31','1323','9','1','1305779408','article/9/1_20110519120559_MTMzMzEwNFoyLTA=.jpg.jpg','1_20110519120559_MTMzMzEwNFoyLTA=.jpg.jpg','1','0');
INSERT INTO `qb_upfile` VALUES ('4','31','1323','9','1','1305779408','article/9/1_20110519120559_MTMzMzEwNFoyLTA=.jpg.jpg.jpg','1_20110519120559_MTMzMzEwNFoyLTA=.jpg.jpg.jpg','1','0');
INSERT INTO `qb_upfile` VALUES ('5','0','0','0','1','1305779467','article/9','tmp-1_20110519120507_MTMzMzEwNFoyLTA=.jpg','1','1');
INSERT INTO `qb_upfile` VALUES ('6','31','1323','9','1','1305779532','qb_photo_/9/1_20110519120507_MTMzMzEwNFoyLTA=.jpg','1_20110519120507_MTMzMzEwNFoyLTA=.jpg','1','0');
INSERT INTO `qb_upfile` VALUES ('7','31','1323','9','1','1305779532','article/9/1_20110519120507_MTMzMzEwNFoyLTA=.jpg.jpg','1_20110519120507_MTMzMzEwNFoyLTA=.jpg.jpg','1','0');
INSERT INTO `qb_upfile` VALUES ('8','31','1323','9','1','1305779532','article/9/1_20110519120507_MTMzMzEwNFoyLTA=.jpg.jpg.jpg','1_20110519120507_MTMzMzEwNFoyLTA=.jpg.jpg.jpg','1','0');
INSERT INTO `qb_upfile` VALUES ('9','0','0','0','1','1305780247','article/9','tmp-1_20110519120507_MTMzMzEwNFoyLTA=.jpg','1','1');
INSERT INTO `qb_upfile` VALUES ('10','0','0','0','1','1305782093','article/9','tmp-1_20110519130553_MTMzMzEwNFoyLTA=.jpg','1','1');
INSERT INTO `qb_upfile` VALUES ('11','31','1323','9','1','1305782134','qb_photo_/9/1_20110519130553_MTMzMzEwNFoyLTA=.jpg','1_20110519130553_MTMzMzEwNFoyLTA=.jpg','1','0');
INSERT INTO `qb_upfile` VALUES ('12','31','1323','9','1','1305782134','qb_photo_/9/1_20110519130553_MTMzMzEwNFoyLTA=.jpg.jpg','1_20110519130553_MTMzMzEwNFoyLTA=.jpg.jpg','1','0');
INSERT INTO `qb_upfile` VALUES ('13','31','1323','9','1','1305782134','qb_photo_/9/1_20110519130553_MTMzMzEwNFoyLTA=.jpg.jpg.jpg','1_20110519130553_MTMzMzEwNFoyLTA=.jpg.jpg.jpg','1','0');
INSERT INTO `qb_upfile` VALUES ('14','0','0','0','1','1305792915','article/7','tmp-1_20110519160515_MTMzMzEwNFoyLTA=.jpg','1','1');
INSERT INTO `qb_upfile` VALUES ('15','0','0','0','1','1305792943','article/7','tmp-1_20110519160543_MTMzMzEwNFoyLTA=.jpg','1','1');
INSERT INTO `qb_upfile` VALUES ('16','0','0','0','1','1305856949','other','tmp-1_20110520100529_MDZDODRDOTdCOEYyNEEyNkE2QzA1QjRCQzVCRTQ3OTQyMDA2MDgwMjE3NTI=.jpg','1','1');
INSERT INTO `qb_upfile` VALUES ('17','0','0','0','1','1305856952','other','tmp-1_20110520100532_MDA0.jpg','1','1');
INSERT INTO `qb_upfile` VALUES ('18','31','','12','1','1305856960','qb_photo_/12/1_20110520100529_MDZDODRDOTdCOEYyNEEyNkE2QzA1QjRCQzVCRTQ3OTQyMDA2MDgwMjE3NTI=.jpg','1_20110520100529_MDZDODRDOTdCOEYyNEEyNkE2QzA1QjRCQzVCRTQ3OTQyMDA2MDgwMjE3NTI=.jpg','1','0');
INSERT INTO `qb_upfile` VALUES ('19','31','','12','1','1305856960','qb_photo_/12/1_20110520100532_MDA0.jpg','1_20110520100532_MDA0.jpg','1','0');
INSERT INTO `qb_upfile` VALUES ('21','0','0','0','1','1305869215','other','tmp-1_20110520130555_NGFiN2ZkY2ZnNjU2ZmE4MjdmN2U0.jpg','1','1');
INSERT INTO `qb_upfile` VALUES ('22','0','0','0','1','1305869215','other','tmp-1_20110520130555_NGFiN2ZkY2ZnNjU2MjkyNzQ5OGI0.jpg','1','1');
INSERT INTO `qb_upfile` VALUES ('23','0','0','0','1','1305869216','other','tmp-1_20110520130556_MDRBRTlCQUE3MzkyNDZBNDkxODI5RTdERDU4RjAzODcyMDA2MDgwMzExNDc=.jpg','1','1');
INSERT INTO `qb_upfile` VALUES ('24','0','0','0','1','1305869216','other','tmp-1_20110520130556_NGJjZGNkZGE4YzhjNGQ1NzkzOTEwMDkwY2FiMWM1MmNfZmFuV0RaU0VIb2hl.jpg','1','1');
INSERT INTO `qb_upfile` VALUES ('25','0','0','0','1','1305869216','other','tmp-1_20110520130556_MDA1.jpg','1','1');
INSERT INTO `qb_upfile` VALUES ('26','31','0','12','1','1305869219','qb_photo_/12/1_20110520130555_NGFiN2ZkY2ZnNjU2ZmE4MjdmN2U0.jpg','1_20110520130555_NGFiN2ZkY2ZnNjU2ZmE4MjdmN2U0.jpg','1','0');
INSERT INTO `qb_upfile` VALUES ('27','31','0','12','1','1305869219','qb_photo_/12/1_20110520130555_NGFiN2ZkY2ZnNjU2MjkyNzQ5OGI0.jpg','1_20110520130555_NGFiN2ZkY2ZnNjU2MjkyNzQ5OGI0.jpg','1','0');
INSERT INTO `qb_upfile` VALUES ('28','31','0','12','1','1305869219','qb_photo_/12/1_20110520130556_MDRBRTlCQUE3MzkyNDZBNDkxODI5RTdERDU4RjAzODcyMDA2MDgwMzExNDc=.jpg','1_20110520130556_MDRBRTlCQUE3MzkyNDZBNDkxODI5RTdERDU4RjAzODcyMDA2MDgwMzExNDc=.jpg','1','0');
INSERT INTO `qb_upfile` VALUES ('29','31','0','12','1','1305869219','qb_photo_/12/1_20110520130556_NGJjZGNkZGE4YzhjNGQ1NzkzOTEwMDkwY2FiMWM1MmNfZmFuV0RaU0VIb2hl.jpg','1_20110520130556_NGJjZGNkZGE4YzhjNGQ1NzkzOTEwMDkwY2FiMWM1MmNfZmFuV0RaU0VIb2hl.jpg','1','0');
INSERT INTO `qb_upfile` VALUES ('30','31','0','12','1','1305869219','qb_photo_/12/1_20110520130556_MDA1.jpg','1_20110520130556_MDA1.jpg','1','0');
INSERT INTO `qb_upfile` VALUES ('32','0','0','0','1','1306133424','other','tmp-1_20110523140524_MV9CNGpyZlhnM0cyQWY=.jpg','1','1');
INSERT INTO `qb_upfile` VALUES ('33','0','0','0','1','1306133424','other','tmp-1_20110523140524_MV9GcEYwV1I5Z2c0SFM=.jpg','1','1');
INSERT INTO `qb_upfile` VALUES ('34','31',',1463','2','1','1306133430','qb_photo_/2/201105/1_20110523140524_MV9CNGpyZlhnM0cyQWY=.jpg','1_20110523140524_MV9CNGpyZlhnM0cyQWY=.jpg','2','0');
INSERT INTO `qb_upfile` VALUES ('35','31',',1463','2','1','1306133430','qb_photo_/2/201105/1_20110523140524_MV9GcEYwV1I5Z2c0SFM=.jpg','1_20110523140524_MV9GcEYwV1I5Z2c0SFM=.jpg','2','0');
INSERT INTO `qb_upfile` VALUES ('36','31','','2','1','1306133430','qb_photo_/2/201105/1_20110523140524_MV9CNGpyZlhnM0cyQWY=.jpg.jpg','1_20110523140524_MV9CNGpyZlhnM0cyQWY=.jpg.jpg','1','0');
INSERT INTO `qb_upfile` VALUES ('37','0','0','0','1','1306133478','article/2','tmp-1_20110523140518_MDZfejk3UjBUWFlIQU5U.jpg','1','1');
INSERT INTO `qb_upfile` VALUES ('38','31','1463','2','1','1306133483','qb_photo_/2/201105/1_20110523140518_MDZfejk3UjBUWFlIQU5U.jpg','1_20110523140518_MDZfejk3UjBUWFlIQU5U.jpg','1','0');
INSERT INTO `qb_upfile` VALUES ('39','0','0','0','1','1306133497','article/2','tmp-1_20110523140537_M19UWDRiVnpsNnljRXk=.jpg','1','1');
INSERT INTO `qb_upfile` VALUES ('40','0','0','0','1','1306133507','article/2','tmp-1_20110523140547_NTk3LTI4NTMtMA==.jpg','1','1');
INSERT INTO `qb_upfile` VALUES ('41','31','1463','2','1','1306133530','qb_photo_/2/201105/1_20110523140547_NTk3LTI4NTMtMA==.jpg','1_20110523140547_NTk3LTI4NTMtMA==.jpg','1','0');
INSERT INTO `qb_upfile` VALUES ('42','31','1463','2','1','1306133530','qb_photo_/2/201105/1_20110523140547_NTk3LTI4NTMtMA==.jpg.jpg','1_20110523140547_NTk3LTI4NTMtMA==.jpg.jpg','1','0');
INSERT INTO `qb_upfile` VALUES ('43','31','1463','2','1','1306133530','qb_photo_/2/201105/1_20110523140547_NTk3LTI4NTMtMA==.jpg.jpg.jpg','1_20110523140547_NTk3LTI4NTMtMA==.jpg.jpg.jpg','1','0');
INSERT INTO `qb_vote_element` VALUES ('37','6','','4','10','','','');
INSERT INTO `qb_vote_element` VALUES ('38','6','','4','7','','','');
INSERT INTO `qb_vote_element` VALUES ('39','6','','2','5','','','');
INSERT INTO `qb_vote_element` VALUES ('41','6','','6','6','','','');
INSERT INTO `qb_vote_element` VALUES ('81','11','Աϲ','0','4','vote/1_20090418220434_DSazk.jpg','','http://www.admin5.com/article/20081231/124093.shtml');
INSERT INTO `qb_vote_element` VALUES ('80','11','Chinaz֮CNIDC','0','9','vote/1_20090419090435_51j39.jpg','','http://www.admin5.com/article/20081231/124093.shtml');
INSERT INTO `qb_vote_element` VALUES ('68','6','','12','9','','','');
INSERT INTO `qb_vote_element` VALUES ('70','10','ٶȷ˿','6','0','vote/1_20090317160304_1cyPh.gif','ǰٶȷ˿','http://www.baidu.com');
INSERT INTO `qb_vote_element` VALUES ('71','10','ȸ˿','2','0','vote/1_20090317160317_NO50S.gif','ǹȸ˿','http://www.google.cn');
INSERT INTO `qb_vote_element` VALUES ('72','11','SNS','1','8','vote/1_20090419090425_nkqeB.jpg','','http://www.admin5.com/article/20081231/124093.shtml');
INSERT INTO `qb_vote_element` VALUES ('73','11','CNײ˵','2','10','vote/1_20090419090455_L5Iz8.jpg','','http://www.admin5.com/article/20081231/124093.shtml');
INSERT INTO `qb_vote_element` VALUES ('74','11','ž','1','3','vote/1_20090419090414_BVe9o.jpg','','http://www.admin5.com/article/20081231/124093.shtml');
INSERT INTO `qb_vote_element` VALUES ('75','11','ѻ԰','2','6','vote/1_20090419090445_qQiaW.jpg','','http://www.admin5.com/article/20081231/124093.shtml');
INSERT INTO `qb_vote_element` VALUES ('76','11','ȫվ','2','5','vote/1_20090419090445_QVf6M.jpg','','http://www.admin5.com/article/20081231/124093.shtml');
INSERT INTO `qb_vote_element` VALUES ('77','11','','0','7','vote/1_20090419090459_1MkWx.jpg','','http://bbs.chinaz.com/Shuiba/thread-1240750-1-1.html');
INSERT INTO `qb_vote_element` VALUES ('82','12','еƼ','11','0','vote/1_20101109161100_eooqn.jpg','','http://www.chinaccnet.com/');
INSERT INTO `qb_vote_element` VALUES ('83','12','','11','0','vote/1_20101109161103_nulvn.jpg','','http://www.sudu.cn/');
INSERT INTO `qb_vote_element` VALUES ('84','12','ȺӢ','11','0','vote/1_20101109161108_q5bre.jpg','','http://www.qy.com.cn/');
INSERT INTO `qb_vote_element` VALUES ('85','12','371','12','0','vote/1_20101109161112_omvjo.jpg','','http://www.371.com/');
INSERT INTO `qb_vote_element` VALUES ('86','12','','11','0','vote/1_20101109161116_zlkqh.jpg','','http://www.zwidc.com/');
INSERT INTO `qb_vote_element` VALUES ('87','12','ǻԻ','11','0','vote/1_20101109161120_ylaj7.jpg','','http://www.eydns.com/');
INSERT INTO `qb_vote_topic` VALUES ('6','Щǰֵ֧','Щǰֺ֧Ӱ쵽ģ','2','600','0','','1164793927','','1233749543','1265256743','0','1','<div class=\"voteid\" title=\"$describes\">{$button}{$title}({$votenum})</div>','0','0','0');
INSERT INTO `qb_vote_topic` VALUES ('11','2008йվʮ¼ͶƱ','-------Ϊ2008ŵվ¼ͶһƱ.','2','500','0','','1237281523','','1233749543','1580789543','0','1','<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"width:118px;float:left;margin-top:4px;\" class=\"voteid\">\r\n  <tr> \r\n    <td align=\"center\"><A HREF=\"$url\" target=\"_blank\" style=\"border:1px solid #ccc;display:block;width:100px;height:75px;\"><img alt=\"{$title}\" style=\"border:1px solid #fff;\" src=\"$img\" border=\"0\" width=\"100\" height=\"75\"></A></td>\r\n  </tr>\r\n  <tr> \r\n    <td align=\"center\">\r\n      <div  style=\"width:110px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap;\">{$button}(<b><font color=\"#FF0000\" >{$votenum}</font></b>)<a HREF=\"$url\" target=\"_blank\" title=\"{$title}\">{$title}</a></div>\r\n    </td>\r\n  </tr>\r\n  <tr> \r\n    <td>{$describes}</td>\r\n  </tr>\r\n  <tr> \r\n    <td></td>\r\n  </tr>\r\n</table>\r\n\r\n','1','0','0');
INSERT INTO `qb_vote_topic` VALUES ('10','ĸ?','ϲʹĸ,ͶһƱ?','1','15','0','','1237275830','','0','0','0','1','<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" style=\"width:90px;float:left;\">\r\n  <tr> \r\n    <td align=\"center\" valign=\"middle\" style=\"line-height:40px;\"> <a href=\"$url\" target=_blank> \r\n      <b>$title</b></a> </td>\r\n  </tr>\r\n  <tr> \r\n    <td align=\"center\"><a href=\"$url\" target=\"_blank\"><img alt=\"$describes\" src=\"$img\" width=\"80\" height=\"30\" border=\"0\"></a></td>\r\n  </tr>\r\n  <tr> \r\n    <td align=\"center\" style=\"line-height:20px;\"> <font color=\"#990000\"> <b><font color=\"#FF0000\">$votenum</font> Ʊ \r\n      </b></font></td>\r\n  </tr>\r\n  <tr> \r\n    <td align=\"center\" style=\"line-height:40px;\"><a href=\"$webdb[www_url]/do/vote.php?action=vote&voteId=$id\" target=\"_blank\"><u>ͶһƱ</u></a> \r\n      <a href=\"$webdb[www_url]/do/vote.php?job=show&cid=$cid#postcomment\" target=\"_blank\"><u>һ</u></a></td>\r\n  </tr>\r\n</table>','2','0','0');
INSERT INTO `qb_vote_topic` VALUES ('12','ΪϲIDCͶϱһƱ','','2','0','0','','1289292937','','0','0','0','0','<div class=\"listVote\" title=\"{$describes}\">\r\n                    	<div class=\"img\"><A HREF=\"$url\" target=\"_blank\"><img src=\"$img\" width=\"120\" height=\"60\"/></A></div>\r\n                        <div class=\"word\">{$button} (<span>{$votenum}</span>)$title</div>\r\n                    </div>','1','0','0');
INSERT INTO `qb_vote_config` VALUES ('module_id','23','');
INSERT INTO `qb_vote_config` VALUES ('Info_webOpen','1','');
INSERT INTO `qb_vote_config` VALUES ('Info_webname','ͶƱϵͳ','');
INSERT INTO `qb_vote_config` VALUES ('module_pre','vote_','');
INSERT INTO `qb_area` VALUES ('1','0','','1','18','0','','0','0','','','','','N;','','0','','','0','','','','','0','b:0;');
INSERT INTO `qb_area` VALUES ('2','0','Ϻ','1','19','0','','0','0','','','','','N;','','0','','','0','','','','','0','b:0;');
INSERT INTO `qb_area` VALUES ('3','0','','1','18','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('4','0','','1','40','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('5','0','ӱʡ','1','11','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('6','0','ɽʡ','1','11','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('7','0','ɹ','1','12','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('8','0','ʡ','1','14','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('9','0','ʡ','1','9','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('10','0','ʡ','1','13','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('11','0','ʡ','1','13','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('12','0','㽭ʡ','1','11','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('13','0','ʡ','1','17','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('14','0','ʡ','1','9','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('15','0','ʡ','1','11','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('16','0','ɽʡ','1','17','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('17','0','ʡ','1','17','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('18','0','ʡ','1','17','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('19','0','ʡ','1','14','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('20','0','㶫ʡ','1','21','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('21','0','׳','1','14','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('22','0','ʡ','1','21','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('23','0','Ĵʡ','1','21','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('24','0','ʡ','1','9','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('25','0','ʡ','1','16','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('26','0','','1','7','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('27','0','ʡ','1','10','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('28','0','ʡ','1','14','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('29','0','ຣʡ','1','8','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('30','0','Ļ','1','5','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('31','0','½ά','1','18','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('32','0','̨ʡ','1','25','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('33','0','ر','1','18','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('34','0','ر','1','5','1','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('35','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('36','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('37','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('38','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('39','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('40','1','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('41','1','ʯɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('42','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('43','1','ͷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('44','1','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('45','1','ͨ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('46','1','˳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('47','1','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('48','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('49','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('50','1','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('51','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('52','1','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('53','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('54','2','¬','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('55','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('56','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('57','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('58','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('59','2','բ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('60','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('61','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('62','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('63','2','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('64','2','ζ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('65','2','ֶ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('66','2','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('67','2','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('68','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('69','2','ϻ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('70','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('71','2','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('72','3','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('73','3','Ӷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('74','3','','2','0','0','','0','0','','','','','N;','','0','','','0','','','','','0','b:0;');
INSERT INTO `qb_area` VALUES ('75','3','Ͽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('76','3','ӱ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('77','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('78','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('79','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('80','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('81','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('82','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('83','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('84','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('85','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('86','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('87','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('88','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('89','3','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('90','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('91','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('92','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('93','4','ɿ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('94','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('95','4','ɳƺ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('96','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('97','4','ϰ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('98','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('99','4','ʢ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('100','4','˫','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('101','4','山','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('102','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('103','4','ǭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('104','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('105','4','뽭','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('106','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('107','4','ͭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('108','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('109','4','ٲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('110','4','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('111','4','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('112','4','ǿ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('113','4','ᶼ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('114','4','潭','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('115','4','¡','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('116','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('117','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('118','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('119','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('120','4','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('121','4','Ϫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('122','4','ʯ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('123','4','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('124','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('125','4','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('126','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('127','4','ϴ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('128','4','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('129','4','ϴ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('130','5','ʯׯ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('131','5','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('132','5','ػʵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('133','5','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('134','5','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('135','5','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('136','5','żҿ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('137','5','е','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('138','5','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('139','5','ȷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('140','5','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('141','6','̫ԭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('142','6','ͬ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('143','6','Ȫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('144','6','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('145','6','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('146','6','˷','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('147','6','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('148','6','˳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('149','6','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('150','6','ٷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('151','6','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('152','7','ͺ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('153','7','ͷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('154','7','ں','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('155','7','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('156','7','ͨ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('157','7','˹','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('158','7','ױ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('159','7','׶','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('160','7','첼','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('161','7','˰','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('162','7','ֹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('163','7','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('164','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('165','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('166','8','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('167','8','˳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('168','8','Ϫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('169','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('170','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('171','8','Ӫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('172','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('173','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('174','8','̽','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('175','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('176','8','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('177','8','«','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('178','9','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('179','9','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('180','9','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('181','9','Դ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('182','9','ͨ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('183','9','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('184','9','ԭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('185','9','׳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('186','9','ӱ߳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('187','10','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('188','10','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('189','10','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('190','10','׸','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('191','10','˫Ѽɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('192','10','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('193','10','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('194','10','ľ˹','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('195','10','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('196','10','ĵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('197','10','ں','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('198','10','绯','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('199','10','˰','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('200','11','Ͼ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('201','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('202','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('203','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('204','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('205','11','ͨ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('206','11','Ƹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('207','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('208','11','γ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('209','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('210','11','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('211','11','̩','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('212','11','Ǩ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('213','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('214','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('215','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('216','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('217','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('218','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('219','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('220','12','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('221','12','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('222','12','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('223','12','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('224','13','Ϸ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('225','13','ߺ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('226','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('227','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('228','13','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('229','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('230','13','ͭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('231','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('232','13','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('233','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('234','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('235','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('236','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('237','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('238','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('239','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('240','13','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('241','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('242','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('243','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('244','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('245','14','Ȫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('246','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('247','14','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('248','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('249','14','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('250','15','ϲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('251','15','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('252','15','Ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('253','15','Ž','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('254','15','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('255','15','ӥ̶','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('256','15','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('257','15','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('258','15','˴','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('259','15','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('260','15','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('261','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('262','16','ൺ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('263','16','Ͳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('264','16','ׯ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('265','16','Ӫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('266','16','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('267','16','Ϋ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('268','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('269','16','̩','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('270','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('271','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('272','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('273','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('274','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('275','16','ĳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('276','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('277','16','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('278','17','֣','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('279','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('280','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('281','17','ƽɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('282','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('283','17','ױ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('284','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('285','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('286','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('287','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('288','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('289','17','Ͽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('290','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('291','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('292','17','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('293','17','ܿ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('294','17','פ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('295','18','人','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('296','18','ʯ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('297','18','ʮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('298','18','˲','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('299','18','差','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('300','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('301','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('302','18','Т','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('303','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('304','18','Ƹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('305','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('306','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('307','18','ʩ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('308','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('309','18','Ǳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('310','18','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('311','18','ũ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('312','19','ɳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('313','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('314','19','̶','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('315','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('316','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('317','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('318','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('319','19','żҽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('320','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('321','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('322','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('323','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('324','19','¦','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('325','19','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('326','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('327','20','ع','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('328','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('329','20','麣','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('330','20','ͷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('331','20','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('332','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('333','20','տ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('334','20','ï','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('335','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('336','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('337','20','÷','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('338','20','β','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('339','20','Դ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('340','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('341','20','Զ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('342','20','ݸ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('343','20','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('344','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('345','20','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('346','20','Ƹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('347','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('348','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('349','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('350','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('351','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('352','21','Ǹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('353','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('354','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('355','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('356','21','ɫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('357','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('358','21','ӳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('359','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('360','21','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('361','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('362','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('363','22','ָɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('364','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('365','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('366','22','Ĳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('367','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('368','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('369','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('370','22','Ͳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('371','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('372','22','ٸ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('373','22','ɳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('374','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('375','22','ֶ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('376','22','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('377','22','ͤ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('378','22','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('379','22','ɳȺ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('380','22','ɳȺ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('381','22','ɳȺĵ亣','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('382','23','ɶ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('383','23','Թ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('384','23','֦','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('385','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('386','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('387','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('388','23','Ԫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('389','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('390','23','ڽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('391','23','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('392','23','ϳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('393','23','üɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('394','23','˱','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('395','23','㰲','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('396','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('397','23','Ű','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('398','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('399','23','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('400','23','ӲǼ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('401','23','β','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('402','23','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('403','24','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('404','24','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('405','24','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('406','24','˳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('407','24','ͭʵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('408','24','ǭϲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('409','24','Ͻڵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('410','24','ǭ嶱','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('411','24','ǭϲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('412','25','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('413','25','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('414','25','Ϫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('415','25','ɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('416','25','ͨ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('417','25','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('418','25','˼é','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('419','25','ٲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('420','25','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('421','25','ӹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('422','25','ɽ׳','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('423','25','˫ɴ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('424','25','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('425','25','º徰','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('426','25','ŭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('427','25','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('428','26','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('429','26','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('430','26','ɽϵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('431','26','տ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('432','26','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('433','26','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('434','26','֥','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('435','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('436','27','ͭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('437','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('438','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('439','27','μ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('440','27','Ӱ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('441','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('442','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('443','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('444','27','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('445','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('446','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('447','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('448','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('449','28','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('450','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('451','28','Ҵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('452','28','ƽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('453','28','Ȫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('454','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('455','28','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('456','28','¤','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('457','28','Ļ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('458','28','ϲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('459','29','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('460','29','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('461','29','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('462','29','ϲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('463','29','ϲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('464','29','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('465','29','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('466','29','ɹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('467','30','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('468','30','ʯɽ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('469','30','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('470','30','ԭ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('471','30','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('472','31','³ľ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('473','31','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('474','31','³','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('475','31','ܵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('476','31','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('477','31','ɹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('478','31','ɹ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('479','31','յ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('480','31','տ¶','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('481','31','ʲ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('482','31','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('483','31','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('484','31','ǵ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('485','31','̩','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('486','31','ʯ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('487','31','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('488','31','ͼľ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('489','31','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('490','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('491','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('492','32','¡','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('493','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('494','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('495','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('496','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('497','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('498','32','԰','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('499','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('500','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('501','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('502','32','û','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('503','32','Ͷ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('504','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('505','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('506','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('507','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('508','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('509','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('510','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('511','32','̨','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('512','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('513','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('514','32','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('515','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('516','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('517','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('518','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('519','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('520','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('521','33','ˮ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('522','33','ƴ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('523','33','ͼ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('524','33','뵺','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('525','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('526','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('527','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('528','33','ɳ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('529','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('530','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('531','33','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('532','33','Ԫ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('533','34','л','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('534','34','ʥ','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('535','34','д','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('536','34','','2','0','0','','0','0','','','','','','','0','','','0','','','','','0','');
INSERT INTO `qb_area` VALUES ('537','34','з˳','2','0','0','','0','0','','','','','N;','','0','','','0','','','','','0','b:0;');
INSERT INTO `qb_jfabout` VALUES ('6','2','¿ɵ{$webdb[postArticleMoney]}','ֻ˺²ſɵû,û˵²û.','0');
INSERT INTO `qb_jfabout` VALUES ('7','2','ɾ¿۳{$webdb[deleteArticleMoney]}','','0');
INSERT INTO `qb_jfabout` VALUES ('5','1','ûעɵ{$webdb[regmoney]}','','0');
INSERT INTO `qb_jfabout` VALUES ('8','2','±Ϊɵ{$webdb[comArticleMoney]}','','0');
INSERT INTO `qb_jfabout` VALUES ('9','1','ÿ㿨ɶһ{$webdb[MoneyRatio]},㿨ֵͨ߳.','','0');
INSERT INTO `qb_jfsort` VALUES ('1','Ա','0');
INSERT INTO `qb_jfsort` VALUES ('2','','0');
INSERT INTO `qb_olpay` VALUES ('33','0','08nyzxrb9a','10','0','1284605041','1','admin','1','0','0','yeepay','0');
INSERT INTO `qb_olpay` VALUES ('34','0','qaqec2flpj','1','0','1291882682','1','admin','1','0','0','tenpay','0');
INSERT INTO `qb_olpay` VALUES ('35','0','tge8v0ag0w','1','0','1291882786','1','admin','1','0','0','tenpay','0');
INSERT INTO `qb_template` VALUES ('5','ͷװ','7','template/default/none.htm','','0');
INSERT INTO `qb_template` VALUES ('6','ײװ','8','template/default/none.htm','','0');
INSERT INTO `qb_template` VALUES ('23','бҳ(խ)','2','template/default/list.htm','','0');
INSERT INTO `qb_template` VALUES ('22','ҳ(խ)','3','template/default/bencandy.htm','','0');
INSERT INTO `qb_template` VALUES ('24','ҳ(խ)','1','template/default/index.htm','','0');
INSERT INTO `qb_template` VALUES ('20','ҳ()','3','template/default/bencandy_tpl_2.htm','','0');
INSERT INTO `qb_template` VALUES ('21','ҳ','9','template/default/alonepage.htm','','0');
INSERT INTO `qb_template` VALUES ('25','רģһ(ͷҪװ)','11','template/special/showsp2.htm','','0');
INSERT INTO `qb_template` VALUES ('26','רģ(ͷҪװ)','11','template/special/special_sport.htm','','0');
INSERT INTO `qb_template` VALUES ('27','רģ(ͷҪװ)','11','template/special/special_car.htm','','0');
INSERT INTO `qb_template` VALUES ('28','רģ(ͷҪװ)','11','template/special/special_finance.htm','','0');
INSERT INTO `qb_template` VALUES ('29','רģ(ͷҪװ)','11','template/special/sp1.htm','','0');
INSERT INTO `qb_crontab` VALUES ('1','ҳ̬','3','','0','1292402491','inc/crontab/make_index_html.php','','1');
INSERT INTO `qb_crontab` VALUES ('2','ݿ','0','0300','0','1292489459','inc/crontab/mysqlbak.php','','1');
INSERT INTO `qb_crontab` VALUES ('3','CK༭ͼ','0','0330','0','1292489510','inc/crontab/delete_ckeditor_tmp.php','','1');
INSERT INTO `qb_crontab` VALUES ('4','ո','0','','1296504125','0','inc/crontab/delete_table_upfile.php','','1');
INSERT INTO `qb_yzimg` VALUES ('rsnaqni6','Byzv','1306911439');
INSERT INTO `qb_yzimg` VALUES ('u072e8fm','QTen','1306912470');
INSERT INTO `qb_news_article` VALUES ('565','ѧˮУ԰ӹע','','39','0','web','4','1','0','1240126531','1240126531','1','admin','','','','','0','','0','1','','0','0','0','ѧ У԰    ע','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1300674312','0','0','0','0','','');
INSERT INTO `qb_news_article` VALUES ('566','վ֪50⣬˳Ϊݸվ','','39','0','web','20','3','1','1240126684','1240126684','1','admin','','','','','0','','0','1','','0','0','0',' վ  ֪ ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1240138830','0','0','','1289286094','3','1240210732','0','0','Ц|1~~|','');
INSERT INTO `qb_news_article` VALUES ('567','ɹĴҪأҪȥ','','39','0','web','3','1','1','1240126775','1240126775','1','admin','','','','','0','','0','1','','0','0','0',' ɹ  Ĵ Ҫ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1240138868','0','0','','1299578826','0','0','0','0','','');
INSERT INTO `qb_news_article` VALUES ('568','ɹվʢΪοβ','','39','0','web','3','1','0','1240126816','1240126816','1','admin','','','','','0','','0','1','','0','0','0',' վ Ϊ  ο','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1240138934','0','0','','1301651295','0','0','0','0','','');
INSERT INTO `qb_news_article` VALUES ('569','ŻͷϷ гǰ޴','','39','0','web','3','1','0','1240126852','1240126852','1','admin','','','','','0','','0','1','','0','0','0',' Ż  ͷ Ϸ  г ǰ ޴','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1301652108','0','0','0','0','','');
INSERT INTO `qb_news_article` VALUES ('570','1219,Ҳ콫V7','','38','0','һﾪ','1','1','0','1240126932','1240126932','1','admin','','','','','0','','0','1','','0','0','0','12 19 콫 ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1292639697','0','0','','1240212806','0','0','0','0','','');
INSERT INTO `qb_news_article` VALUES ('571','ع˹ȥչδ飡','','38','0','һﾪ','2','1','0','1240127012','1240127012','1','admin','','','','','0','','0','1','','0','0','0','ع ȥ չ δ ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1292639905','0','0','','1292639906','0','0','0','0','','');
INSERT INTO `qb_news_article` VALUES ('572','ԭPHP168ƷеVϵSϵУȫֿͬĹ˾Ӫ','','38','0','һﾪ','0','1','0','1240127172','1240127172','1','admin','','','','','0','','0','1','','0','0','0','PHP168 Ʒ ϵ ȫ  ֿ ͬ ˾ Ӫ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1292639985','0','0','','0','0','0','0','0','Ц|1~~|','');
INSERT INTO `qb_news_article` VALUES ('573','Ҫ棡Vϵн12·̳Ϊ벩cms','','38','0','һﾪ','10','1','0','1240127229','1303266534','1','admin','','','','','0','','0','1','','0','1','1300674530','Ҫ  ϵ 12·  ̳   Ϊ 벩 cms','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1292640029','0','0','','1301382485','1','1301382602','0','0','','');
INSERT INTO `qb_news_article` VALUES ('574','eBayؽGmarket طйг','','4','0','ITҵ','4','1','0','1240127281','1240127281','1','admin','','','','','0','','0','1','','0','0','0','eBay ؽ Gmarket  ط й  г','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1301651044','0','0','','1301651047','0','0','0','0','','');
INSERT INTO `qb_news_article` VALUES ('575','ͨŹ֣վΥ 򽫱','','4','0','ITҵ','1','1','0','1240127308','1240127308','1','admin','','','','','0','','0','1','','0','0','0','ͨ   վ  Υ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1289291749','0','0','0','0','','');
INSERT INTO `qb_news_article` VALUES ('576','ɶͶʡ߻رվ ƭ64Ԫ','','4','0','ITҵ','3','1','1','1240127373','1240127373','1','admin','','','','','0','','0','1','','0','0','0','ɶ  Ͷ ر վ ƭ 64Ԫ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1299578878','0','0','0','0','','');
INSERT INTO `qb_news_article` VALUES ('577','ƶOPhoneֻ5½жԿiPhone','','4','0','ITҵ','1','1','0','1240127449','1240127449','1','admin','','','','','0','','0','1','','0','0','0','ƶ OPhoneֻ 5  Կ iPhone','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1301650807','0','0','0','0','','');
INSERT INTO `qb_news_article` VALUES ('578','־һҵ˱','','39','0','web','9','1','0','1240127959','1240127959','1','admin','','','','','0','article/39/1_20090419150430_a2XoC.jpg','1','1','','0','0','0','־ һ ҵ  ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1240128030','0','0','','1301651378','0','0','0','0','','');
INSERT INTO `qb_news_article` VALUES ('579','ѩųǻڲԭ ÿ9000','','4','0','ITҵ','5','1','1','1240128462','1240128462','1','admin','','','','','0','','0','1','','0','0','0','ѩ   ԭ  ÿ 9000','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1299578832','0','0','0','0','','');
INSERT INTO `qb_news_article` VALUES ('580','һй1620 Ѵ3.16','','4','0','ITҵ','6','1','0','1240128514','1240128514','1','admin','','','','','0','','0','1','','0','0','0','һ й   1620  3.16','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1301650799','0','0','0','0','','');
INSERT INTO `qb_news_article` VALUES ('581','֥˾ʷ󾻿 Լ35Ԫ','','4','0','ITҵ','2','1','0','1240128552','1240128552','1','admin','','','','','0','','0','1','','0','0','0','֥  ˾ ʷ   Լ 35Ԫ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1301650797','0','0','0','0','','');
INSERT INTO `qb_news_article` VALUES ('582','վ߳ŻӰ','','4','0','ITҵ','4','1','0','1240128654','1240128654','1','admin','','','','','0','','0','1','','0','0','0',' վ ߳ Ż Ӱ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1301650765','0','0','','1301650775','0','0','0','0','','');
INSERT INTO `qb_news_article` VALUES ('583','Ʒǰְҵ滮','','4','0','ITҵ','9','1','0','1240128744','1240128744','1','admin','','','','','0','article/4/1_20090419160422_PjOh8_jpg.gif','1','1','','0','0','0','Ʒ   ְҵ滮','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1306912078','0','0','0','0','','');
INSERT INTO `qb_news_article` VALUES ('593','Ϊ벩CMS,ܸýע!!','','3','0','','7','1','0','1240129686','1240129686','1','admin','','','','','0','http://i3.sinaimg.cn/home/deco/2009/0330/con_logo_tech_news.gif','1','1','','0','0','0','Ϊ 벩 CMS  ýע','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1292639323','0','0','','1301650730','0','0','0','0','Ц|1~~|','');
INSERT INTO `qb_news_article` VALUES ('594','ݱV7ͻ,ں̨ɶģɸ,ЭҶο.ԼҪ','','3','0','','4','1','0','1240129723','1240129723','1','admin','','','','','0','','0','1','','0','0','0','ݱ ͻ ̨ ģ   Э     Լ Ҫ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1292639096','0','0','','1300674500','0','0','0','0','','');
INSERT INTO `qb_news_article` VALUES ('595','V7Ӷʱ ,ʱݿ⹦','','3','0','','6','1','0','1240129752','1240129752','1','admin','','','','','0','','0','1','','0','0','0','  ʱ    ݿ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1292639054','0','0','','1300674512','0','0','0','0','','');
INSERT INTO `qb_news_article` VALUES ('598','ӦҪ,V7ckeditor༭','','3','0','','7','1','0','1240129958','1240129958','1','admin','','','','','0','','0','1','','0','0','0',' Ҫ  ckeditor ༭ ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1292639000','0','0','','1306912087','0','0','0','0','','');
INSERT INTO `qb_news_article` VALUES ('599','벩̨벩CMSһڿʼƷ񣬻ӭ룡','','3','0','','37','1','2','1240130011','1240130011','1','admin','','','','','0','','0','1','','0','0','0','벩  ̨  CMS һ   ʼ Ʒ  ӭ ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1292638965','0','0','','1300674744','7','1301651967','0','0','Ц|1~~|1~~|','');
INSERT INTO `qb_news_article` VALUES ('545','V7V6ԭй','','31','0','ͷ','16','1','0','1240049871','1240049871','1','admin','','','','','0','','0','1','','0','0','0',' ԭ  ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1292639524','0','0','ΪйCMSƽ̨֮һqibosoftԹٷվҪV6棬V6λΪCMSĴ棬ڹϾд£ͬʱ˼·վӪá','1301650420','0','0','0','0','','');
INSERT INTO `qb_news_article` VALUES ('546','qibosoftPhpwindǿ ƽ','','32','0','Ƽ','4','1','0','1240050071','1240050071','1','admin','','','','#5555AA','0','','0','1','','0','1','1240058149','qibosoft Phpwind ǿ   ƽ ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1240210097','4','1240995136','0','0','Ц|1~~|','');
INSERT INTO `qb_news_article` VALUES ('547','v7ϵͳһǿ,ʵǰ̨鿴Խ','','32','0','Ƽ','4','1','0','1240050179','1240050179','1','admin','','','','','0','','0','1','','0','1','1240058148',' ϵͳ һ ǿ ʵ ǰ̨ 鿴  ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1292640191','0','0','','1300675085','0','0','0','0','','');
INSERT INTO `qb_news_article` VALUES ('548','v7ϵͳ֧뿼ʱƹ','','32','0','Ƽ','2','1','0','1240050522','1240050522','1','admin','','','','','0','','0','1','','0','1','1240058146',' ϵͳ ֧   ʱ  ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1292640138','0','0','','1240058225','0','0','0','0','','');
INSERT INTO `qb_news_article` VALUES ('549','͸¶һV7Ľչ,ǿԱ׬ȡ¼','','32','0','Ƽ','1','1','0','1240050670','1240050670','1','admin','','','','#0033FF','0','','0','1','','0','1','1240058139','͸¶ չ ǿ Ա   ׬ȡ ¼ ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1292640243','0','0','','1240142450','0','0','0','0','','');
INSERT INTO `qb_news_article` VALUES ('550','chinazIDCƽ̨ʽ','','32','0','Ƽ','17','1','0','1240051050','1240051050','1','admin','','','','#B50707','1','article/32/1_20090418180444_f8mDG_jpg.gif','1','1','','0','1','1240058150','chinaz   IDC ƽ̨  cnidc.com ʽ ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1240058256','0','0','','1301651721','1','1240210632','0','0','','');
INSERT INTO `qb_news_article` VALUES ('551','Ҵƹܵģ,ģ͸ƹ','','33','0','ͼƬ','7','1','0','1240051810','1240051810','1','admin','','','','','0','','0','1','','0','1','1240056324','     ģ   ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1292640365','0','0','','1300412231','0','0','0','0','','');
INSERT INTO `qb_news_article` VALUES ('552','ȸйгݶһ','','33','0','ͼƬ','0','1','0','1240052014','1240052014','1','admin','','','','','0','article/33/1_20090418180438_vPiyT.jpg','1','1','','0','1','1240056321',' ȸ й г ݶ  ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1240052093','0','0','','0','0','0','0','0','','');
INSERT INTO `qb_news_article` VALUES ('553','ӣPHPWINDϾվ---ӢΪйչ׼Ʋ','','33','0','ͼƬ','9','1','0','1240052409','1240052409','1','admin','','','','','0','article/33/1_20090418190453_qabKt.jpg','1','1','','0','1','1240056320',' PHPWIND Ͼ վ  ---  Ӣ й չ Ʋ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1240108730','0','0','','1240212610','0','0','0','0','','');
INSERT INTO `qb_news_article` VALUES ('554','ٶȰٿƣadmin5ͼ','','33','0','ͼƬ','16','1','0','1240057138','1240057138','1','admin','','','','','0','article/33/1_20090418200432_5ZUc2.jpg','1','1','','0','1','1240057560','ٶȰٿ admin5 ͼ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1306911378','0','0','0','0','','');
INSERT INTO `qb_news_article` VALUES ('555','ɵĲƸ֮Chinaz.com','','33','0','ͼƬ','6','1','0','1240057438','1240057438','1','admin','','','','','0','article/33/1_20090418200416_Fs7xV.gif','1','1','','0','1','1240057559','Chinaz.com  Ƹ ֮','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1240057762','0','0','','1240213566','0','0','0','0','','');
INSERT INTO `qb_news_article` VALUES ('556','룺õǮ','','33','0','ͼƬ','4','2','0','1240059129','1240059129','1','admin','','','','','0','article/33/1_20090418200441_Zm9oq.jpg','1','1','','0','1','1240059153','  õ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1300440143','0','0','0','0','Ծ|1~~|','');
INSERT INTO `qb_news_article` VALUES ('557','V6V7ʹ','','34','0','ȵ¼','1','1','0','1240060838','1240060838','1','admin','','','','','0','','0','1','','0','1','1240060860','  ʹ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1292640605','0','0','','1240142881','1','1301307299','0','0','','');
INSERT INTO `qb_news_article` VALUES ('558','ݹؼͻʾ,ͼƬʱBUG','','34','0','ȵ¼','2','1','0','1240061182','1240061182','1','admin','','','','','0','','0','1','','0','1','0','  ؼ ͻ ʾ ͼƬ ʱ BUG ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1292640555','0','0','','1240209066','1','1301307298','0','0','','');
INSERT INTO `qb_news_article` VALUES ('559','йƶ3G ӭ͡ʱ','','34','0','ȵ¼','1','1','0','1240061760','1240061760','1','admin','','','','','0','article/34/1_20090418210444_jnTex.jpg','1','1','','0','1','1240061785','йƶ  ӭ  ʱ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','0','0','0','','1300686411','1','1301307297','0','0','','');
INSERT INTO `qb_news_article` VALUES ('560','chinazƷչ װȥ','','34','0','ȵ¼','5','1','0','1240062925','1240062925','1','admin','','','','','0','article/34/1_20090420110424_5lRC8.jpg','1','1','','0','1','0',' Ʒ  װ ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1240196570','0','0','','1240211417','0','0','0','0','','');
INSERT INTO `qb_news_article` VALUES ('603','벩V7¾̬,ȡ÷Ծͻ,ʱȫվ̬+˼ؾ̬','','39','0','web','17','1','1','1240201330','1240201330','1','admin','','','','','0','','0','1','','0','0','0','벩  ̬  ȡ Ծ ͻ ʱ ȫվ  ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1292638888','0','0','','1301652097','4','1301382601','0','0','|1~~|','');
INSERT INTO `qb_news_article` VALUES ('604','V7ӭשУҩڣڲ','','39','0','web','37','1','1','1240209505','1240209505','1','admin','','','','','0','','0','1','','0','0','0','ӭ     ҩ ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','0','','0','0','','','','','','1292638835','0','0','','1300675094','6','1301651968','0','0','','');
INSERT INTO `qb_news_comment` VALUES ('14','603','39','1','1','admin','1300674296','wfdsafds','127.0.0.1','12','1','0','0','0');
INSERT INTO `qb_news_config` VALUES ('Info_webOpen','1','');
INSERT INTO `qb_news_config` VALUES ('module_id','30','');
INSERT INTO `qb_news_config` VALUES ('Private_tpl_foot','','');
INSERT INTO `qb_news_config` VALUES ('SPbencandy_filename','html/5special{$fid}/show{$id}.htm','');
INSERT INTO `qb_news_config` VALUES ('ForbidShowPhpPage','0','');
INSERT INTO `qb_news_config` VALUES ('Private_tpl_head','','');
INSERT INTO `qb_news_config` VALUES ('IF_Private_tpl','0','');
INSERT INTO `qb_news_config` VALUES ('SPlist_filename','html/4special{$fid}/list{$page}.htm','');
INSERT INTO `qb_news_config` VALUES ('bencandy_filename','html/{$fid}-{$dirid}/{$id}-{$page}.htm','');
INSERT INTO `qb_news_config` VALUES ('list_filename','html/{$fid}/{$page}.htm','');
INSERT INTO `qb_news_config` VALUES ('showNoPassComment','1','');
INSERT INTO `qb_news_config` VALUES ('ListPageTitle_nojs','0','');
INSERT INTO `qb_news_config` VALUES ('FlashGet_ID','6370','');
INSERT INTO `qb_news_config` VALUES ('special_show_html','html/special{$fid}/show{$id}.htm','');
INSERT INTO `qb_news_config` VALUES ('XunLei_ID','08311','');
INSERT INTO `qb_news_config` VALUES ('view_sell_article','0','');
INSERT INTO `qb_news_config` VALUES ('CommentOrderType','0','');
INSERT INTO `qb_news_config` VALUES ('allowMemberCommentPass','1','');
INSERT INTO `qb_news_config` VALUES ('allowGuestCommentPass','1','');
INSERT INTO `qb_news_config` VALUES ('allowGuestComment','1','');
INSERT INTO `qb_news_config` VALUES ('CommentTime','5','');
INSERT INTO `qb_news_config` VALUES ('showCommentRows','8','');
INSERT INTO `qb_news_config` VALUES ('forbidComment','0','');
INSERT INTO `qb_news_config` VALUES ('showComment','1','');
INSERT INTO `qb_news_config` VALUES ('autoPlayFirstMv','1','');
INSERT INTO `qb_news_config` VALUES ('allowDownMv','0','');
INSERT INTO `qb_news_config` VALUES ('photoShowType','0','');
INSERT INTO `qb_news_config` VALUES ('EditSystem','2','');
INSERT INTO `qb_news_config` VALUES ('PostNotice','<font face=SimSun>\r\n<p><font face=SimSun>1תݣдԴַ<br />2İȨ뷨ɷ߳е</font></p></font>','');
INSERT INTO `qb_news_config` VALUES ('showsortlogo','0','');
INSERT INTO `qb_news_config` VALUES ('Listsortnameline','2','');
INSERT INTO `qb_news_config` VALUES ('ListLeng','70','');
INSERT INTO `qb_news_config` VALUES ('JsListRows','5','');
INSERT INTO `qb_news_config` VALUES ('JsListLeng','36','');
INSERT INTO `qb_news_config` VALUES ('ListSonRows','9','');
INSERT INTO `qb_news_config` VALUES ('ListSonLeng','34','');
INSERT INTO `qb_news_config` VALUES ('SideTitleStyle','side_tpl/2','');
INSERT INTO `qb_news_config` VALUES ('SideSortStyle','side_sort/2','');
INSERT INTO `qb_news_config` VALUES ('UseArticleHeart','1','');
INSERT INTO `qb_news_config` VALUES ('heart_noRecord','1','');
INSERT INTO `qb_news_config` VALUES ('heart_time','30','');
INSERT INTO `qb_news_config` VALUES ('ArticleDownloadUseFtp','0','');
INSERT INTO `qb_news_config` VALUES ('special_list_html','html/special{$fid}/list{$page}.htm','');
INSERT INTO `qb_news_config` VALUES ('SortUseOtherModule','0','');
INSERT INTO `qb_news_config` VALUES ('Info_html_show','html/{$fid}-{$dirid}/{$id}-{$page}.htm','');
INSERT INTO `qb_news_config` VALUES ('ArticleHeart','Ƿ|1.gif\r\n֧|2.gif\r\nܰ|3.gif\r\n|4.gif\r\nЦ|5.gif\r\n|6.gif\r\n|7.gif\r\nԾ|8.gif','');
INSERT INTO `qb_news_config` VALUES ('cache_time_like','-1','');
INSERT INTO `qb_news_config` VALUES ('cache_time_com','-1','');
INSERT INTO `qb_news_config` VALUES ('cache_time_hot','-1','');
INSERT INTO `qb_news_config` VALUES ('cache_time_new','-1','');
INSERT INTO `qb_news_config` VALUES ('showsp_cache_time','0','');
INSERT INTO `qb_news_config` VALUES ('bencandy_cache_time','0','');
INSERT INTO `qb_news_config` VALUES ('list_cache_time','0','');
INSERT INTO `qb_news_config` VALUES ('index_cache_time','0','');
INSERT INTO `qb_news_config` VALUES ('cache_time_pic','-1','');
INSERT INTO `qb_news_config` VALUES ('fulist_cache_time','0','');
INSERT INTO `qb_news_config` VALUES ('Limit_postOne','0','');
INSERT INTO `qb_news_config` VALUES ('UseArticleDigg','0','');
INSERT INTO `qb_news_config` VALUES ('ForceDel','0','');
INSERT INTO `qb_news_config` VALUES ('AutoTitleNum','1','');
INSERT INTO `qb_news_config` VALUES ('deleteArticleMoney','-1','');
INSERT INTO `qb_news_config` VALUES ('postArticleMoney','1','');
INSERT INTO `qb_news_config` VALUES ('comArticleMoney','3','');
INSERT INTO `qb_news_config` VALUES ('hotArticleNum','100','');
INSERT INTO `qb_news_config` VALUES ('ListShowIcon','0','');
INSERT INTO `qb_news_config` VALUES ('newArticleTime','24','');
INSERT INTO `qb_news_config` VALUES ('autoGetKeyword','0','');
INSERT INTO `qb_news_config` VALUES ('autoGetSmallPic','1','');
INSERT INTO `qb_news_config` VALUES ('autoCutSmallPic','1','');
INSERT INTO `qb_news_config` VALUES ('ForbidRepeatTitle','0','');
INSERT INTO `qb_news_config` VALUES ('viewNoPassArticle','0','');
INSERT INTO `qb_news_config` VALUES ('ArticlePicWidth','800','');
INSERT INTO `qb_news_config` VALUES ('ArticlePicHeight','600','');
INSERT INTO `qb_news_config` VALUES ('ArticleDownloadDirTime','0','');
INSERT INTO `qb_news_config` VALUES ('Html_Type','0','');
INSERT INTO `qb_news_config` VALUES ('Info_html_list','html/{$fid}/{$page}.htm','');
INSERT INTO `qb_news_config` VALUES ('Info_titleName','','');
INSERT INTO `qb_news_config` VALUES ('module_pre','news_','');
INSERT INTO `qb_news_config` VALUES ('Info_weburl','','');
INSERT INTO `qb_news_config` VALUES ('Info_webname','ģ','');
INSERT INTO `qb_news_config` VALUES ('module_close','0','');
INSERT INTO `qb_news_config` VALUES ('DefaultIndexHtml','1','');
INSERT INTO `qb_news_fu_article` VALUES ('3','604');
INSERT INTO `qb_news_fu_article` VALUES ('3','603');
INSERT INTO `qb_news_fu_article` VALUES ('3','599');
INSERT INTO `qb_news_fu_article` VALUES ('3','598');
INSERT INTO `qb_news_fu_article` VALUES ('3','595');
INSERT INTO `qb_news_fu_article` VALUES ('3','594');
INSERT INTO `qb_news_fu_article` VALUES ('3','593');
INSERT INTO `qb_news_fu_article` VALUES ('3','583');
INSERT INTO `qb_news_fu_article` VALUES ('3','582');
INSERT INTO `qb_news_fu_article` VALUES ('3','581');
INSERT INTO `qb_news_fu_article` VALUES ('3','580');
INSERT INTO `qb_news_fu_article` VALUES ('3','579');
INSERT INTO `qb_news_fu_article` VALUES ('3','578');
INSERT INTO `qb_news_fu_article` VALUES ('3','577');
INSERT INTO `qb_news_fu_article` VALUES ('3','576');
INSERT INTO `qb_news_fu_article` VALUES ('3','575');
INSERT INTO `qb_news_fu_article` VALUES ('3','574');
INSERT INTO `qb_news_fu_article` VALUES ('3','573');
INSERT INTO `qb_news_fu_article` VALUES ('3','572');
INSERT INTO `qb_news_fu_article` VALUES ('3','571');
INSERT INTO `qb_news_fu_article` VALUES ('3','570');
INSERT INTO `qb_news_fu_article` VALUES ('3','569');
INSERT INTO `qb_news_fu_article` VALUES ('3','568');
INSERT INTO `qb_news_fu_article` VALUES ('3','567');
INSERT INTO `qb_news_fu_article` VALUES ('3','566');
INSERT INTO `qb_news_fu_article` VALUES ('3','565');
INSERT INTO `qb_news_fu_article` VALUES ('3','560');
INSERT INTO `qb_news_fu_article` VALUES ('3','559');
INSERT INTO `qb_news_fu_article` VALUES ('3','558');
INSERT INTO `qb_news_fu_article` VALUES ('3','557');
INSERT INTO `qb_news_fu_article` VALUES ('3','556');
INSERT INTO `qb_news_fu_article` VALUES ('3','555');
INSERT INTO `qb_news_fu_article` VALUES ('3','554');
INSERT INTO `qb_news_fu_article` VALUES ('3','553');
INSERT INTO `qb_news_fu_article` VALUES ('3','552');
INSERT INTO `qb_news_fu_article` VALUES ('3','551');
INSERT INTO `qb_news_fu_article` VALUES ('3','550');
INSERT INTO `qb_news_fu_article` VALUES ('3','549');
INSERT INTO `qb_news_fu_sort` VALUES ('1','0','0','444','1','1','1','','1','0','','','','','','','0','','','1','','','','','0','','','','','');
INSERT INTO `qb_news_fu_sort` VALUES ('3','1','0','fdsaf666','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:7:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;s:14:\"listContentNum\";s:0:\"\";s:12:\"ListShowType\";s:0:\"\";s:15:\"ListShowBigType\";N;}','','','','');
INSERT INTO `qb_news_gather_rule` VALUES ('20','0','article','article','','ԭѧռ----->ɢ >> ','http://wind.yinsha.com/ashow.php?sid=10&%20size=20&page=[page]','','1','3','1','0','','','','','','','','','','0','','','','','','','','','0','1165498531','1165498610','0','0','','0','0','','','','0','','<img src=images/{NO\"} border=0>\r\n                    \r\n            <a href=\"{url=NO\"}\" target=_blank>{title=NO<}</a> ','<div class=\"nr\">{content=*}</div>','','','0');
INSERT INTO `qb_news_keyword` VALUES ('1','fdsafds','0','1','1','','0');
INSERT INTO `qb_news_keyword` VALUES ('2','trew','0','1','1','','0');
INSERT INTO `qb_news_reply` VALUES ('73','','0','0','0','0','0','<p>&nbsp;&nbsp; λվҵûעqibosoftͬѣ <br />\r\n&nbsp;&nbsp; ӭʹqibosoftվϵͳ,ĿǰĬϰװϵͳ,Ȼⲻһ.ݶһ.ʾݶ,벻Ҫϵͳ⡣</p>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('547','','1240126739','566','39','1','0','˽һͬһ̨վ<br />\r\n&nbsp; &nbsp; 4վռļ۸ṩվռķ̺ܶ࣬ͷҲǧ𣬼۸ͬкܴ죬һ˵Ĵͷ̵Ʒ۸ҪһЩһЩС͹˾ܼ۸ȽϱˣɸվҪ̶ѡֲεṩ̡ѡСл񹲺͹ֵҵӪ֤ķ̸.<br />\r\n<br />\r\n9 ʲô <br />\r\n<br />\r\nϿٳһĴ̿ռ乩ûվļݣܰwebʺļ书ܡ&nbsp;&nbsp;<br />\r\n<br />\r\nνҲСվռ䡱ǰһ̨ڻϵķֳɶ⡱ķÿһжInternet֧WWWFTPE-mailȣܡһ̨ϵĲͬǸԶģûйһֻ̨ܹ֧һʱûеܼ½<br />\r\n<br />\r\nǻõĽʡӲɱļҪӦHTTP񣬽һ̨ĳȫ߼ΪλΪӶ÷ӲԴϵͳģΪ<br />\r\n<br />\r\n<br />\r\n10ʲôHTML<br />\r\n<br />\r\nHTMLHyperTextMark-upLanguageıԣWWWԡHTMLԵĿΪܰѴһ̨еıͼһ̨еıͼηϵһγл壬ǲÿǾϢڵǰϻϡֻʹĳһĵеȡһͼ꣬InternetͻתͼصȥЩϢܴһ̨С HTMLıHTMLɵıHTML˵֡ͼΡӵȡHTMLĽṹͷHead壨Body󲿷֣ͷϢҪ˵ľݡ:<a href=\"http://tool.admin5.com/shouce/html/\" target=\"_blank\"><font color=\"#0000ff\">http://tool.admin5.com/shouce/html/</font></a><br />\r\n<br />\r\n11 ʲôASP<br />\r\n<br />\r\nASPActive Server PageдΪҳASP΢˾ĴCGIűһӦ,ݿнһּ򵥡ı̹ߡASPҳļĸʽ.aspڳڸֶ̬վС ASPһַ˽űдж̬ҳWebӦóASPҳ԰HTMLǡͨıűԼCOMȡASPҳӽʽݣ߱ҲԴʹHTMLҳΪûwebӦó HTMLȣASPҳص㣺 <br />\r\n<br />\r\n1ASPʵͻƾ̬ҳһЩƣʵֶ̬ҳ <br />\r\n<br />\r\n2ASPļǰHTMLɵļеģ޸ĺͲԣ <br />\r\n<br />\r\n3ϵASPͳڷƶASP򣬲HTMLʽ͵ͻϣʹøASPҳ <br />\r\n<br />\r\n4ASPṩһЩöʹЩʹ˽űܸǿԴwebлȡûͨHTMLύϢڽűжЩϢдȻwebϢ <br />\r\n<br />\r\n5ASPʹ÷ActiveXִиָȡݿ⡢ŶǸEmailļϵͳȡ <br />\r\n<br />\r\n6ڷǽASPִеĽHTMLʽؿͻʹ߲ῴASPдԭʼ룬ɷֹASP뱻ȡ<br />\r\n<br />\r\n12 ʲôphp<br />\r\n<br />\r\nPHPһڷ̬վĽűԣPHPHTMLվҳһߴҳʱ˱ִPHPִнߵУASPCoildFusionȻPHPǲ֮ͬPHPԴͿԽƽ̨PHPWINDOWS NTͶְ汾UNIXϡҪκԤȴٷҲҪmod_perlĵʹķڴӳСPHPĵԴ٣PHPΪApache Webһʱд벻ҪⲿƳ򣬷Ҫеκζĸ <br />\r\n<br />\r\nܹҳ⣬PHPܷHIIPı⡣cookie,ǩضûṩ˼õͨ</p>\r\n</td></tr></tbody></table>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('546','','1240126684','566','39','1','0','ݿ⣨DBCɸⲿPDFĵXMLκ顣 <br />\r\n<br />\r\nPHPĿIDE&lt;php ΪĿʼ &gt;ΪPHPĽȻҲô &lt;% %&gt;ı&lt;script LANGUAGE=php&gt;&lt;/script&gt;ASPĸʽ PHPPHPЩ־䴦е顣 <br />\r\n<br />\r\nPHPıCPerlʹ֮ǰûҪκαҽHashǺܼ򵥵顣PHPһЩΪ֯ʹĴṩܺõİ <br />\r\n<br />\r\nȻPHPApacheܿУPHPվһЩMicrosoft IIS  Netscape Enterprise Serer޷ϵָûcopy PHPĻ http: //www.php.com أҲʹòֲᣬ߰еĹPHPĹܺԵ˵<br />\r\n<br />\r\n13ʲôprֵ <br />\r\n<br />\r\nʲôpr PRֵȫΪPageRankPageRank(ҳ)GoogleһҳҪԡһַTitleʶKeywordsʶ֮GoogleͨPageRankʹЩߡҪԡҳվӶԺ <br />\r\nPRֵΪ10һPRֵﵽ4һվˡ <br />\r\nPRֵPageRankҳļȡGoogleĴʼLarry PageGoogle㷨ʽһ֣ʶҳĵȼ/Ҫԡ11010Ϊ֡PRֵԽ˵ҳԽܻӭԽҪ磺һPRֵΪ1վվ̫жȣPRֵΪ710վǳܻӭ˵Ҫ <br />\r\nǿ˵һվⲿԽPRֵԽߣⲿվļԽߣMacromediaվվϣվPRֵԽߡ磺ABC.COMվһXYZ.COMվӣΪABC.COMվṩһЩϺõվݣӶGoogleXYZ.COMΪABC.COMվͶһƱغͰװGoogleվPRֵ ʾ1. <a href=\"http://www.abc.com/\" target=\"_blank\"><font color=\"#0000ff\">www.abc.com</font></a> abc.com prֵǲͬʵġ [url=http://www.abc.com<a href=\"http://www.abc.com/a.htm\" target=\"_blank\"><font color=\"#0000ff\">www.abc.com/a.htm</font></a>]<font color=\"#0000ff\">www.abc.com</font><a href=\"http://www.abc.com/a.htm\" target=\"_blank\"><font color=\"#0000ff\">www.abc.com/a.htm</font></a>[/url] Ҳǲͬ 2. prߣҳЧͺã prߣӣҳǰ Ժܶ౾prߣкܶprߵӣؼǰ 3.pr һ3¸һΣмֵ prվӣӳȥĵվͱͷվprߡ <br />\r\n<br />\r\n14 βѯһվPRֵ&nbsp;&nbsp;<br />\r\n<br />\r\nܼ򵥣ԵgoogleĹٷվȥװһ google toolbar ȻڷҳʱĲ˵ֻһprֵʾȻҲкܶվṩ߲ѯprֵĹ, <a href=\"http://tool.admin5.com/\" target=\"_blank\"><font color=\"#0000ff\">http://tool.admin5.com/</font></a><br />\r\n<br />\r\n15 ʲôFTP<br />\r\n<br />\r\nFTP(File Transfer ProtocolļЭInternetʹ÷ǳ㷺һͨѶЭ飬ΪInternetûļ(ļϴ)ƶġҪʵFTPļ䣬˶װ֧FTPЭװĵϵĽFTPͻװһ˷ϵĽFTP <br />\r\n<br />\r\nͻFTPʹ÷ܼ򵥣ҪԶӣȻԶԶյ͸ӦִȷĿǰWindowsϵͳõFTPCUTEFTPFTPһƣǾǣûĳûעȨûûͿͲļ䡣FTP⣬ûanonymousΪûEmailַ¼ӶʹûԴ<br />\r\n<br />\r\n<br />\r\n16 ôϴԼݵռ <br />\r\n<br />\r\nFTPߣļ乤ߣcuteftpҳϴWEBָĿ¼ <br />\r\ncuteftpϴ岽裺 <br />\r\nCuteFTPĴĸ֣ǱļұǷϵļϴص <br />\r\nCuteFTPĲ˵ļվղվǩFTPַ<a href=\"ftp://yue.hhh.net/\" target=\"_blank\"><font color=\"#0000ff\">ftp://YUE.HHH.NET</font></a>ûӾͿˣһͻʾӳɹȻѡ񱾵صõҳڵļоͿԿʼϴˣ <br />\r\n<br />\r\n<br />\r\n<br />\r\n17 ʲôCMS<br />\r\n<br />\r\nCMSContent Management SystemдΪݹϵͳ <br />\r\nCMSģƣԼӿվٶȺͼٿĳɱ <br />\r\nCMSĹֻܲıҲԴͼƬFlashͼʼ <br />\r\nCMSʵһܹ㷺ĳƺһĲͳŷ򣬵ۺԵվ򶼿ԱΪݹϵͳ<br />\r\n<br />\r\n18 ʲôIIs<br />\r\n<br />\r\n&nbsp;&nbsp;InternetϢInternet Information Services¼IIS΢˾ṩĻMicrosoft WindowsWindows NT汾ĿѡWindows 2000Windows XP ProfessionalWindows Server 2003һУֵעǣձʹõWindows XP home汾ϲûIIS<br />\r\n<br />\r\n19 ʲôз<br />\r\n<br />\r\nһ̨ͬľҪԴġ˵ftpļϴأһ̨ΪFtp֮ļͿͨIPַзˣϴضWEBҲһֻվģûͨIPַʡ<br />\r\n<br />\r\n20 ʲôSEO<br />\r\n<br />\r\nUse some technics to make your website in the top places in Search Engine when somebody is using Search Engine to find somethingӢһɼΪŻ֮ص֪ʶSearch Engine Marketing(ӪSearch Engine Positioning涨λSearch Engine Ranking<br />\r\n<br />\r\nSEOҪͨ˽ץȡҳ桢νԼȷĳһضؼʵȼҳصŻʹӶվվļ <br />\r\n<br />\r\nŻôһּѭѧȫۻƣվṹҳԺվĻ⽻ԵȽк滮վǱʹонǿȻƣӶԴٽҵۺǿƷá<br />\r\n<br />\r\n򵥵˵SEOһվڰٶȣȸ裬ŻýϺõӶӮøǱڿͻһֵӪʽҲSEM(Ӫһַʽ<br />\r\n<br />\r\n21 ʲôB2B<br />\r\n<br />\r\nB2Bǣbusiness to bussinessдҵҵ֮ͨвƷϢĽ. B2Bҵҵ֮ͨвƷϢĽ B2Bҵʵֵƶҵҵչһ㣬ҵֱӵǽͳɱЧʣӳԶҲܴ޶ĻرǰȣҵսԽԽϢĽϡ˾CEOʶΪܱҵľϢҵأµϢͶǿҵʵڸҵճ<br />\r\n<br />\r\n22 ʲôC2C<br />\r\n<br />\r\nC2Cconsumer to consumerҲнClient to ClientҲûûĵԱûûȡѵĵվC2Cվ.<br />\r\n<br />\r\n23 ʲôweb2.0<br />\r\n<br />\r\nWeb2.0Web1.02003ǰĻģʽµһ໥ӦõͳƣһδӺݵⲿӦõĸWeb1.0ͨhtmlҳģʽݸḻϵԸǿԸǿWeb2.0ģʽķչѾΪµķչơ <br />\r\nWeb1.0Web2.0ת䣬˵ģʽǵġдͬ衱չɱؽջϢ컥ϢӻɵԪϣɡҳ򡰷/¼Ϣչӹϣɻ.<br />\r\n<br />\r\n24 ʲôdiv+css<br />\r\n<br />\r\ndivǲ cssʽ ˵ҳĺ ,˵ĳЩҳϵƯdiv,Ƿw3c׼ҳַdiv+css׼ᳫһַǣxhtml<br />\r\n<br />\r\n<br />\r\n25 ʲôݿ<br />\r\n<br />\r\nݿ\"ݽṹ֯洢͹ݵĲֿ\",ھùճУҪĳЩصݷŽ\"ֿ\"ݹҪӦĴ磬һЩλҪְĻ(Ա䡢ʡ״)ڱУűͿԿһݿ⣬ͨͿԸҪʱѯĳְĻҲԲѯĳڵְȵȡЩڼԶУǵ¹ͿԴﵽߵˮƽ⣬ڲֿȹҵҲҪڶ\"ݿ\"ʹüʵֲ񡢲ֿ⡢Զ <br />\r\n˵ˣݿǰ˳еĺܿѧݼϡʱĳ˳򣨻лУӣʱʱ԰һ˳ȡݣʮַ㡣<br />\r\n<br />\r\n26 MYSQLݿôݻָ<br />\r\n<br />\r\nݿabcd <br />\r\nlinuxϵУݿ·/var/lib/mysql/abcd <br />\r\nwindowsϵУݿ·ǣ...\\mysql\\data\\abcd <br />\r\n<br />\r\nŷݣһֱӱļУһǱݡ <br />\r\nֱӱļбȽϷͰȫҪȰݿͣˣ <br />\r\nһֱmysqldumpݣҪݿӦ÷ͣ.<br />\r\n<br />\r\n27 mssqlݿԶ̸<br />\r\n<br />\r\nSQL ServerݿⱸַʽһʹBACKUP DATABASEݿļݳȥһ־ֱӿݿļmdf־ļldfķʽҽʹõڶַʽıָ</p>\r\n<p>&nbsp;</p>\r\n</td></tr></tbody></table>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('544','','1240126531','565','39','1','1','<p>30УѧǵĿǰΪֹûбȽϳ졢רԸݴѧĵվ3ԭʶĸũִѧѧΪ˿У԰վƷߵһǵĴҵӵĹע</p>\r\n<p>ûӮ ׼־ս</p>\r\n<p>3ѧ66У԰(<a href=\"http://www.66xiaoyuan.com\">www.66xiaoyuan.com</a>)ݰУ԰̳ǡУ԰רҵҵĻýȸ棬۵ƷԴסи档ռũִѧһ¥ײֿ⣬ڷż̨ԺһЩ׼Ҿߡ66У԰ҵŶӵİ칫ص㡣</p>\r\n<p>ܼª˼˵ǸũִѧͨŹרҵ2008ҵվӪˡ</p>\r\n<p>߼ߣ20083£66У԰ҵŶ12£վʼӪũִѧרҵ2009ҵȺԸƷɹֲﱣרҵ2008ҵսվļά</p>\r\n<p>30УѧһܴгǵĿǰΪֹûһȽϳ졢רԸݴѧĵվȺ˵Ȼҵ66վûʵӮǿ׼гȥ</p>\r\n<p>ǰʵӮϣڽ°ꡣҪһù˿ͽܵḶ́Ҫʶվվá˵ȡִʩڸݸУƹվƷơ</p>\r\n<p>ơ ɴҵŶ</p>\r\n<p>ڴҵ֮ǰǲʶǹͬ־ߵһ20078£ű1ԪǮĳѵųǸУƹҵ䣬ڸũִѧٰһԽǮμѵֻ2ˣоͰȺԡ</p>\r\n<p>ǱơġȺЦ˵֮ԲμѵΪҲдҵ롣ʶܺҾһµˡ</p>\r\n<p>2007ףȺԶƵġͰ֮͡3ϣ˯ž룬ʲôʱԼһڵ</p>\r\n<p>ͨУ԰̳Ⱥҵ̳ս̸ˣû뵽һļϡ˾ߵһ</p>\r\n<p>ʼʱܶ⣬ҲԽľ飬ֻܿԼȺ˵ԽűҵĳȺԣѾҵܺսѹԵôˣǡÿ˽ͻʱϣ</p>\r\n<p>ֻҪһ˿ͣҲҪá2µףǵĴҵ̨ĹעȺڽӼ߲ɷʱʾֻҪڣͻվȥ</p>\r\n<p><br />\r\n: վ(<a href=\"http://www.admin5.com\">www.admin5.com</a>) Ĳο<a href=\"http://www.admin5.com/article/20090417/143322.shtml\">http://www.admin5.com/article/20090417/143322.shtml</a></p>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('545','','1240126684','566','39','1','1','վ֪50&nbsp; &nbsp;&nbsp; &nbsp;&nbsp; &nbsp;&nbsp;&nbsp;ҾĺõĻһҪ <table cellspacing=\"0\"><tbody><tr><td><p>1 վĲʲô<br />\r\n<br />\r\n1һռռ <br />\r\n2Լ<br />\r\n3Լվ <br />\r\n4 ϴԼݵռ <br />\r\n5ƹԼվ<br />\r\n<br />\r\n<br />\r\n2&nbsp;&nbsp;վҪЩ<br />\r\n<br />\r\nƼҳͣFLASH+DREAMWEAVER+FIREWORKS <br />\r\nFLASHԴСٶȿҳ <br />\r\nFIREWORKSƸλͼʸͼΣͣťָͼƬ <br />\r\nDREAMWEAVERۺϹǿվܡ <br />\r\nFRONTPAGEãÿЧ <br />\r\n<br />\r\n<br />\r\n3 ʲô<br />\r\n<br />\r\nӼǶInternetڽIPַӦһַһɶϲɣ֮Ӣĵľ\".\"ָһ\".\"ұֳ߲ΪTLDҲΪһһ\".\"ֳ߲ΪSLDֳ߲ΪԴƣÿһһķ䡣 <br />\r\nƵICANNͷ䣬Ϊͨö(gTLD, General Top Level DomainҲΪ)͹Ҵ붥(ccTLD, Country Code Top Level Domain) <br />\r\nͨöûŵֻ.com.net.orgͨöInterNICĿǰICANNίNetwork Solutions˾еInterNICк͹Ҵ붥240ɶĸдʾֱͬĹң.cnйĹҴ붥CNNICĿǰйίйѧԺϢĳеCNNICк͹ <br />\r\nҵǶ\"ҵ̱\"ҵǳԼ̱꣬Ϊ̱ҪԺֵҲѱȫҵʶ̱궼ڸԵķھΨһԣInternetķչҵĽǶȿ̱ǱĬϵԣ̱һĹͬص㡣ҵѡʱϣúԼҵ̱һµǣ̱־иǿΨһԡ <br />\r\nֵǶǻĶҲһϡеȫԴICP͵񣬻ϿչҪʼһ˳ƹǻҵվɹĵһ<br />\r\n<br />\r\n4 ν<br />\r\n<br />\r\nIPַת̡IPַ·ϱʶվֵַΪ˼򵥺üǣipַʶվַĽDNSɡ <br />\r\n <br />\r\n<br />\r\nɰµĲ <br />\r\n1ͨƽ̨ <br />\r\n1<a href=\"http://idc.admin5.com/---\" target=\"_blank\"><font color=\"#0000ff\">http://idc.admin5.com/---</font></a>ͨIDӦ¼ͻϵͳ---------Ҫ---&gt;---дIPַ---趨ϵͳԶ---Ч <br />\r\n<br />\r\nA.ԭ¼ý30ȫDNSЧ <br />\r\n<br />\r\nB.Ѵڵ¼IPַ޸ģڹƽ̨DNS30ЧȫDNSһ6-12СʱЧ <br />\r\n<br />\r\n5 βѯһǷע <br />\r\n<br />\r\nʹWHOISѯ WHOISһѯѾעϸϢݿ⣨ˡע̡עں͹ڵȣͨWHOISʵֶעϢѯWHOIS Database WHOISѯϵͳֹ֧WHOISѯWHOISѯӢWHOISѯWHOIS ѯҲԵ<a href=\"http://tool.admin5.com/\" target=\"_blank\"><font color=\"#0000ff\">http://tool.admin5.com/</font></a>ѯϢ<br />\r\n<br />\r\n6&nbsp;&nbsp;ʲôطע<br />\r\n<br />\r\nƼע<br />\r\n<br />\r\nйƵ&nbsp;&nbsp;<a href=\"http://www.35.com/\" target=\"_blank\"><font color=\"#0000ff\">www.35.com</font></a><br />\r\nй&nbsp;&nbsp;<a href=\"http://www.net.cn/\" target=\"_blank\"><font color=\"#0000ff\">www.net.cn</font></a><br />\r\nй&nbsp;&nbsp;<a href=\"http://www.paycenter.com.cn/\" target=\"_blank\"><font color=\"#0000ff\">www.paycenter.com.cn</font></a><br />\r\n&nbsp;&nbsp;mgt.dns.com.cn<br />\r\nй&nbsp;&nbsp;<a href=\"http://www.bizcn.com/\" target=\"_blank\"><font color=\"#0000ff\">www.bizcn.com</font></a><br />\r\nй&nbsp;&nbsp;<a href=\"http://www.ename.cn/\" target=\"_blank\"><font color=\"#0000ff\">www.ename.cn</font></a><br />\r\n<br />\r\nidc.admin5.com б˵1ǮCN㲻Ͷ̫ʽĻûȥעᡣ<br />\r\n<br />\r\n<br />\r\n7 ʲôվռ<br />\r\n<br />\r\nվռ䣬򵥵ؽǴվݵĿռ䣬ʱͨͿԷʵԷվݣȻ󿴶Էվ£֡Ӱʲôġ<br />\r\n&nbsp; &nbsp;&nbsp; &nbsp; վռԲר÷վǲר÷?ҪվԤڷչ״ۺϿǡվ<a href=\"http://www.admin5.com/\" target=\"_blank\"><font color=\"#0000ff\">www.admin5.com</font></a>һ㽨ǣһСҵվݱȽ٣ܼ򵥣Ҳ󣬲ɣ޷վӪվĳЩ⹦ܣӦǲר÷ķʽ90%ϵվǲ.һ˵ҵվĿռСͿ,ʵվҪһ,طֵӰȴվҪԼ齨WEB.<br />\r\n<br />\r\n8 ѡվռ <br />\r\n<br />\r\nվ֮ҪһվռܷվݣѡվռվռʱҪӦǵذվռĴСϵͳһЩ⹦ݿ֧֣վռȶԺٶȣվռ̵רҵˮƽȡһЩͨҪǵݣ<br />\r\n&nbsp; &nbsp; 1վռ̵רҵˮƽͷѡվռĵһҪأѡȽϵµĿռ̣ܻܿվӪ⣬վ޷ʵʱѵõʱĽӰӪĿչ<br />\r\n&nbsp; &nbsp; 2ռСϵͳһЩ⹦ݿǷ֧֡ɸվռõĿռ䣬ԼԤԺӪӵĿռѡĿռСӦ㹻ӰվСһ˵ռԽ۸ҲӦϸߣһΧȨ⣬ҲûбҪĿռ䡣жֲͬãϵͳݿõȣҪԼվĹѡܣվ֮ǰ˽һƷվ֮Ҳʵṩ̡<br />\r\n&nbsp; &nbsp; 3վռȶԺٶȵȡЩضӰվҪһ˽⣬ܣʽ֮ǰ</p>\r\n</td></tr></tbody></table>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('523','','1240049871','545','31','1','1','<p>벩CMSΪйCMSƽ̨֮һ벩ٷԹٷվҪV7棬V7λΪCMSĴ棬ڹϾд£ͬʱ˼·վӪá</p>\r\n<p><strong>V7ļҪ</strong></p>\r\n<p>Ĺעվͨվݵӯģʽٽ档</p>\r\n<p>벩ٷվǻĺģվȫӪĻƽ̨벩ٷЭվһӰվվ</p>\r\n<p>V7ǿԱģ벩ϵ°汾Żϸڣıǰֻؼ</p>\r\n<p>D벩Ŷǿû飬עؿŶӽ裬ʵ͡ӯϵͳ𲽡Ȳƽ</p>\r\n<p><strong>V7沿ֹ£</strong></p>\r\n<p>1V7ǶС֧ƽ̨ΪվӮṩֻ֧Ϸ֧ȡ</p>\r\n<p>2V7PWDZһ.벩CMSPWϰʵֻԱPWݣͼƬʵ޷͡Ŀ»ţרͼƬCMS+BBSŵȡ</p>\r\n<p>3V7վ߱ģ飬ṩֻŷϵܡ</p>\r\n<p>4V7֧ģϵڰģ</p>\r\n<p>5V7֧FTPļָ֧ͨFTPԶ̷.</p>\r\n<p>6V7Ͷ幦ܽϸǿͼĿݼ顢ȶϸ</p>\r\n<p>7V7רҳ潫ִݷḻʽܵCMS¡ͼƬBBSӡҳӱǩר⹦.</p>\r\n<p>8ȵ㣺V7ҪϵͳҳܵΪվҳʾվϵ</p>\r\n<p>9V7ؽԶ幦ܣͬʱϵͶƱܽһǿ,֧PKʽͶƱѡͶƱ.</p>\r\n<p>10V7ҵԱ˻Աֻ֤֤ͨ</p>\r\n<p>11֪ϵͳվںϣṩϵѯ֪ʶ</p>\r\n<p>12ǩֵ֧ԶݡϵͳԴƸۺȶĬģ͡</p>\r\n<p>13,-----V6۹ܽŻ, ûиĶ,.</p>\r\n<p>14V7ûͨԱƼ»û;źȵſͨǩơ</p>\r\n<p>15RSSĹܡʵֿϡº󷢱ͶƱܡźȵſͨǩơ</p>\r\n<p>16V7ǿŻģͣʺѶŻģͿɹעٷվ</p>\r\n<p>17V7бҳ潫ŻʺĶϰ벼֡ӹҲV6Ż</p>\r\n<p>18ƵͼƬصģŻӦʽ</p>\r\n<p>19V7ṩܡ</p>\r\n<p>20V7ϵͳûϵҵۺվҵԸ˵ķģ͡</p>\r\n<p>21ǿר⹦ܣվͼƬ⣬Ƶݡ</p>\r\n<p>22ȵ㣺V7ϵͳ֧ûԻϵͳ칦ܣûɸҪܣӶֻԼҪܵĺϵ</p>\r\n<p>йϢ֮·ϣ 벩ΪڽܳŶӣΪûãϴΪû顢ȿʵá׿ԽĻƷ</p>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('524','','1240050071','546','32','1','1','<p>Ϊйƽ̨֧Ŷ֮һqibosoftPHPwind˴ٶЯ֣qibosoft V5.0PHPWIND 7.0ϺV6PW7.0ٴǿϡCMSBBSں⣬ CMS+BBSƽѾγɡ</p>\r\n<p><strong>qibosoft V6PW7.0ϰ潫¼㣺</strong></p>\r\n<p>ԱPWݣûӵ׷١޸ġ鿴V6ԱĽСV6ԱĽΪqibosoftϵ֮һ</p>\r\n<p>ͼƬʵ޷͡PW̳ͼƬǳ͵CMSϵ</p>\r\n<p>qibosoft PWʵĿ»ţͬʱʵ־̬</p>\r\n<p>V6רͼƬʵCMS+BBSšͬĿпɻϵͼƬ</p>\r\n<p>qibosoft PHPwindܽԭԴŻϣƽ̨ϵøи</p>\r\n<p><strong>qibosoft V5.0PW7.0ϰй£</strong></p>\r\n<p>һϢͬ</p>\r\n<p>̳ӿƼqibosoftվϵͳʾ</p>\r\n<p>qibosoftϵͳ̳ϵݶܲվ</p>\r\n<p>ġͬע ¼˳</p>\r\n<p>塢qibosoftphpwindͬ</p>\r\n<p>վҳԵʾ̳ĸͳϢ</p>\r\n<p>ߡվͨǩɵʾ̳ĸĿ</p>\r\n<p>ˡվϵͳĲɼܿԲɼݵ̳Ŀٳʵḻ̳</p>\r\n<p>ƽ̨ںϣʹûлͬʱרҵŶӿĲƷûĿڼиǿչԡ</p>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('525','','1240050179','547','32','1','1','<div>ʾ,֧ϴͼƬ,WORD,Ƶ,Ƶ.</div>\r\n<p>&nbsp;</p>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('526','','1240050522','548','32','1','1','<p>ʾʵ</p>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('527','','1240050670','549','32','1','1','ʾ,ֻҪĽ,ʵõ,Ҫ,ٷһһ.<br />\r\n<br />\r\nȻǿƵԶԶֹ,Щһһұչ.<br />\r\n<br />\r\n<p>&nbsp;</p>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('528','','1240051050','550','32','1','1','2009323գйվվרҵIDCƽ̨CNIDC.comʽ߷<p align=\"center\"><img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www_qibosoft_com/Tmp_updir/article/32/1_20090418180444_f8mDG.jpg\" width=\"368\" height=\"111\" border=\"0\" alt=\"9.jpg\" title=\"9.jpg\" /></p>\r\n<p align=\"center\"><strong>&nbsp;ͼIDCƽ̨cnidc.com</strong></p>\r\n<p>CNIDC.comIDCҵB2CףBIDC̣Cվҵȿͻйվվchinaz.com7վҵƣIDC̼ҡվҵûIDCնȺ壬޷϶ĶԽӣ֤˫İȫףڴйרҵƽ̨</p>\r\n<p>ͨڽ׹нƣάͱ֤ƽ̨ĹԣԴ˽IDCҵļ۸սҵ淶ʧûޱϵ⡣</p>\r\n<p>мһƽ̨ܵŻפ۸Ӽ׿ݣͬʱȽϡͨйվվ100ӴûȺԼ60ĻԾûԴڴһйҵרҵ߽ƽ̨</p>\r\n<p align=\"center\"><img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www_qibosoft_com/Tmp_updir/article/32/1_20090418180412_jK2np.jpg\" width=\"415\" height=\"185\" border=\"0\" alt=\"99.jpg\" title=\"99.jpg\" /></p>\r\n<p align=\"center\"><strong>ͼIDCƽ̨cnidc.comʽ</strong></p>\r\n<p>˽⣬ʱʱտϸ֤IDC׹гֵֿ⣬˫ڽױݵͬʱʵ˫ĽװȫΪһƽ̨̼֤ƷԼֽ֣ûƷʽ۵ȸڣһܵıϴʩ</p>\r\n<p>IDCƽ̨˽ܣԽƽ̨ԣȨ汣󻯵ıϾٴ롣ЩϾٴ߱ϼƻCNIDC֤̼ңԼ7˿ȴʩȫάߵȨ档</p>\r\n<p>бϣʹҲӱݡΪƼʹû¿ѭ˹ڹǿ֧ƽ̨----֧ͲƸͨ󶨸УҲΪIDCûṩ˰ȫݵ߽׷񡣶Ʒ෱ƷǿܵϵͳҵҪһ</p>\r\n<p>ΪһIDCҵB2Cƽ̨йܡá⡢VPSϸվռʹõĲͬҪͬʱṩIDCҵѶԼIDCصļ̵̳ȡ</p>\r\n<p>CNIDCķչ̣йվվʼ˰ɣҦܵ2005CNIDCѾƳʱվСйæcnzzͳƵԭվһֱ2008꣬CNZZ˾CNIDC¹滮Ҳճ̣Ϊ2009йվվҪվҲǰ·ߣΪһϸϵB2Cƽ̨</p>\r\n<p>ҾôҵûгϵǾʹһϵû֧ϵǽ֧ϵֻӣлᡣƵ仰ҦƳcnidc.comĳԡҦ˵Ŀǰ׻кܶ಻淶ĵطرIDCҵûһҵ淶ԣڸССIDC̲β롣ʹ֮һǱҵҵ淶Ǳҵ淶гϵǱʵãƷõĹ˾ܹӱ˶һʶǾǣǵŬΪվ</p>\r\n<p>ûҦCNIDC.comIDCҵչеԸ</p>\r\n<p align=\"center\"><img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www_qibosoft_com/Tmp_updir/article/32/1_20090418180427_C2M5c.gif\" width=\"510\" height=\"156\" border=\"0\" alt=\"999.gif\" title=\"999.gif\" />&nbsp;&nbsp;</p>\r\n<p align=\"center\"><strong>ͼcnidc.comйרҵƽ̨</strong></p>\r\n<p><strong>ַ</strong><a href=\"http://www.cnidc.com/\">www.cnidc.com</a></p>\r\n<p><strong>Ϣ</strong></p>\r\n<p><a href=\"http://www.chinaz.com/News/Biz/0323F1Q2009.html\">ɣΪʲô</a></p>\r\n<p><a href=\"http://www.chinaz.com/News/IT/0323F2432009.html\">رϴרҵƽ̨</a></p>\r\n<p><a href=\"http://www.chinaz.com/News/Biz/0323F2452009.html\">ķû</a></p>\r\n<p><a href=\"http://www.cnidc.com/help/index.php?action=artikel&cat=1&id=19&artlang=zh\"></a> </p>\r\n<p><a href=\"http://www.cnidc.com/help/index.php?action=artikel&cat=2&id=28&artlang=zh\">ȫָ</a> </p>\r\n<p><a href=\"http://www.cnidc.com/help/index.php?action=artikel&cat=2&id=23&artlang=zh\">߱ϼƻ</a></p>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('529','','1240051810','551','33','1','1','<div>ʾ.ǵЩģƵ.ظȽӰЧ.ģ͵ĸƹ.</div>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('530','','1240052014','552','33','1','1','418Ϣȸлܲ<a href=\"http://go.tech.163.com/renwu/data/6.html\"><font color=\"#1e50a2\"></font></a>ϣȸйгݶܹõϣҲϳԽ<a href=\"http://go.tech.163.com/info/detail.jsp?id=5\"><font color=\"#1e50a2\">ٶ</font></a><a href=\"http://go.tech.163.com/info/detail.jsp?id=5\"><font color=\"#1e50a2\"><img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://cimg20.163.com/tech/2008/3/31/20080331145327d1893.png\" width=\"18\" height=\"18\" border=\"0\" /></font></a>죬ڲ̳<a href=\"http://go.tech.163.com/info/web/2.html\" target=\"_blank\"><font color=\"#1e50a2\"><img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://cimg20.163.com/tech/2008/3/31/20080331145327d1893.png\" width=\"18\" height=\"18\" /></font></a>ƼרʱʾȥȸйгݶѾһԻƳ²Ʒʹùȸ档<p><strong>ҵԴɹӮ</strong></p>\r\n<p>ͳҵýǿʼָȸ޳ӶǻǮɷõţѻŵϰߡȸлܲΪʱĽʹı仯ȸѾܶഫͳýվַǳõĹϵͨߵĹȸϵͳҲȡ˺ܺõĺһֹӮĹϵ</p>\r\n<p><strong>гݶһ һ</strong></p>\r\n<p>ΪȸйѾǾԵĵһȥǵгݶһԿǵڳɳ</p>\r\n<p>ڹȸĵʾӹȸڲȸĿǰѾǵһˮƽ</p>\r\n<p>ʾжϽǶ˵жϱ׼ĵ㣬ǵһҳĽ˭Խ࣬׵վǷܹ뵽棬ǷǷ¡</p>\r\n<p>ĸָ棬ʾ¶࣬棬ȸԶ֡</p>\r\n<p>ǹȸйгݶڰٶȣ˵Ϊܶ˲⣬֪ŹȸѾãϣһ¡һԭǴҵϰߣΪΪ࣬ԲԸ档</p>\r\n<p><strong>Ψһһ</strong></p>\r\n<p>Ͱٶй½гľܳʱ䶼ҪһֱԵһ⡣</p>\r\n<p>ڹȸ½ƳΪȸ½ƳйΨһһҡͳƬ˾ѽиõ顣ȸһģʽĲƷѵģ͸ģҪдµĹܡȨй½</p>\r\n<p>Ϊ滯ʵǹȸƣսȸĺ飬˵ȸȽһ£ʾĽӦԽԽãԽԽáһõͿû⡣淴Чãй½гƹ㡣</p>\r\n<p>ȸƳ֮ٱҵΪǽڻְٶǿƵMP3ٶչֱӾٶȴǰһЩͳƬ˾ǷȨ˷磬ٶϯִй<a href=\"http://go.tech.163.com/renwu/data/45.html\"><font color=\"#1e50a2\"></font></a>׿ƼרʱʾڰȨ⣬ٶȷǳӣκȨϢɾߣͬʱٶҲϣΪݵṩߡ</p>\r\n<p><img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www_qibosoft_com/Tmp_updir/article/33/1_20090418180432_EwElB.jpg\" width=\"500\" height=\"381\" border=\"0\" alt=\"2.jpg\" title=\"2.jpg\" /></p>\r\n<p><strong>²Ʒû</strong></p>\r\n<p>ʾϣ²Ʒû</p>\r\n<p>ʾͶֵĲ໹ҪһGoogleҪ֮⣬ͿԿơȸ˵ͼҳƬƵ<a href=\"http://tech.163.com/special/00092FUU/blog_tech.html\" target=\"_blank\"><font color=\"#1e50a2\"></font></a>֣κһʣǳؼʻǳβؼʣڹȸõЧ</p>\r\n<p>˼ǿ⣬һЩûϲʴȸҲĽ˺ȸĸҳigoogleƶ͵ͼҲǹȸصǿ򣬡ϰλȸ蹤ʦרעһһЩܺõĲƷ֡</p>\r\n<p><strong>3Gг߻</strong> </p>\r\n<p><strong>3Gƶгȸ˺ܶ׼</strong></p>\r\n<p>ȸոպйƶǩƶЭ飬<a href=\"http://go.tech.163.com/renwu/data/1.html\"><font color=\"#1e50a2\"></font></a>ҲһΪйµ3G棬̹ԣܹȸ豣ֿ̬ԸеĵӪ߻Ϻ˫ޡޣųЩ̻ѡ̡</p>\r\n<p>Ϊ3Gһ߻ùȥķúܿ죬շѵ½3Gռȫȸ費μӸĲƷãֻҲһܱҪ⣬רעĲƷ͵ͼﵽǲƳӲƷ</p>\r\n<p>ȸAndroidֻƽ̨һ⣬ʾȸûӵһѿԴֻϵͳûӵһܺõʹ飬κֻֻ̿</p>\r\n<p>˵йֻ̺͵Ӫ˵ܶϵͳҪֻϵͳÿζҪҪ֧֣ûԴ룬޸Ļǳ鷳ԹȸֻϵͳǽһõĲϵͳѵ͸ƶӪ̺йֻ̡</p>\r\n<p><strong>ҵȹΣ</strong></p>\r\n<p>ӰȫľΣΪҵԽģϣܹйҵ˴ξΣõûԴиõƹ㣬ϷǱȽϿõҵƷƹ½ģû½ôء</p>\r\n<p>ΪǰҵҪͳɱսܹƽĶȹҲڴůʱڸյʱ򣬵õܺõĳɳ</p>\r\n<p>ڽΣӰ죬ʾӹȸͻͳݿӰϴǳҵȸȫɳ6%йɳԶȫ򣬡ȸȥļرĺãǵĳɳԶԶҵͬСһԤƻᱣֺҵһõ֮йҲڱֺܺõ</p>\r\n<p>ƸƻʾȸȫԱܻԻһЩάȶˮƽû½й򱣳һľ</p>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('531','','1240052409','553','33','1','1','<p><span>Ϣ ϢҵйٷչһЩҵʵ˿ٳɳڵǰΣӰ£ҲҪ˼·͵ӢվٿòĻӢϾΪйĻɳ׼ײߡ<br />\r\n&nbsp;&nbsp;&nbsp; <p align=\"center\">&nbsp;</p>\r\n</span></p>\r\n<p align=\"center\">&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p align=\"center\">&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p align=\"center\"><img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www_qibosoft_com/Tmp_updir/article/33/1_20090418190417_93pys.jpg\" width=\"546\" height=\"372\" border=\"0\" alt=\"4.jpg\" title=\"4.jpg\" /></p>\r\n<p>&nbsp;</p>\r\n<p align=\"center\">&nbsp;</p>\r\n<p align=\"center\">&nbsp;</p>\r\n<p align=\"center\"><span><img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www_qibosoft_com/Tmp_updir/article/33/1_20090418190427_FSk2e.jpg\" width=\"548\" height=\"323\" border=\"0\" alt=\"5.jpg\" title=\"5.jpg\" /><p><br />\r\n&nbsp;&nbsp;&nbsp; գȫصĽ200λվվͻӢϾδչӯȽ㻰֣̽ڶվǷԼĴҵԼվĶᡣδȫйչǰհԹ۵ҵʦӦԴɳչҵģʽ߹ƽ̨ҵģʽԼҵչ򡢾ӪվȻۺͷ </p>\r\n</span></p>\r\n<p><br />\r\n&nbsp;&nbsp;&nbsp; գȫصĽ200λվվͻӢϾδչӯȽ㻰֣̽ڶվǷԼĴҵԼվĶᡣδȫйչǰհԹ۵ҵʦӦԴɳչҵģʽ߹ƽ̨ҵģʽԼҵչ򡢾ӪվȻۺͷ </p>\r\n<p>&nbsp;</p>\r\n<p><br />\r\n&nbsp;&nbsp;</p>\r\n<h1><font size=\"4\">CHINAZ:רPHPWind ѧʵһԱ</font></h1><p>611գĺ磬PHPWind Forums v6.3LXBlog v6.0ʽ淢ǰеݵѧϵСɲһ裬º˷۾еһСڲ裬һԸ¶֮ŵԽܲɷõϰߣٲȻҡΪһԱ</p>\r\n<p>ѧ1998һص80㿪ʼʩչԼȤͰáһͶԻ֮кͱע2002ѧϴѧͬʱһѾһְԱˡһʱļѧԼĲƷ2003꽫ص̳ϡĿٷչļѧļзŶһ̼ǿԼƷгǰ2004PHPWindʽΪһ̳ͨĿ2005꣬ҵûоѧԼĲƷͶˣõһǮŶĸУԱߴԼļ˾ͬʱɳԱΪCEO</p>\r\n<p>ѧ̹ڳΪ֮㲻ٲƷзˡԭǹ˾Ա40ˣ80%ǸƷļԱȻǲƷĴʼ֮һԼCEOݼĿԱڲƷ͹˾ķչһֱԼƷĵһߣԼȵû֮зԱĵãԱֲƷûʡ</p>\r\n<p≯ƷѧʾPHPWindṩĽվѾǳ죬ʹվûκμ򱳾£һվͬҲǼ򵥲ҲʧԻPHPWindṩһϵнվ͡SNSϵͳȣվ߿ԸԼ󽫲ͬϴﵽԼĸԻĿǰPHPרעڸΧڵվ֧֣Ϊվṩһֵ񣬰ռ䣬ʹСվվķȡ</p>\r\n<p>ѧΪ̳ΪƷ벩ȽǿгԾ߱չǱ˹˾ĿǰǼḻƲƷҪӭûͳĲϱ仯ڴ˻֮Ϊ߼ûṩ߱ԳɳԵĲƷڴЦƷƴľڹûΪͬѡ</p>\r\n<p>ڻ乫˾չʱѧԼһǲӦ뻯̳ĿóȻڱֹ˾ѧʾʹ˾չЩðˣҲԴûĸѧΪûŵĶһ£̸ֽҪãר·ҲùPHPWindĽơ</p>\r\n<p>̣ڱʵοʱѧ̫༤ÿõĲƷдڵɣںõгϷչҪһ֣ûоûнԼĲƷãͲڵһ͵ڶλ档ڶֵĲѧʾһԴ</p>\r\n<p>֮ǰдԳưͰƷư5000ҵļ۸PHPWindչһ£ѧٴҹ˾ֻ̳Ʒҵû漰κʱסΪ֮ѡPHPWind̳ƷΪPHPWind̳ƷרעͲƷİȫ߸غеĸ١ѧͬʱʾΪ˾ԲƷûĹעʹPHPWindƵƵעһ˳µ¡</p>\r\n<p>ѧڻ뷢չʱЩпPHPWindûĿڱܹȡһЩɼܲףҲûPHPWindϵвƷͬͿ϶רעǷ֮ûа׷ѡ</p>\r\n<p>200611£PHPWindڶ̶̵겻ʱעԱﵽ100</p>\r\n<p>2007վѡ07ʮվѧС</p>\r\n<p>2008612,PHPWind Forums v6.0Ѿ߸ʱ䣬ѧŶһζ˳ŵ</p>\r\n<p>ѧΪȡóɹżȻҲǱȻԼĳԸͲΪӮΪȤڽһмֵĲƷӮȤ˽ԲƷ׷ܻûҳϡ</p>\r\n<p≯ɫĹȣѧΪԼλǱ仯رȽȻùͼڲֵȻѧΪԼȫΪϰ壬һ̸ԼҲƷʱϰ̬ȻʧƵһ¾ͱרҵĿǺ߼˼ά˼Ե쵼ŶӵĹߺͶʷľˡû취˿ֻܹѧӵʣԱеĶԲƷרע꣩</p>\r\n<p><strong>PHPWind</strong></p>\r\n<p>PHPWind2002꣬ڹȥ6ʱPHPWindһֱΪڽվṩֵΪվṩ㡢ЧɳĽվ˾ĲƷ̳ϵͳһ׿ԴϵͳͬʱPHPWindӵڶԭĺļģϵݿĶɢļü㷨ļдȶ㷨ݿؾ㷨ذȫϵȣĿǰѾΪӦù㷺̳֮һ </p>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('532','','1240057138','554','33','1','1','<p><a href=\"http://192.168.0.99/view/762692.htm\" target=\"_blank\"><font color=\"#3366cc\"></font></a>˳ͼĸվվܶվΪϴȻûзչһվȴСվɳ <br />\r\n</p>\r\n<div>&nbsp;</div>\r\nйվͼһܡ<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www_qibosoft_com/Tmp_updir/article/33/1_20090418200452_bsk1Z.jpg\" width=\"300\" height=\"450\" border=\"0\" alt=\"6.jpg\" title=\"6.jpg\" />ͼȺͼĿǰйվȦٲȻһƷƣ֪վۻᶼٲͼĲ룬ͼվзǳءվǶͼԴͼ˵ƷǳáйҵվѾΪһɲСվÿǧٶȿٵƻڼӴ󡣸վ֮࣬ܶСվվǳҪվǰİæͼУǰ˽׵Ľɫ <br />\r\n<div>&nbsp;</div>\r\nƺܶվֻ֪ͼ֣в֪ģܶѶ֪ͼֵͼ֮ԽͼʵΪһվ88gg.comһͼƬվʱǸk6k666վ̳֪ܶվվվɵ˶ǳ̳֮ģʱվǳҲȽģͼƬҲԺովһ㾭飬ʼվһվһ£ѧһ㾭飬࿪һҰһЩʱ䣩ʱֱӵͼƬվ٣У̳ͼͼƬر࣬ͼѸ㵽һproץ̳ͼƬɵĴֱһ̳һ̳ץȡ <br />\r\n<div>&nbsp;</div>\r\nһץͼƬģȻacdsee΢ϴͼܳտִ˲ˣȫֹվһ꣬ϰͼƬֹ˽50ͼƬվʱûзվͼƬһڵһҳһ붼ͼģ50վȻÿվ󣬼ǧipȫͣͼqq֣˶Ǹʱͼʶ˺ܴһ͵վ໥ͨѧϰ֪޲˵ܶδıվγϵ飬ͼĹϵرڶԺ󣬳Ϊÿ˵ĻԾӡһվһվˣ˺2꣬ͼҲ2ѣ ͼ̫ѣҲϵԹ2δڸk6ֹͣԺһֱϺһ齨ˣ˺ܶվȥʧʮgͼƬݷҲûˡһθһѺƹոˡ֧ԺҲʧҺýͼԼ渶ˡӴҲûȥ˵ĳʮ˾Ȼܾ04ϴϴǰͼĽʮͼƬվͼֵۡһУоseoҲд㶫ʲôģÿ̳ǵʺܸߵģҲѽվ棬ƹ㷽棬ô桢ô˹淽ָͼʢˡ <br />\r\n<div>&nbsp;</div>\r\nͼĺܶվܶͨ׬Ǯ߰ԼվҲúܴа֪վݾӡ03׵ʱ<a href=\"http://192.168.0.99/view/2178514.htm\" target=\"_blank\"><font color=\"#3366cc\">gjj</font></a>ʶͼͼݾԼվ棬ȻŪȣݾȻԼоݾڲϷչɾgjjҲɾ͹ݾվƺܶվĳɹ벻ͼİæ <br />\r\n<div>&nbsp;</div>\r\nʵҸʶͼǱȽģʱҶˣ05ꡣ֮ǰһֱվվҲõͼָ㡣ȻҺͼĴҲǺܶ࣬һû鲻ΪԼҲܶ࣬Ҫվͨվѣ˽⵽ͼйվֺôҲƶйķչЩǷǳֵġ <br />\r\n<div>&nbsp;</div>\r\nÿ쿴ͼqqߣqqҲһֱִ˲ˣһվѶwww.2D29.CNϣѸһ㣬վһһЩ·ȡóɹ <br />\r\n<div>&nbsp;</div>\r\nҺеõͼѣͼʾĸлҲϣͼԺҵȡøĳɹ HEHE<br />\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('533','','1240057438','555','33','1','1','<p>ɣԭҦйվվʼˡ1982ˡĿǰǧ </p>\r\n<p align=\"center\"><img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www_qibosoft_com/Tmp_updir/article/33/1_20090418200404_25EwL.gif\" width=\"400\" height=\"316\" border=\"0\" alt=\"9.gif\" title=\"9.gif\" /></p>\r\n<p align=\"center\"><strong>йվվʼˡ</strong></p>\r\n<p><strong>ǳɹ</strong></p>\r\n<p><strong>ǳɹģ۴һרݣǧ۵Ḷ́Ǵ2002꽨йվվ2003йվվͳڸַվҳվƼ</strong></p>\r\n<p><strong>Ŀǰйվվӯÿ¶ǣʵÿ¶ӯ漣ÿֵɺ˵20</strong></p>\r\n<p><strong>רһ</strong></p>\r\n<p><strong>ڻĴֻѡΪվվңֻѡˣԴһҵӯǹ档</strong></p>\r\n<p><strong>רעͶ룬ΪЧ˴ҵ֮ȱԴÿһϸڵ</strong></p>\r\n<p><strong>йվվӵнʮԱҪǼԱйվվĿǰΪҵվҪӯһ档йվվչѾȹ̳죬ǰչȻǣΪվйվԽԽ࣬վĹ˾ҲԽԽ࣬վйĵλԽߣƺעˣרһĸõɡ</strong></p>\r\n<p><strong>ǵ</strong></p>\r\n<p><strong>ɵǣΪȡСҲӪ磬ԴѹйվվtxtļʿݷʽΪץסվ𵽷ǳãĺܶԴվҲ׷ģ°ɵ</strong></p>\r\n<p><strong>ǣ켣k666̳ʱ򣬷̳Ĺ棬ʲôվҪ̻</strong></p>\r\n<p><strong>ҲäĿ</strong></p>\r\n<p><strong>2000꣬ʱҲҳȻһƺܴվҰʵվֻнϷĿȽʱߵĴм˰ɣÿҲй̶롣˺ܶʱվĿϣЩĿȴû취׻˺ܴ߹·ҲΪӵһ̨Ϸ˱ˣȻȥŻվվֱ˲࣬󲻵òص</strong></p>\r\n<p><strong>ҲǴ</strong></p>\r\n<p>ǿ˵ĳɹĳȣҵļ鲨ӿʵÿһ˵ĳɹסɹĲףƺֵþѹע</p>\r\n<p>йվվɳ·ϣҲأмβһ͹ص20023½վ󣬲õ7·ݣΪ^**ݱذ˷Ϊȫ棬վһ¡ʱɽֻɽȥҹá˿ǰѷûˣվ¿š</p>\r\n<p>2004ɵķDDOS˰£Ϊйվվǵķǽʱ䣬ɲûİվȥˡջΪѵİŽ⣬վؿ</p>\r\n<p>ʵУ⣬µİվͷ</p>\r\n<p>Ҳй˳ʮչйվվĶ</p>\r\n<p><strong>ɸߴң</strong></p>\r\n<p>1. ʲô£ˣԼܽᲢ׶ԵһЩ顣</p>\r\n<p>2. ΪȡСһʼҪȫվۣҲô÷չһ˵Ǻ޵ģȫվϻǾϵͶ붼Ǿ޴ģվмС</p>\r\n<p>3. վǸʵʵվòûñȽϳɹĸվⶼȽϵһⵥһζݵһһ⣬λȷͬʱҲ׸ھվСϡֻǿƤë</p>\r\n<p>4. һõվõ+Ҳվչľڡ</p>\r\n<p>5. Ҫ۹⿴Զһ㡣κ鶼ҪȷĿϸеļƻҪи˵ԸмƻĿʵʶ֣ôƻԶͣڱʼǱϵļƻֻ˫ʵ</p>\r\n<p>ֻǣΪʲôֻ֧ܳƽ</p>\r\n<p><strong>ɴҵĹ</strong></p>\r\n<p>2000꣬1982˰רҵˡҵʧҵһֱڼдѵʱġûǮˣƺǸѡʱϷ͸ҳΪ飬ǰ;һƬã</p>\r\n<p>ÿµѴһǧ£ǮĺӣһǸĸͷ֮ޡ20007£Ṉ̀ƵӣɵĸҳȻ׬8848ȤĹٶԪɵһΣ鵽˴׬Ǯĸо</p>\r\n<p>20008£һó˰ɲű߼ʵĺΰġҰˡҰʵվֻнϷĿȽʱߵĴм˰ɣÿҲй̶롣ɻ˺ܶʱվĿϣֻЩĿû취׻˺ܴ</p>\r\n<p>20001025գɽŴѧͶϢרҵܿ췢֣ѧѧҪĶܶ۵ĶҲûа취õʵӦרҵİɱͬѧӴԣܶͬѧ̵Ե顣ңͬѧ˵ʱй̶İɣǸĽӦøоŶԣǣ޶ֵͻȻãǸѧҵ֤˵ûʲô塣</p>\r\n<p>20016£ѧؼңרĽ֮·ԷѧѧҵǷڡúܸɴ࣬ᡣңûΪйĽʧܵģĹ˾ˣкܶڴѧȣᣬȴʲôᡣȫãȺеһû˷ʱ䡣</p>\r\n<p>ڼ䣬ɽ(Ұû)һ̨ΪҪ̨ʱվĲĽĿɽӪҲǡĿ½ΪʱѾؼǵãʼʯʱɷҰûʲôչΪվʲôݶУһɫûУվǸˡһӴվߵİɣ˵ۿҲ˵ǳأ20019£رҰ</p>\r\n<p>Ȼ󰢷ɣͼطŻҲվﳤܰѰɴĶ塣</p>\r\n<p>Щ꣬ΪվҪɳһЩվۼĵطK666Yuzi2002ĻվѾk666һվ̳ܲһЩԴأҲġyuziһṩ̳ȽվģҲһȺվ档ǰɷվòãң룺ԽԽ࣬վҲԽԽ࣬һվվӦûǰ</p>\r\n<p>2001ףɷĽվƻǴԴ֣ʱվСվվܶ඼ֳɵԴ룬ÿվ˵ﶼŸָԴ(Ҳͬ)ǰɰԼռ˺ܾõԴóһʵرۣҿãQQϵһʯæ</p>\r\n<p>ʯʱϰ࣬кܶʱ䣬ɸҪĶϣʯܰһվʯӦˣ򰢷ɱʾֻǰﰢɡʯܲվﲢûеסһֱ˵</p>\r\n<p>һϵͳ޸ĳԼҪģԼҳԴʯ£ɸ޸ġҳվЩ顣ɺʯûûҹŻһʱ䣬еԴ023³ƳվʱվʵֻһԴĿ</p>\r\n<p>йվվҲ˷ǳãһѡ2001עchinazzz.netйվվ˼ʱûǮ򵽸õ20021עchinazzz.comٺƼ˵cnzzz.comüǣǻcnzzz.comվʱõʵcnzzz.comһֱעchinaz.com</p>\r\n<p>վ滮ȴԴ֣Ȼվ̳չʱվռ䣬Ҳͬʱɷ֣ҪվȶǷǳҪġΪһ̨ԼķɽҰĽϷӪȨøɽˣȻдһݼƻ飬ϰҪһǮһ̨</p>\r\n<p>йվվһº󣬾һŵҪͶŹ档һʺ100Ǯĸ档Ӫģʽڴ֮ˣ棬ֱЩˡֻû뵽ô졣һֱڣչٶȱȰԼĿܶ࣬û뵽йվôӵôࡣ</p>\r\n<p>2003꣬йվվѾʮڸվѾһ֪ȣѾڰhao123ڵĸַվҳվƼ̶ܶԶҪͶŹ档</p>\r\n<p>2005°꣬ɵĹ˾ʽĿǰģнʮˣӯÿ¶ǣʵÿ¶ӯ漣</p>\r\n<p>&nbsp;</p>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('534','','1240059129','556','33','1','1','<strong>飺</strong> <p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www_qibosoft_com/Tmp_updir/article/33/1_20090418200406_BlSMk.jpg\" width=\"800\" height=\"532\" border=\"0\" alt=\"9.jpg\" title=\"9.jpg\" /></p>\r\n<p>&nbsp;Ϊй߿ƼҵջĵһˡйϢʹߡں̶У4 繤1981ҵںϴѧϵ1984꣬ڻ粿ηӢʦȫͳֵܷĳɼ¼ȡΪйԺоԺŹӢдרҵо1986죬»ʲʱʿٴѧȫѧѧ1987ףôڴѧ˶ʿѧλ󣬽⽻ѧԺʾʿѧλʿѧλڼ䣬ȫĳ˹˾ˡӵްα༭1991ٻӰЭᡰ99űܳ͡ꡱƺš1993꣬ IDGͶ2000ԪϺίйһҺʼչ˾ظԵܾͬ꣬㶫кһҼʹ˾1998꣬ IDGŲ߻ҿƼƼͶʻڽйļҵṩʮԪĴҵ</p>\r\n<p>ȥһһҼ͹˾кͶʡѡ㡱ĿӮйȲ÷ͶʣлͶʳΪڶ˵롣</p>\r\n<p>Ϥһ˵ľ͸֪ȡᡣ</p>\r\n<p><strong>77ѧ</strong></p>\r\n<p>ںʡ̶С</p>\r\n<p>ʱǡĸĸ״Ӳתҵڵظֳθɲ׵İţ1973꣬뵽һ繤</p>\r\n<p>1977ָ߿һֱѧе˳ϺϴѧǵʱΪŵĹҵԿרҵʱѧУļһԻѧԳӢרҵ뱻ѡϡ</p>\r\n<p>77߿ȡ4.8%ºܽᣬζ㰲һݺù1981꣬ѧҵһαоûͨ󱻷䵽粿ηӢʦ</p>\r\n<p>ںϴѧѧڼ䣬һƪڡձͷ淢Ϊ̽ѧϰӢģ⼤Լ߹Ȥ1984꣬ȫͳֵܷĳɼ¼ȡΪйԺоԺϵӢɱרҵо</p>\r\n<p>ʱͶ»ʣĿľڶߡΪǾ˵ĸ׵Ӱ죬һϣΪһսؼߡ1986꣬ϰ꣬붼»жʵϰ</p>\r\n<p>ھͶоڼ䣬ѧУദǢһԸױǴѧ̽ȥѧϰšΪйŴҵԱȻҪѧϰĵطЩԥȻְҵѾΪȷŶ˽ӣ󡰶򡱣ʦ顣</p>\r\n<p>Ǹ˸ѧĺʱ䣬ṩʦƼţʮƪڡйձӢ֮󣬺ܿͻòʿٴѧϵ¼ȡ֪ͨ飬Ҵѧṩȫѧ</p>\r\n<p>Ϊһʱ벢֪ѧҪиͲܻøǩ֤ȻӢרҵʿ˵ʲô⣬׼ܣ617֣˳ͨ</p>\r\n<p>ڱĲƲһŷĻƱһЩΪõŵƷʱǵ뻹ߣԪȴĲˣͬڸйѧһæһЩֻ֮ʣ38Ԫˡ</p>\r\n<p>ڸ׵Ļͱ£ԭѾȶй˴38Ԫ</p>\r\n<p><strong>һ</strong></p>\r\n<p>̵ͷ죬ڵִ֮ĵˣҲλױǴѧʦ͵ѧУʱᣬΪ֧ϼ44Ԫ֮100Ԫ룬˵ĸǮ</p>\r\n<p>ڶ죬ȥѧУҵһ̵Ĺÿ¿׬375ԪȻҵһ˺ķӣÿֻҪ100ԪҵʱҵһװгĹ˴绰ҪΪ֧˵ˣ˵ȫҶΪ㽾!</p>\r\n<p>ϵѹȻڣȻʿٴѧϵĿγΪֻ꣬һĽѧ𡣳˼ӱѧҵ֮⣬뻹Ҫϴ򹤻һЩ롣ð˸µʱеѧ֣׫дģ˶ʿѧλºܽ᣺˿ܾһ飬ֻǾѹ</p>\r\n<p>˶ʿҵ󣬲ʿٴѧ빥ʿĽѧ𡣵յ˸⽻ѧԺĽѧ𣬸ѧԺΪĴѧѧϰ죬תѧѧԺʾʿѧλ</p>\r\n<p>ְ֮ҵܵ˲ʿٴѧѧԺĿ϶1998꣬ѧԺ롰ܳУѡƺšųڵĳɾͣרҵڵһλܳĴһͬ񽱵Ļ007ϵӰƬյ۹ľ˲³˹-Ѷ˹̹ߵHBǪܲ-</p>\r\n<p>ڹʿڼ䣬䵼ʦѴһйĵ࿯ҪһȶֶŵˣȥӦ˳˹Ƹáǿְڡӵһɾ͸ꡣΪ빤һֱûɲʿġ</p>\r\n<p>ڡӵڼ䣬ǡʱżŶ³ʷڸ⽻ѧԺݽӵ̡˺ܶҵʿIDGġ</p>\r\n<p>ϯĶ̸ġ硷һ£ʶԺϰġ</p>\r\n<p><strong>[IDG]</strong></p>\r\n<p>ٷչϢҵڴƻ΢ҵͷͬʱҵҲ˶гѶĴ</p>\r\n<p>19645000ԪһҼго˾ݹ˾IDC󣬹ݼŹ˾IDG</p>\r\n<p>Ķйгжԡǵһλй½ҵˡ1980Ļеҵĵӹҵʳй˾ˡ硷ܱ</p>\r\n<p>2000228գĸУʡѧԺ3.5ԪҲʷϸѧṩһʾӦ˾߲쵼аݷйҵҡǰã102йĵѡΪ2007й</p>\r\n<p>1991꣬̿ʱڵġӵѾͣ˹žûڵʱĻйչȽѣϣۺ̨幤Ȼϣͬиϵͳϵġ</p>\r\n<p>һ̸֮£ΪͶԵ116ţʽְIDGְĵһݹǰѹڵʱġʵӱϲ硷Ķİ·ʽΪ⣬ʱڿ̫гͬ졣</p>\r\n<p>һ·У˽˸ԶгĿʱIDG̫ҵֱλ˴һˣפۣ¼¡ǵȵأһˣפ̨壬̫˹ͬóһݱ档</p>\r\n<p>ǡĩʥǰϦλ˶ȥȼˣŬݱ档ľΪ̫ΣΪ̫ܲá</p>\r\n<p>һϷԵľºڽ˷̸ʱ䣺һ룬˵Ȼҵıˣ뿴˼ҵģ˵ıҿ˵û˵Ҫȥȼ٣æɣⰲŹԺפ̨ĵطҲȥˣҲ뿪˾ˣһ۵ܾ񵽼ôȥˣûô˵ҲãΪǴҲûʲô취ΪһᣬдǾͲܹҡ</p>\r\n<p>&nbsp;</p>\r\n<p><strong>IdgVC֮Ӯй</strong></p>\r\n<p>1993꣬IDGͶ2000ԪϺίйһҺʼչ˾̫ƽͶʣй𡱣ΪIDGҵͶʻ𡱣ܾ</p>\r\n<p><font color=\"#666666\">Ҹע ѶԴ֮Ʒ(֡ͼƬͼƵ)δѶȨκý͸˲ȫ߲תءתأѶ(010-85650997)ϵɺתעΥ߱׷</font><br />\r\n19981027IDGƼǩ¼ƻδ7ʱйӪһʷͶʻԷСƼҵºڽܡܿĲɷʱ˵˵lDGںһͶʣ˵ҵһע</p>\r\n<p>ʱڶԷͶȱ˽⣬һʱڣԹ㹻Ŀ⡣һ棬طϣͶʾض򣬻ضͲṩӦŻݴʩҵֻⷽռɳ25%ſܵŻݡIDGͬطģҷͶСռɣպںҵӵг25%Ĺɷݡ</p>\r\n<p>һΪؼǣ뱾˲ûд¹ͶҵԷͶʵʶԴ¼ڼʿĲɷá20072ڽܡʱɷʱ˵оǸ׵顣</p>\r\n<p><strong>[ӳƴ]</strong></p>\r\n<p>뱾ṩ֣IDGĵһ֧Ǵ1993꿪ʼ2003ΪֹرΪ36%ڶ֧Ǵ1999꿪ʼرʳ40%</p>\r\n<p>IDGѾͶ200ҹ˾ںейУһϵĹ˾IDGڲͬ׶νIDGͶʹҵѶٶȡѺѷ3721ȤWeb2.0ĿУIDGͶѶסѡ</p>\r\n<p>νTMT򣬿Ψһи֪ȣIDGûнľǰͰˡºͣõ500ԪķͶɸʢǣͷڹöģʼͶʡʼԵ롣</p>\r\n<p>IDGйͶɹɺܼ򵥣Ļ˵ǣɽϻӳƴйҵṹһУ˺ܴı仯ȻڹʱIDGһǡôʱһ</p>\r\n<p>йûзͶʵʷȻIDGŶӴΪ·ңΪˣʱĻۣγһ׸гʵ׼һ棬IDGͶĿӣγˡģƣһĿ漰ҵIDGעʵĹ˾һѶΪ֣һIDGԴǣߴƶҵչ</p>\r\n<p>йгãͶҡIDGʼĻת̨ǰȲĴҵѡĿӮйΪ3000ԪҺֵIDGṩ1000Ԫ뿪ʼΪ֪</p>\r\n<p><strong>õǵǮ</strong></p>\r\n<p>վԿһʱڡӮйеı֣һЩڲӦԼĲдʱꡢ̱شѡֵĻشܲ˵б˵Ŀ⡣</p>\r\n<p>һ⣬ȡͶĿĹؼʲô</p>\r\n<p>ʵйͶʵĳɹʷǳ֮ߣߵܶӦͶʡʡӡϣͶʿͶ10Ŀܹɹ1йҪߵö࣬Ϊ־IDG˵෴ҲͶ10Ŀ5ɹˣΪIDGֻ12%Ŀʧܡ</p>\r\n<p>ҵʿΪйгģ졢ɱ͡ΪTMTҵҪʱһ飬ĿǰϺʦнȻֻйȵ1/10</p>\r\n<p>&nbsp;</p>\r\n<p>ԭ֮⣬Ҫһ㣬й˺ƣҵģʽڳгõ˺ܺõļ飬ӦйҵڿĻᡣÿһйҵ亣ԭͣٶȸ衢ѺŻѷ˵Web2.0ҵˡ</p>\r\n<p>ͰµĲƷҲԭ͵ģֻǴİһЩйӦʵչƹ񣬻Դں֮ǰṩƷ񣬶ͨһҲǽeBayC2Cϵ</p>\r\n<p><font color=\"#666666\">Ҹע ѶԴ֮Ʒ(֡ͼƬͼƵ)δѶȨκý͸˲ȫ߲תءתأѶ(010-85650997)ϵɺתעΥ߱׷</font><br />\r\n˶ӦڵķͶ̻ڿ͵ҵ񣬶ǻڱгҵ¡ȻҲ⣬ڴýûܵʱĹ</p>\r\n<p><strong>[νִ]</strong></p>\r\n<p>͸˵ͶҪԶʱڻø߶رʷʽ</p>\r\n<p>Ͷ̻濼⣺ִ˵ıζƶԴһǴĿĿɲۡ</p>\r\n<p>IDGǡʱСĺ飬ýйȻǸ߱ݵҵ٣ÿŷǳѡʱСͨŬܲŹξֵ֧֣ܲŲʱ֧졶ʱС2000ѡⷹ꡷͡йεתɡʱС־졣ⷹ꡷ΪʱмҾӡ³棬йεΪʱн</p>\r\n<p>IDGͶʵѷ䴴Īȫ֮ǰι˹Teleres޼йܾ˹TeleresĻزѶ̣ʵĪȫ˹Teleresչ׶Ρ</p>\r\n<p>һ棬µҵԽֱۣԽԽãζɲԡѷҵģʽܼ򵥣㹻ƶ߹йزҵںܳһʱ䶼Կá߻һǶȣ͡ʱСԣҵԱҪ㹻ļܣǲƾôѡ</p>\r\n<p>ΪʲôһʱվڡֻܲվʶֵͶߵҪַҵģʽܼ򵥣ԱûҪƶ߹Ȼ߹гһֱͷȻǣ̫뵽һȥˡ</p>\r\n<p>ɻһģĿ꣬һҵƶò˳ôͶٻѡһĽͶʴӡ</p>\r\n<p>šӮйĿﵽΨһίھͷǰ磬ǺѡʽɸѡƣǷܹѰٵʵͶʻᣬȻд֤</p>\r\n<p><strong>ʱ</strong></p>\r\n<p>2006930գôƵ꣬ڵĽ조BazaarǴҹֳ99999ԪFendi BִһһŮִ֪ºδ</p>\r\n<p>2007128գ100Ԫңɶèо2006һ˫̥èΪɽ͡ˮӦöΪһΪҲŨŨʱζ</p>\r\n<p>֪IDGǡʱСĺ飬1997IDG͡ʱСʳʱ֮й湫˾IDGûʱýԴIDGĽܣʱС˹س漯µCosmopolitanEsquireİȨ</p>\r\n<p>ԡʱСȤǿ20068£IDG֡ʱСƳʱվYoka..comԵҹ˾Ķ³վϻ㼯ˡʱСڶ࿯ĵӰ棬ֻʱ΢ͺһЩ</p>\r\n<p>ͣйõķչͻڸ߶ʱƷ׷ǿҡYoka..comרעΪ߶Ʒơ߶Ⱥṩ˵ǰ׷ʱеƣӦ˹һƷƶй͸</p>\r\n<p>Ȥԭ򣬵ĳҲ˵Ƶ⣬йѸٵвӮйгĹؼʼڼ۸ڷı䡣ͬͲƷͬƷγɵƫܹʵֳڵۡ</p>\r\n<p><strong></strong></p>\r\n<p>ʱȻоı仯ʵǹѸ٣ҪŬܸķչڹȥ30ʱͨŬ','0');
INSERT INTO `qb_news_reply` VALUES ('535','','1240059129','556','33','1','0','Ľġ˳˹ͬĿ⣬ֻǷͶʣҪӦ</p>\r\n<p><table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"100%\"><tbody><tr><td style=\"color:#666;font-size:14px;\">Ҹע ѶԴ֮Ʒ֡ͼƬͼ δѶȨκý͸˲ȫ߲תءתأ 010-85650997 ϵɺתעԴӣΥ߱׷Ρ</td></tr></tbody></table>\r\n</p>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('536','','1240060838','557','34','1','1','<p>޸һԭPHP168Ŀ¼ΪdataĿ¼ɽ</p>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('537','','1240061182','558','34','1','1','<div>ں̨ݹؼͻʾʱ,ͼƬ.ͼƬʱ.ְйؼʱ.ᵼͼƬ޷ʾ.<br />\r\n<br />\r\n.޸ļ<br />\r\n/inc/article_function.php<br />\r\n<br />\r\nrequire_once(PHP168_PATH.\"php168/keyword.php\");<br />\r\nһ´<br />\r\n$content=preg_replace(\"/ alt=([^ ]+) /is\",\"\",$content);</div>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('538','','1240061760','559','34','1','1','<p><img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www_qibosoft_com/Tmp_updir/article/34/1_20090418210411_MAuzU.jpg\" width=\"500\" height=\"333\" border=\"0\" alt=\"1.jpg\" title=\"1.jpg\" /></p>\r\n<p>йƶG3ʼǱߺʽڱСйƶʽ롢ա廪ͬ17ҹPC̿չȺƳ29йƶG3ʼǱ˾ٿ˹ӪPC̴ģȺӣ־3GTD-SCDMAҵչȡشչû˵ѾʼֻչԤ滰ѻֻҲġ͡ʼǱ<br />\r\n<br />\r\n<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www_qibosoft_com/Tmp_updir/article/34/1_20090418210415_iM0Xb.jpg\" width=\"500\" height=\"333\" border=\"0\" alt=\"1.jpg\" title=\"1.jpg\" /><br />\r\n<br />\r\n<br />\r\nйƶܲ³򶫣У17Һٱ<br />\r\n<br />\r\n&nbsp; &nbsp; йƶΪηĶ17Һĸ߲쵼ϯֹPC̸߲Ƽĳ漴ӢضĳҲѵһл˹ܲ ܡйϢƷ(PSG)ܲüܾ ȫܲáлҵܾ ̨´ǡ3GĵһѾڹPCп˻<br />\r\n<br />\r\n</p>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('539','','1240062925','560','34','1','1','<p>װ׹--רҵIDCվCNIDCƳƷաܣû˽Ʒ̬Ϣ</p>\r\n<p><strong>йվվchinaz.com413Ϣ</strong>Ϊһֶҳʷݵı棬ǶԡҳաϤҳжʹһܡóʵĳ֡աܣǷԸȫ˽һƷĶ̬Ϣأڣ<a href=\"http://www.cnidc.com/\">www.cnidc.com</a>Ƴһܡ</p>\r\n<p>ƳһʷݵĹܽСƷաԭϺġҳաƣֻǰһ뵽Ʒ׵С</p>\r\n<p>һרҵIDCƽ̨֪վռ䣩ǵָϢ࣬һָĸı䣬ͻʹԼ۱ȴྶֽ֧ͥűĲͬASPASP.NETPHP ݿͣACCESSMSSQLMySQLIISơ·Ƿȣʱһָı仯ͻʹϵµʹûһֱľ档</p>\r\n<p align=\"center\"><img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www_qibosoft_com/Tmp_updir/article/34/1_20090418210456_2Vexh.gif\" width=\"448\" height=\"364\" border=\"0\" alt=\"1.gif\" title=\"1.gif\" /></p>\r\n<p align=\"center\">&nbsp;<strong>ͼϢб仯һƷ</strong></p>\r\n<p align=\"center\"><strong></strong><p align=\"center\"><strong><img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www_qibosoft_com/Tmp_updir/article/34/1_20090418210410_CH9Ep.gif\" width=\"417\" height=\"366\" border=\"0\" alt=\"9.gif\" title=\"9.gif\" /><p align=\"center\">&nbsp;ͼƷϢ</p>\r\n</strong></p>\r\n<p align=\"center\">&nbsp;ͼƷϢ</p>\r\n<p>&nbsp;</p>\r\n<p align=\"center\">&nbsp;ͼƷϢ</p>\r\n<p>&nbsp;</p>\r\n<p align=\"center\">&nbsp;ͼƷϢ</p>\r\n<p>&nbsp;</p>\r\n<p align=\"center\">&nbsp;ͼƷϢ</p>\r\n<p>ûͨѽܶûڲοϢܾ֮òŹʱ̣IDCͻĳƷָһı䶯ƳġƷաܣȫžһķûȫ˽Ʒʷݣװ׹</p>\r\n<p align=\"center\">&nbsp;</p>\r\n<p align=\"center\"><strong>&nbsp;ͼϢ仯һƷ</strong></p>\r\n<p>˽⣬ƷաڹϽҵڶܣƷָϸӸӣ֮ȫ˽ܾһļѶȣûݵ˽һƷϢȡϾһƣҳաɴ󻺽һìܡ</p>\r\n<p>ΪһרҵIDCƽ̨һֱάûȨϾ󾫣߱ϼƻCNIDC֤̼ңԼ7˿ȴʩ˷ƳƷաܣȫλάȨһϤľٴ롣</p>\r\n<p><strong></strong>CNIDC.comһIDCƽ̨Ҳй½׼רҵƽ̨2009323ߡ</p>\r\n<p>IDCҵB2CףBIDC̣Cվҵȿͻйվվchinaz.com7վҵƣIDC̼ҡվҵûIDCնȺ壬޷϶Խӣ֤˫ȫףڴйרҵƽ̨</p>\r\n<p>ΪһIDCҵB2Cƽ̨йܡá⡢VPSϸվռʹõĲͬҪͬʱṩIDCҵѶԼIDCصļ̵̳ȡվַ<a href=\"http://www.cnidc.com/\">www.cnidc.com</a>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n</p>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('548','','1240126775','567','39','1','1','<p>繺ﻷս죬ԽԽ߿ʼϹҵ׻ͻ̼ҴͳӪģʽʱĽµӪģʽ</p>\r\n<p>úã̼/ҵƷ۵ƽ̨Ϊ̼/ۺĹͨƽ̨ʱгߺϢĹƽ̨γҵһ廯ҵֵƽ̨˾ܳûͿɴ󽵵ҵгɱЧʣͬʱҲܴƽƽ̨ϵõݸЧķӦڶ೧/˾Ӫչһʱ仯жҪ򣬾Ҫʱ̭Ƕն˲Ʒ/ҵ/˾Ҫ</p>\r\n<p>һ˾ҪѵɹĴҪظ㹻ӣֹӪ˲򣬲äĿͶǷ˼·ʹ󣬲Ҫ죬󲻵òʧܸա</p>\r\n<p>ҪһԽƽ̨Ҫ</p>\r\n<p>ܶ๫˾ʵڻڵתƣΪͰ͡۴ҵƽ̨ϷҵϢչǿչ˵ʵΪȱ£ĵԶקڱ˵ЩϢҵƽֻ̨Ϊƹ绷ѡ</p>\r\n<p>ҪԼĵԼ˾ҪԼգ뽨Լĵƽ̨ƽ̨Խ罨ԽãΪƽ̨ҲҪʱ۵ģ罨棬漤Խ࣬㹫˾ķչԽ</p>\r\n<p>Ҫضƽ̨Ӧѭѭɳչƽ</p>\r\n<p>1ⱻۿ̸</p>\r\n<p>ͨԶҿչĹ˾й۲췢֣ܶһʼߵ룬ͶʵĹ˾û?ڲһʼû侲äĿͶɣһʼ̬⣬ ƭϰ壬ƭͶߣɱ深ټ󣬽УȦǮһк³ĭˣԼһ֮ʵЩǲȱ飬ûʵʵҵ̬װƻ</p>\r\n<p>2</p>\r\n<p>Ҫѵɹץס˾ģ Ʒ + ƽ̨ + г չһƷƣгĹ˾˵˵ЩһʼûƷƣûгͻʲôհ׵Ĺ˾˵Ҫʱ֤ϾҲһͳɱ𲽵ĲκҪӻģһڶͣ档</p>\r\n<p>3ƽ̨ѭʽɳչ</p>\r\n<p>Խƽ̨ʱһһͶ뼸Ǳġ߸ݶľ飬ֽһĵƽ̨Щ̨Ժϡ𲽿죬Լʱ;ֿɱ˷ѲҪĳɱͶ롣ץۡƹ㣬ںܶȱʵʲһʼǿ̨ҪδǿʵһʼòϣԶҲòϣʵʡѭʽɳչϲߣƽ߶ܽܣɹĸʺܸߡ</p>\r\n<p>Ҫ˾ŶӶԵĸ߶ͬ</p>\r\n<p>Ͼǽ귢չܶ๫˾ϰ塢оȨĸ߲ⷽʵûʲôʶеĿ˵ⷽ湫˾Ŷûи߶ȵͬӣڹ˾ڲáչ棬ͿܴһԽĺ蹵ǿŶӣһˡ</p>\r\n<p>һ˵߶ӵĹ˾ӴͶ룬ȫ֧֣Ĺ˾չͿ죬ЧҲ;֮ͻԭ̤СнƿǿӾҲҪȵͬ;ߴ̼һ£Żһѣжжһ֪Թ˾ŶӶԵĸ߶ӣҲǵɹĹؼҪء</p>\r\n<p>ҪģҪпɿĵͷ</p>\r\n<p>˾ҪҵһʵսĴͷˣۿ̸ңṩԹ˾Ը˶Ŀռ䷢չƽ̨ʽչ˾ĵſɳչȥһһ˼·˾˳չɲҪʱ䡢˷ѡȻѡһʵҲȷʵףοһרҲࡣ</p>\r\n<p>õչ͡Ӫ͡͹˾/ҵֻҪĵҪõͿ޶ȵرڵǰΣ£Եͳɱĵģʽʵذѹ˾չٷչĻʱһҵǰ;Ⱦ֣̻;߳</p>\r\n<p><br />\r\n: վ(<a href=\"http://www.admin5.com/\">www.admin5.com</a>) Ĳο<a href=\"http://www.admin5.com/article/20090408/141109.shtml\">http://www.admin5.com/article/20090408/141109.shtml</a></p>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('549','','1240126816','568','39','1','1','<p>Ը⽫ԼĹʡ֮ڡ?Ҫ֪ѾԽԽġ̨϶ԼĹʡɹɹ롰һɹɹʰɡнṩɹʵרվְܿͬҵͬȺɹĹʵ</p>\r\n<p>ԹݵYAMO5ĸ߼ʦڡһɹϸԼн(˰ǰ)8Ԫʣ1406Ԫ;λ2858Ԫ</p>\r\n<p>YAMOһɹʣǻԡɹĹۣҷԼĹοĵáڡнϣbkhɹʣ롢ƱȸԼ΢Ĺʵó21ĴһЩɹʡվϣ˽⵽ҵĹаͨվṩԼְλȣһݡнʱȽϱ桱</p>\r\n<p>ܽ ɹʡĴֱǡ主йʱȡ֡ɹվǶʾᳫѡС˵Ҷɹһɹʣοһ£ܹΪԼĲο ν</p>\r\n<p><br />\r\n</p>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('550','','1240126852','569','39','1','1','<p>λɴ</p>\r\n<p>ĻɴҪѧҦҶѡҪɽˮʮеһ仰һֽκͻɴӰһηʽʼȫһʱѡһ߳УһɴգԸԻķʽ¼Ҫʱ̡</p>\r\n<p>羰˲</p>\r\n<p>ͳĻɴӰӰ¥ӰǾͽĹ԰·ĳƬˮҵ˵Ŀζ</p>\r\n<p>ֽκͻɴӰһ·ϵȻ羰ΪӰƷһ޶˻ɴ㷽ʽԽԽʱеˡ</p>\r\n<p>ҦЧӦλɴӰ硢Ӱ¥ȻŹ̻ݽܣҦҶĻɴ̫ԴĴĹɽկĺǵȷ羰صʤأ˺ܶĻɴѡĵط</p>\r\n<p>רҵʿλɴӰͻεһԪءӰĴ£Ŀǰҵ߶ˡϸַչλɴӰΪһҪβƷ</p>\r\n<p>λɴĸļӴ󣬿ʡȵ𲽷Ŵôβ˽⵽ػɴӰ¥ӰҵϸŻϢ?ܼ򵥡硱ڽϳ˴ȫԡԻɴӰվżġʤ̭ĿǰѾ˻ɴӰŻϷµľҲΪȫѡӰ¥ӰҵȨƽ̨ŻþýйɴӰҸɫΪṩȫķƽ̨</p>\r\n<p>ɴӰһŻ йɴӰ <a href=\"http://www.wed114.cn\">http://www.wed114.cn</a></p>\r\n<p>йɴӰרעڻɴӰҵй󲿷ֳеӰ¥ӰңĿǰѾͨдﵽ14015000Ӱ¥Ӱʽפ̣ͨйĻɴӰվߵϸ̼Ϣ̼һϢѡƷչʾŻȯֵעṩ̼ҵԷŻݻŹϢȡ</p>\r\n<p>ͨǶ100̼ҵĲãձΪйɴӰڹ״ˡɴӰšƣˡҵˡԱöȣͨ͹۵ķʽΪṩȨĽָ꣬ͨûֻƣ׼ǿ˽Ѷ̼ҵĿ͹ۣҲи̼ҷӦЩƺǾֶۣϣйɴӰԵļȼӴſγɸ͹۵ûơ</p>\r\n<p>ĿǰйɴӰƵȫӰ¥Ϣ⣬зǳḻںйɴдͼ(йɴдͼ)йӰȦ(˵Ѿн3ӰʦפУ˽ӦSNSƽ̨)й(רҵĽģϢܿ)йɴӰ̳(Ҫ漰ɴӰ)йӰ¥˲(ͨ˽⣬ո߲ãѾк̼ܶ淢ƸϢҲкܶӰʦױʦȽ룬γרҵӰ¥Ƹְ)</p>\r\n<p>༭С᣺༭ͨ෽˽⣬ΪйɴӰӪȷΪȫ׼ṩѡӰ¥ӰȨķƽ̨̼ͨй߷Եһʱ˽̼á»ŹϢϢߺ̼ҵõʵݡ˼⣺ȻȫݷḻϢЧʺܸߣȫվᴩԻߣر̳֯滹´󹦷</p>\r\n<p>޵һŻ þý <a href=\"http://www.99wed.com\">http://www.99wed.com</a></p>\r\n<p>þýĿǰȫ¸Ļ񼰻Ʒȫչʾƽ̨þû㼯˱Ϻڶ̼ҵѶϢ̼ϵȫλƽ׼ѵϣͨõļʱ̼Ҿʷ׳ʵŻݻϣʵѯǢ̸ףΪ׼˺̼ṩһЧݵһվʽƽ̨</p>\r\n<p>þýҪΪͨйĻͨȫ˽ԳP150򣬶IP5վ̼һԱפ500ҡͨþý90%ϵķԴ˾þýĽΪйһþýҪƵѶ֪ļ̼(ɴӰ졢ǵȵ)</p>\r\n<p>ͨ˽⣬þý2009꣬չģʽ͸й70%ϵгͬʱҲӴ»չģҵ־̽ӰĿܹҵý壬γйҵýƸߵ㡣</p>\r\n<p>༭С᣺þýй漰ҵվ֮һͨƵѸٷչ񣬾þý˻ҵȫ֪ƷƣΪ̼ܣþýͨרע¡顢롱صӪģʽ˴̼ҼʵͻȺ༭ͨ˽ͷ־þýĿǰȻû߳͵ģʽҪȻۼ׼ռǺܸߣȻþýкܸߵ֪ȣ̼ʵд˼</p>\r\n<p>һŻ Ҹ <a href=\"http://www.xfwed.com\">http://www.xfwed.com</a></p>\r\n<p>ҸרעڱҵڱܱҸ൱֪ȣԴһֱΪѺͱ޷ҵṩ񣬶ԱҵԴݺѯлϣѼʱϢڻҵڽϢƣĿǰҸѳΪڻȵҵŻվѸ١ʱṩػ޷չ򣬻³г̬ȫҵϢΪṩרҵĻָҵƼ»ƷȷȫµĻ</p>\r\n<p>ͬڱ߳ƵĻվ˭뵽޷ıжٵᣬҸʼСĻ˵ΪҵеҵṩһչʾƷƹ̨;Ϊ̤ϻõ׼ṩһ齻ɹƽ̨Ϊʵ룬Ҹ˺ܶ࣬еѶܼ֤ġҸ¶̬ŹΪΪ̳Щۼֻͨϸ</p>\r\n<p>༭С᣺Ҹй漰ҵվ֮һͨŹۼͨԱػгȫλھҸȻΪƽ̨׶ĻģҸרעڱڽҸԷչĸá˼⣺ڱҪǱг̼ޣ׼ޣҸչƿͻƿԱгھ͸µҵչҸӦÿǵ⡣ȹ̳ıҲǺϾ⡣</p>\r\n<p>վҵϡƶãǶڱվ˵гж?</p>\r\n<p>˵⡣ݡйҵչ鱨桷ʾҹ5ƽǼǽΪ811ԣгռ41%»ѷ棬 88.40%Ҫɴ;49.14%˼ƻ칫˾Ϊǳ;78.74%׼¥ٰ;36.83%ҪΪﹺɴ;67.66%˽Ρÿ˵ļȨƽѽﵽ12.58Ԫ˼㣬йȺһܶΪ4183Ԫ(811Ԫ41%12.58Ԫ)</p>\r\n<p>༭ĻоվʾվѾ¢ȫгֻΪǸɫչáȫطдСͬĻվҲ֮纼ݡ人ɶȵضвĵطҲƫȫ</p>\r\n<p><a href=\"http://www.admin5.com/article/20090417/143375.shtml\"></a></p>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('551','','1240126932','570','38','1','1',',ʱڽվ,뽨վĻ,ȴ25շRC.RCɽվʹ,ʽĻ,Ҫں,ſɷ.<br />\r\nĿǰƵĹܴ:<br />\r\n<br />\r\n<br />\r\nѼ¼<br />\r\n<br />\r\nԱ<br />\r\n<br />\r\nϵͳģɰװ,ɾ޺<br />\r\n<br />\r\nǩŻ<br />\r\n<br />\r\n֤ǿ<br />\r\n<br />\r\nԱӿѡ<br />\r\n<br />\r\n,бҳ,,,ȡJSʾ<br />\r\n<br />\r\n<br />\r\n̨п,շ,Ƿȫ,ֻ<br />\r\n<br />\r\nԹȥаȫ.<br />\r\n<br />\r\n,һŻ.Ըǿ<br />\r\n<br />\r\nͶƱĽһǿ<br />\r\nؼֹ <br />\r\nһվ̨ͼ<br />\r\n<br />\r\nŻһͼƬˮӡ<br />\r\n<br />\r\nCK༭<br />\r\n<br />\r\nӶʱ<br />\r\n<br />\r\nʱݿ<br />\r\nʱ<br />\r\n<br />\r\nбҳñǩӦĿFIDĿݡ<br />\r\n<br />\r\n<br />\r\n¾̬,ȡ÷Ծͻ,ʱȫվ̬+˼ؾ̬<br />\r\n<br />\r\nŻɻơбݹ࣬תȴʱдŻ<br />\r\n<br />\r\n˫ҳɽбǩ޸<br />\r\n<br />\r\nȵ<br />\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('552','','1240127012','571','38','1','1','<p>-----20041011գݼݼϵͳ1.0淢 </p>\r\n<p>-----20041123գݼݼվ1.5淢 </p>\r\n<p>-----2005127գݼݼվ1.6淢 </p>\r\n<p>-----200534գݼݼվ1.61淢 </p>\r\n<p>-----2005211գݼݼվ1.8淢 </p>\r\n<p>-----2005328գݼݼվ2.0淢 </p>\r\n<p>-----2005420գ168վϵͳ3.0淢(ͬʱݼݼվΪ168վϵͳ) </p>\r\n<p>-----2005514գ168վϵͳ3.1淢 </p>\r\n<p>-----2005106գ168վϵͳ3.5淢 </p>\r\n<p>-----200711գPHP168վϵͳ4.0BETA淢(ͬʱ168վϵͳΪPHP168վϵͳ) </p>\r\n<p>-----2007320գPHP168վϵͳ4.0ʽ淢 </p>\r\n<p>-----200746-26,26չ(ӶԻƴ·140žC31008) </p>\r\n<p>-----2007426-610ƳVIPԱ </p>\r\n<p>-----200768գPHP168վϵͳ4.0SP淢 </p>\r\n<p>-----2007627գƳȨʽ </p>\r\n<p>-----2007726,Ѹ˽ɺϵ </p>\r\n<p>-----200784գPHP168վV4.0SP2ȫܰ淢 </p>\r\n<p>-----2007815,PHPWINDɺϵ </p>\r\n<p>-----2007818,Ȧϵͳ </p>\r\n<p>-----20070922, PHP168վV4.0SP3 ȫܰ淢 </p>\r\n<p>-----20071023,쳵˽ɺϵ </p>\r\n<p>-----20071025,붯PHPɺϵ </p>\r\n<p>-----20071102,עԾƼ޹˾(ӶԻƴ·140žC31008) </p>\r\n<p>-----200811,Ϣϵͳ롶ϵͳ </p>\r\n<p>-----2008110,벥CCɺϵ </p>\r\n<p>-----2008118,CNZZйվ˽ɺϵ </p>\r\n<p>-----2008409,PHP168վ2008վȨʽƳ </p>\r\n<p>-----2008601,PHP168վ2008ѰʽƳ </p>\r\n<p>-----2008814,2008ȫܰվϵͳʽƳ </p>\r\n<p>-----2008902,php168֪ϵͳѰʽƳ </p>\r\n<p>-----20081015,php168phpwindִϰϵͳ </p>\r\n<p>-----20081027,2008Ϣϵͳ </p>\r\n<p>-----2008121,˾ΪЭƼ޹˾Իƴ2ſҵҵ701 </p>\r\n<p>-----2009415,PHP168վV6֮BETA2ڲ԰ʽ </p>\r\n<p>-----2009420,PHP168վV6԰ʽ </p>\r\n<p>-----2009420,PHP168վV6.0վϵͳʽ </p>\r\n<p>-----2009523,PHP168ϢϵͳV6(ϰ) </p>\r\n<p>-----2009523,PHP168ϢϵͳV6() </p>\r\n<p>-----2009531,PHP168V6վϵͳUTF8淢 </p>\r\n<p>-----200971,PHP168վV6.02վϵͳʽ </p>\r\n<p>-----20091022,PHP168վV6Ϣǿ </p>\r\n<p>-----20091127,PHP168վV6ǿ淢 </p>\r\n<p>-----2010121,PHP168ʽ¹̳PHP168Ϊ벩Ϊ<a href=\"http://www.qibosoft.com\">http://www.qibosoft.com</a> <br />\r\n&nbsp;&nbsp;&nbsp;&nbsp; 벩Ϊ<a href=\"http://bbs.qibosoft.com\">http://bbs.qibosoft.com</a>,ͬʱԭֹͣʹ</p>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('553','','1240127172','572','38','1','1','û¹ <br />\r\n<br />\r\nԭPHP168ƷеVϵSϵУȫֿͬĹ˾Ӫҹ˾ûκϵ <br />\r\n<br />\r\n֮ǰPHP168ƷVϵеĲƷ6.02վ汾B2BϵͳϵͳطŻϵͳȵȣVϵкĿģVϵжƿĲƷۺ˾ <br />\r\n<br />\r\n֮ǰPHP168ƷSϵеĲƷԼSϵжƿĲƷۺȵȣϵSϵйٷ <br />\r\n<br />\r\n˾ԭPHP168ƷеSϵУۣҲҲṩۺ֧֡','0');
INSERT INTO `qb_news_reply` VALUES ('554','','1240127229','573','38','1','1','<p>ݴѷVϵSϵйһ̳ڻҡٷؿǣ12·̳ <br />\r\n<a href=\"http://bbs.qibosoft.com\">http://bbs.qibosoft.com</a> <br />\r\nΪVϵеĹٷ̳ </p>\r\n<p>⣬ôȻһΪҪӹ죬ʹʱеӢPHP168CMS&nbsp; VϵһֱûΪģʹԣôܺأԼĸأˣٷݶΪVϵȡΪ벩CMS벩طϵͳ벩B2BҵŻϵͳ벩ϵͳ </p>\r\n<p>벩Ϊٷͷɰٴڳͬչ <br />\r\nVϵн <br />\r\n<a href=\"http://www.qibosoft.com\">http://www.qibosoft.com</a> </p>\r\n<p>&nbsp;</p>\r\n<p><br />\r\nעΪʲôȡsoftβȡCMSβأΪSOFT,Ҫǲ<a href=\"http://www.microsoft.com\">www.microsoft.com</a></p>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('555','','1240127281','574','4','1','1','<span style=\"font-size: 14px\">˿ƼѶ ʱ418Ϣݹý屨Ͷʵл˹̹й˾(Bernstein Research)ʦܸ&middot;ֵ(Jeffrey Lindsay)</span><span style=\"font-size: 14px\"><span>ʾ</span></span>eBayչGmarketּطйձг\r\n<p>\r\n	ܣeBayƵֲSkypeȻÿ24Ԫļ۸չGmarketͨɺADSչ۸ԼΪ12ԪԴˣֵΪeBayһشսԵ»عĵĵҵ</p>\r\n<p>\r\n	ֵƣeBayGmarketƽ̨طйձгǰCEO÷&middot;(Meg Whitman)ʱeBayгıֲ⣬CEOԼ&middot;ɻ(John Donahoe)쵼£eBayϣطг</p>\r\n<p>\r\n	2007꣬eBayĻһֱǺȵĵӦ̡GmarketռeBayķͷֵƣչGmarket֮eBayΧGmarketƶޣйгҵսԡ</p>\r\n<p>\r\n	GmarketֵΪeBayһչ˾MercadoLibreŷ޵˾TradusƱ˾StubHubͷ湫˾Craig&#39;s Listȡ()</p>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('556','','1240127308','575','4','1','1','רҵٶȳ죬һӸ㶨һЩ̳͵վϣ˰˿վӡЩ߾ƣڡϢҵߵһվͨԼȴ԰վɹ༸Ӿܸ㶨ԴˣϺͨŹʿʾվȻͨѸվǧͼʡ¶Լº󻼡<p><strong>վҲһ</strong></p>\r\n<p>ϣ߿һΪܶƹҡңѡվ/ٱ/һӱһƷϸ˵˽׵վûбվӸ㶨20Ԫһվ;ûѾύûбɹվΪվҪʮӣ۸Ҳ50ԪվȽϷҪ10ʱͨ50ԪһվֻҪṩվơվʡơɡ</p>\r\n<p>2005Ų(ΪŲ)ġϢ취(¼ơ취)涨ڹڷϷõվ뱸ҰʱڶʮڡôЩṩһӿٱôٳɵ?</p>\r\n<p>ϺͨŹʿܣȥ꿪ʼֺܾͨ͹Ų㷢˴⣬ԭǵʱϵͳվһ©ͬһͬһſͬʱӦڲͬվνһӱɹʵϱһ©֮󣬹Ųܿ콫޸ֻҪ޸ʾδˡ״̬˵Ҳõһλṩٱ񡱿ͷĳϣ߼ߣѾ1ӱɹˣҲҪһ죬ںšһӱʵֻǸͷѡ</p>\r\n<p><strong>ʹôܻᱻ</strong></p>\r\n<p>ܾͨʿѼߣĿǰЩν챸ķʵΥݡ취ʱύ쵥λơʡЧ֤롢ܵĵλվ˻ϢõصȶϢ챸ߡ뷽ҪôϢһʹ뷽ڿʼɹһַܾͨϢ䱸Žϱע֪ͨISP뷽ʱǡˮһա</p>\r\n<p>ڡվ롱˵Ϊҥԡ3·ݣϺֱܾͨͨ1.5վһСʱһҲ˳ɹˣֻҪϢʵûһҲͨġ</p>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('557','','1240127373','576','4','1','1','1000ԪһվվϷٵͶϢԸ߻رŵ˿͡һй˿ţȰͶʣһġӯΪرյʽ󣬾;Ǯߡӽ2½ֹʱ()ʯ()ʽΡܺУһԳɶ򸾱ƭ߽64ԪգɶԺթƭｫ桢ʯͬȻӡ<p><strong>վͶʱƭ60</strong></p>\r\n<p>211գɶ()ͨҵһΪĳ֤ȯͶ޹˾վҳϽܣڸù˾Ͷʻرܸߡµù˾ǽˡ߻رͶʡںɷ򶭻()µù˾ѯ˾ǮͶʡ</p>\r\n<p>212գ˾ָ˻ϻ38000Ԫڶ죬˾ͷ1900Ԫġӯ˵˾̲Ͷʵʱ죬ִ21Ԫ˺Ҳٴյˡ½40ԪͶʹ˾˻</p>\r\n<p>220գ˾绰Ҫ׷Ͷʣʱûʽ׼˳Ҫ˾ӯһ𻹣ԷظҪһڵʱ䡣</p>\r\n<p>ϣϲҸù˾ȴҳѾʧ绰Ҳû˽ӡʱù˾71Ԫڼ䷵7Ԫġӯн64Ԫ֪ȥ221ϣ˷ɻǰָù˾Ͳڣæ</p>\r\n<p><strong>վ</strong></p>\r\n<p>ӱ󣬾չ顣311գͳʯ뷨</p>\r\n<p>潻Ǹˣ25գͳʯ˴Ӹǰڣ1000ԪһվϷ˸߻رͶϢϵʽ˵򸾵60ԪƭֺǾ͹صվǮߡӻ־ݳʯ֮ǰҲ編ƣ45ΡͶʡƭõĽ5¡</p>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('558','','1240127449','577','4','1','1','˿ƼѶ 417Ϣ֪ʿ416͸¶йƶOPhoneֻɻзСΧԣЧá<p>Ϥ5³EDGE汾OPhoneֻУTD-SCDMA׼ֻҲڵļС</p>\r\n<p>OPhoneֻйƶOMSֻϵͳƽ̨ΪзһֻֻOMSйƶԹȸAndroidΪ</p>\r\n<p>봫ͳֻȣoPhoneֻڻֻɱ⣬oPhone֧ƶͨoPhoneҲԺʵ HttpݣˣoPhoneֻiPhoneֻ࿹⡣() <br />\r\n</p>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('559','','1240127959','578','39','1','1','<p>&nbsp;</p>\r\n<p><strong>˿Ƽ<a href=\"http://tech.sina.com.cn/talk/silverage/index.html\" target=\"_blank\">ʱϵз̸</a>һ</strong>ʱ˿ƼƵƳһǿĿȱдۡ顢ͼ̸ȶʽչһٳɳĴҵ͸߿Ƽҵķ档ڣ˿ƼҲ½ܹעĴҵҵʼˣѽн</p>\r\n<p><strong>Ϊ־ʵ¼</strong> </p>\r\n<p><strong>ʹ۵㣺</strong></p>\r\n<p><font face=\"_GB2312\">- ֮ǰӯѹ⣬ÿС˾⣬ǲȡһѡһշѵĲ</font></p>\r\n<p><font face=\"_GB2312\">- ϣ㲻ֻҪûʹþļֵԼĺľ</font></p>\r\n<p><font face=\"_GB2312\">- ʼΪҹкܶãԺҾͳԺҿһݺõĹҲоѧһĳ</font></p>\r\n<p><font face=\"_GB2312\">- ҼһŵڣһֱϣܹоʿѧҳԹʺôҲôִһ˵ԼҵԼ</font></p>\r\n<p><font face=\"_GB2312\">- ǶԷͶԼ⣬ǲǿĹ˾ڶԼҲҪͶ˸</font></p>\r\n<p><font face=\"_GB2312\">- Ҫ꣬㲻ҪҪȥڶʣ׬ٴǮȵȡҪм򵥡ӵ룬Ϊһ׵ҵһʼʲôûУûмҲûܴ飬ɹĸʻܵͣȻҪ׬Ǯӯʣ㲻ϵʧҵĻ<p align=\"center\">&nbsp;</p>\r\n<p align=\"center\">ͼΪDiscuzCEO־</p>\r\n</font></p>\r\n<p align=\"center\">&nbsp;</p>\r\n<p align=\"center\">ͼΪDiscuzCEO־</p>\r\n<p>&nbsp;</p>\r\n<p align=\"center\">&nbsp;</p>\r\n<p align=\"center\">ͼΪDiscuzCEO־</p>\r\n<p><strong>ˣ </strong>λãӭһڵ˿Ƽʱϵз̸<strong>ǽˣһƾձǿ</strong>뵽ļαDiscuzCEO־Ǵϴѧ30򵽱˾ġ򵥽һԼ</p>\r\n<p><strong>־</strong> λѴҺãܸлҽһЩҵɳľ;Щ;δغܳȷһĿռ䣬Դ˵ǶԼ˵һǳõĻᡣ</p>\r\n<p><strong>ˣ </strong>һѵ⡣</p>\r\n<p><strong>ѣ</strong>24꣬ǲѧУŴҵô̳</p>\r\n<p><strong>־</strong> ҿ϶ѧУ봴ҵ飬˴ѧôѧԤڵĲһҺһЩԼ飬ѧ̵ĶҵȤƫڴѧһ꣬Ϳʼ顣̳֮Ǻܼ򵥣һкܶѽкܶûûӵʹͨܶþһ顣</p>\r\n<p><strong>ˣ </strong>˵ڴѧʱ׬˺ܶǮȻ󵽱Discuz˾</p>\r\n<p><strong>־</strong> ʱܼ򵥣һֱáȻʱҵǰӯռ䣬һҪԵԼĸԼ֮ǰ뷨ҾôҵͿ˾ʽϵ⣬һ˳µġ</p>\r\n<p><strong>ˣ </strong>Ĺ˾0405귢չǳõ£DiscuzȫѣǻʲôĿǣ</p>\r\n<p><strong>־</strong> ĳúܹܶӰܶ໥ûʹϰߣ֮ǰӯѹ⣬ÿС˾⣬ǲȡһֵѡһշѵĲԣշѵżԽԽߣǺܶǮܶ඼Ǹ˵վҸ˵վǻһʱǿ϶Ѹʹãͻǵ롣</p>\r\n<p><strong>ˣ </strong>ںܶѶDiscuzǺʲôģʲôص㣿</p>\r\n<p><strong>־</strong> DiscuzBBS˵̳ճBBSвͬʽÿһвͬʽBBSʽDiscuzСվվͨʹɵعԼϵͳǱڰȫϡŻܵƷ涼ûΪ</p>\r\n<p>Ŀʼʱ䲻Ǻܳ34ʱ䣬ȡһΪԼһĳɼ</p>\r\n<p><strong>ˣ </strong>Ǵʲôʱʼ뵽ѵģ</p>\r\n<p><strong>־</strong> 053·ݡ</p>\r\n<p><strong>ˣ </strong>053·ݵ׵12µף֮һܳḶ́</p>\r\n<p><strong>־</strong> ̾ǲϵ˼붷ϵ˼ʲôʱʲôʱʺ</p>\r\n<p><strong>ˣ </strong>0512·ݾʺϣ</p>\r\n<p><strong>־</strong> ԣҪģһ˾Ҫ棬ҪάֽķչԵʱã֮ǰΪ̳۶05׶γɳıȽѸ֮ͣͻȻ͸оƺ̫ҪѹҪô鷢չ׳</p>\r\n<p>ԣ0512һȽϺõʱҪԭﵽҪ</p>\r\n<p align=\"center\">&nbsp;</p>\r\n<p align=\"center\">ͼΪDiscuzCEO־</p>\r\n<p><strong>ˣ </strong>ǹģռ̳70%ңҲ֪Ժûµӯģʽ</p>\r\n<p><strong>־</strong> ӯģʽ˾ûΪģҪ˾صĶʵԼֵĹ˾Ҿûϣ㲻ֻҪûʹþļֵһûʹ벻ԼĺľҾֻҪʹþͻļֵ</p>\r\n<p><strong>ˣ </strong>ӯģʽûȶԺȥǵ⣿</p>\r\n<p><strong>־</strong> Ӧ˵</p>\r\n<p><strong>ˣ </strong>ԺԴûˣôȥ</p>\r\n<p><strong>־</strong> ûУ֮ǰҵļ֧֡صķṩȶľԴЩǻù֧ǵ</p>\r\n<p><strong>ˣ </strong>ǹ˾жˣ</p>\r\n<p><strong>־</strong> 1617ˡ</p>\r\n<p><strong>ˣ </strong>гıǲһģ</p>\r\n<p><strong>־</strong> ֻǷǼԱҪôǼֵ֧ȵȡ</p>\r\n<p><strong>ˣ </strong>ǹ˾λǼ͵ģǷ͵ģ</p>\r\n<p><strong>־</strong> ԼǸ㼼ģұȽϳеǼ͹˾</p>\r\n<p><strong>ˣ </strong≯һ¹ڹ˾⡣ƽڹ˾ԱĽӦûôϵ</p>\r\n<p><strong>־</strong> 䲻⣬Ҷͬ־ͬ롣ڿʼƸʱ˿ÿɲڿʼƸʱѹǱȽϵһֱѰйͬ롢ͬ־뵽TeamУǲṩߵнͼ߾ĸṩһ룬ͬ룬벢Ŭʵִҹͬļֵ</p>\r\n<p>Ȼкܶͬµ䶼Ҵ󣬵ȻйͬԣΪĿΪֵ߳ģһʼҴ졢ɵģͬУҲǱ̬ұŴһȵȣȻ⣬ͬʵĿ꣬Թⲻ</p>\r\n<p><strong>ˣ </strong>Ĺ˾ԺԭҪĹڵĹת</p>\r\n<p><strong>־</strong> ڼĹļˣҪӣԭĴ룬ӸˣһǽѧѵÿܶµĳԱָͽ⣬ж˾ķչ򡢺ȵȷҲв뵽</p>\r\n<p><strong>ˣ </strong>Ҳ֪ϲʲôԱеϲԱģ</p>\r\n<p><strong>־</strong> Ҿ˺֮ĸоҪʵҶЩһһʵĸоºܳʱ䲻йͬĸȤĻ⣬۾ͻðͬĹ⵫Ƹʱ˲ࡣһԼļˣ룬鲻ͶʱļȾŬģ˲</p>\r\n<p>ΪСļҵ˾Ϊ׬ǮΪһݰȵĹ˲ʺŶӡ</p>\r\n<p><strong>ѣ</strong≯̸ҵʼ뷨ʲô</p>\r\n<p><strong>־</strong> һֱܼ򵥣ʼΪҹкܶãԺҾͳԺҿһݺõĹҲоѧһĳԡһĲƷ顢һļʵĶãͻкõĹᡣ</p>\r\n<p>ǰ֮ǰһѪжϵúܲģöԲǰΪʱ䡢͸顣ԼԺ󣬷ҵƷСŶӣϵ׳ܷһθлʹаá</p>\r\n<p>ĿǰҵСŶӱȽ϶࣬ʵҾǵĴҵĿĺܵܵһһʼΪҹ֮ΪһʹкθУٽΪʵԼļֵʵֲƷļֵʵŶӵļֵĿܶ</p>\r\n<p><strong>ˣ </strong>04ҵһѧתΪ˾ĹߵĹУԼѧʲô</p>\r\n<p><strong>־</strong> ѧ̫ණЩ㲻ȥʵ޷ᵽġѧõô˽Ρ˽Ḷ́Ҫġ</p>\r\n<p><strong>ˣ </strong>ڴҵĹоһЩѯһЩ⣬㲻Ķ</p>\r\n<p><strong>־</strong> ѯʵķʽ٣Ǿύ죬˵Ҳ߲֪Ķһϸһ¡ITȽϺãһѡΧһⷽ顣</p>\r\n<p>&nbsp;</p>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('560','','1240128462','579','4','1','1','TechWeb417Ϣݹý屨ӱѩ(Activision-Blizzard) ħ硷йӪ̾ųǣħ硷ӪȨ׹˾ΪꡣΪ˾Ҫǻڲԭ&nbsp;&nbsp;&nbsp;<br />\r\n<br />\r\nѩֺ;ųĺͬ6·ݵڣѩ֤ʵ֮ǰĴţͬųԼħ硷ľӪȨųǾ֮֡Աѩֶԣײİ֮ǰǾ͡ħIIIǼIIսйµĺͬ2010졣<br />\r\n<br />\r\nһٴؽش˾ųǣھųǻáħ硷Ȩһ꣬һųǷıʾħڲӣ2·ݡħ硷ͬʱʷ߼¼<br />\r\n&nbsp;<br />\r\nWedbush MorganʦMichael PachterΪѩֹ˾֮ѡȡųҪǻڲԭں;ųǺڼ䣬ݹƱѩֹ˾Ի22%Ȩʹ÷ѣҲÿܻ50005500Ԫ롣ʦԤͬ׺ѩֹ˾ٿԻ55%ȨɷѣĻɴ1.4ԪһȽϣͿԿͬ׺ҪͬųǺÿ׬9000Ԫ<br />\r\n<br />\r\nͬʱӱѩ˾ıʾԤƸù˾һ볬ԤڣΪʹٻӢۡԼħ硷ǿ8.6ԪľĿʵ֡<br />\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('561','','1240128514','580','4','1','1','»()418յ (߶Ӻݡܻ) ҵϢɹ18˵2009һй1620ˣﵽ3.16ˡ<p>ɹڴ˼еĲ̳2009ʾġ</p>\r\n<p>ɹ˵ڹʽΣʵ徭ôش£չͷȻƸԣģռ90%ϡIPv4ַԴѸ٣2008ﵽ1.8ڸﵽ1600йվﵽ287.8</p>\r\n<p>ɹʾڻҵϷռҪλݹƣ2008йгģԼΪ3Ԫͬ41.7%гģԼΪ120Ԫͬ55.8%;Ϸгģ190Ԫ200Ԫͬ50%ҡ</p>\r\n<p>⣬ɹܣ20093£й绰ûﵽ10.06ڻƶ绰ûﵽ6.7ڻڵ绰ûеıشﵽ66.1%</p>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('562','','1240128552','581','4','1','1','ѺITϢʱ417Ϣݹý屨ձ뵼ҵ֥˾͸¶ϸ(ֹ331)ȫ꾻3500Ԫ(Լ35Ԫ)Ǹù˾ʷľͬʱ֥ʾǰձԱ3900ͬԱ<p>Ϥĩ֥˾Ѿõ4500ʱԱ⣬ù˾ѾӳٻȡͶ¹ļƻ</p>\r\n<p>ǰ֥ƿ2800Ԫʵʳ֡ù˾ԭ򲿷ֹһ850Ԫĵ˰ƻ</p>\r\n<p>1£֥ƻּһڽԼ̶֧3000ԪзʦΪ֥ԽԼ֧ԤڹֹۡʦԶ֥ծʾǣŴѵ¡</p>\r\n<p>£֥˾Ĺ㷢һЩ仯ϯִй(Atsutoshi Nishida)6̨ȡ֮ǹ˾ʩľ(Norio Sasaki)</p>\r\n<p>65ϵCEO4꣬ڼ䣬Զ֥˴Χţ2006Ͷ37Ԫչݹ˾(Westinghouse)ɷԼǿԺԴҵĿơ⣬ͶʽоƬĲ</p>\r\n<p>2007֥꣬10ԪһṤΪPS32£֥ʾ͸ʿͨЭ飬׼Ӳҵ񣬲δչ۸һ¡ڽչ֮󣬶֥ΪıʼǱӲ̡</p>\r\n<p>Ӫʦʾϵչսȫ򾭼ΣӰ콫ûʵ֣½оƬ۸½Ϲɼµʹ֥ϽƻŴپ޴ѹ(¿±)</p>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('563','','1240128654','582','4','1','1','<div>\r\n	<span style=\"font-size: 9pt; color: #525252\">Ĺվڲ̳ˣѾϢ۸Ƚϵȡ</span><span style=\"font-size: 9pt; color: #525252\">е</span><span style=\"font-size: 9pt; color: #525252\">C2C</span><span style=\"font-size: 9pt; color: #525252\">վϷ</span><span style=\"font-size: 9pt; color: #525252\">ӰһЩֻŻվŻᾭõķټֱӷʹվӣ&ldquo;&rdquo;Żվر&ldquo;</span><span style=\"font-size: 9pt; color: #525252\">naver</span><span style=\"font-size: 9pt; color: #525252\">&rdquo;ͼΪЩվĿǰ</span><span style=\"font-size: 9pt; color: #525252\">Naver</span><span style=\"font-size: 9pt; color: #525252\">Ͷ˴Ĺ棬Ҫ֧ɽѣЩ֧ıǺܴġ</span></div>\r\n<div>\r\n	<br />\r\n	<span style=\"font-size: 9pt; color: #525252\"></span><span style=\"font-size: 9pt; color: #525252\">Rankey.com</span><span style=\"font-size: 9pt; color: #525252\">ͺ</span><span style=\"font-size: 9pt; color: #525252\">Naver</span><span style=\"font-size: 9pt; color: #525252\"></span><span style=\"font-size: 9pt; color: #525252\">Gmarket</span><span style=\"font-size: 9pt; color: #525252\">ķÿѾ</span><span style=\"font-size: 9pt; color: #525252\">2006</span><span style=\"font-size: 9pt; color: #525252\"></span><span style=\"font-size: 9pt; color: #525252\">39</span><span style=\"font-size: 9pt; color: #525252\">%</span><span style=\"font-size: 9pt; color: #525252\">͵ȥ</span><span style=\"font-size: 9pt; color: #525252\">26%</span><span style=\"font-size: 9pt; color: #525252\">⣬ṹվҲͬŻվ</span><span style=\"font-size: 9pt; color: #525252\">2005</span><span style=\"font-size: 9pt; color: #525252\">깺վĹռش</span><span style=\"font-size: 9pt; color: #525252\">2005</span><span style=\"font-size: 9pt; color: #525252\"></span><span style=\"font-size: 9pt; color: #525252\">19%</span><span style=\"font-size: 9pt; color: #525252\">ȥ</span><span style=\"font-size: 9pt; color: #525252\">45%</span><span style=\"font-size: 9pt; color: #525252\"></span><br />\r\n	<br />\r\n	<span style=\"font-size: 9pt; color: #525252\">ҵʿʾ&ldquo;</span><span style=\"font-size: 9pt; color: #525252\">Gmarket</span><span style=\"font-size: 9pt; color: #525252\">ĹЧŻվ&rdquo;&ldquo;ԱΪ</span><span style=\"font-size: 9pt; color: #525252\">1570</span><span style=\"font-size: 9pt; color: #525252\">ÿƽ</span><span style=\"font-size: 9pt; color: #525252\">1810</span><span style=\"font-size: 9pt; color: #525252\">ˣԹ̲&rdquo;</span><br />\r\n	<br />\r\n	<span style=\"font-size: 9pt; color: #525252\">Ŀǰܶ๫˾ȿֺͨŻͷҲ˹վŻվչĽ̡</span><span style=\"font-size: 9pt; color: #525252\">Interpark</span><span style=\"font-size: 9pt; color: #525252\">ڿͨ</span><span style=\"font-size: 9pt; color: #525252\">Naver</span><span style=\"font-size: 9pt; color: #525252\">&ldquo;֪ʶ&rdquo;Ƶļ۸ȽϷ&ldquo;</span><span style=\"font-size: 9pt; color: #525252\">e</span><span style=\"font-size: 9pt; color: #525252\">ͼ&rdquo;󣬺ܻӭվ</span><span style=\"font-size: 9pt; color: #525252\">15</span><span style=\"font-size: 9pt; color: #525252\">ƵڵʹʱȽϸߡ</span><span style=\"font-size: 9pt; color: #525252\">D&amp;shop</span><span style=\"font-size: 9pt; color: #525252\">Ҳͨ</span><span style=\"font-size: 9pt; color: #525252\">3</span><span style=\"font-size: 9pt; color: #525252\">ƷȽϡ񣬷ӦҲ</span></div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	<span style=\"font-size: 9pt; color: #525252\">⹺վҲǿŻϢݡ</span><span style=\"font-size: 9pt; color: #525252\">Lotte.com</span><span style=\"font-size: 9pt; color: #525252\">еʱ־</span><span style=\"font-size: 9pt; color: #525252\">&ldquo;</span><span style=\"font-size: 9pt; color: #525252\">Fashion &amp; The City</span><span style=\"font-size: 9pt; color: #525252\">&rdquo;ÿҲ</span><span style=\"font-size: 9pt; color: #525252\">200</span><span style=\"font-size: 9pt; color: #525252\">ϣ</span><span style=\"font-size: 9pt; color: #525252\">istyle24</span><span style=\"font-size: 9pt; color: #525252\"></span><span style=\"font-size: 9pt; color: #525252\">2006</span><span style=\"font-size: 9pt; color: #525252\">꿪ͨ&ldquo;ʱ־&rdquo;ƵԺѾӵ</span><span style=\"font-size: 9pt; color: #525252\">3000</span><span style=\"font-size: 9pt; color: #525252\">ʱоݣ</span><span style=\"font-size: 9pt; color: #525252\">Hmall</span><span style=\"font-size: 9pt; color: #525252\">־&ldquo;</span><span style=\"font-size: 9pt; color: #525252\">HMall</span><span style=\"font-size: 9pt; color: #525252\">־&rdquo;ҲĶ</span><br />\r\n	&nbsp;</div>\r\n<div>\r\n	<p>\r\n		<span style=\"font-size: 9pt; color: #525252\">Gmarket</span><span style=\"font-size: 9pt; color: #525252\">ҵ˵&ldquo;Ϣṩ۸Ƚ&rdquo;ЩŻվķؿ˹վķΧͨ컯ûȣôվŻվӰ߳</span></p>\r\n</div>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('564','','1240128744','583','4','1','1','<p><img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www_qibosoft_com/Tmp_updir/article/4/1_20090419160422_PjOh8.jpg\" width=\"583\" height=\"370\" border=\"0\" alt=\"23.jpg\" title=\"23.jpg\" /></p>\r\n<p>Ҹ˶ԻƷ¼PM⣬ͼＸݣ</p>\r\n<p>1ɫͷָPMڹҪӴĶ<br />\r\n2ɫͷPMΪģָΧĸţ˵ڹͨЭаĽɫ<br />\r\n3ɫͷҵУPMЩת<br />\r\n4ͼ˵״ͷұۡ˫šࡣ</p>\r\n<p>ͼֻ˵дԣձԣΪҵͬ֯ͬģʽͬPMڹв졣ֻϣͼʹһPMְҵе㡢֧㡢㡣</p>\r\n<p><strong>һƷ</strong></p>\r\n<p>ͼɫߣֱָPM˵Ż˵๤ܷչΪPMǷֱǸƷӪĲšƷӪĲšƷʵֵĲš</p>\r\n<p>ƷӪĲźгӴ࣬гҲ𽥵ĸ˽⣬һƷгֻҪܰгòƷʵֵĲżʵʩѾPMˡгתPMԺͨǿǿӦǿϾڹɽ׶ΣҪѧϰķǲƷĹ;ӪƲƷܲƷԭͣƷ߼ȵȡ</p>\r\n<p>ƷӪĲſ˵ŷḻҵԴӵBDPRͷȵȹ֡˽ҵͬƷʷ״ССĸĶ֪Ϸҵʢһ͵ϷӪ̣ҲǸҪԼϷֻҪѱõϷƷУһǾҪԼһϷʱͿԺܿʵʩΪӪƷͬʱ˴ĲƷг顣µĹҲǺתΪPMġ</p>\r\n<p>ƷʵֵĲţPMĻҾУ˵80%PMǴ߳ġ˽ƷĹܡʹ߼ݽṹϢṹȵȡŲƷġΡټںö๫˾𿪷ĿƷdemoĲƷƶΪPM</p>\r\n<p>һ󣬾ǺöҵϰCEOڼPMְ顣</p>\r\n<p>λ٣ҵεĹǷϼ֮أǣôPMչŶ</p>\r\n<p><strong>Ʒ֧</strong></p>\r\n<p>PMչھѾĽPMɫôҪ߱Щ֧֧PMְλķչأ</p>\r\n<p>1ƤҪ</p>\r\n<p>¿ʼǸͼֵǣɫͷPMΪģָͬĲš˵ڹͨЭаĽɫ</p>\r\n<p>λʿ׷Ůɣǰ᲻ƤôԼ֮ǰҪǱܾ˸öඪԼԷ᲻öԷǶԷǲǸͲԼԼԼˣ</p>\r\n<p>PMڹҲһкܶƻ飬ҳ桢ӭгҪʱרȵȡκ鶼ڸŵļƻ֮ڣôڱ˵֮飬PMʵʩأ쵼Э¶ҪPMʲôǾƤ㣬һЩиĶûʲôЭ˵ġСǾ鷳ˡ</p>\r\n<p>⣬PMڲƷӪУܶʱԵĹͨұ֤ÿιͨPMܹ⣬ܹסҪPMʶ˽⣬PM̬ߣôܿΪӶ⡣</p>\r\n<p>֧˵PMӦþ߱ļܣƪ˵úȫ棬ͨȨ쵼ѧϰҵжȡȰƷעϸڡճƷȵȣƼҿ<a href=\"http://hi.baidu.com/myey8/blog/item/a24a87640d2514f8f636547d.html\" target=\"_blank\"><font color=\"#0033cc\">ƷӦ߱</font></a></p>\r\n<p>ΪһɹPM˾߱Щ֮⣬һ֧㣬Ǿ̬1-5Ƕһ˵5-10ľڶ̬Ժרźʹۡ</p>\r\n<p><strong>Ʒ</strong></p>\r\n<p>PMʱıְλԣ˵PMѾһݹһʽȻҲʱ䳤˻֡ƣ͡⣬Ҳ룬PMá﷢չһֱȥ</p>\r\n<p>ȣPMһҵΪӴ㣬ҪѧϰĶҲҪ࣬ҪΪרţҲǸͨšPMǸϻ۵ְҵʹһʧȥְλô۵Ķòߵġ</p>\r\n<p>Σ˵PMʵƷCEOôPM֮ԼҵٿԱȽϿĽ״̬һЩ·</p>\r\n<p>PMȻǺͲƷһģôƷгӦҲǺPMйϵģƷҵĺûҲҪΪPM˵һ֣ƷúãPMõнˮ࣬ûдﵽгԤھͿPMнˮôPMʵǸнְλ</p>\r\n<p>ģۻҵǴͳҵPMͨģҵѡ</p>\r\n<p>ȵȵȵ???</p>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('574','','1240129686','593','3','1','1','<div>һ·,лһ֧! <br />\r\nͬʱ,ҲܹýĹע: <br />\r\nýر: <br />\r\n<br />\r\n<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://i3.sinaimg.cn/home/deco/2009/0330/con_logo_tech_news.gif\" width=\"110\" height=\"27\" border=\"0\" /><a href=\"http://tech.sina.com.cn/i/2010-12-02/17214935910.shtml\" target=\"_blank\"><font color=\"#0070af\">http://tech.sina.com.cn/i/2010-12-02/17214935910.shtml</font></a> <br />\r\n<br />\r\n<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://cn.yimg.com/ycn/head/img/yahoologocontent.gif\" width=\"118\" height=\"32\" border=\"0\" /><a href=\"http://tech.cn.yahoo.com/yxk/20101202/4yh9.html\" target=\"_blank\"><font color=\"#0070af\">http://tech.cn.yahoo.com/yxk/20101202/4yh9.html</font></a> <br />\r\n<br />\r\n<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://bbs.qibosoft.com/images/ifeng_logo2.gif\" width=\"118\" height=\"45\" border=\"0\" /><a href=\"http://tech.ifeng.com/internet/detail_2010_12/01/3295860_0.shtml\" target=\"_blank\"><font color=\"#0070af\">http://tech.ifeng.com/internet/detail_2010_12/01/3295860_0.shtml</font></a> <br />\r\n<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www.techweb.com.cn/img/images/logo_s.gif\" width=\"77\" height=\"28\" border=\"0\" /> <br />\r\n<a href=\"http://www.techweb.com.cn/internet/2010-12-02/723633.shtml\" target=\"_blank\"><font color=\"#0070af\">http://www.techweb.com.cn/internet/2010-12-02/723633.shtml</font></a> <br />\r\n<a href=\"http://www.techweb.com.cn/news/2010-12-01/723350.shtml\" target=\"_blank\"><font color=\"#0070af\">http://www.techweb.com.cn/news/2010-12-01/723350.shtml</font></a> <br />\r\n<br />\r\n<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www.admin5.com/images/2008a/logodongtian.gif\" width=\"122\" height=\"60\" border=\"0\" /><a href=\"http://www.admin5.com/plus/view.php?aid=291514\" target=\"_blank\"><font color=\"#0070af\">http://www.admin5.com/plus/view.php?aid=291514</font></a> <br />\r\n<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www.chinaz.com/images/logo.gif\" width=\"165\" height=\"60\" border=\"0\" /><a href=\"http://www.chinaz.com/Webmaster/report/12011464202010.html\" target=\"_blank\"><font color=\"#0070af\">http://www.chinaz.com/Webmaster/report/12011464202010.html</font></a> <br />\r\n<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www.cncms.com/templates/cncms/skins/default/images/logo.jpg\" width=\"157\" height=\"51\" border=\"0\" /><a href=\"http://news.cncms.com/2010/1202/4504.html\" target=\"_blank\"><font color=\"#0070af\">http://news.cncms.com/2010/1202/4504.html</font></a> <br />\r\n<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://bbs.qibosoft.com/images/mop.jpg\" width=\"102\" height=\"43\" border=\"0\" /><a href=\"http://tech.mop.com/net/2010/1202/1735542633.shtml\" target=\"_blank\"><font color=\"#0070af\">http://tech.mop.com/net/2010/1202/1735542633.shtml</font></a> <br />\r\n<br />\r\n<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://sudu.cn/images/head/newlogo.gif\" width=\"175\" height=\"60\" border=\"0\" /><a href=\"http://sudu.cn/service/detail.php?id=11689\" target=\"_blank\"><font color=\"#0070af\">http://sudu.cn/service/detail.php?id=11689</font></a> <br />\r\n<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www.eastadmin.com/templets/index_img/logo.gif\" width=\"200\" height=\"45\" border=\"0\" /><a href=\"http://www.eastadmin.com/plus/view.php?aid=4277\" target=\"_blank\"><font color=\"#0070af\">http://www.eastadmin.com/plus/view.php?aid=4277</font></a> <br />\r\n<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www.phpchina.com/templates/phpchina/images/logo.gif\" width=\"188\" height=\"45\" border=\"0\" /><a href=\"http://www.phpchina.com/index.php?action-viewnews-itemid-37657-php-1\" target=\"_blank\"><font color=\"#0070af\">http://www.phpchina.com/index.php?action-viewnews-itemid-37657-php-1</font></a> <br />\r\n<br />\r\n<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www.im286.cn/templets/im2862/images/logo.png\" width=\"162\" height=\"44\" border=\"0\" /><a href=\"http://www.im286.cn/plus/view.php?aid=26387\" target=\"_blank\"><font color=\"#0070af\">http://www.im286.cn/plus/view.php?aid=26387</font></a> <br />\r\n<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://news.cnzz.cn/Skin/new_cn/Images/logo.jpg\" width=\"140\" height=\"70\" border=\"0\" /><a href=\"http://news.cnzz.cn/NewsInfo/22214.aspx\" target=\"_blank\"><font color=\"#0070af\">http://news.cnzz.cn/NewsInfo/22214.aspx</font></a> <br />\r\n<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www.donews.com//images/indx_tmp/bg_04.gif\" width=\"178\" height=\"73\" border=\"0\" /><a href=\"http://www.donews.com/net/201011/284543.shtm\" target=\"_blank\"><font color=\"#0070af\">http://www.donews.com/net/201011/284543.shtm</font></a> <br />\r\n<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://soft.yesky.com/TLimages2009/yesky/images/logo/c_newlogo.gif\" width=\"91\" height=\"36\" border=\"0\" /><a href=\"http://soft.yesky.com/news/22/11672522.shtml\" target=\"_blank\"><font color=\"#0070af\">http://soft.yesky.com/news/22/11672522.shtml</font></a> <br />\r\n<br />\r\n<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www.cnii.com.cn/iframe/tplimg/53.files/images/logo.gif\" width=\"150\" height=\"70\" border=\"0\" /><a href=\"http://www.cnii.com.cn/internet/content/2010-12/03/content_816067.htm\" target=\"_blank\"><font color=\"#0070af\">http://www.cnii.com.cn/internet/content/2010-12/03/content_816067.htm</font></a> <br />\r\n<br />\r\n<br />\r\n<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://tech.ddvip.com/2010/images/logo.gif\" width=\"191\" height=\"60\" border=\"0\" /><a href=\"http://tech.ddvip.com/2010-12/1291174067163689.html\" target=\"_blank\"><font color=\"#0070af\">http://tech.ddvip.com/2010-12/1291174067163689.html</font></a> <br />\r\n<br />\r\n<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www.gdwest.com/images/west/logo.png\" width=\"163\" height=\"52\" border=\"0\" /><a href=\"http://www.gdwest.com/news/96/12620.htm\" target=\"_blank\"><font color=\"#0070af\">http://www.gdwest.com/news/96/12620.htm</font></a> <br />\r\n<br />\r\n<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www.itbear.com.cn/images/show_logo.gif\" width=\"127\" height=\"24\" border=\"0\" /><a href=\"http://www.itbear.com.cn/ZiXun/2010-11/29998.html\" target=\"_blank\"><font color=\"#0070af\">http://www.itbear.com.cn/ZiXun/2010-11/29998.html</font></a> <br />\r\n<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://bbs.flashget.com/images/Zentendo_03/logo.gif\" width=\"330\" height=\"120\" border=\"0\" /><a href=\"http://bbs.flashget.com/viewthread.php?tid=32508&extra=page%3D1\" target=\"_blank\"><font color=\"#0070af\">http://bbs.flashget.com/viewthread.php?tid=32508&amp;extra=page%3D1</font></a> <br />\r\n<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www.php100.com/templets/images/logo.png\" width=\"139\" height=\"69\" border=\"0\" /><a href=\"http://www.php100.com/html/phpnews/PHPxinwen/2010/1121/6867.html\" target=\"_blank\"><font color=\"#0070af\">http://www.php100.com/html/phpnews/PHPxinwen/2010/1121/6867.html</font></a> <br />\r\n<br />\r\n<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www.qibosoft.com/upload_files_p888/friendlink/40001_20100228160200_idba9.gif\" width=\"88\" height=\"31\" border=\"0\" /><a href=\"http://www.chinaccnet.com/content.php?module=content_newsdetail&news_id=29\" target=\"_blank\"><font color=\"#0070af\">http://www.chinaccnet.com/content.php?module=content_newsdetail&amp;news_id=29</font></a> <br />\r\n<br />\r\n<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www.west263.com/info/templets/images/Default_11.gif\" width=\"156\" height=\"47\" border=\"0\" /><a href=\"http://www.west263.com/info/html/xingyezixun/yejiedongtai/20101122/1930518.html\" target=\"_blank\"><font color=\"#0070af\">http://www.west263.com/info/html/xingyezixun/yejiedongtai/20101122/1930518.html</font></a> <br />\r\n<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www.ndiis.com/new/logo.gif\" width=\"220\" height=\"80\" border=\"0\" /><a href=\"http://www.ndiis.com/news/nws_dtl.asp?nid=10000026\" target=\"_blank\"><font color=\"#0070af\">http://www.ndiis.com/news/nws_dtl.asp?nid=10000026</font></a> <br />\r\n<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www.ifengwo.com/images/logo.gif\" width=\"207\" height=\"70\" border=\"0\" /><a href=\"http://www.ifengwo.com/zuozhewenzhang/201011/20-182606.html\" target=\"_blank\"><font color=\"#0070af\">http://www.ifengwo.com/zuozhewenzhang/201011/20-182606.html</font></a> <br />\r\n<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www.jz123.cn/image/logo.png\" width=\"210\" height=\"60\" border=\"0\" /><a href=\"http://www.jz123.cn/plus/view.php?aid=35318\" target=\"_blank\"><font color=\"#0070af\">http://www.jz123.cn/plus/view.php?aid=35318</font></a> <br />\r\n<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www.bbscode.com/templets/index_img/logo.gif\" width=\"180\" height=\"60\" border=\"0\" /><a href=\"http://www.bbscode.com/text/news/2010/1123/59092.html\" target=\"_blank\"><font color=\"#0070af\">http://www.bbscode.com/text/news/2010/1123/59092.html</font></a> <br />\r\n<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www.pd.sd.cn/tp/image/logo.gif\" width=\"180\" height=\"60\" border=\"0\" /><a href=\"http://www.pd.sd.cn/html/2010/11/22093130206.htm\" target=\"_blank\"><font color=\"#0070af\">http://www.pd.sd.cn/html/2010/11/22093130206.htm</font></a> <br />\r\n<br />\r\n<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www.txwb.com/Skin/txwb/logo.gif\" width=\"219\" height=\"60\" border=\"0\" /><a href=\"http://www.txwb.com/Article/hyzx/wlzz/201011/85119.html\" target=\"_blank\"><font color=\"#0070af\">http://www.txwb.com/Article/hyzx/wlzz/201011/85119.html</font></a> <br />\r\n<br />\r\n<img onload=\'if(this.width>600)makesmallpic(this,600,1800);\' src=\"http://www.cn37.cn/cn37/cn37_logo.gif\" width=\"168\" height=\"60\" border=\"0\" /><a href=\"http://www.cn37.cn/article/2714.html\" target=\"_blank\"><font color=\"#0070af\">http://www.cn37.cn/article/2714.html</font></a> <br />\r\n<a href=\"http://news.ename.cn/yuming_xinwen_2010_12_01_25820.html\" target=\"_blank\"><font color=\"#0070af\">http://news.ename.cn/yuming_xinwen_2010_12_01_25820.html</font></a> <br />\r\n<br />\r\n<a href=\"http://news.syd.com.cn/content/2010-12/02/content_25176700.htm\" target=\"_blank\"><font color=\"#0070af\">http://news.syd.com.cn/content/2010-12/02/content_25176700.htm</font></a> <br />\r\n<br />\r\n<a href=\"http://www.jiaonan.com/html/2010/11/22093115441.htm\" target=\"_blank\"><font color=\"#0070af\">http://www.jiaonan.com/html/2010/11/22093115441.htm</font></a> <br />\r\n<br />\r\n<a href=\"http://www.gdwest.com/news/96/12620.htm\" target=\"_blank\"><font color=\"#0070af\">http://www.gdwest.com/news/96/12620.htm</font></a> <br />\r\n<br />\r\n<br />\r\n<a href=\"http://edu.codepub.com/2010/1123/27371.php\" target=\"_blank\"><font color=\"#0070af\">http://edu.codepub.com/2010/1123/27371.php</font></a> <br />\r\n<a href=\"http://www.xinfengit.com/201011/23115011.html\" target=\"_blank\"><font color=\"#0070af\">http://www.xinfengit.com/201011/23115011.html</font></a> <br />\r\n<a href=\"http://236z.com/plus/view.php?aid=127792\" target=\"_blank\"><font color=\"#0070af\">http://236z.com/plus/view.php?aid=127792</font></a>&nbsp;&nbsp; <br />\r\n<a href=\"http://www.qq050.com/article.asp?id=3772\" target=\"_blank\"><font color=\"#0070af\">http://www.qq050.com/article.asp?id=3772</font></a> <br />\r\n<a href=\"http://www.webjx.com/news/focus-27784.html\" target=\"_blank\"><font color=\"#0070af\">http://www.webjx.com/news/focus-27784.html</font></a> <br />\r\n<a href=\"http://www.55175.cn/Comments.asp?ArticleID=4733\" target=\"_blank\"><font color=\"#0070af\">http://www.55175.cn/Comments.asp?ArticleID=4733</font></a> <br />\r\n<a href=\"http://www.zz360.net/plus/view-3492-1.html\" target=\"_blank\"><font color=\"#0070af\">http://www.zz360.net/plus/view-3492-1.html</font></a> <br />\r\n<a href=\"http://www.ok.net.cn/html/24/n-21324.html\" target=\"_blank\"><font color=\"#0070af\">http://www.ok.net.cn/html/24/n-21324.html</font></a> <br />\r\n<a href=\"http://www.91papa.com/html/56-3/3033.htm\" target=\"_blank\"><font color=\"#0070af\">http://www.91papa.com/html/56-3/3033.htm</font></a> <br />\r\n<a href=\"http://www.jzc8.com/article/1972/96929_1.html\" target=\"_blank\"><font color=\"#0070af\">http://www.jzc8.com/article/1972/96929_1.html</font></a> <br />\r\n<a href=\"http://www.idczhuji.com/idczhuji/news/zhujinews/2010/1125/8183.html\" target=\"_blank\"><font color=\"#0070af\">http://www.idczhuji.com/idczhuji/news/zhujinews/2010/1125/8183.html</font></a> <br />\r\n<a href=\"http://www.news365.com.cn/gdxww/170900.htm\" target=\"_blank\"><font color=\"#0070af\">http://www.news365.com.cn/gdxww/170900.htm</font></a> <br />\r\n<a href=\"http://www.qq050.com/article.asp?id=3772\" target=\"_blank\"><font color=\"#0070af\">http://www.qq050.com/article.asp?id=3772</font></a> <br />\r\n<a href=\"http://www.zz360.net/plus/view-3492-1.html\" target=\"_blank\"><font color=\"#0070af\">http://www.zz360.net/plus/view-3492-1.html</font></a> <br />\r\n<a href=\"http://www.cn37.cn/article/2714.html\" target=\"_blank\"><font color=\"#0070af\">http://www.cn37.cn/article/2714.html</font></a> <br />\r\n<a href=\"http://www.txwb.com/Article/hyzx/wlzz/201011/85119.html\" target=\"_blank\"><font color=\"#0070af\">http://www.txwb.com/Article/hyzx/wlzz/201011/85119.html</font></a> <br />\r\n<a href=\"http://www.ok.net.cn/html/24/n-21324.html\" target=\"_blank\"><font color=\"#0070af\">http://www.ok.net.cn/html/24/n-21324.html</font></a> <br />\r\n<a href=\"http://www.zunmi.com/news/201012/15350.html\" target=\"_blank\"><font color=\"#0070af\">http://www.zunmi.com/news/201012/15350.html</font></a> <br />\r\n<a href=\"http://www.hackbase.com/news/2010-12-03/39856.html\" target=\"_blank\"><font color=\"#0070af\">http://www.hackbase.com/news/2010-12-03/39856.html</font></a> <br />\r\n<a href=\"http://www.china-code.net/al-ccmmVYSLlN-374521.html\" target=\"_blank\"><font color=\"#0070af\">http://www.china-code.net/al-ccmmVYSLlN-374521.html</font></a> <br />\r\n<a href=\"http://www.sootoo.com/content/71993.shtml\" target=\"_blank\"><font color=\"#0070af\">http://www.sootoo.com/content/71993.shtml</font></a> <br />\r\n<a href=\"http://www.5b.com.cn/hulianwangxun/2010/12/01/5b129117823411188.shtml\" target=\"_blank\"><font color=\"#0070af\">http://www.5b.com.cn/hulianwangxun/2010/12/01/5b129117823411188.shtml</font></a> <br />\r\n<a href=\"http://www.jzc8.com/article/1972/96929_1.html\" target=\"_blank\"><font color=\"#0070af\">http://www.jzc8.com/article/1972/96929_1.html</font></a> <br />\r\n<a href=\"http://www.bbscode.com/text/news/2010/1123/59092.html\" target=\"_blank\"><font color=\"#0070af\">http://www.bbscode.com/text/news/2010/1123/59092.html</font></a> <br />\r\n<a href=\"http://www.phoer.net/?action-viewnews-itemid-199237\" target=\"_blank\"><font color=\"#0070af\">http://www.phoer.net/?action-viewnews-itemid-199237</font></a> <br />\r\n<a href=\"http://news.xilele.com/keji/266664.htm\" target=\"_blank\"><font color=\"#0070af\">http://news.xilele.com/keji/266664.htm</font></a> <br />\r\n<a href=\"http://news.xinmin.cn/rollnews/2010/12/02/8075967.html\" target=\"_blank\"><font color=\"#0070af\">http://news.xinmin.cn/rollnews/2010/12/02/8075967.html</font></a> <br />\r\n<a href=\"http://flash.longonline.net/article/240/sort02047/2010/20101125133367.asp\" target=\"_blank\"><font color=\"#0070af\">http://flash.longonline.net/article/240/sort02047/2010/20101125133367.asp</font></a> <br />\r\n<a href=\"http://www.zhanzhang.com/news/trend/20101204/29250.html\" target=\"_blank\"><font color=\"#0070af\">http://www.zhanzhang.com/news/trend/20101204/29250.html</font></a> <br />\r\n<a href=\"http://www.pd.sd.cn/html/2010/11/22093130206.htm\" target=\"_blank\"><font color=\"#0070af\">http://www.pd.sd.cn/html/2010/11/22093130206.htm</font></a> <br />\r\n<a href=\"http://www.5b.com.cn/hulianwangxun/2010/12/01/5b129117823411188.shtml\" target=\"_blank\"><font color=\"#0070af\">http://www.5b.com.cn/hulianwangxun/2010/12/01/5b129117823411188.shtml</font></a></div>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('575','','1240129723','594','3','1','1','Ϊο,ʵֿں̨ɸƳͬģ,ܾǰ¿װһ. <br />\r\n<br />\r\n,ٷĬṩĿϵͳ,ж;,ȫһ,һĿ,һƽʱϰ,һѧ,һСѧ,㲻һ.ôں̨һ,Ϳ, <br />\r\n<br />\r\nƺ,ԶԷиԻ޸,Ļ,Խиһ޸. <br />\r\n<br />\r\nȻµĹܾ͸,ŮƵ,ƼƵ,Ҫ,һ. <br />\r\n<br />\r\nЩ,ֻں̨һͿʵ. <br />\r\n<br />\r\nҪҲݿ,޸κγ.û,ֵĻ,һĶο,Կʹ.ⵥ.ȵ. <br />\r\n<br />\r\n<br />\r\n벩Ҫ׷,ʵ <br />\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('576','','1240129752','595','3','1','1','ʱִ,һҳ̬,<br />\r\n<br />\r\nÿĳʱִһ.<br />\r\n<br />\r\n<br />\r\nδĳʱִһ<br />\r\n<br />\r\n,һ,ִһ,ڶ,ÿĳʱִһ,,δĳʱ,ִֻһ.<br />\r\n<br />\r\n<br />\r\n<br />\r\nʱݿĹҲʵ,<br />\r\n,ҿÿʲôʱԶݿ.Ƽ賿,ʱ,ѹС,Ӱ첻.<br />\r\n<br />\r\n,ÿԶһ,ҾͲվֲϵĺ,رǶû˵,ǵñݿ.<br />\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('579','','1240129958','598','3','1','1','ҵĿ֮˸, ckeditor༭.<br />\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('580','','1240130011','599','3','1','1','<div>벩CMS֮V7棬ҽҿɴ汾˵ųǰ̱ãڹϣڱV6йܵĻϣ൱ʵùģһЩɫܡҲͬ <br />\r\nڷ棬ÿ˵۲һȻ󲿷˺Ͽɵǰķ񣬵Ҳв˲̫Ͽɵǰķ <br />\r\nˣ£ǶһŸжģΪлһǵ֧֡Ǿܵ跨ȥҵ <br />\r\nΪ˹ٷʽٰ״ģϣͨδԳྫģ壬 <br />\r\n<br />\r\nƷ£ <br />\r\nһȽ1000Ԫֽ + CMSվطŻB2Bϵͳϵͳѡһ+ͭ1000 <br />\r\nȽ500Ԫֽ + CMSվطŻB2Bϵͳϵͳѡһ+ͭ500 <br />\r\nȵȣ300Ԫֽ + CMSվطŻB2Bϵͳϵͳѡһ+ͭ300 <br />\r\n100Ԫֽ + CMSվطŻB2Bϵͳϵͳѡһ+ͭ100 <br />\r\n<br />\r\nǻûǽṩһչʾƽ̨Ҳǻ¿һ֤ôҪģҵ㡣 <br />\r\n<br />\r\n<br />\r\nֹڴӲƷ <br />\r\n<br />\r\nѡʽɹٷѡΪͶƱΪ <br />\r\n<br />\r\nֻҪṩҳPSͼģ˲鲻ǵˣȥģǰõV7԰棬ڱԵԷʹá <br />\r\n<br />\r\nע:V6Ļһ <br />\r\n<br />\r\n⣬ӭҼV7שǷǹܷ棬ֻǲŻƺóôҾV7档</div>\r\n','0');
INSERT INTO `qb_news_reply` VALUES ('584','','1240201330','603','39','1','1','벩V7¾̬,ڽ,ȡ÷Ծͻ,ʱȫվ̬+˼ؾ̬<br />\r\nʱȫվָ̬,Կʱ,ÿ賿˷,ѹСʱ,Զȫվ̬һ,Է㲹ȫһЩ©ľ̬ҳ.<br />\r\n<br />\r\n<br />\r\n˼ؾָ̬,һȫվ̬,ɹرҳ,ں̨ĵ.Ҫ㿪,ĵȴСʱ,ƪ,һֱΪֹ.ʱ,ٱ,.ֵΪˢһ¼һ<br />\r\n<br />\r\nҲڶCMSһֱڵ,صŴҲþ̬.<br />\r\n<br />\r\n,벩CMSѾһֱΪŴҵ.<br />\r\n<br />\r\nҲѽ,бҳϰҳ,Ҫȴþòת꾲̬.','0');
INSERT INTO `qb_news_reply` VALUES ('585','','1240209505','604','39','1','1','ӭҶڵV7棬йϲĽ飬ϸòλǺ治ͬ <br />\r\n<br />\r\nֻдڰָǲſԸƺϵͳôյʹá <br />\r\n<br />\r\n֮˵˲̫ĳޣͻɱԼ˫ۣڡͻᵼòϵͳòõƣҲӰ쵽ڽʹá','0');
INSERT INTO `qb_news_sort` VALUES ('1','0','0','','1','8','1','','0','0','','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:25:\"template/default/news.htm\";}','','0','','','0','','','','','0','a:11:{s:11:\"sonTitleRow\";s:0:\"\";s:12:\"sonTitleLeng\";s:0:\"\";s:9:\"cachetime\";N;s:12:\"sonListorder\";s:1:\"0\";s:14:\"listContentNum\";N;s:12:\"ListShowType\";N;s:14:\"label_bencandy\";s:0:\"\";s:10:\"channelDir\";s:4:\"nnew\";s:13:\"channelDomain\";s:0:\"\";s:10:\"label_list\";s:0:\"\";s:15:\"ListShowBigType\";s:13:\"bigsort_tpl/0\";}','XinWenZhongXin/{$page}.html','','','');
INSERT INTO `qb_news_sort` VALUES ('3','1','0','','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','1','','','','','0','a:9:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;s:14:\"listContentNum\";s:0:\"\";s:12:\"ListShowType\";s:10:\"list_tpl/6\";s:15:\"ListShowBigType\";N;s:10:\"label_list\";s:0:\"\";s:14:\"label_bencandy\";s:0:\"\";}','SheHuiXinWen/{$page}.html','SheHuiXinWen/{$time_Y}{$time_m}{$time_d}/{$id}-{$page}.html','','');
INSERT INTO `qb_news_sort` VALUES ('4','1','0','ITҵ','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','31','','','1','3','','','','0','a:7:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;s:14:\"listContentNum\";s:0:\"\";s:12:\"ListShowType\";s:11:\"list_tpl/10\";s:15:\"ListShowBigType\";N;}','ITYeJie/{$page}.html','ITYeJie/{$time_Y}{$time_m}{$time_d}/{$id}-{$page}.html','','');
INSERT INTO `qb_news_sort` VALUES ('31','1','0','ͷ','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','1','','','','','1','a:7:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;s:14:\"listContentNum\";s:0:\"\";s:12:\"ListShowType\";s:10:\"list_tpl/3\";s:15:\"ListShowBigType\";N;}','XinWenTouTiao/{$page}.html','XinWenTouTiao/{$time_Y}{$time_m}{$time_d}/{$id}-{$page}.html','','');
INSERT INTO `qb_news_sort` VALUES ('32','1','0','Ƽ','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','1','','','','','1','a:7:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;s:14:\"listContentNum\";s:0:\"\";s:12:\"ListShowType\";s:0:\"\";s:15:\"ListShowBigType\";N;}','TuiJianXinWen/{$page}.html','TuiJianXinWen/{$time_Y}{$time_m}{$time_d}/{$id}-{$page}.html','','');
INSERT INTO `qb_news_sort` VALUES ('33','1','0','ͼƬ','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','1','','','','','1','a:7:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;s:14:\"listContentNum\";s:0:\"\";s:12:\"ListShowType\";s:0:\"\";s:15:\"ListShowBigType\";N;}','TuPianXinWen/{$page}.html','TuPianXinWen/{$time_Y}{$time_m}{$time_d}/{$id}-{$page}.html','','');
INSERT INTO `qb_news_sort` VALUES ('34','1','0','ȵ¼','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','1','','','','','1','a:7:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;s:14:\"listContentNum\";s:0:\"\";s:12:\"ListShowType\";s:10:\"list_tpl/2\";s:15:\"ListShowBigType\";N;}','ReDianShiJian/{$page}.html','ReDianShiJian/{$time_Y}{$time_m}{$time_d}/{$id}-{$page}.html','','');
INSERT INTO `qb_news_sort` VALUES ('38','1','0','һﾪ','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','1','','','','','0','a:7:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;s:14:\"listContentNum\";s:0:\"\";s:12:\"ListShowType\";s:10:\"list_tpl/4\";s:15:\"ListShowBigType\";N;}','YiYuJingRen/{$page}.html','YiYuJingRen/{$time_Y}{$time_m}{$time_d}/{$id}-{$page}.html','','');
INSERT INTO `qb_news_sort` VALUES ('39','1','0','web','2','0','0','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','1','','','','','0','a:7:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;s:14:\"listContentNum\";s:0:\"\";s:12:\"ListShowType\";s:10:\"list_tpl/8\";s:15:\"ListShowBigType\";N;}','webXinWen/{$page}.html','webXinWen/{$time_Y}{$time_m}{$time_d}/{$id}-{$page}.html','','');
INSERT INTO `qb_news_special` VALUES ('10','1','ҳõƬ','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','','7,142,184,248,250,249','3,8,9,10,11,6,12,14,13,5,7,4','','0','1','admin','1237382603','1237382603','44','1301727914','0','1299634568','','','3,4','1','','1');
INSERT INTO `qb_news_special` VALUES ('11','1','ҳͷ','',' ʱ','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','','7,142,184,248,250,249','3,8,9,10,11,6,12,14,13,5,7,4','','0','1','admin','1237382706','1237382706','121','1301728180','0','1238675329','','','3,4','1','','1');
INSERT INTO `qb_news_special` VALUES ('19','1','ϣ˹ź¶','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','special/1_20101119091108_agkc8.jpg','˹ŵϣ˹Ӷһչյнϣ˹ûбΪ򡱣ֻ6²11·ط̳ϣ˹Υֶ̽ΪԼδܼʱϱĹʧ75000Ӣԭ-Զֹμ˹ŵ\r\n','561,562,563,564','','','0','1','admin','1240114393','1240116680','299','1301728180','1','1240116319','','','','0','','1');
INSERT INTO `qb_news_special` VALUES ('20','1','Ӣ࿨÷2010û','','','','a:3:{s:4:\"head\";s:25:\"template/default/none.htm\";s:4:\"foot\";s:25:\"template/default/none.htm\";s:8:\"bencandy\";s:24:\"template/special/sp1.htm\";}','special/1_20101122161134_u6aeu.jpg','磬Ӣά÷һзʱ󣬲ڱѧ칫¥÷ݽǿйҵķչвһֻӢҪڸǿ\r\n\r\nά÷43굱ѡӢ53࣬Ӣ1812ࡣѧǴά÷κ״ηû48СʱгеҪһվ\r\n','595,596,597,598,599,600,601','23,25,26,27,28,29,30,31','','0','1','admin','1240116689','1240116689','366','1301728180','1','1240117139','','','','0','','1');
INSERT INTO `qb_news_special` VALUES ('21','1','۽ʸĸٽƽó׷','','','','a:3:{s:4:\"head\";s:25:\"template/default/none.htm\";s:4:\"foot\";s:25:\"template/default/none.htm\";s:8:\"bencandy\";s:36:\"template/special/special_finance.htm\";}','special/1_20101122151126_wvvvp.jpg','Ժ2934879ͶƱͨʸĸٽƽó׷ּڶν͹һʵĹر˰һΪǽóױµ֡','587,590,591,593,594,595,596,598','23,24,25,26,28,29,27,30,31','','0','1','admin','1240120502','1240120502','361','1301728260','1','1240121484','','','','0','','1');
INSERT INTO `qb_news_special` VALUES ('22','1','µA3 Ŀͬڳ͵','','','','a:3:{s:4:\"head\";s:25:\"template/default/none.htm\";s:4:\"foot\";s:25:\"template/default/none.htm\";s:8:\"bencandy\";s:32:\"template/special/special_car.htm\";}','special/1_20101119161104_fdxqf.jpg','   µA3 SportbackѾʽУͬгУͬΪڳ͵ı1ϵԼڵпĿͲʵڼ۸ϻǳ϶ǰµA3ľ\r\n','679,594,680,681,682,597,595','31,30,29,28,20,21,22,23,27,26,25,24','','0','1','admin','1240121828','1240121828','456','1306912466','1','1240122051','','','','0','','1');
INSERT INTO `qb_news_special` VALUES ('24','1','ɳкͳɹйCEO','','','','a:3:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:8:\"bencandy\";s:28:\"template/default/showsp2.htm\";}','special/1_20090419140403_B36H1.jpg','̫ĹºֵЩûɹʿο\r\nǻѾɹЩڳɳУ죬ǶѾӢۡ','583,594,595,598','17,19,28,29,31,30,20,21,22,23,24,27,26,25','','0','1','admin','1240124312','1240116681','379','1301728180','1','1240125051','','special/1_20090419150403_aMUbN.jpg','','0','','1');
INSERT INTO `qb_news_special` VALUES ('23','1','й۵ο','','','','a:3:{s:4:\"head\";s:25:\"template/default/none.htm\";s:4:\"foot\";s:25:\"template/default/none.htm\";s:8:\"bencandy\";s:28:\"template/special/showsp2.htm\";}','special/1_20090419140451_9nuT0.jpg','Ǵҵȳӿ죬ǽΣȻĽ죬\r\nõļӦʼǲҵչ֮ءֻڶõĻشҲڲͣ任\r\nΪһţǻθıǵCEOǿĲҵδеʲôһ\r\n20092ѶƼƻ߷ðλITCEOCTOǵĴһһΪѳ','674,675,676,677,678,679,597,598','17,19,18,23,20,21,22,27,28,26,25,24','','0','1','admin','1240122281','1240121827','64','1306912470','1','1240122359','','special/1_20090419150453_IGx32.jpg','','0','','1');
INSERT INTO `qb_news_spsort` VALUES ('1','0','ʱר','1','0','1','','1','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:4:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;}','special{$fid}/list{$page}.htm','special{$fid}/show{$id}.htm');
INSERT INTO `qb_news_spsort` VALUES ('2','0','ר','1','0','1','','0','0','','','fff','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','33','','0','','','','','0','a:4:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;}','','');
INSERT INTO `qb_news_spsort` VALUES ('3','0','2008̵','1','0','1','','0','0','','','','','','','0','','','1','','','','','0','','','');
INSERT INTO `qb_news_spsort` VALUES ('4','0','fdsa','1','1','1','','0','0','','','','','','','0','','','1','','','','','0','','','');
INSERT INTO `qb_news_spsort` VALUES ('6','4','fdsafd','2','0','1','','0','0','','','','','a:4:{s:4:\"head\";s:0:\"\";s:4:\"foot\";s:0:\"\";s:4:\"list\";s:0:\"\";s:8:\"bencandy\";s:0:\"\";}','','0','','','0','','','','','0','a:4:{s:11:\"sonTitleRow\";N;s:12:\"sonTitleLeng\";N;s:9:\"cachetime\";N;s:12:\"sonListorder\";N;}','','');
