<?php // -*-php-*-
// rcs_id('$Id: MostRecentIter.php 7638 2010-08-11 11:58:40Z vargenau $');

require_once('lib/WikiDB/backend.php');


/**
 * An inefficient but general most_recent iterator.
 *
 * This iterator will work with any backends.
 */
class WikiDB_backend_dumb_MostRecentIter
extends WikiDB_backend_iterator
{
    function WikiDB_backend_dumb_MostRecentIter(&$backend, &$pages, $params) {
        $limit = false;
        extract($params);
        if ($exclude_major_revisions)
            $include_minor_revisions = true;

        $reverse = $limit < 0;
        if($reverse){$limit = -$limit;}
        $this->_revisions = array();
        while ($page = $pages->next()) {
            $revs = $backend->get_all_revisions($page['pagename']);
            while ($revision = $revs->next()) {
                $vdata = &$revision['versiondata'];
                if (!$vdata) continue;
                assert(is_array($vdata));
                if (empty($vdata['mtime'])) {
		    $vdata['mtime'] = 0;
		}
                if (!empty($vdata['is_minor_edit'])) {
                    if (!$include_minor_revisions)
                        continue;
                }
                else {
                    if ($exclude_major_revisions)
                        continue;
                }
                if (!empty($since) && $vdata['mtime'] < $since)
                    break;

                $this->_revisions[] = $revision;

                if (!$include_all_revisions)
                    break;
            }
            $revs->free();
        }
        if ($reverse) {
            usort($this->_revisions, 'WikiDB_backend_dumb_MostRecentIter_sortf_rev');
        } else {
            usort($this->_revisions, 'WikiDB_backend_dumb_MostRecentIter_sortf');
        }
        if (!empty($limit) && $limit < count($this->_revisions)) {
            array_splice($this->_revisions, $limit);
        }
    }
  
    function next() {
        return array_shift($this->_revisions);
    }
  
    function free() {
        unset($this->_revisions);
    }
}

function WikiDB_backend_dumb_MostRecentIter_sortf($a, $b) {
    $acreated = $a['versiondata']['mtime'];
    $bcreated = $b['versiondata']['mtime'];
    return $bcreated - $acreated;
}

function WikiDB_backend_dumb_MostRecentIter_sortf_rev($a, $b) {
    $acreated = $a['versiondata']['mtime'];
    $bcreated = $b['versiondata']['mtime'];
    return $acreated - $bcreated;
}

// Local Variables:
// mode: php
// tab-width: 8
// c-basic-offset: 4
// c-hanging-comment-ender-p: nil
// indent-tabs-mode: nil
// End: 
?>
