﻿<%@ Page PathInChannel="category/{ID}{Page}{Ext}" Object="GoodsCategory" %>
<%@ OutputCache Duration="7200" VaryByParam="none" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<ilghar:Get ID="GoodsCategory" Object="GoodsCategory" PageID="Request.QueryString['ID']" ForMeta="true" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="keywords" content="<%=MetaKeywords%>" />
<meta name="description" content="<%=MetaDescription%>" />
<title><%=GoodsCategory[Name]%> - <%=Channel[Name]%> - <%=Site[Name]%></title>
<ilghar:Comment><link rel="stylesheet" type="text/css" href="../S01/CHS/css/common.css" /></ilghar:Comment>
<link rel="stylesheet" type="text/css" href="<%=CssPath%>common.css" />
</head>
<body>
<%If String.IsNullOrEmpty(Site[Logo])%>
	<!-- TemplateBeginEditable name="广告位：Banner" -->
	<ilghar:Ad Guid="{099A2FEC-2278-4b03-BC08-A3C1FC3ADC66}">
		<a href="http://www.ilghar.cn"><img src="<%=ImagePath%>ad/banner.gif" alt="Ad" style="width:990px;height:150px" /></a>
	</ilghar:Ad>
	<!-- TemplateEndEditable -->
<%Else%>
	<div class="Header">
		<ul>
			<li class="Left"><img src="<%=Site[Logo]%>" alt="<%=Site[Name]%>" /></li>
			<li class="Right"><%=Site[Name]%></li>
		</ul>
	</div>
<%EndIf%>

<!-- TemplateBeginEditable name="主菜单" -->
<ilghar:Menu Condition="IsDisplay=true and CategoryID IS NULL and ParentID IS NULL">
	<div class="Menu">
		<div class="Left"></div>
		<div class="Middle">
			<ilghar:Record>
				<a href="<%=URL%>" target="<%=Target%>"><%=Name%></a>
				<ilghar:Separator> | </ilghar:Separator>
			</ilghar:Record>
		</div>
		<div class="Right"></div>
	</div>
</ilghar:Menu>
<!-- TemplateEndEditable -->

<div class="Wrap">
	<div class="Block1">
		<!-- TemplateBeginEditable name="产品分类" -->
		<ilghar:List Object="GoodsCategory" Condition="ParentID IS NULL">
			<h2>产品分类</h2>
			<ilghar:Record>
				<h3><a href="<%=BuildUrl()%>" title="<%=Name%>"><%=Name%></a></h3>
			</ilghar:Record>		
		</ilghar:List>			
		<!-- TemplateEndEditable -->

		<!-- TemplateBeginEditable name="最新产品" -->
		<ilghar:List Object="Goods" Page="1" PageSize="10" Condition="IsDeleted=false and IsReleased=true" Sort="UpdateTime DESC">
			<h1>最新产品</h1>
			<ul class="List3">
				<ilghar:Record>
					<li><a href="<%=BuildUrl()%>" title="<%=Name%>" target="_blank"><img src="<%=Thumbnail%>" alt="<%=Name%>" /></a><br />
						<a href="<%=BuildUrl()%>" title="<%=Name%>" target="_blank"><%=Name%></a>
					</li>
				</ilghar:Record>
			</ul>
		</ilghar:List>
		<!-- TemplateEndEditable -->

		<!-- TemplateBeginEditable name="友情连接" -->
		<ilghar:List Mark="System" Object="Link" Condition="IsChecked=true">
			<h1>友情连接</h1>
			<div class="Link">
				<ilghar:Record>
					<a href="<%=URL%>" title="<%=Name%>" target="_blank"><img src="<%=Logo%>" alt="<%=Name%>" /></a><br />
				</ilghar:Record>
			</div>
		</ilghar:List>
		<!-- TemplateEndEditable -->
	</div>
	<div class="Block2">
		<!-- TemplateBeginEditable name="路径" -->
		<div class="Path">
			你的位置：
			<ilghar:Path Object="GoodsCategory" Guid="GoodsCategory[ParentID]">
				<ilghar:Record>
					<a href="<%=URL%>"><%=Name%></a> &gt; 
				</ilghar:Record>
			</ilghar:Path>
			<%=GoodsCategory[Name]%>
		</div>
		<!-- TemplateEndEditable -->

		<!-- TemplateBeginEditable name="列表" -->
		<div class="Block5">
			<ilghar:List ID="List" Object="Goods" Page="PageNumber" PageSize="12" Condition="IsDeleted=false and IsReleased=true and IncludeSubCategory=GoodsCategory[ID]" Sort="UpdateTime DESC">
				<h2><%=GoodsCategory[Name]%></h2>
				<ul class="List2">
					<ilghar:Record>
						<li> <a href="<%=BuildUrl()%>" title="<%=Name%>" target="_blank"><img src="<%=Thumbnail%>" alt="<%=Name%>" /></a><br />
							<a href="<%=BuildUrl()%>" title="<%=Name%>" target="_blank"><%=Name%></a>
						</li>
					</ilghar:Record>
				</ul>
			</ilghar:List> 
		</div>
		<!-- TemplateEndEditable -->

		<!-- TemplateBeginEditable name="分页" -->
		<ilghar:Pagination ID="Pagination" Page="PageNumber" PageSize="12" RecordCount="List[RecordCount]">
			<div class="Pagination">
				<ilghar:FirstPage>
					<ilghar:Yes>
						<span class="Disabled"> &lt;&lt; </span>
						<span class="Disabled"> &lt; </span>
					</ilghar:Yes>
					<ilghar:No>
						<a href="<%=FirstPage%>"> &lt;&lt; </a>
						<a href="<%=PreviousPage%>"> &lt; </a>
					</ilghar:No>
				</ilghar:FirstPage>
				<ilghar:CurrentPage Range="5">
					<ilghar:Yes>
						<span class="Select"><%=Index%></span>
					</ilghar:Yes>
					<ilghar:No>
						<a href="<%=URL%>"><%=Index%></a>
					</ilghar:No>
				</ilghar:CurrentPage>
				<ilghar:LastPage>
					<ilghar:Yes>
						<span class="Disabled"> &gt;&gt; </span>
						<span class="Disabled"> &gt; </span>
					</ilghar:Yes>
					<ilghar:No>
						<a href="<%=NextPage%>"> &gt; </a>
						<a href="<%=LastPage%>"> &gt;&gt; </a>
					</ilghar:No>
				</ilghar:LastPage>
			</div>
		</ilghar:Pagination>
		<!-- TemplateEndEditable -->
	</div>
</div>

<!-- TemplateBeginEditable name="脚注" -->
<div class="Footer">
	<ilghar:Menu Condition="CategoryID={BAC035A8-F6BB-4772-8D51-A7F4F3AB7AD3}">
		<ilghar:Record>
			<a href="<%=URL%>" target="<%=Target%>" title="<%=Name%>"><%=Name%></a>
			<ilghar:Separator>|</ilghar:Separator>
		</ilghar:Record>
	</ilghar:Menu>
	<hr size="1" />

	<%=Footer%>
</div>
<!-- TemplateEndEditable -->

<script type="text/javascript" src="<%=CommonPath%>jquery/core.js"></script>
<script type="text/javascript" src="<%=CommonPath%>jquery/marquee.js"></script>
<script type="text/javascript" src="<%=JsPath%>common.js"></script>
<%=StatisticsCode%>
</body>
</html>
