﻿<%@ Page PathInChannel="product/{ID}{Ext}" Object="Goods" %>
<%@ OutputCache Duration="86400" VaryByParam="none" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<ilghar:Get ID="Goods" Object="Goods" PageID="Request.QueryString['ID']" ForMeta="true" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="keywords" content="<%=MetaKeywords%>" />
<meta name="description" content="<%=MetaDescription%>" />
<title><%=Goods[Name]%> - <%=Goods[CategoryName]%> - <%=Channel[Name]%> - <%=Site[Name]%></title>
<ilghar:Comment><link rel="stylesheet" type="text/css" href="../S01/CHS/css/common.css" /></ilghar:Comment>
<link rel="stylesheet" type="text/css" href="<%=CssPath%>common.css" />
<script type="text/javascript">
var _page = "goods";
var _webPath = "<%=WebPath%>";
var _id = "<%=Goods[InnerID]%>";
</script>
</head>
<body>
<%If String.IsNullOrEmpty(Site[Logo])%>
	<!-- TemplateBeginEditable name="广告位：Banner" -->
	<ilghar:Ad Guid="{099A2FEC-2278-4b03-BC08-A3C1FC3ADC66}">
		<a href="http://www.ilghar.cn"><img src="<%=ImagePath%>ad/banner.gif" alt="Ad" style="width:990px;height:150px" /></a>
	</ilghar:Ad>
	<!-- TemplateEndEditable -->
<%Else%>
	<div class="Header">
		<ul>
			<li class="Left"><img src="<%=Site[Logo]%>" alt="<%=Site[Name]%>" /></li>
			<li class="Right"><%=Site[Name]%></li>
		</ul>
	</div>
<%EndIf%>

<!-- TemplateBeginEditable name="主菜单" -->
<ilghar:Menu Condition="IsDisplay=true and CategoryID IS NULL and ParentID IS NULL">
	<div class="Menu">
		<div class="Left"></div>
		<div class="Middle">
			<ilghar:Record>
				<a href="<%=URL%>" target="<%=Target%>"><%=Name%></a>
				<ilghar:Separator> | </ilghar:Separator>
			</ilghar:Record>
		</div>
		<div class="Right"></div>
	</div>
</ilghar:Menu>
<!-- TemplateEndEditable -->

<div class="Wrap">
	<div class="Block1">
		<!-- TemplateBeginEditable name="产品分类" -->
		<ilghar:List Object="GoodsCategory" Condition="ParentID IS NULL">
			<h2>产品分类</h2>
			<ilghar:Record>
				<h3><a href="<%=BuildUrl()%>" title="<%=Name%>"><%=Name%></a></h3>
			</ilghar:Record>		
		</ilghar:List>			
		<!-- TemplateEndEditable -->

		<!-- TemplateBeginEditable name="最新产品" -->
		<ilghar:List Object="Goods" Page="1" PageSize="10" Condition="IsDeleted=false and IsReleased=true" Sort="UpdateTime DESC">
			<h1>最新产品</h1>
			<ul class="List3">
				<ilghar:Record>
					<li><a href="<%=BuildUrl()%>" title="<%=Name%>" target="_blank"><img src="<%=Thumbnail%>" alt="<%=Name%>" /></a><br />
						<a href="<%=BuildUrl()%>" title="<%=Name%>" target="_blank"><%=Name%></a>
					</li>
				</ilghar:Record>
			</ul>
		</ilghar:List>
		<!-- TemplateEndEditable -->

		<!-- TemplateBeginEditable name="友情连接" -->
		<ilghar:List Mark="System" Object="Link" Condition="IsChecked=true">
			<h1>友情连接</h1>
			<div class="Link">
				<ilghar:Record>
					<a href="<%=URL%>" title="<%=Name%>" target="_blank"><img src="<%=Logo%>" alt="<%=Name%>" /></a><br />
				</ilghar:Record>
			</div>
		</ilghar:List>
		<!-- TemplateEndEditable -->
	</div>
	<div class="Block2">
		<!-- TemplateBeginEditable name="路径" -->
		<div class="Path">
			你的位置：
			<ilghar:Path Object="GoodsCategory" Guid="Goods[CategoryID]">
				<ilghar:Record>
					<a href="<%=URL%>"><%=Name%></a> &gt; 
				</ilghar:Record>
			</ilghar:Path>
			查看产品
		</div>
		<!-- TemplateEndEditable -->

		<div class="Block5">
			<h2><%=Goods[Name]%></h2>
			<div class="Block10">
				<div class="Left">
					<img src="<%=Goods[Thumbnail]%>" alt="<%=Goods[Name]%>" /><br />
					<a href="<%=Goods[Picture]%>" title="<%=Goods[Name]%>" target="_blank">点击看大图</a>
				</div>
				<div class="Right">
					<h6><%=Goods[Name]%></h6>
					<table cellpadding="4" cellspacing="1">
						<tr>
							<th>市 场 价：</th>
							<td><%=Goods[MarketPrice]%>￥/<%=Goods[UnitName]%></td>
						</tr>
						<tr>
							<th>销 售 价：</th>
							<td><%=Goods[SalePrice]%>￥/<%=Goods[UnitName]%></td>
						</tr>
						<ilghar:List Object="Goods.Property" Condition="GoodsID=Goods[ID]">
							<ilghar:Record>
								<tr>
									<th><%=Name%>：</th>
									<td><%=Value%></td>
								</tr>
							</ilghar:Record>						
						</ilghar:List>
					</table>
				</div>
			</div>
			<h6>产品详细说明</h6>
			<div class="Block11"><%=Goods[Description]%></div>
		</div>
	</div>
</div>

<!-- TemplateBeginEditable name="脚注" -->
<div class="Footer">
	<ilghar:Menu Condition="CategoryID={BAC035A8-F6BB-4772-8D51-A7F4F3AB7AD3}">
		<ilghar:Record>
			<a href="<%=URL%>" target="<%=Target%>" title="<%=Name%>"><%=Name%></a>
			<ilghar:Separator>|</ilghar:Separator>
		</ilghar:Record>
	</ilghar:Menu>
	<hr size="1" />

	<%=Footer%>
</div>
<!-- TemplateEndEditable -->

<script type="text/javascript" src="<%=CommonPath%>jquery/core.js"></script>
<script type="text/javascript" src="<%=CommonPath%>jquery/marquee.js"></script>
<script type="text/javascript" src="<%=JsPath%>common.js"></script>
<%=StatisticsCode%>
</body>
</html>
