﻿function BuildHeader()
{
	if (_page == "brand_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Page=" + _pageNumber;
	else if (_page == "comment_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&IsChecked=" + $("#IsChecked").val() + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "delivery_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Page=" + _pageNumber;
	else if (_page == "order_file")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "order_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&State=" + $("#State").val() + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "order_select_goods")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&CategoryID=" + $("#CategoryID").val() + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "order_select_member")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "payment_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Page=" + _pageNumber;
	else if (_page == "refund_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Page=" + _pageNumber;
	else if (_page == "return_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Page=" + _pageNumber;
	else if (_page == "spec_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Page=" + _pageNumber;
	else if (_page == "spec_select")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "tag_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "tag_select")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "type_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Page=" + _pageNumber;
	else if (_page == "goods_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&IsRecycled=" + $("#IsRecycled").val() + "&IsReleased=" + $("#IsReleased").val() + "&IsHeld=" + $("#IsHeld").val() + "&IsRecommended=" + $("#IsRecommended").val() + "&CategoryID=" + $("#CategoryID").val() + "&IncludeSubCategory=" + $("#IncludeSubCategory")[0].checked + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&ListByPicture=" + $("#ListByPicture")[0].checked + "&Page=" + _pageNumber;
	else if (_page == "goods_select")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&CategoryID=" + $("#CategoryID").val() + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "goods_select_part")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&CategoryID=" + $("#CategoryID").val() + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "goods_category_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&IsDisplay=" + $("#IsDisplay").val() + "&IsRecommended=" + $("#IsRecommended").val() + "&IsHeld=" + $("#IsHeld").val() + "&Sort=" + $("#Sort").val();
	else
	    return BuildAjaxPath();
}

function Search()
{
	if (arguments.length > 0 && typeof(arguments[0]) != "object")
		_pageNumber = arguments[0];
	
	SetStatusMessage(_lang_working);
	$.ajax(
	{
		url : BuildHeader(),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
		    if (_page == "comment_list")
			    $("#RecordList").html(HandleFake404(data, "text"));
			else
			    $("#List").html(HandleFake404(data, "text"));
			Init();
			SetStatusMessage();

			if (typeof(SetupIme) == "function")
				SetupIme();
			
			if (_page == "goods_list")
			{
		        var action = "";
		        if ($("#IsRecommended")[0].selectedIndex == 2 && ($("#Sort").val() == "5" || $("#Sort").val() == "6"))
			        action = "MoveRecommend";
		        else if ($("#IsHeld")[0].selectedIndex == 2 && ($("#Sort").val() == "7" || $("#Sort").val() == "8"))
			        action = "MoveHold";
		        if (action != "")
			        g_action = action;
			}
		}
	});
}

function MakeButton()
{
	var buttons = "";
	
	if (_page == "comment_list")
	{	
		if ($("#IsChecked")[0].selectedIndex == 1)
			buttons += "<button class=\"Button\" onclick=\"UpdateComment('Check')\" >" + _lang_check + "</button>";
		else if ($("#IsChecked")[0].selectedIndex == 2)
			buttons += "<button class=\"Button\" onclick=\"UpdateComment('UnCheck')\" >" + _lang_uncheck + "</button>";
	}
	else if (_page == "goods_list")
	{
	    //回收
	    var obj = $("#IsRecycled")[0];
	    if (obj.selectedIndex == 1)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateGoods('Recycle')\" >" + _lang_recycle + "</button>";
	    }
	    else if (obj.selectedIndex == 2)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateGoods('Delete')\" >" + _lang_delete + "</button>";
		    buttons += "<button class=\"Button\" onclick=\"UpdateGoods('Recover')\" >" + _lang_recover + "</button>";
	    }
    	
	    //发布
	    var obj = $("#IsReleased")[0];
	    if (obj.selectedIndex == 1)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateGoods('Release')\" >" + _lang_release + "<</button>";
	    }
	    else if (obj.selectedIndex == 2)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateGoods('UnRelease')\" >" + _lang_unrelease + "</button>";
	    }
    	
	    //置顶
	    var obj = $("#IsHeld")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateGoods('Hold')\" >" + _lang_hold + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateGoods('UnHold')\" >" + _lang_unhold + "</button>";
    	
	    //推荐
	    var obj = $("#IsRecommended")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateGoods('Recommend')\" >" + _lang_recommend + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateGoods('UnRecommend')\" >" + _lang_unrecommend + "</button>";
	}
	else if (_page == "goods_category_list")
	{
	    //显示
	    var obj = $("#IsDisplay")[0];
	    if (obj.selectedIndex == 1)
	        buttons += "<button class=\"Button\" onclick=\"UpdateGoodsCategory('Display')\" >" + _lang_display + "</button>";
	    else if (obj.selectedIndex == 2)
	        buttons += "<button class=\"Button\" onclick=\"UpdateGoodsCategory('UnDisplay')\" >" + _lang_undisplay + "</button>";

	    //置顶
	    var obj = $("#IsHeld")[0];
	    if (obj.selectedIndex == 1)
	        buttons += "<button class=\"Button\" onclick=\"UpdateGoodsCategory('Hold')\" >" + _lang_hold + "</button>";
	    else if (obj.selectedIndex == 2)
	        buttons += "<button class=\"Button\" onclick=\"UpdateGoodsCategory('UnHold')\" >" + _lang_unhold + "</button>";

	    //推荐
	    var obj = $("#IsRecommended")[0];
	    if (obj.selectedIndex == 1)
	        buttons += "<button class=\"Button\" onclick=\"UpdateGoodsCategory('Recommend')\" >" + _lang_recommend + "</button>";
	    else if (obj.selectedIndex == 2)
	        buttons += "<button class=\"Button\" onclick=\"UpdateGoodsCategory('UnRecommend')\" >" + _lang_unrecommend + "</button>";
	}
		
	$("#ExtraButton").html(buttons);
}

function ShowSelectDialog(type)
{
	var path;
	if (type == "Member")
		path = "select_member.aspx?Lang=" + _lang;
	else if (type == "Goods")
		path = "select_goods.aspx?Lang=" + _lang;
	else if (type == "Tag")
		path = "../tag/select.aspx?Lang=" + _lang;
	else if (type == "RelatedGoods")
		path = "select.aspx?Lang=" + _lang;
	else if (type == "Spec")
		path = "../spec/select.aspx?Lang=" + _lang;
	else if (type == "Part")
		path = "select_part.aspx?Lang=" + _lang + (_page == "goods_part" ? "&Single=True" : "");
	else if (type == "SpecMemberPrice")
	{
	    if (_page == "goods_spec_edit")
    		path = "spec_member_price.aspx?Lang=" + _lang + "&Index=" + (_memberPrice == null ? "0&ID=" + _guid : "1") + "&Price=" + (_promote ? document.forms[0].PromotePrice.value : document.forms[0].Price.value);
    	else if (_page == "goods_spec")
    		path = "spec_member_price.aspx?Lang=" + _lang + "&Index=" + (_memberPrice == null ? "0" : "1") + "&Price=" + (_promote ? document.forms[0].PromotePrice.value : document.forms[0].Price.value);
    	else
		    path = "spec_member_price.aspx?Lang=" + _lang + "&Index=" + arguments[1] + "&Price=" + ($("#Promote")[0].checked ? arguments[3] : arguments[2]);
	}

	path = HandleFake404(path, "url");
	if ($.browser.msie)
		window.showModalDialog(path, window, "status=0;dialogWidth=500px;dialogHeight=500px;center=1;help=0;resizable=1;scroll=1");
	else
		window.open(path,null,"width=500,height=500,dialog=yes,modal=yes,maximize=no,menubar=no,toolbar=no,location=no,scrollbars=yes,status=no");
}

function SelectFile(type, path)
{
	var form = document.forms[0];
	switch (type)
	{
		case "Picture":
			form.Picture.value = path;
			$("#PictureView").attr("src", path);
			break;
		case "Thumbnail":
			form.Thumbnail.value = path;
			$("#ThumbnailView").attr("src", path);
			break;
		case "File":
			form.File.value = path;
			break;
		default:
			if (_page == "goods_add")
				eval("form." + type).value = path;
			else
				$("#File" + type).value = path;
			break;
	}	
}

function ShowSelectFileDialog(type)
{
	var path = _adminPath + "IlgharCMS.SystemModule/file_manager/select.aspx?Lang=" + _lang + "&Type=" + type + "&ListByPicture=";
	switch (type)
	{
		case "Thumbnail":
			path += "true&Root=" + _thumbnailRoot;
			break;
		case "File":
			path += "false&Root=" + _fileRoot;
			break;
		default:
			if (_page == "goods_add" || _page == "goods_edit" || _page == "goods_pictures")
				path += "true&Root=" + _pictureRoot;
			else
				path += "true&Root=" + _root;
			break;
	}
	
	path = HandleFake404(path, "url");
	if ($.browser.msie)
		window.showModalDialog(path, window, "status=0;dialogWidth=900px;dialogHeight=600px;center=1;help=0;resizable=1;scroll=0");
	else
		window.open(path,null,"width=900,height=600,menubar=no,toolbar=no,location=no,scrollbars=yes,status=no,modal=yes");
}

function PrepareTag()
{
    var result = {Names:"",PageIDs:"",PageGenerates:"",PageTemplates:"",PageExtensions:""};	
    var tags = $("[name=Tag]");
	
	if (typeof(_tagIndex) != "undefined")
	{
	    _tagIndex = 0;
	}
	else
	{
	    _tagAddIndex = 0;
	    _tagDeleteIndex = 0;
	    _tagAddList.length = 0;
	    _tagDeleteList.length = 0;
    	    	
	    tags.each(function()
	    {
		    if (this.checked)
		    {
			    var j = 0;
			    for (; j < _tags.length; j++)
			    {
				    if (this.id == _tags[j] || this.id == _tags[j].ID)
					    break;
			    }
			    if (j >= _tags.length)
				    _tagAddList[_tagAddList.length] = this.id;
		    }
		    else
		    {
			    for (var j = 0; j < _tags.length; j++)
			    {
				    if (this.id == _tags[j] || this.id == _tags[j].ID)
				    {
					    _tagDeleteList[_tagDeleteList.length] = this.id;
					    break;
				    }
			    }
		    }
	    });
	}

	_tags.length = 0;
	tags.each(function()
	{
		if (!this.checked)
		    return false;

		_tags[_tags.length] = this.id;

		if (result.Names == "")
			result.Names = "|";
		result.Names += this.value + "|";
		
		if (result.PageGenerates == "")
			result.PageGenerates = "|";
		result.PageGenerates += $(this).attr("PageGenerate") + "|";
		
		if (result.PageTemplates == "")
			result.PageTemplates = "|";
		result.PageTemplates += $(this).attr("PageTemplate") + "|";
		
		if (result.PageIDs == "")
			result.PageIDs = "|";
		result.PageIDs += $(this).attr("PageID") + "|";
		
		if (result.PageExtensions == "")
			result.PageExtensions = "|";
		result.PageExtensions += $(this).attr("PageExtension") + "|";
	});
	
	return result;
}

//-------------------------------------------------
//Start : 品牌管理
function AddBrand()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Logo.value, this.LogoAllowedType.value))
	{
		Alert(_lang_type_must_be + this.LogoAllowedType.value, function(){this.Logo.select();}, this);
		return false;
	}
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";

	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&URL=" + encodeURIComponent(this.URL.value);
	data += "&Description=" + encodeURIComponent(this.Description.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	_uploadLogo = _uploader.NeedUpload("Logo");
	if (!_uploadLogo)
		data += "&Logo=" + encodeURIComponent(this.Logo.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Brand&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    _guid = data;
	        AddBrand_GetInnerID();
		}
	});
	
	return false;
}

function AddBrand_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Brand&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
            _id = data;
			AddBrand_SetPageID();
		}
	});
}

function AddBrand_SetPageID()
{
    _pageID = _pageID.replace(/\{ID\}/g, _id);
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
    
    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Brand&Operation=Modify&ID=" + _id,
		data : "PageID=" + _pageID,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Brand_UploadLogo();
		}
	});
}

function EditBrand()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Logo.value, this.LogoAllowedType.value))
	{
		Alert(_lang_type_must_be + this.LogoAllowedType.value, function(){this.Logo.select();}, this);
		return false;
	}
	
	if (this.PageID.value == "")
	{
		Alert(_lang_pageid_empty, function(){this.PageID.select();}, this);
		return false;
	}
	
	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)

	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&URL=" + encodeURIComponent(this.URL.value);
	data += "&Description=" + encodeURIComponent(this.Description.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(pageID);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	_uploadLogo = _uploader.NeedUpload("Logo");
	if (!_uploadLogo)
		data += "&Logo=" + encodeURIComponent(this.Logo.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Brand&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Brand_UploadLogo();
		}
	});
	
	return false;	
}

function Brand_UploadLogo()
{
    if (!_uploadLogo)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
        return;
    }

    SetStatusMessage(_lang_start_upload);
    _uploader.Init({Status:_lang_uploading,Params:"Lang=" + _lang + "&Object=Brand&Operation=UploadLogo&ID=" + _id + "&AddWaterMark=" + $("#AddWaterMark")[0].checked});
    _uploader.Upload("Logo", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function DeleteBrand(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Brand&Operation=Delete&ID=" + id + "&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			Init();
		}
	});
}
//End : 品牌管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 评论管理
function EditComment()
{
	var data = "Content=" + encodeURIComponent(this.Content.value);
	data += "&UpdateTime=" + FormatDate(new Date());

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Comment&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function UpdateComment(action, id)
{
	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdateComment(action, id);}, this);
		else
			UpdateComment(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Comment&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#RecordList").html(HandleFake404(data, "text"));				
			}
		});
	}
}	

//End : 评论管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 栏目设置
function SetBasicSettings()
{
	if (this.GoodsThumbnailFolder.value.length > 0 && this.GoodsThumbnailFolder.value.indexOf("/") != 0)
	{
		Alert(_lang_goods_thumbnail_folder_starts_slash, function(){this.GoodsThumbnailFolder.select();}, this);
		return false;
	}
	
	if (this.GoodsPictureFolder.value.length > 0 && this.GoodsPictureFolder.value.indexOf("/") != 0)
	{
		Alert(_lang_goods_picture_folder_starts_slash, function(){this.GoodsPictureFolder.select();}, this);
		return false;
	}
	
	if (this.FileFolder.value.length > 0 && this.FileFolder.value.indexOf("/") != 0)
	{
		Alert(_lang_file_folder_starts_slash, function(){this.FileFolder.select();}, this);
		return false;
	}
	
	if (this.TempFileFolder.value.length > 0 && this.TempFileFolder.value.indexOf("/") != 0)
	{
		Alert(_lang_file_temp_folder_starts_slash, function(){this.TempFileFolder.select();}, this);
		return false;
	}
	
	if (!this.GoodsThumbnailWidth.value.match(/^\d*$/))
	{
		Alert(_lang_goods_thumbnail_width_incorrect, function(){this.GoodsThumbnailWidth.select();}, this);
		return false;
	}	
	
	if (!this.GoodsThumbnailHeight.value.match(/^\d*$/))
	{
		Alert(_lang_goods_thumbnail_height_incorrect, function(){this.GoodsThumbnailHeight.select();}, this);
		return false;
	}	
	
	if (!IsAllowedType(this.GoodsDefaultThumbnail.value, this.GoodsDefaultThumbnailAllowedType.value))
	{
		Alert(_lang_type_must_be + this.GoodsDefaultThumbnailAllowedType.value, function(){this.GoodsDefaultThumbnail.select();}, this);
		return false;
	}
	
	if (!this.TaxRate.value.match(/^\d+(\.\d+)?$/))
	{
		Alert(_lang_tax_rate_incorrect, function(){this.TaxRate.select();}, this);
		return false;
	}
	
	var data = "GoodsThumbnailFolder=" +  encodeURIComponent(this.GoodsThumbnailFolder.value);
	data += "&GoodsPictureFolder=" +  encodeURIComponent(this.GoodsPictureFolder.value);
	data += "&FileFolder=" +  encodeURIComponent(this.FileFolder.value);
	data += "&TempFileFolder=" +  encodeURIComponent(this.TempFileFolder.value);
	data += "&GoodsThumbnailWidth=" + this.GoodsThumbnailWidth.value;
	data += "&GoodsThumbnailHeight=" + this.GoodsThumbnailHeight.value;
	data += "&TaxRate=" + this.TaxRate.value;
	data += "&EnableComment=" + this.EnableComment.checked;
	data += "&CheckComment=" + this.CheckComment.checked;
	_uploadGoodsDefaultThumbnail = _uploader.NeedUpload("Goods");
	if (!_uploadGoodsDefaultThumbnail)
		data += "&GoodsDefaultThumbnail=" + encodeURIComponent(this.GoodsDefaultThumbnail.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=InstanceConfig&Operation=SetBasicSettings",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    SetBasicSettings_UploadGoodsDefaultThumbnail();
		}
	});
	
	return false;	
}

function SetBasicSettings_UploadGoodsDefaultThumbnail()
{
    if (!_uploadGoodsDefaultThumbnail)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
        return;
    }

    SetStatusMessage(_lang_start_upload);
    _uploader.Init({Status:_lang_uploading,Params:"Lang=" + _lang + "&Object=InstanceConfig&Operation=UploadGoodsDefaultThumbnail"});
    _uploader.Upload("Goods", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function CreateAllGoodsThumbnail()
{
    var me = $(this);
	me.attr("disabled", true);
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Goods&Operation=CreateAllThumbnail",
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			me.attr("disabled", false);
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			me.attr("disabled", false);
		}
	});
	
	return false;	
}

function SetDiscount(form, id)
{
	if (form.Amount.value.match(/^\d+$/) == null || parseInt(form.Amount.value) < 1 || parseInt(form.Amount.value) > 100)
	{
		Alert(_lang_discount_incorrect);
		return;
	}
	
	var data = "RoleInnerID=" + id;
	data += "&Amount=" + form.Amount.value;
	
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Discount&Operation=Set",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
		}
	});
}
//End : 栏目设置
//-------------------------------------------------

//-------------------------------------------------
//Start : 发货单
function DeleteDelivery(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Delivery&Operation=Delete&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			Init();
		}
	});
}
//End : 发货单
//-------------------------------------------------

//-------------------------------------------------
//Start : 类别管理
function UpdateGoodsCategory(action, id)
{
    if (id == null)
    {
        id = "";
        $("[name=Sel]:checked").each(function () { id += id == "" ? this.value : "|" + this.value; });
        if (id == "")
        {
            Alert(_lang_selection_empty);
            return;
        }

        if (action == "Delete")
            Confirm(_lang_confirm_delete, function (returnValue) { if (returnValue) UpdateGoodsCategory(action, id); }, this);
        else
            UpdateGoodsCategory(action, id);
    }
    else
    {
        SetStatusMessage(_lang_working);

        $.ajax(
		{
		    url: _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=GoodsCategory&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
		    data: {},
		    type: "POST",
		    error: function (request)
		    {
		        Alert(_lang_operation_fail);
		        SetStatusMessage();
		    },
		    success: function (data)
		    {
		        Alert(_lang_operation_success);
		        SetStatusMessage();

		        $("#List").html(HandleFake404(data, "text"));
		        Init();
		    }
		});
    }
}

function AddGoodsCategory()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_type_must_be + this.PictureAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";

	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&ParentID=" + encodeURIComponent(this.ParentID.value);
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	data += "&IsHeld=" + $("#IsHeldYes")[0].checked;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=GoodsCategory&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    _guid = data;
	        AddGoodsCategory_GetInnerID();
		}
	});
	
	return false;	
}

function AddGoodsCategory_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=GoodsCategory&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
            _id = data;
			AddGoodsCategory_SetPageID();
		}
	});
}

function AddGoodsCategory_SetPageID()
{
    _pageID = _pageID.replace(/\{ID\}/g, _id);
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
    
    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=GoodsCategory&Operation=Modify&ID=" + _id,
		data : "PageID=" + _pageID,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			GoodsCategory_UploadPicture();
		}
	});
}

function EditGoodsCategory()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_type_must_be + this.PictureAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (this.PageID.value == "")
	{
		Alert(_lang_pageid_empty, function(){this.PageID.select();}, this);
		return false;
	}
	
	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&ParentID=" + encodeURIComponent(this.ParentID.value);
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(pageID);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if (_recommend == 0 || !$("#IsRecommendedYes")[0].checked)
		data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	if (_hold == 0 || !$("#IsHeldYes")[0].checked)
		data += "&IsHeld=" + $("#IsHeldYes")[0].checked;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=GoodsCategory&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    GoodsCategory_UploadPicture();
		}
	});
	
	return false;
}

function GoodsCategory_UploadPicture()
{
    if (!_uploadPicture)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
        return;
    }

    SetStatusMessage(_lang_start_upload);
    _uploader.Init({Status:_lang_uploading,Params:"Lang=" + _lang + "&Object=GoodsCategory&Operation=UploadPicture&ID=" + _id + "&AddWaterMark=" + $("#AddWaterMark")[0].checked});
    _uploader.Upload("Picture", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function ModifyGoodsCategory(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return;
	}
	
	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=GoodsCategory&Operation=Modify&ID=" + id,
		data : "Name=" + encodeURIComponent(form.Name.value),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}
	});
}

function DeleteGoodsCategory(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=GoodsCategory&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			ClientDelete(id);
		}
	});
}

function MoveGoodsCategory(from, to)
{
	if (from == to)
		return;
	
	var action = "Move";
	var sort = $("#Sort").val();
	if (sort == "2" || sort == "3")
	    action = "MoveRecommend";
	else if (sort == "4" || sort == "5")
	    action = "MoveHold";

	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=GoodsCategory&Operation=" + action + "&From=" + from + "&To=" + to,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			ClientMove(from, to, _imagePath);
		}
	});
}
//End : 类别管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 订单管理
function ComputeDeliveryFee(fee, price, weight)
{
	var re = new RegExp("^[\]\[\}\{\)\(0-9WwPp\+\-\/\*]+$");
	if (!re.test(fee))
	{
		Alert(_lang_expression_has_illegal_char);
		return 0;
	}
	
	var str = fee;
	str = str.replace(/(\[)/g, "GetCeil(");
	str = str.replace(/(\])/g, ")");
	str = str.replace(/(\{)/g, "GetVal(");
	str = str.replace(/(\})/g, ")");
	str = str.replace(/(W)/g, weight);
	str = str.replace(/(w)/g, weight);
	str = str.replace(/(P)/g, price);
	str = str.replace(/(p)/g, price);
	try
	{
		return eval(str);
	}
	catch(e)
	{
		Alert(fee + _lang_expression_incorrect);
		return 0;
	}	
}

function OrderAdd_Compute()
{
	var deliveryFee = 0;
	var protectRate = 0;
	var protectMin = 0;
	var paymentRate = 0;
	var priceAdjustment = 0;
	_weight = 0;
	_price = 0;
	
	var form = document.forms[0];
	
	var option = $("[name=DeliveryID] option:selected");
	if (option.attr("isProtect").toLowerCase() == "true")
	{
		protectRate = parseFloat(option.attr("protectRate"));
		protectMin = parseFloat(option.attr("protectMin"));
	}
	
	paymentRate = parseFloat($("[name=PaymentID] option:selected").attr("rate"));
	
	if (!form.PriceAdjustment.value.match(/^-?\d+(\.\d{1,3})?$/))
	{
		Alert(_lang_price_adjustment_incorrect);
		return;
	}
	priceAdjustment = parseFloat(form.PriceAdjustment.value);
	
	var detailTableRows = $("#DetailTable tr");
	if (detailTableRows.length == 2)
	{
		$("#DeliveryFeeTD").html("0");
		$("#SumTD").html("0");
		return;
	}
	
	for (var i = 2; i < detailTableRows.length; i++)
	{
		var row = detailTableRows.eq(i);
		
		_weight += parseFloat(row.attr("weight")) * parseFloat(row.attr("amount"));
		_price += parseFloat(row.attr("price")) * parseFloat(row.attr("amount"));
	}
	
	deliveryFee = ComputeDeliveryFee(option.attr("fee"), _price, _weight);
	var freight = 0;
	if (option.attr("isProtect").toLowerCase() == "true" && $("#DeliveryProtectYes")[0].checked)
		freight = deliveryFee + _price * protectRate / 100 + protectMin;
	else
		freight = deliveryFee;
	var beforeTax = _price + freight;
	var afterTax = beforeTax;
	if ($("#NeedInvoiceYes")[0].checked)
		afterTax = beforeTax + beforeTax * _taxRate / 100;
	var sum = afterTax + afterTax * paymentRate / 100 + priceAdjustment;
		
	$("#DeliveryFeeTD").html(deliveryFee);
	$("#SumTD").html(sum.toFixed(2));
}

function OrderEdit_Compute()
{
	var deliveryFee = 0;
	var protectRate = 0;
	var protectMin = 0;
	var paymentRate = 0;
	var priceAdjustment = 0;
	
	var form = document.forms[0];
	
	var option = $("[name=DeliveryID] option:selected");
	if (option.attr("isProtect").toLowerCase() == "true")
	{
		protectRate = parseFloat(option.attr("protectRate"));
		protectMin = parseFloat(option.attr("protectMin"));
	}
	
	paymentRate = parseFloat($("[name=PaymentID] option:selected").attr("rate"));
	
	if (!form.PriceAdjustment.value.match(/^-?\d+(\.\d{1,3})?$/))
	{
		Alert(_lang_price_adjustment_incorrect);
		return;
	}
	priceAdjustment = parseFloat(form.PriceAdjustment.value);
	
	deliveryFee = ComputeDeliveryFee(option.attr("fee"), _price, _weight);
	var freight = 0;
	if (option.attr("isProtect").toLowerCase() == "true" && $("#DeliveryProtectYes")[0].checked)
		freight = deliveryFee + _price * protectRate / 100 + protectMin;
	else
		freight = deliveryFee;
	var beforeTax = _price + freight;
	var afterTax = beforeTax;
	if ($("#NeedInvoiceYes")[0].checked)
		afterTax = beforeTax + beforeTax * _taxRate / 100;
	var sum = afterTax + afterTax * paymentRate / 100 + priceAdjustment;

	$("#DeliveryFeeTD").html(deliveryFee);
	$("#SumTD").html(sum.toFixed(2));
}

function OrderDetail_Compute()
{
	var deliveryFeeOrginal = _deliveryFeeOrginal;
	var deliveryProtect = _deliveryProtect;
	var protectRate = _protectRate;
	var protectMin = _protectMin;
	var paymentRate = _paymentRate;
	var taxRate = _taxRate;
	var needInvoice = _needInvoice;
	var priceAdjustment = 0;
	_weight = 0;
	_price = 0;
	
	var detailTableRows = $("#DetailTable tr");
	if (detailTableRows.length == 1)
	{
		_sum = "0";
		return;
	}
	
	for (var i = 1; i < detailTableRows.length; i++)
	{
		var row = detailTableRows[i];
		
		var amount = parseFloat(row.cells[5].childNodes[0].value);
		_weight += parseFloat(row.cells[3].innerHTML) * amount;
		_price += parseFloat(row.cells[4].innerHTML) * amount;
	}
	
	deliveryFee = ComputeDeliveryFee(deliveryFeeOrginal, _price, _weight);
	var freight = 0;
	if (deliveryProtect)
		freight = deliveryFee + _price * protectRate / 100 + protectMin;
	else
		freight = deliveryFee;
	var beforeTax = _price + freight;
	var afterTax = beforeTax;
	if (needInvoice)
		afterTax = beforeTax + beforeTax * taxRate / 100;
	_sum = (afterTax + afterTax * paymentRate / 100 + priceAdjustment).toFixed(2);
}

function OrderAdd_AddGoods()
{
	var form = document.forms[0];
	
	var table = $("#DetailTable")[0];
	var row1 = $(table.rows[1]);
	for (var i = 2; i < table.rows.length; i++)
	{
		if (table.rows[i].goodsID == row1.attr("goodsID") && table.rows[i].goodsSpecID == row1.attr("goodsSpecID"))
		{
			Alert(_lang_goods_exists);
			return;
		}
	}
	
	if (!form.Amount.value.match(/^[1-9]\d*$/))
	{
		Alert(_lang_amount_incorrect, function(){form.Amount.select();}, this);
		return;
	}
	
	if (typeof(row1[0].goodsID) == "undefined")
	{
		Alert(_lang_select_goods);
		return;
	}
	
	var row = $(table.insertRow(-1));
	row.attr("goodsID", row1.attr("goodsID"));
	row.attr("goodsSpecID", row1.attr("goodsSpecID"));
	row.attr("number", row1.attr("number"));
	row.attr("name", row1.attr("name"));
	row.attr("kind", row1.attr("kind"));
	row.attr("kindName", row1.attr("kindName"));
	row.attr("serviceCount", row1.attr("serviceCount"));
	row.attr("serviceDuration", row1.attr("serviceDuration"));
	row.attr("weight", row1.attr("weight"));
	row.attr("weightName", row1.attr("weightName"));
	row.attr("price", row1.attr("price"));
	row.attr("amount", form.Amount.value);
	
	var cell = $(row[0].insertCell(-1));
	cell.html(row.attr("number"));
	cell = $(row[0].insertCell(-1));
	cell.html(row.attr("name"));
	cell = $(row[0].insertCell(-1));
	cell.html(row.attr("kindName"));
	cell = $(row[0].insertCell(-1));
	cell.html(row.attr("weightName"));
	cell = $(row[0].insertCell(-1));
	cell.html(row.attr("price"));
	cell = $(row[0].insertCell(-1));
	cell.html(form.Amount.value);
	cell = $(row[0].insertCell(-1));
	cell.html("<input type=\"button\" value=\"" + _lang_delete + "\" onclick=\"OrderAdd_DeleteGoods(this)\" /> ");
	
	OrderAdd_Compute();
}

function OrderAdd_DeleteGoods(input)
{
	$("#DetailTable")[0].deleteRow(input.parentNode.parentNode.rowIndex);
	OrderAdd_Compute();
}

function PaymentID_OnChange()
{
	var form = document.forms[0];
	var option = form.PaymentID.options[form.PaymentID.selectedIndex];
	$("#PaymentRateTD").html(option.rate + "%");
	
	if (_page == "order_add")
		OrderAdd_Compute();
	else
		OrderEdit_Compute();
}

function DeliveryID_OnChange()
{
	var form = document.forms[0];
	var option = form.DeliveryID.options[form.DeliveryID.selectedIndex];
	if (option.isProtect.toLowerCase() == "true")
	{
		$("#ProtectTR").css("display", "");
		
		if ($("#DeliveryProtectYes")[0].checked)
		{
			$("#ProtectRateTR").css("display", "");
			$("#ProtectMinTR").css("display", "");
		}
		else
		{
			$("#ProtectRateTR").css("display", "none");
			$("#ProtectMinTR").css("display", "none");
		}
		
		$("#ProtectRateTD").html(option.protectRate + "%");
		$("#ProtectMinTD").html(option.protectMin);
	}
	else
	{
		$("#ProtectTR").css("display", "none");
	}
	
	if (_page == "order_add")
		OrderAdd_Compute();
	else
		OrderEdit_Compute();
}

function DeliveryProtect_OnClick()
{
	if ($("#DeliveryProtectYes")[0].checked)
	{
		$("#ProtectRateTR").css("display", "");
		$("#ProtectMinTR").css("display", "");
	}
	else
	{
		$("#ProtectRateTR").css("display", "none");
		$("#ProtectMinTR").css("display", "none");
	}
	
	if (_page == "order_add")
		OrderAdd_Compute();
	else
		OrderEdit_Compute();
}

function RegionID_OnChange()
{
	var form = document.forms[0];
	if (form.RegionID.selectedIndex == 0)
	{
		form.DeliveryID.length = 1;
	}
	else
	{
		SetStatusMessage(_lang_working);
	
		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Mark=System&Object=Delivery.Region&Operation=List&Condition=" + encodeURIComponent(IlgharCMS.SystemModule.Delivery_Region.RegionID + "=" + form.RegionID.value),
			type : "GET",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				form.DeliveryID.length = 1;
				
				var xmlDoc = CreateXmlDom();
				xmlDoc.loadXML(data);
				var itemList = xmlDoc.documentElement.childNodes;
				for (var i = 0; i < itemList.length; i++)
				{
					if (typeof (itemList[i].selectSingleNode) == "undefined")
						continue;
						
					var id = itemList[i].selectSingleNode(IlgharCMS.SystemModule.Delivery_Region.DeliveryID).text;
					var name = itemList[i].selectSingleNode(IlgharCMS.SystemModule.Delivery_Region.DeliveryName).text;
					var fee = itemList[i].selectSingleNode(IlgharCMS.SystemModule.Delivery_Region.Fee).text;
					var isProtect = itemList[i].selectSingleNode(IlgharCMS.SystemModule.Delivery_Region.IsProtect).text;
					var protectRate = itemList[i].selectSingleNode(IlgharCMS.SystemModule.Delivery_Region.ProtectRate).text;
					var protectMin = itemList[i].selectSingleNode(IlgharCMS.SystemModule.Delivery_Region.ProtectMin).text;
					
					var option = new Option(name, id);
					option.setAttribute("fee", fee);
					option.setAttribute("isProtect", isProtect);
					if (isProtect.toLowerCase() == "true")
					{
						option.setAttribute("protectRate", protectRate);
						option.setAttribute("protectMin", protectMin);
					}
					else
					{
						option.setAttribute("protectRate", "0");
						option.setAttribute("protectMin", "0");
					}
					form.DeliveryID.options.add(option);
				}
				
				SetStatusMessage();
			}
		});
	}
	
	if (_page == "order_add")
		OrderAdd_Compute();
	else
		OrderEdit_Compute();
}

function SelectGoods(control)
{
	var form = document.forms[0];

	if (_page == "order_add")
	{
		var table = $("#DetailTable")[0];
		var kindName;
		var row = table.rows[1];
		$(row.cells[0]).html(control.number);
		$(row.cells[1]).html(control.name);
		switch (control.kind)
		{
			case "Physical":
			    kindName = _lang_physical;
				$(row.cells[2]).html(kindName);
				form.Amount.disabled = false;
				break;
			case "Card":
			    kindName = _lang_card;
				$(row.cells[2]).html(kindName);
				form.Amount.disabled = false;
				break;
			case "File":
			    kindName = _lang_file;
				$(row.cells[2]).html(_lang_file);
				form.Amount.value = 1;
				form.Amount.disabled = true;
				break;
		}
		var weightName = parseInt(control.weight) / 1000 + "kg";
		$(row.cells[3]).html(weightName);
		$(row.cells[4]).html(control.price);
		
		row = $(row);
		row.attr("goodsID", control.goodsID);
		row.attr("goodsSpecID", control.goodsSpecID);
		row.attr("number", control.number);
		row.attr("name", control.name);
		row.attr("kind", control.kind);
		row.attr("kindName", kindName);
		row.attr("serviceCount", control.serviceCount);
		row.attr("serviceDuration", control.serviceDuration);
		row.attr("weight", control.weight);
		row.attr("weightName", weightName);
		row.attr("price", control.price);
	}
	else if (_page == "order_detail")
	{
		form.GoodsID.value = control.goodsID;
		form.GoodsSpecID.value = control.goodsSpecID;
		form.Number.value = control.number;
		form.Name.value = control.name;
		form.Kind.value = control.kind;
		form.Weight.value = control.weight;
		form.Price.value = control.price;
	}
}

function SelectMember(id, name)
{
	var member = $("#Member");
	member.html(name);
	member.attr("memberID", id);
	member.attr("member", name);
}

function AddOrder()
{
	var dateTime = /^(\d{1,4})(-|\/)(\d{1,2})(-|\/)(\d{1,2})( (\d{1,2}):(\d{1,2}):(\d{1,2}))?$/;
	if (!dateTime.test(this.DeliveryTime.value))
	{
		Alert(_lang_datetime_incorrect, function(){this.DeliveryTime.select();}, this);
		return false;
	}
	
	if (this.PaymentID.selectedIndex == -1)
	{
		Alert(_lang_select_paymentid);
		return false;
	}
	
	if (this.Currency.selectedIndex == -1)
	{
		Alert(_lang_select_currency);
		return false;
	}
	
	if (!this.PriceAdjustment.value.match(/^-?\d+(\.\d+)?$/))
	{
		Alert(_lang_price_adjustment_incorrect, function(){this.PriceAdjustment.select();}, this);
		return false;
	}
	
	if ($("#Member").attr("memberID") == "" && $("[name=PaymentID] option:selected").attr("pluginID").toUpperCase() == "0A3C149B-5337-4FE3-849C-2102BC1858F0")
	{
		Alert(_lang_none_member_acount);
		return false;
	}
	
	var detailTableRows = $("#DetailTable tr");
	if (detailTableRows.length == 2)
	{
		Alert(_lang_no_goods);
		return false;
	}
	
	_goodsIndex = 0;
	_goods.length = 0;
	for (var i = 2; i < detailTableRows.length; i++)
	{
		var row = detailTableRows.eq(i);
		
		_goods[_goods.length] = new Object();
		_goods[_goods.length - 1].GoodsID = row.attr("goodsID");
		_goods[_goods.length - 1].GoodsSpecID = row.attr("goodsSpecID");
		_goods[_goods.length - 1].Number = row.attr("number");
		_goods[_goods.length - 1].Name = row.attr("name");
		_goods[_goods.length - 1].Kind = row.attr("kind");
		_goods[_goods.length - 1].Weight = row.attr("weight");
		_goods[_goods.length - 1].Price = row.attr("price");
		_goods[_goods.length - 1].Amount = row.attr("amount");
	}

	var data = "Number=" + (this.Number.value == "" ? FormatDate(new Date(), "YYYYMMDDhhmmssSSS") : this.Number.value);
	data += "&Member=" + encodeURIComponent($("#Member").attr("member"));
	data += "&MemberID=" + $("#Member").attr("memberID");
	data += "&OrdererName=" + encodeURIComponent(this.OrdererName.value);
	data += "&OrdererPhone=" + encodeURIComponent(this.OrdererPhone.value);
	data += "&OrdererMobile=" + encodeURIComponent(this.OrdererMobile.value);
	data += "&OrdererEmail=" + encodeURIComponent(this.OrdererEmail.value);
	data += "&OrdererQQ=" + encodeURIComponent(this.OrdererQQ.value);
	data += "&OrdererWW=" + encodeURIComponent(this.OrdererWW.value);
	data += "&OrdererMSN=" + encodeURIComponent(this.OrdererMSN.value);
	data += "&ReceiverName=" + encodeURIComponent(this.ReceiverName.value);
	data += "&ReceiverPhone=" + encodeURIComponent(this.ReceiverPhone.value);
	data += "&ReceiverMobile=" + encodeURIComponent(this.ReceiverMobile.value);
	data += "&ReceiverAddress=" + encodeURIComponent(this.ReceiverAddress.value);
	data += "&ReceiverZip=" + encodeURIComponent(this.ReceiverZip.value);
	data += "&ReceiverEmail=" + encodeURIComponent(this.ReceiverEmail.value);
	data += "&ReceiverQQ=" + encodeURIComponent(this.ReceiverQQ.value);
	data += "&ReceiverWW=" + encodeURIComponent(this.ReceiverWW.value);
	data += "&ReceiverMSN=" + encodeURIComponent(this.ReceiverMSN.value);
	data += "&RegionName=" + encodeURIComponent(this.RegionID.options[this.RegionID.selectedIndex].text);
	data += "&RegionID=" + this.RegionID.value;
	if (this.DeliveryID.selectedIndex > 0)
	{
		var option = $("[name=DeliveryID] option:selected");
		data += "&DeliveryName=" + encodeURIComponent(option.text());
		data += "&DeliveryID=" + option.val();
		data += "&DeliveryFee=" + option.attr("fee");
		if (option.attr("isProtect").toLowerCase() == "true" && $("#DeliveryProtectYes")[0].checked)
		{
			data += "&DeliveryProtectRate=" + option.attr("protectRate");
			data += "&DeliveryProtectMin=" + option.attr("protectMin");
		}
	}
	data += "&DeliveryProtect=" + $("#DeliveryProtectYes")[0].checked;
	data += "&DeliveryTime=" + this.DeliveryTime.value;
	data += "&PaymentName=" + encodeURIComponent(this.PaymentID.options[this.PaymentID.selectedIndex].text);
	data += "&PaymentID=" + this.PaymentID.value;
	data += "&PaymentRate=" + $(this.PaymentID.options[this.PaymentID.selectedIndex]).attr("rate");
	data += "&Currency=" + this.Currency.value;
	data += "&NeedInvoice=" + $("#NeedInvoiceYes")[0].checked;
	data += "&TaxRate=" + _taxRate;
	data += "&PriceAdjustment=" + this.PriceAdjustment.value;
	data += "&Memo=" + encodeURIComponent(this.Memo.value);
	data += "&Price=" + _price;
	data += "&Weight=" + _weight;
	data += "&Sum=" + $("#SumTD").html();

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Order&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddOrderGoods(data);
		}
	});
	
	return false;	
}

function EditOrder()
{
	if (this.Number.value == "")
	{
		Alert(_lang_number_empty, function(){this.Number.select();}, this);
		return false;
	}

	var dateTime = /^(\d{1,4})(-|\/)(\d{1,2})(-|\/)(\d{1,2})( (\d{1,2}):(\d{1,2}):(\d{1,2}))?$/;
	if (!dateTime.test(this.DeliveryTime.value))
	{
		Alert(_lang_datetime_incorrect, function(){this.DeliveryTime.select();}, this);
		return false;
	}
	
	if (this.PaymentID.selectedIndex == -1)
	{
		Alert(_lang_select_paymentid);
		return false;
	}
	
	if (this.Currency.selectedIndex == -1)
	{
		Alert(_lang_select_currency);
		return false;
	}
	
	if (!this.PriceAdjustment.value.match(/^-?\d+(\.\d+)?$/))
	{
		Alert(_lang_price_adjustment_incorrect, function(){this.PriceAdjustment.select();}, this);
		return false;
	}
	
	if ($("#Member").attr("memberID") == "" && $("[name=PaymentID] option:selected").attr("pluginID").toUpperCase() == "0A3C149B-5337-4FE3-849C-2102BC1858F0")
	{
		Alert(_lang_none_member_acount);
		return false;
	}

	var data = "Number=" + this.Number.value;
	data += "&Member=" + encodeURIComponent($("#Member").attr("member"));
	data += "&MemberID=" + $("#Member").attr("memberID");
	data += "&OrdererName=" + encodeURIComponent(this.OrdererName.value);
	data += "&OrdererPhone=" + encodeURIComponent(this.OrdererPhone.value);
	data += "&OrdererMobile=" + encodeURIComponent(this.OrdererMobile.value);
	data += "&OrdererEmail=" + encodeURIComponent(this.OrdererEmail.value);
	data += "&OrdererQQ=" + encodeURIComponent(this.OrdererQQ.value);
	data += "&OrdererWW=" + encodeURIComponent(this.OrdererWW.value);
	data += "&OrdererMSN=" + encodeURIComponent(this.OrdererMSN.value);
	data += "&ReceiverName=" + encodeURIComponent(this.ReceiverName.value);
	data += "&ReceiverPhone=" + encodeURIComponent(this.ReceiverPhone.value);
	data += "&ReceiverMobile=" + encodeURIComponent(this.ReceiverMobile.value);
	data += "&ReceiverAddress=" + encodeURIComponent(this.ReceiverAddress.value);
	data += "&ReceiverZip=" + encodeURIComponent(this.ReceiverZip.value);
	data += "&ReceiverEmail=" + encodeURIComponent(this.ReceiverEmail.value);
	data += "&ReceiverQQ=" + encodeURIComponent(this.ReceiverQQ.value);
	data += "&ReceiverWW=" + encodeURIComponent(this.ReceiverWW.value);
	data += "&ReceiverMSN=" + encodeURIComponent(this.ReceiverMSN.value);
	data += "&RegionName=" + encodeURIComponent(this.RegionID.options[this.RegionID.selectedIndex].text);
	data += "&RegionID=" + this.RegionID.value;
	if (this.DeliveryID.selectedIndex > 0)
	{
		var option = $("[name=DeliveryID] option:selected");
		data += "&DeliveryName=" + encodeURIComponent(option.text());
		data += "&DeliveryID=" + option.val();
		data += "&DeliveryFee=" + option.attr("fee");
		if (option.attr("isProtect").toLowerCase() == "true" && $("#DeliveryProtectYes")[0].checked)
		{
			data += "&DeliveryProtectRate=" + option.attr("protectRate");
			data += "&DeliveryProtectMin=" + option.attr("protectMin");
		}
	}
	data += "&DeliveryProtect=" + $("#DeliveryProtectYes")[0].checked;
	data += "&DeliveryTime=" + this.DeliveryTime.value;
	data += "&PaymentName=" + encodeURIComponent(this.PaymentID.options[this.PaymentID.selectedIndex].text);
	data += "&PaymentID=" + this.PaymentID.value;
	data += "&PaymentRate=" + $(this.PaymentID.options[this.PaymentID.selectedIndex]).attr("rate");
	data += "&Currency=" + this.Currency.value;
	data += "&NeedInvoice=" + $("#NeedInvoiceYes")[0].checked;
	data += "&TaxRate=" + _taxRate;
	data += "&PriceAdjustment=" + this.PriceAdjustment.value;
	data += "&Memo=" + encodeURIComponent(this.Memo.value);
	data += "&Sum=" + $("#SumTD").html();

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Order&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function AddOrderGoods(orderID)
{
	if (_goodsIndex >= _goods.length)
	{
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
		return;
	}
	
	var data = "OrderID=" + orderID;
	data += "&GoodsID=" + _goods[_goodsIndex].GoodsID;
	data += "&GoodsSpecID=" + _goods[_goodsIndex].GoodsSpecID;
	data += "&Number=" + encodeURIComponent(_goods[_goodsIndex].Number);
	data += "&Name=" + encodeURIComponent(_goods[_goodsIndex].Name);
	data += "&Price=" + _goods[_goodsIndex].Price;
	data += "&Amount=" + _goods[_goodsIndex].Amount;
	data += "&Weight=" + _goods[_goodsIndex].Weight;
	data += "&Kind=" + _goods[_goodsIndex].Kind;
	
	_goodsIndex++;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Order.Detail&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			AddOrderGoods(orderID);
		}
	});			
}

function OrderDetail_Add()
{
	if (!this.Amount.value.match(/^[1-9]\d*$/))
	{
		Alert(_lang_amount_incorrect, function(){this.Amount.select();}, this);
		return false;
	}
	
	if (this.Number.value == "")
	{
		Alert(_lang_select_goods);
		return false;
	}
	
	for (var i = 1; i < document.forms.length; i++)
	{
		if (this.Number.value == document.forms[i].Number.value)
		{
			Alert(_lang_goods_exists);
			return false;
		}
	}
	
	var data = "OrderID=" + _orderID;
	data += "&GoodsID=" + this.GoodsID.value;
	data += "&GoodsSpecID=" + this.GoodsSpecID.value;
	data += "&Number=" + this.Number.value;
	data += "&Name=" + encodeURIComponent(this.Name.value);
	data += "&Price=" + this.Price.value;
	data += "&Amount=" + this.Amount.value;
	data += "&Weight=" + this.Weight.value;
	data += "&Kind=" + this.Kind.value;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Order.Detail&Operation=Add&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
			
			$("#List").html(HandleFake404(data, "text"));
			Init();

			OrderDetail_Compute();
			OrderDetail_ModifyOrder();
		}
	});
	
	return false;	
}

function OrderDetail_Modify()
{
	if (!this.Amount.value.match(/^[1-9]\d*$/))
	{
		Alert(_lang_amount_incorrect, function(){this.Amount.select();}, this);
		return false;
	}
	
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Order.Detail&Operation=Modify&ID=" + this.action,
		data : "Amount=" + this.Amount.value,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{		
			OrderDetail_Compute();
			OrderDetail_ModifyOrder();
		}
	});
	
	return false;	
}

function OrderDetail_Delete(id)
{
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Order.Detail&Operation=Delete&ID=" + id + "&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			$("#List").html(HandleFake404(data, "text"));
			Init();
			
			OrderDetail_Compute();
			OrderDetail_ModifyOrder();
		}
	});
	
	return false;	
}

function OrderDetail_ModifyOrder()
{
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Order&Operation=Modify&ID=" + _id,
		data : "PriceAdjustment=0&Weight=" + _weight + "&Price=" + _price + "&Sum=" + _sum,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function AddFeedBack()
{
	if (this.Content.value == "")
	{
		Alert(_lang_content_empty, function(){this.Content.select();}, this);
		return false;
	}
	
	if (this.Content.value.length > 255)
	{
		Alert(_lang_content_incorrect, function(){this.Content.select();}, this);
		return false;
	}
	
	var data = "OrderID=" + _orderID;
	data += "&Content=" + encodeURIComponent(this.Content.value);
	
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Feedback&Operation=Add&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			$("#List").html(HandleFake404(data, "text"));
		}
	});
	
	return false;	
}

function SetFile(id)
{
	var data = "Auto=" + $("#Auto" + id).checked;
	data += "&File=" + encodeURIComponent($("#File" + id).val());
	
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Order.Detail&Operation=SetFile",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
		}
	});
	
	return false;	
}

function ShowActionDialog(id, action)
{
	var path;
	if (action == "Payment")
		path = "make_payment.aspx?Lang=" + _lang + "&ID=" + id;
	else if (action == "Refund")
		path = "make_refund.aspx?Lang=" + _lang + "&ID=" + id;
	else if (action == "Delivery")
		path = "make_delivery.aspx?Lang=" + _lang + "&ID=" + id;
	else if (action == "Return")
		path = "make_return.aspx?Lang=" + _lang + "&ID=" + id;
		
	path = HandleFake404(path, "url");
	if ($.browser.msie)
		window.showModalDialog(path, window, "status=0;dialogWidth=800px;dialogHeight=650px;center=1;help=0;resizable=1;scroll=1");
	else
		window.open(path,null,"width=800,height=650,menubar=no,toolbar=no,location=no,scrollbars=yes,status=no,modal=yes");
}

function ConfirmOrder(id)
{
	if (arguments.length == 1)
	{
		Confirm(_lang_confirm, function(returnValue){if (returnValue)ConfirmOrder(id, true);}, this);
	}
	else
	{
		SetStatusMessage(_lang_working);
		
		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Order&Operation=Confirm&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();
			
			    $("#List").html(HandleFake404(data, "text"));
			    Init();
			}
		});
	}
		
	return false;	
}

function CancelOrder(id)
{
	if (arguments.length == 1)
	{
		Confirm(_lang_cancel, function(returnValue){if (returnValue)CancelOrder(id, true);}, this);
	}
	else
	{
		SetStatusMessage(_lang_working);
		
		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Order&Operation=Cancel&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();
			
			    $("#List").html(HandleFake404(data, "text"));
			    Init();
			}
		});
	}
		
	return false;	
}

function ArchiveOrder(id)
{
	if (arguments.length == 1)
	{
		Confirm(_lang_cancel, function(returnValue){if (returnValue)ArchiveOrder(id, true);}, this);
	}
	else
	{
		SetStatusMessage(_lang_working);
		
		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Order&Operation=Archive&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();
			
			    $("#List").html(HandleFake404(data, "text"));
			    Init();
			}
		});
	}
		
	return false;	
}

function DeleteOrder(id)
{
	if (arguments.length == 1)
	{
		Confirm(_lang_cancel, function(returnValue){if (returnValue)DeleteOrder(id, true);}, this);
	}
	else
	{
		SetStatusMessage(_lang_working);
		
		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Order&Operation=Delete&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();
			
			    $("#List").html(HandleFake404(data, "text"));
			    Init();
			}
		});
	}
		
	return false;	
}

function MakeDelivery()
{
	_goodsIndex = 0;
	_goods.length = 0;
	var rows = $("#DetailTable")[0].rows;
	for (var i = 1; i < rows.length; i++)
	{
		var amount = document.getElementById("Amount" + rows[i].id);
		if (amount == null)
			continue;
			
		if (!amount.value.match(/^\d+$/))
		{
			Alert(_lang_amout_incorrect, function(){amount.select();}, this);
			return false;
		}
		
		if (parseInt(amount.value) == 0)
			continue;
		
		if (parseInt(rows[i].cells[3].innerHTML) - parseInt(rows[i].cells[4].innerHTML) < parseInt(amount.value))
		{
			Alert(_lang_amount_exceed, function(){amount.select();}, this);
			return false;
		}

		if (rows[i].kind == "Physical" || rows[i].kind == "Card")
		{
			var stock = parseInt(rows[i].cells[2].innerHTML);
			if (isNaN(stock) || parseInt(stock) < parseInt(amount.value))
			{
				Alert(_lang_stock_not_enough, function(){amount.select();}, this);
				return false;
			}
		}
		
		_goods[_goods.length] = new Object();
		_goods[_goods.length - 1].InnerID = rows[i].id;
		_goods[_goods.length - 1].GoodsNumber = rows[i].cells[0].innerHTML;
		_goods[_goods.length - 1].GoodsName = rows[i].cells[1].innerHTML;
		_goods[_goods.length - 1].Amount = amount.value;
		
		var auto = $("#Auto" + rows[i].id);
		var file = $("#File" + rows[i].id);
		if (file != null)
		{
			if (!auto.checked && file.value == "")
			{
				Alert(_lang_set_file, function(){file.select();}, this);
				return false;
			}
			
			_goods[_goods.length - 1].File = encodeURIComponent(file.value);
		}
		else
		{
			_goods[_goods.length - 1].File = "";
		}
	}
	
	if (_goods.length == 0)
	{
		Alert(_lang_no_goods);
		return false;
	}
	
	var dateTime = /^(\d{1,4})(-|\/)(\d{1,2})(-|\/)(\d{1,2})( (\d{1,2}):(\d{1,2}):(\d{1,2}))?$/;
	if (!dateTime.test(this.Time.value))
	{
		Alert(_lang_time_incorrect, function(){this.Time.select();}, this);
		return false;
	}
	
	var number = (this.Number.value == "" ? FormatDate(new Date(), "YYYYMMDDhhmmssSSS") : this.Number.value);

	_data = "OrderID=" + _orderID + "&DeliveryName=" + _deliveryName + "&IsProtect=" + _isProtect;
	_data += "&Number=" + number;
	_data += "&Name=" + encodeURIComponent(this.Name.value);
	_data += "&Phone=" + encodeURIComponent(this.Phone.value);
	_data += "&Mobile=" + encodeURIComponent(this.Mobile.value);
	_data += "&Email=" + encodeURIComponent(this.Email.value);
	_data += "&QQ=" + encodeURIComponent(this.QQ.value);
	_data += "&WW=" + encodeURIComponent(this.WW.value);
	_data += "&MSN=" + encodeURIComponent(this.MSN.value);
	_data += "&Address=" + encodeURIComponent(this.Address.value);
	_data += "&Zip=" + encodeURIComponent(this.Zip.value);
	_data += "&DeliveryNumber=" + encodeURIComponent(this.DeliveryNumber.value);
	_data += "&Company=" + encodeURIComponent(this.Company.value);
	_data += "&Time=" + encodeURIComponent(this.Time.value);
	_data += "&Memo=" + encodeURIComponent(this.Memo.value);
	
	SetStatusMessage(_lang_delivering);
	DeliverGoods();
	return false;
}

function DeliverGoods()
{
	if (_goodsIndex >= _goods.length)
	{
		AddDelivery();
		return;
	}
	
	var data = "Amount=" + _goods[_goodsIndex].Amount;
	data += "&File=" + _goods[_goodsIndex].File;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Order.Detail&Operation=Deliver&ID=" + _goods[_goodsIndex++].InnerID,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			DeliverGoods();
		}
	});			
}

function AddDelivery()
{
	SetStatusMessage(_lang_making_delivery);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Delivery&Operation=Add",
		data : _data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			_deliveryID = data;
			_goodsIndex = 0;
			AddDeliveryDetail();
		}
	});
}

function AddDeliveryDetail()
{
	if (_goodsIndex >= _goods.length)
	{
		Alert(_lang_operation_success, function(){window.close();}, this);
		SetStatusMessage();
				
	    if ($.browser.msie)
			window.dialogArguments.Search();
		else
			window.opener.Search();
		
		return;
	}
	
	var data = "DeliveryID=" + _deliveryID;
	data += "&GoodsNumber=" + _goods[_goodsIndex].GoodsNumber;
	data += "&GoodsName=" + _goods[_goodsIndex].GoodsName;
	data += "&Amount=" + _goods[_goodsIndex].Amount;
	
	_goodsIndex++;
	
	SetStatusMessage(_lang_making_delivery_detail);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Delivery.Detail&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			AddDeliveryDetail();
		}
	});
}

function MakePayment()
{
	if (!this.Amount.value.match(/^\d+(\.\d+)?$/))
	{
		Alert(_lang_amount_incorrect, function(){this.Amount.select();}, this);
		return false;
	}
	
	if (parseFloat(this.Amount.value) <= 0)
	{
		Alert(_lang_amount_less_than_zero, function(){this.Amount.select();}, this);
		return false;
	}
	
	if (parseFloat(this.Amount.value) > (_sum - _hasPayed))
	{
		Alert(_lang_amount_greater_than_sum, function(){this.Amount.select();}, this);
		return false;
	}
	
	var dateTime = /^(\d{1,4})(-|\/)(\d{1,2})(-|\/)(\d{1,2})( (\d{1,2}):(\d{1,2}):(\d{1,2}))?$/;
	if (!dateTime.test(this.Time.value))
	{
		Alert(_lang_time_incorrect, function(){this.Time.select();}, this);
		return false;
	}
	
	var paymentNumber = (this.Number.value == "" ? FormatDate(new Date(), "YYYYMMDDhhmmssSSS") : this.Number.value);

	_data = "OrderID=" + _orderID + "&Currency=" + _currency;
	_data += "&Number=" + paymentNumber;
	_data += "&PaymentName=" + encodeURIComponent(_paymentName);
	_data += "&Name=" + encodeURIComponent(this.Name.value);
	_data += "&Phone=" + this.Phone.value;
	_data += "&Mobile=" + this.Mobile.value;
	_data += "&Email=" + this.Email.value;
	_data += "&QQ=" + this.QQ.value;
	_data += "&WW=" + this.WW.value;
	_data += "&MSN=" + this.MSN.value;
	_data += "&Amount=" + this.Amount.value;
	_data += "&Time=" + this.Time.value;
	_data += "&Memo=" + encodeURIComponent(this.Memo.value);
	
	SetStatusMessage(_lang_working);
	$(":submit")[0].disabled = true;
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Order&Operation=Pay&ID=" + _id,
		data : "Amount=" + this.Amount.value + "&PaymentNumber=" + paymentNumber,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			SetStatusMessage(_lang_making_payment);
	
			$.ajax(
			{
				url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Payment&Operation=Add",
				data : _data,
				type : "POST",
				error : function(request)
				{
					Alert(_lang_operation_fail);
					SetStatusMessage();
				},
				success : function(data)
				{
					Alert(_lang_operation_success, function(){window.close();}, this);
					SetStatusMessage();
							
	                if ($.browser.msie)
						window.dialogArguments.Search();
					else
						window.opener.Search();
				}
			});
		}
	});
	
	return false;
}

function MakeRefund()
{
	if (!this.Amount.value.match(/^\d+(\.\d+)?$/))
	{
		Alert(_lang_amount_incorrect, function(){this.Amount.select();}, this);
		return false;
	}
	
	if (parseFloat(this.Amount.value) <= 0)
	{
		Alert(_lang_amount_less_than_zero, function(){this.Amount.select();}, this);
		return false;
	}
	
	if (parseFloat(this.Amount.value) > _hasPayed)
	{
		Alert(_lang_amount_greater_than_sum, function(){this.Amount.select();}, this);
		return false;
	}
	
	var dateTime = /^(\d{1,4})(-|\/)(\d{1,2})(-|\/)(\d{1,2})( (\d{1,2}):(\d{1,2}):(\d{1,2}))?$/;
	if (!dateTime.test(this.Time.value))
	{
		Alert(_lang_time_incorrect, function(){this.Time.select();}, this);
		return false;
	}
	
	var refundNumber = (this.Number.value == "" ? FormatDate(new Date(), "YYYYMMDDhhmmssSSS") : this.Number.value);

	_data = "OrderID=" + _orderID + "&Currency=" + _currency;
	_data += "&Number=" + refundNumber;
	_data += "&Name=" + encodeURIComponent(this.Name.value);
	_data += "&Phone=" + encodeURIComponent(this.Phone.value);
	_data += "&Mobile=" + encodeURIComponent(this.Mobile.value);
	_data += "&Email=" + encodeURIComponent(this.Email.value);
	_data += "&QQ=" + encodeURIComponent(this.QQ.value);
	_data += "&WW=" + encodeURIComponent(this.WW.value);
	_data += "&MSN=" + encodeURIComponent(this.MSN.value);
	_data += "&AccountInfo=" + encodeURIComponent(this.AccountInfo.value);
	_data += "&Amount=" + this.Amount.value;
	_data += "&Time=" + this.Time.value;
	_data += "&Memo=" + encodeURIComponent(this.Memo.value);
	
	SetStatusMessage(_lang_working);
	$(":submit")[0].disabled = true;
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Order&Operation=Refund&ID=" + _id,
		data : "Amount=" + this.Amount.value + "&RefundNumber=" + refundNumber,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			SetStatusMessage(_lang_making_refund);
	
			$.ajax(
			{
				url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Refund&Operation=Add",
				data : _data,
				type : "POST",
				error : function(request)
				{
					Alert(_lang_operation_fail);
					SetStatusMessage();
				},
				success : function(data)
				{
					Alert(_lang_operation_success, function(){window.close();}, this);
					SetStatusMessage();
							
	                if ($.browser.msie)
						window.dialogArguments.Search();
					else
						window.opener.Search();
				}
			});
		}
	});

	return false;
}

function MakeReturn()
{
	_goodsIndex = 0;
	_goods.length = 0;
	var rows = $("#DetailTable")[0].rows;
	for (var i = 1; i < rows.length; i++)
	{
		var amount = document.getElementById("Amount" + rows[i].id);
		if (amount == null)
			continue;
			
		if (!amount.value.match(/^\d+$/))
		{
			Alert(_lang_amout_incorrect, function(){amount.select();}, this);
			return false;
		}
		
		if (parseInt(amount.value) == 0)
			continue;
		
		if (parseInt(rows[i].cells[3].innerHTML) < parseInt(amount.value))
		{
			Alert(_lang_amount_exceed, function(){amount.select();}, this);
			return false;
		}
		
		_goods[_goods.length] = new Object();
		_goods[_goods.length - 1].InnerID = rows[i].id;
		_goods[_goods.length - 1].GoodsNumber = rows[i].cells[0].innerHTML;
		_goods[_goods.length - 1].GoodsName = rows[i].cells[1].innerHTML;
		_goods[_goods.length - 1].Amount = amount.value;
	}
	
	if (_goods.length == 0)
	{
		Alert(_lang_no_goods);
		return false;
	}
	
	var dateTime = /^(\d{1,4})(-|\/)(\d{1,2})(-|\/)(\d{1,2})( (\d{1,2}):(\d{1,2}):(\d{1,2}))?$/;
	if (!dateTime.test(this.Time.value))
	{
		Alert(_lang_time_incorrect, function(){this.Time.select();}, this);
		return false;
	}
	
	var number = (this.Number.value == "" ? FormatDate(new Date(), "YYYYMMDDhhmmssSSS") : this.Number.value);

	_data = "OrderID=" + _orderID;
	_data += "&Number=" + number;
	_data += "&Name=" + encodeURIComponent(this.Name.value);
	_data += "&Phone=" + encodeURIComponent(this.Phone.value);
	_data += "&Mobile=" + encodeURIComponent(this.Mobile.value);
	_data += "&Email=" + encodeURIComponent(this.Email.value);
	_data += "&QQ=" + encodeURIComponent(this.QQ.value);
	_data += "&WW=" + encodeURIComponent(this.WW.value);
	_data += "&MSN=" + encodeURIComponent(this.MSN.value);
	_data += "&Address=" + encodeURIComponent(this.Address.value);
	_data += "&Zip=" + encodeURIComponent(this.Zip.value);
	_data += "&Time=" + encodeURIComponent(this.Time.value);
	_data += "&Memo=" + encodeURIComponent(this.Memo.value);
	
	SetStatusMessage(_lang_returning);
	ReturnGoods();
	return false;
}

function ReturnGoods()
{
	if (_goodsIndex >= _goods.length)
	{
		AddReturn();
		return;
	}
	
	var data = "Amount=" + _goods[_goodsIndex].Amount;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Order.Detail&Operation=Return&ID=" + _goods[_goodsIndex++].InnerID,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			ReturnGoods();
		}
	});			
}

function AddReturn()
{
	SetStatusMessage(_lang_making_return);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Return&Operation=Add",
		data : _data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			_returnID = data;
			_goodsIndex = 0;
			AddReturnDetail();
		}
	});
}

function AddReturnDetail()
{
	if (_goodsIndex >= _goods.length)
	{
		Alert(_lang_operation_success, function(){window.close();}, this);
		SetStatusMessage();
				
	    if ($.browser.msie)
			window.dialogArguments.Search();
		else
			window.opener.Search();
		
		return;
	}
	
	var data = "ReturnID=" + _returnID;
	data += "&GoodsNumber=" + _goods[_goodsIndex].GoodsNumber;
	data += "&GoodsName=" + _goods[_goodsIndex].GoodsName;
	data += "&Amount=" + _goods[_goodsIndex].Amount;
	
	_goodsIndex++;
	
	SetStatusMessage(_lang_making_return_detail);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Return.Detail&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			AddDeliveryDetail();
		}
	});
}
//End : 订单管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 付款单
function DeletePayment(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Payment&Operation=Delete&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			Init();
		}
	});
}
//End : 付款单
//-------------------------------------------------

//-------------------------------------------------
//Start : 退款单
function DeleteRefund(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Refund&Operation=Delete&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			Init();
		}
	});
}
//End : 退款单
//-------------------------------------------------

//-------------------------------------------------
//Start : 退货单
function DeleteReturn(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Return&Operation=Delete&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			Init();
		}
	});
}
//End : 退货单
//-------------------------------------------------

//-------------------------------------------------
//Start : 规格管理
function AddSpec()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Spec&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function EditSpec()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Spec&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function DeleteSpec(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Spec&Operation=Delete&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			Init();
		}
	});
}

function AddSpecOption()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "SpecID=" + _specID + "Name=" + encodeURIComponent(this.Name.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Spec.Option&Operation=Add&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
			
			$("#List").html(HandleFake404(data, "text"));
			Init();

			if (typeof(SetupIme) == "function")
				SetupIme();			
		}
	});
	
	return false;	
}

function ModifySpecOption(form, id)
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(form.Name.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Spec.Option&Operation=Modify&ID=" + id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function EditSpecOption()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Spec.Option&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function DeleteSpecOption(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Spec.Option&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			$("#" + id).remove();
		}
	});
}

//End : 规格管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 标签管理
function AddTag()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var pageID = this.PageID.value;
	if (pageID == "")
		pageID = "{ID}";
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			pageID = pageID.replace(/\{Guid\}/g, data);

			if (pageID != "")
			{
				$.ajax(
				{
					url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Brand&Operation=GetInnerIDFromGuid&ID=" + data,
					type : "GET",
					error : function(request)
					{
						Alert(_lang_innerid_fail);
						SetStatusMessage();
						$(":submit")[0].disabled = false;
					},
					success : function(data)
					{
						AddTag_SetPageID(data, pageID);
					}
				});
			}
			else
			{
			    AddTag_SetPageID(null, "");
			}
		}
	});
	
	return false;	
}

function AddTag_SetPageID(id, pageID)
{
	Alert(_lang_operation_success);
	SetStatusMessage();
	$(":submit")[0].disabled = false;
	
	if (pageID != "")
		$.post(_webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Tag&Operation=Modify&ID=" + id, "PageID=" + encodeURIComponent(pageID.replace(/\{ID\}/g, id)));
}

function ModifyTag(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(form.Name.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Tag&Operation=Modify&ID=" + id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function EditTag()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.PageID.value == "")
	{
		Alert(_lang_pageid_empty, function(){this.PageID.select();}, this);
		return false;
	}
	
	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(pageID);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Tag&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function DeleteTag()
{
	var id = GetChecked("Sel");
	if(id == "")
	{
		Alert(_lang_no_selection);
		return;
	}
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Tag&Operation=Delete&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			$("#List").html(HandleFake404(data, "text"));
			Init();

			if (typeof(SetupIme) == "function")
				SetupIme();			
		}
	});
}	
//End : 标签管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 类型管理
function AddType()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&Kind=" + encodeURIComponent(this.Kind.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function EditType()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&Kind=" + encodeURIComponent(this.Kind.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function DeleteType(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type&Operation=Delete&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			Init();
		}
	});
}

function AddParameterGroup()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "TypeID=" + _typeID + "&Name=" + encodeURIComponent(this.Name.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type.ParameterGroup&Operation=Add&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
			
			$("#List").html(HandleFake404(data, "text"));
			Init();
		}
	});
	
	return false;	
}

function EditParameterGroup()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type.ParameterGroup&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function ModifyParameterGroup(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return;
	}
	
	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type.ParameterGroup&Operation=Modify&ID=" + id,
		data : "Name=" + encodeURIComponent(form.Name.value),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}
	});
}

function DeleteParameterGroup(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type.ParameterGroup&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#" + id).remove();
		}
	});
}

function MoveParameterGroup(from, to)
{
	if (from == to)
		return;
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type.ParameterGroup&Operation=" + g_action + "&From=" + from + "&To=" + to,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			ClientMove(from, to, _imagePath);
		}
	});
}

function AddParameter()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "GroupID=" + _groupID + "&Name=" + encodeURIComponent(this.Name.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type.ParameterGroup.Parameter&Operation=Add&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
			
			$("#List").html(HandleFake404(data, "text"));
			Init();
		}
	});
	
	return false;	
}

function EditParameter()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type.ParameterGroup.Parameter&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function ModifyParameter(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return;
	}
	
	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type.ParameterGroup.Parameter&Operation=Modify&ID=" + id,
		data : "Name=" + encodeURIComponent(form.Name.value),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}
	});
}

function DeleteParameter(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type.ParameterGroup.Parameter&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#" + id).remove();
		}
	});
}

function MoveParameter(from, to)
{
	if (from == to)
		return;
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type.ParameterGroup.Parameter&Operation=" + g_action + "&From=" + from + "&To=" + to,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			ClientMove(from, to, _imagePath);
		}
	});
}

function AddProperty()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "TypeID=" + _typeID;
	data += "&Name=" + encodeURIComponent(this.Name.value);
	data += "&Control=" + encodeURIComponent(this.Control.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type.Property&Operation=Add&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
			
			$("#List").html(HandleFake404(data, "text"));
			Init();
		}
	});
	
	return false;	
}

function EditProperty()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type.Property&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function ModifyProperty(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return;
	}
	
	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type.Property&Operation=Modify&ID=" + id,
		data : "Name=" + encodeURIComponent(form.Name.value),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}
	});
}

function DeleteProperty(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type.Property&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#" + id).remove();
		}
	});
}

function MoveProperty(from, to)
{
	if (from == to)
		return;
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type.Property&Operation=" + g_action + "&From=" + from + "&To=" + to,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			ClientMove(from, to, _imagePath);
		}
	});
}

function AddPropertyOption()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "PropertyID=" + _propertyID + "&Name=" + encodeURIComponent(this.Name.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type.Property.Option&Operation=Add&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
			
			$("#List").html(HandleFake404(data, "text"));
			Init();
		}
	});
	
	return false;	
}

function EditPropertyOption()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type.Property.Option&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function ModifyPropertyOption(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return;
	}
	
	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type.Property.Option&Operation=Modify&ID=" + id,
		data : "Name=" + encodeURIComponent(form.Name.value),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}
	});
}

function DeletePropertyOption(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type.Property.Option&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#" + id).remove();
		}
	});
}

function MovePropertyOption(from, to)
{
	if (from == to)
		return;
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type.Property.Option&Operation=" + g_action + "&From=" + from + "&To=" + to,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			from = $("#" + from)[0];
			to = $("#" + to)[0];
			var table = from.parentNode.parentNode;
			var fromIndex = from.rowIndex;
			var toIndex = to.rowIndex;
			
			table.moveRow(fromIndex, toIndex);
		}
	});
}
//End : 类型管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 计量单位
function AddUnit()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Unit&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function EditUnit()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Unit&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function ModifyUnit(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return;
	}
	
	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Unit&Operation=Modify&ID=" + id,
		data : "Name=" + encodeURIComponent(form.Name.value),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}
	});
}

function DeleteUnit(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Unit&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#" + id).remove();
		}
	});
}
//End : 计量单位
//-------------------------------------------------

//-------------------------------------------------
//Start : 商品管理
function GoodsAdd_TypeID_OnChange()
{
	var form = document.forms[0];
	
	var option = $(form.TypeID.options(form.TypeID.selectedIndex));
	if (option.attr("kind") == "Physical")
	{
		$("#StockTR").css("display", "");
		$("#WeightTR").css("display", "");
		$("#CardTR").css("display", "none");
		$("#SpecTR").css("display", "");
		$("#FileTR").css("display", "none");
	}
	else
	{
		if (option.attr("kind") == "Card")
		{
			$("#CardTR").css("display", "");
			$("#FileTR").css("display", "none");
		}
		else if (option.attr("kind"), "File")
		{
			$("#CardTR").css("display", "none");
			$("#FileTR").css("display", "");
		}
		
		form.Stock.value = 0;
		form.Weight.value = 0;
		$("#StockTR").css("display", "none");
		$("#WeightTR").css("display", "none");

		var spec = $("#HasSpec")[0];
		spec.checked = false;
		EnableSpec();
		$("#SpecTR").css("display", "none");
	}
	
	$("#PropertyTR")[0].cells[1].innerHTML = "";
	$("#ParameterTR")[0].cells[1].innerHTML = "";
	if (option.val() != "")
	{		
		$("#PropertyTR").css("display", "");
		$("#ParameterTR").css("display", "");
		
		GetPropertyList(option.val());
	}
	else
	{
		$("#PropertyTR").css("display", "none");
		$("#ParameterTR").css("display", "none");
	}
}

function GetPropertyList(typeID)
{
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type.Property&Operation=List&Condition=" + encodeURIComponent(IlgharCMS.ShopModule.Type_Property.TypeID + "=" + typeID),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
		},
		success : function(data)
		{
			_html = "";
			_xmlProperty.loadXML(data);
			var itemList = _xmlProperty.documentElement.childNodes;
			if (itemList.length > 0)
				_html = "<table id='PropertyTable' border='0' cellpadding='4' cellspacing='1'><!--Property--></table>";
			
			_propertyHasOption.length = 0;
			
			for (var i = 0; i < itemList.length; i++)
			{
				if (typeof (itemList[i].selectSingleNode) == "undefined")
					continue;
						
				var innerID = itemList[i].selectSingleNode(IlgharCMS.ShopModule.Type_Property.InnerID).text;
				var name = itemList[i].selectSingleNode(IlgharCMS.ShopModule.Type_Property.Name).text;
				var control = itemList[i].selectSingleNode(IlgharCMS.ShopModule.Type_Property.Control).text;
				if (control != "Text" && control != "TextArea")
				{
					var property = new Object();
					property.ID = itemList[i].selectSingleNode(IlgharCMS.ShopModule.Type_Property.ID).text;
					property.InnerID = innerID;
					property.Name = name;
					property.Control = control;
					_propertyHasOption[_propertyHasOption.length] = property;
					continue;
				}
				
				var value;
				if (control == "Text")
					value = "<input type='text' name='P" + innerID + "' />";
				else
					value = "<textarea cols='40' rows='3' name='P" + innerID + "'></textarea>";
				_html = _html.replace("<!--Property-->", "<tr class='<%=ContentLang%>Font'><th>" + name + "：</th><td>" + value + "</td></tr><!--Property-->");
			}
			
			if (_propertyHasOption.length > 0)
			{
				_index = 0;
				GetPropertyOptionList(_propertyHasOption[_index].ID);
			}
			else
			{
				document.getElementById("PropertyTR").cells[1].innerHTML = _html;
				
				_action = "ParameterGroupList";
				_ajax.Post("<%=WebPath%>ilghar.aspx?Lang=<%=ContentLang%>&Object=Type.ParameterGroup&Operation=List&Condition=" + encodeURIComponent(IlgharCMS.ShopModule.Type_ParameterGroup.TypeID + "=" + document.forms[0].TypeID.value), null, XmlHttpCallBack);
			}
		}
	});
}

function GetPropertyOptionList(propertyID)
{
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type.Property.Option&Operation=List&Condition=" + encodeURIComponent(IlgharCMS.ShopModule.Type_Property_Option.PropertyID + "=" + propertyID),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
		},
		success : function(data)
		{
			_xmlDoc.loadXML(data);
			var itemList = _xmlDoc.documentElement.childNodes;
			if (itemList.length != 0)
			{
				var propertyID = _propertyHasOption[_index].InnerID;
				var control = _propertyHasOption[_index].Control;
				
				var name = "";
				var value = "";
				
				for (var i = 0; i < itemList.length; i++)
				{
					if (typeof (itemList[i].selectSingleNode) == "undefined")
						continue;
						
					var id = itemList[i].selectSingleNode(IlgharCMS.ShopModule.Type_Property_Option.InnerID).text;			
					name = itemList[i].selectSingleNode(IlgharCMS.ShopModule.Type_Property_Option.Name).text;
					if (control == "Select" || control == "List")
						value += "<option value='" + id + "'>" + name + "</option>";
					else if (control == "CheckBox")
						value += "<input type='checkbox' id='O" + id + "' name='P" + propertyID + "' value='" + name + "' /><label for='O" + id + "' class='<%=ContentLang%>Font'>" + name + "</label>";
					else if (control == "Radio")
						value += "<input type='radio' id='O" + id + "' name='P" + propertyID + "' value='" + name + "' /><label for='O" + id + "' class='<%=ContentLang%>Font'>" + name + "</label>";
				}
				
				name = _propertyHasOption[_index].Name;
				if (control == "Select")
					value = "<select name='P" + propertyID + "' class='<%=ContentLang%>Font'>" + value + "</select>";
				else if (control == "List")
					value = "<select name='P" + propertyID + "' size='4' class='<%=ContentLang%>Font'>" + value + "</select>";
				_html = _html.replace("<!--Property-->", "<tr class='<%=ContentLang%>Font'><th>" + name + "：</th><td>" + value + "</td></tr><!--Property-->");
			}
				
			_index++;
			if (_index < _propertyHasOption.length)
			{
				GetPropertyOptionList(_propertyHasOption[_index].ID);
			}
			else
			{
				$("#PropertyTR")[0].cells[1].innerHTML = _html;
				
				GetParameterGroupList(document.forms[0].TypeID.value);
			}
		}
	});	
}

function GetParameterGroupList(typeID)
{
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type.ParameterGroup&Operation=List&Condition=" + encodeURIComponent(IlgharCMS.ShopModule.Type_ParameterGroup.TypeID + "=" + typeID),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
		},
		success : function(data)
		{
			_xmlParameterGroup.loadXML(data);
			var itemList = _xmlParameterGroup.documentElement.childNodes;
			if (itemList.length > 0 && typeof (itemList[_index].selectSingleNode) != "undefined")
			{
				_html = "";
				_index = 0;
				GetParameterList(itemList[_index].selectSingleNode(IlgharCMS.ShopModule.Type_ParameterGroup.ID).text);
				
			}
		}
	});	
}

function GetParameterList(groupID)
{
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Type.ParameterGroup.Parameter&Operation=List&Condition=" + encodeURIComponent(IlgharCMS.ShopModule.Type_ParameterGroup_Parameter.GroupID + "=" + groupID),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
		},
		success : function(data)
		{
			var group = _xmlParameterGroup.documentElement.childNodes[_index];
			
			_xmlDoc.loadXML(data);
			var itemList = _xmlDoc.documentElement.childNodes;
			if (itemList.length != 0)
			{
				if (_html == "")
					_html = "<table id='ParameterTable' border='0' cellpadding='4' cellspacing='1'><!--Parameter--></table>";
					
				var name = group.selectSingleNode(IlgharCMS.ShopModule.Type_ParameterGroup.Name).text;
				_html = _html.replace("<!--Parameter-->", "<tr class='<%=ContentLang%>Font'><th colspan='2' style='text-align:left'>" + name + "</th></tr><!--Parameter-->");
				
				for (var i = 0; i < itemList.length; i++)
				{
					if (typeof (itemList[i].selectSingleNode) == "undefined")
						continue;
						
					var id = itemList[i].selectSingleNode(IlgharCMS.ShopModule.Type_ParameterGroup_Parameter.ID).text;
					name = itemList[i].selectSingleNode(IlgharCMS.ShopModule.Type_ParameterGroup_Parameter.Name).text;
					_html = _html.replace("<!--Parameter-->", "<tr><th>" + name + "：</th><td><input type='text' id='" + id + "' size='40' class='<%=ContentLang%>Font' /></td></tr><!--Parameter-->");
				}
			}
				
			_index++;
			if (_index < _xmlParameterGroup.documentElement.childNodes.length)
			{
				group = _xmlParameterGroup.documentElement.childNodes[_index];
				GetParameterList(group.selectSingleNode(IlgharCMS.ShopModule.Type_ParameterGroup.ID).text);
			}
			else
			{
				$("#ParameterTR").cells[1].innerHTML = _html;
			}
		}
	});		
}

function EnableSpec()
{
	var cb = $("#HasSpec")[0];
	var form = cb.form;
	if (cb.checked)
	{
		$("#SalePriceLabel").css("display", "none");
		$("#PromotePriceLabel").css("display", "none");
		$("#MemberPriceLabel").css("display", "none");
		$("#MemberPriceDiv").css("display", "none");
		if (_page == "goods_add")
		    $("#SpecTable").css("display", "");
	}
	else
	{
		$("#SalePriceLabel").css("display", "");
		$("#PromotePriceLabel").css("display", "");
		$("#MemberPriceLabel").css("display", "");
		$("#MemberPriceDiv").css("display", "");
		if (_page == "goods_add")
    		$("#SpecTable").css("display", "none");
	}
}

function SalePrice_OnChange()
{
	var salePrice = document.forms[0].SalePrice;
	$("input").each(function()
	{
		if (this.name.indexOf("MG") == 0)
		{
			if (salePrice.value.match(/^\d+(\.\d+)?$/))
				$("#MP" + this.name.substr(2)).html(parseInt(salePrice.value) * parseInt($(this).attr("amount")) / 100);
			else
				$("#MP" + this.name.substr(2)).html(salePrice.value);
		}
	});
}

function Promote_OnClick()
{
	var form = this.form;
	if (this.checked)
	{
		form.PromotePrice.disabled = false;
		form.PromoteStart.disabled = false;
		form.PromoteEnd.disabled = false;
		form.PromoteStart.value = FormatDate(new Date(), "YYYY-MM-DD");
		form.PromoteEnd.value = FormatDate(new Date(), "YYYY-MM-DD");
	}
	else
	{
		form.PromotePrice.disabled = true;
		form.PromoteStart.disabled = true;
		form.PromoteEnd.disabled = true;
	}
}

function MemberPrice_OnClick()
{
	var form = this.form;
	form.MemberPrice.disabled = true;
	
	var memberPriceTable = $("#MemberPriceTable")[0];
	if (memberPriceTable == null)
	{
	    $.ajax(
	    {
		    url : "ajax_member_price.aspx",
		    type : "GET",
		    error : function(request)
		    {
			    Alert(_lang_operation_fail);
		    },
		    success : function(data)
		    {
		        var form = document.forms[0];
			    $("#MemberPriceDiv").html(data);
			    form.MemberPrice.disabled = false;

                if (_page == "goods_edit")
                {
			        for (var i = 0; i < _memberPrices.length; i++)
			        {
				        var input = form.getAttribute("MG" + _memberPrices[i].RoleInnerID);
				        if (input != null)
					        input.value = _memberPrices[i].Price;
			        }
			    }
    			
			    SalePrice_OnChange();
		    }
	    });	
	}
	else
	{
		if (this.checked)
			memberPriceTable.style.display = "";
		else
			memberPriceTable.style.display = "none";
		this.disabled = false;
	}
}

function SelectSpec(spec, checked)
{
	var del = false;
	var i = 0;
	for (; i < _specs.length; i++)
	{
		if (_specs[i].ID == spec.ID)
		{
			if (checked)
				return;
			
			del = true;
			continue;
		}
		
		if (del)
			_specs[i - 1] = _specs[i];
	}
	
	if (i == _specs.length && !checked)
		return;
	
	if (del)
		_specs.length = _specs.length -1;
	else
		_specs[_specs.length] = spec;
	
	var html = "";
	for (i = 0; i < _specs.length; i++)
	{
		html += "<select id=\"Spec" + _specs[i].ID + "\">";
		html += "<option value=\"\">--" + _specs[i].Name + "--</option>";
		for (var j = 0; j < _specs[i].Options.length; j++)
		{
			html += "<option value=\"" + _specs[i].Options[j].ID + "\">" + _specs[i].Options[j].Name + "</option>";
		}
		html += "</select>";
	}
	
	if (_page == "goods_spec")
	{
	    $("#SpecSpan").html(html);
	}
	else
	{
	    html += "<input type=\"button\" value=\"" + _lang_select + "\" onclick=\"ShowSelectDialog('Spec')\" />";
	    $("#SpecTD").html(html);
	}
}

function SelectPart(name, sourceID, sourceSpecID, number, price, checked)
{
    if (_page == "goods_part")
    {
	    var form = document.forms[0];
	    form.Name.value = name;
	    form.SourceID.value = sourceID;
	    form.SourceSpecID.value = sourceSpecID;
	    form.Number.value = number;
	    form.Price.value = price;
    }
    else
    {
	    var checkbox = $("#Part" + number)[0];
	    if (checkbox != null)
	    {
		    checkbox.checked = checked;
		    return;
	    }
    	
	    var cell1Html = "<input type=\"checkbox\" id=\"Part" + number + "\" name=\"" + name + "\" sourceID=\"" + sourceID + "\" sourceSpecID=\"" + sourceSpecID + "\" number=\"" + number + "\" price=\"" + price + "\" checked=\"checked\" />";
	    var cell2Html = name;
	    var cell3Html = "<input type=\"text\" id=\"PartMin" + number + "\" value=\"0\" size=\"5\" />";
	    var cell4Html = "<input type=\"text\" id=\"PartMax" + number + "\" value=\"1\" size=\"5\" />";
	    var cell5Html = "<input type=\"checkbox\" id=\"PartIsDiscount" + number + "\" size=\"5\" checked=\"checked\" />";
	    var cell6Html = "<input type=\"text\" id=\"PartAmount" + number + "\" value=\"1\" size=\"5\" />";
    	
	    var cardTable = document.getElementById("PartTable");
	    if (cardTable == null)
	    {
		    var html = "<table id=\"PartTable\" border=\"0\" cellpadding=\"4\" cellspacing=\"1\">\
						    <thead>\
							    <tr>\
								    <th width=\"40\">" + _lang_select + "</th>\
								    <th>" + _lang_name + "</th>\
								    <th>" + _lang_lower + "</th>\
								    <th>" + _lang_upper + "</th>\
								    <th>" + _lang_discount + "</th>\
								    <th>" + _lang_amount + "</th>\
							    </tr>\
						    </thead>\
						    <tbody>\
							    <tr>\
								    <td><!--Cell1--></td>\
								    <td><!--Cell2--></td>\
								    <td><!--Cell3--></td>\
								    <td><!--Cell4--></td>\
								    <td><!--Cell5--></td>\
								    <td><!--Cell6--></td>\
							    </tr>\
						    </tbody>\
					    </table>";
		    html = html.replace("<!--Cell1-->", cell1Html);
		    html = html.replace("<!--Cell2-->", cell2Html);
		    html = html.replace("<!--Cell3-->", cell3Html);
		    html = html.replace("<!--Cell4-->", cell4Html);
		    html = html.replace("<!--Cell5-->", cell5Html);
		    html = html.replace("<!--Cell6-->", cell6Html);
		    $("#PartDiv").html(html);
	    }
	    else
	    {
		    var row = cardTable.insertRow(-1);
		    var cell1 = row.insertCell(-1);
		    cell1.innerHTML = cell1Html;
		    var cell2 = row.insertCell(-1);
		    cell2.innerHTML = cell2Html;
		    var cell3 = row.insertCell(-1);
		    cell3.innerHTML = cell3Html;
		    var cell4 = row.insertCell(-1);
		    cell4.innerHTML = cell4Html;
		    var cell5 = row.insertCell(-1);
		    cell5.innerHTML = cell5Html;
		    var cell6 = row.insertCell(-1);
		    cell6.innerHTML = cell6Html;
	    }
    }
}

function GetSpecMemberPrice(index)
{
    if (_page == "goods_spec_edit")
	    return _goodsSpecs[index].MemberPrice;
    else
        return _memberPrice;
}

function SelectTag(tag, checked)
{
	var tags = $("[name=Tag]");
	for (var i = 0; i < tags.length; i++)
	{
		if (tags[i].id == tag.ID)
		{
			tags[i].checked = checked;
			return;
		}
	}
	
	var tagContainer = $("#TagDiv");
	var br = "";
	if (tags.length > 0 && tags.length % 5 == 0) br = "<br />";
	tagContainer.html(tagContainer.html() + br + "<input type='checkbox' checked='checked' name='Tag' id='" + tag.ID + "' value='" + tag.Name + "' PageGenerate='" + tag.PageGenerate + "' PageTemplate='" + tag.PageTemplate + "'' PageID='" + tag.PageID + "'' PageExtension='" + tag.PageExtension + "' /><label class='" + _lang + "Font' for='" + tag.ID + "'>" + tag.Name + "</label>");	
}

function AddMorePicture()
{
	var cell1Html = "<input type=\"button\" value=\"" + _lang_delete + "\" onclick=\"DeleteMorePicture(this)\" />";
	var cell2Html = "<input id=\"Picture<!--Index-->Textbox\" type=\"text\" name=\"MorePicture<!--Index-->\" size=\"55\" class=\"Text\" onchange=\"document.getElementById('Picture<!--Index-->View').src = this.value\" />\
					 <input id=\"Picture<!--Index-->Browse\" type=\"button\" value=\"" + _lang_browse + "\" />\
					 <input type=\"button\" value=\"" + _lang_select + "...\" onclick=\"ShowSelectFileDialog('MorePicture<!--Index-->')\" />\
					 <img height=\"22\" id=\"Picture<!--Index-->View\" style=\"vertical-align:bottom\" />\
					 <input type=\"checkbox\" id=\"AddWaterMarkToMorePicture<!--Index-->\" /><label for=\"AddWaterMarkToMorePicture<!--Index-->\">" + _lang_water_print + "</label>";
	
	var morePictureTable = document.getElementById("MorePictureTable");
	if (morePictureTable == null)
	{
		var html = "<table id=\"MorePictureTable\" border=\"0\" cellpadding=\"4\" cellspacing=\"1\">\
							<tr>\
								<td width=\"40\"><!--Cell1--></td>\
								<td><!--Cell2--></td>\
							</tr>\
						</table>";
		html = html.replace("<!--Cell1-->", cell1Html.replace(/<!--Index-->/g, 0));
		html = html.replace("<!--Cell2-->", cell2Html.replace(/<!--Index-->/g, 0));
		document.getElementById("MorePictureDiv").innerHTML = html;
		
		_uploader.Add("Picture0", "Picture0Textbox", "Picture0Browse");
	}
	else
	{
		var row = morePictureTable.insertRow(-1);
		var cell1 = row.insertCell(-1);
		cell1.innerHTML = cell1Html.replace(/<!--Index-->/g, row.rowIndex);
		var cell2 = row.insertCell(-1);
		cell2.innerHTML = cell2Html.replace(/<!--Index-->/g, row.rowIndex);
		
		_uploader.Add("Picture" + row.rowIndex, "Picture" + row.rowIndex + "Textbox", "Picture" + row.rowIndex + "Browse");
	}
}

function DeleteMorePicture(input)
{
	var morePictureTable = document.getElementById("MorePictureTable");
	_uploader.Delete("Picture" + input.parentNode.parentNode.rowIndex);
	morePictureTable.deleteRow(input.parentNode.parentNode.rowIndex);
}

function AddCardToClient()
{
	var cell1Html = "<input type=\"button\" value=\"" + _lang_delete + "\" onclick=\"DeleteCard(this)\" />";
	var cell2Html = "<input type=\"text\" name=\"CardName<!--Index-->\" class=\"Text <%=ContentLang%>Font\" />";
	var cell3Html = "<textarea name=\"CardContent<!--Index-->\" cols=\"40\" rows=\"3\"></textarea>";
	
	var cardTable = document.getElementById("CardTable");
	if (cardTable == null)
	{
		var html = "<table id=\"CardTable\" border=\"0\" cellpadding=\"4\" cellspacing=\"1\">\
							<tr>\
								<td width=\"40\"><!--Cell1--></td>\
								<td><!--Cell2--></td>\
								<td><!--Cell3--></td>\
							</tr>\
						</table>";
		html = html.replace("<!--Cell1-->", cell1Html.replace(/<!--Index-->/g, 0));
		html = html.replace("<!--Cell2-->", cell2Html.replace(/<!--Index-->/g, 0));
		html = html.replace("<!--Cell3-->", cell3Html.replace(/<!--Index-->/g, 0));
		document.getElementById("CardDiv").innerHTML = html;
	}
	else
	{
		var row = cardTable.insertRow(-1);
		var cell1 = row.insertCell(-1);
		cell1.innerHTML = cell1Html.replace(/<!--Index-->/g, row.rowIndex);
		var cell2 = row.insertCell(-1);
		cell2.innerHTML = cell2Html.replace(/<!--Index-->/g, row.rowIndex);
		var cell3 = row.insertCell(-1);
		cell3.innerHTML = cell3Html.replace(/<!--Index-->/g, row.rowIndex);
	}
}

function DeleteCard(input)
{
	var CardTable = document.getElementById("CardTable");
	CardTable.deleteRow(input.parentNode.parentNode.rowIndex);
}

function SelectRelatedGoods(name, id, innerID, checked)
{
    if (_page == "goods_edit" && innerID == _id)
        return;

	var checkbox = document.getElementById("RG" + innerID);
	if (checkbox != null)
	{
		checkbox.checked = checked;
		return;
	}
	
	var cell1Html = "<input type=\"checkbox\" id=\"RG" + innerID + "\" value=\"" + id + "\" checked=\"checked\" />";
	var cell2Html = name;
	var cell3Html = "<input type=\"checkbox\" id=\"RGBoth" + innerID + "\" />";
	
	var cardTable = document.getElementById("RelatedGoodsTable");
	if (cardTable == null)
	{
		var html = "<table id=\"RelatedGoodsTable\" border=\"0\" cellpadding=\"4\" cellspacing=\"1\">\
						<thead>\
							<tr>\
								<th width=\"40\">" + _lang_select + "</th>\
								<th>" + _lang_name + "</th>\
								<th width=\"60\">" + _lang_cross + "</th>\
							</tr>\
						</thead>\
						<tbody>\
							<tr>\
								<td><!--Cell1--></td>\
								<td><!--Cell2--></td>\
								<td><!--Cell3--></td>\
							</tr>\
						</tbody>\
					</table>";
		html = html.replace("<!--Cell1-->", cell1Html);
		html = html.replace("<!--Cell2-->", cell2Html);
		html = html.replace("<!--Cell3-->", cell3Html);
		$("#RelatedGoodsDiv").html(html);
	}
	else
	{
		var row = cardTable.insertRow(-1);
		var cell1 = row.insertCell(-1);
		cell1.innerHTML = cell1Html;
		var cell2 = row.insertCell(-1);
		cell2.innerHTML = cell2Html;
		var cell3 = row.insertCell(-1);
		cell3.innerHTML = cell3Html;
	}
}

function Goods_AddSpec()
{
	var form = this.form;

	if (_specs.length == 0)
	{
		Alert(_lang_select_spec);
		return;
	}
	
	if (!form.SpecStock.value.match(/^\d+$/))
	{
		Alert(_lang_stock_incorrect, function(){form.SpecStock.select();}, this);
		return;
	}
	
	if (!form.SpecPrice.value.match(/^\d+(\.\d+)?$/))
	{
		Alert(_lang_sale_price_incorrect, function(){form.SpecPrice.select();}, this);
		return;
	}
	
	if (!form.SpecPromotePrice.value.match(/^\d+(\.\d+)?$/))
	{
		Alert(_lang_promote_price_incorrect, function(){form.SpecPromotePrice.select();}, this);
		return;
	}
	
	var spec = new Object();
	spec.Number = (form.SpecNumber.value == "" ? FormatDate(new Date(), "YYYYMMDDhhmmssSSS") : form.SpecNumber.value);
	spec.Stock = form.SpecStock.value;
	spec.Price = form.SpecPrice.value;
	spec.PromotePrice = form.SpecPromotePrice.value;
	spec.MemberPrice = new Array();
	spec.Name = "";
	spec.SpecInnerIDs = "";
	spec.SpecNames = "";
	spec.ValueInnerIDs = "";
	spec.ValueNames = "";
	for (var i = 0; i < _specs.length; i++)
	{
		var list = document.getElementById("Spec" + _specs[i].ID);
		if (list == null || list.selectedIndex == 0)
			continue;
		
		var option = list[list.selectedIndex];
		
		if (spec.Name != "")
			spec.Name += " , ";
		spec.Name += option.text;
		
		if (spec.SpecInnerIDs == "")
		{
			spec.SpecInnerIDs = "|";
			spec.SpecNames = "|";
			spec.ValueInnerIDs = "|";
			spec.ValueNames = "|";
		}
		spec.SpecInnerIDs += _specs[i].ID + "|";
		spec.SpecNames += _specs[i].Name + "|";
		spec.ValueInnerIDs += option.value + "|";
		spec.ValueNames += option.text + "|";
	}
	
	if (spec.Name == "")
	{
		Alert(_lang_spec_name_empty);
		return;
	}
	
	for (var i = 0; i < _goodsSpecs.length; i++)
	{
		if (_goodsSpecs[i].SpecInnerIDs == spec.SpecInnerIDs && _goodsSpecs[i].ValueInnerIDs == spec.ValueInnerIDs)
		{
			Alert(_lang_spec_exist);
			return;
		}
	}
	
	_goodsSpecs[_goodsSpecs.length] = spec;
	
	var row = document.getElementById("SpecTable").insertRow(-1);
	row.id = "SpecRow" + (_goodsSpecs.length - 1);
	var cell = row.insertCell(-1);
	cell.innerHTML = spec.Number;
	cell = row.insertCell(-1);
	cell.innerHTML = spec.ValueNames.substr(1, spec.ValueNames.length - 2).replace("|", " + ");
	cell = row.insertCell(-1);
	cell.innerHTML = spec.Stock;
	cell = row.insertCell(-1);
	cell.innerHTML = spec.Price;
	cell = row.insertCell(-1);
	cell.innerHTML = spec.PromotePrice;
	cell = row.insertCell(-1);
	cell.innerHTML = "<input type=\"button\" value=\"" + _lang_set + "\"" + ($("#MemberPriceLabel").css("display") == "none" ? " disabled=\"disabled\"" : "") + " onclick=\"ShowSelectDialog('SpecMemberPrice', " + (_goodsSpecs.length - 1) + ", " + spec.Price + ", " + spec.PromotePrice + ")\" />";
	cell = row.insertCell(-1);
	cell.innerHTML = "<input type=\"button\" value=\"" + _lang_delete + "\" onclick=\"Goods_DeleteSpec(" + (_goodsSpecs.length - 1) + ")\" />";
}

function Goods_DeleteSpec(index)
{
	for (var i = index + 1; i < _goodsSpecs.length; i++)
		_goodsSpecs[i - 1] = _goodsSpecs[i];
	_goodsSpecs.length = _goodsSpecs.length - 1;
	
	document.getElementById("SpecTable").deleteRow(document.getElementById("SpecRow" + index).rowIndex);
}

function SetSpecMemberPrice(index, memberPrice)
{
    if (_page == "goods_spec_edit" || _page == "goods_spec")
    {
    	_memberPrice = memberPrice;
	}
	else
	{
	    for (var i = 0; i < memberPrice.length; i++)
	    {
		    var del = false;
		    var j = 0;
		    for (; j < _goodsSpecs[index].MemberPrice.length; j++)
		    {
			    if (memberPrice[i].RoleInnerID == _goodsSpecs[index].MemberPrice[j].RoleInnerID)
			    {
				    if (memberPrice[i].Price == "")
				    {
					    del = true;
				    }
				    else
				    {
					    _goodsSpecs[index].MemberPrice[j].Price = memberPrice[i].Price;
					    break;
				    }
			    }
    			
			    if (del)
				    _goodsSpecs[index].MemberPrice[j - 1] = _goodsSpecs[index].MemberPrice[j];
		    }
    		
		    if (del)
			    _goodsSpecs[index].MemberPrice.length = _goodsSpecs[index].MemberPrice.length -1;
		    else
			    _goodsSpecs[index].MemberPrice[_goodsSpecs[index].MemberPrice.length] = memberPrice[i];
	    }
	}
}

function AddGoods()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!this.Stock.value.match(/^\d+$/))
	{
		Alert(_lang_stock_incorrect, function(){this.Stock.select();}, this);
		return false;
	}
	
	if (!this.Weight.value.match(/^\d+(\.\d+)?$/))
	{
		Alert(_lang_weight_incorrect, function(){this.Weight.select();}, this);
		return false;
	}
	
	if (!this.MarketPrice.value.match(/^\d+(\.\d+)?$/))
	{
		Alert(_lang_market_price_incorrect, function(){this.MarketPrice.select();}, this);
		return false;
	}
	
	if (!this.SalePrice.value.match(/^\d+(\.\d+)?$/))
	{
		Alert(_lang_sale_price_incorrect, function(){this.SalePrice.select();}, this);
		return false;
	}
	
	if (!this.CostPrice.value.match(/^\d+(\.\d+)?$/))
	{
		Alert(_lang_cost_price_incorrect, function(){this.CostPrice.select();}, this);
		return false;
	}

	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_picture_type_must_be + this.PictureAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Thumbnail.value, this.ThumbnailAllowedType.value))
	{
		Alert(_lang_thumbnail_type_must_be + this.ThumbnailAllowedType.value, function(){this.Thumbnail.select();}, this);
		return false;
	}
	
	if (!this.HitCount.value.match(/^\d+$/))
	{
		Alert(_lang_hitcount_incorrect, function(){this.HitCount.select();}, this);
		return false;
	}

	if (!this.Up.value.match(/^\d+$/))
	{
		Alert(_lang_up_incorrect, function(){this.Up.select();}, this);
		return false;
	}

	if (!this.Down.value.match(/^\d+$/))
	{
		Alert(_lang_down_incorrect, function(){this.Down.select();}, this);
		return false;
	}
	
	if ($("#Promote")[0].checked)
	{
		if (!this.PromotePrice.value.match(/^\d+(\.\d+)?$/))
		{
			Alert(_lang_promote_price_incorrect, function(){this.PromotePrice.select();}, this);
			return false;
		}

		var dateTime = /^(\d{1,4})(-|\/)(\d{1,2})(-|\/)(\d{1,2})( (\d{1,2}):(\d{1,2}):(\d{1,2}))?$/;
		if (!dateTime.test(this.PromoteStart.value))
		{
			Alert(_lang_promote_start_incorrect, function(){this.PromoteStart.select();}, this);
			return false;
		}
		if (!dateTime.test(this.PromoteEnd.value))
		{
			Alert(_lang_promote_end_incorrect, function(){this.PromoteEnd.select();}, this);
			return false;
		}
	}
	
	var fail = false;

	_memberPriceIndex = 0;
	_memberPrices.length = 0;
	$("#MemberPriceDiv input").each(function()
	{
		if (this.value == "")
			return;
			
		if (!this.value.match(/^\d+(\.\d+)?$/))
		{
			Alert(_lang_member_price_incorrect, function(){this.select();}, this);
			fail = true;
			return false;
		}
		
		var memberPrice = new Object();
		memberPrice.Price = encodeURIComponent(inputs[i].value);
		memberPrice.RoleInnerID = inputs[i].name.substr(2);
		_memberPrices[_memberPrices.length] = memberPrice;
	});

	if (fail)
		return false;
	
	if ($("#FileTR").css("display") == "")
	{
		if (!IsAllowedType(this.File.value, this.FileAllowedType.value))
		{
			Alert(_lang_file_type_must_be + form.FileAllowedType.value, function(){this.File.select();}, this);
			return false;
		}
	}
	else if ($("#CardTR").css("display") == "")
	{
		$("#CardDiv :text").each(function()
		{
			if (this.value == "")
			{
				Alert(_lang_card_name_empty, function(){this.select();}, this);
				fail = false;
				return false;
			}
			
			var content = eval("document.forms[0].CardContent" + this.name.substr(8));
			if (content.value == "")
			{
				Alert(_lang_card_content_empty, function(){content.select();}, this);
				fail = false;
				return false;
			}
		});
		
		if (fail)
			return false;
	}
	
	_morePictureIndex = 0;
	_morePictures.length = 0;
	$("#MorePictureDiv :text").each(function()
	{
		if (this.value == "")
			return;
		
		if (!IsAllowedType(this.value, this.form.PictureAllowedType.value))
		{
			Alert(_lang_type_must_be + this.form.PictureAllowedType.value, function(){this.select();}, this);
			fail = true;
			return false;
		}

		var morePicture = new Object();
		morePicture.URL = encodeURIComponent(this.value);
		morePicture.FormID = "Picture" + this.parentNode.parentNode.rowIndex;
		morePicture.Upload = _uploader.NeedUpload(morePicture.FormID);
		_morePictures[_morePictures.length] = morePicture;
	});
	
	if (fail)
		return false;

	_propertyIndex = 0;
	_properties.length = 0;
	var items = (_xmlProperty.documentElement == null ? null : _xmlProperty.documentElement.childNodes);
	for (var i = 0; items != null && i < items.length; i++)
	{
		var property = new Object();
		property.ID = items[i].selectSingleNode(IlgharCMS.ShopModule.Type_Property.ID).text;
		property.OptionInnerIDs = "";
		property.Value = "";
		
		var name = "P" + items[i].selectSingleNode(IlgharCMS.ShopModule.Type_Property.InnerID).text;
		var control = items[i].selectSingleNode(IlgharCMS.ShopModule.Type_Property.Control).text;
		if (control == "CheckBox" || control == "Radio")
		{
			$("#PropertyTable input").each(function()
			{
				if (this.name != name || !this.checked)
					return;
				
				if (control == "Radio")
				{
					property.Value = inputs[j].value;
					property.OptionInnerIDs = inputs[j].id.substr(1);
					return false;
				}
				
				if (property.Value == "")
				{
					property.OptionInnerIDs = "|";
					property.Value = "|";
				}
				property.OptionInnerIDs += this.id.substr(1) + "|";
				property.Value += this.value + "|";
			});
			
			if (property.Value != "")
				_properties[_properties.length] = property;
		}
		else if (control == "Select" || control == "List")
		{
			var menu = eval("document.forms[0]." + name);
			if (menu.selectedIndex != -1)
			{
				property.Value = menu.options[menu.selectedIndex].text;
				property.OptionInnerIDs = menu.options[menu.selectedIndex].value;
				_properties[_properties.length] = property;
			}
		}
		else
		{
			property.Value = eval("document.forms[0]." + name).value;
			_properties[_properties.length] = property;
		}
	}

	_parameterIndex = 0;
	_parameters.length = 0;
	var inputs = $("#ParameterTR input").each(function()
	{
		var parameter = new Object();
		parameter.ID = this.id;
		parameter.Value = encodeURIComponent(this.value);
		_parameters[_parameters.length] = parameter;
	});

	_relatedIndex = 0;
	_relateds.length = 0;
	$("#RelatedGoodsDiv :checked").each(function()
	{
		if (this.id.indexOf("RGBoth") == 0)
			return;
		
		var goods = new Object();
		goods.RelatedID = this.value;
		goods.Both = $("#RGBoth" + this.id.substr(2))[0].checked;
		_relateds[_relateds.length] = goods;
	});
	
	_partIndex = 0;
	_parts.length = 0;
	$("#PartDiv :checked").each(function()
	{
	    var me = $(this);
		if (this.id.indexOf("PartIsDiscount") == 0)
			return;

		var partMin = $("#PartMin" + me.attr("number"))[0];
		if (!partMin.value.match(/^\d+$/))
		{
			Alert(_lang_lower_incorrect, function(){partMin.select();}, this);
			fail = true;
			return false;
		}

		var partMax = $("#PartMax" + me.attr("number"))[0];
		if (!partMax.value.match(/^\d+$/))
		{
			Alert(_lang_upper_incorrect, function(){partMax.select();}, this);
			fail = true;
			return false;
		}

		var partIsDiscount = $("#PartIsDiscount" + me.attr("number"))[0];
		var partAmount = $("#PartAmount" + me.attr("number"))[0];
		if (partIsDiscount.checked)
		{
			if (!partAmount.value.match(/^(1|0|(0\.\d+))$/))
			{
				Alert(_lang_amount_incorrect, function(){partAmount.select();}, this);
				fail = true;
				return false;
			}
		}
		else
		{
			if (!partAmount.value.match(/^\d+$/))
			{
				Alert(_lang_amount_incorrect, function(){partAmount.select();}, this);
				fail = true;
				return false;
			}
		
			if (parseInt(this.form.Amount.value) > parseInt(this.price))
			{
				Alert(_lang_amount_exceed, function(){this.form.Amount.select();}, this);
				fail = true;
				return false;
			}
		}
		
		var part = new Object();
		part.SourceID = me.attr("sourceID");
		part.SourceSpecID = me.attr("sourceSpecID");
		part.Number = me.attr("number");
		part.Name = me.attr("name");
		part.Price = me.attr("price");
		part.Min = partMin.value;
		part.Max = partMax.value;
		part.IsDiscount = partIsDiscount.checked;
		part.Amount = partAmount.value;
		_parts[_parts.length] = part;
	});
	
	if (fail)
		return false;
	
	SetCookie("CategoryID", this.CategoryID.value, 10*360*24*60);	
	SetCookie("TypeID", this.TypeID.value, 10*360*24*60);	
	SetCookie("UnitID", this.UnitID.value, 10*360*24*60);	
	SetCookie("BrandID", this.BrandID.value, 10*360*24*60);

	var category = $("[name=CategoryID] option:selected");
	var type = $("[name=TypeID] option:selected");
	var unit = $("[name=UnitID] option:selected");
	var brand = $("[name=BrandID] option:selected");

	_uploadFile = false;
	_goodsSpecIndex = 0;
	_specMemberPriceIndex = 0;	
	
	var tag = PrepareTag();

	_createTime = new Date();
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";

	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&CreateTime=" + FormatDate(_createTime, "YYYY-MM-DD hh:mm:ss.SSS");
	data += "&Number=" + (this.Number.value == "" ? FormatDate(_createTime, "YYYYMMDDhhmmssSSS") : this.Number.value);
	data += "&CategoryID=" + this.CategoryID.value;
	data += "&CategoryName=" + category.attr("Name");
	data += "&CategoryPageGenerate=" + category.attr("PageGenerate");
	data += "&CategoryPageTemplate=" + category.attr("PageTemplate");
	data += "&CategoryPageID=" + category.attr("PageID");
	data += "&CategoryPageExtension=" + category.attr("PageExtension");
	data += "&TypeID=" + type.val();
	data += "&Kind=" + type.attr("kind");
	data += "&UnitID=" + unit.val();
	data += "&UnitName=" + encodeURIComponent(unit.attr("name"));
	data += "&BrandID=" + brand.val();
	data += "&BrandInnerID=" + brand.attr("innerID");
	data += "&BrandName=" + encodeURIComponent(brand.attr("name"));
	data += "&Stock=" + this.Stock.value;
	data += "&Weight=" + this.Weight.value;
	data += "&MarketPrice=" + this.MarketPrice.value;
	data += "&SalePrice=" + this.SalePrice.value;
	data += "&CostPrice=" + this.CostPrice.value;
	data += "&HasSpec=" + $("#HasSpec")[0].checked;
	data += "&Promote=" + $("#Promote")[0].checked;
	if ($("#Promote")[0].checked)
	{
		data += "&PromotePrice=" + this.PromotePrice.value;
		data += "&PromoteStart=" + this.PromoteStart.value;
		data += "&PromoteEnd=" + this.PromoteEnd.value;
	}

	if (type.attr("kind") == "Card")
	{
		_cardIndex = 0;
		_cards.length = 0;
		$("#CardDiv :text").each(function()
		{
			var card = new Object();
			card.Name = this.value;
			card.Content = eval("document.forms[0].CardContent" + this.name.substr(8)).value;
			_cards[_cards.length] = card;
		});
	}
	else if (type.attr("kind") == "File")
	{
		_uploadFile = _uploader.NeedUpload("File");
		if (!_uploadFile)
			data += "&File=" + encodeURIComponent(this.File.value);
	}
	data += "&Introduction=" + encodeURIComponent(this.Introduction.value);
	var editor = FCKeditorAPI.GetInstance("HtmlEditor");
	if (editor.IsDirty())
		data += "&Description=" + encodeURIComponent(editor.GetXHTML(false));
	data += "&IsReleased=" + this.IsReleased.checked;
	data += "&OnlyAsPart=" + this.OnlyAsPart.checked;
	data += "&IsRecommended=" + $("#IsRecommended")[0].checked;
	data += "&IsHeld=" + $("#IsHeld")[0].checked;
	data += "&HitCount=" + this.HitCount.value;
	data += "&Up=" + this.Up.value;
	data += "&Down=" + this.Down.value;
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	data += "&TagNames=" + encodeURIComponent(tag.Names);
	data += "&TagPageGenerates=" + encodeURIComponent(tag.PageGenerates);
	data += "&TagPageTemplates=" + encodeURIComponent(tag.PageTemplates);
	data += "&TagPageIDs=" + encodeURIComponent(tag.PageIDs);
	data += "&TagPageExtensions=" + encodeURIComponent(tag.PageExtensions);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if (this.MakeThumbnail.checked)
	{
		_uploadThumbnail = false;
	}
	else
	{
		_uploadThumbnail = _uploader.NeedUpload("Thumbnail");
		if (!_uploadThumbnail)
			data += "&Thumbnail=" + encodeURIComponent(this.Thumbnail.value);
	}

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Goods&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			_guid = data;
		    AddGoods_GetInnerID();
		}
	});
	
	return false;	
}

function AddGoods_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Goods&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
            _id = data;
			AddGoods_SetPageID();
		}
	});
}

function AddGoods_SetPageID()
{
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
	_pageID = _pageID.replace(/\{ID\}/g, _id);
	_pageID = _pageID.replace(/\{YYYYMMDDhhmmss\}/g, FormatDate(_createTime, "YYYYMMDDhhmmss"));
	_pageID = _pageID.replace(/\{YYYY-MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY-MM-DD/hhmmss"));
	_pageID = _pageID.replace(/\{YYYY\/MM\/DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM/DD/hhmmss"));
	_pageID = _pageID.replace(/\{YYYY\/MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM-DD/hhmmss"));

    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Goods&Operation=Modify&ID=" + _id,
		data : "PageID=" + encodeURIComponent(_pageID),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			AddGoods_AddMemberPrice();
		}
	});
}

function AddGoods_AddMemberPrice()
{
	if (_memberPriceIndex >= _memberPrices.length)
	{
		AddGoods_AddCard();
		return;
	}
	
	var data = "GoodsID=" + _guid;
	data += "&RoleInnerID=" + _memberPrices[_memberPriceIndex].RoleInnerID;
	data += "&Price=" + _memberPrices[_memberPriceIndex].Price;
	
	_memberPriceIndex++;

	SetStatusMessage(_lang_adding_member_price);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=MemberPrice&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddGoods_AddMemberPrice();
		}
	});			
}

function AddGoods_AddCard()
{
	if (_cardIndex >= _cards.length)
	{
		AddGoods_AddProperty();
		return;
	}
	
	var data = "GoodsID=" + _guid;
	data += "&Name=" + _cards[_cardIndex].Name;
	data += "&Content=" + _cards[_cardIndex].Content;
	
	_cardIndex++;

	SetStatusMessage(_lang_adding_card);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Card&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddGoods_AddCard();
		}
	});			
}

function AddGoods_AddProperty()
{
	if (_propertyIndex >= _properties.length)
	{
		AddGoods_AddParameter();
		return;
	}
	
	var data = "GoodsID=" + _guid;
	data += "&PropertyID=" + _properties[_propertyIndex].ID;
	data += "&OptionInnerIDs=" + _properties[_propertyIndex].OptionInnerIDs;
	data += "&Value=" + _properties[_propertyIndex].Value;
	
	_propertyIndex++;

	SetStatusMessage(_lang_adding_property);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Goods.Property&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddGoods_AddProperty();
		}
	});			
}

function AddGoods_AddParameter()
{
	if (_parameterIndex >= _parameters.length)
	{
		AddGoods_AddTag();
		return;
	}
	
	var data = "GoodsID=" + _guid;
	data += "&ParameterID=" + _parameters[_parameterIndex].ID;
	data += "&Value=" + _parameters[_parameterIndex].Value;
	
	_parameterIndex++;

	SetStatusMessage(_lang_adding_parameter);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Goods.Parameter&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddGoods_AddParameter();
		}
	});			
}

function AddGoods_AddTag()
{
	if (_tagIndex >= _tags.length)
	{
		AddGoods_AddRelatedGoods();
		return;
	}
	
	var data = "GoodsID=" + _guid;
	data += "&TagID=" + _tags[_tagIndex];
	
	_tagIndex++;

	SetStatusMessage(_lang_adding_tag);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Goods.Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddGoods_AddTag();
		}
	});			
}

function AddGoods_AddRelatedGoods()
{
	if (_relatedIndex >= _relateds.length)
	{
		AddGoods_AddSpec();
		return;
	}
	
	var data = "MainID=" + _guid;
	data += "&RelatedID=" + _relateds[_relatedIndex].RelatedID;
	data += "&Both=" + _relateds[_relatedIndex].Both;
	
	_relatedIndex++;

	SetStatusMessage(_lang_adding_related_goods);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Goods.RelatedGoods&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddGoods_AddRelatedGoods();
		}
	});
}

function AddGoods_AddSpec()
{
	if (_goodsSpecIndex >= _goodsSpecs.length)
	{
		AddGoods_AddPart();
		return;
	}
	
	var data = "GoodsID=" + _guid;
	data += "&Number=" + _goodsSpecs[_goodsSpecIndex].Number;
	data += "&Name=" + _goodsSpecs[_goodsSpecIndex].Name;
	data += "&Stock=" + _goodsSpecs[_goodsSpecIndex].Stock;
	data += "&Price=" + _goodsSpecs[_goodsSpecIndex].Price;
	data += "&PromotePrice=" + _goodsSpecs[_goodsSpecIndex].PromotePrice;
	data += "&SpecInnerIDs=" + _goodsSpecs[_goodsSpecIndex].SpecInnerIDs;
	data += "&SpecNames=" + encodeURIComponent(_goodsSpecs[_goodsSpecIndex].SpecNames);
	data += "&ValueInnerIDs=" + _goodsSpecs[_goodsSpecIndex].ValueInnerIDs;
	data += "&ValueNames=" + encodeURIComponent(_goodsSpecs[_goodsSpecIndex].ValueNames);
	
	_goodsSpecIndex++;

	SetStatusMessage(_lang_adding_spec);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Goods.Spec&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddGoods_AddSpec();
		}
	});
}

function AddGoods_AddPart()
{
	if (_partIndex >= _parts.length)
	{
		AddGoods_UploadMorePicture()
		return;
	}
	
	var data = "GoodsID=" + _guid;
	data += "&SourceID=" + _parts[_partIndex].SourceID;
	data += "&SourceSpecID=" + _parts[_partIndex].SourceSpecID;
	data += "&Number=" + encodeURIComponent(_parts[_partIndex].Number);
	data += "&Name=" + encodeURIComponent(_parts[_partIndex].Name);
	data += "&Price=" + _parts[_partIndex].Price;
	data += "&Min=" + _parts[_partIndex].Min;
	data += "&Max=" + _parts[_partIndex].Max;
	data += "&IsDiscount=" + _parts[_partIndex].IsDiscount;
	data += "&Amount=" + _parts[_partIndex].Amount;
	
	_partIndex++;

	SetStatusMessage(_lang_adding_part);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Part&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddGoods_AddPart();
		}
	});
}

function AddGoods_UploadMorePicture()
{
	if (_morePictureIndex >= _morePictures.length)
	{
		Goods_UploadFile();
		return;
	}
    
    if (_morePictures[_morePictureIndex].Upload)
    {
        var formID = _morePictures[_morePictureIndex].FormID;
        var index = formID.substr(7);

        _morePictureIndex++;

	    _uploader.Init({Status:_lang_uploading_more_picture,Params:"Lang=" + _lang + "&Object=Goods.Pictures&Operation=Upload&GoodsID=" + _guid + "&GoodsInnerID=" + _id + "&AddWaterMark=" + $("#AddWaterMarkToMorePicture" + index)[0].checked});
	    _uploader.Upload(formID, function()
        {
            if (arguments.length == 2)
            {
                Alert(arguments[1]);
		        SetStatusMessage();
		        $(":submit")[0].disabled = false;
            }
            else
            {
    		    AddGoods_UploadMorePicture();
    	    }
        });
    }
    else
    {
        var data = "GoodsID=" + _guid;
        data += "&URL=" + _morePictures[_morePictureIndex].URL;

        _morePictureIndex++;

	    SetStatusMessage(_lang_adding_more_picture);

	    $.ajax(
	    {
		    url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Goods.Pictures&Operation=Add",
		    data : data,
		    type : "POST",
		    error : function(request)
		    {
			    Alert(_lang_operation_fail);
			    SetStatusMessage();
			    $(":submit")[0].disabled = false;
		    },
		    success : function(data)
		    {
			    AddGoods_UploadMorePicture();
		    }
	    });
    }
}

function AddCard()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.Content.value == "")
	{
		Alert(_lang_content_empty, function(){this.Content.select();}, this);
		return false;
	}
		
	var data = "GoodsID=" + _goodsID + "&Name=" + encodeURIComponent(this.Name.value);
	data += "&Content=" + encodeURIComponent(this.Content.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Card&Operation=Add&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
			
			$("#List").html(HandleFake404(data, "text"));
			Init();
		}
	});
	
	return false;	
}

function DeleteCard(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Card&Operation=Delete&ID=" + id + "&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			Init();
		}
	});
}

function EditGoodsDescription(id)
{
	var editor = FCKeditorAPI.GetInstance("HtmlEditor");
	if (!editor.IsDirty())
	{
		Alert(_lang_no_changes);
		return false;
	}
		
	var data = "Description=" + encodeURIComponent(editor.GetXHTML(false));

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Goods&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function GoodsEdit_TypeID_OnChange()
{
	var form = document.forms[0];
	
	var option = $("[name=TypeID]:selected");
	if (option.attr("kind") == "Physical")
	{
		$("#StockTR").css("display", "");
		$("#WeightTR").css("display", "");
		$("#SpecTR").css("display", "");
		$("#FileTR").css("display", "none");
	}
	else
	{
		if (option.attr("kind") == "Card")
		{
			$("#FileTR").css("display", "none");
		}
		else if (option.attr("kind"), "File")
		{
			$("#FileTR").css("display", "");
		}
		
		form.Stock.value = 0;
		form.Weight.value = 0;
		$("#StockTR").css("display", "none");
		$("#WeightTR").css("display", "none");

		var spec = $("#HasSpec")[0];
		spec.checked = false;
		EnableSpec();
		$("#SpecTR").css("display", "none");
	}
}

function EditGoods()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!this.Stock.value.match(/^\d+$/))
	{
		Alert(_lang_stock_incorrect, function(){this.Stock.select();}, this);
		return false;
	}
	
	if (!this.Weight.value.match(/^\d+(\.\d+)?$/))
	{
		Alert(_lang_weight_incorrect, function(){this.Weight.select();}, this);
		return false;
	}
	
	if (!this.MarketPrice.value.match(/^\d+(\.\d+)?$/))
	{
		Alert(_lang_market_price_incorrect, function(){this.MarketPrice.select();}, this);
		return false;
	}
	
	if (!this.SalePrice.value.match(/^\d+(\.\d+)?$/))
	{
		Alert(_lang_sale_price_incorrect, function(){this.SalePrice.select();}, this);
		return false;
	}
	
	if (!this.CostPrice.value.match(/^\d+(\.\d+)?$/))
	{
		Alert(_lang_cost_price_incorrect, function(){this.CostPrice.select();}, this);
		return false;
	}

	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_picture_type_must_be + this.PictureAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Thumbnail.value, this.ThumbnailAllowedType.value))
	{
		Alert(_lang_thumbnail_type_must_be + this.ThumbnailAllowedType.value, function(){this.Thumbnail.select();}, this);
		return false;
	}
	
	if (!this.HitCount.value.match(/^\d+$/))
	{
		Alert(_lang_hitcount_incorrect, function(){this.HitCount.select();}, this);
		return false;
	}

	if (!this.Up.value.match(/^\d+$/))
	{
		Alert(_lang_up_incorrect, function(){this.Up.select();}, this);
		return false;
	}

	if (!this.Down.value.match(/^\d+$/))
	{
		Alert(_lang_down_incorrect, function(){this.Down.select();}, this);
		return false;
	}
	
	if (this.PageID.value == "")
	{
		Alert(_lang_pageid_empty, function(){this.PageID.select();}, this);
		return false;
	}

	if ($("#Promote")[0].checked)
	{
		if (!this.PromotePrice.value.match(/^\d+(\.\d+)?$/))
		{
			Alert(_lang_promote_price_incorrect, function(){this.PromotePrice.select();}, this);
			return false;
		}

		var dateTime = /^(\d{1,4})(-|\/)(\d{1,2})(-|\/)(\d{1,2})( (\d{1,2}):(\d{1,2}):(\d{1,2}))?$/;
		if (!dateTime.test(this.PromoteStart.value))
		{
			Alert(_lang_promote_start_incorrect, function(){this.PromoteStart.select();}, this);
			return false;
		}
		if (!dateTime.test(this.PromoteEnd.value))
		{
			Alert(_lang_promote_end_incorrect, function(){this.PromoteEnd.select();}, this);
			return false;
		}
	}

    var fail = false;
	
	$("#MemberPriceDiv input").each(function()
	{
		if (this.value == "")
			return;
			
		if (!this.value.match(/^\d+(\.\d+)?$/))
		{
			Alert(_lang_member_price_incorrect, function(){this.select();}, this);
			fail = true;
			return false;
		}
	});
	
	if (fail)
	    return false;
	
	if ($("#FileTR").css("display") == "")
	{
		if (!IsAllowedType(this.File.value, this.FileAllowedType.value))
		{
			Alert(_lang_file_type_must_be + this.FileAllowedType.value, function(){this.File.select();}, this);
			return false;
		}
	}
	
	var tag = PrepareTag();
	PrepareMemberPrice();
	PrepareRelatedGoods();

	var category = $("[name=CategoryID] option:selected");
	var type = $("[name=TypeID] option:selected");
	var unit = $("[name=UnitID] option:selected");
	var brand = $("[name=BrandID] option:selected");

	_uploadFile = false;
	
	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)
	pageID = pageID.replace(/\{YYYYMMDDhhmmss\}/g, FormatDate(_createTime, "YYYYMMDDhhmmss"));
	pageID = pageID.replace(/\{YYYY-MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY-MM-DD/hhmmss"));
	pageID = pageID.replace(/\{YYYY\/MM\/DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM/DD/hhmmss"));
	pageID = pageID.replace(/\{YYYY\/MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM-DD/hhmmss"));
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&Number=" + (this.Number.value == "" ? FormatDate(new Date(), "YYYYMMDDhhmmssSSS") : this.Number.value);
	data += "&CategoryID=" + category.val();
	data += "&CategoryInnerID=" + category.attr("innerID");
	data += "&CategoryName=" + encodeURIComponent(category.attr("name"));
	data += "&TypeID=" + type.val();
	data += "&Kind=" + type.attr("kind");
	data += "&UnitID=" + unit.val();
	data += "&UnitName=" + encodeURIComponent(unit.attr("name"));
	data += "&BrandID=" + brand.val();
	data += "&BrandInnerID=" + brand.attr("innerID");
	data += "&BrandName=" + encodeURIComponent(brand.attr("name"));
	data += "&Stock=" + this.Stock.value;
	data += "&Weight=" + this.Weight.value;
	data += "&MarketPrice=" + this.MarketPrice.value;
	data += "&SalePrice=" + this.SalePrice.value;
	data += "&CostPrice=" + this.CostPrice.value;
	data += "&HasSpec=" + $("#HasSpec")[0].checked;
	data += "&Promote=" + $("#Promote")[0].checked;
	if ($("#Promote")[0].checked)
	{
		data += "&PromotePrice=" + this.PromotePrice.value;
		data += "&PromoteStart=" + this.PromoteStart.value;
		data += "&PromoteEnd=" + this.PromoteEnd.value;
	}
	if (type.attr("kind") == "File")
	{
		_uploadFile = _uploader.NeedUpload("File");
		if (!_uploadFile)
			data += "&File=" + encodeURIComponent(this.File.value);
	}
	data += "&Introduction=" + encodeURIComponent(this.Introduction.value);
	data += "&IsReleased=" + this.IsReleased.checked;
	data += "&OnlyAsPart=" + this.OnlyAsPart.checked;
	if (_recommend == 0 || !$("#IsRecommended")[0].checked)
		data += "&IsRecommended=" + $("#IsRecommended")[0].checked;
	if (_hold == 0 || !$("#IsHeld")[0].checked)
		data += "&IsHeld=" + $("#IsHeld")[0].checked;
	data += "&HitCount=" + this.HitCount.value;
	data += "&Up=" + this.Up.value;
	data += "&Down=" + this.Down.value;
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	data += "&TagNames=" + encodeURIComponent(tag.Names);
	data += "&TagPageGenerates=" + encodeURIComponent(tag.PageGenerates);
	data += "&TagPageTemplates=" + encodeURIComponent(tag.PageTemplates);
	data += "&TagPageIDs=" + encodeURIComponent(tag.PageIDs);
	data += "&TagPageExtensions=" + encodeURIComponent(tag.PageExtensions);
	data += "&UpdateTime=" + this.UpdateTime.value;
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(pageID);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if (this.MakeThumbnail.checked)
	{
		_uploadThumbnail = false;
	}
	else
	{
		_uploadThumbnail = _uploader.NeedUpload("Thumbnail");
		if (!_uploadThumbnail)
			data += "&Thumbnail=" + encodeURIComponent(this.Thumbnail.value);
	}
	
	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Goods&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			SetStatusMessage(_lang_modifying_tag);
			EditGoods_DeleteTag();
		}
	});
	
	return false;	
}

function EditGoods_DeleteTag()
{
	if (_tagDeleteIndex >= _tagDeleteList.length)
	{
		EditGoods_AddTag();
		return;
	}

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Goods.Tag&Operation=Delete&GoodsID=" + _guid + "&TagID=" + _tagDeleteList[_tagDeleteIndex++],
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditGoods_DeleteTag();
		}
	});
}

function EditGoods_AddTag()
{
	if (_tagAddIndex >= _tagAddList.length)
	{
		SetStatusMessage(_lang_modifying_member_price);
		EditGoods_DeleteMemberPrice();
		return;
	}
	
	var data = "GoodsID=" + _guid;
	data += "&TagID=" + _tagAddList[_tagAddIndex];
	
	_tagAddIndex++;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Goods.Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditGoods_AddTag();
		}
	});
}

function EditGoods_DeleteMemberPrice()
{
	if (_mpDeleteIndex >= _mpDeleteList.length)
	{
		EditGoods_SetMemberPrice();
		return;
	}

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=MemberPrice&Operation=Delete&GoodsID=" + _guid + "&RoleInnerID=" + _mpDeleteList[_mpDeleteIndex++].RoleInnerID,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditGoods_DeleteMemberPrice();
		}
	});
}

function EditGoods_SetMemberPrice()
{
	if (_mpSetIndex >= _mpSetList.length)
	{
		SetStatusMessage(_lang_modifying_related_goods);
		EditGoods_DeleteRelatedGoods();
		return;
	}
	
	var data = "GoodsID=" + _guid;
	data += "&RoleInnerID=" + _mpSetList[_mpSetIndex].RoleInnerID;
	data += "&Price=" + _mpSetList[_mpSetIndex].Price;
	
	_mpSetIndex++;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=MemberPrice&Operation=Set",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditGoods_SetMemberPrice();
		}
	});
}

function EditGoods_DeleteRelatedGoods()
{
	if (_rgDeleteIndex >= _rgDeleteList.length)
	{
		EditGoods_SetRelatedGoods();
		return;
	}

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Goods.RelatedGoods&Operation=Delete&MainID=" + _guid + "&RelatedID=" + _rgDeleteList[_rgDeleteIndex++].RelatedID,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditGoods_DeleteRelatedGoods();
		}
	});
}

function EditGoods_SetRelatedGoods()
{
	if (_rgSetIndex >= _rgSetList.length)
	{
		Goods_UploadFile();
		return;
	}
	
	var data = "MainID=" + _rgSetList[_rgSetIndex].MainID;
	data += "&RelatedID=" + _rgSetList[_rgSetIndex].RelatedID;
	data += "&Both=" + _rgSetList[_rgSetIndex].Both;
	
	_rgSetIndex++;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Goods.RelatedGoods&Operation=Set",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditGoods_SetRelatedGoods();
		}
	});
}

function Goods_UploadFile()
{
    if (!_uploadFile)
    {
        Goods_UploadPicture();
        return;
    }
    
    SetStatusMessage(_lang_start_upload_file);
    _uploader.Init({Status:_lang_uploading_file,Params:"Lang=" + _lang + "&Object=Goods&Operation=UploadFile&ID=" + _id});
    _uploader.Upload("File", function()
    {
        if (arguments.length == 2)
        {
            Alert(arguments[1]);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
        }
        else
        {
    		Goods_UploadPicture();
    	}
    });
}

function Goods_UploadPicture()
{
    if (!_uploadPicture)
    {
        Goods_UploadThumbnail();
        return;
    }

    SetStatusMessage(_lang_start_upload_picture);
    _uploader.Init({Status:_lang_uploading_picture,Params:"Lang=" + _lang + "&Object=Goods&Operation=UploadPicture&ID=" + _id + "&MakeThumbnail=" + $("#MakeThumbnail")[0].checked + "&AddWaterMark=" + $("#AddWaterMarkToPicture")[0].checked});
    _uploader.Upload("Picture", function()
    {
        if (arguments.length == 2)
        {
            Alert(arguments[1]);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
        }
        else
        {
    		Goods_UploadThumbnail();
    	}
    });
}

function Goods_UploadThumbnail()
{
    if (!_uploadThumbnail)
    {
	    Alert(_lang_operation_success);
	    SetStatusMessage();
	    $(":submit")[0].disabled = false;
        return;
    }   

    SetStatusMessage(_lang_start_upload_thumbnail);
    _uploader.Init({Status:_lang_uploading_thumbnail,Params:"Lang=" + _lang + "&Object=Goods&Operation=UploadThumbnail&ID=" + _id + "&AddWaterMark=" + $("#AddWaterMarkToThumbnail")[0].checked});
    _uploader.Upload("Thumbnail", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function PrepareMemberPrice()
{
	_mpSetIndex = 0;
	_mpDeleteIndex = 0;
	_mpSetList.length = 0;
	_mpDeleteList.length = 0;
	
	var inputs = $("#MemberPriceDiv input");
	
	inputs.each(function()
	{
		if (this.value == "")
		{
			var memberPrice = new Object();
			memberPrice.RoleInnerID = this.name.substr(2);
			_mpDeleteList[_mpDeleteList.length] = memberPrice;
		}
		else
		{
			var j = 0;
			for (; j < _memberPrices.length; j++)
			{
				if (this.name.substr(2) == _memberPrices[j].RoleInnerID && this.value == _memberPrices[j].Price)
					break;
			}
			
			if (j >= _memberPrices.length)
			{
				var memberPrice = new Object();
				memberPrice.RoleInnerID = this.name.substr(2);
				memberPrice.Price = encodeURIComponent(this.value);
				_mpSetList[_mpSetList.length] = memberPrice;
			}
		}
	});
	
	_memberPrices.length = 0;
	inputs.each(function()
	{
		if (this.value == "")
			return;
			
		var memberPrice = new Object();
		memberPrice.RoleInnerID = this.name.substr(2);
		memberPrice.Price = encodeURIComponent(this.value);
		_memberPrices[_memberPrices.length] = memberPrice;
	});
}

function PrepareRelatedGoods()
{
	_rgSetIndex = 0;
	_rgDeleteIndex = 0;
	_rgSetList.length = 0;
	_rgDeleteList.length = 0;
	
	var inputs = $("#RelatedGoodsTable input");
	for (var i = 0; i < inputs.length; i += 2)
	{
		if (!inputs[i].checked && inputs.eq(i + 1).attr("old") == "" || inputs[i].checked && inputs[i + 1].checked.toString() == inputs.eq(i + 1).attr("old").toLowerCase())
			continue;

		if (inputs[i].checked)
		{
			var goods = new Object();		
			if (inputs[i].disabled)
			{
				goods.MainID = inputs[i + 1].value;
				goods.RelatedID = inputs[i].value;
			}
			else
			{
				goods.MainID = _guid;
				goods.RelatedID = inputs[i].value;
			}
			goods.Both = inputs[i + 1].checked;
			_rgSetList[_rgSetList.length] = goods;
		}
		else
		{
			var goods = new Object();
			goods.RelatedID = inputs[i].value;
			_rgDeleteList[_rgDeleteList.length] = goods;
		}
	}
}

function EditCard()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.Content.value == "")
	{
		Alert(_lang_content_empty, function(){this.Content.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&Content=" + encodeURIComponent(this.Content.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Card&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function EditPart()
{
	if (!this.Min.value.match(/^\d+$/))
	{
		Alert(_lang_min_incorrect, function(){this.Min.select();}, this);
		return false;
	}
	
	if (!this.Max.value.match(/^\d+$/))
	{
		Alert(_lang_max_incorrect, function(){this.Max.select();}, this);
		return false;
	}
	
	if (this.IsDiscount.checked)
	{
		if (parseFloat(this.Amount.value) < 0 || parseFloat(this.Amount.value) > 1)
		{
			Alert(_lang_amount_incorrect, function(){this.Amount.select();}, this);
			return false;
		}
	}
	else
	{
		if (!this.Amount.value.match(/^\d+$/))
		{
			Alert(_lang_amount_incorrect, function(){this.Amount.select();}, this);
			return false;
		}
		
		if (parseFloat(this.Amount.value) > this.Price.value)
		{
			Alert(_lang_amount_exceed, function(){this.Amount.select();}, this);
			return false;
		}
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&Min=" + this.Min.value;
	data += "&Max=" + this.Max.value;
	data += "&IsDiscount=" + this.IsDiscount.checked;
	data += "&Amount=" + this.Amount.value;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Part&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function EditGoodsSpec()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!this.Stock.value.match(/^\d+$/))
	{
		Alert(_lang_stock_incorrect, function(){this.Stock.select();}, this);
		return false;
	}
	
	if (!this.Price.value.match(/^\d+(\.\d+)?$/))
	{
		Alert(_lang_sale_price_incorrect, function(){this.Price.select();}, this);
		return false;
	}
	
	if (!this.PromotePrice.value.match(/^\d+(\.\d+)?$/))
	{
		Alert(_lang_promote_price_incorrect, function(){this.PromotePrice.select();}, this);
		return false;
	}

	_memberPriceIndex = 0;
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&Stock=" + this.Stock.value;
	data += "&Price=" + this.Price.value;
	data += "&PromotePrice=" + this.PromotePrice.value;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Goods.Spec&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    EditGoodsSpec_ModifyMemberPrice();
		}
	});
	
	return false;	
}

function EditGoodsSpec_ModifyMemberPrice()
{
	if (_memberPrice != null && _memberPriceIndex >= _memberPrice.length)
	{
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
		return;
	}

    var url, data;
    if (_memberPrice[_memberPriceIndex].Price == "")
    {
        url = _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=MemberPrice&Operation=Delete&GoodsID=" + _goodsID + "&GoodsSpecID=" + _guid + "&RoleInnerID=" + _memberPrice[_memberPriceIndex++].RoleInnerID;
        data = {};
    }
	else
	{
        url = _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=MemberPrice&Operation=Set";
        data = "GoodsID=" + _goodsID + "&GoodsSpecID=" + _guid + "&RoleInnerID=" + _memberPrice[_memberPriceIndex].RoleInnerID + "&Price=" + _memberPrice[_memberPriceIndex++].Price;
    }

    $.ajax(
    {
	    url : url,
	    data : data,
	    type : "POST",
	    error : function(request)
	    {
		    Alert(_lang_operation_fail);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
	    },
	    success : function(data)
	    {
		    EditGoodsSpec_ModifyMemberPrice();
	    }
    });
}

function UpdateGoods(action, id)
{
	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdateGoods(action, id);}, this);
		else
			UpdateGoods(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Goods&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#List").html(HandleFake404(data, "text"));
				Init();
			}
		});
	}
}

function MoveGoods(from, to)
{
	if (from == to)
		return;
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Goods&Operation=" + g_action + "&From=" + from + "&To=" + to + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			Init();
		}
	});
}

function EditGoodsParameter()
{
    if (arguments.length > 0)
    {
	    _parameterIndex = 0;
	    _parameters.length = 0;
	    $(":text").each(function()
	    {
		    var parameter = new Object();
		    parameter.ID = this.id;
		    parameter.Value = encodeURIComponent(this.value);
		    _parameters[_parameters.length] = parameter;
	    });
    	
	    if (_parameters.length == 0)
		    return false;
	
    	SetStatusMessage(_lang_working);
		$(":submit")[0].disabled = true;
    }
    
    if (_parameterIndex >= _parameters.length)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
		return false;
    }
    
    var data = "GoodsID=" + _goodsID;
    data += "&ParameterID=" + _parameters[_parameterIndex].ID;
    data += "&Value=" + _parameters[_parameterIndex].Value;
    
    _parameterIndex++;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Goods.Parameter&Operation=Set",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
		    EditGoodsParameter();
		}
	});
	
	return false;
}

function AddPart()
{
	if (this.SourceID.value == "")
	{
		Alert(_lang_select_part);
		return false;
	}
	
	if (!this.Min.value.match(/^\d+$/))
	{
		Alert(_lang_min_incorrect, function(){this.Min.select();}, this);
		return false;
	}
	
	if (!this.Max.value.match(/^\d+$/))
	{
		Alert(_lang_max_incorrect, function(){this.Max.select();}, this);
		return false;
	}
	
	if (this.IsDiscount.checked)
	{
		if (!this.Amount.value.match(/^(1|0|(0\.\d+))$/))
		{
			Alert(_lang_amount_incorrect, function(){this.Amount.select();}, this);
			return false;
		}
	}
	else
	{
		if (!form.Amount.value.match(/^\d+$/))
		{
			Alert(_lang_amount_incorrect, function(){this.Amount.select();}, this);
			return false;
		}
		
		if (parseInt(this.Amount.value) > this.Price.value)
		{
			Alert(_lang_amount_exceed, function(){this.Amount.select();}, this);
			return false;
		}
	}
	
	var data = "GoodsID=" + _goodsID;
	data += "&SourceID=" + this.SourceID.value;
	data += "&SourceSpecID=" + this.SourceSpecID.value;
	data += "&Number=" + encodeURIComponent(this.Number.value);
	data += "&Name=" + encodeURIComponent(this.Name.value);
	data += "&Price=" + this.Price.value;
	data += "&Min=" + this.Min.value;
	data += "&Max=" + this.Max.value;
	data += "&IsDiscount=" + this.IsDiscount.checked;
	data += "&Amount=" + this.Amount.value;
	
	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Part&Operation=Add&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
        	$(":submit")[0].disabled = false;

			$("#List").html(HandleFake404(data, "text"));
			Init();
		}
	});
	
	return false;
}

function DeletePart(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Part&Operation=Delete&ID=" + id + "&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			Init();
		}
	});
}

function AddGoodsPicture()
{
	if (this.Picture.value == "")
	{
		Alert(_lang_select_picture);
		return false;
	}

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	if (_uploader.NeedUpload("Picture"))
	{
	    _uploader.Init({Status:_lang_uploading,Params:"Lang=" + _lang + "&Object=Goods.Pictures&Operation=Upload&GoodsID=" + _goodsID + "&GoodsInnerID=" + _goodsInnerID + "&AddWaterMark=" + $("#AddWaterMark")[0].checked});
	    _uploader.Upload("Picture", function()
	    {
	        $.ajax(
	        {
		        url : BuildAjaxPath(),
		        data : {},
		        type : "POST",
		        error : function(request)
		        {
			        Alert(_lang_operation_fail);
			        SetStatusMessage();
		        },
		        success : function(data)
		        {
			        Alert(_lang_operation_success);
			        SetStatusMessage();
        			
			        $("#List").html(HandleFake404(data, "text"));
                    Init();
		        }
	        });	    
	    });	
	}
	else
	{
		var data = "GoodsID=" + _goodsID;
		data += "&URL=" + encodeURIComponent(this.Picture.value);
		
	    $.ajax(
	    {
		    url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Goods.Pictures&Operation=Add&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		    data : data,
		    type : "POST",
		    error : function(request)
		    {
			    Alert(_lang_operation_fail);
			    SetStatusMessage();
		    },
		    success : function(data)
		    {
			    Alert(_lang_operation_success);
			    SetStatusMessage();

			    $("#List").html(HandleFake404(data, "text"));
			    Init();
		    }
	    });		
	}
	
	return false;
}

function DeleteGoodsPicture(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Goods.Pictures&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#" + id).html("<span style='color:#333'>已删除</span>");
		}
	});
}

function EditGoodsProperty()
{
    if (arguments.length > 0)
    {
	    _valueIndex = 0;
	    _values.length = 0;
	    for (var i = 0; i < _properties.length; i++)
	    {
		    var value = new Object();
		    value.PropertyID = _properties[i].ID;
		    value.OptionInnerIDs = "";
		    value.Value = "";
    		
		    var name = "P" + _properties[i].InnerID;
		    var control = _properties[i].Control;
		    if (control == "CheckBox" || control == "Radio")
		    {
			    $("[name=" + name + "]:checked").each(function()
			    {
				    if (control == "Radio")
				    {
					    value.Value = this.value;
					    value.OptionInnerIDs = this.id.substr(1);
					    return;
				    }
    				
				    if (value.Value == "")
				    {
					    value.OptionInnerIDs = "|";
					    value.Value = "|";
				    }
				    value.OptionInnerIDs += this.id.substr(1) + "|";
				    value.Value += this.value + "|";
			    });
    			
			    if (value.Value != "")
				    _values[_values.length] = value;
		    }
		    else if (control == "Select" || control == "List")
		    {
			    var menu = eval("document.forms[0]." + name);
			    if (menu.selectedIndex != -1)
			    {
				    value.Value = menu.options[menu.selectedIndex].text;
				    value.OptionInnerIDs = menu.options[menu.selectedIndex].value;
				    _values[_values.length] = value;
			    }
		    }
		    else
		    {
			    value.Value = eval("document.forms[0]." + name).value;
			    _values[_values.length] = value;
		    }
	    }
    	
	    if (_values.length == 0)
		    return false;
	
    	SetStatusMessage(_lang_working);
		$(":submit")[0].disabled = true;
    }
    
    if (_valueIndex >= _values.length)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
		return false;
    }
	
	var data = "GoodsID=" + _goodsID;
	data += "&PropertyID=" + _values[_valueIndex].PropertyID;
	data += "&OptionInnerIDs=" + _values[_valueIndex].OptionInnerIDs;
	data += "&Value=" + _values[_valueIndex].Value;
	
	_valueIndex++;
	
	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Goods.Property&Operation=Set",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
        	$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    EditGoodsProperty();
		}
	});
	
	return false;
}

function ReplaceGoods()
{
	if (this.From.type == "text" && this.From.value == "")
	{
		Alert(_lang_from_empty, function(){this.From.select();}, this);
		return false;
	}
	
	var data = "Property=" + this.Property.value;
	data += "&From=" + encodeURIComponent(this.From.value);
	data += "&To=" + encodeURIComponent(this.To.value);
	
	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Goods&Operation=Replace",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
        	$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function Property_OnChange()
{
    switch (this.value)
    {
        case "CategoryID":
            SetStatusMessage(_lang_working);
        	
            $.ajax(
            {
                url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=GoodsCategory&Operation=List",
                type : "GET",
                error : function(request)
                {
	                Alert(_lang_operation_fail);
	                SetStatusMessage();
                },
                success : function(data)
                {
	                _xmlDoc.loadXML(data);
	                var childNodes = _xmlDoc.documentElement.childNodes;
        			
	                var from = "<select name=\"From\" class=\"" + _lang + "Font\">";
	                var to = "<select name=\"To\" class=\"" + _lang + "Font\">";
	                for (var i = 0; i < childNodes.length; i++)
	                {
						if (typeof (childNodes[i].selectSingleNode) == "undefined")
							continue;
						
	                    var id = childNodes[i].selectSingleNode(IlgharCMS.ShopModule.GoodsCategory.ID).text;
	                    var name = childNodes[i].selectSingleNode(IlgharCMS.ShopModule.GoodsCategory.Name).text;
		                var option = "<option value=\"" + id + "\">" + name + "</option>";
		                from += option;
		                to += option;
	                }
	                from += "</select>";
	                to += "</select>";
        			
	                $("#FromTd").html(from);
	                $("#ToTd").html(to);
	                SetStatusMessage();
                }
            });
	        break;
        case "Name":
        case "Description":
	        $("#FromTd").html("<input type=\"text\" name=\"From\" class=\"Text " + _lang + "Font\" />");
	        $("#ToTd").html("<input type=\"text\" name=\"To\" class=\"Text " + _lang + "Font\" />");
	        break;
        default:
	        $("#FromTd").html("<input type=\"text\" name=\"From\" size=\"40\" class=\"Text\" />");
	        $("#ToTd").html("<input type=\"text\" name=\"To\" size=\"40\" class=\"Text\" />");
	        break;
    }
}

function AddGoodsSpec()
{
	if (_specs.length == 0)
	{
		Alert(_lang_no_spec);
		return false;
	}
	
	if (!this.Stock.value.match(/^\d+$/))
	{
		Alert(_lang_stock_incorrect, function(){this.Stock.select();}, this);
		return false;
	}
	
	if (!this.Price.value.match(/^\d+(\.\d+)?$/))
	{
		Alert(_lang_sale_price_incorrect, function(){this.Price.select();}, this);
		return false;
	}
	
	if (!this.PromotePrice.value.match(/^\d+(\.\d+)?$/))
	{
		Alert(_lang_promote_price_incorrect, function(){this.PromotePrice.select();}, this);
		return false;
	}

	if (_memberPrice != null)
	{
		var memberPrice = new Array();
		for (var i = 0; i < _memberPrice.length; i++)
		{
			if (_memberPrice.Price == "")
				continue;
			
			memberPrice[memberPrice.length] = _memberPrice[i];
		}
		_memberPrice = memberPrice;
	}
	
	var number = (this.Number.value == "" ? FormatDate(new Date(), "YYYYMMDDhhmmssSSS") : this.Number.value);
	var stock = this.Stock.value;
	var price = this.Price.value;
	var promotePrice = this.PromotePrice.value;
	var memberPrice = new Array();
	var name = "";
	var specInnerIDs = "";
	var specNames = "";
	var valueInnerIDs = "";
	var valueNames = "";
	for (var i = 0; i < _specs.length; i++)
	{
		var list = document.getElementById("Spec" + _specs[i].ID);
		if (list == null || list.selectedIndex == 0)
			continue;
		
		var option = list[list.selectedIndex];
		
		if (name != "")
			name += " , ";
		name += option.text;
		
		if (specInnerIDs == "")
		{
			specInnerIDs = "|";
			specNames = "|";
			valueInnerIDs = "|";
			valueNames = "|";
		}
		specInnerIDs += _specs[i].ID + "|";
		specNames += _specs[i].Name + "|";
		valueInnerIDs += option.value + "|";
		valueNames += option.text + "|";
	}
	
	if (name == "")
	{
		Alert(_lang_select_spec);
		return false;
	}
	
	for (var i = 0; i < _goodsSpecs.length; i++)
	{
		if (_goodsSpecs[i].SpecInnerIDs == specInnerIDs && _goodsSpecs[i].ValueInnerIDs == valueInnerIDs)
		{
			Alert(_lang_spec_exist);
			return false;
		}
	}
	
	_memberPriceIndex = 0;
	
	var data = "GoodsID=" + _goodsID;
	data += "&Number=" + number;
	data += "&Name=" + encodeURIComponent(name);
	data += "&Stock=" + stock;
	data += "&Price=" + price;
	data += "&PromotePrice=" + promotePrice;
	data += "&SpecInnerIDs=" + specInnerIDs;
	data += "&SpecNames=" + encodeURIComponent(specNames);
	data += "&ValueInnerIDs=" + valueInnerIDs;
	data += "&ValueNames=" + encodeURIComponent(valueNames);
	
	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Goods.Spec&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
        	$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
	        AddGoodsSpec_AddMemberPrice();
		}
	});
	
	return false;
}

function AddGoodsSpec_AddMemberPrice()
{
	if (_memberPrice == null || _memberPriceIndex >= _memberPrice.length)
	{
	    $.ajax(
	    {
		    url : BuildAjaxPath(),
		    type : "POST",
		    error : function(request)
		    {
			    Alert(_lang_operation_fail);
			    SetStatusMessage();
		    },
		    success : function(data)
		    {
	            Alert(_lang_operation_success);
	            SetStatusMessage();
	            $(":submit")[0].disabled = false;

			    $("#List").html(HandleFake404(data, "text"));
			    Init();
		    }
	    });
		return;
	}
	
	var data = "GoodsID=" + _goodsID;
	data += "&GoodsSpecID=" + _goodsSpecID;
	data += "&RoleInnerID=" + _memberPrice[_memberPriceIndex].RoleInnerID;
	data += "&Price=" + _memberPrice[_memberPriceIndex].Price;
	
	_memberPriceIndex++;

    SetStatusMessage(_lang_adding_member_price);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=MemberPrice&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			AddGoodsSpec_AddMemberPrice();
		}
	});
}

function DeleteGoodsSpec(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Goods.Spec&Operation=Delete&ID=" + id + "&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			Init();
		}
	});
}
//End : 商品管理
//-------------------------------------------------

function Init()
{
	if (typeof (_page) == "undefined")
		return;
	
	if (_page == "brand_list")
	{
		$("tr").each(function()
		{
			var id = $(this).attr("id");
			
			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteBrand(id);}, this);
				return false;
			});
		});
	}
	else if (_page == "brand_add")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Logo", "LogoTextbox", "LogoBrowse");
		
		$("form").eq(0).submit(AddBrand);
		$("#LogoTextbox").change(function(){$("#LogoView").attr("src", this.value)});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "brand_edit")
	{
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;

		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Logo", "LogoTextbox", "LogoBrowse");
		
		$("form").eq(0).submit(EditBrand);
		$("#LogoTextbox").change(function(){$("#LogoView").attr("src", this.value)});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "comment_list")
	{
		MakeButton();

		if (arguments.length == 0)
		    return;

		$("#IsChecked").change(Search);
		$("#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
		$("#Delete").click(function(){UpdateComment("Delete");});
	}
	else if (_page == "comment_edit")
	{
		$("form").eq(0).submit(EditComment);
	}
	else if (_page == "config_basic")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Goods", "GoodsTextbox", "GoodsBrowse");

		$("form").eq(0).submit(SetBasicSettings);
		$("#CreateAllGoodsThumbnail").click(CreateAllGoodsThumbnail);
		$("#GoodsTextbox").change(function(){$("#GoodsDefaultThumbnailView").attr("src", this.value)});
	}
	else if (_page == "config_discount")
	{
		$("form").each(function()
		{
			var id = this.action;
			$(this).submit(function(){SetDiscount(this, id);return false;});
		});
	}
	else if (_page == "delivery_list")
	{
		$("tr").each(function()
		{
			var id = $(this).attr("id");
			
			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteDelivery(id);}, this);
				return false;
			});
		});
	}
	else if (_page == "goods_category_add")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
		
		$("form").eq(0).submit(AddGoodsCategory);
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "goods_category_edit")
	{
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;

		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
		
		$("form").eq(0).submit(EditGoodsCategory);
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "goods_category_list")
	{
	    MakeButton();

	    $("tr").each(function ()
		{
			var id = $(this).attr("ItemID");
			
			$(this).find("form").submit(function(){ModifyGoodsCategory(this, id);return false;});
			$(this).find("[sort=" + id + "]").mouseover(function(){this.className += " Move_MouseOver";}).mouseout(function(){this.className="Move";});

			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteGoodsCategory(id);}, this);
				return false;
			});
		});
		
		if (arguments.length == 0)
		    return;

		InitMove(null,"Move", null, MoveGoodsCategory);
		
		$("#IsDisplay,#IsRecommended,#IsHeld,#Sort").change(Search);
	}
	else if (_page == "order_add")
	{
		$("form").eq(0).submit(AddOrder);
		$("#MemberSelect").click(function(){ShowSelectDialog("Member")});
		$("#GoodsSelect").click(function(){ShowSelectDialog("Goods")});
		$("[name=NeedInvoice]").click(OrderAdd_Compute);
		$("[name=PriceAdjustment]").change(OrderAdd_Compute);
		$("[name=PaymentID]").change(PaymentID_OnChange);
		$("[name=DeliveryID]").change(DeliveryID_OnChange);
		$("[name=RegionID]").change(RegionID_OnChange);
		$("[name=DeliveryProtect]").click(DeliveryProtect_OnClick);
		$("#GoodsAdd").click(OrderAdd_AddGoods);
		PaymentID_OnChange();
	}
	else if (_page == "order_delivery")
	{
		$("tr").each(function()
		{
			var row = this;
			var id = this.id;
			
			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete,
						function(returnValue)
						{
							if (!returnValue)
								return;
							
							SetStatusMessage(_lang_working);
						
							$.ajax(
							{
								url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Delivery&Operation=Delete&ID=" + id,
								data : {},
								type : "POST",
								error : function(request)
								{
									Alert(_lang_operation_fail);
									SetStatusMessage();
								},
								success : function(data)
								{
									Alert(_lang_operation_success);
									SetStatusMessage();
						
									$("#" + id).remove();
								}
							});
						},
						this
						);
				return false;
			});
		});
	}
	else if (_page == "order_detail")
	{
		$(".ToolBar form").submit(OrderDetail_Add);
		$("#GoodsSelect").click(function(){ShowSelectDialog("Goods")});

		$("table form").each(function()
		{
			var id = this.action;

			$(this).submit(OrderDetail_Modify);

			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)OrderDetail_Delete(id);}, this);
				return false;
			});
		});
	}
	else if (_page == "order_edit")
	{
		$("form").eq(0).submit(EditOrder);
		$("#MemberSelect").click(function(){ShowSelectDialog("Member")});
		$("[name=NeedInvoice]").click(OrderEdit_Compute);
		$("[name=PriceAdjustment]").change(OrderEdit_Compute);
		$("[name=PaymentID]").change(PaymentID_OnChange);
		$("[name=DeliveryID]").change(DeliveryID_OnChange);
		$("[name=RegionID]").change(RegionID_OnChange);
		$("[name=DeliveryProtect]").click(DeliveryProtect_OnClick);
		
		DeliveryID_OnChange();
		PaymentID_OnChange();
	}
	else if (_page == "order_feedback")
	{
		$("form").submit(AddFeedBack);
	}
	else if (_page == "order_file")
	{
		$("tr").each(function()
		{
			var id = this.id;
			
			$(this).find(":checkbox").click(function()
			{
				if (this.checked)
					$("#FileSpan" + id).css("display", "none");
				else
					$("#FileSpan" + id).css("display", "");
			});

			$(this).find("span :button").click(function(){ShowSelectFileDialog(id);});

			$(this).find("td:last :button").click(function(){SetFile(id);});
		});
		
		if (arguments.length == 0)
		    return;

		$("#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
	}
	else if (_page == "order_list")
	{
		$("#List :button").click(function()
		{
			var index = this.id.indexOf("_");
			if (index == -1)
				return;
			
			var action = this.id.substr(0, index);

			if (action == "Confirm")
				ConfirmOrder(this.id.substr(index + 1));
			else if (action == "Archive")
				ArchiveOrder(this.id.substr(index + 1));
			else if (action == "Cancel")
				CancelOrder(this.id.substr(index + 1));
			else if (action == "Delete")
				DeleteOrder(this.id.substr(index + 1));
			else
				ShowActionDialog(this.id.substr(index + 1), action);
		});
		
		if (arguments.length == 0)
		    return;

		$("#State").change(Search);
		$("#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
	}
	else if (_page == "make_delivery")
	{
		$("form").submit(MakeDelivery);
		
		$("tr").each(function()
		{
			var id = this.id;
			
			$(this).find(":checkbox").click(function()
			{
				if (this.checked)
					$("#FileSpan" + id).css("display", "none");
				else
					$("#FileSpan" + id).css("display", "");
			});

			$(this).find("span :button").click(function(){ShowSelectFileDialog(id);});
		});
	}
	else if (_page == "make_payment")
	{
		$("form").submit(MakePayment);
	}
	else if (_page == "make_refund")
	{
		$("form").submit(MakeRefund);
	}
	else if (_page == "make_return")
	{
		$("form").submit(MakeReturn);
	}
	else if (_page == "order_payment")
	{
		$("tr").each(function()
		{
			var row = this;
			var id = this.id;
			
			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete,
						function(returnValue)
						{
							if (!returnValue)
								return;
							
							SetStatusMessage(_lang_working);
						
							$.ajax(
							{
								url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Payment&Operation=Delete&ID=" + id,
								data : {},
								type : "POST",
								error : function(request)
								{
									Alert(_lang_operation_fail);
									SetStatusMessage();
								},
								success : function(data)
								{
									Alert(_lang_operation_success);
									SetStatusMessage();
						
									$("#" + id).remove();
								}
							});
						},
						this
						);
				return false;
			});
		});
	}
	else if (_page == "order_refund")
	{
		$("tr").each(function()
		{
			var row = this;
			var id = this.id;
			
			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete,
						function(returnValue)
						{
							if (!returnValue)
								return;
							
							SetStatusMessage(_lang_working);
						
							$.ajax(
							{
								url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Refund&Operation=Delete&ID=" + id,
								data : {},
								type : "POST",
								error : function(request)
								{
									Alert(_lang_operation_fail);
									SetStatusMessage();
								},
								success : function(data)
								{
									Alert(_lang_operation_success);
									SetStatusMessage();
						
									$("#" + id).remove();
								}
							});
						},
						this
						);
				return false;
			});
		});
	}
	else if (_page == "order_return")
	{
		$("tr").each(function()
		{
			var row = this;
			var id = this.id;
			
			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete,
						function(returnValue)
						{
							if (!returnValue)
								return;
							
							SetStatusMessage(_lang_working);
						
							$.ajax(
							{
								url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Return&Operation=Delete&ID=" + id,
								data : {},
								type : "POST",
								error : function(request)
								{
									Alert(_lang_operation_fail);
									SetStatusMessage();
								},
								success : function(data)
								{
									Alert(_lang_operation_success);
									SetStatusMessage();
						
									$("#" + id).remove();
								}
							});
						},
						this
						);
				return false;
			});
		});
	}
	else if (_page == "order_select_goods")
	{
		$("#List a").click(function()
		{
	        if ($.browser.msie)
				window.dialogArguments.SelectGoods(this);
			else
				window.opener.SelectGoods(this);
			window.close();
			return false;
		});
		
		if (arguments.length == 0)
		    return;

		$("#Sort").change(Search);
		$("#CategoryID").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
	}
	else if (_page == "order_select_member")
	{
		$("#List a").click(function()
		{
			var id = $(this).attr("ID");
			var name = $(this).attr("Name");
			
	        if ($.browser.msie)
				window.dialogArguments.SelectGoods(id, name);
			else
				window.opener.SelectGoods(id, name);
			window.close();
			return false;
		});
		
		if (arguments.length == 0)
		    return;

		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
	}
	else if (_page == "order_view")
	{
		$("DeliveryFeeTD").html(ComputeDeliveryFee(_deliveryFee, _price, _weight));
	}
	else if (_page == "payment_list")
	{
		$("tr").each(function()
		{
			var id = $(this).attr("id");
			
			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeletePayment(id);}, this);
				return false;
			});
		});
	}
	else if (_page == "refund_list")
	{
		$("tr").each(function()
		{
			var id = $(this).attr("id");
			
			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteRefund(id);}, this);
				return false;
			});
		});
	}
	else if (_page == "return_list")
	{
		$("tr").each(function()
		{
			var id = $(this).attr("id");
			
			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteReturn(id);}, this);
				return false;
			});
		});
	}
	else if (_page == "spec_list")
	{
		$("tr").each(function()
		{
			var id = $(this).attr("id");
			
			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteSpec(id);}, this);
				return false;
			});
		});
	}
	else if (_page == "spec_add")
	{
		$("form").submit(AddSpec);
	}
	else if (_page == "spec_edit")
	{
		$("form").submit(EditSpec);
	}
	else if (_page == "spec_select")
	{
		$(":checkbox").click(function()
		{
			$(this).click(function()
			{
				var spec = new Object();
				spec.ID = $(this).attr("ID");
				spec.Name = $(this).attr("Name");
				spec.Options = new Array();
				
				$("#O" + spec.ID + " option:selected").each(function()
				{
					spec.Options[spec.Options.length] = new Object();
					spec.Options[spec.Options.length - 1].ID = this.value;
					spec.Options[spec.Options.length - 1].Name = this.text;
				});
				
				if (this.checked && spec.Options.length == 0)
				{
					Alert(_lang_no_selection);
					return;
				}
				
	            if ($.browser.msie)
					window.dialogArguments.SelectSpec(spec, this.checked);
				else
					window.opener.SelectSpec(spec, this.checked);
			});
		});
		
		if (arguments.length == 0)
		    return;

		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#Ok").click(function(){window.close();});
	}
	else if (_page == "spec_option_list")
	{
		$("table form").each(function()
		{
			var id = this.action;

			$(this).submit(function(){ModifySpecOption(this, id)});

			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteSpecOption(id);}, this);
				return false;
			});
		});

		if (arguments.length == 0)
		    return;

		$(".ToolBar form").submit(AddSpecOption);
	}
	else if (_page == "spec_option_edit")
	{
		$("form").submit(EditSpecOption);
	}
	else if (_page == "tag_list")
	{
		$("form").each(function()
		{
			var id = this.action;

			$(this).submit(function(){return ModifyTag(this, id)});
		});		

		if (arguments.length == 0)
		    return;

		$("#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
		$("#Delete").click(function(){DeleteTag();});
	}
	else if (_page == "tag_select")
	{
		$(":checkbox").click(function()
		{
	        if ($.browser.msie)
				window.dialogArguments.SelectTag({ID:$(this).attr("ID"),Name:$(this).attr("Name"),PageGenerate:$(this).attr("PageGenerate"),PageTemplate:$(this).attr("PageTemplate"),PageID:$(this).attr("PageID"),PageExtension:$(this).attr("PageExtension")}, this.checked);
			else
				window.opener.SelectTag({ID:$(this).attr("ID"),Name:$(this).attr("Name"),PageGenerate:$(this).attr("PageGenerate"),PageTemplate:$(this).attr("PageTemplate"),PageID:$(this).attr("PageID"),PageExtension:$(this).attr("PageExtension")}, this.checked);
		});
		
		if (arguments.length == 0)
		    return;

		$("#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#Ok").click(function(){window.close();});
	}
	else if (_page == "tag_add")
	{
		$("form").submit(AddTag);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "tag_edit")
	{
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;

		$("form").submit(EditTag);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "type_list")
	{
		$("tr").each(function()
		{
			var id = $(this).attr("id");
			
			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteType(id);}, this);
				return false;
			});
		});
	}
	else if (_page == "type_add")
	{
		$("form").submit(AddType);
	}
	else if (_page == "type_edit")
	{
		$("form").submit(EditType);
		
		CheckAndSelect($("[name=Kind]")[0], _kind);
	}
	else if (_page == "parameter_group_list")
	{
		$("tr").each(function()
		{
			var id = this.id;
			
			$(this).find("form").submit(function(){ModifyParameterGroup(this, id);return false;});
			$(this).find("[sort=" + id + "]").mouseover(function(){this.className += " Move_MouseOver";}).mouseout(function(){this.className="Move";});

			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteParameterGroup(id);}, this);
				return false;
			});
		});
		
		if (arguments.length == 0)
		    return;

		InitMove(null,"Move", null, MoveParameterGroup);
		
		$(".ToolBar form").submit(AddParameterGroup);		
	}
	else if (_page == "parameter_group_edit")
	{
		$("form").submit(EditParameterGroup);
	}
	else if (_page == "parameter_list")
	{
		$("tr").each(function()
		{
			var id = this.id;
			
			$(this).find("form").submit(function(){ModifyParameter(this, id);return false;});
			$(this).find("[sort=" + id + "]").mouseover(function(){this.className += " Move_MouseOver";}).mouseout(function(){this.className="Move";});

			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteParameter(id);}, this);
				return false;
			});
		});
		
		if (arguments.length == 0)
		    return;

		InitMove(null,"Move", null, MoveParameter);
		
		$(".ToolBar form").submit(AddParameter);		
	}
	else if (_page == "parameter_edit")
	{
		$("form").submit(EditParameter);
	}
	else if (_page == "property_list")
	{
		$("tr").each(function()
		{
			var id = this.id;
			
			$(this).find("form").submit(function(){ModifyProperty(this, id);return false;});
			$(this).find("[sort=" + id + "]").mouseover(function(){this.className += " Move_MouseOver";}).mouseout(function(){this.className="Move";});

			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteProperty(id);}, this);
				return false;
			});
		});
		
		if (arguments.length == 0)
		    return;

		InitMove(null,"Move", null, MoveProperty);
		
		$(".ToolBar form").submit(AddProperty);		
	}
	else if (_page == "property_edit")
	{
		$("form").submit(EditProperty);
	}
	else if (_page == "property_option_list")
	{
		$("tr").each(function()
		{
			var id = this.id;

			$(this).find("form").submit(function(){ModifyPropertyOption(this, id);return false;});
			$(this).find("[sort=" + id + "]").mouseover(function(){this.className += " Move_MouseOver";}).mouseout(function(){this.className="Move";});

			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeletePropertyOption(id);}, this);
				return false;
			});
		});
		
		if (arguments.length == 0)
		    return;

		InitMove(null,"Move", null, MovePropertyOption);
		
		$(".ToolBar form").submit(AddPropertyOption);		
	}
	else if (_page == "property_option_edit")
	{
		$("form").submit(EditPropertyOption);
	}
	else if (_page == "unit_list")
	{
		$("tr").each(function()
		{
			var id = $(this).attr("id");
			
			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteUnit(id);}, this);
				return false;
			});
		});
	}
	else if (_page == "unit_add")
	{
		$("form").submit(AddUnit);
	}
	else if (_page == "unit_edit")
	{
		$("form").submit(EditUnit);
	}
	else if (_page == "goods_add")
	{
		var form = document.forms[0];
		_xmlProperty = CreateXmlDom();
		_xmlDoc = CreateXmlDom();
		_xmlParameterGroup = CreateXmlDom();
		
		CheckAndSelect(form.CategoryID, GetCookie("CategoryID"));
		CheckAndSelect(form.UnitID, GetCookie("UnitID"));
		CheckAndSelect(form.BrandID, GetCookie("BrandID"));

		var typeID = GetCookie("TypeID");
		if (typeID != "")
		{
			CheckAndSelect(form.TypeID, typeID);
			GoodsAdd_TypeID_OnChange();
		}

		var makeThumbnail = $("#MakeThumbnail")[0];
		if (GetCookie("MakeThumbnail") == "false")
			makeThumbnail.checked = false;
		else
			makeThumbnail.checked = true;
		$("#ThumbnailRow").css("display", makeThumbnail.checked ? "none" : "");
		$("#MakeThumbnail").click(function(){$("#ThumbnailRow").css("display", this.checked ? "none" : "");});
		
		$(form).eq(0).submit(AddGoods);
		$("[name=TypeID]").change(GoodsAdd_TypeID_OnChange);
		$("#HasSpec").click(EnableSpec);
		$("[name=SalePrice]").change(SalePrice_OnChange);
		$("#Promote").click(Promote_OnClick);
		$("#MemberPrice").click(MemberPrice_OnClick);
		$("#SpecTD input").click(function(){ShowSelectDialog("Spec")});
		$("#PartSelect").click(function(){ShowSelectDialog("Part")});
		$("#RelatedGoodsSelect").click(function(){ShowSelectDialog("RelatedGoods")});
		$("#TagSelect").click(function(){ShowSelectDialog("Tag")});
		$("#FileSelect").click(function(){ShowSelectFileDialog("File")});
		$("#PictureSelect").click(function(){ShowSelectFileDialog("Picture")});
		$("#ThumbnailSelect").click(function(){ShowSelectFileDialog("Thumbnail")});
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#ThumbnailTextbox").change(function(){$("#ThumbnailView").attr("src", this.value)});
		$("#MorePicture").click(AddMorePicture);
		$("#Card").click(AddCardToClient);
		$("#AddSpec").click(Goods_AddSpec);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
		
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
		_uploader.Add("Thumbnail", "ThumbnailTextbox", "ThumbnailBrowse");
		_uploader.Add("File", "FileTextbox", "FileBrowse");
	}
	else if (_page == "goods_card")
	{
		$("tr").each(function()
		{
			var id = $(this).attr("id");
			
			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteCard(id);}, this);
				return false;
			});
		});
		
		if (arguments.length == 0)
		    return;

		$("form").submit(AddCard);
	}
	else if (_page == "goods_description")
	{
		$("form").submit(EditGoodsDescription);
	}
	else if (_page == "goods_edit")
	{
        GoodsEdit_TypeID_OnChange();
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;
        
        if (_hasSpec == "True")
        {
	        $("#HasSpec").attr("checked", true);
	        EnableSpec();
        }
        
        for (var i = 0; i < _tags.length; i++)
        {
	        SelectTag(_tags[i], true);
        }
	
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
		_uploader.Add("Thumbnail", "ThumbnailTextbox", "ThumbnailBrowse");
		_uploader.Add("File", "FileTextbox", "FileBrowse");
	
		$("form").eq(0).submit(EditGoods);
		$("[name=TypeID]").change(GoodsEdit_TypeID_OnChange);
		$("#HasSpec").click(EnableSpec);
		$("[name=SalePrice]").change(SalePrice_OnChange);
		$("#Promote").click(Promote_OnClick);
		$("#MemberPrice").click(MemberPrice_OnClick);
		$("#FileSelect").click(function(){ShowSelectFileDialog("File")});
		$("#PictureSelect").click(function(){ShowSelectFileDialog("Picture")});
		$("#ThumbnailSelect").click(function(){ShowSelectFileDialog("Thumbnail")});
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#ThumbnailTextbox").change(function(){$("#ThumbnailView").attr("src", this.value)});
		$("#MakeThumbnail").click(function(){$("#ThumbnailRow").css("display", this.checked ? "none" : "");});
		$("#SetUpdateTime").click(function(){document.forms[0].UpdateTime.value = FormatDate(new Date(), 'YYYY-MM-DD hh:mm:ss');});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
		
		$("#Promote").click();
	}
	else if (_page == "card_edit")
	{
		$("form").submit(EditCard);
	}
	else if (_page == "part_edit")
	{
		$("form").submit(EditPart);
	}
	else if (_page == "goods_spec_edit")
	{
		$("form").submit(EditGoodsSpec);
		$("#MemberPrice").click(function(){ShowSelectDialog("SpecMemberPrice")});
	}
	else if (_page == "goods_list")
	{
		MakeButton();
		
		$("tr").each(function()
		{
			$(this).find("[sort=" + this.id + "]").mouseover(function(){this.className += " Move_MouseOver";}).mouseout(function(){this.className="Move";});
		});
    	
		if (arguments.length == 0)
		    return;

	    if (GetCookie("ListByPicture").toLowerCase() == "true")
		    $("#ListByPicture")[0].checked = true;	
	    else
		    $("#ListByPicture")[0].checked = false;
	
		InitMove(null, "Move", null, MoveGoods);
		
		$("#IsRecycled,#IsReleased,#IsHeld,#IsRecommended,#CategoryID,#Sort").change(Search);
		$("#IncludeSubCategory").click(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
		
		$("#ListByPicture").click(function()
		{
	        SetCookie("ListByPicture", $("#ListByPicture")[0].checked, 10*360*24*60);
	        Search();
		});
	}
	else if (_page == "goods_parameter")
	{
		$("form").submit(EditGoodsParameter);
	}
	else if (_page == "goods_part")
	{
		$("tr").each(function()
		{
			var id = $(this).attr("id");
			
			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeletePart(id);}, this);
				return false;
			});
		});
		
		if (arguments.length == 0)
		    return;

		$("form").submit(AddPart);
		$("#PartSelect").click(function(){ShowSelectDialog("Part")});
	}
	else if (_page == "goods_pictures")
	{
		$("#List li").each(function()
		{
			var id = $(this).attr("id");
			
			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteGoodsPicture(id);}, this);
				return false;
			});
		});
		
		if (arguments.length == 0)
		    return;

		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
	
		$("form").eq(0).submit(AddGoodsPicture);
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#PictureSelect").click(function(){ShowSelectFileDialog("Picture")});
	}
	else if (_page == "goods_property")
	{
		$("form").submit(EditGoodsProperty);
	}
	else if (_page == "goods_replace")
	{
		_xmlDoc = CreateXmlDom();

		$("form").submit(ReplaceGoods);
		$("[name=Property]").change(Property_OnChange);
	}
	else if (_page == "goods_select")
	{
		$(":checkbox").click(function()
		{
	        if ($.browser.msie)
				window.dialogArguments.SelectRelatedGoods($(this).attr("Name"), $(this).attr("Guid"), $(this).attr("ID"), this.checked);
			else
				window.opener.SelectRelatedGoods($(this).attr("Name"), $(this).attr("Guid"), $(this).attr("ID"), this.checked);
		});
		
		if (arguments.length == 0)
		    return;

		$("#Sort,#CategoryID").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#Ok").click(function(){window.close();});
	}
	else if (_page == "goods_select_part")
	{
		$(":checkbox,a").click(function()
		{
	        if ($.browser.msie)
				window.dialogArguments.SelectPart($(this).attr("Name"), $(this).attr("SourceID"), $(this).attr("SourceSpecID"), $(this).attr("Number"), $(this).attr("Price"), this.checked);
			else
				window.opener.SelectPart($(this).attr("Name"), $(this).attr("SourceID"), $(this).attr("SourceSpecID"), $(this).attr("Number"), $(this).attr("Price"), this.checked);
				
			if (_single == "True")
			    window.close();
		});
		
		if (arguments.length == 0)
		    return;

		$("#Sort,#CategoryID").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#Ok").click(function(){window.close();});
	}
	else if (_page == "goods_spec_member_price")
	{
        for (var i = 0; i < _memberPrice.length; i++)
        {
	        $("#MG" + _memberPrice[i].RoleInnerID).val(_memberPrice[i].Price);
        }

        $(":text").each(function()
        {
	        $("Span" + this.id.substr(2)).html(_price * parseInt($(this).attr("amount")) / 100);
        });
	
		$("#Ok").click(function()
		{
	        var result = new Array();
	        $(":text").each(function()
	        {
		        if (this.value != "" && !this.value.match(/^\d+(\.\d+)?$/))
		        {
			        Alert(_lang_price_incorrect, function(){this.select();}, this);
			        return;
		        }
        		
		        result[result.length] = new Object();
		        result[result.length - 1].RoleInnerID = inputs[i].id.substr(2);
		        result[result.length - 1].Price = inputs[i].value;
	        });
        	
	        if ($.browser.msie)
		        window.dialogArguments.SetSpecMemberPrice(_index, result);
	        else
		        window.opener.SetSpecMemberPrice(_index, result);
        	
	        window.close();
		});
	}
	else if (_page == "goods_spec")
	{
		$("tr").each(function()
		{
			var id = $(this).attr("id");
			
			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteGoodsSpec(id);}, this);
				return false;
			});
		});
		
		if (arguments.length == 0)
		    return;

		$("form").submit(AddGoodsSpec);
		$("#SpecSelect").click(function(){ShowSelectDialog("Spec")});
		$("#SpecMemberPrice").click(function(){ShowSelectDialog("SpecMemberPrice")});
	}
}
Init(true);