﻿function BuildHeader()
{
	if (_page == "music_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&IsRecycled=" + $("#IsRecycled").val() + "&IsChecked=" + $("#IsChecked").val() + "&IsRecommended=" + $("#IsRecommended").val() + "&IsHeld=" + $("#IsHeld").val() + "&NeedPack=" + $("#NeedPack").val() + "&RegionID=" + $("#RegionID").val() + "&IncludeSubRegion=" + $("#IncludeSubRegion")[0].checked + "&LanguageID=" + $("#LanguageID").val() + "&CategoryID=" + $("#CategoryID").val() + "&IncludeSubCategory=" + $("#IncludeSubCategory")[0].checked + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "company_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "music_comment_list" || _page == "album_comment_list" || _page == "person_comment_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&IsChecked=" + $("#IsChecked").val() + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "person_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&IsRecycled=" + $("#IsRecycled").val() + "&IsChecked=" + $("#IsChecked").val() + "&IsRecommended=" + $("#IsRecommended").val() + "&IsHeld=" + $("#IsHeld").val() + "&RegionID=" + $("#RegionID").val() + "&IncludeSubRegion=" + $("#IncludeSubRegion")[0].checked + "&LanguageID=" + $("#LanguageID").val() + "&SexID=" + $("#SexID").val() + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&ListByPicture=" + $("#ListByPicture")[0].checked + "&Page=" + _pageNumber;
	else if (_page == "tag_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "tag_select")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "person_select")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&RegionID=" + $("#RegionID").val() + "&IncludeSubRegion=" + $("#IncludeSubRegion")[0].checked + "&LanguageID=" + $("#LanguageID").val() + "&SexID=" + $("#SexID").val() + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "album_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&IsRecycled=" + $("#IsRecycled").val() + "&IsChecked=" + $("#IsChecked").val() + "&IsRecommended=" + $("#IsRecommended").val() + "&IsHeld=" + $("#IsHeld").val() + "&RegionID=" + $("#RegionID").val() + "&IncludeSubRegion=" + $("#IncludeSubRegion")[0].checked + "&LanguageID=" + $("#LanguageID").val() + "&CategoryID=" + $("#CategoryID").val() + "&IncludeSubCategory=" + $("#IncludeSubCategory")[0].checked + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&ListByPicture=" + $("#ListByPicture")[0].checked + "&Page=" + _pageNumber;
	else if (_page == "lyric_list" || _page == "title_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&IsRecycled=" + $("#IsRecycled").val() + "&IsChecked=" + $("#IsChecked").val() + "&IsRecommended=" + $("#IsRecommended").val() + "&IsHeld=" + $("#IsHeld").val() + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "music_select")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&RegionID=" + $("#RegionID").val() + "&IncludeSubRegion=" + $("#IncludeSubRegion")[0].checked + "&LanguageID=" + $("#LanguageID").val() + "&CategoryID=" + $("#CategoryID").val() + "&IncludeSubCategory=" + $("#IncludeSubCategory")[0].checked + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "album_select")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&RegionID=" + $("#RegionID").val() + "&IncludeSubRegion=" + $("#IncludeSubRegion")[0].checked + "&LanguageID=" + $("#LanguageID").val() + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "music_category_list" || _page == "album_category_list")
		return BuildAjaxPath(true) + "?Lang=" + _lang + "&IsDisplay=" + $("#IsDisplay").val() + "&IsRecommended=" + $("#IsRecommended").val() + "&IsHeld=" + $("#IsHeld").val() + "&Sort=" + $("#Sort").val();
	else
	    return BuildAjaxPath();
}

function Search()
{
	if (arguments.length > 0 && typeof(arguments[0]) != "object")
		_pageNumber = arguments[0];
	
	SetStatusMessage(_lang_working);
	$.ajax(
	{
		url : BuildHeader(),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
	        if (_page == "music_comment_list" || _page == "album_comment_list" || _page == "person_comment_list")
			    $("#RecordList").html(HandleFake404(data, "text"));
			else
			    $("#List").html(HandleFake404(data, "text"));
			Init();
			SetStatusMessage();

			if (typeof(SetupIme) == "function")
				SetupIme();
			
			if (_page == "music_list" || _page == "person_list" || _page == "album_list" || _page == "lyric_list" || _page == "title_list")
			{
		        var action = "";
		        if ($("#IsRecommended")[0].selectedIndex == 2 && ($("#Sort").val() == "5" || $("#Sort").val() == "6"))
			        action = "MoveRecommend";
		        else if ($("#IsHeld")[0].selectedIndex == 2 && ($("#Sort").val() == "7" || $("#Sort").val() == "8"))
			        action = "MoveHold";
		        if (action != "")
			        g_action = action;
			}
		}
	});
}

function MakeButton()
{
	var buttons = "";
	
	if (_page == "music_list")
	{
	    //回收
	    var obj = $("#IsRecycled")[0];
	    if (obj.selectedIndex == 1)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateMusic('Recycle')\" >" + _lang_recycle + "</button>";
	    }
	    else if (obj.selectedIndex == 2)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateMusic('Delete')\" >" + _lang_delete + "</button>";
		    buttons += "<button class=\"Button\" onclick=\"UpdateMusic('Recover')\" >" + _lang_recover + "</button>";
	    }
    	
	    //审核
	    var obj = $("#IsChecked")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateMusic('Check')\" >" + _lang_check + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateMusic('UnCheck')\" >" + _lang_uncheck + "</button>";
    	
	    //推荐
	    var obj = $("#IsRecommended")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateMusic('Recommend')\" >" + _lang_recommend + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateMusic('UnRecommend')\" >" + _lang_unrecommend + "</button>";
    	
	    //置顶
	    var obj = $("#IsHeld")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateMusic('Hold')\" >" + _lang_hold + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateMusic('UnHold')\" >" + _lang_unhold + "</button>";
	}
	else if (_page == "person_list")
	{
	    //回收
	    var obj = $("#IsRecycled")[0];
	    if (obj.selectedIndex == 1)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdatePerson('Recycle')\" >" + _lang_recycle + "</button>";
	    }
	    else if (obj.selectedIndex == 2)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdatePerson('Delete')\" >" + _lang_delete + "</button>";
		    buttons += "<button class=\"Button\" onclick=\"UpdatePerson('Recover')\" >" + _lang_recover + "</button>";
	    }
    	
	    //审核
	    var obj = $("#IsChecked")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdatePerson('Check')\" >" + _lang_check + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdatePerson('UnCheck')\" >" + _lang_uncheck + "</button>";
    	
	    //推荐
	    var obj = $("#IsRecommended")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdatePerson('Recommend')\" >" + _lang_recommend + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdatePerson('UnRecommend')\" >" + _lang_unrecommend + "</button>";
    	
	    //置顶
	    var obj = $("#IsHeld")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdatePerson('Hold')\" >" + _lang_hold + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdatePerson('UnHold')\" >" + _lang_unhold + "</button>";
	}
	else if (_page == "album_list")
	{
	    //回收
	    var obj = $("#IsRecycled")[0];
	    if (obj.selectedIndex == 1)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateAlbum('Recycle')\" >" + _lang_recycle + "</button>";
	    }
	    else if (obj.selectedIndex == 2)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateAlbum('Delete')\" >" + _lang_delete + "</button>";
		    buttons += "<button class=\"Button\" onclick=\"UpdateAlbum('Recover')\" >" + _lang_recover + "</button>";
	    }
    	
	    //审核
	    var obj = $("#IsChecked")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateAlbum('Check')\" >" + _lang_check + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateAlbum('UnCheck')\" >" + _lang_uncheck + "</button>";
    	
	    //推荐
	    var obj = $("#IsRecommended")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateAlbum('Recommend')\" >" + _lang_recommend + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateAlbum('UnRecommend')\" >" + _lang_unrecommend + "</button>";
    	
	    //置顶
	    var obj = $("#IsHeld")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateAlbum('Hold')\" >" + _lang_hold + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateAlbum('UnHold')\" >" + _lang_unhold + "</button>";
	}
	else if (_page == "lyric_list")
	{
	    //回收
	    var obj = $("#IsRecycled")[0];
	    if (obj.selectedIndex == 1)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateLyric('Recycle')\" >" + _lang_recycle + "</button>";
	    }
	    else if (obj.selectedIndex == 2)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateLyric('Delete')\" >" + _lang_delete + "</button>";
		    buttons += "<button class=\"Button\" onclick=\"UpdateLyric('Recover')\" >" + _lang_recover + "</button>";
	    }
    	
	    //审核
	    var obj = $("#IsChecked")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateLyric('Check')\" >" + _lang_check + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateLyric('UnCheck')\" >" + _lang_uncheck + "</button>";
    	
	    //推荐
	    var obj = $("#IsRecommended")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateLyric('Recommend')\" >" + _lang_recommend + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateLyric('UnRecommend')\" >" + _lang_unrecommend + "</button>";
    	
	    //置顶
	    var obj = $("#IsHeld")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateLyric('Hold')\" >" + _lang_hold + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateLyric('UnHold')\" >" + _lang_unhold + "</button>";
	}
	else if (_page == "title_list")
	{
	    //回收
	    var obj = $("#IsRecycled")[0];
	    if (obj.selectedIndex == 1)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateTitle('Recycle')\" >" + _lang_recycle + "</button>";
	    }
	    else if (obj.selectedIndex == 2)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateTitle('Delete')\" >" + _lang_delete + "</button>";
		    buttons += "<button class=\"Button\" onclick=\"UpdateTitle('Recover')\" >" + _lang_recover + "</button>";
	    }
    	
	    //审核
	    var obj = $("#IsChecked")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateTitle('Check')\" >" + _lang_check + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateTitle('UnCheck')\" >" + _lang_uncheck + "</button>";
    	
	    //推荐
	    var obj = $("#IsRecommended")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateTitle('Recommend')\" >" + _lang_recommend + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateTitle('UnRecommend')\" >" + _lang_unrecommend + "</button>";
    	
	    //置顶
	    var obj = $("#IsHeld")[0];
	    if (obj.selectedIndex == 1)
		    buttons += "<button class=\"Button\" onclick=\"UpdateTitle('Hold')\" >" + _lang_hold + "</button>";
	    else if (obj.selectedIndex == 2)
		    buttons += "<button class=\"Button\" onclick=\"UpdateTitle('UnHold')\" >" + _lang_unhold + "</button>";
	}
	else if (_page == "music_comment_list")
	{	
		if ($("#IsChecked")[0].selectedIndex == 1)
			buttons += "<button class=\"Button\" onclick=\"UpdateMusicComment('Check')\" >" + _lang_check + "</button>";
		else if ($("#IsChecked")[0].selectedIndex == 2)
			buttons += "<button class=\"Button\" onclick=\"UpdateMusicComment('UnCheck')\" >" + _lang_uncheck + "</button>";
	}
	else if (_page == "person_comment_list")
	{	
		if ($("#IsChecked")[0].selectedIndex == 1)
			buttons += "<button class=\"Button\" onclick=\"UpdatePersonComment('Check')\" >" + _lang_check + "</button>";
		else if ($("#IsChecked")[0].selectedIndex == 2)
			buttons += "<button class=\"Button\" onclick=\"UpdatePersonComment('UnCheck')\" >" + _lang_uncheck + "</button>";
	}
	else if (_page == "album_comment_list")
	{	
		if ($("#IsChecked")[0].selectedIndex == 1)
			buttons += "<button class=\"Button\" onclick=\"UpdateAlbumComment('Check')\" >" + _lang_check + "</button>";
		else if ($("#IsChecked")[0].selectedIndex == 2)
			buttons += "<button class=\"Button\" onclick=\"UpdateAlbumComment('UnCheck')\" >" + _lang_uncheck + "</button>";
	}
    else if (_page == "music_category_list")
    {
        //显示
        var obj = $("#IsDisplay")[0];
        if (obj.selectedIndex == 1)
            buttons += "<button class=\"Button\" onclick=\"UpdateMusicCategory('Display')\" >" + _lang_display + "</button>";
        else if (obj.selectedIndex == 2)
            buttons += "<button class=\"Button\" onclick=\"UpdateMusicCategory('UnDisplay')\" >" + _lang_undisplay + "</button>";

        //置顶
        var obj = $("#IsHeld")[0];
        if (obj.selectedIndex == 1)
            buttons += "<button class=\"Button\" onclick=\"UpdateMusicCategory('Hold')\" >" + _lang_hold + "</button>";
        else if (obj.selectedIndex == 2)
            buttons += "<button class=\"Button\" onclick=\"UpdateMusicCategory('UnHold')\" >" + _lang_unhold + "</button>";

        //推荐
        var obj = $("#IsRecommended")[0];
        if (obj.selectedIndex == 1)
            buttons += "<button class=\"Button\" onclick=\"UpdateMusicCategory('Recommend')\" >" + _lang_recommend + "</button>";
        else if (obj.selectedIndex == 2)
            buttons += "<button class=\"Button\" onclick=\"UpdateMusicCategory('UnRecommend')\" >" + _lang_unrecommend + "</button>";
    }
    else if (_page == "album_category_list")
    {
        //显示
        var obj = $("#IsDisplay")[0];
        if (obj.selectedIndex == 1)
            buttons += "<button class=\"Button\" onclick=\"UpdateAlbumCategory('Display')\" >" + _lang_display + "</button>";
        else if (obj.selectedIndex == 2)
            buttons += "<button class=\"Button\" onclick=\"UpdateAlbumCategory('UnDisplay')\" >" + _lang_undisplay + "</button>";

        //置顶
        var obj = $("#IsHeld")[0];
        if (obj.selectedIndex == 1)
            buttons += "<button class=\"Button\" onclick=\"UpdateAlbumCategory('Hold')\" >" + _lang_hold + "</button>";
        else if (obj.selectedIndex == 2)
            buttons += "<button class=\"Button\" onclick=\"UpdateAlbumCategory('UnHold')\" >" + _lang_unhold + "</button>";

        //推荐
        var obj = $("#IsRecommended")[0];
        if (obj.selectedIndex == 1)
            buttons += "<button class=\"Button\" onclick=\"UpdateAlbumCategory('Recommend')\" >" + _lang_recommend + "</button>";
        else if (obj.selectedIndex == 2)
            buttons += "<button class=\"Button\" onclick=\"UpdateAlbumCategory('UnRecommend')\" >" + _lang_unrecommend + "</button>";
    }

	$("#ExtraButton").html(buttons);
}

function ShowSelectFileDialog(type)
{
	var path = _adminPath + "IlgharCMS.SystemModule/file_manager/select.aspx?Lang=" + _lang + "&Type=" + type + "&ListByPicture=";
	switch (type)
	{
		case "Picture":
			path += "true&Root=" + _pictureRoot;
			break;
		case "Thumbnail":
			path += "true&Root=" + _thumbnailRoot;
			break;
		case "URL":
			path += "false&Root=" + _urlRoot;
			break;
		case "Download":
			path += "false&Root=" + _downloadRoot;
			break;
	}
	
	path = HandleFake404(path, "url");
	if ($.browser.msie)
		window.showModalDialog(path, window, "status=0;dialogWidth=900px;dialogHeight=600px;center=1;help=0;resizable=1;scroll=0");
	else
		window.open(path,null,"width=900,height=600,menubar=no,toolbar=no,location=no,scrollbars=yes,status=no,modal=yes");
}

function ShowSelectDialog(type)
{
	var path;
	if (type == "Tag")
		path = "../tag/select.aspx?Lang=" + _lang;
	else if (type == "Person")
		path = "../person/select.aspx?Lang=" + _lang;
	else if (type == "Music")
		path = "../music/select.aspx?Lang=" + _lang;
	else if (type == "Album")
		path = "../album/select.aspx?Lang=" + _lang;

	path = HandleFake404(path, "url");
	if ($.browser.msie)
		window.showModalDialog(path, window, "status=0;dialogWidth=500px;dialogHeight=500px;center=1;help=0;resizable=1;scroll=1");
	else
		window.open(path,null,"width=500,height=500,dialog=yes,modal=yes,maximize=no,menubar=no,toolbar=no,location=no,scrollbars=yes,status=no");
}

function SelectFile(type, path)
{
	var form = document.forms[0];
	switch (type)
	{
		case "Picture":
			form.Picture.value = path;
			$("#PictureView").attr("src", path);
			break;
		case "Thumbnail":
			form.Thumbnail.value = path;
			$("#ThumbnailView").attr("src", path);
			break;
		case "URL":
			form.URL.value = path;
			break;
		case "Download":
			form.Download.value = path;
			break;
	}	
}

function SelectTag(tag, checked)
{
	var tags = $("[name=Tag]");
	for (var i = 0; i < tags.length; i++)
	{
		if (tags[i].id == tag.ID)
		{
			tags[i].checked = checked;
			return;
		}
	}
	
	var tagContainer = $("#TagDiv");
	var br = "";
	if (tags.length > 0 && tags.length % 5 == 0) br = "<br />";
	tagContainer.html(tagContainer.html() + br + "<input type='checkbox' checked='checked' name='Tag' id='" + tag.ID + "' value='" + tag.Name + "' PageGenerate='" + tag.PageGenerate + "' PageTemplate='" + tag.PageTemplate + "'' PageID='" + tag.PageID + "'' PageExtension='" + tag.PageExtension + "' /><label class='" + _lang + "Font' for='" + tag.ID + "'>" + tag.Name + "</label>");
}

function SelectPerson(person, checked)
{
	var persons = $("[name=Person]");
	for (var i = 0; i < persons.length; i++)
	{
		if (persons[i].id == person.ID)
		{
			persons[i].checked = checked;
			return;
		}
	}
	
	var personContainer = $("#PersonDiv");
	var br = "";
	if (persons.length > 0 && persons.length % 5 == 0) br = "<br />";
	personContainer.html(personContainer.html() + br + "<input type='checkbox' checked='checked' name='Person' id='" + person.ID + "' value='" + person.Name + "' PageGenerate='" + person.PageGenerate + "' PageTemplate='" + person.PageTemplate + "'' PageID='" + person.PageID + "'' PageExtension='" + person.PageExtension + "' /><label class='" + _lang + "Font' for='" + person.ID + "'>" + person.Name + "</label>");
}

function SelectAlbum(album, checked)
{
	var albums = $("[name=Album]");
	for (var i = 0; i < albums.length; i++)
	{
		if (albums[i].id == album.ID)
		{
			albums[i].checked = checked;
			return;
		}
	}
	
	var albumContainer = $("#AlbumDiv");
	var br = "";
	if (albums.length > 0 && albums.length % 5 == 0) br = "<br />";
	albumContainer.html(albumContainer.html() + br + "<input type='checkbox' checked='checked' name='Album' id='" + album.ID + "' value='" + album.Name + "' PageGenerate='" + album.PageGenerate + "' PageTemplate='" + album.PageTemplate + "'' PageID='" + album.PageID + "'' PageExtension='" + album.PageExtension + "' /><label class='" + _lang + "Font' for='" + album.ID + "'>" + album.Name + "</label>");
}

function SelectMusic(a)
{
    $("[name=Music]").attr("id", $(a).attr("ID")).attr("value", $(a).attr("Name")).attr("InnerID", $(a).attr("InnerID"));
}

function Style_OnChange()
{
    if ($("#Custom")[0].checked)
    {
        if (this.id == "Custom")
            $("[name=CustomStyle]").show();

        return;
    }
    else
    {
        $("[name=CustomStyle]").hide();
    }

    var result = "";

    if ($("#Bold")[0].checked)
        result = "font-weight:bold";

    if ($("#Italic")[0].checked)
    {
        if (result != "")
            result += ";";

        result += "font-style:italic";
    }

    if ($.trim($("#Color").val()) != "")
    {
        if (result != "")
            result += ";";

        result += "color:" + $("#Color").val();
    }
    
    $("[name=CustomStyle]").val(result);
}

function Property_OnChange()
{
    switch (this.value)
    {
        case "CategoryID":
            SetStatusMessage(_lang_working);
        	
            $.ajax(
            {
                url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=" + ((_page == "album_replace") ? "AlbumCategory" : "MusicCategory") + "&Operation=List",
                type : "GET",
                error : function(request)
                {
	                Alert(_lang_operation_fail);
	                SetStatusMessage();
                },
                success : function(data)
                {
	                _xmlDoc.loadXML(data);
	                var childNodes = _xmlDoc.documentElement.childNodes;
        			
	                var from = "<select name=\"From\" class=\"" + _lang + "Font\">";
	                var to = "<select name=\"To\" class=\"" + _lang + "Font\">";
	                for (var i = 0; i < childNodes.length; i++)
	                {
						if (typeof (childNodes[i].selectSingleNode) == "undefined")
							continue;
						
	                    var id, name;
	                    if (_page == "album_replace")
	                    {
	                        id = childNodes[i].selectSingleNode(IlgharCMS.MusicModule.AlbumCategory.ID).text;
	                        name = childNodes[i].selectSingleNode(IlgharCMS.MusicModule.AlbumCategory.Name).text;
	                    }
	                    else
	                    {
	                        id = childNodes[i].selectSingleNode(IlgharCMS.MusicModule.MusicCategory.ID).text;
	                        name = childNodes[i].selectSingleNode(IlgharCMS.MusicModule.MusicCategory.Name).text;
	                    }
		                var option = "<option value=\"" + id + "\">" + name + "</option>";
		                from += option;
		                to += option;
	                }
	                from += "</select>";
	                to += "</select>";
        			
	                $("#FromTd").html(from);
	                $("#ToTd").html(to);
	                SetStatusMessage();
                }
            });
	        break;
        case "RegionID":
            SetStatusMessage(_lang_working);
        	
            $.ajax(
            {
                url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Region&Operation=List",
                type : "GET",
                error : function(request)
                {
	                Alert(_lang_operation_fail);
	                SetStatusMessage();
                },
                success : function(data)
                {
	                _xmlDoc.loadXML(data);
	                var childNodes = _xmlDoc.documentElement.childNodes;
        			
	                var from = "<select name=\"From\" class=\"" + _lang + "Font\">";
	                var to = "<select name=\"To\" class=\"" + _lang + "Font\">";
	                for (var i = 0; i < childNodes.length; i++)
	                {
						if (typeof (childNodes[i].selectSingleNode) == "undefined")
							continue;
						
	                    var id = childNodes[i].selectSingleNode(IlgharCMS.MusicModule.Region.ID).text;
	                    var name = childNodes[i].selectSingleNode(IlgharCMS.MusicModule.Region.Name).text;
		                var option = "<option value=\"" + id + "\">" + name + "</option>";
		                from += option;
		                to += option;
	                }
	                from += "</select>";
	                to += "</select>";
        			
	                $("#FromTd").html(from);
	                $("#ToTd").html(to);
	                SetStatusMessage();
                }
            });
	        break;
        case "LanguageID":
            SetStatusMessage(_lang_working);
        	
            $.ajax(
            {
                url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Language&Operation=List",
                type : "GET",
                error : function(request)
                {
	                Alert(_lang_operation_fail);
	                SetStatusMessage();
                },
                success : function(data)
                {
	                _xmlDoc.loadXML(data);
	                var childNodes = _xmlDoc.documentElement.childNodes;
        			
	                var from = "<select name=\"From\" class=\"" + _lang + "Font\">";
	                var to = "<select name=\"To\" class=\"" + _lang + "Font\">";
	                for (var i = 0; i < childNodes.length; i++)
	                {
						if (typeof (childNodes[i].selectSingleNode) == "undefined")
							continue;
						
	                    var id = childNodes[i].selectSingleNode(IlgharCMS.MusicModule.Language.ID).text;
	                    var name = childNodes[i].selectSingleNode(IlgharCMS.MusicModule.Language.Name).text;
		                var option = "<option value=\"" + id + "\">" + name + "</option>";
		                from += option;
		                to += option;
	                }
	                from += "</select>";
	                to += "</select>";
        			
	                $("#FromTd").html(from);
	                $("#ToTd").html(to);
	                SetStatusMessage();
                }
            });
	        break;
        case "SexID":
            SetStatusMessage(_lang_working);
        	
            $.ajax(
            {
                url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Sex&Operation=List",
                type : "GET",
                error : function(request)
                {
	                Alert(_lang_operation_fail);
	                SetStatusMessage();
                },
                success : function(data)
                {
	                _xmlDoc.loadXML(data);
	                var childNodes = _xmlDoc.documentElement.childNodes;
        			
	                var from = "<select name=\"From\" class=\"" + _lang + "Font\">";
	                var to = "<select name=\"To\" class=\"" + _lang + "Font\">";
	                for (var i = 0; i < childNodes.length; i++)
	                {
						if (typeof (childNodes[i].selectSingleNode) == "undefined")
							continue;
						
	                    var id = childNodes[i].selectSingleNode(IlgharCMS.MusicModule.Sex.ID).text;
	                    var name = childNodes[i].selectSingleNode(IlgharCMS.MusicModule.Sex.Name).text;
		                var option = "<option value=\"" + id + "\">" + name + "</option>";
		                from += option;
		                to += option;
	                }
	                from += "</select>";
	                to += "</select>";
        			
	                $("#FromTd").html(from);
	                $("#ToTd").html(to);
	                SetStatusMessage();
                }
            });
	        break;
        case "Name":
        case "Description":
	        $("#FromTd").html("<input type=\"text\" name=\"From\" class=\"Text " + _lang + "Font\" />");
	        $("#ToTd").html("<input type=\"text\" name=\"To\" class=\"Text " + _lang + "Font\" />");
	        break;
        default:
	        $("#FromTd").html("<input type=\"text\" name=\"From\" size=\"40\" class=\"Text\" />");
	        $("#ToTd").html("<input type=\"text\" name=\"To\" size=\"40\" class=\"Text\" />");
	        break;
    }
}

function PrepareTag()
{
    var result = {Names:"",PageIDs:"",PageGenerates:"",PageTemplates:"",PageExtensions:""};	
    var tags = $("[name=Tag]");
	
	if (typeof(_tagIndex) != "undefined")
	{
	    _tagIndex = 0;
	}
	else
	{
	    _tagAddIndex = 0;
	    _tagDeleteIndex = 0;
	    _tagAddList.length = 0;
	    _tagDeleteList.length = 0;
    	    	
	    tags.each(function()
	    {
		    if (this.checked)
		    {
			    var j = 0;
			    for (; j < _tags.length; j++)
			    {
				    if (this.id == _tags[j] || this.id == _tags[j].ID)
					    break;
			    }
			    if (j >= _tags.length)
				    _tagAddList[_tagAddList.length] = this.id;
		    }
		    else
		    {
			    for (var j = 0; j < _tags.length; j++)
			    {
				    if (this.id == _tags[j] || this.id == _tags[j].ID)
				    {
					    _tagDeleteList[_tagDeleteList.length] = this.id;
					    break;
				    }
			    }
		    }
	    });
	}

	_tags.length = 0;
	tags.each(function()
	{
		if (!this.checked)
		    return false;

		_tags[_tags.length] = this.id;

		if (result.Names == "")
			result.Names = "|";
		result.Names += this.value + "|";
		
		if (result.PageGenerates == "")
			result.PageGenerates = "|";
		result.PageGenerates += $(this).attr("PageGenerate") + "|";
		
		if (result.PageTemplates == "")
			result.PageTemplates = "|";
		result.PageTemplates += $(this).attr("PageTemplate") + "|";
		
		if (result.PageIDs == "")
			result.PageIDs = "|";
		result.PageIDs += $(this).attr("PageID") + "|";
		
		if (result.PageExtensions == "")
			result.PageExtensions = "|";
		result.PageExtensions += $(this).attr("PageExtension") + "|";
	});
	
	return result;
}

function PreparePerson()
{
    var result = {Names:"",PageIDs:"",PageGenerates:"",PageTemplates:"",PageExtensions:""};	
    var persons = $("[name=Person]");
	
	if (typeof(_personIndex) != "undefined")
	{
	    _personIndex = 0;
	}
	else
	{
	    _personAddIndex = 0;
	    _personDeleteIndex = 0;
	    _personAddList.length = 0;
	    _personDeleteList.length = 0;
    	    	
	    persons.each(function()
	    {
		    if (this.checked)
		    {
			    var j = 0;
			    for (; j < _persons.length; j++)
			    {
				    if (this.id == _persons[j] || this.id == _persons[j].ID)
					    break;
			    }
			    if (j >= _persons.length)
				    _personAddList[_personAddList.length] = this.id;
		    }
		    else
		    {
			    for (var j = 0; j < _persons.length; j++)
			    {
				    if (this.id == _persons[j] || this.id == _persons[j].ID)
				    {
					    _personDeleteList[_personDeleteList.length] = this.id;
					    break;
				    }
			    }
		    }
	    });
	}

	_persons.length = 0;
	persons.each(function()
	{
		if (!this.checked)
		    return false;

		_persons[_persons.length] = this.id;

		if (result.Names == "")
			result.Names = "|";
		result.Names += this.value + "|";
		
		if (result.PageGenerates == "")
			result.PageGenerates = "|";
		result.PageGenerates += $(this).attr("PageGenerate") + "|";
		
		if (result.PageTemplates == "")
			result.PageTemplates = "|";
		result.PageTemplates += $(this).attr("PageTemplate") + "|";
		
		if (result.PageIDs == "")
			result.PageIDs = "|";
		result.PageIDs += $(this).attr("PageID") + "|";
		
		if (result.PageExtensions == "")
			result.PageExtensions = "|";
		result.PageExtensions += $(this).attr("PageExtension") + "|";
	});
	
	return result;
}

function PrepareAlbum()
{
    var result = {Names:"",PageIDs:"",PageGenerates:"",PageTemplates:"",PageExtensions:""};	
    var albums = $("[name=Album]");
	
	if (typeof(_albumIndex) != "undefined")
	{
	    _albumIndex = 0;
	}
	else
	{
	    _albumAddIndex = 0;
	    _albumDeleteIndex = 0;
	    _albumAddList.length = 0;
	    _albumDeleteList.length = 0;
    	    	
	    albums.each(function()
	    {
		    if (this.checked)
		    {
			    var j = 0;
			    for (; j < _albums.length; j++)
			    {
				    if (this.id == _albums[j] || this.id == _albums[j].ID)
					    break;
			    }
			    if (j >= _albums.length)
				    _albumAddList[_albumAddList.length] = this.id;
		    }
		    else
		    {
			    for (var j = 0; j < _albums.length; j++)
			    {
				    if (this.id == _albums[j] || this.id == _albums[j].ID)
				    {
					    _albumDeleteList[_albumDeleteList.length] = this.id;
					    break;
				    }
			    }
		    }
	    });
	}

	_albums.length = 0;
	albums.each(function()
	{
		if (!this.checked)
		    return false;

		_albums[_albums.length] = this.id;

		if (result.Names == "")
			result.Names = "|";
		result.Names += this.value + "|";
		
		if (result.PageGenerates == "")
			result.PageGenerates = "|";
		result.PageGenerates += $(this).attr("PageGenerate") + "|";
		
		if (result.PageTemplates == "")
			result.PageTemplates = "|";
		result.PageTemplates += $(this).attr("PageTemplate") + "|";
		
		if (result.PageIDs == "")
			result.PageIDs = "|";
		result.PageIDs += $(this).attr("PageID") + "|";
		
		if (result.PageExtensions == "")
			result.PageExtensions = "|";
		result.PageExtensions += $(this).attr("PageExtension") + "|";
	});
	
	return result;
}

//-------------------------------------------------
//Start : 音乐类别管理
function UpdateMusicCategory(action, id)
{
    if (id == null)
    {
        id = "";
        $("[name=Sel]:checked").each(function () { id += id == "" ? this.value : "|" + this.value; });
        if (id == "")
        {
            Alert(_lang_selection_empty);
            return;
        }

        if (action == "Delete")
            Confirm(_lang_confirm_delete, function (returnValue) { if (returnValue) UpdateMusicCategory(action, id); }, this);
        else
            UpdateMusicCategory(action, id);
    }
    else
    {
        SetStatusMessage(_lang_working);

        $.ajax(
		{
		    url: _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=MusicCategory&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
		    data: {},
		    type: "POST",
		    error: function (request)
		    {
		        Alert(_lang_operation_fail);
		        SetStatusMessage();
		    },
		    success: function (data)
		    {
		        Alert(_lang_operation_success);
		        SetStatusMessage();

		        $("#List").html(HandleFake404(data, "text"));
		        Init();
		    }
		});
    }
}

function AddMusicCategory()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_type_must_be + this.PictureAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";

	var data = "Name=" + encodeURIComponent(this.Name.value);
	if ($("#GuidCheckBox")[0].checked)
		data += "&ID=" + this.ID.value;
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	data += "&ParentID=" + encodeURIComponent(this.ParentID.value);
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	data += "&PageUrl=" + encodeURIComponent(this.PageUrl.value);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	data += "&IsHeld=" + $("#IsHeldYes")[0].checked;
	data += "&IsDisplay=" + $("#IsDisplayYes")[0].checked;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=MusicCategory&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    _guid = data;
	        AddMusicCategory_GetInnerID();
		}
	});
	
	return false;	
}

function AddMusicCategory_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=MusicCategory&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
            _id = data;
			AddMusicCategory_SetPageID();
		}
	});
}

function AddMusicCategory_SetPageID()
{
    _pageID = _pageID.replace(/\{ID\}/g, _id);
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
    
    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=MusicCategory&Operation=Modify&ID=" + _id,
		data : "PageID=" + _pageID,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			MusicCategory_UploadPicture();
		}
	});
}

function EditMusicCategory()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_type_must_be + this.PictureAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (this.PageID.value == "")
	{
		Alert(_lang_pageid_empty, function(){this.PageID.select();}, this);
		return false;
	}
	
	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	if ($("#GuidCheckBox")[0].checked)
		data += "&ID=" + this.ID.value;
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	else
	    data += "&Style=";
	data += "&ParentID=" + encodeURIComponent(this.ParentID.value);
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(pageID);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	data += "&PageUrl=" + encodeURIComponent(this.PageUrl.value);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if (_recommend == 0 || !$("#IsRecommendedYes")[0].checked)
		data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	if (_hold == 0 || !$("#IsHeldYes")[0].checked)
		data += "&IsHeld=" + $("#IsHeldYes")[0].checked;
	data += "&IsDisplay=" + $("#IsDisplayYes")[0].checked;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=MusicCategory&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    MusicCategory_UploadPicture();
		}
	});
	
	return false;	
}

function MusicCategory_UploadPicture()
{
    if (!_uploadPicture)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
        return;
    }

    SetStatusMessage(_lang_start_upload);
    _uploader.Init({Status:_lang_uploading,Params:"Lang=" + _lang + "&Object=MusicCategory&Operation=UploadPicture&ID=" + _id + "&AddWaterMark=" + $("#AddWaterMark")[0].checked});
    _uploader.Upload("Picture", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function MoveMusicCategory(from, to)
{
	if (from == to)
		return;
	
	var action = "Move";
	var sort = $("#Sort").val();
	if (sort == "2" || sort == "3")
	    action = "MoveRecommend";
	else if (sort == "4" || sort == "5")
	    action = "MoveHold";

	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=MusicCategory&Operation=" + action + "&From=" + from + "&To=" + to,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			ClientMove(from, to, _imagePath);
		}
	});
}

function ModifyMusicCategory(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return;
	}
	
	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=MusicCategory&Operation=Modify&ID=" + id,
		data : "Name=" + encodeURIComponent(form.Name.value),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}
	});
}

function DeleteMusicCategory(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=MusicCategory&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			ClientDelete(id);
		}
	});
}
//End : 音乐类别管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 专辑类别管理
function UpdateAlbumCategory(action, id)
{
    if (id == null)
    {
        id = "";
        $("[name=Sel]:checked").each(function () { id += id == "" ? this.value : "|" + this.value; });
        if (id == "")
        {
            Alert(_lang_selection_empty);
            return;
        }

        if (action == "Delete")
            Confirm(_lang_confirm_delete, function (returnValue) { if (returnValue) UpdateAlbumCategory(action, id); }, this);
        else
            UpdateAlbumCategory(action, id);
    }
    else
    {
        SetStatusMessage(_lang_working);

        $.ajax(
		{
		    url: _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=AlbumCategory&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
		    data: {},
		    type: "POST",
		    error: function (request)
		    {
		        Alert(_lang_operation_fail);
		        SetStatusMessage();
		    },
		    success: function (data)
		    {
		        Alert(_lang_operation_success);
		        SetStatusMessage();

		        $("#List").html(HandleFake404(data, "text"));
		        Init();
		    }
		});
    }
}

function AddAlbumCategory()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_type_must_be + this.PictureAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";

	var data = "Name=" + encodeURIComponent(this.Name.value);
	if ($("#GuidCheckBox")[0].checked)
		data += "&ID=" + this.ID.value;
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	data += "&ParentID=" + encodeURIComponent(this.ParentID.value);
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	data += "&PageUrl=" + encodeURIComponent(this.PageUrl.value);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	data += "&IsHeld=" + $("#IsHeldYes")[0].checked;
	data += "&IsDisplay=" + $("#IsDisplayYes")[0].checked;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=AlbumCategory&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    _guid = data;
	        AddAlbumCategory_GetInnerID();
		}
	});
	
	return false;	
}

function AddAlbumCategory_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=AlbumCategory&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
            _id = data;
			AddAlbumCategory_SetPageID();
		}
	});
}

function AddAlbumCategory_SetPageID()
{
    _pageID = _pageID.replace(/\{ID\}/g, _id);
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
    
    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=AlbumCategory&Operation=Modify&ID=" + _id,
		data : "PageID=" + _pageID,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AlbumCategory_UploadPicture();
		}
	});
}

function EditAlbumCategory()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_type_must_be + this.PictureAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (this.PageID.value == "")
	{
		Alert(_lang_pageid_empty, function(){this.PageID.select();}, this);
		return false;
	}
	
	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	if ($("#GuidCheckBox")[0].checked)
		data += "&ID=" + this.ID.value;
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	else
	    data += "&Style=";
	data += "&ParentID=" + encodeURIComponent(this.ParentID.value);
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(pageID);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	data += "&PageUrl=" + encodeURIComponent(this.PageUrl.value);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if (_recommend == 0 || !$("#IsRecommendedYes")[0].checked)
		data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	if (_hold == 0 || !$("#IsHeldYes")[0].checked)
		data += "&IsHeld=" + $("#IsHeldYes")[0].checked;
	data += "&IsDisplay=" + $("#IsDisplayYes")[0].checked;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=AlbumCategory&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    AlbumCategory_UploadPicture();
		}
	});
	
	return false;	
}

function AlbumCategory_UploadPicture()
{
    if (!_uploadPicture)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
        return;
    }

    SetStatusMessage(_lang_start_upload);
    _uploader.Init({Status:_lang_uploading,Params:"Lang=" + _lang + "&Object=AlbumCategory&Operation=UploadPicture&ID=" + _id + "&AddWaterMark=" + $("#AddWaterMark")[0].checked});
    _uploader.Upload("Picture", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function MoveAlbumCategory(from, to)
{
	if (from == to)
		return;
	
	var action = "Move";
	var sort = $("#Sort").val();
	if (sort == "2" || sort == "3")
	    action = "MoveRecommend";
	else if (sort == "4" || sort == "5")
	    action = "MoveHold";

	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=AlbumCategory&Operation=" + action + "&From=" + from + "&To=" + to,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			ClientMove(from, to, _imagePath);
		}
	});
}

function ModifyAlbumCategory(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return;
	}
	
	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=AlbumCategory&Operation=Modify&ID=" + id,
		data : "Name=" + encodeURIComponent(form.Name.value),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}
	});
}

function DeleteAlbumCategory(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=AlbumCategory&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			ClientDelete(id);
		}
	});
}
//End : 专辑类别管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 标签管理
function AddTag()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    _guid = data;
	        AddTag_GetInnerID();
		}
	});
	
	return false;	
}

function AddTag_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Tag&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
            _id = data;
			AddTag_SetPageID();
		}
	});
}

function AddTag_SetPageID()
{
    _pageID = _pageID.replace(/\{ID\}/g, _id);
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
    
    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Tag&Operation=Modify&ID=" + _id,
		data : "PageID=" + _pageID,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
}

function ModifyTag(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(form.Name.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Tag&Operation=Modify&ID=" + id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function EditTag()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.PageID.value == "")
	{
		Alert(_lang_pageid_empty, function(){this.PageID.select();}, this);
		return false;
	}
	
	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(pageID);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Tag&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function DeleteTag()
{
	var id = GetChecked("Sel");
	if(id == "")
	{
		Alert(_lang_no_selection);
		return;
	}
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Tag&Operation=Delete&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			$("#List").html(HandleFake404(data, "text"));
			Init();

			if (typeof(SetupIme) == "function")
				SetupIme();			
		}
	});
}	
//End : 标签管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 地区管理
function AddRegion()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";

	var data = "ParentID=" + this.ParentID.value;
	data += "&Name=" + encodeURIComponent(this.Name.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);

	$(":submit").attr("disabled", true);
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Region&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit").attr("disabled", false);
		},
		success : function(data)
		{
		    _guid = data;
	        AddRegion_GetInnerID();
		}
	});
	
	return false;	
}

function AddRegion_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Region&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
            _id = data;
			AddRegion_SetPageID();
		}
	});
}

function AddRegion_SetPageID()
{
    _pageID = _pageID.replace(/\{ID\}/g, _id);
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
    
    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Region&Operation=Modify&ID=" + _id,
		data : "PageID=" + _pageID,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
}

function EditRegion()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.PageID.value == "")
	{
		Alert(_lang_pageid_empty, function(){this.PageID.select();}, this);
		return false;
	}
	
	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)

	var data = "ParentID=" + this.ParentID.value;
	data += "&Name=" + encodeURIComponent(this.Name.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(pageID);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);

	$(":submit").attr("disabled", true);
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Region&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit").attr("disabled", false);
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function ModifyRegion(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return;
	}
	
	form.disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Region&Operation=Modify&ID=" + id,
		data : "Name=" + encodeURIComponent(form.Name.value),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			form.disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			form.disabled = false;
		}
	});
}

function DeleteRegion(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Region&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			ClientDelete(id);
		}
	});
}

function MoveRegion(from, to)
{
	if (from == to)
		return;
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Region&Operation=" + g_action + "&From=" + from + "&To=" + to,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			
			ClientMove(from, to, _imagePath);
		}
	});
}
//End : 地区管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 公司管理
function AddCompany()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.FoundedDate.value != "")
	{
		var regx = /^((\d{4})|(\d{4}-\d{2})|(\d{4}-\d{2}-\d{2}))$/;
		if (!regx.test(this.FoundedDate.value))
		{
		    Alert(_lang_founded_date_incorrect, function(){this.FoundedDate.select();}, this);
			return false;
		}
	}
	
	if (!IsAllowedType(this.Logo.value, this.LogoAllowedType.value))
	{
		Alert(_lang_type_must_be + this.LogoAllowedType.value, function(){this.Logo.select();}, this);
		return false;
	}
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";

	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&FoundedDate=" + encodeURIComponent(this.FoundedDate.value);
	data += "&Phone=" + encodeURIComponent(this.Phone.value);
	data += "&Address=" + encodeURIComponent(this.Address.value);
	data += "&Description=" + encodeURIComponent(this.Description.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	_uploadLogo = _uploader.NeedUpload("Logo");
	if (!_uploadLogo)
		data += "&Logo=" + encodeURIComponent(this.Logo.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Company&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    _guid = data;
	        AddCompany_GetInnerID();
		}
	});
	
	return false;
}

function AddCompany_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Company&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
            _id = data;
			AddCompany_SetPageID();
		}
	});
}

function AddCompany_SetPageID()
{
    _pageID = _pageID.replace(/\{ID\}/g, _id);
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
    
    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Company&Operation=Modify&ID=" + _id,
		data : "PageID=" + _pageID,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Company_UploadLogo();
		}
	});
}

function EditCompany()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Logo.value, this.LogoAllowedType.value))
	{
		Alert(_lang_type_must_be + this.LogoAllowedType.value, function(){this.Logo.select();}, this);
		return false;
	}
	
	if (this.PageID.value == "")
	{
		Alert(_lang_pageid_empty, function(){this.PageID.select();}, this);
		return false;
	}
	
	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)

	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&FoundedDate=" + encodeURIComponent(this.FoundedDate.value);
	data += "&Phone=" + encodeURIComponent(this.Phone.value);
	data += "&Address=" + encodeURIComponent(this.Address.value);
	data += "&Description=" + encodeURIComponent(this.Description.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	_uploadLogo = _uploader.NeedUpload("Logo");
	if (!_uploadLogo)
		data += "&Logo=" + encodeURIComponent(this.Logo.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Company&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Company_UploadLogo();
		}
	});
	
	return false;	
}

function Company_UploadLogo()
{
    if (!_uploadLogo)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
        return;
    }

    SetStatusMessage(_lang_start_upload);
    _uploader.Init({Status:_lang_uploading,Params:"Lang=" + _lang + "&Object=Company&Operation=UploadLogo&ID=" + _id + "&AddWaterMark=" + $("#AddWaterMark")[0].checked});
    _uploader.Upload("Logo", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function DeleteCompany(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Company&Operation=Delete&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			Init();
		}
	});
}
//End : 公司管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 栏目设置
function SetBasicSettings()
{
	if (this.PlayFolder.value.length > 0 && this.PlayFolder.value.indexOf("/") != 0)
	{
		Alert(_lang_play_folder_starts_slash, function(){this.PlayFolder.select();}, this);
		return false;
	}
	
	if (this.DownloadFolder.value.length > 0 && this.DownloadFolder.value.indexOf("/") != 0)
	{
		Alert(_lang_download_folder_starts_slash, function(){this.DownloadFolder.select();}, this);
		return false;
	}
	
	if (!this.AlbumThumbnailWidth.value.match(/^\d*$/))
	{
		Alert(_lang_music_thumbnail_width_incorrect, function(){this.AlbumThumbnailWidth.select();}, this);
		return false;
	}	
	
	if (!this.AlbumThumbnailHeight.value.match(/^\d*$/))
	{
		Alert(_lang_music_thumbnail_height_incorrect, function(){this.AlbumThumbnailHeight.select();}, this);
		return false;
	}	
	
	if (!this.PersonThumbnailWidth.value.match(/^\d*$/))
	{
		Alert(_lang_person_thumbnail_width_incorrect, function(){this.PersonThumbnailWidth.select();}, this);
		return false;
	}	
	
	if (!this.PersonThumbnailHeight.value.match(/^\d*$/))
	{
		Alert(_lang_person_thumbnail_height_incorrect, function(){this.PersonThumbnailHeight.select();}, this);
		return false;
	}	
	
	if (!IsAllowedType(this.AlbumDefaultThumbnail.value, this.AlbumDefaultThumbnailAllowedType.value))
	{
		Alert(_lang_album_type_must_be + this.AlbumDefaultThumbnailAllowedType.value, function(){this.AlbumDefaultThumbnail.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.PersonDefaultThumbnail.value, this.PersonDefaultThumbnailAllowedType.value))
	{
		Alert(_lang_person_type_must_be + this.PersonDefaultThumbnailAllowedType.value, function(){this.PersonDefaultThumbnail.select();}, this);
		return false;
	}
	
	var data = "FirstLetter=" + encodeURIComponent(this.FirstLetter.value);
	data += "&PlayFolder=" +  encodeURIComponent(this.PlayFolder.value);
	data += "&DownloadFolder=" +  encodeURIComponent(this.DownloadFolder.value);
	data += "&AlbumThumbnailFolder=" +  encodeURIComponent(this.AlbumThumbnailFolder.value);
	data += "&AlbumPictureFolder=" +  encodeURIComponent(this.AlbumPictureFolder.value);
	data += "&PersonThumbnailFolder=" +  encodeURIComponent(this.PersonThumbnailFolder.value);
	data += "&PersonPictureFolder=" +  encodeURIComponent(this.PersonPictureFolder.value);
	data += "&AlbumThumbnailWidth=" + this.AlbumThumbnailWidth.value;
	data += "&AlbumThumbnailHeight=" + this.AlbumThumbnailHeight.value;
	data += "&PersonThumbnailWidth=" + this.PersonThumbnailWidth.value;
	data += "&PersonThumbnailHeight=" + this.PersonThumbnailHeight.value;
	data += "&EnableComment=" + this.EnableComment.checked;
	data += "&CheckComment=" + this.CheckComment.checked;
	_uploadAlbumDefaultThumbnail = _uploader.NeedUpload("Album");
	if (!_uploadAlbumDefaultThumbnail)
		data += "&AlbumDefaultThumbnail=" + encodeURIComponent(this.AlbumDefaultThumbnail.value);
	_uploadPersonDefaultThumbnail = _uploader.NeedUpload("Person");
	if (!_uploadPersonDefaultThumbnail)
		data += "&PersonDefaultThumbnail=" + encodeURIComponent(this.PersonDefaultThumbnail.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=InstanceConfig&Operation=SetBasicSettings",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    SetBasicSettings_UploadAlbumDefaultThumbnail();
		}
	});
	
	return false;	
}

function SetBasicSettings_UploadAlbumDefaultThumbnail()
{
    if (!_uploadAlbumDefaultThumbnail)
    {
		SetBasicSettings_UploadPersonDefaultThumbnail();
        return;
    }

    SetStatusMessage(_lang_start_upload_music);
    _uploader.Init({Status:_lang_uploading_music,Params:"Lang=" + _lang + "&Object=InstanceConfig&Operation=UploadAlbumDefaultThumbnail"});
    _uploader.Upload("Album", function()
    {
        if (arguments.length == 2)
        {
            Alert(arguments[1]);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
        }
        else
        {
    		SetBasicSettings_UploadPersonDefaultThumbnail();
    	}
    });
}

function SetBasicSettings_UploadPersonDefaultThumbnail()
{
    if (!_uploadPersonDefaultThumbnail)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
        return;
    }

    SetStatusMessage(_lang_start_upload_person);
    _uploader.Init({Status:_lang_uploading_person,Params:"Lang=" + _lang + "&Object=InstanceConfig&Operation=UploadPersonDefaultThumbnail"});
    _uploader.Upload("Person", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function CreateAllAlbumThumbnail()
{
    var me = $(this);
	me.attr("disabled", true);
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Album&Operation=CreateAllThumbnail",
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			me.attr("disabled", false);
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			me.attr("disabled", false);
		}
	});
	
	return false;	
}

function CreateAllPersonThumbnail()
{
    var me = $(this);
	me.attr("disabled", true);
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Person&Operation=CreateAllThumbnail",
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			me.attr("disabled", false);
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			me.attr("disabled", false);
		}
	});
	
	return false;	
}

function CreateAllPackFile()
{
    var me = $(this);
	me.attr("disabled", true);
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Music&Operation=CreateAllPackFile",
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			me.attr("disabled", false);
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			me.attr("disabled", false);
		}
	});
	
	return false;	
}
//End : 栏目设置
//-------------------------------------------------

//-------------------------------------------------
//Start : 语言管理
function AddLanguage()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";

	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Language&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    _guid = data;
	        AddLanguage_GetInnerID();
		}
	});
	
	return false;
}

function AddLanguage_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Language&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
            _id = data;
			AddLanguage_SetPageID();
		}
	});
}

function AddLanguage_SetPageID()
{
    _pageID = _pageID.replace(/\{ID\}/g, _id);
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
    
    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Language&Operation=Modify&ID=" + _id,
		data : "PageID=" + _pageID,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
}

function EditLanguage()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.PageID.value == "")
	{
		Alert(_lang_pageid_empty, function(){this.PageID.select();}, this);
		return false;
	}
	
	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)

	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(pageID);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Language&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function ModifyLanguage(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(form.Name.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Language&Operation=Modify&ID=" + id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function DeleteLanguage(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Language&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#" + id).remove();
		}
	});
}	
//End : 语言管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 音乐管理
function AddMusic()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!this.HitCount.value.match(/^\d+$/))
	{
		Alert(_lang_hitcount_incorrect, function(){this.HitCount.select();}, this);
		return false;
	}

	if (!this.Up.value.match(/^\d+$/))
	{
		Alert(_lang_up_incorrect, function(){this.Up.select();}, this);
		return false;
	}

	if (!this.Down.value.match(/^\d+$/))
	{
		Alert(_lang_down_incorrect, function(){this.Down.select();}, this);
		return false;
	}

	if (!this.Error.value.match(/^\d+$/))
	{
		Alert(_lang_error_incorrect, function(){this.Error.select();}, this);
		return false;
	}
	
	var tag = PrepareTag();
	var album = PrepareAlbum();
	var person = PreparePerson();

	var category = $("[name=CategoryID] option:selected");
	var region = $("[name=RegionID] option:selected");
	var language = $("[name=LanguageID] option:selected");

	SetCookie("CategoryID", category.val(), 10*360*24*60);	
	SetCookie("RegionID", region.val(), 10*360*24*60);	
	SetCookie("LanguageID", language.val(), 10*360*24*60);	
	SetCookie("PlayerID", this.PlayerID.value, 10*360*24*60);

	_createTime = new Date();
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";

	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&CreateTime=" + FormatDate(_createTime, "YYYY-MM-DD hh:mm:ss.SSS");
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	data += "&CategoryID=" + this.CategoryID.value;
	data += "&CategoryName=" + category.attr("Name");
	data += "&CategoryPageGenerate=" + category.attr("PageGenerate");
	data += "&CategoryPageTemplate=" + category.attr("PageTemplate");
	data += "&CategoryPageID=" + category.attr("PageID");
	data += "&CategoryPageExtension=" + category.attr("PageExtension");
	data += "&RegionID=" + this.RegionID.value;
	data += "&RegionName=" + region.attr("Name");
	data += "&RegionPageGenerate=" + region.attr("PageGenerate");
	data += "&RegionPageTemplate=" + region.attr("PageTemplate");
	data += "&RegionPageID=" + region.attr("PageID");
	data += "&RegionPageExtension=" + region.attr("PageExtension");
	data += "&LanguageID=" + this.LanguageID.value;
	data += "&LanguageName=" + language.attr("Name");
	data += "&LanguagePageGenerate=" + language.attr("PageGenerate");
	data += "&LanguagePageTemplate=" + language.attr("PageTemplate");
	data += "&LanguagePageID=" + language.attr("PageID");
	data += "&LanguagePageExtension=" + language.attr("PageExtension");
	data += "&PlayerID=" + this.PlayerID.value;
	data += "&NeedPack=" + $("#NeedPackYes")[0].checked;
	data += "&Lyric=" + encodeURIComponent(this.Lyric.value);
	data += "&Title=" + encodeURIComponent(this.Title.value);
	data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	data += "&IsHeld=" + $("#IsHeldYes")[0].checked;
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	data += "&PageUrl=" + encodeURIComponent(this.PageUrl.value);
	data += "&HitCount=" + this.HitCount.value;
	data += "&Up=" + this.Up.value;
	data += "&Down=" + this.Down.value;
	data += "&Error=" + this.Error.value;
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	data += "&AlbumNames=" + encodeURIComponent(album.Names);
	data += "&AlbumPageGenerates=" + encodeURIComponent(album.PageGenerates);
	data += "&AlbumPageTemplates=" + encodeURIComponent(album.PageTemplates);
	data += "&AlbumPageIDs=" + encodeURIComponent(album.PageIDs);
	data += "&AlbumPageExtensions=" + encodeURIComponent(album.PageExtensions);
	data += "&PersonNames=" + encodeURIComponent(person.Names);
	data += "&PersonPageGenerates=" + encodeURIComponent(person.PageGenerates);
	data += "&PersonPageTemplates=" + encodeURIComponent(person.PageTemplates);
	data += "&PersonPageIDs=" + encodeURIComponent(person.PageIDs);
	data += "&PersonPageExtensions=" + encodeURIComponent(person.PageExtensions);
	data += "&TagNames=" + encodeURIComponent(tag.Names);
	data += "&TagPageGenerates=" + encodeURIComponent(tag.PageGenerates);
	data += "&TagPageTemplates=" + encodeURIComponent(tag.PageTemplates);
	data += "&TagPageIDs=" + encodeURIComponent(tag.PageIDs);
	data += "&TagPageExtensions=" + encodeURIComponent(tag.PageExtensions);
	_uploadForPlay = _uploader.NeedUpload("URL");
	if (!_uploadForPlay)
		data += "&URL=" + encodeURIComponent(this.URL.value);
	_uploadForDownload = _uploader.NeedUpload("Download");
	if (!_uploadForDownload)
		data += "&Download=" + encodeURIComponent(this.Download.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Music&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			_guid = data;
		    AddMusic_GetInnerID();
		}
	});
	
	return false;	
}

function AddMusic_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Music&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
            _id = data;
			AddMusic_SetPageID();
		}
	});
}

function AddMusic_SetPageID()
{
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
	_pageID = _pageID.replace(/\{ID\}/g, _id);
	_pageID = _pageID.replace(/\{YYYYMMDDhhmmss\}/g, FormatDate(_createTime, "YYYYMMDDhhmmss"));
	_pageID = _pageID.replace(/\{YYYY-MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY-MM-DD/hhmmss"));
	_pageID = _pageID.replace(/\{YYYY\/MM\/DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM/DD/hhmmss"));
	_pageID = _pageID.replace(/\{YYYY\/MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM-DD/hhmmss"));

    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Music&Operation=Modify&ID=" + _id,
		data : "PageID=" + encodeURIComponent(_pageID),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
    		AddMusic_AddTag();
		}
	});
}

function AddMusic_AddTag()
{
	if (_tagIndex >= _tags.length)
	{
		AddMusic_AddAlbum();
		return;
	}
	
	var data = "MusicID=" + _guid;
	data += "&TagID=" + _tags[_tagIndex];
	
	_tagIndex++;

    SetStatusMessage(_lang_adding_tag);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Music.Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddMusic_AddTag();
		}
	});
}

function AddMusic_AddAlbum()
{
	if (_albumIndex >= _albums.length)
	{
		AddMusic_AddPerson();
		return;
	}
	
	var data = "MusicID=" + _guid;
	data += "&AlbumID=" + _albums[_albumIndex];
	
	_albumIndex++;

    SetStatusMessage(_lang_adding_album);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Music.Album&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddMusic_AddAlbum();
		}
	});
}

function AddMusic_AddPerson()
{
	if (_personIndex >= _persons.length)
	{
		Music_UploadForPlay();
		return;
	}
	
	var data = "MusicID=" + _guid;
	data += "&PersonID=" + _persons[_personIndex];
	
	_personIndex++;

    SetStatusMessage(_lang_adding_person);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Music.Person&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddMusic_AddPerson();
		}
	});
}

function EditMusic()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!this.HitCount.value.match(/^\d+$/))
	{
		Alert(_lang_hitcount_incorrect, function(){this.HitCount.select();}, this);
		return false;
	}

	if (!this.Up.value.match(/^\d+$/))
	{
		Alert(_lang_up_incorrect, function(){this.Up.select();}, this);
		return false;
	}

	if (!this.Down.value.match(/^\d+$/))
	{
		Alert(_lang_down_incorrect, function(){this.Down.select();}, this);
		return false;
	}

	if (!this.Error.value.match(/^\d+$/))
	{
		Alert(_lang_error_incorrect, function(){this.Error.select();}, this);
		return false;
	}
		
	var dateTime = /^(\d{1,4})(-|\/)(\d{1,2})(-|\/)(\d{1,2})( (\d{1,2}):(\d{1,2}):(\d{1,2}))?$/;
	if (!dateTime.test(this.UpdateTime.value))
	{
	    Alert(_lang_update_time_incorrect, function(){this.UpdateTime.select();}, this);
		return false;
	}

	var tag = PrepareTag();
	var album = PrepareAlbum();
	var person = PreparePerson();
	
	var category = $("[name=CategoryID] option:selected");
	var region = $("[name=RegionID] option:selected");
	var language = $("[name=LanguageID] option:selected");

	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)
	pageID = pageID.replace(/\{YYYYMMDDhhmmss\}/g, FormatDate(_createTime, "YYYYMMDDhhmmss"));
	pageID = pageID.replace(/\{YYYY-MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY-MM-DD/hhmmss"));
	pageID = pageID.replace(/\{YYYY\/MM\/DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM/DD/hhmmss"));
	pageID = pageID.replace(/\{YYYY\/MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM-DD/hhmmss"));

	var data = "Name=" + encodeURIComponent(this.Name.value);
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	else
	    data += "&Style=";
	data += "&CategoryID=" + this.CategoryID.value;
	data += "&CategoryName=" + category.attr("Name");
	data += "&CategoryPageGenerate=" + category.attr("PageGenerate");
	data += "&CategoryPageTemplate=" + category.attr("PageTemplate");
	data += "&CategoryPageID=" + category.attr("PageID");
	data += "&CategoryPageExtension=" + category.attr("PageExtension");
	data += "&RegionID=" + this.RegionID.value;
	data += "&RegionName=" + region.attr("Name");
	data += "&RegionPageGenerate=" + region.attr("PageGenerate");
	data += "&RegionPageTemplate=" + region.attr("PageTemplate");
	data += "&RegionPageID=" + region.attr("PageID");
	data += "&RegionPageExtension=" + region.attr("PageExtension");
	data += "&LanguageID=" + this.LanguageID.value;
	data += "&LanguageName=" + language.attr("Name");
	data += "&LanguagePageGenerate=" + language.attr("PageGenerate");
	data += "&LanguagePageTemplate=" + language.attr("PageTemplate");
	data += "&LanguagePageID=" + language.attr("PageID");
	data += "&LanguagePageExtension=" + language.attr("PageExtension");
	data += "&PlayerID=" + this.PlayerID.value;
	data += "&Lyric=" + encodeURIComponent(this.Lyric.value);
	data += "&Title=" + encodeURIComponent(this.Title.value);
	data += "&NeedPack=" + $("#NeedPackYes")[0].checked;
	data += "&HitCount=" + this.HitCount.value;
	data += "&Up=" + this.Up.value;
	data += "&Down=" + this.Down.value;
	data += "&Error=" + this.Error.value;
	data += "&UpdateTime=" + this.UpdateTime.value;
	if (_recommend == 0 || !$("#IsRecommendedYes")[0].checked)
		data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	if (_hold == 0 || !$("#IsHeldYes")[0].checked)
		data += "&IsHeld=" + $("#IsHeldYes")[0].checked;
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(pageID);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	data += "&PageUrl=" + encodeURIComponent(this.PageUrl.value);
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	data += "&AlbumNames=" + encodeURIComponent(album.Names);
	data += "&AlbumPageGenerates=" + encodeURIComponent(album.PageGenerates);
	data += "&AlbumPageTemplates=" + encodeURIComponent(album.PageTemplates);
	data += "&AlbumPageIDs=" + encodeURIComponent(album.PageIDs);
	data += "&AlbumPageExtensions=" + encodeURIComponent(album.PageExtensions);
	data += "&PersonNames=" + encodeURIComponent(person.Names);
	data += "&PersonPageGenerates=" + encodeURIComponent(person.PageGenerates);
	data += "&PersonPageTemplates=" + encodeURIComponent(person.PageTemplates);
	data += "&PersonPageIDs=" + encodeURIComponent(person.PageIDs);
	data += "&PersonPageExtensions=" + encodeURIComponent(person.PageExtensions);
	data += "&TagNames=" + encodeURIComponent(tag.Names);
	data += "&TagPageGenerates=" + encodeURIComponent(tag.PageGenerates);
	data += "&TagPageTemplates=" + encodeURIComponent(tag.PageTemplates);
	data += "&TagPageIDs=" + encodeURIComponent(tag.PageIDs);
	data += "&TagPageExtensions=" + encodeURIComponent(tag.PageExtensions);
	_uploadForPlay = _uploader.NeedUpload("URL");
	if (!_uploadForPlay)
		data += "&URL=" + encodeURIComponent(this.URL.value);
	_uploadForDownload = _uploader.NeedUpload("Download");
	if (!_uploadForDownload)
		data += "&Download=" + encodeURIComponent(this.Download.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Music&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditMusic_DeleteTag();
		}
	});

	return false;
}

function EditMusic_DeleteTag()
{
	if (_tagDeleteIndex >= _tagDeleteList.length)
	{
		EditMusic_AddTag();
		return;
	}

	SetStatusMessage(_lang_modifying_tag);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Music.Tag&Operation=Delete&MusicID=" + _guid + "&TagID=" + _tagDeleteList[_tagDeleteIndex++],
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditMusic_DeleteTag();
		}
	});
}

function EditMusic_AddTag()
{
	if (_tagAddIndex >= _tagAddList.length)
	{
        EditMusic_DeleteAlbum();
		return;
	}
	
	var data = "MusicID=" + _guid;
	data += "&TagID=" + _tagAddList[_tagAddIndex];
	
	_tagAddIndex++;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Music.Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditMusic_AddTag();
		}
	});
}

function EditMusic_DeleteAlbum()
{
	if (_albumDeleteIndex >= _albumDeleteList.length)
	{
		EditMusic_AddAlbum();
		return;
	}

	SetStatusMessage(_lang_modifying_album);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Music.Album&Operation=Delete&MusicID=" + _guid + "&AlbumID=" + _albumDeleteList[_albumDeleteIndex++],
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditMusic_DeleteAlbum();
		}
	});
}

function EditMusic_AddAlbum()
{
	if (_albumAddIndex >= _albumAddList.length)
	{
        EditMusic_DeletePerson();
		return;
	}
	
	var data = "MusicID=" + _guid;
	data += "&AlbumID=" + _albumAddList[_albumAddIndex];
	
	_albumAddIndex++;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Music.Album&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditMusic_AddAlbum();
		}
	});
}

function EditMusic_DeletePerson()
{
	if (_personDeleteIndex >= _personDeleteList.length)
	{
		EditMusic_AddPerson();
		return;
	}

	SetStatusMessage(_lang_modifying_person);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Music.Person&Operation=Delete&MusicID=" + _guid + "&PersonID=" + _personDeleteList[_personDeleteIndex++],
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditMusic_DeletePerson();
		}
	});
}

function EditMusic_AddPerson()
{
	if (_personAddIndex >= _personAddList.length)
	{
        Music_UploadForPlay();
		return;
	}
	
	var data = "MusicID=" + _guid;
	data += "&PersonID=" + _personAddList[_personAddIndex];
	
	_personAddIndex++;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Music.Person&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditMusic_AddPerson();
		}
	});
}

function Music_UploadForPlay()
{
    if (!_uploadForPlay)
    {
        Music_UploadForDownload();
        return;
    }

    SetStatusMessage(_lang_start_upload_play);
    _uploader.Init({Status:_lang_uploading_play,Params:"Lang=" + _lang + "&Object=Music&Operation=UploadForPlay&ID=" + _id});
    _uploader.Upload("URL", function()
    {
        if (arguments.length == 2)
        {
            Alert(arguments[1]);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
        }
        else
        {
    		Music_UploadForDownload();
    	}
    });
}

function Music_UploadForDownload()
{
    if (!_uploadForDownload)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;

        return;
    }

    SetStatusMessage(_lang_start_upload_download);
    _uploader.Init({Status:_lang_uploading_download,Params:"Lang=" + _lang + "&Object=Music&Operation=UploadForDownload&ID=" + _id});
    _uploader.Upload("Download", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function MoveMusic(from, to)
{
	if (from == to)
		return;
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Music&Operation=" + g_action + "&From=" + from + "&To=" + to + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			Init();
		}
	});
}

function UpdateMusic(action, id)
{
	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdateMusic(action, id);}, this);
		else
			UpdateMusic(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Music&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#List").html(HandleFake404(data, "text"));
				Init();
			}
		});
	}
}

function ReplaceMusic()
{
	if (this.From.type == "text" && this.From.value == "")
	{
		Alert(_lang_from_empty, function(){this.From.select();}, this);
		return false;
	}
	
	var data = "Property=" + this.Property.value;
	data += "&From=" + encodeURIComponent(this.From.value);
	data += "&To=" + encodeURIComponent(this.To.value);
	
	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Music&Operation=Replace",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
        	$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}
//End : 音乐管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 音乐评论管理
function EditMusicComment()
{
	var data = "Content=" + encodeURIComponent(this.Content.value);
	data += "&UpdateTime=" + FormatDate(new Date());

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=MusicComment&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function UpdateMusicComment(action, id)
{
	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdateMusicComment(action, id);}, this);
		else
			UpdateMusicComment(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=MusicComment&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#RecordList").html(HandleFake404(data, "text"));				
			}
		});
	}
}
//End : 音乐评论管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 专辑评论管理
function EditAlbumComment()
{
	var data = "Content=" + encodeURIComponent(this.Content.value);
	data += "&UpdateTime=" + FormatDate(new Date());

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=AlbumComment&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function UpdateAlbumComment(action, id)
{
	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdateAlbumComment(action, id);}, this);
		else
			UpdateAlbumComment(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=AlbumComment&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#RecordList").html(HandleFake404(data, "text"));				
			}
		});
	}
}
//End : 专辑评论管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 人物评论管理
function EditPersonComment()
{
	var data = "Content=" + encodeURIComponent(this.Content.value);
	data += "&UpdateTime=" + FormatDate(new Date());

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=PersonComment&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function UpdatePersonComment(action, id)
{
	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdatePersonComment(action, id);}, this);
		else
			UpdatePersonComment(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=PersonComment&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#RecordList").html(HandleFake404(data, "text"));				
			}
		});
	}
}
//End : 人物评论管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 性别管理
function AddSex()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";

	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Sex&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    _guid = data;
	        AddSex_GetInnerID();
		}
	});
	
	return false;
}

function AddSex_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Sex&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
            _id = data;
			AddSex_SetPageID();
		}
	});
}

function AddSex_SetPageID()
{
    _pageID = _pageID.replace(/\{ID\}/g, _id);
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
    
    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Sex&Operation=Modify&ID=" + _id,
		data : "PageID=" + _pageID,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
}

function EditSex()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.PageID.value == "")
	{
		Alert(_lang_pageid_empty, function(){this.PageID.select();}, this);
		return false;
	}
	
	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)

	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(pageID);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Sex&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function ModifySex(form, id)
{
	if (form.Name.value == "")
	{
		Alert(_lang_name_empty, function(){form.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(form.Name.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Sex&Operation=Modify&ID=" + id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;	
}

function DeleteSex(id)
{
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Sex&Operation=Delete&ID=" + id,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#" + id).remove();
		}
	});
}
//End : 性别管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 人物管理
function AddPerson()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_picture_type_must_be + this.ThumbnailAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Thumbnail.value, this.ThumbnailAllowedType.value))
	{
		Alert(_lang_thumbnail_type_must_be + this.ThumbnailAllowedType.value, function(){this.Thumbnail.select();}, this);
		return false;
	}
	
	if (!this.HitCount.value.match(/^\d+$/))
	{
		Alert(_lang_hitcount_incorrect, function(){this.HitCount.select();}, this);
		return false;
	}

	if (!this.Up.value.match(/^\d+$/))
	{
		Alert(_lang_up_incorrect, function(){this.Up.select();}, this);
		return false;
	}

	if (!this.Down.value.match(/^\d+$/))
	{
		Alert(_lang_down_incorrect, function(){this.Down.select();}, this);
		return false;
	}

	var tag = PrepareTag();

	var sex = $("[name=SexID] option:selected");
	var region = $("[name=RegionID] option:selected");
	var language = $("[name=LanguageID] option:selected");
	
	SetCookie("MakeThumbnail", $("#MakeThumbnail")[0].checked, 10*360*24*60);
		
	_createTime = new Date();
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	if ($("#GuidCheckBox")[0].checked)
		data += "&ID=" + this.ID.value;
	data += "&CreateTime=" + FormatDate(_createTime, "YYYY-MM-DD hh:mm:ss.SSS");
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	data += "&FirstLetter=" + this.FirstLetter.value;
	data += "&SexID=" + this.SexID.value;
	data += "&SexName=" + sex.attr("Name");
	data += "&SexPageGenerate=" + sex.attr("PageGenerate");
	data += "&SexPageTemplate=" + sex.attr("PageTemplate");
	data += "&SexPageID=" + sex.attr("PageID");
	data += "&SexPageExtension=" + sex.attr("PageExtension");
	data += "&RegionID=" + this.RegionID.value;
	data += "&RegionName=" + region.attr("Name");
	data += "&RegionPageGenerate=" + region.attr("PageGenerate");
	data += "&RegionPageTemplate=" + region.attr("PageTemplate");
	data += "&RegionPageID=" + region.attr("PageID");
	data += "&RegionPageExtension=" + region.attr("PageExtension");
	data += "&LanguageID=" + this.LanguageID.value;
	data += "&LanguageName=" + language.attr("Name");
	data += "&LanguagePageGenerate=" + language.attr("PageGenerate");
	data += "&LanguagePageTemplate=" + language.attr("PageTemplate");
	data += "&LanguagePageID=" + language.attr("PageID");
	data += "&LanguagePageExtension=" + language.attr("PageExtension");
	data += "&HitCount=" + this.HitCount.value;
	data += "&Up=" + this.Up.value;
	data += "&Down=" + this.Down.value;
	data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	data += "&IsHeld=" + $("#IsHeldYes")[0].checked;
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	data += "&PageUrl=" + encodeURIComponent(this.PageUrl.value);
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	data += "&TagNames=" + encodeURIComponent(tag.Names);
	data += "&TagPageGenerates=" + encodeURIComponent(tag.PageGenerates);
	data += "&TagPageTemplates=" + encodeURIComponent(tag.PageTemplates);
	data += "&TagPageIDs=" + encodeURIComponent(tag.PageIDs);
	data += "&TagPageExtensions=" + encodeURIComponent(tag.PageExtensions);
	var editor = FCKeditorAPI.GetInstance("HtmlEditor");
	if (editor.IsDirty())
		data += "&Description=" + encodeURIComponent(editor.GetXHTML(false));
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if ($("#MakeThumbnail")[0].checked)
	{
		_uploadThumbnail = false;
	}
	else
	{
		_uploadThumbnail = _uploader.NeedUpload("Thumbnail");
		if (!_uploadThumbnail)
			data += "&Thumbnail=" + encodeURIComponent(this.Thumbnail.value);
	}

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Person&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			_guid = data;
		    AddPerson_GetInnerID();
		}
	});
	
	return false;	
}

function AddPerson_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Person&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
            _id = data;
			AddPerson_SetPageID();
		}
	});
}

function AddPerson_SetPageID()
{
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
	_pageID = _pageID.replace(/\{ID\}/g, _id);
	_pageID = _pageID.replace(/\{YYYYMMDDhhmmss\}/g, FormatDate(_createTime, "YYYYMMDDhhmmss"));
	_pageID = _pageID.replace(/\{YYYY-MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY-MM-DD/hhmmss"));
	_pageID = _pageID.replace(/\{YYYY\/MM\/DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM/DD/hhmmss"));
	_pageID = _pageID.replace(/\{YYYY\/MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM-DD/hhmmss"));

    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Person&Operation=Modify&ID=" + _id,
		data : "PageID=" + encodeURIComponent(_pageID),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
    		AddPerson_AddTag();
		}
	});
}

function AddPerson_AddTag()
{
	if (_tagIndex >= _tags.length)
	{
		Person_UploadPicture();
		return;
	}
	
	var data = "PersonID=" + _guid;
	data += "&TagID=" + _tags[_tagIndex];
	
	_tagIndex++;

    SetStatusMessage(_lang_adding_tag);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Person.Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddPerson_AddTag();
		}
	});
}

function EditPerson()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_picture_type_must_be + this.ThumbnailAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Thumbnail.value, this.ThumbnailAllowedType.value))
	{
		Alert(_lang_thumbnail_type_must_be + this.ThumbnailAllowedType.value, function(){this.Thumbnail.select();}, this);
		return false;
	}
	
	if (!this.HitCount.value.match(/^\d+$/))
	{
		Alert(_lang_hitcount_incorrect, function(){this.HitCount.select();}, this);
		return false;
	}

	if (!this.Up.value.match(/^\d+$/))
	{
		Alert(_lang_up_incorrect, function(){this.Up.select();}, this);
		return false;
	}

	if (!this.Down.value.match(/^\d+$/))
	{
		Alert(_lang_down_incorrect, function(){this.Down.select();}, this);
		return false;
	}

	var dateTime = /^(\d{1,4})(-|\/)(\d{1,2})(-|\/)(\d{1,2})( (\d{1,2}):(\d{1,2}):(\d{1,2}))?$/;
	if (!dateTime.test(this.UpdateTime.value))
	{
	    Alert(_lang_update_time_incorrect, function(){this.UpdateTime.select();}, this);
		return false;
	}

	var tag = PrepareTag();

	var sex = $("[name=SexID] option:selected");
	var region = $("[name=RegionID] option:selected");
	var language = $("[name=LanguageID] option:selected");

	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)
	pageID = pageID.replace(/\{YYYYMMDDhhmmss\}/g, FormatDate(_createTime, "YYYYMMDDhhmmss"));
	pageID = pageID.replace(/\{YYYY-MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY-MM-DD/hhmmss"));
	pageID = pageID.replace(/\{YYYY\/MM\/DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM/DD/hhmmss"));
	pageID = pageID.replace(/\{YYYY\/MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM-DD/hhmmss"));
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	if ($("#GuidCheckBox")[0].checked)
		data += "&ID=" + this.ID.value;
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	else
	    data += "&Style=";
	data += "&UpdateTime=" + this.UpdateTime.value;
	data += "&FirstLetter=" + this.FirstLetter.value;
	data += "&SexID=" + this.SexID.value;
	data += "&SexName=" + sex.attr("Name");
	data += "&SexPageGenerate=" + sex.attr("PageGenerate");
	data += "&SexPageTemplate=" + sex.attr("PageTemplate");
	data += "&SexPageID=" + sex.attr("PageID");
	data += "&SexPageExtension=" + sex.attr("PageExtension");
	data += "&RegionID=" + this.RegionID.value;
	data += "&RegionName=" + region.attr("Name");
	data += "&RegionPageGenerate=" + region.attr("PageGenerate");
	data += "&RegionPageTemplate=" + region.attr("PageTemplate");
	data += "&RegionPageID=" + region.attr("PageID");
	data += "&RegionPageExtension=" + region.attr("PageExtension");
	data += "&LanguageID=" + this.LanguageID.value;
	data += "&LanguageName=" + language.attr("Name");
	data += "&LanguagePageGenerate=" + language.attr("PageGenerate");
	data += "&LanguagePageTemplate=" + language.attr("PageTemplate");
	data += "&LanguagePageID=" + language.attr("PageID");
	data += "&LanguagePageExtension=" + language.attr("PageExtension");
	data += "&HitCount=" + this.HitCount.value;
	data += "&Up=" + this.Up.value;
	data += "&Down=" + this.Down.value;
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	data += "&TagNames=" + encodeURIComponent(tag.Names);
	data += "&TagPageGenerates=" + encodeURIComponent(tag.PageGenerates);
	data += "&TagPageTemplates=" + encodeURIComponent(tag.PageTemplates);
	data += "&TagPageIDs=" + encodeURIComponent(tag.PageIDs);
	data += "&TagPageExtensions=" + encodeURIComponent(tag.PageExtensions);
	if (_recommend == 0 || !$("#IsRecommendedYes")[0].checked)
		data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	if (_hold == 0 || !$("#IsHeldYes")[0].checked)
		data += "&IsHeld=" + $("#IsHeldYes")[0].checked;
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(pageID);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	data += "&PageUrl=" + encodeURIComponent(this.PageUrl.value);
	var editor = FCKeditorAPI.GetInstance("HtmlEditor");
	if (editor.IsDirty())
		data += "&Description=" + encodeURIComponent(editor.GetXHTML(false));
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if ($("#MakeThumbnail")[0].checked)
	{
		_uploadThumbnail = false;
	}
	else
	{
		_uploadThumbnail = _uploader.NeedUpload("Thumbnail");
		if (!_uploadThumbnail)
			data += "&Thumbnail=" + encodeURIComponent(this.Thumbnail.value);
	}

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Person&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditPerson_DeleteTag();
		}
	});

	return false;
}

function EditPerson_DeleteTag()
{
	if (_tagDeleteIndex >= _tagDeleteList.length)
	{
		EditPerson_AddTag();
		return;
	}

	SetStatusMessage(_lang_modifying_tag);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Person.Tag&Operation=Delete&PersonID=" + _guid + "&TagID=" + _tagDeleteList[_tagDeleteIndex++],
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditPerson_DeleteTag();
		}
	});
}

function EditPerson_AddTag()
{
	if (_tagAddIndex >= _tagAddList.length)
	{
        Person_UploadPicture();
		return;
	}
	
	var data = "PersonID=" + _guid;
	data += "&TagID=" + _tagAddList[_tagAddIndex];
	
	_tagAddIndex++;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Person.Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditPerson_AddTag();
		}
	});
}

function Person_UploadPicture()
{
    if (!_uploadPicture)
    {
        Person_UploadThumbnail();
        return;
    }

    SetStatusMessage(_lang_start_upload_picture);
    _uploader.Init({Status:_lang_uploading_picture,Params:"Lang=" + _lang + "&Object=Person&Operation=UploadPicture&ID=" + _id + "&MakeThumbnail=" + $("#MakeThumbnail")[0].checked + "&AddWaterMark=" + $("#AddWaterMarkToPicture")[0].checked});
    _uploader.Upload("Picture", function()
    {
        if (arguments.length == 2)
        {
            Alert(arguments[1]);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
        }
        else
        {
    		Person_UploadThumbnail();
    	}
    });
}

function Person_UploadThumbnail()
{
    if (!_uploadThumbnail)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;

        return;
    }

    SetStatusMessage(_lang_start_upload_thumbnail);
    _uploader.Init({Status:_lang_uploading_thumbnail,Params:"Lang=" + _lang + "&Object=Person&Operation=UploadThumbnail&ID=" + _id + "&AddWaterMark=" + $("#AddWaterMarkToThumbnail")[0].checked});
    _uploader.Upload("Thumbnail", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function MovePerson(from, to)
{
	if (from == to)
		return;
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Person&Operation=" + g_action + "&From=" + from + "&To=" + to + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			Init();
		}
	});
}

function UpdatePerson(action, id)
{
	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdatePerson(action, id);}, this);
		else
			UpdatePerson(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Person&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#List").html(HandleFake404(data, "text"));
				Init();
			}
		});
	}
}

function ReplacePerson()
{
	if (this.From.type == "text" && this.From.value == "")
	{
		Alert(_lang_from_empty, function(){this.From.select();}, this);
		return false;
	}
	
	var data = "Property=" + this.Property.value;
	data += "&From=" + encodeURIComponent(this.From.value);
	data += "&To=" + encodeURIComponent(this.To.value);
	
	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Person&Operation=Replace",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
        	$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}
//End : 人物管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 专辑管理
function AddAlbum()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.ReleaseDate.value != "")
	{
		var regx = /^((\d{4})|(\d{4}-\d{2})|(\d{4}-\d{2}-\d{2}))$/;
		if (!regx.test(this.ReleaseDate.value))
		{
		    Alert(_lang_release_date_incorrect, function(){this.ReleaseDate.select();}, this);
			return false;
		}
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_picture_type_must_be + this.ThumbnailAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Thumbnail.value, this.ThumbnailAllowedType.value))
	{
		Alert(_lang_thumbnail_type_must_be + this.ThumbnailAllowedType.value, function(){this.Thumbnail.select();}, this);
		return false;
	}
	
	if (!this.HitCount.value.match(/^\d+$/))
	{
		Alert(_lang_hitcount_incorrect, function(){this.HitCount.select();}, this);
		return false;
	}

	if (!this.Up.value.match(/^\d+$/))
	{
		Alert(_lang_up_incorrect, function(){this.Up.select();}, this);
		return false;
	}

	if (!this.Down.value.match(/^\d+$/))
	{
		Alert(_lang_down_incorrect, function(){this.Down.select();}, this);
		return false;
	}
	
	var tag = PrepareTag();
	var person = PreparePerson();

	var category = $("[name=CategoryID] option:selected");
	var region = $("[name=RegionID] option:selected");
	var language = $("[name=LanguageID] option:selected");
	var company = $("[name=CompanyID] option:selected");

	SetCookie("CategoryID", category.val(), 10*360*24*60);	
	SetCookie("RegionID", region.val(), 10*360*24*60);	
	SetCookie("LanguageID", language.val(), 10*360*24*60);	
	SetCookie("MakeThumbnail", $("#MakeThumbnail")[0].checked, 10*360*24*60);
		
	_createTime = new Date();
	
	_pageID = this.PageID.value;
	if (_pageID == "")
		_pageID = "{ID}";

	var data = "Name=" + encodeURIComponent(this.Name.value);
	data += "&CreateTime=" + FormatDate(_createTime, "YYYY-MM-DD hh:mm:ss.SSS");
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	data += "&CategoryID=" + this.CategoryID.value;
	data += "&CategoryName=" + category.attr("Name");
	data += "&CategoryPageGenerate=" + category.attr("PageGenerate");
	data += "&CategoryPageTemplate=" + category.attr("PageTemplate");
	data += "&CategoryPageID=" + category.attr("PageID");
	data += "&CategoryPageExtension=" + category.attr("PageExtension");
	data += "&RegionID=" + this.RegionID.value;
	data += "&RegionName=" + region.attr("Name");
	data += "&RegionPageGenerate=" + region.attr("PageGenerate");
	data += "&RegionPageTemplate=" + region.attr("PageTemplate");
	data += "&RegionPageID=" + region.attr("PageID");
	data += "&RegionPageExtension=" + region.attr("PageExtension");
	data += "&LanguageID=" + this.LanguageID.value;
	data += "&LanguageName=" + language.attr("Name");
	data += "&LanguagePageGenerate=" + language.attr("PageGenerate");
	data += "&LanguagePageTemplate=" + language.attr("PageTemplate");
	data += "&LanguagePageID=" + language.attr("PageID");
	data += "&LanguagePageExtension=" + language.attr("PageExtension");
	data += "&CompanyID=" + this.CompanyID.value;
	data += "&CompanyName=" + company.attr("Name");
	data += "&CompanyPageGenerate=" + company.attr("PageGenerate");
	data += "&CompanyPageTemplate=" + company.attr("PageTemplate");
	data += "&CompanyPageID=" + company.attr("PageID");
	data += "&CompanyPageExtension=" + company.attr("PageExtension");
	data += "&ReleaseDate=" + this.ReleaseDate.value;
	data += "&Description=" + encodeURIComponent(this.Description.value);
	data += "&IsRecommended=" + document.getElementById("IsRecommendedYes").checked;
	data += "&IsHeld=" + document.getElementById("IsHeldYes").checked;
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	data += "&PageUrl=" + encodeURIComponent(this.PageUrl.value);
	data += "&HitCount=" + this.HitCount.value;
	data += "&Up=" + this.Up.value;
	data += "&Down=" + this.Down.value;
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	data += "&PersonNames=" + encodeURIComponent(person.Names);
	data += "&PersonPageGenerates=" + encodeURIComponent(person.PageGenerates);
	data += "&PersonPageTemplates=" + encodeURIComponent(person.PageTemplates);
	data += "&PersonPageIDs=" + encodeURIComponent(person.PageIDs);
	data += "&PersonPageExtensions=" + encodeURIComponent(person.PageExtensions);
	data += "&TagNames=" + encodeURIComponent(tag.Names);
	data += "&TagPageGenerates=" + encodeURIComponent(tag.PageGenerates);
	data += "&TagPageTemplates=" + encodeURIComponent(tag.PageTemplates);
	data += "&TagPageIDs=" + encodeURIComponent(tag.PageIDs);
	data += "&TagPageExtensions=" + encodeURIComponent(tag.PageExtensions);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if ($("#MakeThumbnail")[0].checked)
	{
		_uploadThumbnail = false;
	}
	else
	{
		_uploadThumbnail = _uploader.NeedUpload("Thumbnail");
		if (!_uploadThumbnail)
			data += "&Thumbnail=" + encodeURIComponent(this.Thumbnail.value);
	}

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Album&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			_guid = data;
		    AddAlbum_GetInnerID();
		}
	});
	
	return false;	
}

function AddAlbum_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Album&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
            _id = data;
			AddAlbum_SetPageID();
		}
	});
}

function AddAlbum_SetPageID()
{
    _pageID = _pageID.replace(/\{Guid\}/g, _guid);
	_pageID = _pageID.replace(/\{ID\}/g, _id);
	_pageID = _pageID.replace(/\{YYYYMMDDhhmmss\}/g, FormatDate(_createTime, "YYYYMMDDhhmmss"));
	_pageID = _pageID.replace(/\{YYYY-MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY-MM-DD/hhmmss"));
	_pageID = _pageID.replace(/\{YYYY\/MM\/DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM/DD/hhmmss"));
	_pageID = _pageID.replace(/\{YYYY\/MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM-DD/hhmmss"));

    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Album&Operation=Modify&ID=" + _id,
		data : "PageID=" + encodeURIComponent(_pageID),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
    		AddAlbum_AddTag();
		}
	});
}

function AddAlbum_AddTag()
{
	if (_tagIndex >= _tags.length)
	{
		AddAlbum_AddPerson();
		return;
	}
	
	var data = "AlbumID=" + _guid;
	data += "&TagID=" + _tags[_tagIndex];
	
	_tagIndex++;

    SetStatusMessage(_lang_adding_tag);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Album.Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddAlbum_AddTag();
		}
	});
}

function AddAlbum_AddPerson()
{
	if (_personIndex >= _persons.length)
	{
		Album_UploadPicture();
		return;
	}
	
	var data = "AlbumID=" + _guid;
	data += "&PersonID=" + _persons[_personIndex];
	
	_personIndex++;

    SetStatusMessage(_lang_adding_person);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Album.Person&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddAlbum_AddPerson();
		}
	});
}

function EditAlbum()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.ReleaseDate.value != "")
	{
		var regx = /^((\d{4})|(\d{4}-\d{2})|(\d{4}-\d{2}-\d{2}))$/;
		if (!regx.test(this.ReleaseDate.value))
		{
		    Alert(_lang_release_date_incorrect, function(){this.ReleaseDate.select();}, this);
			return false;
		}
	}
	
	if (!IsAllowedType(this.Picture.value, this.PictureAllowedType.value))
	{
		Alert(_lang_picture_type_must_be + this.ThumbnailAllowedType.value, function(){this.Picture.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Thumbnail.value, this.ThumbnailAllowedType.value))
	{
		Alert(_lang_thumbnail_type_must_be + this.ThumbnailAllowedType.value, function(){this.Thumbnail.select();}, this);
		return false;
	}
	
	if (!this.HitCount.value.match(/^\d+$/))
	{
		Alert(_lang_hitcount_incorrect, function(){this.HitCount.select();}, this);
		return false;
	}

	if (!this.Up.value.match(/^\d+$/))
	{
		Alert(_lang_up_incorrect, function(){this.Up.select();}, this);
		return false;
	}

	if (!this.Down.value.match(/^\d+$/))
	{
		Alert(_lang_down_incorrect, function(){this.Down.select();}, this);
		return false;
	}
	
	var dateTime = /^(\d{1,4})(-|\/)(\d{1,2})(-|\/)(\d{1,2})( (\d{1,2}):(\d{1,2}):(\d{1,2}))?$/;
	if (!dateTime.test(this.UpdateTime.value))
	{
	    Alert(_lang_update_time_incorrect, function(){this.UpdateTime.select();}, this);
		return false;
	}

	var tag = PrepareTag();
	var person = PreparePerson();
	
	var category = $("[name=CategoryID] option:selected");
	var region = $("[name=RegionID] option:selected");
	var language = $("[name=LanguageID] option:selected");
	var company = $("[name=CompanyID] option:selected");

	var pageID = this.PageID.value;
	pageID = pageID.replace(/\{Guid\}/g, _guid)
	pageID = pageID.replace(/\{ID\}/g, _id)
	pageID = pageID.replace(/\{YYYYMMDDhhmmss\}/g, FormatDate(_createTime, "YYYYMMDDhhmmss"));
	pageID = pageID.replace(/\{YYYY-MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY-MM-DD/hhmmss"));
	pageID = pageID.replace(/\{YYYY\/MM\/DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM/DD/hhmmss"));
	pageID = pageID.replace(/\{YYYY\/MM-DD\/hhmmss\}/g, FormatDate(_createTime, "YYYY/MM-DD/hhmmss"));

	var data = "Name=" + encodeURIComponent(this.Name.value);
	if (this.CustomStyle.value != "")
	    data += "&Style=" + encodeURIComponent(" style=\"" + this.CustomStyle.value + "\"");
	else
	    data += "&Style=";
	data += "&CategoryID=" + this.CategoryID.value;
	data += "&CategoryName=" + category.attr("Name");
	data += "&CategoryPageGenerate=" + category.attr("PageGenerate");
	data += "&CategoryPageTemplate=" + category.attr("PageTemplate");
	data += "&CategoryPageID=" + category.attr("PageID");
	data += "&CategoryPageExtension=" + category.attr("PageExtension");
	data += "&RegionID=" + this.RegionID.value;
	data += "&RegionName=" + region.attr("Name");
	data += "&RegionPageGenerate=" + region.attr("PageGenerate");
	data += "&RegionPageTemplate=" + region.attr("PageTemplate");
	data += "&RegionPageID=" + region.attr("PageID");
	data += "&RegionPageExtension=" + region.attr("PageExtension");
	data += "&LanguageID=" + this.LanguageID.value;
	data += "&LanguageName=" + language.attr("Name");
	data += "&LanguagePageGenerate=" + language.attr("PageGenerate");
	data += "&LanguagePageTemplate=" + language.attr("PageTemplate");
	data += "&LanguagePageID=" + language.attr("PageID");
	data += "&LanguagePageExtension=" + language.attr("PageExtension");
	data += "&CompanyID=" + this.CompanyID.value;
	data += "&CompanyName=" + company.attr("Name");
	data += "&CompanyPageGenerate=" + company.attr("PageGenerate");
	data += "&CompanyPageTemplate=" + company.attr("PageTemplate");
	data += "&CompanyPageID=" + company.attr("PageID");
	data += "&CompanyPageExtension=" + company.attr("PageExtension");
	data += "&ReleaseDate=" + this.ReleaseDate.value;
	data += "&Description=" + encodeURIComponent(this.Description.value);
	data += "&HitCount=" + this.HitCount.value;
	data += "&Up=" + this.Up.value;
	data += "&Down=" + this.Down.value;
	data += "&UpdateTime=" + this.UpdateTime.value;
	if (_recommend == 0 || !$("#IsRecommendedYes")[0].checked)
		data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	if (_hold == 0 || !$("#IsHeldYes")[0].checked)
		data += "&IsHeld=" + $("#IsHeldYes")[0].checked;
	data += "&PageGenerate=" + $("[name=PageGenerate]:checked").val();
	data += "&PageTemplate=" + encodeURIComponent(this.PageTemplate.value);
	data += "&PageID=" + encodeURIComponent(pageID);
	data += "&PageExtension=" + encodeURIComponent(this.PageExtension.value);
	data += "&PageUrl=" + encodeURIComponent(this.PageUrl.value);
	data += "&MetaKeywords=" + encodeURIComponent(this.MetaKeywords.value);
	data += "&MetaDescription=" + encodeURIComponent(this.MetaDescription.value);
	data += "&PersonNames=" + encodeURIComponent(person.Names);
	data += "&PersonPageGenerates=" + encodeURIComponent(person.PageGenerates);
	data += "&PersonPageTemplates=" + encodeURIComponent(person.PageTemplates);
	data += "&PersonPageIDs=" + encodeURIComponent(person.PageIDs);
	data += "&PersonPageExtensions=" + encodeURIComponent(person.PageExtensions);
	data += "&TagNames=" + encodeURIComponent(tag.Names);
	data += "&TagPageGenerates=" + encodeURIComponent(tag.PageGenerates);
	data += "&TagPageTemplates=" + encodeURIComponent(tag.PageTemplates);
	data += "&TagPageIDs=" + encodeURIComponent(tag.PageIDs);
	data += "&TagPageExtensions=" + encodeURIComponent(tag.PageExtensions);
	_uploadPicture = _uploader.NeedUpload("Picture");
	if (!_uploadPicture)
		data += "&Picture=" + encodeURIComponent(this.Picture.value);
	if ($("#MakeThumbnail")[0].checked)
	{
		_uploadThumbnail = false;
	}
	else
	{
		_uploadThumbnail = _uploader.NeedUpload("Thumbnail");
		if (!_uploadThumbnail)
			data += "&Thumbnail=" + encodeURIComponent(this.Thumbnail.value);
	}

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Album&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditAlbum_DeleteTag();
		}
	});

	return false;
}

function EditAlbum_DeleteTag()
{
	if (_tagDeleteIndex >= _tagDeleteList.length)
	{
		EditAlbum_AddTag();
		return;
	}

	SetStatusMessage(_lang_modifying_tag);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Album.Tag&Operation=Delete&AlbumID=" + _guid + "&TagID=" + _tagDeleteList[_tagDeleteIndex++],
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditAlbum_DeleteTag();
		}
	});
}

function EditAlbum_AddTag()
{
	if (_tagAddIndex >= _tagAddList.length)
	{
        EditAlbum_DeletePerson();
		return;
	}
	
	var data = "AlbumID=" + _guid;
	data += "&TagID=" + _tagAddList[_tagAddIndex];
	
	_tagAddIndex++;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Album.Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditAlbum_AddTag();
		}
	});
}

function EditAlbum_DeletePerson()
{
	if (_personDeleteIndex >= _personDeleteList.length)
	{
		EditAlbum_AddPerson();
		return;
	}

	SetStatusMessage(_lang_modifying_person);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Album.Person&Operation=Delete&AlbumID=" + _guid + "&PersonID=" + _personDeleteList[_personDeleteIndex++],
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditAlbum_DeletePerson();
		}
	});
}

function EditAlbum_AddPerson()
{
	if (_personAddIndex >= _personAddList.length)
	{
        Album_UploadPicture();
		return;
	}
	
	var data = "AlbumID=" + _guid;
	data += "&PersonID=" + _personAddList[_personAddIndex];
	
	_personAddIndex++;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Album.Person&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditAlbum_AddPerson();
		}
	});
}

function Album_UploadPicture()
{
    if (!_uploadPicture)
    {
        Album_UploadThumbnail();
        return;
    }

    SetStatusMessage(_lang_start_upload_picture);
    _uploader.Init({Status:_lang_uploading_picture,Params:"Lang=" + _lang + "&Object=Album&Operation=UploadPicture&ID=" + _id + "&MakeThumbnail=" + $("#MakeThumbnail")[0].checked + "&AddWaterMark=" + $("#AddWaterMarkToPicture")[0].checked});
    _uploader.Upload("Picture", function()
    {
        if (arguments.length == 2)
        {
            Alert(arguments[1]);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
        }
        else
        {
    		Album_UploadThumbnail();
    	}
    });
}

function Album_UploadThumbnail()
{
    if (!_uploadThumbnail)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;

        return;
    }

    SetStatusMessage(_lang_start_upload_thumbnail);
    _uploader.Init({Status:_lang_uploading_thumbnail,Params:"Lang=" + _lang + "&Object=Album&Operation=UploadThumbnail&ID=" + _id + "&AddWaterMark=" + $("#AddWaterMarkToThumbnail")[0].checked});
    _uploader.Upload("Thumbnail", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function MoveAlbum(from, to)
{
	if (from == to)
		return;
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Album&Operation=" + g_action + "&From=" + from + "&To=" + to + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			Init();
		}
	});
}

function UpdateAlbum(action, id)
{
	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdateAlbum(action, id);}, this);
		else
			UpdateAlbum(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Album&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#List").html(HandleFake404(data, "text"));
				Init();
			}
		});
	}
}

function ReplaceAlbum()
{
	if (this.From.type == "text" && this.From.value == "")
	{
		Alert(_lang_from_empty, function(){this.From.select();}, this);
		return false;
	}
	
	var data = "Property=" + this.Property.value;
	data += "&From=" + encodeURIComponent(this.From.value);
	data += "&To=" + encodeURIComponent(this.To.value);
	
	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Album&Operation=Replace",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
        	$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}
//End : 专辑管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 歌词管理
function AddLyric()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.Content.value == "")
	{
		Alert(_lang_content_empty, function(){this.Content.select();}, this);
		return false;
	}
	
	if (!this.HitCount.value.match(/^\d+$/))
	{
		Alert(_lang_hitcount_incorrect, function(){this.HitCount.select();}, this);
		return false;
	}

	if (!this.Up.value.match(/^\d+$/))
	{
		Alert(_lang_up_incorrect, function(){this.Up.select();}, this);
		return false;
	}

	if (!this.Down.value.match(/^\d+$/))
	{
		Alert(_lang_down_incorrect, function(){this.Down.select();}, this);
		return false;
	}

	if (!this.Error.value.match(/^\d+$/))
	{
		Alert(_lang_error_incorrect, function(){this.Error.select();}, this);
		return false;
	}

	var data = "&Name=" + encodeURIComponent(this.Name.value);
	data += "&Content=" + encodeURIComponent(this.Content.value);
	data += "&MusicID=" + this.Music.id;
	data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	data += "&IsHeld=" + $("#IsHeldYes")[0].checked;
	data += "&HitCount=" + this.HitCount.value;
	data += "&Up=" + this.Up.value;
	data += "&Down=" + this.Down.value;
	data += "&Error=" + this.Error.value;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Lyric&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function EditLyric()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.Content.value == "")
	{
		Alert(_lang_content_empty, function(){this.Content.select();}, this);
		return false;
	}
	
	if (!this.HitCount.value.match(/^\d+$/))
	{
		Alert(_lang_hitcount_incorrect, function(){this.HitCount.select();}, this);
		return false;
	}

	if (!this.Up.value.match(/^\d+$/))
	{
		Alert(_lang_up_incorrect, function(){this.Up.select();}, this);
		return false;
	}

	if (!this.Down.value.match(/^\d+$/))
	{
		Alert(_lang_down_incorrect, function(){this.Down.select();}, this);
		return false;
	}

	if (!this.Error.value.match(/^\d+$/))
	{
		Alert(_lang_error_incorrect, function(){this.Error.select();}, this);
		return false;
	}
	
	var data = "&Name=" + encodeURIComponent(this.Name.value);
	data += "&Content=" + encodeURIComponent(this.Content.value);
	data += "&MusicID=" + this.Music.id;
	if (_recommend == 0 || !$("#IsRecommendedYes")[0].checked)
		data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	if (_hold == 0 || !$("#IsHeldYes")[0].checked)
		data += "&IsHeld=" + $("#IsHeldYes")[0].checked;
	data += "&HitCount=" + this.HitCount.value;
	data += "&Up=" + this.Up.value;
	data += "&Down=" + this.Down.value;
	data += "&Error=" + this.Error.value;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Lyric&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function SetDefaultLyric()
{
    var id = $("[name=Music]").attr("InnerID");
	if (id == "")
	{
		Alert(_lang_no_select);
		return;
	}

    var me = $(this);
	me.eq(0).attr("disabled", true);
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Music&Operation=Modify&ID=" + id,
		data : "Lyric=" + encodeURIComponent($("[name=Content]").val()),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			me.eq(0).attr("disabled", false);
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			me.eq(0).attr("disabled", false);
		}
	});
}

function MoveLyric(from, to)
{
	if (from == to)
		return;
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Lyric&Operation=" + g_action + "&From=" + from + "&To=" + to + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			Init();
		}
	});
}

function UpdateLyric(action, id)
{
	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdateLyric(action, id);}, this);
		else
			UpdateLyric(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Lyric&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#List").html(HandleFake404(data, "text"));
				Init();
			}
		});
	}
}
//End : 歌词管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 字幕管理
function AddTitle()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.Content.value == "")
	{
		Alert(_lang_content_empty, function(){this.Content.select();}, this);
		return false;
	}
	
	if (!this.HitCount.value.match(/^\d+$/))
	{
		Alert(_lang_hitcount_incorrect, function(){this.HitCount.select();}, this);
		return false;
	}

	if (!this.Up.value.match(/^\d+$/))
	{
		Alert(_lang_up_incorrect, function(){this.Up.select();}, this);
		return false;
	}

	if (!this.Down.value.match(/^\d+$/))
	{
		Alert(_lang_down_incorrect, function(){this.Down.select();}, this);
		return false;
	}

	if (!this.Error.value.match(/^\d+$/))
	{
		Alert(_lang_error_incorrect, function(){this.Error.select();}, this);
		return false;
	}

	var data = "&Name=" + encodeURIComponent(this.Name.value);
	data += "&Content=" + encodeURIComponent(this.Content.value);
	data += "&MusicID=" + this.Music.id;
	data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	data += "&IsHeld=" + $("#IsHeldYes")[0].checked;
	data += "&HitCount=" + this.HitCount.value;
	data += "&Up=" + this.Up.value;
	data += "&Down=" + this.Down.value;
	data += "&Error=" + this.Error.value;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Title&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function EditTitle()
{
	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	if (this.Content.value == "")
	{
		Alert(_lang_content_empty, function(){this.Content.select();}, this);
		return false;
	}
	
	if (!this.HitCount.value.match(/^\d+$/))
	{
		Alert(_lang_hitcount_incorrect, function(){this.HitCount.select();}, this);
		return false;
	}

	if (!this.Up.value.match(/^\d+$/))
	{
		Alert(_lang_up_incorrect, function(){this.Up.select();}, this);
		return false;
	}

	if (!this.Down.value.match(/^\d+$/))
	{
		Alert(_lang_down_incorrect, function(){this.Down.select();}, this);
		return false;
	}

	if (!this.Error.value.match(/^\d+$/))
	{
		Alert(_lang_error_incorrect, function(){this.Error.select();}, this);
		return false;
	}
	
	var data = "&Name=" + encodeURIComponent(this.Name.value);
	data += "&Content=" + encodeURIComponent(this.Content.value);
	data += "&MusicID=" + this.Music.id;
	if (_recommend == 0 || !$("#IsRecommendedYes")[0].checked)
		data += "&IsRecommended=" + $("#IsRecommendedYes")[0].checked;
	if (_hold == 0 || !$("#IsHeldYes")[0].checked)
		data += "&IsHeld=" + $("#IsHeldYes")[0].checked;
	data += "&HitCount=" + this.HitCount.value;
	data += "&Up=" + this.Up.value;
	data += "&Down=" + this.Down.value;
	data += "&Error=" + this.Error.value;

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Title&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
		    Alert(_lang_operation_success);
		    SetStatusMessage();
		    $(":submit")[0].disabled = false;
		}
	});
	
	return false;
}

function SetDefaultTitle()
{
    var id = $("[name=Music]").attr("InnerID");
	if (id == "")
	{
		Alert(_lang_no_select);
		return;
	}

    var me = $(this);
	me.eq(0).attr("disabled", true);
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Music&Operation=Modify&ID=" + id,
		data : "Title=" + encodeURIComponent($("[name=Content]").val()),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			me.eq(0).attr("disabled", false);
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();
			me.eq(0).attr("disabled", false);
		}
	});
}

function MoveTitle(from, to)
{
	if (from == to)
		return;
	
	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Title&Operation=" + g_action + "&From=" + from + "&To=" + to + "&Transfer=" + encodeURIComponent(BuildHeader()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			Init();
		}
	});
}

function UpdateTitle(action, id)
{
	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdateTitle(action, id);}, this);
		else
			UpdateTitle(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Lang=" + _lang + "&Object=Title&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#List").html(HandleFake404(data, "text"));
				Init();
			}
		});
	}
}
//End : 字幕管理
//-------------------------------------------------

function Init()
{
	if (typeof (_page) == "undefined")
		return;
	
	if (_page == "music_category_add")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
		
		$("form").eq(0).submit(AddMusicCategory);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
		
		$("#GuidCheckBox").click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = "Disabled";
			else
				this.form.ID.className = "Text";
		});
	}
	else if (_page == "music_category_edit")
	{
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;
		
		if (_style.indexOf(" style=\"") != -1)
		{
		    _style = _style.substr(8, _style.length - 9);
		    var props = _style.split(";");
		    for (var i = 0; i < props.length; i++)
		    {
		        if (props[i] != "font-weight:bold" && props[i] != "font-style:italic" && props[i].indexOf("color:") != 0)
		        {
    		        $("#Custom")[0].checked = true;
    		        $("[name=CustomStyle]").show();
		        }
		        
		        if (props[i] == "font-weight:bold")
		            $("#Bold")[0].checked = true;
		            
		        if (props[i] == "font-style:italic")
		            $("#Italic")[0].checked = true;
		            
		        if (props[i].indexOf("color:") == 0)
		            $("#Color").val(props[i].substr(6));
		    }
		    $("[name=CustomStyle]").val(_style);
		}

		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
		
		$("form").eq(0).submit(EditMusicCategory);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
		
		$("#GuidCheckBox").click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = "Disabled";
			else
				this.form.ID.className = "Text";
		});
	}
	else if (_page == "music_category_list")
	{
	    MakeButton();

	    $("tr").each(function ()
		{
			var id = $(this).attr("ItemID");
			
			$(this).find("form").submit(function(){ModifyMusicCategory(this, id);return false;});
			$(this).find("[sort=" + id + "]").mouseover(function(){this.className += " Move_MouseOver";}).mouseout(function(){this.className="Move";});

			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteMusicCategory(id);}, this);
				return false;
			});
		});
		
		if (arguments.length == 0)
		    return;

		InitMove(null,"Move", null, MoveMusicCategory);
		
		$("#IsDisplay,#IsRecommended,#IsHeld,#Sort").change(Search);
	}
	else if (_page == "album_category_add")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
		
		$("form").eq(0).submit(AddAlbumCategory);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
		
		$("#GuidCheckBox").click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = "Disabled";
			else
				this.form.ID.className = "Text";
		});
	}
	else if (_page == "album_category_edit")
	{
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;
		
		if (_style.indexOf(" style=\"") != -1)
		{
		    _style = _style.substr(8, _style.length - 9);
		    var props = _style.split(";");
		    for (var i = 0; i < props.length; i++)
		    {
		        if (props[i] != "font-weight:bold" && props[i] != "font-style:italic" && props[i].indexOf("color:") != 0)
		        {
    		        $("#Custom")[0].checked = true;
    		        $("[name=CustomStyle]").show();
		        }
		        
		        if (props[i] == "font-weight:bold")
		            $("#Bold")[0].checked = true;
		            
		        if (props[i] == "font-style:italic")
		            $("#Italic")[0].checked = true;
		            
		        if (props[i].indexOf("color:") == 0)
		            $("#Color").val(props[i].substr(6));
		    }
		    $("[name=CustomStyle]").val(_style);
		}

		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
		
		$("form").eq(0).submit(EditAlbumCategory);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
		
		$("#GuidCheckBox").click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = "Disabled";
			else
				this.form.ID.className = "Text";
		});
	}
	else if (_page == "album_category_list")
	{
	    MakeButton();

	    $("tr").each(function ()
		{
			var id = $(this).attr("ItemID");
			
			$(this).find("form").submit(function(){ModifyAlbumCategory(this, id);return false;});
			$(this).find("[sort=" + id + "]").mouseover(function(){this.className += " Move_MouseOver";}).mouseout(function(){this.className="Move";});

			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteAlbumCategory(id);}, this);
				return false;
			});
		});
		
		if (arguments.length == 0)
		    return;

		InitMove(null,"Move", null, MoveAlbumCategory);
		
		$("#IsDisplay,#IsRecommended,#IsHeld,#Sort").change(Search);
	}
	else if (_page == "tag_list")
	{
		$("form").each(function()
		{
			var id = this.action;

			$(this).submit(function(){return ModifyTag(this, id)});
		});

		if (arguments.length == 0)
		    return;

		$("#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
		$("#Delete").click(function(){DeleteTag();});
	}
	else if (_page == "tag_select")
	{
		$(":checkbox").click(function()
		{
	        if ($.browser.msie)
				window.dialogArguments.SelectTag({ID:$(this).attr("ID"),Name:$(this).attr("Name"),PageGenerate:$(this).attr("PageGenerate"),PageTemplate:$(this).attr("PageTemplate"),PageID:$(this).attr("PageID"),PageExtension:$(this).attr("PageExtension")}, this.checked);
			else
				window.opener.SelectTag({ID:$(this).attr("ID"),Name:$(this).attr("Name"),PageGenerate:$(this).attr("PageGenerate"),PageTemplate:$(this).attr("PageTemplate"),PageID:$(this).attr("PageID"),PageExtension:$(this).attr("PageExtension")}, this.checked);
		});
		
		if (arguments.length == 0)
		    return;

		$("#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#Ok").click(function(){window.close();});
	}
	else if (_page == "tag_add")
	{
		$("form").submit(AddTag);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "tag_edit")
	{
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;

		$("form").submit(EditTag);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "region_list")
	{
		$("tr").each(function()
		{
			var id = $(this).attr("ItemID");
			
			$(this).find("form").submit(function(){ModifyRegion(this, id);return false;});
			$(this).find("[sort=" + id + "]").mouseover(function(){this.className += " Move_MouseOver";}).mouseout(function(){this.className="Move";});

			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteRegion(id);}, this);
				return false;
			});
		});
		
		InitMove(null,"Move", null, MoveRegion);
	}
	else if (_page == "region_add")
	{
		$("form").submit(AddRegion);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "region_edit")
	{
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;

		$("form").submit(EditRegion);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	if (_page == "company_list")
	{
		$("tr").each(function()
		{
			var id = this.id;
			
			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteCompany(id);}, this);
				return false;
			});
		});

		if (arguments.length == 0)
		    return;

		$("#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
	}
	else if (_page == "company_add")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Logo", "LogoTextbox", "LogoBrowse");
		
		$("form").eq(0).submit(AddCompany);
		$("#LogoTextbox").change(function(){$("#LogoView").attr("src", this.value)});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "company_edit")
	{
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;

		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Logo", "LogoTextbox", "LogoBrowse");
		
		$("form").eq(0).submit(EditCompany);
		$("#LogoTextbox").change(function(){$("#LogoView").attr("src", this.value)});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "config_basic")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Album", "AlbumTextbox", "AlbumBrowse");
		_uploader.Add("Person", "PersonTextbox", "PersonBrowse");

		$("form").eq(0).submit(SetBasicSettings);
		$("#CreateAllPackFile").click(CreateAllPackFile);
		$("#CreateAllAlbumThumbnail").click(CreateAllAlbumThumbnail);
		$("#CreateAllPersonThumbnail").click(CreateAllPersonThumbnail);
		$("#AlbumTextbox").change(function(){$("#AlbumDefaultThumbnailView").attr("src", this.value)});
		$("#PersonTextbox").change(function(){$("#PersonDefaultThumbnailView").attr("src", this.value)});
	}
	else if (_page == "language_list")
	{
		$("tr").each(function()
		{
			var id = this.id;
			
			$(this).find("form").submit(function(){return ModifyLanguage(this, id);});

			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteLanguage(id);}, this);
				return false;
			});
		});
	}
	else if (_page == "language_add")
	{
		$("form").eq(0).submit(AddLanguage);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "language_edit")
	{
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;

		$("form").eq(0).submit(EditLanguage);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "music_add")
	{
	    var form = $("form")[0];
	    CheckAndSelect(form.CategoryID, GetCookie("CategoryID"));
	    CheckAndSelect(form.RegionID, GetCookie("RegionID"));
	    CheckAndSelect(form.LanguageID, GetCookie("LanguageID"));
	    CheckAndSelect(form.PlayerID, GetCookie("PlayerID"));

		_uploader.Init({WebPath:_webPath});
        _uploader.Add("URL", "URLTextbox", "URLBrowse");
        _uploader.Add("Download", "DownloadTextbox", "DownloadBrowse");
               
		$("form").eq(0).submit(AddMusic);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("#TagSelect").click(function(){ShowSelectDialog("Tag")});
		$("#PersonSelect").click(function(){ShowSelectDialog("Person")});
		$("#AlbumSelect").click(function(){ShowSelectDialog("Album")});
		$("#URLSelect").click(function(){ShowSelectFileDialog("URL")});
		$("#DownloadSelect").click(function(){ShowSelectFileDialog("Download")});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "music_edit")
	{
        CheckAndSelect(document.forms[0].PlayerID, _playerID);

		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;

		if (_style.indexOf(" style=\"") != -1)
		{
		    _style = _style.substr(8, _style.length - 9);
		    var props = _style.split(";");
		    for (var i = 0; i < props.length; i++)
		    {
		        if (props[i] != "font-weight:bold" && props[i] != "font-style:italic" && props[i].indexOf("color:") != 0)
		        {
    		        $("#Custom")[0].checked = true;
    		        $("[name=CustomStyle]").show();
		        }
		        
		        if (props[i] == "font-weight:bold")
		            $("#Bold")[0].checked = true;
		            
		        if (props[i] == "font-style:italic")
		            $("#Italic")[0].checked = true;
		            
		        if (props[i].indexOf("color:") == 0)
		            $("#Color").val(props[i].substr(6));
		    }
		    $("[name=CustomStyle]").val(_style);
		}
        
        for (var i = 0; i < _tags.length; i++)
        {
	        SelectTag(_tags[i], true);
        }
        
        for (var i = 0; i < _albums.length; i++)
        {
	        SelectAlbum(_albums[i], true);
        }
        
        for (var i = 0; i < _persons.length; i++)
        {
	        SelectPerson(_persons[i], true);
        }

		_uploader.Init({WebPath:_webPath});
        _uploader.Add("URL", "URLTextbox", "URLBrowse");
        _uploader.Add("Download", "DownloadTextbox", "DownloadBrowse");

		$("form").eq(0).submit(EditMusic);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("#TagSelect").click(function(){ShowSelectDialog("Tag")});
		$("#PersonSelect").click(function(){ShowSelectDialog("Person")});
		$("#AlbumSelect").click(function(){ShowSelectDialog("Album")});
		$("#URLSelect").click(function(){ShowSelectFileDialog("URL")});
		$("#DownloadSelect").click(function(){ShowSelectFileDialog("Download")});
		$("#Now").click(function(){$("[name=UpdateTime]").val(FormatDate(new Date(), "YYYY-MM-DD hh:mm:ss"));return false;});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "music_list")
	{
		MakeButton();
		
		$("tr").each(function()
		{
			$(this).find("[sort=" + this.id + "]").mouseover(function(){this.className += " Move_MouseOver";}).mouseout(function(){this.className="Move";});
		});
	
		if (arguments.length == 0)
		    return;

		InitMove(null, "Move", null, MoveMusic);
		
		$("#IsRecycled,#IsChecked,#IsRecommended,#IsHeld,#RegionID,#LanguageID,#CategoryID,#NeedPack,#Sort").change(Search);
		$("#IncludeSubCategory,#IncludeSubRegion").click(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
	}
	else if (_page == "music_replace")
	{
		_xmlDoc = CreateXmlDom();

		$("form").submit(ReplaceMusic);
		$("[name=Property]").change(Property_OnChange);
	}
	else if (_page == "music_select")
	{
		$("td a").click(function()
		{
	        if ($.browser.msie)
				window.dialogArguments.SelectMusic(this);
			else
				window.opener.SelectMusic(this);
			window.close();
		});
		
		if (arguments.length == 0)
		    return;

		$("#RegionID,#LanguageID,#CategoryID,#Sort").change(Search);
		$("#IncludeSubCategory,#IncludeSubRegion").click(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
	}
	else if (_page == "music_comment_list")
	{
		MakeButton();

		if (arguments.length == 0)
		    return;

		$("#IsChecked").change(Search);
		$("#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
		$("#Delete").click(function(){UpdateMusicComment("Delete");});
	}
	else if (_page == "music_comment_edit")
	{
		$("form").eq(0).submit(EditMusicComment);
	}
	else if (_page == "album_comment_list")
	{
		MakeButton();

		if (arguments.length == 0)
		    return;

		$("#IsChecked").change(Search);
		$("#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
		$("#Delete").click(function(){UpdateAlbumComment("Delete");});
	}
	else if (_page == "album_comment_edit")
	{
		$("form").eq(0).submit(EditAlbumComment);
	}
	else if (_page == "person_comment_list")
	{
		MakeButton();

		if (arguments.length == 0)
		    return;

		$("#IsChecked").change(Search);
		$("#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
		$("#Delete").click(function(){UpdatePersonComment("Delete");});
	}
	else if (_page == "person_comment_edit")
	{
		$("form").eq(0).submit(EditPersonComment);
	}
	else if (_page == "sex_list")
	{
		$("tr").each(function()
		{
			var id = $(this).attr("id");
			
			$(this).find("form").submit(function(){ModifySex(this, id);return false;});

			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteSex(id);}, this);
				return false;
			});
		});
	}
	else if (_page == "sex_add")
	{
		$("form").eq(0).submit(AddSex);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "sex_edit")
	{
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;

		$("form").eq(0).submit(EditSex);
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "person_add")
	{
	    if (GetCookie("MakeThumbnail") == "false")
	    {
		    $("#MakeThumbnail")[0].checked = false;
		    $("#ThumbnailRow").show();
	    }
	    else
	    {
		    $("#MakeThumbnail")[0].checked = true;
		    $("#ThumbnailRow").hide();
		}

		_uploader.Init({WebPath:_webPath});
        _uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
        _uploader.Add("Thumbnail", "ThumbnailTextbox", "ThumbnailBrowse");
               
		$("form").eq(0).submit(AddPerson);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("#TagSelect").click(function(){ShowSelectDialog("Tag")});
		$("#PictureSelect").click(function(){ShowSelectFileDialog("Picture")});
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#ThumbnailSelect").click(function(){ShowSelectFileDialog("Thumbnail")});
		$("#ThumbnailTextbox").change(function(){$("#ThumbnailView").attr("src", this.value)});
		$("#MakeThumbnail").click(function(){this.checked ? $("#ThumbnailRow").hide() : $("#ThumbnailRow").show();});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
		
		$("#GuidCheckBox").click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = "Disabled";
			else
				this.form.ID.className = "Text";
		});
	}
	else if (_page == "person_edit")
	{
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;

		if (_style.indexOf(" style=\"") != -1)
		{
		    _style = _style.substr(8, _style.length - 9);
		    var props = _style.split(";");
		    for (var i = 0; i < props.length; i++)
		    {
		        if (props[i] != "font-weight:bold" && props[i] != "font-style:italic" && props[i].indexOf("color:") != 0)
		        {
    		        $("#Custom")[0].checked = true;
    		        $("[name=CustomStyle]").show();
		        }
		        
		        if (props[i] == "font-weight:bold")
		            $("#Bold")[0].checked = true;
		            
		        if (props[i] == "font-style:italic")
		            $("#Italic")[0].checked = true;
		            
		        if (props[i].indexOf("color:") == 0)
		            $("#Color").val(props[i].substr(6));
		    }
		    $("[name=CustomStyle]").val(_style);
		}
        
        for (var i = 0; i < _tags.length; i++)
        {
	        SelectTag(_tags[i], true)
        }

		_uploader.Init({WebPath:_webPath});
        _uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
        _uploader.Add("Thumbnail", "ThumbnailTextbox", "ThumbnailBrowse");

		$("form").eq(0).submit(EditPerson);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("#TagSelect").click(function(){ShowSelectDialog("Tag")});
		$("#PictureSelect").click(function(){ShowSelectFileDialog("Picture")});
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#ThumbnailSelect").click(function(){ShowSelectFileDialog("Thumbnail")});
		$("#ThumbnailTextbox").change(function(){$("#ThumbnailView").attr("src", this.value)});
		$("#MakeThumbnail").click(function(){this.checked ? $("#ThumbnailRow").hide() : $("#ThumbnailRow").show();});
		$("#Now").click(function(){$("[name=UpdateTime]").val(FormatDate(new Date(), "YYYY-MM-DD hh:mm:ss"));return false;});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
		
		$("#GuidCheckBox").click(function()
		{
			this.form.ID.disabled = !this.checked;
			if (this.form.ID.disabled)
				this.form.ID.className = "Disabled";
			else
				this.form.ID.className = "Text";
		});
	}
	else if (_page == "person_list")
	{
		MakeButton();
		
		$("tr").each(function()
		{
			$(this).find("[sort=" + this.id + "]").mouseover(function(){this.className += " Move_MouseOver";}).mouseout(function(){this.className="Move";});
		});
    	
		if (arguments.length == 0)
		    return;

	    if (GetCookie("ListByPicture").toLowerCase() == "true")
		    $("#ListByPicture")[0].checked = true;	
	    else
		    $("#ListByPicture")[0].checked = false;
	
		InitMove(null, "Move", null, MovePerson);
		
		$("#IsRecycled,#IsChecked,#IsRecommended,#IsHeld,#RegionID,#LanguageID,#SexID,#Sort").change(Search);
		$("#IncludeSubRegion").click(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
		
		$("#ListByPicture").click(function()
		{
	        SetCookie("ListByPicture", $("#ListByPicture")[0].checked, 10*360*24*60);
	        Search();
		});
	}
	else if (_page == "person_select")
	{
		$("#List :checkbox").click(function()
		{
	        if ($.browser.msie)
				window.dialogArguments.SelectPerson({ID:$(this).attr("ID"),Name:$(this).attr("Name"),PageGenerate:$(this).attr("PageGenerate"),PageTemplate:$(this).attr("PageTemplate"),PageID:$(this).attr("PageID"),PageExtension:$(this).attr("PageExtension")}, this.checked);
			else
				window.opener.SelectPerson({ID:$(this).attr("ID"),Name:$(this).attr("Name"),PageGenerate:$(this).attr("PageGenerate"),PageTemplate:$(this).attr("PageTemplate"),PageID:$(this).attr("PageID"),PageExtension:$(this).attr("PageExtension")}, this.checked);
		});
		
		if (arguments.length == 0)
		    return;

		$("#RegionID,#LanguageID,#SexID,#Sort").change(Search);
		$("#IncludeSubRegion").click(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#Ok").click(function(){window.close();});
	}
	else if (_page == "person_replace")
	{
		_xmlDoc = CreateXmlDom();

		$("form").submit(ReplacePerson);
		$("[name=Property]").change(Property_OnChange);
	}
	else if (_page == "album_add")
	{
	    var form = $("form")[0];
	    CheckAndSelect(form.CategoryID, GetCookie("CategoryID"));
	    CheckAndSelect(form.RegionID, GetCookie("RegionID"));
	    CheckAndSelect(form.LanguageID, GetCookie("LanguageID"));
    	
	    if (GetCookie("MakeThumbnail") == "false")
	    {
		    $("#MakeThumbnail")[0].checked = false;
		    $("#ThumbnailRow").show();
	    }
	    else
	    {
		    $("#MakeThumbnail")[0].checked = true;
		    $("#ThumbnailRow").hide();
		}

		_uploader.Init({WebPath:_webPath});
        _uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
        _uploader.Add("Thumbnail", "ThumbnailTextbox", "ThumbnailBrowse");
               
		$("form").eq(0).submit(AddAlbum);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("#TagSelect").click(function(){ShowSelectDialog("Tag")});
		$("#PictureSelect").click(function(){ShowSelectFileDialog("Picture")});
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#ThumbnailSelect").click(function(){ShowSelectFileDialog("Thumbnail")});
		$("#ThumbnailTextbox").change(function(){$("#ThumbnailView").attr("src", this.value)});
		$("#PersonSelect").click(function(){ShowSelectDialog("Person")});
		$("#MakeThumbnail").click(function(){this.checked ? $("#ThumbnailRow").hide() : $("#ThumbnailRow").show();});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "album_edit")
	{
		$("[name=PageGenerate][value=" + _pageGenerate + "]")[0].checked = true;

		if (_style.indexOf(" style=\"") != -1)
		{
		    _style = _style.substr(8, _style.length - 9);
		    var props = _style.split(";");
		    for (var i = 0; i < props.length; i++)
		    {
		        if (props[i] != "font-weight:bold" && props[i] != "font-style:italic" && props[i].indexOf("color:") != 0)
		        {
    		        $("#Custom")[0].checked = true;
    		        $("[name=CustomStyle]").show();
		        }
		        
		        if (props[i] == "font-weight:bold")
		            $("#Bold")[0].checked = true;
		            
		        if (props[i] == "font-style:italic")
		            $("#Italic")[0].checked = true;
		            
		        if (props[i].indexOf("color:") == 0)
		            $("#Color").val(props[i].substr(6));
		    }
		    $("[name=CustomStyle]").val(_style);
		}
        
        for (var i = 0; i < _tags.length; i++)
        {
	        SelectTag(_tags[i], true)
        }
        
        for (var i = 0; i < _persons.length; i++)
        {
	        SelectPerson(_persons[i], true)
        }

		_uploader.Init({WebPath:_webPath});
        _uploader.Add("Picture", "PictureTextbox", "PictureBrowse");
        _uploader.Add("Thumbnail", "ThumbnailTextbox", "ThumbnailBrowse");

		$("form").eq(0).submit(EditAlbum);
		$("#Bold,#Italic,#Custom").click(Style_OnChange);
		$("#Color").keyup(Style_OnChange);
		$("#TagSelect").click(function(){ShowSelectDialog("Tag")});
		$("#PictureSelect").click(function(){ShowSelectFileDialog("Picture")});
		$("#PictureTextbox").change(function(){$("#PictureView").attr("src", this.value)});
		$("#ThumbnailSelect").click(function(){ShowSelectFileDialog("Thumbnail")});
		$("#ThumbnailTextbox").change(function(){$("#ThumbnailView").attr("src", this.value)});
		$("#PersonSelect").click(function(){ShowSelectDialog("Person")});
		$("#MakeThumbnail").click(function(){this.checked ? $("#ThumbnailRow").hide() : $("#ThumbnailRow").show();});
		$("#Now").click(function(){$("[name=UpdateTime]").val(FormatDate(new Date(), "YYYY-MM-DD hh:mm:ss"));return false;});
		$("#PageIDCandidate").change(PageIDCandidate_OnChange);
	}
	else if (_page == "album_list")
	{
		MakeButton();
		
		$("tr").each(function()
		{
			$(this).find("[sort=" + this.id + "]").mouseover(function(){this.className += " Move_MouseOver";}).mouseout(function(){this.className="Move";});
		});
    	
		if (arguments.length == 0)
		    return;

	    if (GetCookie("ListByPicture").toLowerCase() == "true")
		    $("#ListByPicture")[0].checked = true;	
	    else
		    $("#ListByPicture")[0].checked = false;
	
		InitMove(null, "Move", null, MoveAlbum);
		
		$("#IsRecycled,#IsChecked,#IsRecommended,#IsHeld,#RegionID,#LanguageID,#CategoryID,#Sort").change(Search);
		$("#IncludeSubCategory,#IncludeSubRegion").click(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
		
		$("#ListByPicture").click(function()
		{
	        SetCookie("ListByPicture", $("#ListByPicture")[0].checked, 10*360*24*60);
	        Search();
		});
	}
	else if (_page == "album_select")
	{
		$("#List :checkbox").click(function()
		{
	        if ($.browser.msie)
				window.dialogArguments.SelectAlbum({ID:$(this).attr("ID"),Name:$(this).attr("Name"),PageGenerate:$(this).attr("PageGenerate"),PageTemplate:$(this).attr("PageTemplate"),PageID:$(this).attr("PageID"),PageExtension:$(this).attr("PageExtension")}, this.checked);
			else
				window.opener.SelectAlbum({ID:$(this).attr("ID"),Name:$(this).attr("Name"),PageGenerate:$(this).attr("PageGenerate"),PageTemplate:$(this).attr("PageTemplate"),PageID:$(this).attr("PageID"),PageExtension:$(this).attr("PageExtension")}, this.checked);
		});
		
		if (arguments.length == 0)
		    return;

		$("#RegionID,#LanguageID,#Sort").change(Search);
		$("#IncludeSubRegion").click(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#Ok").click(function(){window.close();});
	}
	else if (_page == "album_replace")
	{
		_xmlDoc = CreateXmlDom();

		$("form").submit(ReplaceAlbum);
		$("[name=Property]").change(Property_OnChange);
	}
	else if (_page == "lyric_add")
	{
		$("form").eq(0).submit(AddLyric);
		$("#MusicSelect").click(function(){ShowSelectDialog("Music")});
		$("#ClearMusic").click(function(){$("[name=Music]").attr("id", "").attr("value", "").attr("InnerID", "");});
	}
	else if (_page == "lyric_edit")
	{
		$("form").eq(0).submit(EditLyric);
		$("#MusicSelect").click(function(){ShowSelectDialog("Music")});
		$("#SetDefault").click(SetDefaultLyric);
		$("#ClearMusic").click(function(){$("[name=Music]").attr("id", "").attr("value", "").attr("InnerID", "");});
	}
	else if (_page == "lyric_list")
	{
		MakeButton();
		
		$("tr").each(function()
		{
			$(this).find("[sort=" + this.id + "]").mouseover(function(){this.className += " Move_MouseOver";}).mouseout(function(){this.className="Move";});
		});
	
		if (arguments.length == 0)
		    return;

		InitMove(null, "Move", null, MoveLyric);
		
		$("#IsRecycled,#IsChecked,#IsRecommended,#IsHeld,#Sort").change(Search);
		$("#IncludeSubRegion").click(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
	}
	else if (_page == "title_add")
	{
		$("form").eq(0).submit(AddTitle);
		$("#MusicSelect").click(function(){ShowSelectDialog("Music")});
		$("#ClearMusic").click(function(){$("[name=Music]").attr("id", "").attr("value", "").attr("InnerID", "");});
	}
	else if (_page == "title_edit")
	{
		$("form").eq(0).submit(EditTitle);
		$("#MusicSelect").click(function(){ShowSelectDialog("Music")});
		$("#SetDefault").click(SetDefaultTitle);
		$("#ClearMusic").click(function(){$("[name=Music]").attr("id", "").attr("value", "").attr("InnerID", "");});
	}
	else if (_page == "title_list")
	{
		MakeButton();
		
		$("tr").each(function()
		{
			$(this).find("[sort=" + this.id + "]").mouseover(function(){this.className += " Move_MouseOver";}).mouseout(function(){this.className="Move";});
		});
	
		if (arguments.length == 0)
		    return;

		InitMove(null, "Move", null, MoveTitle);
		
		$("#IsRecycled,#IsChecked,#IsRecommended,#IsHeld,#Sort").change(Search);
		$("#IncludeSubRegion").click(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
	}
}
Init(true);