﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<%@ Register TagPrefix="IlgharUC" TagName="Ime" Src="../../ime.dwt.ascx"%>
<%@ Register TagPrefix="IlgharUC" TagName="LanguageMenu" Src="../../language_menu.dwt.ascx"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>人物评论</title>
<link rel="stylesheet" type="text/css" href="<%=CommonPath%>jquery/themes/lightness/all.css" />
<ilghar:Comment><link rel="stylesheet" type="text/css" href="../../S01/CHS/css/common.css" /></ilghar:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<ilgharUC:Ime Ime="false" Eot="true" runat="server" />
<style type="text/css">
.Title .Middle{text-align:right;padding:0 10px}
.MiddleLeft{float:left}
.MiddleRight{float:right}
P{position:relative;margin:0 0 5px 0;background:#C8E3FF}
</style>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 是否审核
	string isChecked = Request.QueryString["IsChecked"];
	if (isChecked == null)
		condition.Append(and + Alias.PersonComment.IsChecked + "=true");
	else if (isChecked != String.Empty)
		condition.Append(and + Alias.PersonComment.IsChecked + "=" + isChecked);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		switch (Request.QueryString["KeywordType"])
		{
			case "PersonName":
				condition.Append(and + Alias.PersonComment.PersonName + " LIKE '%" + keyword + "%'");
				break;
			case "PersonID":
				condition.Append(and + Alias.PersonComment.PersonID + "=" + keyword);
				break;
			case "PersonInnerID":
				condition.Append(and + Alias.PersonComment.PersonInnerID + "=" + keyword);
				break;
			case "Content":
				condition.Append(and + Alias.PersonComment.Content + " LIKE '%" + keyword + "%'");
				break;
		}
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.PersonComment.CreateTime + " DESC";
			break;
		case "2":
			sort = Alias.PersonComment.CreateTime + " ASC";
			break;
		default:
			sort = Alias.PersonComment.CreateTime + " DESC";
			break;
	}
	
	return sort;
}
</script>
<script type="text/javascript">
var _page = "person_comment_list";
var _lang = "<%=ContentLang%>";
var _webPath = "<%=WebPath%>";
var _imagePath = "<%=ImagePath%>";
var _lang_working = "正在操作...";
var _lang_operation_fail = "操作失败！";
var _lang_operation_success = "操作成功！";
var _lang_confirm_delete = "要删除此项吗？";
var _lang_check = "审核";
var _lang_uncheck = "取消审核";
var _lang_selection_empty = "没有选择任何对象！";
</script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame.gif" /></div>
	<div class="Title">人物评论列表</div>
	<div class="Right">
		<ilgharUC:LanguageMenu runat="server" />
		<img height="15" src="<%=ImagePath%>dropdown.gif" /> 语言：<%=CurrentLanguage%>
	</div>
</div>
<div class="Block">
	<ul class="TabMenu">
		<li class="Left"></li>
		<li class="Middle"><a href="../person/list.aspx?Lang=<%=ContentLang%>">人物列表</a></li>
		<li class="Right"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="../person/add.aspx?Lang=<%=ContentLang%>">添加人物</a></li>
		<li class="Right"></li>
		<li class="Left Selected"></li>
		<li class="Middle Selected">人物评论</li>
		<li class="Right Selected"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="../person/replace.aspx?Lang=<%=ContentLang%>">批量替换</a></li>
		<li class="Right"></li>
	</ul>
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle"></li>
		<li class="Right"></li>
	</ul>
	<div class="ToolBar">
		<select id="IsChecked">
			<option>是否审核</option>
			<option value="false">未审核</option>
			<option value="true" selected="selected">已审核</option>
		</select>
		<select id="Sort">
			<option value="1">日期↓</option>
			<option value="2">日期↑</option>
		</select>
		<input id="Keyword" class="Text <%=ContentLang%>Font" />
		<select id="KeywordType">
			<option value="GoodsName">商品名称</option>
			<option value="GoodsID">商品Guid</option>
			<option value="GoodsInnerID">商品编号</option>
			<option value="Content">内容</option>
		</select>
		<input type="button" id="Search" value="搜索" class="Button" />
		<input type="button" id="SelectAll" value="全选" class="Button" />
		<input type="button" id="ReverseSelect" value="反选" class="Button" />
		<input type="button" id="Delete" value="删除" class="Button" />
		<span id="ExtraButton"></span>
	</div>
</div>
<div id="RecordList" class="Block">
	<ilghar:List ID="List" Object="PersonComment" Page="PageNumber" PageSize="5" Condition="Condition()" Sort="Sort()" Validate="True">
		<ilghar:Record>
			<div id="Record<%=InnerID%>">
				<ul class="Title">
					<li class="Left"></li>
					<li class="Middle">
						<span class="MiddleLeft <%=ContentLang%>Font"><%=PersonName%></span>
						<span class="MiddleRight"><%=Creator%> 发布于：<%=CreateTime%> <a href="edit.aspx?ID=<%=InnerID%>">编辑</a><input type="checkbox" name="Sel" value="<%=InnerID%>" /></span>
					</li>
					<li class="Right"></li>
				</ul>
				<p class="<%=ContentLang%>Font"><%=Content%></p>
			</div>
		</ilghar:Record>
	</ilghar:List>
	<ilghar:Pagination Page="PageNumber" PageSize="5" RecordCount="List[RecordCount]">
		<div class="Pagination">
			<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
			<div class="Right">
				<ilghar:FirstPage>
					<ilghar:Yes>
						<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
						<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
					</ilghar:Yes>
					<ilghar:No>
						<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
						<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
					</ilghar:No>
				</ilghar:FirstPage>
				<ilghar:CurrentPage Range="5">
					<ilghar:Yes>
						<span class="Current"><%=Index%></span>						
					</ilghar:Yes>
					<ilghar:No>
						<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
					</ilghar:No>
				</ilghar:CurrentPage>
				<ilghar:LastPage>
					<ilghar:Yes>
						<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
						<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
					</ilghar:Yes>
					<ilghar:No>
						<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
						<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
					</ilghar:No>
				</ilghar:LastPage>
			</div>
		</div>
	</ilghar:Pagination>
</div>
<script type="text/javascript" src="<%=CommonPath%>jquery/core.js"></script>
<script type="text/javascript" src="<%=CommonPath%>jquery/ui.js"></script>
<script type="text/javascript" src="<%=CommonPath%>utility.js"></script>
<script type="text/javascript" src="<%=JsPath%>global.js"></script>
<script type="text/javascript" src="<%=JsPath%>picture.js"></script>
</body>
</html>