﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 是否显示
	string isDisplay = Request.QueryString["IsDisplay"];
	if (isDisplay == null)
		condition.Append(Alias.AlbumCategory.IsDisplay + "=true");
	else if (isDisplay != String.Empty)
		condition.Append(Alias.AlbumCategory.IsDisplay + "=" + isDisplay);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否推荐
	string isRecommended = Request.QueryString["IsRecommended"];
	if (!String.IsNullOrEmpty(isRecommended))
		condition.Append(and + Alias.AlbumCategory.IsRecommended + "=" + isRecommended);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否置顶
	string isHeld = Request.QueryString["IsHeld"];
	if (!String.IsNullOrEmpty(isHeld))
		condition.Append(and + Alias.AlbumCategory.IsHeld + "=" + isHeld);
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.AlbumCategory.Sort + " ASC";
			break;
		case "2":
			sort = Alias.AlbumCategory.Recommend + " DESC";
			break;
		case "3":
			sort = Alias.AlbumCategory.Recommend + " ASC";
			break;
		case "4":
			sort = Alias.AlbumCategory.Hold + " DESC";
			break;
		case "5":
			sort = Alias.AlbumCategory.Hold + " ASC";
			break;
		default:
			sort = Alias.AlbumCategory.Sort + " ASC";
			break;
	}
	
	return sort;
}
</script>
<table border="0" cellpadding="4" cellspacing="1" class="TreeTable">
	<thead>
		<tr>
            <th width="40">选择</th>
            <th width="40">移动</th>
			<th>名称及层次</th>
			<th width="40">修改</th>
			<th width="80">浏览影集</th>
			<th width="80">添加子类别</th>
			<th width="40">编辑</th>
			<th width="40">删除</th>
		</tr>
	</thead>
	<tbody>
		<%If Request.QueryString["Sort"] == "1"%>
			<ilghar:Tree Object="AlbumCategory" Condition="Condition()" Sort="Sort()" Validate="True">
				<ilghar:Control>
					<ilghar:Space><span style="margin-left:20px"></span></ilghar:Space>
					<ilghar:Line><img src="<%=ImagePath%>tree/line.gif" /></ilghar:Line>
					<ilghar:TopOpen><img id="SH<%=InnerID%>" onclick="ShowAndHide('<%=InnerID%>')" src="<%=ImagePath%>tree/top_open.gif" class="ShowHide" /></ilghar:TopOpen>
					<ilghar:Top><img src="<%=ImagePath%>tree/top.gif" /></ilghar:Top>
					<ilghar:MiddleOpen><img id="SH<%=InnerID%>" onclick="ShowAndHide('<%=InnerID%>')" src="<%=ImagePath%>tree/middle_open.gif" class="ShowHide" /></ilghar:MiddleOpen>
					<ilghar:Middle><img src="<%=ImagePath%>tree/middle.gif" /></ilghar:Middle>
					<ilghar:BottomOpen><img id="SH<%=InnerID%>" onclick="ShowAndHide('<%=InnerID%>')" src="<%=ImagePath%>tree/bottom_open.gif" class="ShowHide" /></ilghar:BottomOpen>
					<ilghar:Bottom><img src="<%=ImagePath%>tree/bottom.gif" /></ilghar:Bottom>
				</ilghar:Control>
				<ilghar:Record>
					<tr id="Row<%=InnerID%>" ItemID="<%=InnerID%>" ParentID="<%=ParentInnerID%>">
						<form>
                            <td><input type="checkbox" name="Sel" value="<%=InnerID%>" /></td>
							<td><img name="<%=Name%>" sort="<%=InnerID%>" class="Move" src="<%=ImagePath%>move.gif" /></td>
							<th><span id="Control<%=InnerID%>"><%=Control%></span><input type="text" name="Name" value="<%=Name%>" class="<%=ContentLang%>Font"></th>
							<td><input type="image" src="<%=ImagePath%>modify.gif" /></td>
							<td><a href="../album/list.aspx?Lang=<%=ContentLang%>&amp;CategoryID=<%=ID%>">浏览影集</a></td>
							<td><a href="add.aspx?Lang=<%=ContentLang%>&amp;ParentID=<%=ID%>">添加子类别</a></td>
							<td><a href="edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>">编辑</a></td>
							<td><a href="">删除</a></td>
						</form>
					</tr>
					<%=ChildRecords%>
				</ilghar:Record>
			</ilghar:Tree>
		<%Else%>
			<ilghar:List Object="AlbumCategory" Condition="Condition()" Sort="Sort()" Validate="True">
				<ilghar:Record>
					<tr id="Row<%=InnerID%>" ItemID="<%=InnerID%>" ParentID="">
						<form>
                            <td><input type="checkbox" name="Sel" value="<%=InnerID%>" /></td>
							<td>
								<%If Request.QueryString["Sort"] == "1" || (Request.QueryString["Sort"] == "2" || Request.QueryString["Sort"] == "3") && Convert.ToInt32(Recommend) > 0 || (Request.QueryString["Sort"] == "4" || Request.QueryString["Sort"] == "5") && Convert.ToInt32(Hold) > 0%>
									<img name="<%=Name%>" sort="<%=InnerID%>" class="Move" src="<%=ImagePath%>move.gif" />
								<%EndIf%>
							</td>
							<th><input type="text" name="Name" value="<%=Name%>" class="<%=ContentLang%>Font"></th>
							<td><input type="image" src="<%=ImagePath%>modify.gif" /></td>
							<td><a href="../album/list.aspx?Lang=<%=ContentLang%>&amp;CategoryID=<%=ID%>">浏览影集</a></td>
							<td><a href="add.aspx?Lang=<%=ContentLang%>&amp;ParentID=<%=ID%>">添加子类别</a></td>
							<td><a href="edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>">编辑</a></td>
							<td><a href="">删除</a></td>
						</form>
					</tr>
				</ilghar:Record>
			</ilghar:List>
		<%EndIf%>
	</tbody>
</table>
