﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<%@ Import Namespace="System.Text.RegularExpressions" %>
<%@ Register TagPrefix="IlgharUC" TagName="Ime" Src="../../ime.dwt.ascx"%>
<%@ Register TagPrefix="IlgharUC" TagName="LanguageMenu" Src="../../language_menu.dwt.ascx"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>歌词列表</title>
<link rel="stylesheet" type="text/css" href="<%=CommonPath%>jquery/themes/lightness/all.css" />
<ilghar:Comment><link rel="stylesheet" type="text/css" href="../../S01/CHS/css/common.css" /></ilghar:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<ilgharUC:Ime Ime="true" Eot="true" runat="server" />
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 是否回收
	string isRecycled = Request.QueryString["IsRecycled"];
	if (isRecycled == null)
		condition.Append(Alias.Lyric.IsDeleted + "=false");
	else if (isRecycled != String.Empty)
		condition.Append(Alias.Lyric.IsDeleted + "=" + isRecycled);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否审核
	string isChecked = Request.QueryString["IsChecked"];
	if (isChecked == null)
		condition.Append(and + Alias.Lyric.IsChecked + "=true");
	else if (isChecked != String.Empty)
		condition.Append(and + Alias.Lyric.IsChecked + "=" + isChecked);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否推荐
	string isRecommended = Request.QueryString["IsRecommended"];
	if (!String.IsNullOrEmpty(isRecommended))
		condition.Append(and + Alias.Lyric.IsRecommended + "=" + isRecommended);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否置顶
	string isHeld = Request.QueryString["IsHeld"];
	if (!String.IsNullOrEmpty(isHeld))
		condition.Append(and + Alias.Lyric.IsHeld + "=" + isHeld);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		switch (Request.QueryString["KeywordType"])
		{
			case "Name":
				condition.Append(and + Alias.Lyric.Name + " LIKE '%" + keyword + "%'");
				break;
			case "Content":
				condition.Append(and + Alias.Lyric.Content + " LIKE '%" + keyword + "%'");
				break;
			case "MusicName":
				condition.Append(and + Alias.Lyric.MusicName + " LIKE '%" + keyword + "%'");
				break;
			case "MusicID":
				if (Regex.IsMatch(keyword, @"^\{?[a-fA-F0-9]{8}(-?[a-fA-F0-9]{4}){3}-?[a-fA-F0-9]{12}\}?$"))
					condition.Append(and + Alias.Lyric.MusicID + "=" + keyword);
				else
					condition.Append(and + Alias.Lyric.MusicInnerID + "=" + keyword);
				break;
		}
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Lyric.UpdateTime + " DESC";
			break;
		case "2":
			sort = Alias.Lyric.UpdateTime + " ASC";
			break;
		case "3":
			sort = Alias.Lyric.HitCount + " DESC";
			break;
		case "4":
			sort = Alias.Lyric.HitCount + " ASC";
			break;
		case "5":
			sort = Alias.Lyric.Recommend + " DESC";
			break;
		case "6":
			sort = Alias.Lyric.Recommend + " ASC";
			break;
		case "7":
			sort = Alias.Lyric.Hold + " DESC";
			break;
		case "8":
			sort = Alias.Lyric.Hold + " ASC";
			break;
		case "9":
			sort = Alias.Lyric.InnerID + " DESC";
			break;
		case "10":
			sort = Alias.Lyric.InnerID + " ASC";
			break;
		case "11":
			sort = Alias.Lyric.Up + " DESC";
			break;
		case "12":
			sort = Alias.Lyric.Up + " ASC";
			break;
		case "13":
			sort = Alias.Lyric.Down + " DESC";
			break;
		case "14":
			sort = Alias.Lyric.Down + " ASC";
			break;
		case "15":
			sort = Alias.Lyric.Error + " DESC";
			break;
		case "16":
			sort = Alias.Lyric.Error + " ASC";
			break;
		default:
			sort = Alias.Lyric.UpdateTime + " DESC";
			break;
	}
	
	return sort;
}

protected bool Move
{
	get
	{
		if (Request.QueryString["Sort"] == "5" || Request.QueryString["Sort"] == "6")
			return Request.QueryString["IsRecommended"] == "true";
		else if (Request.QueryString["Sort"] == "7" || Request.QueryString["Sort"] == "8")
			return Request.QueryString["IsHeld"] == "true";
		else
			return false;
	}
}
</script>
<script type="text/javascript">
var _page = "lyric_list";
var _lang = "<%=ContentLang%>";
var _webPath = "<%=WebPath%>";
var _imagePath = "<%=ImagePath%>";
var _lang_working = "正在操作...";
var _lang_operation_fail = "操作失败！";
var _lang_operation_success = "操作成功！";
var _lang_confirm_delete = "要删除此项吗？";
var _lang_check = "审核";
var _lang_uncheck = "取消审核";
var _lang_recycle = "回收";
var _lang_delete = "删除";
var _lang_recover = "还原";
var _lang_recommend = "推荐";
var _lang_unrecommend = "取消推荐";
var _lang_hold = "置顶";
var _lang_unhold = "取消置顶";
var _lang_selection_empty = "没有选择任何对象！";
</script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame.gif" /></div>
	<div class="Title">歌词列表</div>
	<div class="Right">
		<ilgharUC:LanguageMenu runat="server" />
		<img height="15" src="<%=ImagePath%>dropdown.gif" /> 语言：<%=CurrentLanguage%>
	</div>
</div>
<div class="Block">
	<ul class="TabMenu">
		<li class="Left Selected"></li>
		<li class="Middle Selected">歌词列表</li>
		<li class="Right Selected"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="add.aspx?Lang=<%=ContentLang%>">添加歌词</a></li>
		<li class="Right"></li>
	</ul>
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle"></li>
		<li class="Right"></li>
	</ul>
	<div class="ToolBar">
		<select id="IsRecycled">
			<option value="">是否回收</option>
			<option value="false" selected="selected">未回收</option>
			<option value="true">已回收</option>
		</select>
		<select id="IsChecked">
			<option value="">是否审核</option>
			<option value="false">未审核</option>
			<option value="true" selected="selected">已审核</option>
		</select>
		<select id="IsRecommended">
			<option value="">是否推荐</option>
			<option value="false">未推荐</option>
			<option value="true">已推荐</option>
		</select>
		<select id="IsHeld">
			<option value="">是否置顶</option>
			<option value="false">未置顶</option>
			<option value="true">已置顶</option>
		</select>
	</div>
	<div class="ToolBar">
		<select id="Sort">
			<option value="1">更新日期↓</option>
			<option value="2">更新日期↑</option>
			<option value="3">人气↓</option>
			<option value="4">人气↑</option>
			<option value="5">推荐↓</option>
			<option value="6">推荐↑</option>
			<option value="7">置顶↓</option>
			<option value="8">置顶↑</option>
			<option value="9">编号↓</option>
			<option value="10">编号↑</option>
			<option value="11">顶↓</option>
			<option value="12">顶↑</option>
			<option value="13">踩↓</option>
			<option value="14">踩↑</option>
			<option value="15">错误↓</option>
			<option value="16">错误↑</option>
		</select>
		<input id="Keyword" class="Text <%=ContentLang%>Font" />
		<select id="KeywordType">
			<option value="Name">名称</option>
			<option value="Content">内容</option>
			<option value="MusicName">歌曲名称</option>
			<option value="MusicID">歌曲编号</option>
		</select>
		<input id="Search" type="button" value="搜索" class="Button" />
		<input id="SelectAll" type="button" value="全选" class="Button" />
		<input id="ReverseSelect" type="button" value="反选" class="Button" />
		<span id="ExtraButton"></span>
	</div>
	<div id="List">
		<table border="0" cellpadding="4" cellspacing="1" class="ListTable">
			<thead>
				<tr>
					<th width="40">选择</th>
					<%If Move%>
						<th width="60">
							<%If Request.QueryString["IsRecommended"] == "true"%>
								移动推荐
							<%Else%>
								移动置顶
							<%EndIf%>
						</th>
					<%EndIf%>
					<th>名称</th>
					<th width="110">更新日期</th>
					<th width="40">人气</th>
					<th width="40">顶</th>
					<th width="40">踩</th>
					<th width="40">错误</th>
				</tr>
			</thead>
			<tbody>
				<ilghar:List ID="List" Object="Lyric" Page="PageNumber" PageSize="20" Condition="Condition()" Sort="Sort()" Validate="True">
					<ilghar:Record>
						<tr id="Row<%=InnerID%>">
							<td><input type="checkbox" name="Sel" value="<%=InnerID%>" /></td>
							<%If Move%>
								<td><img name="<%=Name%>" sort="<%=InnerID%>" class="Move" src="<%=ImagePath%>move.gif" /></td>
							<%EndIf%>
							<td class="<%=ContentLang%>Font"><a href="edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>"><%=Name%></a></td>
							<td><%=UpdateTime%></td>
							<td><%=HitCount%></td>
							<td><%=Up%></td>
							<td><%=Down%></td>
							<td><%=Error%></td>
						</tr>
					</ilghar:Record>
				</ilghar:List>
			</tbody>
		</table>
		<ilghar:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
			<div class="Pagination">
				<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
				<div class="Right">
					<ilghar:FirstPage>
						<ilghar:Yes>
							<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
						</ilghar:No>
					</ilghar:FirstPage>
					<ilghar:CurrentPage Range="5">
						<ilghar:Yes>
							<span class="Current"><%=Index%></span>						
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
						</ilghar:No>
					</ilghar:CurrentPage>
					<ilghar:LastPage>
						<ilghar:Yes>
							<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
						</ilghar:No>
					</ilghar:LastPage>
				</div>
			</div>
		</ilghar:Pagination>
	</div>
</div>
<script type="text/javascript" src="<%=CommonPath%>jquery/core.js"></script>
<script type="text/javascript" src="<%=CommonPath%>jquery/ui.js"></script>
<script type="text/javascript" src="<%=CommonPath%>utility.js"></script>
<script type="text/javascript" src="<%=JsPath%>move.js"></script>
<script type="text/javascript" src="<%=JsPath%>global.js"></script>
<script type="text/javascript" src="<%=JsPath%>music.js"></script>
</body>
</html>