﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<ilghar:Get ID="Member" Object="Member" InnerID="Request.QueryString['MemberID']" />
<ilghar:Get ID="Balance" Object="Member.Point" Operation="GetBalance((Guid)Member[ID])" />
<script language="c#" runat="server">
private decimal _balance = -1;
protected decimal GetBalance(object amount)
{
	if (_balance == -1)
		_balance = Balance;
	decimal result = _balance;
	_balance -= Convert.ToDecimal(amount);
	return result;
}
</script>
<table border="0" cellpadding="4" cellspacing="1" class="ListTable">
	<thead>
		<tr>
			<th>交易时间</th>
			<th>业务摘要</th>
			<th>转入金额</th>
			<th>转出金额</th>
			<th>当前余额</th>
			<th>备 注</th>
		</tr>
	</thead>
	<tbody>
		<ilghar:List ID="List" Object="Member.Point" Page="PageNumber" PageSize="20" Condition="MemberID=Member[ID]" Sort="CreateTime DESC" Validate="True">
			<ilghar:Record>
				<tr>
					<td><%=CreateTime%></td>
					<td class="<%=ContentLang%>Font"><%=Title%></td>
					<%If Convert.ToDecimal(Amount) > 0%>
						<td><%=Amount%></td>
						<td>0</td>
					<%Else%>
						<td>0</td>
						<td><%=-1 * Convert.ToDecimal(Amount)%></td>
					<%EndIf%>
					<td><%=GetBalance(Amount)%></td>
					<td class="<%=ContentLang%>Font"><%=Memo%></td>
				</tr>
			</ilghar:Record>
		</ilghar:List>
	</tbody>
</table>		
<ilghar:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ilghar:FirstPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:FirstPage>
			<ilghar:CurrentPage Range="5">
				<ilghar:Yes>
					<span class="Current"><%=Index%></span>						
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ilghar:No>
			</ilghar:CurrentPage>
			<ilghar:LastPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:LastPage>
		</div>
	</div>
</ilghar:Pagination>
