﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 开始日期
	string startTime = Request.QueryString["StartTime"];
	if (!String.IsNullOrEmpty(startTime))
		condition.Append(and + Alias.Out.CreateTime + " >= #" + startTime + "#");
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 结束日期
	string endTime = Request.QueryString["EndTime"];
	if (!String.IsNullOrEmpty(endTime))
		condition.Append(and + Alias.Out.CreateTime + " <= #" + endTime + "#");
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "LinkName")
			condition.Append(and + Alias.Out.LinkName + " LIKE '%" + keyword + "%'");
		if (Request.QueryString["KeywordType"] == "LinkInnerID")
			condition.Append(and + Alias.Out.LinkInnerID + "=" + keyword);
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Out.CreateTime + " DESC";
			break;
		case "2":
			sort = Alias.Out.CreateTime + " ASC";
			break;
		default:
			sort = Alias.Out.CreateTime + " DESC";
			break;
	}
	
	return sort;
}
</script>
<table border="0" cellpadding="4" cellspacing="1" class="ListTable">
	<thead>
		<tr>
			<th width="40">选择</th>
			<th>名称</th>
			<th>时间</th>
			<th>IP地址</th>
		</tr>
	</thead>
	<tbody>
		<ilghar:List ID="List" Object="Out" Page="PageNumber" PageSize="20" Condition="Condition()" Sort="Sort()" Validate="True">
			<ilghar:Record>
				<tr>
					<td><input type="checkbox" name="Sel" value="<%=InnerID%>" /></td>
					<td class="<%=ContentLang%>Font"><a href="../link/edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=LinkInnerID%>"><%=LinkName%></a></td>
					<td><%=CreateTime%></td>
					<td><%=IP%></td>
				</tr>
			</ilghar:Record>
		</ilghar:List>
	</tbody>
</table>
<ilghar:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ilghar:FirstPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:FirstPage>
			<ilghar:CurrentPage Range="5">
				<ilghar:Yes>
					<span class="Current"><%=Index%></span>						
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ilghar:No>
			</ilghar:CurrentPage>
			<ilghar:LastPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:LastPage>
		</div>
	</div>
</ilghar:Pagination>