﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();

	condition.Append(Alias.Product.IsDeleted + "=false");
	condition.Append(" AND " + Alias.Product.IsChecked + "=true");
	if (Request.QueryString["Type"] == "Host")
		condition.Append(" AND " + Alias.Product.Kind + "='Host'");
	else if (Request.QueryString["Type"] == "WebSite")
		condition.Append(" AND " + Alias.Product.Kind + "='WebSite'");
	else if (Request.QueryString["Type"] == "Binding" || Request.QueryString["Type"] == "Present")
		condition.Append(" AND " + Alias.Product.Kind + "<>'Set' AND " + Alias.Product.Kind + "<>'AutoSite'");

	#region 性质
	string kind = Request.QueryString["Kind"];
	if (kind != null && kind != "*")
		condition.Append(" AND " + Alias.Product.Kind + "='" + kind + "'");
	#endregion

	#region 类别
	string categoryID = Request.QueryString["CategoryID"];
	if (!String.IsNullOrEmpty(categoryID))
		condition.Append(" AND " + Alias.Product.CategoryID + "=" + Convert.ToInt32(categoryID));
	#endregion

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Name")
			condition.Append(" AND " + Alias.Product.Name + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Product.UpdateTime + " DESC";
			break;
		case "2":
			sort = Alias.Product.UpdateTime + " ASC";
			break;
		default:
			sort = Alias.Product.UpdateTime + " DESC";
			break;
	}
	
	return sort;
}
</script>
<table border="0" cellpadding="4" cellspacing="1">
	<thead>
		<tr><th colspan="4">结果</th></tr>
	</thead>
	<tbody>
		<ilghar:List ID="List" Object="Product" Page="PageNumber" PageSize="20" Condition="Condition()" Sort="Sort()">
			<ilghar:Row MaxCol="2">
				<tr>
					<ilghar:Col MaxRecord="1">
						<ilghar:Record>
							<%If Request.QueryString["Type"] == "Product"%>
								<td><a href="javascript:OnSelect({ProductID:'<%=ID%>',ProductNumber:'<%=Number%>',Name:'<%=Name%>',Kind:'<%=Kind%>',UnitID:'<%=UnitID%>',UnitName:'<%=UnitName%>',Price:'<%=Price%>'})" class="<%=ContentLang%>Font"><%=Name%></a></td>
							<%Else%>
								<td><input type="checkbox" id="<%=InnerID%>" onclick="OnSelect({ID:'<%=ID%>',Name:'<%=Name%>',InnerID:'<%=InnerID%>'})" /><label for="<%=InnerID%>" class="<%=ContentLang%>Font"><%=Name%></label></td>
							<%EndIf%>
						</ilghar:Record>
					</ilghar:Col>
				</tr>
			</ilghar:Row>
		</ilghar:List>
	</tbody>
</table>
<ilghar:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ilghar:FirstPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:FirstPage>
			<ilghar:CurrentPage Range="5">
				<ilghar:Yes>
					<span class="Current"><%=Index%></span>						
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ilghar:No>
			</ilghar:CurrentPage>
			<ilghar:LastPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:LastPage>
		</div>
	</div>
</ilghar:Pagination>