﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<ilghar:Get ID="OrderDetail" Object="Order.Detail" InnerID="Request.QueryString['ID']" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>管理</title>
<ilghar:Comment><link rel="stylesheet" type="text/css" href="../../../S01/CHS/css/common.css" /></ilghar:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<script type="text/javascript" src="<%=Manager.GetModulePath(null)%><%=Instance[IlgharCMS.SystemModule.Alias.Module.Namespace]%>/alias.js"></script>
<script type="text/javascript" src="<%=CommonPath%>ajax.js"></script>
<script type="text/javascript" src="<%=CommonPath%>xmldom.js"></script>
<script type="text/javascript" src="<%=JsPath%>common.js"></script>
<script type="text/javascript">
var _appPoolID = "<%=OrderDetail[AppPoolID]%>";
var _serverBindings = "<%=OrderDetail[ServerBindings]%>";
var _logEnabled = <%=Convert.ToString(OrderDetail[LogEnabled]).ToLower()%>;
var _maxConnections = "<%=OrderDetail[MaxConnections]%>";
var _maxBandwidth = "<%=OrderDetail[MaxBandwidth]%>";
var _defaultDoc = "<%=OrderDetail[DefaultDoc]%>";
var _error404 = "<%=OrderDetail[Error404]%>";
var _scriptMaps = "<%=Convert.ToString(OrderDetail[ScriptMaps]).Replace("\\", "\\\\")%>";

function XmlHttpCallBack(xmlHttp)
{
	if (xmlHttp.status == 200)
	{
		alert("编辑成功！");
	}
	else
	{
		if (_action == "Edit")
			alert("编辑失败！请查看日志！");
		else
			alert("失败！请查看日志！");
	}
	document.getElementById("Submit").disabled = false;
	window.status = "";
}

function OnSubmit(form)
{
	if (!form.MaxConnections.value.match(/^\d+$/))
	{
		alert("最大并发连接数格式不正确！");
		form.MaxConnections.select();
		return false;
	}

	if (!form.MaxBandwidth.value.match(/^\d+$/))
	{
		alert("最大带宽格式不正确！");
		form.MaxBandwidth.select();
		return false;
	}
	
	var serverBindings = "";
	for (var i = 0; i < form.ServerBindings.options.length; i++)
	{
		if (serverBindings != "")
			serverBindings += "|";
		serverBindings += form.ServerBindings.options[i].text;
	}
	
	var scriptMaps = "";
	for (var i = 0; i < form.ScriptMaps.options.length; i++)
	{
		if (scriptMaps != "")
			scriptMaps += "|";
		scriptMaps += form.ScriptMaps.options[i].text;
	}
	
	var data = "Script=|" + GetChecked("Script") + "|";
	if (_appPoolID != form.AppPoolID.value)
	{
		_appPoolID = form.AppPoolID.value;
		data += "&AppPoolID=" + _appPoolID;
	}
	if (_serverBindings != serverBindings)
	{
		_serverBindings = serverBindings;
		data += "&ServerBindings=" + encodeURIComponent(_serverBindings);
	}
	if (_logEnabled != document.getElementById("LogEnabledYes").checked)
	{
		_logEnabled = !_logEnabled;
		data += "&LogEnabled=" + _logEnabled;
	}
	if (_maxConnections != form.MaxConnections.value)
	{
		_maxConnections = form.MaxConnections.value;
		data += "&MaxConnections=" + _maxConnections;
	}
	if (_maxBandwidth != form.MaxBandwidth.value)
	{
		_maxBandwidth = form.MaxBandwidth.value;
		data += "&MaxBandwidth=" + _maxBandwidth;
	}
	if (_defaultDoc != form.DefaultDoc.value)
	{
		_defaultDoc = form.DefaultDoc.value;
		data += "&DefaultDoc=" + encodeURIComponent(_defaultDoc);
	}
	if (_error404 != form.Error404.value)
	{
		_error404 = form.Error404.value;
		data += "&Error404=" + encodeURIComponent(_error404);
	}
	if (_scriptMaps != scriptMaps)
	{
		_scriptMaps = scriptMaps;
		data += "&ScriptMaps=" + encodeURIComponent(_scriptMaps);
	}
	
	document.getElementById("Submit").disabled = true;
	window.status = "正在操作...";
	_action = "Edit";
	_ajax.Post("<%=WebPath%>ilghar.aspx?Lang=<%=ContentLang%>&Object=Order.Detail&Operation=Modify&ID=<%=Request.QueryString["ID"]%>", data, XmlHttpCallBack);
	return false;
}

function AddServerBinding()
{
	var form = document.forms[0];
	var serverBinding = Trim(form.ServerBinding.value.toLowerCase());
	if (serverBinding.indexOf("http://") == 0)
		serverBinding = serverBinding.substr(7);
	if (serverBinding == "" || serverBinding.indexOf(":") == 0)
	{
		alert("请输入域名！");
		form.ServerBinding.select();
		return false;
	}

	for (var i = 0; i < form.ServerBindings.options.length; i++)
	{
		if (serverBinding == form.ServerBindings.options[i].text)
		{
			alert("此域名已经存在！");
			form.ServerBinding.select();
			return false;
		}
	}
	
	if (form.ServerBindings.options.length >= <%=OrderDetail[ServerBindingsCount]%>)
	{
		alert("已达到最大可绑定域名数！");
		form.ServerBinding.select();
		return false;
	}

	form.ServerBindings.options.add(new Option(serverBinding, ""));
	
	return false;
}

function DeleteServerBinding()
{
	var form = document.forms[0];
	if (form.ServerBindings.length == 1)
	{
		alert("不能全部删除！");
		return;
	}
	if (form.ServerBindings.selectedIndex != -1)
		form.ServerBindings.remove(form.ServerBindings.selectedIndex);
}

function Script_OnClick(input)
{
	var items = new Array();
	if (input.value == "asp")
	{
		items[items.length] = ".asp;C:\\Windows\\system32\\inetsrv\\asp.dll;5;GET,HEAD,POST,TRACE";
		items[items.length] = ".asa;C:\\Windows\\system32\\inetsrv\\asp.dll;5;GET,HEAD,POST,TRACE";
	}
	else
	{
		if (input.value == "aspnet2.0" && !input.checked)
			document.getElementById("ScriptIlgharCMS").checked = false;
		else if (input.value == "IlgharCMS" && input.checked)
			document.getElementById("ScriptAspNet20").checked = true;
		
		if (input.value != "IlgharCMS" || input.checked)
		{
			items[items.length] = ".asax;C:\Windows\Microsoft.NET\Framework\v2.0.50727\aspnet_isapi.dll;5;GET,HEAD,POST,DEBUG";
			items[items.length] = ".ascx;C:\Windows\Microsoft.NET\Framework\v2.0.50727\aspnet_isapi.dll;5;GET,HEAD,POST,DEBUG";
			items[items.length] = ".aspx;C:\Windows\Microsoft.NET\Framework\v2.0.50727\aspnet_isapi.dll;5;GET,HEAD,POST,DEBUG";
			items[items.length] = ".config;C:\Windows\Microsoft.NET\Framework\v2.0.50727\aspnet_isapi.dll;5;GET,HEAD,POST,DEBUG";
		}
	}
	
	for (var i = 0; i < items.length; i++)
	{
		var index = items[i].indexOf(";");
		var extension = items[i].substr(0, index + 1);
		
		var exist = false;
		var j = 0;
		for (; j < input.form.ScriptMaps.options.length; j++)
		{
			if (input.form.ScriptMaps.options[j].text.indexOf(extension) == 0)
			{
				exist = true;
				break;
			}
		}
		
		if (input.checked && !exist)
			input.form.ScriptMaps.options.add(new Option(items[i], ""));
		else if (!input.checked && exist)
			input.form.ScriptMaps.remove(j);
	}
}

function AddScriptMap()
{
	var form = document.forms[0];
	var scriptMap = Trim(form.ScriptMap.value);
	var parts = scriptMap.split(";");
	if (scriptMap == "" || scriptMap.indexOf(".") != 0 || parts.length != 4 || !parts[2].match(/^\d+$/))
	{
		alert("格式不正确！");
		form.ScriptMap.select();
		return false;
	}

	var extension = parts[0].toLowerCase() + ";";
	for (var i = 0; i < form.ScriptMaps.options.length; i++)
	{
		if (form.ScriptMaps.options[i].text.toLowerCase().indexOf(extension) == 0)
		{
			alert("已经存在！");
			form.ScriptMap.select();
			return false;
		}
	}

	form.ScriptMaps.options.add(new Option(scriptMap, ""));
	
	return false;
}

function DeleteScriptMap()
{
	var form = document.forms[0];
	if (form.ScriptMaps.selectedIndex != -1)
		form.ScriptMaps.remove(form.ScriptMaps.selectedIndex);
}
</script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame.gif" onclick="OpenCloseLeftFrame()" /></div>
	<div class="Title"><a href="list.aspx?Lang=<%=ContentLang%>">产品列表</a> → <span class="<%=ContentLang%>Font"><%=OrderDetail[Name]%></span></div>
	<div class="Right"></div>
</div>
<div class="Block">
	<ul class="TabMenu">
		<li class="Left"></li>
		<li class="Middle"><a href="view.aspx?Lang=<%=ContentLang%>&amp;ID=<%=Request.QueryString["ID"]%>">查看</a></li>
		<li class="Right"></li>
		<li class="Left Selected"></li>
		<li class="Middle Selected">管理</li>
		<li class="Right Selected"></li>
		<li class="Left"></li>
		<li class="Middle"><a href="feedback.aspx?Lang=<%=ContentLang%>&amp;ID=<%=Request.QueryString["ID"]%>">反馈</a></li>
		<li class="Right"></li>
	</ul>
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle"></li>
		<li class="Right"></li>
	</ul>
	<form method="post" onsubmit="return OnSubmit(this)">
		<table border="0" cellpadding="4" cellspacing="1">
			<tbody>
				<tr>
					<th>服务器：</th>
					<td class="<%=ContentLang%>Font">
						<ilghar:List Object="Server" Condition="ID=OrderDetail[ServerID]">
							<ilghar:Record>
								<%=Name%>
							</ilghar:Record>
						</ilghar:List>
					</td>
				</tr>
				<tr>
					<th>应用程序池：</th>
					<td>
						<select name="AppPoolID">
							<ilghar:List Object="AppPool" Condition="ServerID=OrderDetail[ServerID]">
								<ilghar:Record>
									<%If Guid.Equals(ID, OrderDetail[AppPoolID])%>
										<option value="<%=ID%>" selected="selected"><%=Name%></option>
									<%Else%>
										<option value="<%=ID%>"><%=Name%></option>
									<%EndIf%>
								</ilghar:Record>
							</ilghar:List>
						</select>
					</td>
				</tr>
				<tr>
					<th>空间大小：</th>
					<td><%=OrderDetail[SpaceSize]%>M</td>
				</tr>
				<tr>
					<th>域名列表：</th>
					<td>
						域名：<input type="text" name="ServerBinding" size="50" onkeydown="if(event.keyCode == 13) return AddServerBinding();" /><input type="button" value="添加" onclick="AddServerBinding()" /><input type="button" value="删除" onclick="DeleteServerBinding()" />格式：域名:端口，最大可绑定数：<%=OrderDetail[ServerBindingsCount]%><br />
						<select name="ServerBindings" size="4">
							<ilghar:List Source="Manager.SplitToTable(OrderDetail[ServerBindings])">
								<ilghar:Record>
									<option><%=[0]%></option>
								</ilghar:Record>
							</ilghar:List>
						</select>
					</td>
				</tr>
				<tr>
					<th>是否写日志：</th>
					<td>
						<%If Convert.ToBoolean(OrderDetail[LogEnabled])%>
							<input type="radio" name="LogEnabled" id="LogEnabledYes" checked="checked" /><label for="LogEnabledYes">是</label>
							<input type="radio" name="LogEnabled" id="LogEnabledNo" /><label for="LogEnabledNo">否</label>
						<%Else%>
							<input type="radio" name="LogEnabled" id="LogEnabledYes" /><label for="LogEnabledYes">是</label>
							<input type="radio" name="LogEnabled" id="LogEnabledNo" checked="checked" /><label for="LogEnabledNo">否</label>
						<%EndIf%>
					</td>
				</tr>
				<tr>
					<th>最大并发连接数：</th>
					<td><input type="text" name="MaxConnections" value="<%=OrderDetail[MaxConnections]%>" size="10" maxlength="20" class="Text" />若不限制，则设为0</td>
				</tr>
				<tr>
					<th>最大带宽（k/s）：</th>
					<td><input type="text" name="MaxBandwidth" value="<%=OrderDetail[MaxBandwidth]%>" size="10" maxlength="20" class="Text" />若不限制，则设为0</td>
				</tr>
				<tr>
					<th>默认文档：</th>
					<td><input type="text" name="DefaultDoc" value="<%=OrderDetail[DefaultDoc]%>" size="60" maxlength="255" class="Text" /></td>
				</tr>
				<tr>
					<th>自定义404错误：</th>
					<td><input type="text" name="Error404" value="<%=OrderDetail[Error404]%>" size="60" maxlength="255" class="Text" /></td>
				</tr>
				<tr>
					<th>脚本：</th>
					<td>
						<%If Convert.ToString(OrderDetail[Script]).Contains("|asp|")%>
							<input type="checkbox" name="Script" id="ScriptAsp" value="asp" checked="checked" onclick="Script_OnClick(this)" /><label for="ScriptAsp">Asp</label>
						<%Else%>
							<input type="checkbox" name="Script" id="ScriptAsp" value="asp" onclick="Script_OnClick(this)" /><label for="ScriptAsp">Asp</label>
						<%EndIf%>
						<%If Convert.ToString(OrderDetail[Script]).Contains("|aspnet2.0|")%>
							<input type="checkbox" name="Script" id="ScriptAspNet20" value="aspnet2.0" checked="checked" onclick="Script_OnClick(this)" /><label for="ScriptAspNet20">Asp.Net2.0</label>
						<%Else%>
							<input type="checkbox" name="Script" id="ScriptAspNet20" value="aspnet2.0" onclick="Script_OnClick(this)" /><label for="ScriptAspNet20">Asp.Net2.0</label>
						<%EndIf%>
						<%If Convert.ToString(OrderDetail[Script]).Contains("|IlgharCMS|")%>
							<input type="checkbox" name="Script" id="ScriptIlgharCMS" value="IlgharCMS" checked="checked" onclick="Script_OnClick(this)" /><label for="ScriptIlgharCMS">IlgharCMS</label>
						<%Else%>
							<input type="checkbox" name="Script" id="ScriptIlgharCMS" value="IlgharCMS" onclick="Script_OnClick(this)" /><label for="ScriptIlgharCMS">IlgharCMS</label>
						<%EndIf%>
						<br />
						<input type="text" name="ScriptMap" size="90" onkeydown="if(event.keyCode == 13) return AddScriptMap();" /><input type="button" value="添加" onclick="AddScriptMap()" /><input type="button" value="删除" onclick="DeleteScriptMap()" />
						<br />格式：Extensions1;ScriptProcessor1;Flags1;IncludedVerbs1<br />
						<select name="ScriptMaps" size="4">
							<ilghar:List Source="Manager.SplitToTable(OrderDetail[ScriptMaps])">
								<ilghar:Record>
									<option><%=[0]%></option>
								</ilghar:Record>
							</ilghar:List>
						</select>
					</td>
				</tr>
			</tbody>
			<tfoot>
				<tr>
					<td colspan="2">
						<input type="submit" id="Submit" value="编辑" />
					</td>
				</tr>
			</tfoot>
		</table>
	</form>
	<div class="Footer"></div>
</div>
<script type="text/javascript">
HandleFake404();
</script>
</body>
</html>