﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<%@ Register TagPrefix="IlgharUC" TagName="Ime" Src="../../ime.dwt.ascx"%>
<%@ Register TagPrefix="IlgharUC" TagName="LanguageMenu" Src="../../language_menu.dwt.ascx"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<ilghar:Get ID="Config" Object="InstanceConfig" Operation="GetBasicSettings()" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>留言列表</title>
<link rel="stylesheet" type="text/css" href="<%=CommonPath%>jquery/themes/lightness/all.css" />
<ilghar:Comment><link rel="stylesheet" type="text/css" href="../../S01/CHS/css/common.css" /></ilghar:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<ilgharUC:Ime Ime="false" Eot="true" runat="server" />
<style type="text/css">
.Title .Middle{text-align:right;padding-right:10px}
TABLE .Left DIV{text-align:left}
.Subject{float:left;font-weight:bold}
.Time{float:right}
.Reply{color:#900}
</style>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 是否审核
	string isChecked = Request.QueryString["IsChecked"];
	if (isChecked == null && Request.Cookies["IsChecked"] != null)
		isChecked = Request.Cookies["IsChecked"].Value;

	if (isChecked == null)
		condition.Append(and + Alias.GuestBook.IsChecked + "=true");
	else if (isChecked != String.Empty && isChecked != "*")
		condition.Append(and + Alias.GuestBook.IsChecked + "=" + isChecked);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 类别
	string categoryID = Request.QueryString["CategoryID"];
	if (!String.IsNullOrEmpty(categoryID))
	{
		if (categoryID == "0")
			condition.Append(and + Alias.GuestBook.CategoryID + " IS NULL");
		else
			condition.Append(and + Alias.GuestBook.CategoryID + "=" + categoryID);
	}
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		switch (Request.QueryString["KeywordType"])
		{
			case "Subject":
				condition.Append(and + Alias.GuestBook.Subject + " LIKE '%" + keyword + "%'");
				break;
			case "Content":
				condition.Append(and + Alias.GuestBook.Content + " LIKE '%" + keyword + "%'");
				break;
			case "Name":
				condition.Append(and + Alias.GuestBook.Name + " LIKE '%" + keyword + "%'");
				break;
		}
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.GuestBook.CreateTime + " DESC";
			break;
		case "2":
			sort = Alias.GuestBook.CreateTime + " ASC";
			break;
		default:
			sort = Alias.GuestBook.CreateTime + " DESC";
			break;
	}
	
	return sort;
}
</script>
<script type="text/javascript">
var _page = "guestbook_list";
var _lang = "<%=ContentLang%>";
var _webPath = "<%=WebPath%>";
var _imagePath = "<%=ImagePath%>";
var _lang_working = "正在操作...";
var _lang_operation_fail = "操作失败！";
var _lang_operation_success = "操作成功！";
var _lang_confirm_delete = "要删除此项吗？";
var _lang_no_selection = "没有选择任何对象！";
var _lang_check = "审核";
var _lang_uncheck = "取消审核";
var _lang_selection_empty = "没有选择任何对象！";
</script>
</head>
<body>
<div class="WhiteHeader">
	<div class="Left"><img src="<%=ImagePath%>close_frame.gif" /></div>
	<div class="Title">留言列表</div>
	<div class="Right">
		<ilgharUC:LanguageMenu runat="server" />
		<img height="15" src="<%=ImagePath%>dropdown.gif" /> 语言：<%=CurrentLanguage%>
	</div>
</div>
<div class="Block">
	<div class="ToolBar">
		<select id="IsChecked">
			<option value="*">是否审核</option>
			<%If Request.Cookies["IsChecked"] != null && Request.Cookies["IsChecked"].Value == "false"%>
				<option value="false" selected="selected">未审核</option>
				<option value="true">已审核</option>
			<%Else%>
				<option value="false">未审核</option>
				<option value="true" selected="selected">已审核</option>
			<%EndIf%>
		</select>
		<select id="CategoryID" class="<%=ContentLang%>Font">
			<option value="">所有类别</option>
			<option value="0">未指定类别</option>
			<ilghar:Tree Object="Category">
				<ilghar:Control>
					<ilghar:Space>&nbsp;&nbsp;</ilghar:Space>
					<ilghar:Line>│</ilghar:Line>
					<ilghar:TopOpen>┌</ilghar:TopOpen>
					<ilghar:Top>┌</ilghar:Top>
					<ilghar:MiddleOpen>├</ilghar:MiddleOpen>
					<ilghar:Middle>├</ilghar:Middle>
					<ilghar:BottomOpen>└</ilghar:BottomOpen>
					<ilghar:Bottom>└</ilghar:Bottom>
				</ilghar:Control>
				<ilghar:Record>
					<option value="<%=ID%>"><%=Control%><%=Name%></option>
					<%=ChildRecords%>
				</ilghar:Record>
			</ilghar:Tree>
		</select>
		<select id="Sort">
			<option value="1">日期↓</option>
			<option value="2">日期↑</option>
		</select>
		<input id="Keyword" class="Text <%=ContentLang%>Font" />
		<select id="KeywordType">
			<option value="Subject">主题</option>
			<option value="Content">内容</option>
			<option value="Name">留言人</option>
		</select>
		<input type="button" id="Search" value="搜索" class="Button" />
		<input type="button" id="SelectAll" value="全选" class="Button" />
		<input type="button" id="ReverseSelect" value="反选" class="Button" />
		<input type="button" id="Delete" value="删除" class="Button" />
		<span id="ExtraButton"></span>
	</div>
</div>
<div id="RecordList" class="Block">
	<ilghar:List ID="List" Object="GuestBook" Page="PageNumber" PageSize="5" Condition="Condition()" Sort="Sort()" Validate="True">
		<ilghar:Record>
			<div id="Record<%=InnerID%>">
				<ul class="Title">
					<li class="Left"></li>
					<li class="Middle"><a href="edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>">编辑</a><input type="checkbox" name="Sel" value="<%=InnerID%>" /></li>
					<li class="Right"></li>
				</ul>
				<table align="center" cellpadding="4" cellspacing="1">
					<tr>
						<td rowspan="3" class="Left">
							<img src="<%=Head%>" /><br />
							<span class="<%=ContentLang%>Font"><%=Name%></span>
							<div>
								<strong>QQ：</strong><%=QQ%><br />
								<strong>Email：</strong><%=Email%><br />
								<strong>主页：</strong><%=HomePage%><br />
								<strong>IP：</strong><%=IP%><br />
								<strong>是否保密：</strong>
									<%If Convert.ToBoolean(Private)%>
										是
									<%Else%>
										否
									<%EndIf%>
							</div>
						</td>
						<td>
							<span class="Subject <%=ContentLang%>Font"><a href="../../GuestBook/guest_book/edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>"><%=HttpUtility.HtmlEncode(Convert.ToString(Subject))%></a></span>
							<span class="Time">发布于：<%=CreateTime%></span>
						</td>
					</tr>
					<tr>
						<td class="<%=ContentLang%>Font">
							<%If Convert.ToBoolean(Config[EnableHtmlEditor])%>
								<%=Content%>
							<%Else%>
								<%=HttpUtility.HtmlEncode(Convert.ToString(Content))%>
							<%EndIf%>
						</td>
					</tr>
					<tr>
						<td class="Reply <%=ContentLang%>Font">
							<%=Reply%>
						</td>
					</tr>
				</table>
			</div>
		</ilghar:Record>
	</ilghar:List>
	<ilghar:Pagination Page="PageNumber" PageSize="5" RecordCount="List[RecordCount]">
		<div class="Pagination">
			<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
			<div class="Right">
				<ilghar:FirstPage>
					<ilghar:Yes>
						<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
						<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
					</ilghar:Yes>
					<ilghar:No>
						<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
						<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
					</ilghar:No>
				</ilghar:FirstPage>
				<ilghar:CurrentPage Range="5">
					<ilghar:Yes>
						<span class="Current"><%=Index%></span>						
					</ilghar:Yes>
					<ilghar:No>
						<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
					</ilghar:No>
				</ilghar:CurrentPage>
				<ilghar:LastPage>
					<ilghar:Yes>
						<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
						<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
					</ilghar:Yes>
					<ilghar:No>
						<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
						<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
					</ilghar:No>
				</ilghar:LastPage>
			</div>
		</div>
	</ilghar:Pagination>
</div>
<script type="text/javascript" src="<%=CommonPath%>jquery/core.js"></script>
<script type="text/javascript" src="<%=CommonPath%>jquery/ui.js"></script>
<script type="text/javascript" src="<%=CommonPath%>utility.js"></script>
<script type="text/javascript" src="<%=JsPath%>global.js"></script>
<script type="text/javascript" src="<%=JsPath%>guestbook.js"></script>
</body>
</html>