﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.AdminPageBase" %>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder();
	string and = String.Empty;

	#region 是否回收
	string isRecycled = Request.QueryString["IsRecycled"];
	if (isRecycled == null)
		condition.Append(Alias.Position.IsDeleted + "=false");
	else if (isRecycled != String.Empty)
		condition.Append(Alias.Position.IsDeleted + "=" + isRecycled);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 是否审核
	string isAvailable = Request.QueryString["IsAvailable"];
	if (!String.IsNullOrEmpty(isAvailable))
		condition.Append(and + Alias.Position.IsAvailable + "=" + isAvailable);
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 类型
	string typeID = Request.QueryString["TypeID"];
	if (!String.IsNullOrEmpty(typeID))
	{
		condition.Append(and + Alias.Position.TypeID + "=" + typeID);
	}
	#endregion

	if (and == String.Empty && condition.Length != 0)
		and = " AND ";

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Name")
			condition.Append(and + Alias.Position.Name + " LIKE '%" + keyword + "%'");
		else if (Request.QueryString["KeywordType"] == "Guid")
			condition.Append(and + Alias.Position.ID + "=" + keyword);
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Position.InnerID + " DESC";
			break;
		case "2":
			sort = Alias.Position.InnerID + " ASC";
			break;
		default:
			sort = Alias.Position.InnerID + " DESC";
			break;
	}
	
	return sort;
}
</script>
<table border="0" cellpadding="4" cellspacing="1" class="ListTable">
	<thead>
		<tr>
			<th width="40">选择</th>
			<th width="40">编号</th>
			<th width="200">示意图</th>
			<th>名称</th>
			<th width="60">广告列表</th>
			<th width="60">添加广告</th>
		</tr>
	</thead>
	<tbody>
		<ilghar:List ID="List" Object="Position" Page="PageNumber" PageSize="20" Condition="Condition()" Sort="Sort()" Validate="True">
			<ilghar:Record>
				<tr id="Row<%=InnerID%>">
					<td><input type="checkbox" name="Sel" value="<%=InnerID%>" /></td>
					<td><%=InnerID%></td>
					<td>
						<%If !String.Equals(SketchMap, String.Empty)%>
							<a href="<%=SketchMap%>" target="_blank"><img src="<%=SketchMap%>" class="Thumbnail" /></a>
						<%EndIf%>
					</td>
					<td class="<%=ContentLang%>Font"><a href="edit.aspx?Lang=<%=ContentLang%>&amp;ID=<%=InnerID%>"><%=Name%></a></td>
					<td><a href="../ad/list.aspx?Lang=<%=ContentLang%>&amp;PositionID=<%=InnerID%>">广告列表</a></td>
					<td><a href="../ad/add.aspx?Lang=<%=ContentLang%>&amp;PositionID=<%=InnerID%>">添加广告</a></td>
				</tr>
			</ilghar:Record>
		</ilghar:List>
	</tbody>
</table>
<ilghar:Pagination Page="PageNumber" PageSize="20" RecordCount="List[RecordCount]">
	<div class="Pagination">
		<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
		<div class="Right">
			<ilghar:FirstPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:FirstPage>
			<ilghar:CurrentPage Range="5">
				<ilghar:Yes>
					<span class="Current"><%=Index%></span>						
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
				</ilghar:No>
			</ilghar:CurrentPage>
			<ilghar:LastPage>
				<ilghar:Yes>
					<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
					<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
				</ilghar:Yes>
				<ilghar:No>
					<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
					<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
				</ilghar:No>
			</ilghar:LastPage>
		</div>
	</div>
</ilghar:Pagination>