﻿function ShowAndHide(id)
{
	var rows = document.getElementsByTagName("TR");
	for (var i = 0; i < rows.length; i++)
	{
		if (rows[i].ParentID != id)
			continue;
	
		var show = false;
		if (arguments.length == 2)
		{
			show = false;
		}
		else
		{
			if(rows[i].style.display == 'none')
				show = true;
			else
				show = false;
		}
		
		var img = document.getElementById("SH" + id);
		
		if(show)
		{
			rows[i].style.display = '';
			img.src = img.src.replace("close","open");
		}
		else
		{
			rows[i].style.display = 'none';
			img.src = img.src.replace("open","close");
			
			ShowAndHide(rows[i].ItemID, false);
		}
	}
}

function ShowAll()
{
	var rows = document.getElementsByTagName("TR");
	for (var i = 0; i < rows.length; i++)
	{
		if (rows[i].ParentID != "")
			rows[i].style.display = '';
			
		var img = document.getElementById("SH" + rows[i].ItemID);
		if (img != null)
			img.src = img.src.replace("close","open");
	}
}

function CloseAll()
{
	var rows = document.getElementsByTagName("TR");
	for (var i = 0; i < rows.length; i++)
	{
		if (rows[i].ParentID == undefined)
			continue;
			
		if (rows[i].ParentID != "")
			rows[i].style.display = 'none';
			
		var img = document.getElementById("SH" + rows[i].ItemID);
		if (img != null)
			img.src = img.src.replace("open","close");
	}
}

function MakeTreeControl(id, imagePath)
{
	var result = "";

	var rows = document.getElementsByTagName("TR");
	var row = eval("document.getElementById('Row" + id + "')");
	var control = eval("document.getElementById('Control" + id + "')");
	var whitespace = "\r\n\t\t\t";
	var space = whitespace + "<span style=\"margin-left:20px\"></span>" + whitespace;
	var middleOpen = whitespace + "<img id=\"SH" + id + "\" onclick=\"ShowAndHide('" + id + "')\" src=\"" + imagePath + "tree/middle_open.gif\" class=\"ShowHide\" />" + whitespace;
	var middle = whitespace + "<img src=\"" + imagePath + "tree/middle.gif\" />" + whitespace;
	var bottomOpen = whitespace + "<img id=\"SH" + id + "\" onclick=\"ShowAndHide('" + id + "')\" src=\"" + imagePath + "tree/bottom_open.gif\" class=\"ShowHide\" />" + whitespace;
	var bottom = whitespace + "<img src=\"" + imagePath + "tree/bottom.gif\" />" + whitespace;
	var topOpen = whitespace + "<img id=\"SH" + id + "\" onclick=\"ShowAndHide('" + id + "')\" src=\"" + imagePath + "tree/top_open.gif\" class=\"ShowHide\" />" + whitespace;
	var top = whitespace + "<img src=\"" + imagePath + "tree/top.gif\" />" + whitespace;
	var line = whitespace + "<img src=\"" + imagePath + "tree/line.gif\" />" + whitespace;
	
	var HasNext = function()
	{
		var treeItem = row;
		if (arguments.length == 1)
			treeItem = arguments[0];
			
		var over = false;
		for (var i = 0; i < rows.length; i++)
		{
			if (rows[i].ItemID == treeItem.ItemID)
			{
				over = true;
				continue;
			}
			
			if (!over)
				continue;
		
			if (rows[i].ParentID == treeItem.ParentID)
				return true;
		}
		
		return false;
	}
	
	var HasPrevious = function()
	{
		var treeItem = row;
		for (var i = 0; i < rows.length; i++)
		{
			if (rows[i].ItemID == treeItem.ItemID)
				return false;
		
			if (rows[i].ParentID == treeItem.ParentID)
				return true;
		}
		
		return false;
	}
	
	var HasChild = function()
	{
		var treeItem = row;
		for (var i = 0; i < rows.length; i++)
		{
			if (rows[i].ParentID == treeItem.ItemID)
				return true;
		}
		
		return false;
	}
	
	var GetParent = function(treeItem)
	{
		if (treeItem.ParentID == "")
			return null;
	
		for (var i = 0; i < rows.length; i++)
		{
			if (rows[i].ItemID == treeItem.ParentID)
				return rows[i];
		}
		return null;
	}
	
	if (row.ParentID != "")
	{
		result = space;
		if (HasNext())
		{
			if (HasChild())
			{
				if (control.innerHTML.indexOf("_open") != -1)
					result += middleOpen;
				else
					result += middleOpen.replace("_open", "_close");
			}
			else
			{
				result += middle;
			}
		}
		else
		{
			if (HasChild())
			{
				if (control.innerHTML.indexOf("_open") != -1)
					result += bottomOpen;
				else
					result += bottomOpen.replace("_open", "_close");
			}
			else
			{
				result += bottom;
			}
		}
	}
	else
	{
		if (HasNext())
		{
			if (HasPrevious())
			{
				if (HasChild())
				{
					if (control.innerHTML.indexOf("_open") != -1)
						result = middleOpen;
					else
						result = middleOpen.replace("_open", "_close");
				}
				else
				{
					result = middle;
				}
			}
			else
			{
				if (HasChild())
				{
					if (control.innerHTML.indexOf("_open") != -1)
						result = topOpen;
					else
						result = topOpen.replace("_open", "_close");
				}
				else
				{
					result = top;
				}
			}
		}
		else
		{
			if (HasPrevious())
			{
				if (HasChild())
				{
					if (control.innerHTML.indexOf("_open") != -1)
						result = bottomOpen;
					else
						result = bottomOpen.replace("_open", "_close");
				}
				else
				{
					result = bottom;
				}
			}
			else
			{
				if (HasChild())
				{
					if (control.innerHTML.indexOf("_open") != -1)
						result = topOpen;
					else
						result = topOpen.replace("_open", "_close");
				}
				else
				{
					result = top;
				}
			}
		}
	}
	
	var parent = GetParent(row);
	var grand = null;
	while (parent != null)
	{
		grand = GetParent(parent);
		if (grand != null)
		{
			if (HasNext(parent))
				result = space + line + result;
			else
				result = space + space + result;
		}
		else
		{
			if (HasNext(parent))
				result = line + result;
		}
		
		parent = grand;
	}
	
	return result;
}

function ClientDelete(id)
{
	//删除所有属于他的
	var rows = document.getElementsByTagName("TR");
	for (var i = 0; i < rows.length; i++)
	{
		if (rows[i].ParentID == id)
			ClientDelete(rows[i].ItemID)
	}
	
	//删除本身
	var row = eval("document.getElementById('Row" + id + "')");
	var table = row.parentElement.parentElement;
	table.deleteRow(row.rowIndex);
}

function IsInherit(child, parent, rows)
{
	if (child.ItemID == parent.ItemID)
		return true;

	while (true)
	{
		if (child.ParentID == "")
			break;
			
		if (child.ParentID == parent.ItemID)
			return true;
	
		for (var i = 0; i < rows.length; i++)
		{
			if (rows[i].ItemID == child.ParentID)
			{
				child = rows[i];
				break;
			}
		}
	}

	return false;
}

function ClientMove(fromID, toID, imagePath, isChild)
{
	//获取信息
	var from = eval("document.getElementById('Row" + fromID + "')");
	var to = eval("document.getElementById('Row" + toID + "')");
	var table = from.parentElement.parentElement;
	var fromIndex = from.rowIndex;
	var toIndex = to.rowIndex;
	
	//判断回路
	if (IsInherit(to, from, table.rows))
	{
		alert("不能移动！");
		return false;
	}
	
	//移动行
	table.moveRow(fromIndex, toIndex);

	//移动所有属于他的
	var childCount = 0;
	var rows = document.getElementsByTagName("TR");
	for (var i = 0; i < rows.length; i++)
	{
		if (rows[i].ParentID == fromID)
		{
			ClientMove(rows[i].ItemID, toID, imagePath, false);
			childCount++;
		}
	}
	
	if (arguments.length == 3)
	{
		//替换父ID
		from.ParentID = to.ParentID;
		
		//替换树控制
		//var start = Math.min(fromIndex, toIndex);
		//var end = Math.max(fromIndex, toIndex);
		for (var i = 0; i <= rows.length; i++)
		{
			var row = table.rows[i];
			var control = eval("document.getElementById('Control" + rows[i].ItemID + "')");
			if (control == null)
				break;
			control.innerHTML = MakeTreeControl(row.ItemID, imagePath);
		}
	}
	
	return true;
}