﻿function BuildHeader()
{
	if (_page == "article_list")
		return BuildAjaxPath(true) + "?IsRecycled=" + $("#IsRecycled").val() + "&IsChecked=" + $("#IsChecked").val() + "&IsRecommended=" + $("#IsRecommended").val() + "&IsHeld=" + $("#IsHeld").val() + "&CategoryID=" + $("#CategoryID").val() + "&IncludeSubCategory=" + $("#IncludeSubCategory")[0].checked + "&Type=" + $("#Type").val() + "&Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "file_list")
		return BuildAjaxPath(true) + "?Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
	else if (_page == "tag_select")
		return BuildAjaxPath(true) + "?Sort=" + $("#Sort").val() + "&Keyword=" + encodeURIComponent($("#Keyword").val()) + "&KeywordType=" + $("#KeywordType").val() + "&Page=" + _pageNumber;
}	

function Search()
{
	if (arguments.length > 0 && typeof(arguments[0]) != "object")
		_pageNumber = arguments[0];
	
	SetStatusMessage(_lang_working);
	$.ajax(
	{
		url : BuildHeader(),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			$("#List").html(HandleFake404(data, "text"));
			Init();
			SetStatusMessage();
		}
	});
}

function MakeButton()
{
	var buttons = "";

	if (_page == "article_list")
	{
	    if ($("#IsRecycled")[0].selectedIndex == 1)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateArticle('Recycle')\" >" + _lang_recycle + "</button>";
	    }
	    else if ($("#IsRecycled")[0].selectedIndex == 2)
	    {
		    buttons += "<button class=\"Button\" onclick=\"UpdateArticle('Delete')\" >" + _lang_delete + "</button>";
		    buttons += "<button class=\"Button\" onclick=\"UpdateArticle('Recover')\" >" + _lang_recover + "</button>";
	    }
	}
		
	$("#ExtraButton").html(buttons);
}

function ShowSelectDialog(type)
{
	var path;
	if (type == "Tag")
		path = "../tag/select.aspx";
	else if (type == "File")
		path = "../file/select.aspx";

	path = HandleFake404(path, "url");
	if ($.browser.msie)
		window.showModalDialog(path, window, "status=0;dialogWidth=500px;dialogHeight=500px;center=1;help=0;resizable=1;scroll=1");
	else
		window.open(path,null,"width=500,height=500,dialog=yes,modal=yes,maximize=no,menubar=no,toolbar=no,location=no,scrollbars=yes,status=no");
}

function SelectTag(tag, checked)
{
	var tags = $("[name=Tag]");
	for (var i = 0; i < tags.length; i++)
	{
		if (tags[i].id == tag.ID)
		{
			tags[i].checked = checked;
			return;
		}
	}
	
	var tagContainer = $("#TagDiv");
	var br = "";
	if (tags.length > 0 && tags.length % 5 == 0) br = "<br />";
	tagContainer.html(tagContainer.html() + br + "<input type='checkbox' checked='checked' name='Tag' id='" + tag.ID + "' tagName='" + tag.Name + "' tagPageGenerate='" + tag.PageGenerate + "' tagPageTemplate='" + tag.PageTemplate + "'' tagPageID='" + tag.PageID + "'' tagPageExtension='" + tag.PageExtension + "' /><label for='" + tag.ID + "'>" + tag.Name + "</label>");	
}

function SelectFile(type, path)
{
	switch (type)
	{
		case "File":
            $("#FileTextBox").val(path);
			break;
	}	
}

function PrepareTag()
{
    var result = {Names:"",PageIDs:"",PageGenerates:"",PageTemplates:"",PageExtensions:""};	
    var tags = $("[name=Tag]");
	
	if (typeof(_tagIndex) != "undefined")
	{
	    _tagIndex = 0;
	}
	else
	{
	    _tagAddIndex = 0;
	    _tagDeleteIndex = 0;
	    _tagAddList.length = 0;
	    _tagDeleteList.length = 0;
    	    	
	    tags.each(function()
	    {
		    if (this.checked)
		    {
			    var j = 0;
			    for (; j < _tags.length; j++)
			    {
				    if (this.id == _tags[j] || this.id == _tags[j].ID)
					    break;
			    }
			    if (j >= _tags.length)
				    _tagAddList[_tagAddList.length] = this.id;
		    }
		    else
		    {
			    for (var j = 0; j < _tags.length; j++)
			    {
				    if (this.id == _tags[j] || this.id == _tags[j].ID)
				    {
					    _tagDeleteList[_tagDeleteList.length] = this.id;
					    break;
				    }
			    }
		    }
	    });
	}

	_tags.length = 0;
	tags.each(function()
	{
		if (!this.checked)
		    return false;

		_tags[_tags.length] = this.id;

		if (result.Names == "")
			result.Names = "|";
		result.Names += this.value + "|";
		
		if (result.PageGenerates == "")
			result.PageGenerates = "|";
		result.PageGenerates += $(this).attr("PageGenerate") + "|";
		
		if (result.PageTemplates == "")
			result.PageTemplates = "|";
		result.PageTemplates += $(this).attr("PageTemplate") + "|";
		
		if (result.PageIDs == "")
			result.PageIDs = "|";
		result.PageIDs += $(this).attr("PageID") + "|";
		
		if (result.PageExtensions == "")
			result.PageExtensions = "|";
		result.PageExtensions += $(this).attr("PageExtension") + "|";
	});
	
	return result;
}

//-------------------------------------------------
//Start : 文章管理
function AddArticle()
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return false;
    }

	if (this.Title.value == "")
	{
		Alert(_lang_title_empty, function(){this.Title.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Thumbnail.value, this.ThumbnailAllowedType.value))
	{
		Alert(_lang_thumbnail_type_must_be + form.ThumbnailAllowedType.value, function(){this.Thumbnail.select();}, this);
		return false;
	}
	
	if (this.Introduction.value.length > 250)
	{
		Alert(_lang_introduction_incorrect, function(){this.Description.select();}, this);
		return false;
	}
	
	var tag = PrepareTag();

	var category = $("[name=CategoryID] option:selected");
	
	var data = "IsChecked=false&Title=" + encodeURIComponent(this.Title.value);
	data += "&CategoryID=" + this.CategoryID.value;
	data += "&CategoryName=" + category.attr("Name");
	data += "&CategoryPageGenerate=" + category.attr("PageGenerate");
	data += "&CategoryPageTemplate=" + category.attr("PageTemplate");
	data += "&CategoryPageID=" + category.attr("PageID");
	data += "&CategoryPageExtension=" + category.attr("PageExtension");
	data += "&FromLabel=" + encodeURIComponent(this.FromLabel.value);
	data += "&FromLink=" + encodeURIComponent(this.FromLink.value);
	data += "&Type=" + this.Type.value;
	data += "&TagNames=" + encodeURIComponent(tag.Names);
	data += "&TagPageGenerates=" + encodeURIComponent(tag.PageGenerates);
	data += "&TagPageTemplates=" + encodeURIComponent(tag.PageTemplates);
	data += "&TagPageIDs=" + encodeURIComponent(tag.PageIDs);
	data += "&TagPageExtensions=" + encodeURIComponent(tag.PageExtensions);
	data += "&Introduction=" + encodeURIComponent(this.Introduction.value);
	var editor = FCKeditorAPI.GetInstance("HtmlEditor");
	if (editor.IsDirty())
		data += "&Content=" + encodeURIComponent(editor.GetXHTML(false));
	_uploadThumbnail = _uploader.NeedUpload("Thumbnail");
	if (!_uploadThumbnail)
		data += "&Thumbnail=" + encodeURIComponent(this.Thumbnail.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Article&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			_guid = data;
		    AddArticle_GetInnerID();
		}
	});
	
	return false;	
}

function AddArticle_GetInnerID()
{
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Article&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
            _id = data;
			AddArticle_SetPageID();
		}
	});
}

function AddArticle_SetPageID()
{
    SetStatusMessage(_lang_setting_pageid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Article&Operation=Modify&ID=" + _id,
		data : "PageID=" + encodeURIComponent(_id),
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
    		AddArticle_AddTag();
		}
	});
}

function AddArticle_AddTag()
{
	if (_tagIndex >= _tags.length)
	{
		Article_UploadThumbnail();
		return;
	}
	
	var data = "ArticleID=" + _guid;
	data += "&TagID=" + _tags[_tagIndex];
	
	_tagIndex++;

    SetStatusMessage(_lang_adding_tag);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Article.Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			AddArticle_AddTag();
		}
	});
}

function EditArticle()
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return false;
    }

	if (this.Title.value == "")
	{
		Alert(_lang_title_empty, function(){this.Title.select();}, this);
		return false;
	}
	
	if (!IsAllowedType(this.Thumbnail.value, this.ThumbnailAllowedType.value))
	{
		Alert(_lang_thumbnail_type_must_be + form.ThumbnailAllowedType.value, function(){this.Thumbnail.select();}, this);
		return false;
	}
	
	var tag = PrepareTag();
	
	var category = $("[name=CategoryID] option:selected");

	var data = "IsChecked=false&Title=" + encodeURIComponent(this.Title.value);
	data += "&CategoryID=" + this.CategoryID.value;
	data += "&CategoryName=" + category.attr("Name");
	data += "&CategoryPageGenerate=" + category.attr("PageGenerate");
	data += "&CategoryPageTemplate=" + category.attr("PageTemplate");
	data += "&CategoryPageID=" + category.attr("PageID");
	data += "&CategoryPageExtension=" + category.attr("PageExtension");
	data += "&FromLabel=" + encodeURIComponent(this.FromLabel.value);
	data += "&FromLink=" + encodeURIComponent(this.FromLink.value);
	data += "&Type=" + this.Type.value;
	data += "&TagNames=" + encodeURIComponent(tag.Names);
	data += "&TagPageGenerates=" + encodeURIComponent(tag.PageGenerates);
	data += "&TagPageTemplates=" + encodeURIComponent(tag.PageTemplates);
	data += "&TagPageIDs=" + encodeURIComponent(tag.PageIDs);
	data += "&TagPageExtensions=" + encodeURIComponent(tag.PageExtensions);
	data += "&Introduction=" + encodeURIComponent(this.Introduction.value);
	var editor = FCKeditorAPI.GetInstance("HtmlEditor");
	if (editor.IsDirty())
		data += "&Content=" + encodeURIComponent(editor.GetXHTML(false));
	_uploadThumbnail = _uploader.NeedUpload("Thumbnail");
	if (!_uploadThumbnail)
		data += "&Thumbnail=" + encodeURIComponent(this.Thumbnail.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Article&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditArticle_DeleteTag();
		}
	});
	
	return false;	
}

function EditArticle_DeleteTag()
{
	if (_tagDeleteIndex >= _tagDeleteList.length)
	{
		EditArticle_AddTag();
		return;
	}

	SetStatusMessage(_lang_modifying_tag);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Article.Tag&Operation=Delete&ArticleID=" + _guid + "&TagID=" + _tagDeleteList[_tagDeleteIndex++],
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditArticle_DeleteTag();
		}
	});
}

function EditArticle_AddTag()
{
	if (_tagAddIndex >= _tagAddList.length)
	{
        Article_UploadThumbnail();
		return;
	}
	
	var data = "ArticleID=" + _guid;
	data += "&TagID=" + _tagAddList[_tagAddIndex];
	
	_tagAddIndex++;

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=Article.Tag&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			EditArticle_AddTag();
		}
	});
}

function Article_UploadThumbnail()
{
    if (!_uploadThumbnail)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
        return;
    }

    SetStatusMessage(_lang_start_upload_thumbnail);
    _uploader.Init({Status:_lang_uploading_thumbnail,Params:"Object=Article&Operation=UploadThumbnail&ID=" + _id + "&AddWaterMark=" + $("#AddWaterMark")[0].checked});
    _uploader.Upload("Thumbnail", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function UpdateArticle(action, id)
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return;
    }

	if (id == null)
	{
		id = "";
		$("[name=Sel]:checked").each(function(){id += id == "" ? this.value : "|" + this.value;});
		if(id == "")
		{
			Alert(_lang_selection_empty);
			return;
		}
		
		if(action == "Delete")
			Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)UpdateArticle(action, id);}, this);
		else
			UpdateArticle(action, id);
	}
	else
	{
		SetStatusMessage(_lang_working);

		$.ajax(
		{
			url : _webPath + "ilghar.aspx?Object=Article&Operation=" + action + "&ID=" + id + "&Transfer=" + encodeURIComponent(BuildHeader()),
			data : {},
			type : "POST",
			error : function(request)
			{
				Alert(_lang_operation_fail);
				SetStatusMessage();
			},
			success : function(data)
			{
				Alert(_lang_operation_success);
				SetStatusMessage();

				$("#List").html(HandleFake404(data, "text"));
				Init();
			}
		});
	}
}

function SubTitleButton_OnClick()
{
	var editor = FCKeditorAPI.GetInstance("HtmlEditor") ;

	if (editor.EditMode == FCK_EDITMODE_WYSIWYG)
		editor.InsertHtml("[title]" + $("#SubTitle").val() + "[/title]");
}

function FileButton_OnClick()
{
	var editor = FCKeditorAPI.GetInstance("HtmlEditor") ;

	if (editor.EditMode == FCK_EDITMODE_WYSIWYG)
	{
	    if ($("#PlayerID")[0].selectedIndex > 0)
	    {
	        player = $("#PlayerID").val();
	        if (player != "")
	            player = "=" + player;
    		editor.InsertHtml("[player" + player + "]" + $("#FileTextBox").val() + "[/player]");
	    }
        else
        {
		    editor.InsertHtml($("#FileTextBox").val());
		}
	}
}
//End : 文章管理
//-------------------------------------------------

//-------------------------------------------------
//Start : 文件管理
function AddFile()
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return false;
    }

	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}
	
	var data = "Name=" + encodeURIComponent(this.Name.value);
	var uploadFile = _uploader.NeedUpload("File");
	if (!uploadFile)
		data += "&URL=" + encodeURIComponent(this.URL.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=File&Operation=Add",
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
			_guid = data;
		    AddFile_GetInnerID();
		}
	});
	
	return false;
}

function AddFile_GetInnerID()
{
    if (!uploadFile)
    {
		File_Upload();
        return;
    }
    
    SetStatusMessage(_lang_getting_innerid);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=File&Operation=GetInnerIDFromGuid&ID=" + _guid,
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
            _id = data;
			File_Upload();
		}
	});
}

function EditFile()
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return false;
    }

	if (this.Name.value == "")
	{
		Alert(_lang_name_empty, function(){this.Name.select();}, this);
		return false;
	}

	var data = "Name=" + encodeURIComponent(this.Name.value);
	var uploadFile = _uploader.NeedUpload("File");
	if (!uploadFile)
		data += "&URL=" + encodeURIComponent(this.URL.value);

	$(":submit")[0].disabled = true;
	SetStatusMessage(_lang_working);
	
	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=File&Operation=Modify&ID=" + _id,
		data : data,
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
			$(":submit")[0].disabled = false;
		},
		success : function(data)
		{
    		File_Upload();
		}
	});
	
	return false;	
}

function File_Upload()
{
    if (!uploadFile)
    {
		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;

        return;
    }

    SetStatusMessage(_lang_start_upload);
    _uploader.Init({Status:_lang_uploading,Params:"Object=File&Operation=Upload&ID=" + _id});
    _uploader.Upload("File", function()
    {
        if (arguments.length == 2)
            Alert(arguments[1]);
        else
    		Alert(_lang_operation_success);
		SetStatusMessage();
		$(":submit")[0].disabled = false;
    });
}

function DeleteFile(id)
{
    if (_isLocked)
    {
        Alert(_lang_locked);
        return;
    }

	SetStatusMessage(_lang_working);

	$.ajax(
	{
		url : _webPath + "ilghar.aspx?Object=File&Operation=Delete&ID=" + id + "&Transfer=" + encodeURIComponent(BuildAjaxPath()),
		data : {},
		type : "POST",
		error : function(request)
		{
			Alert(_lang_operation_fail);
			SetStatusMessage();
		},
		success : function(data)
		{
			Alert(_lang_operation_success);
			SetStatusMessage();

			$("#List").html(HandleFake404(data, "text"));
			Init();
		}
	});
}
//End : 文件管理
//-------------------------------------------------

function Init()
{
	if (typeof (_page) == "undefined")
		return;
	
	if (_page == "article_add")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Thumbnail", "ThumbnailTextbox", "ThumbnailBrowse");
		
		$("form").eq(0).submit(AddArticle);
		$("#TagSelect").click(function(){ShowSelectDialog("Tag")});
		$("#FileSelect").click(function(){ShowSelectDialog("File")});
		$("#ThumbnailTextbox").change(function(){$("#ThumbnailView").attr("src", this.value)});
		$("#SubTitleButton").click(SubTitleButton_OnClick);
		$("#FileButton").click(FileButton_OnClick);
	}
	else if (_page == "article_edit")
	{		
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("Thumbnail", "ThumbnailTextbox", "ThumbnailBrowse");
		
		CheckAndSelect($("[name=Type]")[0], _type);

        for (var i = 0; i < _tags.length; i++)
        {
	        SelectTag(_tags[i], true)
        }

		$("form").eq(0).submit(EditArticle);
		$("#TagSelect").click(function(){ShowSelectDialog("Tag")});
		$("#FileSelect").click(function(){ShowSelectDialog("File")});
		$("#ThumbnailTextbox").change(function(){$("#ThumbnailView").attr("src", this.value)});
		$("#SubTitleButton").click(SubTitleButton_OnClick);
		$("#FileButton").click(FileButton_OnClick);
	}
	else if (_page == "article_list")
	{
		MakeButton();

		if (arguments.length == 0)
		    return;

		$("#IsRecycled,#IsChecked,#IsRecommended,#IsHeld,#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#SelectAll").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = true;});});
		$("#ReverseSelect").click(function(){$(":checkbox[name=Sel]").each(function(){this.checked = !this.checked;});});
	}
	else if (_page == "tag_select")
	{
		$(":checkbox").click(function()
		{
            if ($.browser.msie)
				window.dialogArguments.SelectTag({ID:$(this).attr("ID"),Name:$(this).attr("Name"),PageGenerate:$(this).attr("PageGenerate"),PageTemplate:$(this).attr("PageTemplate"),PageID:$(this).attr("PageID"),PageExtension:$(this).attr("PageExtension")}, this.checked);
			else
				window.opener.SelectTag({ID:$(this).attr("ID"),Name:$(this).attr("Name"),PageGenerate:$(this).attr("PageGenerate"),PageTemplate:$(this).attr("PageTemplate"),PageID:$(this).attr("PageID"),PageExtension:$(this).attr("PageExtension")}, this.checked);
		});
		
		if (arguments.length == 0)
		    return;

		$("#Sort").keydown(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
		$("#Ok").click(function(){window.close();});
	}
	else if (_page == "file_list")
	{
		$("tr").each(function()
		{
			var id = $(this).attr("id");
			
			$(this).find("a:last").click(function()
			{
				Confirm(_lang_confirm_delete, function(returnValue){if (returnValue)DeleteFile(id);}, this);
				return false;
			});
		});
		
		if (arguments.length == 0)
		    return;

		$("#Sort").change(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
	}
	else if (_page == "file_add")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("File", "FileTextbox", "FileBrowse");
		
		$("form").eq(0).submit(AddFile);
	}
	else if (_page == "file_edit")
	{
		_uploader.Init({WebPath:_webPath});
		_uploader.Add("File", "FileTextbox", "FileBrowse");
		
		$("form").eq(0).submit(EditFile);
	}
	else if (_page == "file_select")
	{
		$("td a").click(function()
		{
	        if ($.browser.msie)
				window.dialogArguments.SelectFile("File", $(this).attr("href"));
			else
				window.opener.SelectFile("File", $(this).attr("href"));
			window.close();
		});
		
		if (arguments.length == 0)
		    return;

		$("#Sort").keydown(Search);
		$("#Keyword").keydown(function(e){if(e.keyCode == 13){Search(1);e.preventDefault();}});
		$("#Search").click(function(){Search(1);});
	}
}
Init(true);