﻿<%@ Page CodeFileBaseClass="IlgharCMS.Lib.MemberPageBase" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<!-- TemplateInfo codeOutsideHTMLIsLocked="true" -->
<base target="_self" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>选择专辑</title>
<link rel="stylesheet" type="text/css" href="<%=CommonPath%>jquery/themes/lightness/all.css" />
<ilghar:Comment><link rel="stylesheet" type="text/css" href="../../S01/CHS/css/common.css" /></ilghar:Comment>
<link rel="stylesheet" href="<%=CssPath%>common.css" />
<style type="text/css">
.Block{width:96%}
</style>
<script language="c#" runat="server">
protected string Condition()
{
	StringBuilder condition = new StringBuilder(Alias.Album.IsDeleted + "=false AND " + Alias.Album.IsChecked + "=true");
	string and = " AND ";

	#region 地区
	string regionID = Request.QueryString["RegionID"];
	if (!String.IsNullOrEmpty(regionID))
	{
		if (Convert.ToBoolean(Request.QueryString["IncludeSubRegion"]))
		{
			condition.Append(and + Alias.Album.IncludeSubRegion + "=" + regionID);
		}
		else
		{
			if (regionID == "0")
				condition.Append(and + Alias.Album.RegionID + " IS NULL");
			else
				condition.Append(and + Alias.Album.RegionID + "=" + regionID);
		}
	}
	#endregion

	#region 语言
	string languageID = Request.QueryString["LanguageID"];
	if (!String.IsNullOrEmpty(languageID))
	{
		if (languageID == "0")
			condition.Append(and + Alias.Album.LanguageID + " IS NULL");
		else
			condition.Append(and + Alias.Album.LanguageID + "=" + languageID);
	}
	#endregion

	#region 关键词
	string keyword = Request.QueryString["Keyword"];
	if (!String.IsNullOrEmpty(keyword))
	{
		if (Request.QueryString["KeywordType"] == "Name")
			condition.Append(and + Alias.Album.Name + " LIKE '%" + keyword + "%'");
	}
	#endregion
	
	return condition.ToString();
}

protected string Sort()
{
	string sort = String.Empty;
	switch (Request.QueryString["Sort"])
	{
		case "1":
			sort = Alias.Album.UpdateTime + " DESC";
			break;
		case "2":
			sort = Alias.Album.UpdateTime + " ASC";
			break;
		case "3":
			sort = Alias.Album.HitCount + " DESC";
			break;
		case "4":
			sort = Alias.Album.HitCount + " ASC";
			break;
		default:
			sort = Alias.Album.UpdateTime + " DESC";
			break;
	}
	
	return sort;
}
</script>
<script type="text/javascript">
var _page = "album_select";
var _webPath = "<%=WebPath%>";
var _imagePath = "<%=ImagePath%>";
var _lang_working = "正在操作...";
var _lang_operation_fail = "操作失败！";
</script>
</head>
<body>
<div class="Block">
	<ul class="Title">
		<li class="Left"></li>
		<li class="Middle">选择专辑</li>
		<li class="Right"></li>
	</ul>
	<div class="ToolBar">
		<select id="RegionID" class="<%=PageLang%>Font">
			<option value="">所有地区</option>
			<option value="0">未指定地区</option>
			<ilghar:Tree Object="Region">
				<ilghar:Control>
					<ilghar:Space>&nbsp;&nbsp;</ilghar:Space>
					<ilghar:Line>│</ilghar:Line>
					<ilghar:TopOpen>┌</ilghar:TopOpen>
					<ilghar:Top>┌</ilghar:Top>
					<ilghar:MiddleOpen>├</ilghar:MiddleOpen>
					<ilghar:Middle>├</ilghar:Middle>
					<ilghar:BottomOpen>└</ilghar:BottomOpen>
					<ilghar:Bottom>└</ilghar:Bottom>
				</ilghar:Control>
				<ilghar:Record>
					<option value="<%=ID%>"><%=Control%><%=Name%></option>
					<%=ChildRecords%>
				</ilghar:Record>
			</ilghar:Tree>
		</select>
		<input type="checkbox" id="IncludeSubRegion" /><label for="IncludeSubRegion">包含子地区</label>
		<select id="LanguageID" class="<%=PageLang%>Font">
			<option value="">所有语言</option>
			<option value="0">未指定语言</option>
			<ilghar:List Object="Language">
				<ilghar:Record>
					<option value="<%=ID%>"><%=Name%></option>
				</ilghar:Record>
			</ilghar:List>
		</select>
	</div>
	<div class="ToolBar">
		<select id="Sort">
			<option value="1">更新日期↓</option>
			<option value="2">更新日期↑</option>
			<option value="3">人气↓</option>
			<option value="4">人气↑</option>
		</select>
		<input id="Keyword" tabindex="1" class="Text <%=PageLang%>Font" />
		<select id="KeywordType">
			<option value="Name">名称</option>
		</select>
		<input type="button" id="Search" value="搜索" class="Button" />
	</div>
	<div id="List">
		<table border="0" cellpadding="4" cellspacing="1">
			<thead>
				<tr><th colspan="4">结果</th></tr>
			</thead>
			<tbody>
				<ilghar:List ID="List" Object="Album" Page="PageNumber" PageSize="24" Condition="Condition()" Sort="Sort()">
					<ilghar:Row MaxCol="4">
						<tr>
							<ilghar:Col MaxRecord="1">
								<ilghar:Record>
									<td><input type="checkbox" ID="<%=ID%>" Name="<%=Name%>" PageGenerate="<%=PageGenerate%>" PageTemplate="<%=PageTemplate%>" PageID="<%=PageID%>" PageExtension="<%=PageExtension%>" /><label for="<%=ID%>" class="<%=PageLang%>Font"><%=Name%></label></td>
								</ilghar:Record>
							</ilghar:Col>
						</tr>
					</ilghar:Row>
				</ilghar:List>
			</tbody>
		</table>
		<ilghar:Pagination Page="PageNumber" PageSize="24" RecordCount="List[RecordCount]">
			<div class="Pagination">
				<div class="Left">共 <%=RecordCount%> 条 当前显示第 <%=PageNumber%> 页 第 <%=RangeLower%>-<%=RangeUpper%> 条 </div>
				<div class="Right">
					<ilghar:FirstPage>
						<ilghar:Yes>
							<img src="<%=ImagePath%>pagination/first_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/previous_page_off.gif"/>
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(1)"><img src="<%=ImagePath%>pagination/first_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageNumber%> - 1)" id="PrevPage"><img src="<%=ImagePath%>pagination/previous_page_on.gif"/></a>
						</ilghar:No>
					</ilghar:FirstPage>
					<ilghar:CurrentPage Range="5">
						<ilghar:Yes>
							<span class="Current"><%=Index%></span>						
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(<%=Index%>)">[<%=Index%>]</a>
						</ilghar:No>
					</ilghar:CurrentPage>
					<ilghar:LastPage>
						<ilghar:Yes>
							<img src="<%=ImagePath%>pagination/next_page_off.gif"/>
							<img src="<%=ImagePath%>pagination/last_page_off.gif"/>
						</ilghar:Yes>
						<ilghar:No>
							<a href="javascript:Go(<%=PageNumber%> + 1)" id="NextPage"><img src="<%=ImagePath%>pagination/next_page_on.gif"/></a>
							<a href="javascript:Go(<%=PageCount%>)"><img src="<%=ImagePath%>pagination/last_page_on.gif"/></a>
						</ilghar:No>
					</ilghar:LastPage>
				</div>
			</div>
		</ilghar:Pagination>
	</div>
</div>
<button id="Ok">确 定</button>
<script type="text/javascript" src="<%=CommonPath%>jquery/core.js"></script>
<script type="text/javascript" src="<%=CommonPath%>jquery/ui.js"></script>
<script type="text/javascript" src="<%=CommonPath%>utility.js"></script>
<%If PageLang == "UYG" || PageLang == "KZA" || PageLang == "KGA"%>
	<script type="text/javascript" src="<%=CommonPath%>IlgharIme.js"></script>
<%EndIf%>
<script type="text/javascript" src="<%=JsPath%>common.js"></script>
<script type="text/javascript" src="<%=JsPath%>video.js"></script>
</body>
</html>